/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferFacade;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferPrice;
import com.kingdee.eas.scm.im.inv.InnerCostRuleEnum;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferFacadeFactory;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Info;
import com.kingdee.eas.scm.im.inv.TransferRule3Info;
import com.kingdee.eas.scm.im.inv.TransferRule4Info;
import com.kingdee.eas.scm.im.inv.TransferRuleInfo;
import com.kingdee.eas.scm.im.inv.app.BuildPriceByBalanceCost;
import com.kingdee.eas.scm.im.inv.app.BuildPriceByPricePolicy;
import com.kingdee.eas.scm.im.inv.app.BuildPriceByPricePolicyExtend;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.MultiSidesPriceBizDataVO;
import com.kingdee.eas.scm.im.inv.app.MultiSidesPriceDataLoader;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractBuildPrice
implements IMultiSidesTransferPrice {
    protected MultiSidesPriceBizDataVO dataVO;
    protected Context ctx;
    protected static Map mapParamValue = new HashMap();
    protected static Map mapTaxRateValue = new HashMap();

    public AbstractBuildPrice(Context ctx, MultiSidesPriceBizDataVO dataVO) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.dataVO = dataVO;
    }

    @Override
    public PriceInfo getPrice(PriceParamInfo paramInfo) throws BOSException, EASBizException {
        if (paramInfo == null || paramInfo.getSupplyRelation() == null || paramInfo.getBizTypeInfo() == null) {
            return null;
        }
        if (this.getTransferRuleInfo(paramInfo.getSupplyRelation().getId().toString(), paramInfo.getBizTypeInfo().getId().toString()) == null) {
            return null;
        }
        return this._getPrice(paramInfo);
    }

    public abstract PriceInfo _getPrice(PriceParamInfo var1) throws BOSException, EASBizException;

    public static List getBuildPriceInstances(Context ctx, PriceParamInfo[] paramInfos) throws EASBizException, BOSException {
        ArrayList<AbstractBuildPrice> list = new ArrayList<AbstractBuildPrice>();
        MultiSidesPriceBizDataVO dataVO = new MultiSidesPriceDataLoader(ctx, paramInfos).loadDataVO();
        list.add(0, new BuildPriceByBalanceCost(ctx, dataVO));
        list.add(1, new BuildPriceByPricePolicy(ctx, dataVO));
        list.add(2, new BuildPriceByPricePolicyExtend(ctx, dataVO));
        return list;
    }

    protected boolean getIsCostAdd(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        TransferRule4Info tri;
        if (priceParamInfo.getSupplyRelation() == null) {
            return false;
        }
        boolean isCostAdd = false;
        String bizTypeId = priceParamInfo.getBizTypeInfo().getId().toString();
        String supplyRelationId = priceParamInfo.getSupplyRelation().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            TransferRule2Info tri2 = (TransferRule2Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (tri2 != null && UseStatusEnum.ACTIVE == tri2.getStatus()) {
                isCostAdd = tri2.isIssueIsCostBalance();
            }
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            TransferRule3Info tri3 = (TransferRule3Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (tri3 != null && UseStatusEnum.ACTIVE == tri3.getStatus()) {
                if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                    isCostAdd = tri3.isIssueIsCostBalance();
                } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                    isCostAdd = tri3.isSupplyIsCostBalance();
                }
            }
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) && (tri = (TransferRule4Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId)) != null && UseStatusEnum.ACTIVE == tri.getStatus()) {
            if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                isCostAdd = tri.isIssueIsCostBalance();
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                isCostAdd = tri.isSupplyIsCostBalance();
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) {
                isCostAdd = tri.isRequireIsCostBalance();
            }
        }
        return isCostAdd;
    }

    protected boolean getIsOnlyAver(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        TransferRule4Info tri;
        if (priceParamInfo.getSupplyRelation() == null || !priceParamInfo.isMoveAverage()) {
            return false;
        }
        boolean isOnlyAver = false;
        String bizTypeId = priceParamInfo.getBizTypeInfo().getId().toString();
        String supplyRelationId = priceParamInfo.getSupplyRelation().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            TransferRule2Info tri2 = (TransferRule2Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (tri2 != null && UseStatusEnum.ACTIVE == tri2.getStatus()) {
                isOnlyAver = tri2.isIsIssueOnlyAver();
            }
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            TransferRule3Info tri3 = (TransferRule3Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (tri3 != null && UseStatusEnum.ACTIVE == tri3.getStatus()) {
                if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                    isOnlyAver = tri3.isIsIssueOnlyAver();
                } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                    isOnlyAver = tri3.isIsSupplyOnlyAver();
                }
            }
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) && (tri = (TransferRule4Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId)) != null && UseStatusEnum.ACTIVE == tri.getStatus()) {
            if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                isOnlyAver = tri.isIsIssueOnlyAver();
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                isOnlyAver = tri.isIsSupplyOnlyAver();
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) {
                isOnlyAver = tri.isIsRequireOnlyAver();
            }
        }
        return isOnlyAver;
    }

    protected BigDecimal getCostAddRate(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        String bizTypeId = priceParamInfo.getBizTypeInfo().getId().toString();
        String supplyRelationId = priceParamInfo.getSupplyRelation().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            TransferRule2Info tri = (TransferRule2Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (tri != null && UseStatusEnum.ACTIVE == tri.getStatus()) {
                if (tri.getIssueCostRule() == null || tri.getIssueCostRule() == InnerCostRuleEnum.RATEBYUNIONPRICE) {
                    return tri.getIssueCostRate();
                }
                if (tri.getIssueCostRule() == InnerCostRuleEnum.RATEBYMATERIAL && priceParamInfo.getMateial().getId() != null && priceParamInfo.getIssueSaleOrgUnitInfo().getId() != null) {
                    MaterialSalesInfo materialSalesInfo = this.dataVO.getMaterialSales(this.ctx, priceParamInfo.getMateial().getId().toString(), priceParamInfo.getIssueSaleOrgUnitInfo().getId().toString());
                    if (materialSalesInfo == null) {
                        return new BigDecimal(0);
                    }
                    BigDecimal rate = new BigDecimal(materialSalesInfo.getInnerPriceRate());
                    return rate;
                }
            }
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            return this.getAddRate(priceParamInfo);
        }
        return new BigDecimal(0);
    }

    protected BigDecimal getAddRate(PriceParamInfo priceParamInfo) throws EASBizException, BOSException {
        String bizTypeId = priceParamInfo.getBizTypeInfo().getId().toString();
        String supplyRelationId = priceParamInfo.getSupplyRelation().getId().toString();
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            TransferRule3Info tri = (TransferRule3Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (tri != null && UseStatusEnum.ACTIVE == tri.getStatus()) {
                if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                    if (tri.getIssueCostRule() == null || InnerCostRuleEnum.RATEBYUNIONPRICE.equals((Object)tri.getIssueCostRule())) {
                        return tri.getIssueCostRate();
                    }
                    if (InnerCostRuleEnum.RATEBYMATERIAL.equals((Object)tri.getIssueCostRule()) && priceParamInfo.getMateial().getId() != null && priceParamInfo.getIssueSaleOrgUnitInfo().getId() != null) {
                        MaterialSalesInfo materialSalesInfo = this.dataVO.getMaterialSales(this.ctx, priceParamInfo.getMateial().getId().toString(), priceParamInfo.getIssueSaleOrgUnitInfo().getId().toString());
                        if (materialSalesInfo == null) {
                            return new BigDecimal(0);
                        }
                        BigDecimal rate = new BigDecimal(materialSalesInfo.getInnerPriceRate());
                        return rate;
                    }
                } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                    if (tri.getSupplyCostRule() == null || InnerCostRuleEnum.RATEBYUNIONPRICE.equals((Object)tri.getSupplyCostRule())) {
                        return tri.getSupplyCostRate();
                    }
                    if (InnerCostRuleEnum.RATEBYMATERIAL.equals((Object)tri.getSupplyCostRule()) && priceParamInfo.getMateial().getId() != null && priceParamInfo.getSupplySaleOrgUnitInfo().getId() != null) {
                        MaterialSalesInfo materialSalesInfo = this.dataVO.getMaterialSales(this.ctx, priceParamInfo.getMateial().getId().toString(), priceParamInfo.getSupplySaleOrgUnitInfo().getId().toString());
                        if (materialSalesInfo == null) {
                            return new BigDecimal(0);
                        }
                        BigDecimal rate = new BigDecimal(materialSalesInfo.getInnerPriceRate());
                        return rate;
                    }
                }
            }
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            TransferRule4Info tri = (TransferRule4Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (tri != null && UseStatusEnum.ACTIVE == tri.getStatus()) {
                if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                    if (tri.getIssueCostRule() == null || InnerCostRuleEnum.RATEBYUNIONPRICE.equals((Object)tri.getIssueCostRule())) {
                        return tri.getIssueCostRate();
                    }
                    if (InnerCostRuleEnum.RATEBYMATERIAL.equals((Object)tri.getIssueCostRule()) && priceParamInfo.getMateial().getId() != null && priceParamInfo.getIssueSaleOrgUnitInfo().getId() != null) {
                        MaterialSalesInfo materialSalesInfo = this.dataVO.getMaterialSales(this.ctx, priceParamInfo.getMateial().getId().toString(), priceParamInfo.getIssueSaleOrgUnitInfo().getId().toString());
                        if (materialSalesInfo == null) {
                            return new BigDecimal(0);
                        }
                        BigDecimal rate = new BigDecimal(materialSalesInfo.getInnerPriceRate());
                        return rate;
                    }
                } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                    if (tri.getSupplyCostRule() == null || InnerCostRuleEnum.RATEBYUNIONPRICE.equals((Object)tri.getSupplyCostRule())) {
                        return tri.getSupplyCostRate();
                    }
                    if (InnerCostRuleEnum.RATEBYMATERIAL.equals((Object)tri.getSupplyCostRule()) && priceParamInfo.getMateial().getId() != null && priceParamInfo.getSupplySaleOrgUnitInfo().getId() != null) {
                        MaterialSalesInfo materialSalesInfo = this.dataVO.getMaterialSales(this.ctx, priceParamInfo.getMateial().getId().toString(), priceParamInfo.getSupplySaleOrgUnitInfo().getId().toString());
                        if (materialSalesInfo == null) {
                            return new BigDecimal(0);
                        }
                        BigDecimal rate = new BigDecimal(materialSalesInfo.getInnerPriceRate());
                        return rate;
                    }
                }
                if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) {
                    if (tri.getRequireCostRule() == null || InnerCostRuleEnum.RATEBYUNIONPRICE.equals((Object)tri.getRequireCostRule())) {
                        return tri.getRequireCostRate();
                    }
                    if (InnerCostRuleEnum.RATEBYMATERIAL.equals((Object)tri.getRequireCostRule()) && priceParamInfo.getMateial().getId() != null && priceParamInfo.getRequireSaleOrgUnitInfo().getId() != null) {
                        MaterialSalesInfo materialSalesInfo = this.dataVO.getMaterialSales(this.ctx, priceParamInfo.getMateial().getId().toString(), priceParamInfo.getRequireSaleOrgUnitInfo().getId().toString());
                        if (materialSalesInfo == null) {
                            return new BigDecimal(0);
                        }
                        BigDecimal rate = new BigDecimal(materialSalesInfo.getInnerPriceRate());
                        return rate;
                    }
                }
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.RequireSide) && tri != null && UseStatusEnum.ACTIVE == tri.getStatus()) {
                if (tri.getRequireCostRule() == null || InnerCostRuleEnum.RATEBYUNIONPRICE.equals((Object)tri.getRequireCostRule())) {
                    return tri.getRequireCostRate();
                }
                if (InnerCostRuleEnum.RATEBYMATERIAL.equals((Object)tri.getRequireCostRule()) && priceParamInfo.getMateial().getId() != null && priceParamInfo.getRequireSaleOrgUnitInfo().getId() != null) {
                    MaterialSalesInfo materialSalesInfo = this.dataVO.getMaterialSales(this.ctx, priceParamInfo.getMateial().getId().toString(), priceParamInfo.getRequireSaleOrgUnitInfo().getId().toString());
                    if (materialSalesInfo == null) {
                        return new BigDecimal(0);
                    }
                    BigDecimal rate = new BigDecimal(materialSalesInfo.getInnerPriceRate());
                    return rate;
                }
            }
        }
        return new BigDecimal(0);
    }

    protected PricePolicyInfo getPricePolicy(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        TransferRule4Info tri;
        if (priceParamInfo.getSupplyRelation() == null) {
            return null;
        }
        PricePolicyInfo ppi = null;
        String bizTypeId = priceParamInfo.getBizTypeInfo().getId().toString();
        String supplyRelationId = priceParamInfo.getSupplyRelation().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            TransferRule2Info tri2 = (TransferRule2Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (tri2 != null && UseStatusEnum.ACTIVE == tri2.getStatus()) {
                ppi = tri2.getIssuePricePolicy();
            }
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            TransferRule3Info tri3 = (TransferRule3Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (tri3 != null && UseStatusEnum.ACTIVE == tri3.getStatus()) {
                if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                    ppi = tri3.getIssuePricePolicy();
                } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                    ppi = tri3.getSupplyPricePolicy();
                }
            }
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) && (tri = (TransferRule4Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId)) != null && UseStatusEnum.ACTIVE == tri.getStatus()) {
            if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                ppi = tri.getIssuePricePolicy();
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                ppi = tri.getSupplyPricePolicy();
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) {
                ppi = tri.getRequirePricePolicy();
            }
        }
        return ppi;
    }

    protected SaleOrgUnitInfo getSaleOrgUnitInfo(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        SaleOrgUnitInfo soi = null;
        if (priceParamInfo == null || priceParamInfo.getBizTypeInfo() == null || priceParamInfo.getSupplyRelation() == null) {
            return null;
        }
        String bizTypeId = priceParamInfo.getBizTypeInfo().getId().toString();
        String supplyRelationId = priceParamInfo.getSupplyRelation().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            TransferRule2Info tri = (TransferRule2Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            soi = tri != null && tri.getStatus() != null && tri.getStatus().getValue() == 1 ? tri.getIssueSaleOrgUnit() : priceParamInfo.getIssueSaleOrgUnitInfo();
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            TransferRule3Info tri = (TransferRule3Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                soi = tri != null && tri.getStatus() != null && tri.getStatus().getValue() == 1 ? tri.getIssueSaleOrgUnit() : priceParamInfo.getIssueSaleOrgUnitInfo();
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                soi = tri != null && tri.getStatus() != null && tri.getStatus().getValue() == 1 ? tri.getSupplySaleOrgUnit() : priceParamInfo.getSupplySaleOrgUnitInfo();
            }
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            TransferRule4Info tri = (TransferRule4Info)this.getTransferRuleInfo(supplyRelationId, bizTypeId);
            if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                soi = tri != null && tri.getStatus() != null && tri.getStatus().getValue() == 1 ? tri.getIssueSaleOrgUnit() : priceParamInfo.getIssueSaleOrgUnitInfo();
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                soi = tri != null && tri.getStatus() != null && tri.getStatus().getValue() == 1 ? tri.getSupplySaleOrgUnit() : priceParamInfo.getSupplySaleOrgUnitInfo();
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) {
                soi = tri != null && tri.getStatus() != null && tri.getStatus().getValue() == 1 ? tri.getRequireSaleOrgUnit() : priceParamInfo.getRequireSaleOrgUnitInfo();
            }
        }
        return soi;
    }

    protected BigDecimal getTaxRate(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        BigDecimal taxRate = SCMConstant.DefaultTaxRate;
        String matId = priceParamInfo.getMateial().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(priceParamInfo.getBizTypeInfo().getId().toString())) {
            if (priceParamInfo.getIssueSaleOrgUnitInfo() != null) {
                taxRate = this.getMaterialTaxRate(priceParamInfo, priceParamInfo.getIssueSaleOrgUnitInfo(), matId);
            }
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(priceParamInfo.getBizTypeInfo().getId().toString())) {
            if (priceParamInfo.getSupplySaleOrgUnitInfo() != null) {
                taxRate = this.getMaterialTaxRate(priceParamInfo, priceParamInfo.getSupplySaleOrgUnitInfo(), matId);
            }
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(priceParamInfo.getBizTypeInfo().getId().toString()) && priceParamInfo.getSupplySaleOrgUnitInfo() != null) {
            taxRate = this.getMaterialTaxRate(priceParamInfo, priceParamInfo.getSupplySaleOrgUnitInfo(), matId);
        }
        return taxRate;
    }

    public BigDecimal getMaterialTaxRate(PriceParamInfo priceParamInfo, SaleOrgUnitInfo saleOrg, String materialId) throws BOSException, EASBizException {
        BigDecimal taxRate = new BigDecimal("0.00");
        BigDecimal defaultTaxRate = SCMConstant.DefaultTaxRate;
        if (this.isFetchTaxRateFromCustomer(saleOrg.getId().toString())) {
            CompanyOrgUnitInfo requireCouInfo = priceParamInfo.getRequireCompanyOrgUnitInfo();
            if (requireCouInfo == null) {
                taxRate = defaultTaxRate;
            } else if (!mapTaxRateValue.containsKey(requireCouInfo.getId().toString())) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("taxRate"));
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("internalCompany.id", (Object)requireCouInfo.getId().toString()));
                ev.setFilter(fi);
                ev.setSelector(sic);
                ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)this.ctx);
                CustomerCollection voInfo = iCustomer.getCustomerCollection(ev);
                taxRate = voInfo != null && null != voInfo.get(0) && null != voInfo.get(0).getTaxRate() ? voInfo.get(0).getTaxRate() : defaultTaxRate;
                mapTaxRateValue.put(requireCouInfo.getId().toString(), taxRate);
            } else {
                taxRate = (BigDecimal)mapTaxRateValue.get(requireCouInfo.getId().toString());
                if (null == taxRate) {
                    taxRate = defaultTaxRate;
                }
            }
        } else {
            MaterialSalesInfo materialSalesInfo = this.getSalesInfo(materialId, saleOrg.getId().toString());
            taxRate = materialSalesInfo != null && materialSalesInfo.getTaxRate() != null ? materialSalesInfo.getTaxRate() : defaultTaxRate;
        }
        return taxRate;
    }

    public boolean isFetchTaxRateFromCustomer(String saleOrgId) throws EASBizException, BOSException {
        if (!mapParamValue.containsKey(saleOrgId + "SALEBILL001")) {
            mapParamValue.put(saleOrgId + "SALEBILL001", ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectUuidPK(saleOrgId), "SALEBILL001"));
        }
        boolean isPurParam = false;
        String strPurParam = (String)mapParamValue.get(saleOrgId + "SALEBILL001");
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    private MaterialSalesInfo getSalesInfo(String matId, String saleOrgId) throws EASBizException, BOSException {
        if (!this.dataVO.getMapMaterialSales().containsKey(matId + saleOrgId)) {
            this.dataVO.getMapMaterialSales().put(matId + saleOrgId, MaterialSalesFactory.getLocalInstance((Context)this.ctx).getSalesInfo(matId, saleOrgId));
        }
        return (MaterialSalesInfo)this.dataVO.getMapMaterialSales().get(matId + saleOrgId);
    }

    private CustomerInfo getCustomerByInter(String couId) throws BOSException, EASBizException {
        if (!this.dataVO.getMapCustomer().containsKey(couId)) {
            ICustomer ic = CustomerFactory.getLocalInstance((Context)this.ctx);
            CustomerCollection cc = ic.getCustomerCollectionByInter(couId);
            this.dataVO.getMapCustomer().put(couId, cc.size() > 0 ? cc.get(0) : null);
        }
        return (CustomerInfo)this.dataVO.getMapCustomer().get(couId);
    }

    protected CustomerInfo getCustomer(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        if (priceParamInfo == null || priceParamInfo.getSupplyRelation() == null) {
            return null;
        }
        SupplyRelationInfo srInfo = priceParamInfo.getSupplyRelation();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(priceParamInfo.getBizTypeInfo().getId().toString())) {
            if (srInfo.getReceiveCompanyOrgUnit() != null && srInfo.getReceiveCompanyOrgUnit().getId() != null) {
                return this.getCustomerByInter(srInfo.getReceiveCompanyOrgUnit().getId().toString());
            }
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(priceParamInfo.getBizTypeInfo().getId().toString())) {
            if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                if (srInfo.getReceiveCompanyOrgUnit() != null && srInfo.getReceiveCompanyOrgUnit().getId() != null) {
                    return this.getCustomerByInter(srInfo.getReceiveCompanyOrgUnit().getId().toString());
                }
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide) && srInfo.getSupplyCompanyOrgUnit() != null && srInfo.getSupplyCompanyOrgUnit().getId() != null) {
                return this.getCustomerByInter(srInfo.getSupplyCompanyOrgUnit().getId().toString());
            }
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(priceParamInfo.getBizTypeInfo().getId().toString())) {
            if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                if (srInfo.getSupplyCompanyOrgUnit() != null && srInfo.getSupplyCompanyOrgUnit().getId() != null) {
                    return this.getCustomerByInter(srInfo.getSupplyCompanyOrgUnit().getId().toString());
                }
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                if (srInfo.getRequireCompanyOrgUnit() != null && srInfo.getRequireCompanyOrgUnit().getId() != null) {
                    return this.getCustomerByInter(srInfo.getRequireCompanyOrgUnit().getId().toString());
                }
            } else if (priceParamInfo.getBizRole().equals((Object)BizRoleTypeEnum.RequireSide) && srInfo.getReceiveCompanyOrgUnit() != null && srInfo.getReceiveCompanyOrgUnit().getId() != null) {
                return this.getCustomerByInter(srInfo.getReceiveCompanyOrgUnit().getId().toString());
            }
        }
        return null;
    }

    protected PriceInfo getPriceInfo(PriceInfo priceInfo, PriceParamInfo priceParamInfo, BigDecimal costAddRate, boolean isCostAdd, boolean isInTax) throws EASBizException, BOSException {
        priceInfo.setStockTransferID(priceParamInfo.getStockTransferID());
        priceInfo.setStockTransferEntryID(priceParamInfo.getStockTransferEntryID());
        priceInfo.setBizRoleType(priceParamInfo.getBizRole());
        priceInfo.setCostAdd(isCostAdd);
        priceInfo.setOnlyAver(this.getIsOnlyAver(priceParamInfo));
        priceInfo.setCostAddRate(costAddRate);
        priceInfo.setPricePrecision(priceParamInfo.getMateial().getPricePrecision());
        priceInfo.setIsInTax(isInTax);
        priceInfo.setKey(priceParamInfo.getStockTransferEntryID());
        if (priceParamInfo.getTransferOrderBillTaxRate() == null || priceParamInfo.getTransferOrderBillTaxRate().compareTo(ZERO) <= 0) {
            priceInfo.setTaxRate(this.getTaxRate(priceParamInfo));
        } else {
            priceInfo.setTaxRate(priceParamInfo.getTransferOrderBillTaxRate());
        }
        if (this.isFetchTaxRateFromCustomer(this.getSaleOrgUnitInfo(priceParamInfo).getId().toString())) {
            CustomerInfo customer = this.getCustomer(priceParamInfo);
            priceInfo.setTaxRate(customer.getTaxRate());
        }
        if (priceInfo.getDiscountType() == null || priceInfo.getDiscountType().equals((Object)DiscountModeEnum.NULL)) {
            priceInfo.setDiscountType(DiscountModeEnum.getEnum((int)0));
            priceInfo.setDiscountRate(new BigDecimal("0.00"));
        }
        if (priceInfo.getPrice() != null || priceInfo.getTaxPrice() != null) {
            InvAppUtils.getPriceInfo(priceInfo);
        }
        return priceInfo;
    }

    protected boolean getIsInTax(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo ppi;
        IPriceParam ipp = PriceParamFactory.getLocalInstance((Context)this.ctx);
        SaleOrgUnitInfo saleOrg = this.getSaleOrgUnitInfo(priceParamInfo);
        if (saleOrg == null) {
            return true;
        }
        if (!this.dataVO.getMapPolicyContainTax().containsKey(saleOrg.getId().toString()) && (ppi = ipp.getParameter(saleOrg.getId().toString())) != null) {
            this.dataVO.getMapPolicyContainTax().put(saleOrg.getId().toString(), ppi.isContainTax());
        }
        return (Boolean)this.dataVO.getMapPolicyContainTax().get(saleOrg.getId().toString());
    }

    public TransferRuleInfo getTransferRuleInfo(String supplyRelationId, String bizTypeId) throws EASBizException, BOSException {
        TransferRuleInfo transferRuleInfo = null;
        if (!this.dataVO.getMapTransferRule().containsKey(supplyRelationId + bizTypeId)) {
            IMultiSidesTransferFacade ims = MultiSidesTransferFacadeFactory.getLocalInstance(this.ctx);
            transferRuleInfo = ims.getTransferRuleInfo(supplyRelationId, bizTypeId);
            this.dataVO.getMapTransferRule().put(supplyRelationId + bizTypeId, transferRuleInfo);
        } else {
            transferRuleInfo = (TransferRuleInfo)this.dataVO.getMapTransferRule().get(supplyRelationId + bizTypeId);
        }
        return transferRuleInfo;
    }

    @Override
    public PriceInfo[] getPrice(PriceParamInfo[] paramInfos) throws BOSException, EASBizException {
        int length = paramInfos.length;
        PriceParamInfo[] validParams = new PriceParamInfo[length];
        for (int i = 0; i < length; ++i) {
            validParams[i] = paramInfos[i] == null || paramInfos[i].getSupplyRelation() == null || paramInfos[i].getBizTypeInfo() == null || this.getTransferRuleInfo(paramInfos[i].getSupplyRelation().getId().toString(), paramInfos[i].getBizTypeInfo().getId().toString()) == null ? null : paramInfos[i];
        }
        return this._getPrice(paramInfos);
    }

    protected abstract PriceInfo[] _getPrice(PriceParamInfo[] var1) throws BOSException, EASBizException;
}

