/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.PriceRule4ProfitEnum;
import com.kingdee.eas.basedata.scm.common.SettlementRuleEntryForPCInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.loadmass.app.DataLoaderHelper;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferPrice;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDiffPrice
implements IMultiSidesTransferPrice {
    protected Context ctx = null;
    protected Map dataVO = new HashMap();
    protected SettlementRuleEntryForPCInfo settlementRuleEntryForPCInfo = null;

    protected PriceCondition buildPriceCondition(PriceParamInfo paramInfo) throws EASBizException, BOSException {
        if (paramInfo == null) {
            return null;
        }
        SaleOrgUnitInfo sou = this.getSaleOrgUnitInfo(paramInfo);
        if (sou == null) {
            return null;
        }
        PriceCondition pc = new PriceCondition();
        pc.setSaleOrg(sou);
        pc.setCustomerInfo(new CustomerInfo());
        pc.setMaterialInfo(paramInfo.getMateial());
        pc.setMeasureUnit(paramInfo.getUnit().getId().toString());
        pc.setOrderQty(paramInfo.getQty());
        pc.setCurrencyInfo(paramInfo.getCurrencyInfo());
        pc.setAssiProperty(paramInfo.getAssistAttirute());
        pc.setCurDate(paramInfo.getBizDate());
        pc.setCompanyOrg(paramInfo.getCompanyOrgUnit());
        pc.setIgnoreSalePriceParam(true);
        return pc;
    }

    protected CustomerInfo getCustomer(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        if (priceParamInfo == null) {
            return null;
        }
        return this.getCustomerByInter(priceParamInfo.getCompanyOrgUnit().getId().toString());
    }

    protected CustomerInfo getCustomerByInter(String couId) throws BOSException, EASBizException {
        if (!this.dataVO.containsKey(couId)) {
            ICustomer ic = CustomerFactory.getLocalInstance((Context)this.ctx);
            CustomerCollection cc = ic.getCustomerCollectionByInter(couId);
            this.dataVO.put(couId, cc.size() > 0 ? cc.get(0) : null);
        }
        return (CustomerInfo)this.dataVO.get(couId);
    }

    protected PeriodInfo getCurPeriod(String companyId) throws BOSException, EASBizException {
        if (!this.dataVO.containsKey(companyId + SystemEnum.INVENTORYMANAGEMENT)) {
            this.dataVO.putAll(DataLoaderHelper.loadCurrenPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (String[])new String[]{companyId}));
        }
        return (PeriodInfo)this.dataVO.get(companyId + SystemEnum.INVENTORYMANAGEMENT);
    }

    protected SaleOrgUnitInfo getSaleOrgUnitInfo(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        SaleOrgUnitInfo soi = this.settlementRuleEntryForPCInfo.getSaleOrgUnit();
        return soi;
    }

    protected PriceInfo buildPriceInfo(List list, PriceParamInfo paramInfo) throws EASBizException, BOSException {
        if (list != null && list.size() > 0 && list.get(0) != null) {
            SalePriceTO salePriceT0 = (SalePriceTO)list.get(0);
            BigDecimal price = salePriceT0.price;
            if (price != null && price.compareTo(ZERO) > 0) {
                String currency = salePriceT0.currency;
                if (!paramInfo.getCurrencyInfo().getId().toString().equals(currency)) {
                    return null;
                }
                String assistproperty = salePriceT0.assistProperty;
                if (paramInfo.getAssistAttirute() != null && assistproperty != null && !paramInfo.getAssistAttirute().getId().toString().equals(assistproperty)) {
                    return null;
                }
                price = this.addOrMinusPriceRate(paramInfo, price);
                PriceInfo priceInfo = new PriceInfo();
                priceInfo.setPrice(price);
                return priceInfo;
            }
        }
        return null;
    }

    @Override
    public PriceInfo getPrice(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        this.settlementRuleEntryForPCInfo = priceParamInfo.getSettlementRuleEntryForPCInfo();
        if (this.settlementRuleEntryForPCInfo != null && this.settlementRuleEntryForPCInfo.getPriceRule() != null && this.settlementRuleEntryForPCInfo.getPriceRule().equals((Object)this.getPriceRuleEnum())) {
            return this._getPrice(priceParamInfo);
        }
        return null;
    }

    @Override
    public PriceInfo[] getPrice(PriceParamInfo[] paramInfos) throws BOSException, EASBizException {
        PriceInfo[] priceInfos = new PriceInfo[paramInfos.length];
        for (int i = 0; i < paramInfos.length; ++i) {
            this.settlementRuleEntryForPCInfo = paramInfos[i].getSettlementRuleEntryForPCInfo();
            priceInfos[i] = this.settlementRuleEntryForPCInfo != null && this.settlementRuleEntryForPCInfo.getPriceRule() != null && this.settlementRuleEntryForPCInfo.getPriceRule().equals((Object)this.getPriceRuleEnum()) ? this._getPrice(paramInfos[i]) : null;
        }
        return priceInfos;
    }

    protected BigDecimal addOrMinusPriceRate(PriceParamInfo paramInfo, BigDecimal price) throws BOSException, EASBizException {
        int pricePrecision = paramInfo.getPricePrecision();
        BigDecimal addOrMinusRate = this.settlementRuleEntryForPCInfo.getAddOrMinusRate();
        BigDecimal addOrMinusPrice = this.settlementRuleEntryForPCInfo.getAddOrMinusPrice();
        if (addOrMinusRate != null && addOrMinusRate.compareTo(ZERO) != 0) {
            price = price.multiply(BigDecimal.ONE.add(addOrMinusRate.divide(new BigDecimal("100.00"), 4, 4))).setScale(pricePrecision, 4);
        }
        if (addOrMinusPrice != null && addOrMinusPrice.compareTo(ZERO) != 0) {
            price = price.add(addOrMinusPrice).setScale(pricePrecision, 4);
        }
        if (price.compareTo(ZERO) <= 0) {
            price = ZERO;
        }
        price = price.setScale(pricePrecision, 4);
        return price;
    }

    protected boolean isSystemRule() throws BOSException, EASBizException {
        return "Lz0e9mGfRZi8e4R5qQlUehUHKaY=".equals(this.settlementRuleEntryForPCInfo.getParent().getId().toString());
    }

    protected abstract PriceInfo _getPrice(PriceParamInfo var1) throws BOSException, EASBizException;

    protected abstract PriceRule4ProfitEnum getPriceRuleEnum() throws BOSException, EASBizException;
}

