/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractAutoCreateVoucherFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class AutoCreateVoucherFacadeControllerBean
extends AbstractAutoCreateVoucherFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.AutoCreateVoucherFacadeControllerBean");

    @Override
    protected void _createVoucher(Context ctx, IObjectValue invBillBaseInfo) throws BOSException, EASBizException {
        this.generateVoucherInNewThread(ctx, invBillBaseInfo);
    }

    private void generateVoucherInNewThread(final Context ctx, final IObjectValue invBillBaseInfo) {
        if (null == invBillBaseInfo) {
            logger.error((Object)"InvBillBase is null,can't generateVoucher........");
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (invBillBaseInfo instanceof SaleIssueBillInfo) {
                            SaleIssueBillFactory.getLocalInstance(ctx).generateVoucher((SaleIssueBillInfo)invBillBaseInfo);
                        } else if (invBillBaseInfo instanceof PurInWarehsBillInfo) {
                            PurInWarehsBillFactory.getLocalInstance(ctx).generateVoucher((PurInWarehsBillInfo)invBillBaseInfo);
                        } else {
                            logger.error((Object)"BillType is not supported,can't generateVoucher........");
                        }
                    }
                    catch (Exception e) {
                        String billNumber = null;
                        String detail = null;
                        if (null != invBillBaseInfo && invBillBaseInfo instanceof InvBillBaseInfo) {
                            billNumber = ((InvBillBaseInfo)invBillBaseInfo).getNumber();
                        }
                        if (e instanceof EASBizException) {
                            detail = e.getMessage();
                        }
                        if (billNumber == null) break block8;
                        AutoCreateVoucherFacadeControllerBean.this.setFailuareMessage(ctx, billNumber, detail);
                    }
                }
            }
        });
        thread.start();
    }

    private void setFailuareMessage(Context ctx, String billNumber, String detail) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        String sysStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.common.SCMResource", (String)"SYSTEM", (Context)ctx);
        String msgStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.common.SCMResource", (String)"GEN_VOUCHER_FAILED", (Context)ctx);
        MessageFormat mf = new MessageFormat(msgStr);
        String msg = mf.format(new String[]{billNumber});
        message.setLocaleStringHeader("title", msg, ctx.getLocale());
        message.setLocaleStringHeader("sender", sysStr, ctx.getLocale());
        if (null != detail && !detail.trim().equals("")) {
            msg = mf.format(new String[]{detail});
        }
        message.setLocaleStringHeader("body", msg, ctx.getLocale());
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        message.setStringHeader("receiver", userId);
        senderAgent.sendMessage(message);
    }
}

