/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTypeEnum;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractAutoBillProcessor;
import com.kingdee.eas.scm.im.inv.app.IAutoBillProcessor;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.SaleIssueAlgorithmForInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoPurInProcessor
extends AbstractAutoBillProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.AutoCreateBill4PurIn");

    private AutoPurInProcessor() {
    }

    public static IAutoBillProcessor getInstance() {
        return new AutoPurInProcessor();
    }

    @Override
    public void _autoCreate(Context ctx, SCMBillBaseInfo scmBillInfo) throws EASBizException, BOSException {
        this.createSaleIssue4Delivery(ctx, (PurInWarehsBillInfo)scmBillInfo);
    }

    private void createSaleIssue4Delivery(Context ctx, PurInWarehsBillInfo piwInfo) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            this.preCheck4CreateSaleIssue(ctx, piwInfo);
            this.createCommonSaleIssue(ctx, piwInfo, conn);
            this.createManuSaleIssue(ctx, piwInfo, conn);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void preCheck4CreateSaleIssue(Context ctx, PurInWarehsBillInfo piwInfo) throws BOSException, EASBizException {
        ICodingRuleManager manager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = manager.getCodingRule((IObjectValue)new SaleIssueBillInfo(), piwInfo.getStorageOrgUnit().getId().toString());
        if (ruleInfo == null || !ruleInfo.isIsEnabled()) {
            throw new InvBizException(InvBizException.NOTENABLECODINGRULE);
        }
    }

    @Override
    protected boolean shouldAutoCreate(Context ctx, SCMBillBaseInfo billInfo) throws BOSException {
        StringBuffer entrySizeSql = new StringBuffer("select count(1) as entrySize from T_IM_TransferOrderBillEntry where fid in ");
        entrySizeSql.append("(select FPurOrderEntryID from T_IM_PurInWarehsEntry where FParentId = '");
        entrySizeSql.append(billInfo.getId().toString()).append("' and FCoreBillTypeID = '");
        entrySizeSql.append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("') and FSupplyType = ");
        entrySizeSql.append(4);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)entrySizeSql.toString());
        try {
            if (rs.next() && rs.getInt("entrySize") > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    private void createCommonSaleIssue(Context ctx, PurInWarehsBillInfo piwInfo, Connection conn) throws BOSException, SQLException, EASBizException {
        BTPTransformResult result = this.createSaleIssue(ctx, piwInfo, "INM-131", conn);
        if (result == null || result.getBills() == null || result.getBills().size() == 0) {
            return;
        }
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            SaleIssueBillInfo siInfo = (SaleIssueBillInfo)result.getBills().getObject(i);
            Map headMap = this.updateCommonHead(conn, siInfo);
            this.updateCommonEntry(conn, siInfo, headMap);
            try {
                new SaleIssueAlgorithmForInfo(siInfo, ctx).revalue();
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        this.saveBotpBill(result, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map updateCommonHead(Connection conn, SaleIssueBillInfo siInfo) throws BOSException, SQLException, EASBizException {
        SaleIssueEntryCollection siCol = siInfo.getEntry();
        StringBuffer headSql = new StringBuffer("select fisintax, fconvertmode, FCurrencyId,FExchangeRate,FId,FCustomerOrderNumber,FNumber,FOrderCustomerID FROM T_SD_SaleOrder ");
        headSql.append("where FId = (select FSaleOrderId from T_IM_TransferOrderBillEntry toe ");
        headSql.append("where toe.fid = (select FPurOrderEntryId from T_IM_PurInWarehsEntry piwe ");
        headSql.append("where piwe.fid = '").append(siCol.get(0).getSourceBillEntryId().toString()).append("' ").append("))");
        IRowSet rs = InvServerUtils.executeQuery(conn, headSql.toString());
        String currencyId = null;
        BigDecimal exchangeRate = null;
        boolean isInTax = true;
        int convertMode = 0;
        HashMap<String, String> headMap = new HashMap<String, String>();
        try {
            if (rs.size() > 0 && rs.next()) {
                currencyId = rs.getString("FCurrencyId");
                exchangeRate = rs.getBigDecimal("FExchangeRate");
                headMap.put("soNumber", rs.getString("FNumber"));
                headMap.put("soCusOrderNumber", rs.getString("FCustomerOrderNumber"));
                headMap.put("soId", rs.getString("FId"));
                headMap.put("orderCusId", rs.getString("FOrderCustomerID"));
                isInTax = rs.getBoolean("fisintax");
                convertMode = rs.getInt("fconvertmode");
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setId(BOSUuid.read((String)currencyId));
        siInfo.setCurrency(currencyInfo);
        siInfo.setExchangeRate(exchangeRate);
        siInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        siInfo.setIsInTax(isInTax);
        siInfo.setConvertMode(ConvertModeEnum.getEnum((int)convertMode));
        return headMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCommonEntry(Connection conn, SaleIssueBillInfo siInfo, Map headMap) throws BOSException, SQLException, EASBizException {
        SaleIssueEntryCollection siCol = siInfo.getEntry();
        HashMap orderEntryMap = new HashMap(siCol.size() * 2);
        StringBuffer srcBillIds = new StringBuffer();
        int entrySize = siCol.size();
        for (int j = 0; j < entrySize; ++j) {
            srcBillIds.append("'").append(siCol.get(j).getSourceBillEntryId()).append("',");
        }
        srcBillIds.append("''");
        StringBuffer entrySql = new StringBuffer();
        entrySql.append("select soe.FSeq as seq,soe.FTaxRate as taxRate,");
        entrySql.append("piwe.FId as piweId,soe.FPaymentCustomerID as payCusId,soe.FReceiveCustomerID as recCusId,");
        entrySql.append("soe.FId as entryId,soe.FIsBetweenCompanySend as bcSend,so.FIsCentralBalance as cenBalance,");
        entrySql.append("DECIMAL(soe.FActualTaxPrice / CASE WHEN piwe.FUnitId = soe.FUnitId THEN 1 ");
        entrySql.append("ELSE DECIMAL(smmu.FBaseConvsRate/pmmu.FBaseConvsRate,21,8) END,21,8) as actualTaxPrice, ");
        entrySql.append("so.fnumber as soNumber, ");
        entrySql.append("so.fid as soId, ");
        entrySql.append("so.FBillTypeID as soBillTypeID, ");
        entrySql.append("so.FsaleOrgUnitID as soSaleOrg, ");
        entrySql.append("soe.fprice as price, ");
        entrySql.append("soe.FDiscountType as discountType, ");
        entrySql.append("soe.fDiscount as discount, ");
        entrySql.append("soe.ftaxprice as taxPrice ");
        entrySql.append("from T_IM_TransferOrderBillEntry toe ");
        entrySql.append("left join T_IM_PurInWarehsEntry piwe on piwe.FPurOrderEntryId = toe.FId ");
        entrySql.append("left join T_SD_SaleOrderEntry soe on soe.FId = toe.FSaleOrderEntryId ");
        entrySql.append("left join T_BD_MultiMeasureUnit pmmu on pmmu.FMeasureUnitId = piwe.FUnitId AND pmmu.FMaterialId = piwe.FMaterialId ");
        entrySql.append("left join T_BD_MultiMeasureUnit smmu on smmu.FMeasureUnitId = soe.FUnitId AND smmu.FMaterialId = soe.FMaterialId ");
        entrySql.append("left join T_SD_SaleOrder so on so.FId = soe.FParentId where piwe.fid in(");
        entrySql.append(srcBillIds).append(")");
        IRowSet rs = InvServerUtils.executeQuery(conn, entrySql.toString());
        try {
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("seq", new Integer(rs.getInt("seq")));
                map.put("actualTaxPrice", rs.getBigDecimal("actualTaxPrice"));
                map.put("taxRate", rs.getBigDecimal("taxRate"));
                map.put("entryId", rs.getString("entryId"));
                map.put("payCusId", rs.getString("payCusId"));
                map.put("recCusId", rs.getString("recCusId"));
                map.put("bcSend", new Boolean(rs.getBoolean("bcSend")));
                map.put("cenBalance", new Boolean(rs.getBoolean("cenBalance")));
                map.put("price", rs.getBigDecimal("price"));
                map.put("discountType", rs.getString("discountType"));
                map.put("discount", rs.getBigDecimal("discount"));
                map.put("taxPrice", rs.getBigDecimal("taxPrice"));
                map.put("soNumber", rs.getString("soNumber"));
                map.put("soId", rs.getString("soId"));
                map.put("soSaleOrg", rs.getString("soSaleOrg"));
                map.put("soBillTypeID", rs.getString("soBillTypeID"));
                orderEntryMap.put(rs.getString("piweId"), map);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        int entrySize2 = siCol.size();
        for (int j = 0; j < entrySize2; ++j) {
            this.updateOneEntry(siCol.get(j), orderEntryMap, headMap, siInfo.getExchangeRate());
        }
    }

    private void updateOneEntry(SaleIssueEntryInfo siEntryInfo, Map orderEntryMap, Map headMap, BigDecimal exchangeRate) {
        BigDecimal ONE = new BigDecimal("1.00");
        Map map = (Map)orderEntryMap.get(siEntryInfo.getSourceBillEntryId());
        siEntryInfo.setIsBetweenCompanySend((Boolean)map.get("bcSend"));
        siEntryInfo.setIsCenterBalance((Boolean)map.get("cenBalance"));
        siEntryInfo.setSaleOrder((String)map.get("soId"));
        siEntryInfo.setSaleOrderNumber((String)map.get("soNumber"));
        siEntryInfo.setSaleOrderEntry((String)map.get("entryId"));
        siEntryInfo.setSaleOrderEntrySeq((Integer)map.get("seq"));
        if (map.get("soBillTypeID") != null) {
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)((String)map.get("soBillTypeID"))));
            siEntryInfo.setCoreBillType(billTypeInfo);
        }
        siEntryInfo.setOrderNumber((String)headMap.get("soCusOrderNumber"));
        CustomerInfo orderCusInfo = new CustomerInfo();
        orderCusInfo.setId(BOSUuid.read((String)headMap.get("orderCusId").toString()));
        siEntryInfo.setOrderCustomer(orderCusInfo);
        CustomerInfo payCusInfo = new CustomerInfo();
        payCusInfo.setId(BOSUuid.read((String)((String)map.get("payCusId"))));
        siEntryInfo.setPaymentCustomer(payCusInfo);
        CustomerInfo recCusInfo = new CustomerInfo();
        recCusInfo.setId(BOSUuid.read((String)((String)map.get("recCusId"))));
        siEntryInfo.setBalanceCustomer(recCusInfo);
        SaleOrgUnitInfo saleOrg = new SaleOrgUnitInfo();
        saleOrg.setId(BOSUuid.read((String)map.get("soSaleOrg").toString()));
        siEntryInfo.setSaleOrgUnit(saleOrg);
        BigDecimal qty = siEntryInfo.getQty() == null ? ZERO : siEntryInfo.getQty();
        siEntryInfo.setTaxRate((BigDecimal)map.get("taxRate"));
        BigDecimal taxRatePlusOne = siEntryInfo.getTaxRate().add(ONE);
        BigDecimal price = map.get("actualTaxPrice") == null ? ZERO : (BigDecimal)map.get("actualTaxPrice");
        BigDecimal localPrice = exchangeRate.multiply(price);
        BigDecimal localAmt = qty.multiply(localPrice);
        BigDecimal amount = qty.multiply(price);
        siEntryInfo.setNonTaxAmount(amount.divide(taxRatePlusOne, 4));
        siEntryInfo.setLocalNonTaxAmount(localAmt.divide(taxRatePlusOne, 4));
        siEntryInfo.setLocalTax(localAmt.subtract(siEntryInfo.getLocalNonTaxAmount()));
        siEntryInfo.setTax(amount.subtract(siEntryInfo.getNonTaxAmount()));
        siEntryInfo.setPrice(price);
        siEntryInfo.setLocalPrice(localPrice);
        siEntryInfo.setAmount(amount);
        siEntryInfo.setLocalAmount(localAmt);
        price = map.get("price") == null ? SysConstant.BIGZERO : (BigDecimal)map.get("price");
        DiscountModeEnum discountType = map.get("discountType") == null ? DiscountModeEnum.PERCENT : DiscountModeEnum.getEnum((int)Integer.parseInt(map.get("discountType").toString()));
        BigDecimal discount = map.get("discount") == null ? SysConstant.BIGZERO : (BigDecimal)map.get("discount");
        BigDecimal taxPrice = map.get("taxPrice") == null ? SysConstant.BIGZERO : (BigDecimal)map.get("taxPrice");
        siEntryInfo.setSalePrice(price);
        siEntryInfo.setDiscountType(discountType);
        siEntryInfo.setDiscount(discount);
        siEntryInfo.setTaxPrice(taxPrice);
    }

    private void createManuSaleIssue(Context ctx, PurInWarehsBillInfo piwInfo, Connection conn) throws BOSException, SQLException, EASBizException {
        BTPTransformResult result = this.createSaleIssue(ctx, piwInfo, "INM-130", conn);
        if (result == null || result.getBills() == null || result.getBills().size() == 0) {
            return;
        }
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            SaleIssueBillInfo siInfo = (SaleIssueBillInfo)result.getBills().getObject(i);
            siInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        this.saveBotpBill(result, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTPTransformResult createSaleIssue(Context ctx, PurInWarehsBillInfo piwInfo, String botpNumber, Connection conn) throws BOSException, SQLException, EASBizException {
        String[] billIds = new String[]{piwInfo.getId().toString()};
        StringBuffer sql = new StringBuffer("select fid from T_IM_PurInWarehsEntry WHERE FParentId = '");
        sql.append(billIds[0]);
        sql.append("' and FPurOrderEntryID in (select fid from T_IM_TransferOrderBillEntry where fid in ");
        sql.append("(select FPurOrderEntryID from T_IM_PurInWarehsEntry where FParentId = '");
        sql.append(billIds[0]).append("' and FCoreBillTypeID = '").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=");
        sql.append("') and FSupplyType = ").append(4);
        IRowSet rs = null;
        try {
            if (piwInfo.getCU() == null && (rs = InvServerUtils.executeQuery(conn, "select FControlUnitID from T_IM_PurInWarehsBill where FID = '" + billIds[0] + "'")).next()) {
                CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                cuInfo.setId(BOSUuid.read((String)rs.getString("FControlUnitID")));
                piwInfo.setCU(cuInfo);
            }
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        BOTMappingCollection mappingCol = null;
        try {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("SRCENTITYNAME", (Object)SCMConstant.BOSTYPE_PURINWAREHS));
            filter.getFilterItems().add(new FilterItemInfo("DESTENTITYNAME", (Object)SCMConstant.BOSTYPE_SALEISSUE));
            filter.getFilterItems().add(new FilterItemInfo("EXTRULE.ISEFFECTED", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("EXTRULE.TRANSMODE", (Object)10));
            filter.getFilterItems().add(new FilterItemInfo("EXTRULE.TRANSMODE", (Object)30));
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
            ev.setFilter(filter);
            mappingCol = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(ev);
        }
        catch (BOSException e) {
            logger.info((Object)e);
        }
        String botpId = this.getBotpId(botpNumber, mappingCol);
        if ("INM-131".equals(botpNumber)) {
            if (botpId == null) {
                throw new InvBizException(InvBizException.DIRECT_COMMON_BOTP_NONEXITED);
            }
            sql.append(" and FSaleOrderId is not null and FSaleOrderEntryId is not null)");
        } else if ("INM-130".equals(botpNumber)) {
            if (botpId == null) {
                throw new InvBizException(InvBizException.DIRECT_MANU_BOTP_NONEXITED);
            }
            sql.append(" and FDirectCustomerId is not null and FSaleOrderId is null and FSaleOrderEntryId is null)");
        }
        BTPTransformResult result = null;
        rs = InvServerUtils.executeQuery(conn, sql.toString());
        if (rs.size() > 0) {
            ArrayList<String> entriesKeys = new ArrayList<String>(rs.size());
            try {
                while (rs.next()) {
                    entriesKeys.add(rs.getString("fid"));
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
            result = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(billIds, new String[]{"entry"}, entriesKeys, null, SCMConstant.BOSTYPE_SALEISSUE, (IObjectPK)new ObjectUuidPK(botpId), SCMConstant.BOSTYPE_PURINWAREHS);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _autoDelete(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)billInfo;
        PurInWarehsEntryInfo entry = null;
        String coreEntryID = null;
        TransferOrderBillEntryInfo toEntry = null;
        boolean isCanDelete = false;
        int size = piwInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entry = piwInfo.getEntry().get(i);
            if (!"Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(entry.getCoreBillType()) || (coreEntryID = entry.getCoreBillEntryId()) == null || (toEntry = TransferOrderBillEntryFactory.getLocalInstance(ctx).getTransferOrderBillEntryInfo((IObjectPK)new ObjectUuidPK(coreEntryID))) == null || !StockTypeEnum.DIRECTDELIVERY.equals((Object)toEntry.getSupplyType())) continue;
            isCanDelete = true;
            break;
        }
        if (!isCanDelete) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct si.FId as fid from T_IM_SaleIssueEntry sie ");
        sql.append("inner join T_IM_SaleIssueBill si on si.FId = sie.FParentId ");
        sql.append("where si.FBaseStatus not in(?,?) ");
        sql.append("  and sie.FSourceBillId = ?");
        Object[] params = new Object[]{new Integer(4), new Integer(7), piwInfo.getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            while (rs.next()) {
                SaleIssueBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(rs.getString("fid")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }
}

