/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.IInventoryBalance;
import com.kingdee.eas.scm.im.inv.InventoryBalanceCollection;
import com.kingdee.eas.scm.im.inv.InventoryBalanceFactory;
import com.kingdee.eas.scm.im.inv.InventoryBalanceInfo;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractBuildPrice;
import com.kingdee.eas.scm.im.inv.app.MultiSidesPriceBizDataVO;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.sql.RowSet;

public class BuildPriceByBalanceCost
extends AbstractBuildPrice {
    private Map mapMAP = new HashMap();

    public BuildPriceByBalanceCost(Context ctx, MultiSidesPriceBizDataVO dataVO) throws EASBizException, BOSException {
        super(ctx, dataVO);
    }

    private void cacheMoveAveragePrice(Context ctx, PriceParamInfo[] paramInfos) throws EASBizException, BOSException {
        String calType;
        this.mapMAP = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select FMaterialID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FPrice from T_CL_RecentCost where ");
        HashMap<String, String> calTypeMap = new HashMap<String, String>();
        for (PriceParamInfo paramInfo : paramInfos) {
            if (paramInfo == null) continue;
            String compayId = null;
            String souId = null;
            if (paramInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                compayId = paramInfo.getCompanyOrgUnit().getId().toString();
                souId = paramInfo.getStorageOrgUnit().getId().toString();
            } else if (paramInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                if (paramInfo.getIssueCompanyOrgUnitInfo() != null && paramInfo.getIssueStorageOrgUnitInfo() != null) {
                    compayId = paramInfo.getIssueCompanyOrgUnitInfo().getId().toString();
                    souId = paramInfo.getIssueStorageOrgUnitInfo().getId().toString();
                }
            } else if (paramInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.RequireSide) && paramInfo.getRequireCompanyOrgUnitInfo() != null && paramInfo.getRequireStorageOrgUnitInfo() != null) {
                compayId = paramInfo.getRequireCompanyOrgUnitInfo().getId().toString();
                souId = paramInfo.getRequireStorageOrgUnitInfo().getId().toString();
            }
            calType = paramInfo.getCalType();
            if (paramInfo == null || !this.getIsCostAdd(paramInfo) || !paramInfo.isMoveAverage() || calType == null || !this.isValidCalType(calType) || calType.equals("2") && paramInfo.getIssueWarehsInfo() == null) continue;
            calTypeMap.put(compayId, calType);
            sql.append("(FMaterialID = '");
            sql.append(paramInfo.getMateial().getId().toString());
            sql.append("' and FCompanyOrgUnitID = '");
            sql.append(compayId);
            if (calType.equals("1")) {
                sql.append("' and FStorageOrgUnitID = '");
                sql.append(souId);
            } else if (calType.equals("2")) {
                sql.append("' and FStorageOrgUnitID = '");
                sql.append(souId);
                sql.append("' and FWarehouseID = '");
                sql.append(paramInfo.getIssueWarehsInfo().getId().toString());
            }
            sql.append("') or ");
        }
        if (calTypeMap.size() > 0) {
            sql.append("(0 = 1)");
            Connection conn = null;
            RowSet rowSet = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                rowSet = SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
                while (rowSet.next()) {
                    calType = (String)calTypeMap.get(rowSet.getString("FCompanyOrgUnitID"));
                    String key = rowSet.getString("FMaterialID") + rowSet.getString("FCompanyOrgUnitID");
                    if (!"0".equals(calType)) {
                        if ("1".equals(calType)) {
                            key = key + rowSet.getString("FStorageOrgUnitID");
                        } else if ("2".equals(calType)) {
                            key = key + rowSet.getString("FStorageOrgUnitID") + rowSet.getString("FWarehouseID");
                        }
                    }
                    this.mapMAP.put(key, rowSet.getBigDecimal("FPrice"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
                try {
                    if (rowSet != null) {
                        rowSet.close();
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    protected BigDecimal dealAddPrice(BigDecimal price, PriceParamInfo paramInfo, BigDecimal costAddRate) throws EASBizException, BOSException {
        BigDecimal addPrice = price;
        BigDecimal val = new BigDecimal(1);
        costAddRate = val.add(costAddRate.multiply(new BigDecimal("0.01")));
        return addPrice.multiply(costAddRate);
    }

    @Override
    public PriceInfo _getPrice(PriceParamInfo paramInfo) throws BOSException, EASBizException {
        this.cacheMoveAveragePrice(this.ctx, new PriceParamInfo[]{paramInfo});
        if (!this.getIsCostAdd(paramInfo)) {
            return null;
        }
        BigDecimal price = null;
        int pricePrecision = paramInfo.getMateial().getPricePrecision();
        if (paramInfo.isMoveAverage()) {
            price = this.getMoveAveragePrice(paramInfo);
        }
        if (!(paramInfo.isMoveAverage() && this.getIsOnlyAver(paramInfo) || price != null && price.compareTo(ZERO) > 0)) {
            EntityViewInfo evi = this.getEntityViewInfo(paramInfo);
            if (evi == null) {
                return null;
            }
            IInventoryBalance iib = InventoryBalanceFactory.getLocalInstance(this.ctx);
            InventoryBalanceCollection ibc = iib.getInventoryBalanceCollection(evi);
            if (ibc == null || ibc.size() <= 0) {
                return null;
            }
            BigDecimal totalQty = new BigDecimal("0.00");
            BigDecimal totalAmount = new BigDecimal("0.00");
            for (int i = 0; i < ibc.size(); ++i) {
                InventoryBalanceInfo ibi = ibc.get(i);
                totalQty = totalQty.add(ibi.getPeriodBeginQty());
                totalAmount = totalAmount.add(ibi.getPeriodBeginBalance());
            }
            if (totalQty.compareTo(ZERO) == 0) {
                return null;
            }
            price = totalAmount.divide(totalQty, pricePrecision, 4);
        }
        if (price == null) {
            return null;
        }
        BigDecimal costAddRate = this.getCostAddRate(paramInfo);
        price = this.dealAddPrice(price, paramInfo, costAddRate);
        ExchangeRateInfo exchangeRateInfo = paramInfo.getExchangeRageInfo();
        if (exchangeRateInfo != null && exchangeRateInfo.getConvertRate() != null && exchangeRateInfo.getConvertRate().compareTo(ZERO) > 0) {
            price = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)exchangeRateInfo.getConvertMode()) ? price.multiply(exchangeRateInfo.getConvertRate()) : price.divide(exchangeRateInfo.getConvertRate(), 4);
        }
        if (!paramInfo.getUnit().getId().toString().equals(paramInfo.getBaseUnit().getId().toString())) {
            MaterialInfo material = paramInfo.getMateial();
            try {
                price = this.getUnitPrice(material, price, paramInfo.getBaseUnit(), paramInfo.getUnit());
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"14_BuildPriceByBalanceCost", (Locale)this.ctx.getLocale()) + e.getMessage());
            }
        }
        price = price.setScale(pricePrecision, 4);
        PriceInfo priceInfo = new PriceInfo();
        priceInfo.setPrice(price);
        return this.getPriceInfo(priceInfo, paramInfo, costAddRate, true, false);
    }

    private BigDecimal getUnitPrice(MaterialInfo material, BigDecimal fromPrice, MeasureUnitInfo fromUnit, MeasureUnitInfo toUnit) throws Exception {
        BigDecimal fromRate = (BigDecimal)this.dataVO.getMapBaseConvsRate().get(material.getId().toString() + fromUnit.getId().toString());
        BigDecimal toRate = (BigDecimal)this.dataVO.getMapBaseConvsRate().get(material.getId().toString() + toUnit.getId().toString());
        BigDecimal toPrice = fromPrice.divide(fromRate, material.getPricePrecision(), 4).multiply(toRate);
        return toPrice;
    }

    private EntityViewInfo getEntityViewInfo(PriceParamInfo paramInfo) throws BOSException, EASBizException {
        if (paramInfo == null) {
            return null;
        }
        if (paramInfo.getIssueCompanyOrgUnitInfo() == null) {
            return null;
        }
        String companyOrgUnitID = null;
        StorageOrgUnitInfo storageOrgUnit = null;
        WarehouseInfo warehouseInfo = null;
        if (paramInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
            companyOrgUnitID = paramInfo.getCompanyOrgUnit().getId().toString();
            storageOrgUnit = paramInfo.getStorageOrgUnit();
        } else if (paramInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
            companyOrgUnitID = paramInfo.getIssueCompanyOrgUnitInfo().getId().toString();
            storageOrgUnit = paramInfo.getIssueStorageOrgUnitInfo();
        } else if (paramInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) {
            companyOrgUnitID = paramInfo.getRequireCompanyOrgUnitInfo().getId().toString();
            storageOrgUnit = paramInfo.getRequireStorageOrgUnitInfo();
        }
        PeriodInfo curPeriodInfo = (PeriodInfo)this.dataVO.getMapCurrenPeriod().get(companyOrgUnitID + SystemEnum.INVENTORYMANAGEMENT);
        if (curPeriodInfo == null) {
            return null;
        }
        String materialID = paramInfo.getMateial().getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.appendFilterItem("companyOrgUnit", (Object)companyOrgUnitID);
        fi.appendFilterItem("materialID", (Object)materialID);
        fi.appendFilterItem("period", (Object)new Integer(curPeriodInfo.getPeriodNumber()));
        fi.appendFilterItem("year", (Object)new Integer(curPeriodInfo.getPeriodYear()));
        if (paramInfo.isSpecialAcct()) {
            String calType = paramInfo.getCalType();
            if (calType != null && this.isValidCalType(calType)) {
                if ("1".equals(calType) && storageOrgUnit != null) {
                    fi.appendFilterItem("storageOrgUnit", (Object)storageOrgUnit.getId().toString());
                }
                warehouseInfo = paramInfo.getIssueWarehsInfo();
                if ("2".equals(calType) && warehouseInfo != null) {
                    if (storageOrgUnit != null) {
                        fi.appendFilterItem("storageOrgUnit", (Object)storageOrgUnit.getId().toString());
                    }
                    fi.appendFilterItem("warehouse", (Object)warehouseInfo.getId().toString());
                }
            }
            if (paramInfo.isLot() && paramInfo.getLot() != null) {
                fi.appendFilterItem("lot", (Object)paramInfo.getLot());
            }
            if (paramInfo.isAssistProperty() && paramInfo.getAssistProperty() != null) {
                fi.appendFilterItem("assistProperty.id", (Object)paramInfo.getAssistProperty());
            }
            if (paramInfo.isProject() && paramInfo.getProject() != null) {
                fi.appendFilterItem("project.id", (Object)paramInfo.getProject());
            }
            if (paramInfo.isTrackNumber() && paramInfo.getTrackNumber() != null) {
                fi.appendFilterItem("trackNumber.id", (Object)paramInfo.getTrackNumber());
            }
        }
        evi.setFilter(fi);
        return evi;
    }

    private BigDecimal getMoveAveragePrice(PriceParamInfo paramInfo) throws BOSException, EASBizException {
        String calType = paramInfo.getCalType();
        if (calType == null || !this.isValidCalType(calType) || "2".equals(calType) && paramInfo.getIssueWarehsInfo() == null) {
            return null;
        }
        String companyId = null;
        String souId = null;
        if (paramInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
            companyId = paramInfo.getCompanyOrgUnit().getId().toString();
            souId = paramInfo.getStorageOrgUnit().getId().toString();
        } else if (paramInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
            if (paramInfo.getIssueCompanyOrgUnitInfo() != null && paramInfo.getIssueStorageOrgUnitInfo().getId() != null) {
                companyId = paramInfo.getIssueCompanyOrgUnitInfo().getId().toString();
                souId = paramInfo.getIssueStorageOrgUnitInfo().getId().toString();
            }
        } else if (paramInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.RequireSide) && paramInfo.getRequireCompanyOrgUnitInfo() != null && paramInfo.getRequireStorageOrgUnitInfo().getId() != null) {
            companyId = paramInfo.getRequireCompanyOrgUnitInfo().getId().toString();
            souId = paramInfo.getRequireStorageOrgUnitInfo().getId().toString();
        }
        String materialId = paramInfo.getMateial().getId().toString();
        String key = materialId + companyId;
        if ("1".equals(calType)) {
            key = key + souId;
        } else if ("2".equals(calType)) {
            key = key + souId;
            key = key + paramInfo.getIssueWarehsInfo().getId().toString();
        }
        return (BigDecimal)this.mapMAP.get(key);
    }

    private boolean isValidCalType(String calType) {
        return calType.equals("0") || calType.equals("1") || calType.equals("2");
    }

    @Override
    protected PriceInfo[] _getPrice(PriceParamInfo[] paramInfos) throws BOSException, EASBizException {
        this.cacheMoveAveragePrice(this.ctx, paramInfos);
        PriceInfo[] priceInfos = new PriceInfo[paramInfos.length];
        int length = paramInfos.length;
        for (int i = 0; i < length; ++i) {
            if (paramInfos[i] == null) continue;
            priceInfos[i] = this.getPrice(paramInfos[i]);
        }
        return priceInfos;
    }
}

