/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.im.inv.app.AbstractConverteQtyFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.util.ConverteQtyInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ConverteQtyFacadeControllerBean
extends AbstractConverteQtyFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.ConverteQtyFacadeControllerBean");
    private static final long serialVersionUID = 1L;

    @Override
    protected List _processDynQty(Context ctx, List params) throws BOSException, EASBizException {
        String tempTable = DBUtil.createTempTable((Context)ctx, (String)"ConVerte", (String[][])this.getConterteQtyTempTableFields());
        String tempInventoryTable = DBUtil.createTempTable((Context)ctx, (String)"Inventoy", (String[][])this.getInventoryTempTableFields());
        this.insertConverteQty(ctx, tempTable, params);
        this.insertInventory(ctx, tempInventoryTable, tempTable);
        this.updateTempTable(ctx, tempTable);
        this.processConverteQty(ctx, tempTable, tempInventoryTable);
        List list = this.getConverteQtyList(ctx, tempTable);
        return list;
    }

    private List getConverteQtyList(Context ctx, String tempTable) throws BOSException {
        ArrayList<ConverteQtyInfo> arrayList;
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT * FROM ").append(tempTable);
        Connection conn = null;
        PreparedStatement pm = null;
        ResultSet rs = null;
        ArrayList<ConverteQtyInfo> list = new ArrayList<ConverteQtyInfo>();
        ConverteQtyInfo converteQtyInfo = null;
        try {
            conn = this.getConnection(ctx);
            pm = conn.prepareStatement(bf.toString());
            rs = pm.executeQuery();
            while (rs.next()) {
                converteQtyInfo = new ConverteQtyInfo();
                converteQtyInfo.setId(rs.getString("FID"));
                converteQtyInfo.setMaterialID(rs.getString("FMaterialID"));
                converteQtyInfo.setWarehouseID(rs.getString("FWarehouseID"));
                converteQtyInfo.setStorageOrgUnitID(rs.getString("FStorageOrgUnitID"));
                converteQtyInfo.setStoreTypeID(rs.getString("FStoreTypeID"));
                converteQtyInfo.setStoreStatusID(rs.getString("FStoreStatusID"));
                converteQtyInfo.setQty(rs.getBigDecimal("FQty"));
                converteQtyInfo.setBaseQty(rs.getBigDecimal("FBaseQty"));
                converteQtyInfo.setAssistQty(rs.getBigDecimal("FAssistQty"));
                converteQtyInfo.setQtyPrecision(rs.getInt("FQtyPrecision"));
                converteQtyInfo.setSeq(rs.getInt("FSeq"));
                converteQtyInfo.setAsstAttrPropertyID(rs.getString("FAssistpropertyID"));
                converteQtyInfo.setLot(rs.getString("FLot"));
                list.add(converteQtyInfo);
            }
            arrayList = list;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm}, (ResultSet[])new ResultSet[]{rs});
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm}, (ResultSet[])new ResultSet[]{rs});
        return arrayList;
    }

    private void insertConverteQty(Context ctx, String tempTable, List params) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append(" INSERT INTO ").append(tempTable).append("\r\n");
        bf.append("(FID,FMaterialID,FWarehouseID,FStorageOrgUnitID,FStoreTypeID,FStoreStatusID");
        bf.append(",FBaseUnitID,FAssistQty,FQtyPrecision,FSeq,FLot,FAssistpropertyID) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        String inserSQL = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        try {
            conn = this.getConnection(ctx);
            pm = conn.prepareStatement(inserSQL);
            for (ConverteQtyInfo converteQtyInfo : params) {
                pm.setString(1, this.getId());
                pm.setString(2, converteQtyInfo.getMaterialID());
                pm.setString(3, converteQtyInfo.getWarehouseID());
                pm.setString(4, converteQtyInfo.getStorageOrgUnitID());
                pm.setString(5, converteQtyInfo.getStoreTypeID());
                pm.setString(6, converteQtyInfo.getStoreStatusID());
                pm.setString(7, converteQtyInfo.getBaseUnitID());
                pm.setBigDecimal(8, converteQtyInfo.getAssistQty());
                pm.setInt(9, converteQtyInfo.getQtyPrecision());
                pm.setInt(10, converteQtyInfo.getSeq());
                pm.setString(11, converteQtyInfo.getLot() == null ? null : converteQtyInfo.getLot());
                pm.setString(12, converteQtyInfo.getAsstAttrPropertyID() == null ? null : converteQtyInfo.getAsstAttrPropertyID());
                pm.addBatch();
            }
            pm.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm}, null);
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm}, null);
    }

    private void insertInventory(Context ctx, String tempInventoryTable, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ").append(tempInventoryTable);
        bf.append(" (FID,FStorageOrgUnitID,FMaterialID,FWarehouseID,FStoreTypeID");
        bf.append(",FStoreStatusID,FCurStoreQty,FCurStoreAssistQty,FBaseQty,FBaseQtyConvertRate,FQtyConvertRate,FLot,FAssistpropertyID)");
        bf.append("\r\n");
        bf.append("SELECT NEWBOSID('88888888'),a.FStorageOrgUnitID as FStorageOrgUnitID,a.FMaterialID as FMaterialID,a.FWarehouseID as FWarehouseID ").append("\r\n");
        bf.append(",a.FStoreTypeID as FStoreTypeID,a.FStoreStatusID as FStoreStatusID, SUM(a.FCurStoreQty) AS FCurStoreQty").append("\r\n");
        bf.append(",SUM(a.FCurStoreAssistQty) AS FCurStoreAssistQty,SUM(a.FBaseQty) AS FBaseQty").append("\r\n");
        bf.append(" ,CASE WHEN SUM(a.FCurStoreAssistQty) = 0 THEN").append("\r\n");
        bf.append(" 1 ");
        bf.append(" ELSE ").append("\r\n");
        bf.append(CalculateUtil.TO_DECIMAL_DIVIDE((String)(CalculateUtil.TO_DECIMAL_SUM((String)"SUM(a.FBaseQty)") + "/" + CalculateUtil.TO_DECIMAL_QTY((String)"SUM(a.FCurStoreAssistQty)")))).append(" END AS FBaseQtyConvertRate");
        bf.append(" ,CASE WHEN SUM(a.FCurStoreAssistQty) = 0 THEN").append("\r\n");
        bf.append(" 1 ");
        bf.append(" ELSE ").append("\r\n");
        bf.append(CalculateUtil.TO_DECIMAL_DIVIDE((String)(CalculateUtil.TO_DECIMAL_SUM((String)"SUM(a.FCurStoreQty)") + "/" + CalculateUtil.TO_DECIMAL_QTY((String)"SUM(a.FCurStoreAssistQty)")))).append(" END AS FQtyConvertRate");
        bf.append(" ,case when  b.flot is null then N'YNi0IQEOEADgBT3mfwAAAcznrtQ='  else  a.FLot end as FLot ,case when  b.FAssistpropertyID is null then 'EgkAAAA5EWALxvQu'  else  a.FAssistpropertyID end as FAssistpropertyID");
        bf.append(" FROM T_IM_Inventory a").append("\r\n");
        bf.append(" inner join ").append(tempTable).append(" b on ").append("\r\n");
        bf.append("  a.FStorageOrgUnitID = b.FStorageOrgUnitID and ");
        bf.append("  a.FStoreTypeID = b.FStoreTypeID and ");
        bf.append("  a.FStoreStatusID = b.FStoreStatusID and ");
        bf.append("  a.FMaterialID = b.FMaterialID and ");
        bf.append("  a.FWarehouseID = b.FWarehouseID and ");
        bf.append("  a.flot = isnull(b.Flot,a.flot) and");
        bf.append("  a.FAssistpropertyID = isnull(b.FAssistpropertyID,a.FAssistpropertyID)");
        bf.append(" GROUP BY a.FStorageOrgUnitID,a.FMaterialID,a.FWarehouseID,a.FStoreTypeID,a.FStoreStatusID,case when  b.flot is null then N'YNi0IQEOEADgBT3mfwAAAcznrtQ='  else  a.FLot end ,case when  b.FAssistpropertyID is null then 'EgkAAAA5EWALxvQu'  else  a.FAssistpropertyID end").append("\r\n");
        DBUtil.execute((Context)ctx, (String)bf.toString());
    }

    private void updateTempTable(Context ctx, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTable).append(" AS T").append("\r\n");
        bf.append(" SET(FQtyPrecision) = (").append("\r\n");
        bf.append(" SELECT MULTIBASEUNIT.FQtyPrecision AS FQtyPrecision").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT");
        bf.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT").append("\r\n");
        bf.append(" ON (TempT.FMaterialID = MULTIBASEUNIT.FMaterialID");
        bf.append(" AND TempT.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID)").append("\r\n");
        bf.append(" WHERE T.FSeq = TempT.FSeq)");
        DBUtil.execute((Context)ctx, (String)bf.toString());
    }

    private void processConverteQty(Context ctx, String tempTable, String tempInventoryTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTable).append(" AS T1").append("\r\n");
        bf.append(" SET(FQtyConvertRate,FBaseQtyConvertRate,FQty,FBaseQty) = (").append("\r\n");
        bf.append(" SELECT TempT.FQtyConvertRate,TempT.FBaseQtyConvertRate").append("\r\n");
        bf.append(",ROUND(").append(CalculateUtil.TO_DECIMAL_QTY((String)"T2.FAssistQty*TempT.FQtyConvertRate")).append(",T2.FQtyPrecision)").append("\r\n");
        bf.append(",ROUND(").append(CalculateUtil.TO_DECIMAL_QTY((String)"T2.FAssistQty*TempT.FBaseQtyConvertRate")).append(",T2.FQtyPrecision)").append("\r\n");
        bf.append(" FROM ").append(tempInventoryTable).append(" AS TempT");
        bf.append(" INNER JOIN ").append(tempTable).append(" AS T2");
        bf.append(" ON T2.FStorageOrgUnitID = TempT.FStorageOrgUnitID").append("\r\n");
        bf.append(" AND T2.FMaterialID = TempT.FMaterialID").append("\r\n");
        bf.append(" AND T2.FWarehouseID = TempT.FWarehouseID").append("\r\n");
        bf.append(" AND T2.FStoreTypeID = TempT.FStoreTypeID").append("\r\n");
        bf.append(" AND T2.FStoreStatusID = TempT.FStoreStatusID").append("\r\n");
        bf.append(" AND isnull(T2.FLot,'YNi0IQEOEADgBT3mfwAAAcznrtQ=') = TempT.FLot").append("\r\n");
        bf.append(" AND isnull(T2.FAssistpropertyID,'EgkAAAA5EWALxvQu') = TempT.FAssistpropertyID").append("\r\n");
        bf.append(" WHERE T1.FSeq = T2.FSeq)");
        DBUtil.execute((Context)ctx, (String)bf.toString());
    }

    private String getInventoryTempTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ").append(tempTable).append(" (");
        sql.append("FID Varchar(44),").append("\r\n");
        sql.append("FStorageOrgUnitID Varchar(44),").append("\r\n");
        sql.append("FMaterialID Varchar(44),").append("\r\n");
        sql.append("FWarehouseID Varchar(44),").append("\r\n");
        sql.append("FStoreTypeID Varchar(44),").append("\r\n");
        sql.append("FStoreStatusID Varchar(44),").append("\r\n");
        sql.append("FCurStoreQty Decimal(28,10) Not Null Default 0,").append("\r\n");
        sql.append("FCurStoreAssistQty Decimal(28,10) Not Null Default 0,").append("\r\n");
        sql.append("FBaseQty Decimal(28,10) Not Null Default 0,").append("\r\n");
        sql.append("FQtyConvertRate Decimal(28,10) Not Null Default 0,").append("\r\n");
        sql.append("FBaseQtyConvertRate Decimal(28,10) Not Null Default 0,").append("\r\n");
        sql.append("FQtyPrecision int,").append("\r\n");
        sql.append("FBaseQtyPrecision int").append("\r\n");
        sql.append(" );");
        return sql.toString();
    }

    public String[][] getInventoryTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44)"}, {"FMaterialID", "VARCHAR(44)"}, {"FWarehouseID", "VARCHAR(44)"}, {"FStorageOrgUnitID", "VARCHAR(44)"}, {"FStoreTypeID", "VARCHAR(44)"}, {"FStoreStatusID", "VARCHAR(44)"}, {"FCurStoreQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FCurStoreAssistQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FQtyConvertRate", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQtyConvertRate", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FLot", "VARCHAR(255)"}, {"FAssistpropertyID", "VARCHAR(44)"}};
        return fields;
    }

    public String[][] getConterteQtyTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44)"}, {"FMaterialID", "VARCHAR(44)"}, {"FWarehouseID", "VARCHAR(44)"}, {"FStorageOrgUnitID", "VARCHAR(44)"}, {"FStoreTypeID", "VARCHAR(44)"}, {"FStoreStatusID", "VARCHAR(44)"}, {"FBaseUnitID", "VARCHAR(44)"}, {"FAssistQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FQtyConvertRate", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQtyConvertRate", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FQtyPrecision", "INT DEFAULT 2"}, {"FSeq", "INT"}, {"FLot", "VARCHAR(255)"}, {"FAssistpropertyID", "VARCHAR(44)"}};
        return fields;
    }

    private String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    private String getId() {
        BOSObjectType bosType = BOSObjectType.create((String)"FC910EF3");
        return bosType.toString();
    }
}

