/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.CountingTableEntryCollection;
import com.kingdee.eas.scm.im.inv.CountingTableEntryFactory;
import com.kingdee.eas.scm.im.inv.CountingTableInfo;
import com.kingdee.eas.scm.im.inv.ICountingTableEntry;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.app.AbstractCountingTableControllerBean;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class CountingTableControllerBean
extends AbstractCountingTableControllerBean {
    private static final long serialVersionUID = 1L;
    private static final String IS_BASEUNIT_UPDATE = "isBaseUpdate";
    private static final String IS_AR_UPDATE = "isArUpdate";
    protected static final String OUT_EFFECT = "OUT_EFFECT";
    protected static final String IN_EFFECT = "IN_EFFECT";
    private static final String IS_INVENTORY = "isInventory";
    private static final String FILTERDATE = "filterDate";
    private static final String OVERDATE = "overDate";

    @Override
    public IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (pk == null) {
            return null;
        }
        CountingTableInfo aCountingTableInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("warehouse.id"));
        sic.add(new SelectorItemInfo("warehouse.name"));
        sic.add(new SelectorItemInfo("warehouse.number"));
        sic.add(new SelectorItemInfo("warehouse.whState"));
        sic.add(new SelectorItemInfo("warehouse.transState"));
        sic.add(new SelectorItemInfo("warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("warehouse.hasLocationLevel"));
        sic.add(new SelectorItemInfo("countingPerson.id"));
        sic.add(new SelectorItemInfo("countingPerson.name"));
        sic.add(new SelectorItemInfo("countingPerson.number"));
        sic.add(new SelectorItemInfo("countingAgainPerson.id"));
        sic.add(new SelectorItemInfo("countingAgainPerson.name"));
        sic.add(new SelectorItemInfo("countingAgainPerson.number"));
        sic.add(new SelectorItemInfo("countingMonitorer.id"));
        sic.add(new SelectorItemInfo("countingMonitorer.name"));
        sic.add(new SelectorItemInfo("countingMonitorer.number"));
        SorterItemCollection sortcoll = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("warehouse.number");
        sortcoll.add(sortItem);
        aCountingTableInfo = (CountingTableInfo)super.getValue(ctx, pk, sic, sortcoll);
        String taskid = "";
        if (aCountingTableInfo != null && aCountingTableInfo.getCountingTask() != null && aCountingTableInfo.getCountingTask().getId() != null) {
            taskid = aCountingTableInfo.getCountingTask().getId().toString();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection siceEtry = viewInfo.getSelector();
        siceEtry.add(new SelectorItemInfo("location.id"));
        siceEtry.add(new SelectorItemInfo("location.name"));
        siceEtry.add(new SelectorItemInfo("location.number"));
        siceEtry.add(new SelectorItemInfo("storeType.id"));
        siceEtry.add(new SelectorItemInfo("storeType.name"));
        siceEtry.add(new SelectorItemInfo("storeType.number"));
        siceEtry.add(new SelectorItemInfo("unit.id"));
        siceEtry.add(new SelectorItemInfo("unit.name"));
        siceEtry.add(new SelectorItemInfo("unit.number"));
        siceEtry.add(new SelectorItemInfo("assistUnit.id"));
        siceEtry.add(new SelectorItemInfo("assistUnit.name"));
        siceEtry.add(new SelectorItemInfo("assistUnit.number"));
        siceEtry.add(new SelectorItemInfo("material.id"));
        siceEtry.add(new SelectorItemInfo("material.name"));
        siceEtry.add(new SelectorItemInfo("material.number"));
        siceEtry.add(new SelectorItemInfo("material.model"));
        siceEtry.add(new SelectorItemInfo("material.longNumber"));
        siceEtry.add(new SelectorItemInfo("material.simpleName"));
        siceEtry.add(new SelectorItemInfo("material.baseUnit.id"));
        siceEtry.add(new SelectorItemInfo("material.baseUnit.name"));
        siceEtry.add(new SelectorItemInfo("material.baseUnit.number"));
        siceEtry.add(new SelectorItemInfo("material.assistUnit.id"));
        siceEtry.add(new SelectorItemInfo("material.assistUnit.name"));
        siceEtry.add(new SelectorItemInfo("material.assistUnit.number"));
        siceEtry.add(new SelectorItemInfo("material.assistAttr.id"));
        siceEtry.add(new SelectorItemInfo("material.assistAttr.name"));
        siceEtry.add(new SelectorItemInfo("material.assistAttr.number"));
        siceEtry.add(new SelectorItemInfo("assistProperty.id"));
        siceEtry.add(new SelectorItemInfo("assistProperty.name"));
        siceEtry.add(new SelectorItemInfo("assistProperty.number"));
        siceEtry.add(new SelectorItemInfo("assistProperty.type"));
        siceEtry.add(new SelectorItemInfo("supplier.id"));
        siceEtry.add(new SelectorItemInfo("supplier.name"));
        siceEtry.add(new SelectorItemInfo("supplier.number"));
        siceEtry.add(new SelectorItemInfo("customer.id"));
        siceEtry.add(new SelectorItemInfo("customer.name"));
        siceEtry.add(new SelectorItemInfo("customer.number"));
        siceEtry.add(new SelectorItemInfo("project.id"));
        siceEtry.add(new SelectorItemInfo("project.name"));
        siceEtry.add(new SelectorItemInfo("project.number"));
        siceEtry.add(new SelectorItemInfo("trackNumber.id"));
        siceEtry.add(new SelectorItemInfo("trackNumber.name"));
        siceEtry.add(new SelectorItemInfo("trackNumber.number"));
        siceEtry.add(new SelectorItemInfo("storeStatus.id"));
        siceEtry.add(new SelectorItemInfo("storeStatus.name"));
        siceEtry.add(new SelectorItemInfo("storeStatus.number"));
        siceEtry.add(new SelectorItemInfo("baseUnit.id"));
        siceEtry.add(new SelectorItemInfo("baseUnit.name"));
        siceEtry.add(new SelectorItemInfo("baseUnit.number"));
        siceEtry.add(new SelectorItemInfo("invUnit.id"));
        siceEtry.add(new SelectorItemInfo("invUnit.name"));
        siceEtry.add(new SelectorItemInfo("invUnit.number"));
        siceEtry.add(new SelectorItemInfo("mfg"));
        siceEtry.add(new SelectorItemInfo("exp"));
        siceEtry.add(new SelectorItemInfo("*"));
        SelectorItemInfo sicItem = null;
        String propertyName = null;
        int index = -1;
        for (int i = 0; i < selector.size(); ++i) {
            sicItem = selector.get(i);
            propertyName = sicItem.getPropertyName();
            index = propertyName.indexOf("entry.");
            if (propertyName == null || index <= -1) continue;
            propertyName = propertyName.substring(index + 6);
            siceEtry.add(new SelectorItemInfo(propertyName));
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo itemInfo = new FilterItemInfo("parent", (Object)pk.toString());
        filterInfo.getFilterItems().add(itemInfo);
        viewInfo.setFilter(filterInfo);
        SorterItemInfo sortItema = new SorterItemInfo("seq");
        viewInfo.getSorter().add(sortItema);
        String sort = this.replaceSortPropertiesToEntry(this.getCountingSort(ctx, taskid));
        String[][] item = this.getSortItem(sort);
        if (item != null) {
            int size = item.length;
            for (int i = 0; i < size; ++i) {
                SorterItemInfo sortItemInfo = new SorterItemInfo(item[i][0]);
                sortItemInfo.setSortType(SortType.getEnum((String)item[i][1]));
                viewInfo.getSorter().add(sortItemInfo);
            }
        }
        ICountingTableEntry ientry = CountingTableEntryFactory.getLocalInstance(ctx);
        CountingTableEntryCollection coll = ientry.getCountingTableEntryCollection(viewInfo);
        aCountingTableInfo.getEntry().clear();
        aCountingTableInfo.getEntry().addCollection(coll);
        return aCountingTableInfo;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String log = "";
        if (pk == null) {
            return log;
        }
        CountingTableInfo aCountingTableInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("countingTask.number"));
        aCountingTableInfo = this.getCountingTableInfo(ctx, pk, sic);
        if (aCountingTableInfo.getCountingTask() != null) {
            log = aCountingTableInfo.getCountingTask().getNumber();
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCountingSort(Context ctx, String pk) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FSORT FROM T_IM_COUNTINGTASKSORT WHERE FCOUNTINGTASKID = '").append(pk).append("'");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (result.next()) {
                String string = result.getString("FSORT");
                return string;
            }
        }
        catch (SQLException e) {
            String string = null;
            return string;
        }
        finally {
            SQLUtils.cleanup((ResultSet)result);
        }
        return null;
    }

    private String replaceSortPropertiesToEntry(String sort) {
        if (sort == null || sort.length() == 0) {
            return null;
        }
        sort = sort.replaceAll("material.number", "material.number");
        sort = sort.replaceAll("material.model", "material.model");
        sort = sort.replaceAll("material.name", "material.name");
        sort = sort.replaceAll("unit.name", "unit.name");
        sort = sort.replaceAll("baseUnit.name", "baseUnit.name");
        sort = sort.replaceAll("entry.lot", "lot");
        sort = sort.replaceAll("location.number", "location.number");
        sort = sort.replaceAll("assistProperty.id", "assistProperty.id");
        sort = sort.replaceAll("storeType.number", "storeType.number");
        sort = sort.replaceAll("storeStatus.number", "storeStatus.number");
        sort = sort.replaceAll("supplier.id", "supplier.id");
        sort = sort.replaceAll("customer.id", "customer.id");
        return sort;
    }

    private String[][] getSortItem(String sort) {
        if (sort == null) {
            return null;
        }
        String[] sortItems = sort.split(",");
        int size = sortItems.length;
        String[][] items = new String[size][2];
        for (int i = 0; i < size; ++i) {
            items[i][0] = sortItems[i].substring(0, sortItems[i].indexOf(" "));
            items[i][1] = sortItems[i].substring(sortItems[i].indexOf(" ") + 1);
        }
        return items;
    }

    @Override
    protected void _updateCountingPerson(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        CountingTableInfo aCountingTableInfo = (CountingTableInfo)model;
        String CountingPersonid = "";
        String CountingAgainPersonid = "";
        String CountingMonitorerid = "";
        String countingtaskid = "";
        String description = "";
        Timestamp beginTime = null;
        Timestamp endTime = null;
        if (aCountingTableInfo.getCountingPerson() != null && aCountingTableInfo.getCountingPerson().getId() != null) {
            CountingPersonid = aCountingTableInfo.getCountingPerson().getId().toString();
        }
        if (aCountingTableInfo.getCountingAgainPerson() != null && aCountingTableInfo.getCountingAgainPerson().getId() != null) {
            CountingAgainPersonid = aCountingTableInfo.getCountingAgainPerson().getId().toString();
        }
        if (aCountingTableInfo.getCountingMonitorer() != null && aCountingTableInfo.getCountingMonitorer().getId() != null) {
            CountingMonitorerid = aCountingTableInfo.getCountingMonitorer().getId().toString();
        }
        if (aCountingTableInfo.getCountingTask() != null && aCountingTableInfo.getCountingTask().getId() != null) {
            countingtaskid = aCountingTableInfo.getCountingTask().getId().toString();
        }
        if (aCountingTableInfo.getDescription() != null) {
            description = aCountingTableInfo.getDescription();
        }
        if (aCountingTableInfo.getTaskBeginTime() != null) {
            beginTime = aCountingTableInfo.getTaskBeginTime();
        }
        if (aCountingTableInfo.getTaskEndTime() != null) {
            endTime = aCountingTableInfo.getTaskEndTime();
        }
        String[] sqls = new String[5];
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_COUNTINGTABLE SET ");
        sql.append("      FCOUNTINGPERSONID = '").append(CountingPersonid).append("',");
        sql.append(" FCOUNTINGAGAINPERSONID = '").append(CountingAgainPersonid).append("',");
        sql.append("   FCOUNTINGMONITORERID = '").append(CountingMonitorerid).append("'");
        sql.append(" WHERE FCOUNTINGPERSONID IS NULL      AND FCOUNTINGAGAINPERSONID IS NULL");
        sql.append("   AND FCOUNTINGMONITORERID IS NULL   AND FCOUNTINGTASKID = '").append(countingtaskid).append("'");
        sqls[0] = sql.toString();
        sql = new StringBuffer();
        sql.append("UPDATE T_IM_COUNTINGTABLE SET ");
        sql.append("      FCOUNTINGPERSONID = '").append(CountingPersonid).append("'");
        sql.append(" WHERE FCOUNTINGPERSONID IS NULL     ");
        sql.append("   AND FCOUNTINGTASKID = '").append(countingtaskid).append("'");
        sqls[1] = sql.toString();
        sql = new StringBuffer();
        sql.append("UPDATE T_IM_COUNTINGTABLE SET ");
        sql.append(" FCOUNTINGAGAINPERSONID = '").append(CountingAgainPersonid).append("'");
        sql.append(" WHERE FCOUNTINGAGAINPERSONID IS NULL");
        sql.append("   AND FCOUNTINGTASKID = '").append(countingtaskid).append("'");
        sqls[2] = sql.toString();
        sql = new StringBuffer();
        sql.append("UPDATE T_IM_COUNTINGTABLE SET ");
        sql.append("   FCOUNTINGMONITORERID = '").append(CountingMonitorerid).append("'");
        sql.append(" WHERE FCOUNTINGMONITORERID IS NULL AND FCOUNTINGTASKID = '").append(countingtaskid).append("'");
        sqls[3] = sql.toString();
        sql = new StringBuffer();
        sql.append("UPDATE T_IM_COUNTINGTABLE SET ");
        sql.append("   FDESCRIPTION = '").append(description).append("'");
        sql.append(" WHERE FDESCRIPTION IS NULL AND FCOUNTINGTASKID = '").append(countingtaskid).append("'");
        sqls[4] = sql.toString();
        try {
            if (beginTime != null) {
                sql = new StringBuffer();
                sql.append("UPDATE T_IM_COUNTINGTABLE SET ");
                sql.append(" FTASKBEGINTIME = ?");
                sql.append(" WHERE FTASKBEGINTIME IS NULL AND FCOUNTINGTASKID = ?");
                String sqlStr = sql.toString();
                DbUtil.execute((Context)ctx, (String)sqlStr, (Object[])new Object[]{beginTime, countingtaskid});
            }
            if (endTime != null) {
                sql = new StringBuffer();
                sql.append("UPDATE T_IM_COUNTINGTABLE SET ");
                sql.append(" FTASKENDTIME = ?");
                sql.append(" WHERE FTASKENDTIME IS NULL AND FCOUNTINGTASKID = ?");
                String sqlUpdate = sql.toString();
                DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{endTime, countingtaskid});
            }
            com.kingdee.eas.dynbusiness.util.DBUtil.executeBatch((Context)ctx, (String[])sqls);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected RptRowSet _getBillAdjustResultSet(Context ctx, Map hm) throws BOSException, EASBizException {
        String tempTableName = null;
        RptRowSet rs = null;
        tempTableName = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateTempTableSql());
        DbUtil.execute((Context)ctx, (String)("delete from  " + tempTableName));
        String sqlWhere = this.getFilterSQL(hm);
        this.insertBillData(ctx, hm, tempTableName, sqlWhere);
        String sqlFilter = this.getFilterSQLBy4Condition(hm);
        rs = this.getFinalDate(ctx, tempTableName, sqlFilter);
        return rs;
    }

    private RptRowSet getFinalDate(Context ctx, String tempTable, String msWhere) throws BOSException, EASBizException {
        Locale loc = ctx.getLocale();
        StringBuffer finalSQL = new StringBuffer();
        RptRowSet rowSet = null;
        finalSQL.append("SELECT UNIT.FQtyPrecision,BUNIT.FQtyPrecision,AUNIT.FQtyPrecision,");
        finalSQL.append(" null as isCheck, A.FBizDate, TO_CHAR(A.FBillBizDate, 'yyyy-MM-dd'), B.FNAME_").append(loc).append(", A.FBillNum, A.Fseq, ");
        finalSQL.append(" D.FNumber, D.FNAME_").append(loc).append(", D.FMODEL, ");
        finalSQL.append(" ASSIST.FNAME_").append(loc).append(" ,A.FLot, UNIT.FName_").append(loc).append(", ");
        finalSQL.append("round(A.FQty,UNIT.FQtyPrecision) FQty, BUNIT.FName_").append(loc).append(", ");
        finalSQL.append("round(A.FBaseQty,BUNIT.FQtyPrecision) FBaseQty, A.FFlag,  ");
        finalSQL.append(" A.FMaterialID, A.FUnitID, A.FStorageOrgUnitID, A.FAssistPropertyID,AUNIT.FName_").append(loc).append(",ISNULL(A.FAssistQty,0) ");
        finalSQL.append(" from ");
        finalSQL.append(tempTable).append(" A ");
        finalSQL.append(" INNER JOIN T_SCM_BillType B ON A.FBillType = B.FID ");
        finalSQL.append(" INNER JOIN T_BD_Material  D ON A.FMaterialID = D.FID ");
        finalSQL.append(" INNER JOIN T_BD_MeasureUnit AS UNIT  ON A.FUnitID = UNIT.FID ");
        finalSQL.append(" INNER JOIN T_BD_MeasureUnit AS BUNIT ON A.FBaseUnitID = BUNIT.FID ");
        finalSQL.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSIST ON A.FAssistPropertyID = ASSIST.FID ");
        finalSQL.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS AUNIT ON A.FAssistUnitID = AUNIT.FID ");
        finalSQL.append(msWhere);
        finalSQL.append(" group by ");
        finalSQL.append(" A.FBizDate, A.FBillBizDate, B.FNAME_").append(loc).append(", A.FBillNum, A.Fseq, ");
        finalSQL.append(" D.FNumber, D.FNAME_").append(loc).append(", D.FMODEL,");
        finalSQL.append(" ASSIST.FNAME_").append(loc).append(" ,A.FLot, UNIT.FName_").append(loc).append(", A.FQty, BUNIT.FName_").append(loc).append(", A.FBaseQty, A.FFlag, ");
        finalSQL.append(" A.FMaterialID, A.FUnitID, A.FStorageOrgUnitID, A.FAssistPropertyID,AUNIT.FName_").append(loc).append(",A.FAssistQty ");
        finalSQL.append(",UNIT.FQtyPrecision, BUNIT.FQtyPrecision, AUNIT.FQtyPrecision");
        finalSQL.append(" ORDER BY A.FBizDate ASC");
        rowSet = this.executeQuery(finalSQL.toString(), null, ctx);
        return rowSet;
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (SqlParams)parameters, (int)0, (int)-1, (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    protected String getCreateTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table T_IM_Inventory_temp (").append("FCompanyOrgUnitID VARCHAR(44),").append("FStorageOrgUnitID VARCHAR(44),").append("FBizDate DATETIME,").append("FBillBizDate DATETIME,").append("FBillType VARCHAR(44),").append("FBillNum VARCHAR(80),").append("Fseq INT,").append("FFlag INT,").append("FWarehouseID VARCHAR(44),").append("FLocationID VARCHAR(44),").append("FStoreTypeID VARCHAR(44),").append("FStoreStatusID VARCHAR(44),").append("FLot NVARCHAR(80),").append("FSupplierID VARCHAR(44),").append("FCustomerID VARCHAR(44),").append("FMaterialID VARCHAR(44),").append("FUnitID VARCHAR(44),").append("FQty NUMERIC(28,16) DEFAULT 0,").append("FAssistUnitID VARCHAR(44),").append("FAssistQty NUMERIC(28,16),").append("FBaseQty NUMERIC(28,16) DEFAULT 0,").append("FBaseUnitID VARCHAR(44),").append("FAssistPropertyID VARCHAR(44));");
        return sql.toString();
    }

    public static String getFilterBeginDate(Date d) {
        Date bdate = new Date(d.getYear(), d.getMonth(), d.getDate());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(bdate);
    }

    private String getFilterSQL(Map hm) {
        String assistProperty;
        String aMeasureUnitID;
        MaterialInfo material;
        String aWarehouseID;
        StringBuffer sqlwh = new StringBuffer();
        boolean isInventory = (Boolean)hm.get(IS_INVENTORY);
        boolean isArUpdateInventory = (Boolean)hm.get(IS_AR_UPDATE);
        boolean isBaseUnitUpdate = (Boolean)hm.get(IS_BASEUNIT_UPDATE);
        String auditDate = "A.FAuditTime";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date filterDate = (Date)hm.get(FILTERDATE);
        Date overDate = (Date)hm.get(OVERDATE);
        sqlwh.append(" WHERE 1=1 ");
        if (isInventory && filterDate != null) {
            String ftDate = df.format(filterDate);
            sqlwh.append(" AND ").append(auditDate).append(" > to_date('").append(ftDate).append("') ");
        } else if (filterDate != null && overDate != null) {
            String ftDate = df.format(filterDate);
            String ovDate = CountingTableControllerBean.getFilterBeginDate(overDate);
            if (isArUpdateInventory) {
                sqlwh.append(" AND ((CONVERT(DATETIME,TO_CHAR(A.FBizDate,'yyyy-MM-dd')) < to_date('").append(ovDate).append("') ");
                sqlwh.append(" \tAND ((").append(auditDate).append(" > to_date('").append(ftDate).append("') ");
                sqlwh.append("            AND A.FCreateTime < to_date('").append(ftDate).append("')) ");
                sqlwh.append("         OR (A.FCreateTime > to_date('").append(ftDate).append("'))) ");
                sqlwh.append(" ) OR ");
                sqlwh.append("     (CONVERT(DATETIME,TO_CHAR(A.FBizDate,'yyyy-MM-dd')) >= to_date('").append(ovDate).append("') ").append(" ))");
            } else {
                sqlwh.append(" AND ((A.FBizDate < to_date('").append(ovDate).append("') ");
                sqlwh.append(" \tAND ").append(auditDate).append(" > to_date('").append(ftDate).append("')) ");
                sqlwh.append("   OR ");
                sqlwh.append("  ( A.FBizDate >= to_date('").append(ovDate).append("') ").append(" ))");
            }
        }
        StorageOrgUnitInfo aStorageOrgUnitInfo = (StorageOrgUnitInfo)hm.get("STORAGEORGUNIT");
        if (aStorageOrgUnitInfo != null && aStorageOrgUnitInfo.getId() != null) {
            sqlwh.append(" AND B.FStorageOrgUnitID = '").append(aStorageOrgUnitInfo.getId().toString()).append("'");
        }
        if ((aWarehouseID = (String)hm.get("WAREHOUSE")) != null) {
            sqlwh.append(" AND B.FWarehouseID ='").append(aWarehouseID).append("'");
        }
        if ((material = (MaterialInfo)hm.get("MATERIAL")) != null && material.getId() != null) {
            sqlwh.append(" AND B.FMaterialID ='").append(material.getId().toString()).append("'");
        }
        if (!isBaseUnitUpdate && (aMeasureUnitID = (String)hm.get("UNIT")) != null) {
            sqlwh.append(" AND B.FUnitID ='").append(aMeasureUnitID).append("'");
        }
        if ((assistProperty = (String)hm.get("ASSISTANTATTR")) != null) {
            sqlwh.append(" AND B.FAssistPropertyID ='").append(assistProperty).append("'");
        }
        return sqlwh.toString();
    }

    private String getFilterSQLBy4Condition(Map hm) {
        String supplierID;
        String customerID;
        String storeStateID;
        String storeTypeID;
        String aLocationID;
        StringBuffer sqlwh = new StringBuffer();
        sqlwh.append(" WHERE 1=1 ");
        String lot = (String)hm.get("BATCH");
        if (lot != null) {
            sqlwh.append(" AND A.FLot ='").append(lot).append("'");
        }
        if ((aLocationID = (String)hm.get("LOCATION")) != null) {
            sqlwh.append(" AND A.FLocationID ='").append(aLocationID).append("'");
        }
        if ((storeTypeID = (String)hm.get("STORETYPE")) != null) {
            sqlwh.append(" AND A.FStoreTypeID ='").append(storeTypeID).append("'");
        }
        if ((storeStateID = (String)hm.get("STORESTATE")) != null) {
            sqlwh.append(" AND A.FStoreStatusID ='").append(storeStateID).append("'");
        }
        if ((customerID = (String)hm.get("CUSTOMER")) != null) {
            sqlwh.append(" AND A.FCustomerID ='").append(customerID).append("'");
        }
        if ((supplierID = (String)hm.get("SUPPLIER")) != null) {
            sqlwh.append(" AND A.FSupplierID ='").append(supplierID).append("'");
        }
        return sqlwh.toString();
    }

    private void insertBillData(Context ctx, Map params, String tempTable, String msWhere) throws BOSException, EASBizException {
        StringBuffer sqlIn = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        String[][] tableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}, {"T_IM_PurReceivalBill", "T_IM_PurReceivalEntry"}, {"T_IM_InventoryInitBill", "T_IM_InventoryInitEntry"}, {"T_IM_MoveLocationBill", "T_IM_MoveLocationBillEntry"}, {"T_IM_InvStateAdjustBill", "T_IM_InvStateAdjustBillEntry"}};
        sqlIn.append("insert into ").append(tempTable).append(" ");
        sqlIn.append("(fcompanyorgunitid,fstorageorgunitid,fmaterialid,funitid,fbaseunitid,");
        sqlIn.append("fassistunitid,fassistpropertyid,fstoretypeid,fstorestatusid,fsupplierid,fcustomerid,");
        sqlIn.append("fwarehouseid,flocationid,flot,fqty,fbaseqty,fassistqty,fbizdate,FBillBizDate, fbilltype, fbillnum, fseq, FFlag) ");
        int billCount = tableName.length;
        boolean isArUpdateInventory = (Boolean)params.get(IS_AR_UPDATE);
        boolean isInventory = (Boolean)params.get(IS_INVENTORY);
        String[] sqls = isArUpdateInventory ? new String[billCount * 2 + 2] : new String[billCount * 2 + 1];
        for (int i = 0; i < billCount; ++i) {
            sql = new StringBuffer();
            sql.append(sqlIn).append(this.getBillSql2(tableName[i][0], tableName[i][1], msWhere, IN_EFFECT, isArUpdateInventory, isInventory));
            sqls[i] = sql.toString();
            sql = new StringBuffer();
            sql.append(sqlIn).append(this.getBillSql2(tableName[i][0], tableName[i][1], msWhere, OUT_EFFECT, isArUpdateInventory, isInventory));
            sqls[i + billCount] = sql.toString();
        }
        sqls[billCount * 2] = this.getDecomposeBillSql(sqlIn.toString(), msWhere, isInventory);
        if (isArUpdateInventory) {
            sqls[billCount * 2 + 1] = this.getArBillSql(sqlIn.toString(), msWhere, isInventory);
        }
        com.kingdee.eas.dynbusiness.util.DBUtil.executeBatch((Context)ctx, (String[])sqls);
    }

    protected String getBillSql2(String billHead, String billEntry, String msWhere, String effectString, boolean isArUpdateInventory, boolean isInventory) {
        String fieldStoreStatusId;
        String fieldStoreTypeId;
        String fieldLocationId;
        String fieldWarehouseId;
        String fieldSupplierId;
        String fieldCustomerId;
        StringBuffer sql = new StringBuffer();
        boolean isInEffect = IN_EFFECT.endsWith(effectString);
        boolean isOutEffect = OUT_EFFECT.endsWith(effectString);
        int customerValue = 3;
        int toCustomerValue = 4;
        int supplierValue = 2;
        int toSupplierValue = 5;
        if ("T_IM_SaleIssueBill".equals(billHead)) {
            fieldCustomerId = "a.FCustomerId";
            fieldSupplierId = "b.FSupplierId";
        } else if ("T_IM_PurInWarehsBill".equals(billHead)) {
            fieldCustomerId = "b.FCustomerId";
            fieldSupplierId = "a.FSupplierId";
        } else if ("T_IM_PurReceivalBill".equals(billHead)) {
            fieldCustomerId = "a.FCustomerId";
            fieldSupplierId = "a.FSupplierId";
        } else {
            fieldCustomerId = "b.FCustomerId";
            fieldSupplierId = "b.FSupplierId";
        }
        if ("T_IM_MoveLocationBill".equals(billHead) && isInEffect) {
            fieldWarehouseId = "b.FWarehouseId";
            fieldLocationId = "b.FReceiptLocationID";
        } else if ("T_IM_PurInWarehsBill".equals(billHead) && isOutEffect) {
            fieldWarehouseId = "b.FOutWarehouseId";
            fieldLocationId = "b.FOutLocationId";
        } else {
            fieldWarehouseId = "b.FWarehouseId";
            fieldLocationId = "b.FLocationId";
        }
        String fieldEffectQtyName = isInEffect ? "c.FExistingQty" : "c.FExistingQtyPre";
        String fieldEffectQty = "0";
        if (isInEffect) {
            fieldStoreTypeId = "c.FStoreTypeId";
            fieldStoreStatusId = "c.FStoreStateId";
            fieldEffectQty = "1";
            fieldEffectQty = fieldEffectQtyName;
        } else {
            fieldStoreTypeId = "c.FStoreTypePreId";
            fieldStoreStatusId = "c.FStoreStatePreId";
            fieldEffectQty = "-1";
            fieldEffectQty = fieldEffectQtyName;
        }
        if (SCMUtil.isInInvBillTable((String)billHead)) {
            fieldEffectQty = "1";
        }
        if (SCMUtil.isOutInvBillTable((String)billHead)) {
            fieldEffectQty = "-1";
        }
        if ("T_IM_MoveLocationBill".equals(billHead)) {
            fieldStoreTypeId = "b.FStoreTypeId";
            fieldStoreStatusId = "b.FStoreStatusId";
            if (isInEffect) {
                fieldWarehouseId = "b.FWarehouseId";
                fieldLocationId = "b.FReceiptLocationID";
                fieldEffectQty = "1";
            } else {
                fieldWarehouseId = "b.FWarehouseId";
                fieldLocationId = "b.FLocationId";
                fieldEffectQty = "-1";
            }
        }
        if ("T_IM_InvStateAdjustBill".equals(billHead)) {
            if (isInEffect) {
                fieldStoreTypeId = "b.FStoreTypeId";
                fieldStoreStatusId = "b.FDestStoreStatusID";
                fieldEffectQty = "1";
            } else {
                fieldStoreTypeId = "b.FStoreTypeId";
                fieldStoreStatusId = "b.FSrcStoreStatusID";
                fieldEffectQty = "-1";
            }
        }
        if ("T_IM_InventoryInitBill".equals(billHead)) {
            if (isInEffect) {
                fieldStoreTypeId = "b.FStoreTypeId";
                fieldStoreStatusId = "b.FStoreStatusId";
                fieldEffectQty = "1";
            } else {
                fieldStoreTypeId = "b.FStoreTypeId";
                fieldStoreStatusId = "b.FStoreStatusId";
                fieldEffectQty = "-1";
            }
        }
        String fbizdate = isInventory ? "a.faudittime ,a.FBizDate" : "a.fcreatetime ,a.FBizDate";
        sql.append("select b.fcompanyorgunitid,b.fstorageorgunitid,");
        sql.append("b.fmaterialid,b.funitid,b.fbaseunitid,b.fassistunitid,b.fassistpropertyid,");
        sql.append(fieldStoreTypeId + ",");
        sql.append(" isnull(").append(fieldStoreStatusId).append(",'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'), ");
        sql.append("case d.FStoreFlag when ").append(toSupplierValue).append(" then ").append(fieldSupplierId);
        sql.append(" when ").append(supplierValue).append(" then ").append(fieldSupplierId);
        sql.append(" else null end,");
        sql.append("case d.FStoreFlag when ").append(toCustomerValue).append(" then ").append(fieldCustomerId);
        sql.append(" when ").append(customerValue).append(" then ").append(fieldCustomerId);
        sql.append(" else null end,");
        sql.append(fieldWarehouseId).append(",");
        sql.append(fieldLocationId).append(",");
        sql.append(" b.FLot,");
        if (billHead.equals("T_IM_InventoryInitBill")) {
            sql.append("sum(case a.fisreversed when 1 then (-1)*").append(fieldEffectQty);
            sql.append(" * b.fqty else ").append(fieldEffectQty).append(" * b.fqty end) as fqty,");
            sql.append("sum(case a.fisreversed when 1 then (-1)*").append(fieldEffectQty);
            sql.append(" * b.fbaseqty else ").append(fieldEffectQty).append(" * b.fbaseqty end) as fbaseqty,");
            sql.append("sum(case a.fisreversed when 1 then (-1)*").append(fieldEffectQty);
            sql.append(" * b.fassistqty else ").append(fieldEffectQty).append(" * b.fassistqty end) as fassistqty, ");
        } else {
            sql.append("sum(b.fqty) as fqty,");
            sql.append("sum(b.fbaseqty) as fbaseqty,");
            sql.append("sum(b.fassistqty) as fassistqty, ");
        }
        sql.append(fbizdate);
        sql.append(" ,a.fbilltypeid, a.fnumber, b.fseq,  ");
        sql.append(fieldEffectQty).append(" as FFlag ");
        sql.append(" from ").append(billHead).append(" a,").append(billEntry).append(" b,");
        if (SCMUtil.isInInvBillTable((String)billHead) || SCMUtil.isOutInvBillTable((String)billHead)) {
            sql.append("t_im_invupdatetype c,t_im_storetype d ");
        } else {
            sql.append("t_im_storetype d ");
        }
        if ("T_IM_InventoryInitEntry".equals(billEntry)) {
            sql.append(",T_DB_SOAccreditWH sowh ");
        }
        sql.append(msWhere);
        sql.append(" and a.fid = b.fparentid and d.fid = ").append(fieldStoreTypeId);
        sql.append(" and a.fbasestatus = 4 and isnull(a.fisinitbill,0) = 0 ");
        if (SCMUtil.isInInvBillTable((String)billHead) || SCMUtil.isOutInvBillTable((String)billHead)) {
            sql.append(" and c.FIsNotUpdateInv=0 and " + fieldEffectQtyName + "=1");
            sql.append(" and b.finvupdatetypeid=c.fid");
            sql.append(" and " + fieldStoreTypeId + "=d.fid");
        } else {
            sql.append(" and " + fieldStoreTypeId + "=d.fid");
        }
        if ("T_IM_InventoryInitEntry".equals(billEntry)) {
            sql.append(" and sowh.FWareHouseID = b.FWarehouseID and sowh.FstorageOrgID = b.fstorageorgunitid and sowh.FIsStarted = 0 ");
        }
        sql.append(" group by b.fcompanyorgunitid,b.fstorageorgunitid,b.fmaterialid,b.funitid,b.fbaseunitid,");
        sql.append("b.fassistunitid,b.fassistpropertyid,b.FLot,d.fstoreflag,");
        sql.append(fieldStoreTypeId).append(",").append(fieldStoreStatusId).append(",");
        sql.append(fieldWarehouseId).append(",").append(fieldLocationId).append(",");
        sql.append(fieldSupplierId).append(",").append(fieldCustomerId).append(",");
        sql.append(fbizdate).append(", a.fbilltypeid, a.fnumber, b.fseq, a.fisreversed");
        if (SCMUtil.isInInvBillTable((String)billHead) || SCMUtil.isOutInvBillTable((String)billHead)) {
            sql.append("," + fieldEffectQtyName);
        }
        return sql.toString();
    }

    private String getDecomposeBillSql(String sqlIn, String msWhere, boolean isInventory) {
        StringBuffer sqlSelect = new StringBuffer();
        String fbizdate = null;
        fbizdate = isInventory ? "a.faudittime ,a.FBizDate" : "a.fcreatetime ,a.FBizDate";
        String[] entryNames = new String[]{"T_IM_DecomposeEntry", "T_IM_DecomposeEntryDetail"};
        String[] symbols = new String[]{"-1", "1"};
        StringBuffer sql = new StringBuffer(sqlIn);
        sql.append("(");
        for (int i = 0; i < symbols.length; ++i) {
            sqlSelect.append("select b.fcompanyorgunitid,b.fstorageorgunitid,b.fmaterialid,b.funitid,");
            sqlSelect.append("b.fbaseunitid,b.fassistunitid,b.fassistpropertyid,b.fstoretypeid,");
            sqlSelect.append("isnull(b.fstorestatusid,'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'),");
            sqlSelect.append("b.fsupplierid,b.fcustomerid,b.fwarehouseid,b.flocationid,b.flot,sum(");
            sqlSelect.append(symbols[i]).append(" * b.fqty),sum(");
            sqlSelect.append(symbols[i]).append(" * b.fbaseqty),sum(");
            sqlSelect.append(symbols[i]).append(" * b.fassistqty), ");
            sqlSelect.append(fbizdate);
            sqlSelect.append(" ,a.fbilltypeid, a.fnumber, b.fseq,  ");
            sqlSelect.append(symbols[i]).append(" as fflag  ");
            sqlSelect.append("FROM ").append(entryNames[i]).append(" b ");
            if ("T_IM_DecomposeEntryDetail".equalsIgnoreCase(entryNames[i])) {
                sqlSelect.append("left join T_IM_DecomposeEntry c on b.FDecompEntryID = c.fid ");
                sqlSelect.append("left join T_IM_DecomposeBill a on a.fid = c.fparentid ");
            } else {
                sqlSelect.append("left join T_IM_DecomposeBill a on a.fid = b.fparentid ");
            }
            sqlSelect.append(msWhere).append(" AND a.fbasestatus = 4 AND isnull(a.fisinitbill,0) = 0 ");
            sqlSelect.append("GROUP BY b.fcompanyorgunitid,b.fstorageorgunitid,b.fwarehouseid, b.flocationid,b.fstoretypeid,b.fsupplierid,");
            sqlSelect.append("b.fcustomerid,b.fstorestatusid,b.flot,b.fmaterialid,b.funitid,b.fbaseunitid,b.fassistunitid,b.fassistpropertyid,");
            sqlSelect.append(fbizdate).append(", a.fbilltypeid, a.fnumber, b.fseq ");
            if (i >= symbols.length - 1) continue;
            sqlSelect.append(" union ");
        }
        sql.append(sqlSelect).append(")");
        return sql.toString();
    }

    private String getArBillSql(String sqlIn, String msWhere, boolean isInventory) {
        String where = null;
        where = msWhere.replaceAll("B.FStorageOrgUnitID", "c.fstorageorgunitid");
        where = where.replaceAll("B.FWarehouseID", "c.fwarehouseid");
        where = where.replaceAll("B.FMaterialID", "c.fmaterialid");
        where = where.replaceAll("B.FUnitID", "c.funitid");
        where = where.replaceAll("B.FAssistPropertyID", "c.fassistpropertyid");
        where = where.replaceAll("A.FAuditTime", "a.fauditdate");
        StringBuffer result = new StringBuffer(sqlIn);
        String saleIssue = this.getARsqlFromSaleIssue(where, isInventory);
        result.append(saleIssue);
        result.append(" union all ");
        String sqlorder = this.getARsqlFromSaleOrder(where, isInventory);
        result.append(sqlorder);
        return result.toString();
    }

    private String getARsqlFromSaleIssue(String where, boolean isInventory) {
        StringBuffer sqlSelect = new StringBuffer();
        String fbizdate = null;
        fbizdate = isInventory ? "a.fauditdate ,a.FBizDate" : "a.fcreatetime ,a.FBizDate";
        sqlSelect.append("select a.FCompanyID,c.fstorageorgunitid,b.fmaterialid,");
        sqlSelect.append(" case when isnull(param.FValue_L2,'false')='true'");
        sqlSelect.append(" then b.fbaseunitid");
        sqlSelect.append(" else c.funitid end as UnitID,");
        sqlSelect.append(" b.fbaseunitid,b.fassistunitid,b.fassistpropertyid,");
        sqlSelect.append("'").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("',");
        sqlSelect.append("'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("',null,b.FServiceCustomerID,");
        sqlSelect.append(" c.FWareHouseID, c.FLocationID, c.Flot,");
        sqlSelect.append(" case when isnull(param.FValue_L2,'false') = 'true'");
        sqlSelect.append(" then ");
        sqlSelect.append("(case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.fbaseqty)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.fbaseqty)) ");
        sqlSelect.append("else 0 end)");
        sqlSelect.append(" else ");
        sqlSelect.append(" case when b.FMeasureUnitID = C.FUnitID ");
        sqlSelect.append(" then  ");
        sqlSelect.append("(case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.FQuantity)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.FQuantity)) ");
        sqlSelect.append("else 0 end )");
        sqlSelect.append(" else");
        sqlSelect.append(" round(decimal(");
        sqlSelect.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.fbaseqty)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.fbaseqty)) ");
        sqlSelect.append("else 0 end ");
        sqlSelect.append("/ M.FBaseConvsRate,21,8),M.FQtyPrecision)");
        sqlSelect.append(" end ");
        sqlSelect.append("end AS FQty, ");
        sqlSelect.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.fbaseqty)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.fbaseqty)) ");
        sqlSelect.append("else 0 end, ");
        sqlSelect.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.FAssistQty)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.FAssistQty)) ");
        sqlSelect.append("else 0 end, ");
        sqlSelect.append(fbizdate);
        sqlSelect.append(" ,'510b6503-0105-1000-e000-0117c0a812fd463ED552' as fbilltype, a.fnumber, b.fseq,  ");
        sqlSelect.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen 1 ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen -1 ");
        sqlSelect.append("else 0 end as FFlag ");
        sqlSelect.append("FROM T_AR_OtherBill A ");
        sqlSelect.append("INNER JOIN T_AR_OTHERBILLENTRY B on A.FID = B.FParentID ");
        sqlSelect.append("INNER JOIN T_IM_SaleIssueEntry C on C.FID = B.FSOURCEBILLENTRYID ");
        sqlSelect.append("INNER JOIN T_BD_multimeasureunit M on (C.FUnitID = M.fmeasureunitid and C.FMaterialID = M.FMaterialID) ");
        sqlSelect.append(" LEFT JOIN (select Fid, FValue_L1,FValue_L2,FValue_L3,FOrgUnitID from t_bas_paramitem WHERE FKEYID = (select fid from t_bas_param where fnumber = 'INM004')) param ");
        sqlSelect.append(" on c.fstorageorgunitid = param.FOrgUnitID ");
        sqlSelect.append(where).append("AND (A.FBizTypeId = '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("OR A.FBizTypeId = '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("') ");
        sqlSelect.append("AND isnull(A.FIsInitializeBill,0) = 0 AND A.FBillStatus = 3 AND A.FisBizBill = 0  ");
        sqlSelect.append("GROUP BY a.FCompanyID,c.fstorageorgunitid,b.fmaterialid,b.FServiceCustomerID,c.FWareHouseID,c.FLocationID,c.flot,");
        sqlSelect.append("b.FMeasureUnitID,b.FQuantity,b.fbaseunitid,b.fbaseqty,b.fassistunitid,b.FAssistQty,b.fassistpropertyid,a.fbiztypeid,");
        sqlSelect.append("param.FValue_L2, c.FUnitid,M.FBaseConvsRate,M.FQtyPrecision, ");
        sqlSelect.append(fbizdate).append(" ,a.fbilltype, a.fnumber, b.fseq ");
        return sqlSelect.toString();
    }

    private String getARsqlFromSaleOrder(String where, boolean isInventory) {
        StringBuffer sqlorder = new StringBuffer();
        String fbizdate = null;
        fbizdate = isInventory ? "a.fauditdate ,a.FBizDate" : "a.fcreatetime ,a.FBizDate";
        sqlorder.append("select a.FCompanyID,c.fstorageorgunitid,b.fmaterialid,");
        sqlorder.append(" b.FMeasureUnitID,b.fbaseunitid,b.fassistunitid,b.fassistpropertyid,");
        sqlorder.append("'").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("',");
        sqlorder.append("'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("',null,b.FServiceCustomerID,");
        sqlorder.append(" null, null, null,");
        sqlorder.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlorder.append("\tthen sum(abs(b.FQuantity)) ");
        sqlorder.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlorder.append("\tthen (-1) * sum(abs(b.FQuantity)) ");
        sqlorder.append("else 0 end, ");
        sqlorder.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlorder.append("\tthen sum(abs(b.fbaseqty)) ");
        sqlorder.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlorder.append("\tthen (-1) * sum(abs(b.fbaseqty)) ");
        sqlorder.append("else 0 end, ");
        sqlorder.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlorder.append("\tthen sum(abs(b.FAssistQty)) ");
        sqlorder.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlorder.append("\tthen (-1) * sum(abs(b.FAssistQty)) ");
        sqlorder.append("else 0 end ,");
        sqlorder.append(fbizdate);
        sqlorder.append(" ,'510b6503-0105-1000-e000-0117c0a812fd463ED552' as fbilltype, a.fnumber, b.fseq, ");
        sqlorder.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlorder.append("\tthen 1 ");
        sqlorder.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlorder.append("\tthen -1 ");
        sqlorder.append("else 0 end as FFlag  ");
        sqlorder.append("FROM T_AR_OtherBill A ");
        sqlorder.append("INNER JOIN T_AR_OTHERBILLENTRY B on A.FID = B.FParentID ");
        sqlorder.append("INNER JOIN T_SD_SaleOrderEntry C on C.FID = B.FSOURCEBILLENTRYID ");
        sqlorder.append(where).append("AND (A.FBizTypeId = '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlorder.append("OR A.FBizTypeId = '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("') ");
        sqlorder.append("And isnull(A.FIsInitializeBill,0) = 0 And A.FBillStatus = 3 And A.FisBizBill = 0  ");
        sqlorder.append("GROUP BY a.FCompanyID,c.fstorageorgunitid,b.FServiceCustomerID,b.fmaterialid,");
        sqlorder.append(" b.FMeasureUnitID,b.fbaseunitid,b.fassistunitid,b.fassistpropertyid,a.fbiztypeid, ");
        sqlorder.append(fbizdate).append(" ,a.fbilltype, a.fnumber, b.fseq ");
        return sqlorder.toString();
    }

    protected IObjectPK _submit(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        CountingTableInfo info = (CountingTableInfo)value;
        String countTaskId = null;
        boolean isInventory = false;
        boolean isFreeMaterial = false;
        if (info.getId() != null) {
            String billID = info.getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append(" select t2.ftaskstatus, t2.fid as countTaskId, t2.FIsInventory as FIsInventory, ");
            sql.append(" t2.FIsFreeMaterial as FIsFreeMaterial ");
            sql.append(" from T_IM_COUNTINGTABLE t1 inner join t_im_countingtask t2 on t1.fcountingTaskid = t2.fid ");
            sql.append(" and t1.fid = '").append(billID).append("'");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (result.next()) {
                    int status = result.getInt("ftaskstatus");
                    isInventory = result.getBoolean("FIsInventory");
                    isFreeMaterial = result.getBoolean("FIsFreeMaterial");
                    countTaskId = isInventory && isFreeMaterial ? result.getString("countTaskId") : null;
                    if (status == 4) {
                        throw new InvBizException(InvBizException.COUNTING_COMPLETED);
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)result);
            }
        }
        IObjectPK pk = super._submit(ctx, value);
        if (!StringUtil.isEmpty(countTaskId)) {
            this.insertCountingTempTask(ctx, countTaskId);
        }
        return pk;
    }

    private void insertCountingTempTask(Context ctx, String countTaskId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("select 1 from T_IM_COUNTINGTEMP where FCOUNTINGTASKID = '").append(countTaskId).append("' ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (!result.next()) {
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" delete from T_IM_COUNTINGTEMP where FCOUNTINGTASKID = '").append(countTaskId).append("' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("INSERT INTO T_IM_COUNTINGTEMP                                         ");
        sql.append("  (FID, FCOUNTINGTASKID, FSTORAGEORGUNITID, FWAREHOUSEID, FMATERIALID,");
        sql.append("    FSUPPLIERID,FCUSTOMERID,FSTORETYPEID,FCOUNTINGTIME)\t\t\t\t  ");
        sql.append("  SELECT newbosid('12345678') AS NewFID, countTask.*                  ");
        sql.append("    FROM (SELECT DISTINCT B.FCountingTaskID, B.FSTORAGEORGUNITID,     ");
        sql.append("            B.FWAREHOUSEID, A.FMATERIALID ,A.FSUPPLIERID,             ");
        sql.append("            A.FCUSTOMERID, A.FSTORETYPEID, B.FCOUNTINGBEGINTIME       ");
        sql.append("            FROM T_IM_CountingTableEntry A                            ");
        sql.append("            LEFT OUTER JOIN T_IM_CountingTable B                      ");
        sql.append("              ON A.FParentID = B.FID                                  ");
        sql.append("           WHERE 1=1\t\t\t\t\t\t                          ");
        sql.append("             AND B.FCountingTaskID = '").append(countTaskId).append("') countTask");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        CountingTableInfo info = (CountingTableInfo)model;
        if (info.getId() != null) {
            String billID = info.getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append("update T_IM_CountingTableEntry as c set (FBaseQty,FCountingQty,FDifferQty,FCountingAssistQty,FDiffAssistQty) = ");
            sql.append("(select abs(round(decimal(isnull(a.FDifferQty,0)*b.FBaseConvsRate,21,8),b.FQtyPrecision)),");
            sql.append("isnull(a.FCountingQty, 0), isnull(a.FDifferQty, 0), isnull(a.FCountingAssistQty, 0), isnull(a.FDiffAssistQty, 0) ");
            sql.append("from T_IM_CountingTableEntry a ");
            sql.append("inner join t_bd_multimeasureunit b on a.fmaterialid = b.fmaterialid and a.funitid = b.fmeasureunitid ");
            sql.append("where a.fparentid = '").append(billID).append("' and c.fid = a.fid)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

