/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.IOtherInWarehsBill;
import com.kingdee.eas.scm.im.inv.IOtherIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillInfo;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBill;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.util.AccountViewUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class CreateVirtualBillForMatattrBotp
extends CreateVirtualBill {
    public InvBillBaseInfo createInvVirtualBill(Context ctx, IObjectValue model, IInvBillBase invBillBase, String botpName, InvBillBaseInfo isSueColl) throws BOSException, EASBizException {
        CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
        coreBillBaseColl.add((CoreBillBaseInfo)model);
        IObjectCollection infos = null;
        IObjectCollection infoColl = null;
        if (invBillBase instanceof IOtherIssueBill) {
            BTPTransformResult transformResultIsSue = this.getTransformResult(ctx, coreBillBaseColl, botpName);
            infos = transformResultIsSue.getBills();
            infoColl = this.setIsSueColl(ctx, infos, model);
            invBillBase.handleAfterTransform("SAVE", infoColl);
        }
        if (invBillBase instanceof IOtherInWarehsBill) {
            BTPTransformResult transformResultInWarehs = this.getTransformResult(ctx, coreBillBaseColl, botpName);
            infos = transformResultInWarehs.getBills();
            infoColl = this.setInWarehsColl(ctx, infos, model);
            invBillBase.handleAfterTransform("SAVE", infoColl);
            AccountViewUtil.updateAccountView(ctx, infos);
        }
        InvBillBaseInfo info = null;
        if (infoColl != null && infoColl.size() > 0) {
            info = (InvBillBaseInfo)infoColl.getObject(0);
            if (info != null && info.getTransactionType() == null) {
                throw new InvBizException(InvBizException.TRANSACTION_CHECK_ERROR);
            }
            invBillBase.addnew((CoreBaseInfo)info);
            this.afterVirtualBill(ctx, (CoreBillBaseInfo)model, (CoreBillBaseInfo)info);
        }
        AccountViewUtil.updateAccountView(ctx, infos);
        return info;
    }

    public BTPTransformResult getTransformResult(Context ctx, CoreBillBaseCollection coreBillBaseColl, String botpName) throws EASBizException, BOSException {
        BOTMappingInfo botIsSueMappingInfo = null;
        try {
            botIsSueMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpName + "'");
        }
        catch (Exception e) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
        }
        if (!botIsSueMappingInfo.getExtRule().isIsEffected()) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
        }
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coreBillBaseColl, botIsSueMappingInfo);
        return transformResult;
    }

    public IObjectCollection setIsSueColl(Context ctx, IObjectCollection infos, IObjectValue model) throws EASBizException, BOSException {
        InvBillBaseInfo modelInfo = (InvBillBaseInfo)model;
        Boolean isInvUpdateType = false;
        IObjectCollection beforeEntries = null;
        InvBillBaseEntryInfo beforeEntry = null;
        if (model instanceof MatAttrChangeBillInfo || model instanceof MatAssembleBillInfo || model instanceof MatDisassembleBillInfo) {
            isInvUpdateType = true;
        }
        for (int i = 0; i < infos.size(); ++i) {
            TransactionTypeInfo transactionTypeInfo;
            InvBillBaseInfo info = (InvBillBaseInfo)infos.getObject(i);
            info.setNumber("**" + modelInfo.getNumber() + "A");
            if (info.getBizDate() == null) {
                info.setBizDate(new Date());
            }
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setAuditTime(new Timestamp(new Date().getTime()));
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            info.setIsReversed(false);
            info.put("isSysBill", Boolean.FALSE);
            info.setIsInitBill(false);
            if (info.getTotalQty() == null) {
                info.setTotalQty(SCMConstant.BIGDECIMAL_ZERO);
            }
            if (info.getTotalAmount() == null) {
                info.setTotalAmount(SCMConstant.BIGDECIMAL_ZERO);
            }
            CompanyOrgUnitInfo company = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)company);
            if (period != null) {
                info.setYear(period.getPeriodYear());
                info.setPeriod(period.getPeriodNumber());
            }
            info.setMonth(model.getInt("month"));
            info.setDay(model.getInt("day"));
            BillTypeInfo billTypeInfo = info.getBillType();
            if (billTypeInfo == null) {
                billTypeInfo = new BillTypeInfo();
                billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0177c0a812fd463ED552"));
                info.setBillType(billTypeInfo);
            }
            if ((transactionTypeInfo = info.getTransactionType()) == null && info.getBizType() != null && info.getBizType().getId() != null) {
                transactionTypeInfo = InvCommonUtils.getDefaultTransactionType(ctx, billTypeInfo.getId().toString(), info.getBizType().getId().toString());
                info.setTransactionType(transactionTypeInfo);
            }
            info.setFiVouchered(false);
            info.setIsReversed(false);
            IObjectCollection entryColl = (IObjectCollection)info.get("entry");
            if (entryColl == null) {
                entryColl = (IObjectCollection)info.get("entries");
            }
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (int j = 0; j < entryColl.size(); ++j) {
                InvUpdateTypeInfo invUpdateType;
                InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryColl.getObject(j);
                if (entryInfo == null) continue;
                entryInfo.setStorageOrgUnit(info.getStorageOrgUnit());
                if (entryInfo.getAssCoefficient() == null) {
                    entryInfo.setAssCoefficient(SCMConstant.BIGDECIMAL_ZERO);
                }
                if (entryInfo.getReverseQty() == null) {
                    entryInfo.setReverseQty(SCMConstant.BIGDECIMAL_ZERO);
                }
                if (entryInfo.getReverseBaseQty() == null) {
                    entryInfo.setReverseBaseQty(SCMConstant.BIGDECIMAL_ZERO);
                }
                if (entryInfo.getUnitActualCost() == null) {
                    entryInfo.setUnitActualCost(SCMConstant.BIGDECIMAL_ZERO);
                }
                if (entryInfo.getActualCost() == null) {
                    entryInfo.setActualCost(SCMConstant.BIGDECIMAL_ZERO);
                }
                String sourceBillEntryID = entryInfo.getSourceBillEntryId();
                if (!isInvUpdateType.booleanValue()) continue;
                beforeEntries = (IObjectCollection)modelInfo.get("entry");
                if (beforeEntries == null) {
                    beforeEntries = (IObjectCollection)modelInfo.get("entries");
                }
                beforeEntry = null;
                if (!CollectionUtil.isEmpty((IObjectCollection)beforeEntries)) {
                    int size = beforeEntries.size();
                    for (int n = 0; n < size; ++n) {
                        InvBillBaseEntryInfo beforeEntryTemp = (InvBillBaseEntryInfo)beforeEntries.getObject(n);
                        if (sourceBillEntryID == null || !sourceBillEntryID.equals(beforeEntryTemp.getId().toString())) continue;
                        beforeEntry = (InvBillBaseEntryInfo)beforeEntries.getObject(n);
                        break;
                    }
                }
                String transactionTypeID = null;
                if (info.getTransactionType() != null) {
                    transactionTypeID = info.getTransactionType().getId().toString();
                }
                String aStoreTypeID = null;
                String aStoreStateID = null;
                StoreTypeInfo storeType = null;
                StoreStateInfo storeState = null;
                if (beforeEntry != null) {
                    storeType = (StoreTypeInfo)beforeEntry.get("storeType");
                    storeState = (StoreStateInfo)beforeEntry.get("storeStatus");
                }
                String aStoreTypeName = "";
                if (storeType != null) {
                    aStoreTypeID = storeType.getId().toString();
                    aStoreTypeName = storeType.getName();
                }
                String aStoreStateName = "";
                if (storeState != null) {
                    aStoreStateID = storeState.getId().toString();
                    aStoreStateName = storeState.getName();
                }
                if ((invUpdateType = InvCommonUtils.getInvUpdateType(ctx, transactionTypeID, aStoreTypeID, aStoreStateID)) == null) {
                    throw new InvBizException(InvBizException.ISSUE_INVUPDATETYPE_ISNOT_EXIST, new String[]{aStoreTypeName, aStoreStateName});
                }
                entryInfo.setInvUpdateType(invUpdateType);
            }
        }
        return infos;
    }

    public IObjectCollection setInWarehsColl(Context ctx, IObjectCollection infos, IObjectValue model) throws EASBizException, BOSException {
        InvBillBaseInfo modelInfo = (InvBillBaseInfo)model;
        Boolean isInvUpdateType = false;
        IObjectCollection beforeEntries = null;
        InvBillBaseEntryInfo beforeEntry = null;
        if (model instanceof MatAttrChangeBillInfo || model instanceof MatAssembleBillInfo || model instanceof MatDisassembleBillInfo) {
            isInvUpdateType = true;
        }
        for (int i = 0; i < infos.size(); ++i) {
            TransactionTypeInfo transactionTypeInfo;
            InvBillBaseInfo info = (InvBillBaseInfo)infos.getObject(i);
            info.setNumber("*" + modelInfo.getNumber() + "A");
            if (info.getBizDate() == null) {
                info.setBizDate(new Date());
            }
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setAuditTime(new Timestamp(new Date().getTime()));
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            info.setIsReversed(false);
            info.put("isSysBill", Boolean.FALSE);
            CompanyOrgUnitInfo company = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)company);
            if (period != null) {
                info.setYear(period.getPeriodYear());
                info.setPeriod(period.getPeriodNumber());
            }
            info.setMonth(model.getInt("month"));
            info.setDay(model.getInt("day"));
            BillTypeInfo billTypeInfo = info.getBillType();
            if (billTypeInfo == null) {
                billTypeInfo = new BillTypeInfo();
                billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-017bc0a812fd463ED552"));
                info.setBillType(billTypeInfo);
            }
            if ((transactionTypeInfo = info.getTransactionType()) == null) {
                transactionTypeInfo = InvCommonUtils.getDefaultTransactionType(ctx, billTypeInfo.getId().toString(), info.getBizType().getId().toString());
                info.setTransactionType(transactionTypeInfo);
            }
            info.setFiVouchered(false);
            info.setIsReversed(false);
            IObjectCollection entryColl = (IObjectCollection)info.get("entry");
            if (entryColl == null) {
                entryColl = (IObjectCollection)info.get("entries");
            }
            if (entryColl == null || entryColl.size() <= 0) continue;
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)entryColl.getObject(0).get("companyOrgUnit");
            int curPrecision = 4;
            if (companyInfo != null && companyInfo.getBaseCurrency() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(companyInfo.getBaseCurrency().getId());
                curPrecision = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk).getPrecision();
            }
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            for (int j = 0; j < entryColl.size(); ++j) {
                InvUpdateTypeInfo invUpdateType;
                InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryColl.getObject(j);
                entryInfo.setStorageOrgUnit(info.getStorageOrgUnit());
                MaterialInfo material = entryInfo.getMaterial();
                String materialID = material.getId().toString();
                MaterialCompanyInfoInfo materialCompanyInfo = iMaterial.getCompanyInfo(materialID, companyInfo.getId().toString());
                if (materialCompanyInfo.getAccountType().getValue() == 2) {
                    MultiMeasureUnitInfo multiMuInfo = immu.getMultiUnit(materialID, entryInfo.getUnit().getId().toString());
                    BigDecimal unitStandCost = materialCompanyInfo.getStandardCost().multiply(multiMuInfo.getBaseConvsRate()).setScale(material.getPricePrecision(), 4);
                    entryInfo.setUnitStandardCost(unitStandCost);
                    BigDecimal standCost = unitStandCost.multiply(entryInfo.getQty()).setScale(curPrecision, 4);
                    entryInfo.setStandardCost(standCost);
                    entryInfo.setUnitActualCost(unitStandCost);
                    entryInfo.setActualCost(standCost);
                }
                String sourceBillEntryID = entryInfo.getSourceBillEntryId();
                if (!isInvUpdateType.booleanValue()) continue;
                beforeEntries = (IObjectCollection)modelInfo.get("entry");
                beforeEntries = (IObjectCollection)modelInfo.get("entry");
                if (beforeEntries == null) {
                    beforeEntries = (IObjectCollection)modelInfo.get("entries");
                }
                beforeEntry = null;
                if (!CollectionUtil.isEmpty((IObjectCollection)beforeEntries)) {
                    int size = beforeEntries.size();
                    for (int n = 0; n < size; ++n) {
                        InvBillBaseEntryInfo beforeEntryTemp = (InvBillBaseEntryInfo)beforeEntries.getObject(n);
                        if (sourceBillEntryID == null || !sourceBillEntryID.equals(beforeEntryTemp.getId().toString())) continue;
                        beforeEntry = (InvBillBaseEntryInfo)beforeEntries.getObject(n);
                        break;
                    }
                }
                String transactionTypeID = null;
                if (info.getTransactionType() != null) {
                    transactionTypeID = info.getTransactionType().getId().toString();
                }
                String aStoreTypeID = null;
                String aStoreStateID = null;
                StoreTypeInfo storeType = null;
                StoreStateInfo storeState = null;
                if (beforeEntry != null) {
                    InvBillBaseEntryInfo afterEntry;
                    IObjectCollection afterEntrys = (IObjectCollection)beforeEntry.get("entry1");
                    if (afterEntrys == null) {
                        afterEntrys = (IObjectCollection)beforeEntry.get("entries");
                    }
                    if (afterEntrys != null && (afterEntry = (InvBillBaseEntryInfo)afterEntrys.getObject(0)) != null) {
                        storeType = (StoreTypeInfo)afterEntry.get("storeType");
                        storeState = (StoreStateInfo)afterEntry.get("storeStatus");
                    }
                }
                String aStoreTypeName = "";
                if (storeType != null) {
                    aStoreTypeID = storeType.getId().toString();
                    aStoreTypeName = storeType.getName();
                    if (aStoreTypeName == null) {
                        storeType = StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo("select id,name where id = '" + aStoreTypeID + "'");
                        aStoreTypeName = storeType.getName();
                    }
                }
                String aStoreStateName = "";
                if (storeState != null) {
                    aStoreStateID = storeState.getId().toString();
                    aStoreStateName = storeState.getName();
                    if (aStoreStateName == null) {
                        storeState = StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateInfo("select id,name where id = '" + aStoreStateID + "'");
                        aStoreStateName = storeState.getName();
                    }
                }
                if ((invUpdateType = InvCommonUtils.getInvUpdateType(ctx, transactionTypeID, aStoreTypeID, aStoreStateID)) == null) {
                    throw new InvBizException(InvBizException.IN_INVUPDATETYPE_ISNOT_EXIST, new String[]{aStoreTypeName, aStoreStateName});
                }
                entryInfo.setInvUpdateType(invUpdateType);
            }
        }
        return infos;
    }

    private void afterVirtualBill(Context ctx, CoreBillBaseInfo srcBillInfo, CoreBillBaseInfo destBillBaseInfo) throws BOSException, EASBizException {
        SCMServerUtils.traceUpAndDown((Context)ctx, (String)srcBillInfo.getId().toString(), (String)destBillBaseInfo.getId().toString(), (String)srcBillInfo.getBOSType().toString(), (String)destBillBaseInfo.getBOSType().toString());
    }

    @Override
    protected String getBalanceCustomerSql(Map map) {
        return null;
    }

    @Override
    protected String getBalanceSupplierSql(Map map) {
        return null;
    }
}

