/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBillForPurIn;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.util.AccountViewUtil;
import com.kingdee.eas.scm.sm.pur.IPurInnerDealPrice;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceCollection;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceFactory;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.SettlementRouteEntryInfo;
import com.kingdee.eas.scm.sm.pur.SettlementSteps;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CreateVirtualBillForPurCentralBalance
extends CreateVirtualBillForPurIn {
    private static final String SALEISSUE_BOTPNAME = "PurIn_SaleIssueVirtualBill_Purchasing";
    private static final String PURIN_BOTPNAME = "PurIn_PurInVirtualBill_Purchasing";
    private IObjectValue orginModel;
    private Map customerMap = new HashMap();
    private Map supplierMap = new HashMap();
    private SettlementSteps settlementSteps;
    private Map settlementStepsMap = new HashMap();
    private Set purOrderIdSet = new HashSet();
    private Map entryCollectionMap = new HashMap();
    private Map purInnerDealPriceMap = new HashMap();
    private Map saleissueVirtualMap = new HashMap();
    private Map purinVirtualMap = new HashMap();
    private PurOrderCollection purOrderCollection = null;
    private List botRelationParamsList = new ArrayList();
    private Date auditTime = new Date();

    @Override
    protected void createVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!this.checkCreateVirtualBill(ctx, model)) {
            return;
        }
        this.init(ctx, model);
        Iterator it = this.settlementStepsMap.keySet().iterator();
        SettlementSteps.SimpleSettlementStep simpleSettlementStep = null;
        while (it.hasNext()) {
            String purOrderId = (String)it.next();
            this.settlementSteps = (SettlementSteps)this.settlementStepsMap.get(purOrderId);
            this.reBuildModelEntry(purOrderId, model);
            this.createInvVirtualBill(ctx, model, PurInWarehsBillFactory.getLocalInstance(ctx), this.getPurInBOTPName(model), this.settlementSteps.getLastStep());
            simpleSettlementStep = this.settlementSteps.getSettlementStepByLevel(1);
            this.doCreateVirtualBill(ctx, model, simpleSettlementStep);
        }
        this.executeBatchTraceUpAndDown(ctx);
    }

    private void init(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this.orginModel = model;
        this.initPurOrderIdSet(ctx, model);
        this.initPurOrderCollection(ctx);
        this.initSettlementStepsMap(ctx);
        Set companyOrgUnitIdSet = this.initCompanyOrgUnitIdSet(this.settlementStepsMap);
        this.initCustomerInfo(ctx, companyOrgUnitIdSet);
        this.initSupplierInfo(ctx, companyOrgUnitIdSet);
        this.splitModel(ctx, model);
        this.initPurInnerDealPriceMap(ctx);
        this.initVirtualBill(ctx, model);
    }

    private void splitModel(Context ctx, IObjectValue model) {
        for (String purOrderId : this.purOrderIdSet) {
            this.entryCollectionMap.put(purOrderId, new PurInWarehsEntryCollection());
        }
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        PurInWarehsEntryCollection purInWarehsEntrys = pi.getEntry();
        PurInWarehsEntryInfo piEntry = null;
        int length = purInWarehsEntrys.size();
        for (int i = 0; i < length; ++i) {
            piEntry = purInWarehsEntrys.get(i);
            if (!"510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(piEntry.getCoreBillType().getId().toString()) || !this.entryCollectionMap.containsKey(piEntry.getPurOrder())) continue;
            PurInWarehsEntryCollection entryCollection = (PurInWarehsEntryCollection)((Object)this.entryCollectionMap.get(piEntry.getPurOrder()));
            entryCollection.add(piEntry);
        }
    }

    private void reBuildModelEntry(String purOrderId, IObjectValue model) {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        PurInWarehsEntryCollection purInWarehsEntrys = pi.getEntry();
        PurInWarehsEntryCollection entryCollection = (PurInWarehsEntryCollection)((Object)this.entryCollectionMap.get(purOrderId));
        purInWarehsEntrys.clear();
        purInWarehsEntrys.addCollection(entryCollection);
    }

    private void createBill(Context ctx, IObjectValue model, SettlementSteps.SimpleSettlementStep simpleSettlementStep) throws BOSException, EASBizException {
        this.createInvVirtualBill(ctx, model, SaleIssueBillFactory.getLocalInstance(ctx), this.getSaleIssueBOTPName(model), simpleSettlementStep);
        if (!simpleSettlementStep.isLastStep()) {
            this.createInvVirtualBill(ctx, model, PurInWarehsBillFactory.getLocalInstance(ctx), this.getPurInBOTPName(model), simpleSettlementStep);
        }
    }

    private IObjectCollection doCreateVirtualBill(Context ctx, IObjectValue model, SettlementSteps.SimpleSettlementStep simpleSettlementStep) throws EASBizException, BOSException {
        if (null == simpleSettlementStep || null == model) {
            return null;
        }
        this.createBill(ctx, model, simpleSettlementStep);
        return this.doCreateVirtualBill(ctx, model, simpleSettlementStep.getNextStep());
    }

    private void afterVirtualBill(Context ctx, CoreBillBaseInfo srcBillInfo, CoreBillBaseInfo destBillBaseInfo) throws BOSException, EASBizException {
        Object[] params = new Object[]{srcBillInfo.getBOSType().toString(), destBillBaseInfo.getBOSType().toString(), srcBillInfo.getId().toString(), destBillBaseInfo.getId().toString()};
        this.botRelationParamsList.add(params);
    }

    private void executeBatchTraceUpAndDown(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_BOT_Relation ");
        sql.append("(FID, FSrcEntityID, FDestEntityID, FSrcObjectID, FDestObjectID, FDate, FOperatorID, FisEffected, FType) ");
        sql.append(" VALUES (NEWBOSID('59302EC6'), ?, ?, ?, ?, NOW(), 'unknown', 1, 0)");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)this.botRelationParamsList);
    }

    private void checkMatCompanyInfo(Context ctx, InvBillBaseInfo info) throws BOSException, EASBizException {
        InvServerUtils.checkMatCompanyInfo(ctx, info, InvBizException.MATERIAL_COMPANY_NULL_VIRTUAL);
        if (info.isIsInitBill()) {
            SCMServerUtils.checkInitBizDate((Context)ctx, (SCMBillBaseInfo)info, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(info), (boolean)true);
        } else {
            SCMServerUtils.checkBizDate((Context)ctx, (IObjectValue)info, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(info), (boolean)true);
        }
    }

    private void createInvVirtualBill(Context ctx, IObjectValue model, IInvBillBase invBillBase, String botpName, SettlementSteps.SimpleSettlementStep simpleSettlementStep) throws BOSException, EASBizException {
        InvBillBaseInfo info;
        int i;
        IObjectCollection infos = this.generateVirtualBill(model, botpName);
        for (i = 0; i < infos.size(); ++i) {
            info = (InvBillBaseInfo)infos.getObject(i);
            this.handleInfo(ctx, model, info, i);
            this.handleInfoSettlementRoute(ctx, info, simpleSettlementStep);
        }
        invBillBase.handleAfterTransform("SAVE", infos);
        AccountViewUtil.updateAccountView(ctx, infos);
        for (i = 0; i < infos.size(); ++i) {
            info = (InvBillBaseInfo)infos.getObject(i);
            invBillBase.addnew((CoreBaseInfo)info);
            this.afterVirtualBill(ctx, (CoreBillBaseInfo)model, (CoreBillBaseInfo)info);
            this.calculateBill(ctx, info);
            this.checkMatCompanyInfo(ctx, info);
        }
    }

    private IObjectCollection generateVirtualBill(IObjectValue model, String botpName) {
        AbstractObjectCollection infos;
        block3: {
            String purOrderId;
            block2: {
                PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
                PurInWarehsEntryCollection purInWarehsEntrys = pi.getEntry();
                purOrderId = purInWarehsEntrys.get(0).getPurOrder();
                infos = null;
                if (!SALEISSUE_BOTPNAME.equals(botpName)) break block2;
                infos = new SaleIssueBillCollection();
                IObjectCollection saleissueVirtualCollection = (IObjectCollection)this.saleissueVirtualMap.get(purOrderId);
                int length = saleissueVirtualCollection.size();
                for (int i = 0; i < length; ++i) {
                    InvBillBaseInfo info = (InvBillBaseInfo)saleissueVirtualCollection.getObject(i);
                    infos.addObject((IObjectValue)this.createNewVirtualModel(info));
                }
                break block3;
            }
            if (!PURIN_BOTPNAME.equals(botpName)) break block3;
            infos = new PurInWarehsBillCollection();
            IObjectCollection purinVirtualCollection = (IObjectCollection)this.purinVirtualMap.get(purOrderId);
            int length = purinVirtualCollection.size();
            for (int i = 0; i < length; ++i) {
                InvBillBaseInfo info = (InvBillBaseInfo)purinVirtualCollection.getObject(i);
                infos.addObject((IObjectValue)this.createNewVirtualModel(info));
            }
        }
        return infos;
    }

    private InvBillBaseInfo createNewVirtualModel(InvBillBaseInfo info) {
        InvBillBaseInfo newInfo = (InvBillBaseInfo)info.clone();
        newInfo.setId(null);
        IObjectCollection entry = (IObjectCollection)newInfo.get("entry");
        int length = entry.size();
        for (int i = 0; i < length; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entry.getObject(i);
            entryInfo.setId(null);
        }
        return newInfo;
    }

    private void initVirtualBill(Context ctx, IObjectValue model) throws InvException, BOSException, BTPException {
        CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
        coreBillBaseColl.add((CoreBillBaseInfo)model);
        String oql = "where name in('PurIn_SaleIssueVirtualBill_Purchasing','PurIn_PurInVirtualBill_Purchasing')";
        BOTMappingInfo botMappingInfo = null;
        BOTMappingCollection botMappingCollection = null;
        try {
            botMappingCollection = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(oql);
        }
        catch (Exception e) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{PURIN_BOTPNAME, SALEISSUE_BOTPNAME});
        }
        for (String purOrderId : this.purOrderIdSet) {
            this.reBuildModelEntry(purOrderId, model);
            int length = botMappingCollection.size();
            for (int i = 0; i < length; ++i) {
                botMappingInfo = botMappingCollection.get(i);
                if (!botMappingInfo.getExtRule().isIsEffected()) {
                    throw new InvException(InvException.BOTPERROR, (Object[])new String[]{PURIN_BOTPNAME, SALEISSUE_BOTPNAME});
                }
                BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coreBillBaseColl, botMappingInfo);
                IObjectCollection infos = transformResult.getBills();
                if (SALEISSUE_BOTPNAME.equals(botMappingInfo.getName())) {
                    this.saleissueVirtualMap.put(purOrderId, infos);
                    continue;
                }
                if (!PURIN_BOTPNAME.equals(botMappingInfo.getName())) continue;
                this.purinVirtualMap.put(purOrderId, infos);
            }
        }
    }

    private void handleInfo(Context ctx, IObjectValue model, InvBillBaseInfo info, int i) throws EASBizException, BOSException {
        info.setNumber(info.getNumber() + (char)(i + 65));
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Timestamp(new Date().getTime()));
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        info.setIsReversed(false);
        info.put("isSysBill", Boolean.TRUE);
        CompanyOrgUnitInfo company = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
        PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)company);
        if (period != null) {
            info.setYear(period.getPeriodYear());
            info.setPeriod(period.getPeriodNumber());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(info.getAuditTime().getTime()));
        info.setMonth(cal.get(1) * 100 + (cal.get(2) + 1));
        info.setDay(cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5));
        if (model.get("entry") != null) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)((IObjectCollection)model.get("entry")).getObject(0);
            info.put("VT_StorageOrgUnitID", entry.getStorageOrgUnit().getId().toString());
            info.put("VT_CompanyOrgUnitID", entry.getCompanyOrgUnit().getId().toString());
        }
    }

    private void handleInfoSettlementRoute(Context ctx, InvBillBaseInfo info, SettlementSteps.SimpleSettlementStep simpleSettlementStep) throws EASBizException, BOSException {
        info.put("settlementRelation", this.getModelSettlementRelation());
        this.handleNumber(info, simpleSettlementStep);
        this.handleAuditTime(info, simpleSettlementStep);
        this.handleStorageOrgUnit(info, simpleSettlementStep);
        this.handleCompanyOrgUnit(info, simpleSettlementStep);
        this.handleSupplierInfo(info, this.getArSettlementRoute(simpleSettlementStep));
        this.handleCustomerInfo(info, this.getApSettlementRoute(simpleSettlementStep));
        this.handleWarehouse(info, simpleSettlementStep);
        this.handleSaleOrgUnit(info, simpleSettlementStep);
        this.handlePurInnerDealPrice(ctx, info, this.getArSettlementRoute(simpleSettlementStep));
    }

    private void handlePurInnerDealPrice(Context ctx, InvBillBaseInfo info, SettlementRouteEntryInfo settlementRouteEntryInfo) {
        if (null == settlementRouteEntryInfo) {
            return;
        }
        IObjectCollection entry = (IObjectCollection)info.get("entry");
        String key = null;
        PurInnerDealPriceInfo purInnerDealPriceInfo = null;
        String coreBillEntryProperty = info instanceof PurInWarehsBillInfo ? "purOrderEntry" : "saleOrderEntry";
        String discountProperty = info instanceof PurInWarehsBillInfo ? "discountRate" : "discount";
        String priceProperty = info instanceof PurInWarehsBillInfo ? "price" : "salePrice";
        String actualTaxPriceProperty = info instanceof PurInWarehsBillInfo ? "actualTaxPrice" : "price";
        int length = entry.size();
        for (int i = 0; i < length; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entry.getObject(i);
            key = entryInfo.get(coreBillEntryProperty) + settlementRouteEntryInfo.getId().toString();
            purInnerDealPriceInfo = (PurInnerDealPriceInfo)this.purInnerDealPriceMap.get(key);
            if (null == purInnerDealPriceInfo) continue;
            entryInfo.put(priceProperty, purInnerDealPriceInfo.getPrice());
            entryInfo.put("taxRate", purInnerDealPriceInfo.getTaxRate());
            entryInfo.put("taxPrice", purInnerDealPriceInfo.getTaxPrice());
            entryInfo.put("actualPrice", purInnerDealPriceInfo.getActualPrice());
            entryInfo.put(actualTaxPriceProperty, purInnerDealPriceInfo.getActualTaxPrice());
            entryInfo.put("discountType", String.valueOf(purInnerDealPriceInfo.getDiscountMode().getValue()));
            if (0 == purInnerDealPriceInfo.getDiscountMode().getValue()) {
                entryInfo.put(discountProperty, purInnerDealPriceInfo.getDiscount());
                continue;
            }
            if (1 == purInnerDealPriceInfo.getDiscountMode().getValue()) {
                entryInfo.put("discountAmount", purInnerDealPriceInfo.getDiscount());
                continue;
            }
            entryInfo.put(discountProperty, purInnerDealPriceInfo.getDiscount());
        }
        this.handleExternalPurInWarehsPrice(ctx, info, settlementRouteEntryInfo);
    }

    private void handleExternalPurInWarehsPrice(Context ctx, InvBillBaseInfo info, SettlementRouteEntryInfo settlementRouteEntryInfo) {
        if (null == this.purOrderCollection || 0 == this.purOrderCollection.size()) {
            return;
        }
        if (info instanceof PurInWarehsBillInfo && this.getLastSettlementRouteEntryInfo().getLevel() == settlementRouteEntryInfo.getLevel() + 1) {
            IObjectCollection entry = (IObjectCollection)info.get("entry");
            int length = entry.size();
            for (int i = 0; i < length; ++i) {
                PurOrderEntryCollection purOrderEntryCollection;
                PurOrderEntryInfo purOrderEntryInfo;
                InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entry.getObject(i);
                String purOrderId = entryInfo.get("purOrder").toString();
                String purOrderEntryId = entryInfo.get("purOrderEntry").toString();
                PurOrderInfo purOrderInfo = (PurOrderInfo)this.purOrderCollection.getObject((Object)BOSUuid.read((String)purOrderId));
                if (null == purOrderInfo || null == (purOrderEntryInfo = (PurOrderEntryInfo)(purOrderEntryCollection = purOrderInfo.getEntries()).getObject((Object)BOSUuid.read((String)purOrderEntryId)))) continue;
                entryInfo.put("price", purOrderEntryInfo.getPrice());
                entryInfo.put("taxRate", purOrderEntryInfo.getTaxRate());
                entryInfo.put("taxPrice", purOrderEntryInfo.getTaxPrice());
                entryInfo.put("actualPrice", purOrderEntryInfo.getActualPrice());
                entryInfo.put("actualTaxPrice", purOrderEntryInfo.getActualTaxPrice());
                entryInfo.put("discountType", DiscountModeEnum.PERCENT);
                entryInfo.put("discountRate", purOrderEntryInfo.getDiscountRate());
                entryInfo.put("discountAmount", SysConstant.BIGZERO);
            }
        }
    }

    private void handleNumber(InvBillBaseInfo info, SettlementSteps.SimpleSettlementStep simpleSettlementStep) {
        SettlementRouteEntryInfo settlementRouteEntryInfo = this.getSettlementRouteEntryInfoByModelType(info, simpleSettlementStep);
        if (null == settlementRouteEntryInfo) {
            return;
        }
        int repeat = settlementRouteEntryInfo.getLevel() - 1;
        if (info instanceof SaleIssueBillInfo) {
            info.setNumber(info.getNumber().substring(1));
        }
        if (settlementRouteEntryInfo.isIsLeaf()) {
            repeat = 0;
        }
        info.setNumber(StringUtils.repeat((String)"*", (int)repeat) + info.getNumber());
    }

    private void handleAuditTime(InvBillBaseInfo info, SettlementSteps.SimpleSettlementStep simpleSettlementStep) {
        SettlementRouteEntryInfo settlementRouteEntryInfo = this.getSettlementRouteEntryInfoByModelType(info, simpleSettlementStep);
        if (null == settlementRouteEntryInfo) {
            return;
        }
        this.auditTime.setTime(this.auditTime.getTime() + 1000L);
        info.setAuditTime(new Timestamp(this.auditTime.getTime()));
    }

    private String getPurInBOTPName(IObjectValue model) {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        PurInWarehsEntryInfo pie = pi.getEntry().get(0);
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(pie.getCoreBillType().getId().toString())) {
            return PURIN_BOTPNAME;
        }
        return null;
    }

    private String getSaleIssueBOTPName(IObjectValue model) {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        PurInWarehsEntryInfo pie = pi.getEntry().get(0);
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(pie.getCoreBillType().getId().toString())) {
            return SALEISSUE_BOTPNAME;
        }
        return null;
    }

    private SettlementRouteEntryInfo getApSettlementRoute(SettlementSteps.SimpleSettlementStep simpleSettlementStep) {
        SettlementRouteEntryInfo settlementRouteEntryInfo = simpleSettlementStep.getApInfo();
        return settlementRouteEntryInfo;
    }

    private SettlementRouteEntryInfo getArSettlementRoute(SettlementSteps.SimpleSettlementStep simpleSettlementStep) {
        SettlementRouteEntryInfo settlementRouteEntryInfo = simpleSettlementStep.getArInfo();
        return settlementRouteEntryInfo;
    }

    private void handleStorageOrgUnit(InvBillBaseInfo info, SettlementSteps.SimpleSettlementStep simpleSettlementStep) {
        SettlementRouteEntryInfo settlementRouteEntryInfo = null;
        if (info instanceof SaleIssueBillInfo) {
            settlementRouteEntryInfo = this.getArSettlementRoute(simpleSettlementStep);
        }
        if (info instanceof PurInWarehsBillInfo) {
            settlementRouteEntryInfo = this.getApSettlementRoute(simpleSettlementStep);
        }
        if (null == (settlementRouteEntryInfo = this.handleLeafSettlementRouteEntryInfo(settlementRouteEntryInfo))) {
            return;
        }
        info.setStorageOrgUnit(settlementRouteEntryInfo.getStorageOrgUnit());
        IObjectCollection entry = (IObjectCollection)info.get("entry");
        int length = entry.size();
        for (int i = 0; i < length; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entry.getObject(i);
            entryInfo.setStorageOrgUnit(settlementRouteEntryInfo.getStorageOrgUnit());
        }
        info.put("VT_StorageOrgUnitID", settlementRouteEntryInfo.getStorageOrgUnit().getId().toString());
    }

    private void handleCompanyOrgUnit(InvBillBaseInfo info, SettlementSteps.SimpleSettlementStep simpleSettlementStep) {
        SettlementRouteEntryInfo settlementRouteEntryInfo = null;
        if (info instanceof SaleIssueBillInfo) {
            settlementRouteEntryInfo = this.getArSettlementRoute(simpleSettlementStep);
        }
        if (info instanceof PurInWarehsBillInfo) {
            settlementRouteEntryInfo = this.getApSettlementRoute(simpleSettlementStep);
        }
        if (null == (settlementRouteEntryInfo = this.handleLeafSettlementRouteEntryInfo(settlementRouteEntryInfo))) {
            return;
        }
        IObjectCollection entry = (IObjectCollection)info.get("entry");
        int length = entry.size();
        for (int i = 0; i < length; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entry.getObject(i);
            entryInfo.setCompanyOrgUnit(settlementRouteEntryInfo.getCompanyOrgUnit());
        }
        info.put("VT_CompanyOrgUnitID", settlementRouteEntryInfo.getCompanyOrgUnit().getId().toString());
    }

    private SettlementRouteEntryInfo getSettlementRouteEntryInfoByModelType(InvBillBaseInfo info, SettlementSteps.SimpleSettlementStep simpleSettlementStep) {
        SettlementRouteEntryInfo settlementRouteEntryInfo = null;
        if (info instanceof SaleIssueBillInfo) {
            settlementRouteEntryInfo = this.getArSettlementRoute(simpleSettlementStep);
        }
        if (info instanceof PurInWarehsBillInfo) {
            settlementRouteEntryInfo = this.getApSettlementRoute(simpleSettlementStep);
        }
        return settlementRouteEntryInfo;
    }

    private void handleWarehouse(InvBillBaseInfo info, SettlementSteps.SimpleSettlementStep simpleSettlementStep) {
        SettlementRouteEntryInfo settlementRouteEntryInfo = null;
        if (info instanceof SaleIssueBillInfo) {
            settlementRouteEntryInfo = this.getArSettlementRoute(simpleSettlementStep);
        }
        if (info instanceof PurInWarehsBillInfo) {
            settlementRouteEntryInfo = this.getApSettlementRoute(simpleSettlementStep);
        }
        if (null == (settlementRouteEntryInfo = this.handleLeafSettlementRouteEntryInfo(settlementRouteEntryInfo))) {
            return;
        }
        IObjectCollection entry = (IObjectCollection)info.get("entry");
        int length = entry.size();
        for (int i = 0; i < length; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entry.getObject(i);
            entryInfo.setWarehouse(settlementRouteEntryInfo.getWarehouse());
        }
    }

    private void handleSupplierInfo(InvBillBaseInfo info, SettlementRouteEntryInfo settlementRouteEntryInfo) throws BOSException, EASBizException {
        if (info instanceof PurInWarehsBillInfo) {
            SupplierInfo supplierInfo = null;
            supplierInfo = this.getLastSettlementRouteEntryInfo().getLevel() == settlementRouteEntryInfo.getLevel() + 1 ? (SupplierInfo)this.orginModel.get("supplier") : this.getSupplierInfo(settlementRouteEntryInfo);
            info.put("supplier", supplierInfo);
            info.put("VT_CompanyOrgUnitID", settlementRouteEntryInfo.getCompanyOrgUnit().getId().toString());
            IObjectCollection entry = (IObjectCollection)info.get("entry");
            int length = entry.size();
            for (int i = 0; i < length; ++i) {
                InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entry.getObject(i);
                entryInfo.put("balanceSupplier", supplierInfo);
            }
        }
    }

    private SettlementRouteEntryInfo getLastSettlementRouteEntryInfo() {
        return this.settlementSteps.getLastStep().getApInfo();
    }

    private SupplierInfo getSupplierInfo(SettlementRouteEntryInfo settlementRouteEntryInfo) {
        String companyOrgUnitId = settlementRouteEntryInfo.getCompanyOrgUnit().getId().toString();
        SupplierInfo supplierInfo = (SupplierInfo)this.supplierMap.get(companyOrgUnitId);
        return supplierInfo;
    }

    private void initSupplierInfo(Context ctx, Set companyOrgUnitIdSet) throws BOSException, EASBizException {
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("internalCompany.id", (Object)companyOrgUnitIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filterInfo);
        SupplierCollection collection = iSupplier.getSupplierCollection(view);
        if (null != collection && 0 < collection.size()) {
            int length = collection.size();
            for (int i = 0; i < length; ++i) {
                SupplierInfo supplierInfo = collection.get(i);
                this.supplierMap.put(supplierInfo.getInternalCompany().getId().toString(), supplierInfo);
            }
        }
    }

    private void handleCustomerInfo(InvBillBaseInfo info, SettlementRouteEntryInfo settlementRouteEntryInfo) throws BOSException, EASBizException {
        if (info instanceof SaleIssueBillInfo) {
            CustomerInfo customerInfo = this.getCustomerInfo(settlementRouteEntryInfo);
            info.put("customer", customerInfo);
            info.put("VT_CompanyOrgUnitID", settlementRouteEntryInfo.getCompanyOrgUnit().getId().toString());
            IObjectCollection entry = (IObjectCollection)info.get("entry");
            int length = entry.size();
            for (int i = 0; i < length; ++i) {
                InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entry.getObject(i);
                entryInfo.put("balanceCustomer", customerInfo);
                entryInfo.put("orderCustomer", customerInfo);
                entryInfo.put("paymentCustomer", customerInfo);
            }
        }
    }

    private void handleSaleOrgUnit(InvBillBaseInfo info, SettlementSteps.SimpleSettlementStep simpleSettlementStep) {
        SettlementRouteEntryInfo settlementRouteEntryInfo = null;
        if (info instanceof SaleIssueBillInfo) {
            settlementRouteEntryInfo = this.getArSettlementRoute(simpleSettlementStep);
            if (null == (settlementRouteEntryInfo = this.handleLeafSettlementRouteEntryInfo(settlementRouteEntryInfo))) {
                return;
            }
            SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)info;
            SaleIssueEntryInfo saleIssueEntryInfo = null;
            SaleIssueEntryCollection saleIssueEntryCollection = saleIssueBillInfo.getEntry();
            int length = saleIssueEntryCollection.size();
            for (int i = 0; i < length; ++i) {
                saleIssueEntryInfo = saleIssueEntryCollection.get(i);
                saleIssueEntryInfo.setSaleOrgUnit(settlementRouteEntryInfo.getSaleOrgUnit());
            }
        }
    }

    private CustomerInfo getCustomerInfo(SettlementRouteEntryInfo settlementRouteEntryInfo) {
        String companyOrgUnitId = settlementRouteEntryInfo.getCompanyOrgUnit().getId().toString();
        CustomerInfo customerInfo = (CustomerInfo)this.customerMap.get(companyOrgUnitId);
        return customerInfo;
    }

    private void initCustomerInfo(Context ctx, Set companyOrgUnitIdSet) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("internalCompany.id", (Object)companyOrgUnitIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filterInfo);
        CustomerCollection collection = iCustomer.getCustomerCollection(view);
        if (null != collection && 0 < collection.size()) {
            int length = collection.size();
            for (int i = 0; i < length; ++i) {
                CustomerInfo customerInfo = collection.get(i);
                this.customerMap.put(customerInfo.getInternalCompany().getId().toString(), customerInfo);
            }
        }
    }

    private Set initCompanyOrgUnitIdSet(Map settlementStepsMap) {
        Iterator it = settlementStepsMap.keySet().iterator();
        SettlementSteps.SimpleSettlementStep simpleSettlementStep = null;
        HashSet<String> companyOrgUnitIdSet = new HashSet<String>();
        while (it.hasNext()) {
            String purOrderId = (String)it.next();
            SettlementSteps settlementSteps = (SettlementSteps)settlementStepsMap.get(purOrderId);
            int length = settlementSteps.getStepCount();
            for (int i = 1; i <= length; ++i) {
                simpleSettlementStep = settlementSteps.getSettlementStepByLevel(i);
                String apCompanyOrgUnitId = simpleSettlementStep.getApInfo().getCompanyOrgUnit().getId().toString();
                companyOrgUnitIdSet.add(apCompanyOrgUnitId);
                String arCompanyOrgUnitId = simpleSettlementStep.getArInfo().getCompanyOrgUnit().getId().toString();
                companyOrgUnitIdSet.add(arCompanyOrgUnitId);
            }
        }
        return companyOrgUnitIdSet;
    }

    private void initSettlementStepsMap(Context ctx) throws EASBizException, BOSException {
        for (String purOrderId : this.purOrderIdSet) {
            this.settlementStepsMap.put(purOrderId, new SettlementSteps(ctx, purOrderId));
        }
    }

    private void initPurInnerDealPriceMap(Context ctx) throws EASBizException, BOSException {
        String[] purOrderIds = new String[this.purOrderIdSet.size()];
        Iterator it = this.purOrderIdSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            String purOrderId;
            purOrderIds[i] = purOrderId = (String)it.next();
            ++i;
        }
        IPurInnerDealPrice iPurInnerDealPrice = PurInnerDealPriceFactory.getLocalInstance((Context)ctx);
        PurInnerDealPriceCollection purInnerDealPriceCollection = iPurInnerDealPrice.getInnerDealPrice(purOrderIds);
        if (null != purInnerDealPriceCollection && 0 < purInnerDealPriceCollection.size()) {
            int length = purInnerDealPriceCollection.size();
            for (int index = 0; index < length; ++index) {
                PurInnerDealPriceInfo purInnerDealPriceInfo = purInnerDealPriceCollection.get(index);
                String purOrderEntryId = purInnerDealPriceInfo.getPurOrderEntry().getId().toString();
                String routeEntryId = purInnerDealPriceInfo.getRouteEntry().getId().toString();
                String key = purOrderEntryId + routeEntryId;
                this.purInnerDealPriceMap.put(key, purInnerDealPriceInfo);
            }
        }
    }

    private void initPurOrderIdSet(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        PurInWarehsEntryCollection purInWarehsEntrys = pi.getEntry();
        PurInWarehsEntryInfo piEntry = null;
        int length = purInWarehsEntrys.size();
        for (int i = 0; i < length; ++i) {
            piEntry = purInWarehsEntrys.get(i);
            if (!"510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(piEntry.getCoreBillType().getId().toString())) continue;
            this.purOrderIdSet.add(piEntry.getPurOrder());
        }
    }

    private void initPurOrderCollection(Context ctx) throws EASBizException, BOSException {
        StringBuffer sqlStr = new StringBuffer("where id in (");
        for (String purOrderId : this.purOrderIdSet) {
            sqlStr.append("'").append(purOrderId).append("'");
            sqlStr.append(",");
        }
        if (sqlStr.indexOf(",") > 0) {
            sqlStr.deleteCharAt(sqlStr.length() - 1);
        }
        sqlStr.append(")");
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)ctx);
        this.purOrderCollection = iPurOrder.getPurOrderCollection(sqlStr.toString());
    }

    private SettlementRouteEntryInfo handleLeafSettlementRouteEntryInfo(SettlementRouteEntryInfo settlementRouteEntryInfo) {
        if (settlementRouteEntryInfo.isIsLeaf()) {
            SettlementSteps.SimpleSettlementStep settlementStep = this.settlementSteps.getFirstStep();
            settlementRouteEntryInfo = settlementStep.getArInfo();
        }
        return settlementRouteEntryInfo;
    }

    private String getModelSettlementRelation() {
        IObjectCollection entry = (IObjectCollection)this.orginModel.get("entry");
        InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entry.getObject(0);
        String settlementRelationStr = entryInfo.get("settlementRelation").toString();
        return settlementRelationStr;
    }
}

