/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.im.inv.ITransferOrderBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBill;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleReturns;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CreateVirtualBillForSaleIssue
extends CreateVirtualBill {
    @Override
    protected boolean checkCreateVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.checkIsValid(ctx, model);
    }

    @Override
    protected boolean checkUpdateVirtualBillForReversed(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.checkIsValid(ctx, model);
    }

    private boolean checkIsValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo si = (SaleIssueBillInfo)model;
        SaleIssueEntryInfo sie = si.getEntry().get(0);
        if (sie.getCoreBillType() == null) {
            return false;
        }
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sie.getCoreBillType().getId().toString())) {
            return this.checkIsValidForSaleOrder(ctx, model);
        }
        if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(sie.getCoreBillType().getId().toString())) {
            return this.checkIsValidForSaleReturn(ctx, model);
        }
        if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(sie.getCoreBillType().getId().toString())) {
            return this.checkIsValidForTransferOrder(ctx, model);
        }
        return false;
    }

    @Override
    protected void initBillMap(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.initBillMap(ctx, model);
        SaleIssueBillInfo si = (SaleIssueBillInfo)model;
        SaleIssueEntryInfo sie = si.getEntry().get(0);
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sie.getCoreBillType().getId().toString())) {
            this.initBillMapForSaleOrder(ctx, model);
        } else if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(sie.getCoreBillType().getId().toString())) {
            this.initBillMapForSaleReturn(ctx, model);
        } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(sie.getCoreBillType().getId().toString())) {
            this.initBillMapForTransferOrder(ctx, model);
        }
    }

    private void initBillMapForSaleOrder(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo si = (SaleIssueBillInfo)model;
        BigDecimal exchangeRate = si.getExchangeRate().setScale(8, 4);
        this.billMap.put("exchangeRate", exchangeRate);
        BizTypeInfo bizType = si.getBizType();
        TransactionTypeInfo transactionTypeInfo = si.getTransactionType();
        this.billMap.put("sourceBillTable", "t_im_saleissuebill");
        this.billMap.put("sourceEntryTable", "t_im_saleissueentry");
        this.billMap.put("coreBillTable", "t_sd_saleorder");
        this.billMap.put("coreBillEntryTable", "t_sd_saleorderentry");
        this.billMap.put("coreBillIDField", "FSaleOrderID");
        this.billMap.put("coreBillEntryIDField", "FSaleOrderEntryID");
        this.billMap.put("coreBillNumber", "FSaleOrderNumber");
        this.billMap.put("coreBillSeqNo", "FSaleOrderEntrySeq");
        this.billMap.put("supplierSql", "(SELECT TOP 1 FID FROM T_BD_Supplier WHERE FInternalCompanyID = '" + (String)this.billMap.get("invCompanyOrgUnit") + "')");
        this.billMap.put("customerSql", "FCustomerID");
        this.billMap.put("balanceSupplierSql", this.getBalanceSupplierSql(this.billMap));
        this.billMap.put("balanceCustomerSql", this.getBalanceCustomerSql(this.billMap));
        this.billMap.put("storageField", "FStorageOrgUnitID");
        this.billMap.put("costInPrice", "(select top 1 FActualTaxPrice from T_SD_SaleInnerDealPrice where fsaleorderentryid = b.fid)");
        this.billMap.put("costInAmount", "a.FPrice * a.FQty");
        this.billMap.put("virtualReceiveOrgUnit", "d.FStorageOrgUnitID");
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer();
        sb.append("isnull((select top 1 FActuralPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleInnerDealPrice sidp where sidp.FSaleOrderEntryID = b.FID),0)");
        this.billMap.put("costInUnitActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1 FActuralPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleInnerDealPrice sidp where sidp.FSaleOrderEntryID = b.FID),0),21,8) * a.FQty)");
        this.billMap.put("costInActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1 FActuralPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleInnerDealPrice sidp where sidp.FSaleOrderEntryID = b.FID),0),21,8) * a.FQty)");
        this.billMap.put("costInUnWriteOffAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("(b.FActualTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID)) ");
        this.billMap.put("costOutPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(b.FActualTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID),21,8) * a.FQty)");
        this.billMap.put("costOutAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("isnull((select top 1 FActuralPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleInnerDealPrice sidp where sidp.FSaleOrderEntryID = b.FID),0)");
        this.billMap.put("costOutUnitActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1 FActuralPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleInnerDealPrice sidp where sidp.FSaleOrderEntryID = b.FID),0),21,8) * a.FQty)");
        this.billMap.put("costOutActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1 FActuralPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleInnerDealPrice sidp where sidp.FSaleOrderEntryID = b.FID),0),21,8) * a.FQty)");
        this.billMap.put("costOutUnWriteOffAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("round((decimal(isnull((select top 1 fprice from T_SD_SaleInnerDealPrice pidp where pidp.FSaleOrderEntryID = b.FID ) * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("round((decimal(isnull((select top 1 ftaxprice from T_SD_SaleInnerDealPrice pidp where pidp.FSaleOrderEntryID = b.FID ) * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInTaxPrice", sb.toString());
        this.billMap.put("costInTaxRate", "(select top 1 ftaxrate from T_SD_SaleInnerDealPrice pidp where pidp.FSaleOrderEntryID = b.FID )");
        this.billMap.put("costInDiscountRate", "(select top 1 fdiscount from T_SD_SaleInnerDealPrice pidp where pidp.FSaleOrderEntryID = b.FID )");
        this.billMap.put("costInPurchaseFee", "0.00");
        this.billMap.put("costInMaterialCost", "0.00");
        this.billMap.put("costInQty", "a.fqty");
        this.billMap.put("costInExchangeRate", "d.FExchangeRate");
        this.billMap.put("costInConvertMode", "d.FConvertMode");
        this.billMap.put("costInDiscountAmount", "round(decimal((" + this.billMap.get("costInTaxPrice") + " * " + this.billMap.get("costInDiscountRate") + "/100 * " + this.billMap.get("costInQty") + "),21,8),cur.FPrecision)");
        this.billMap.put("costInPrice", "round(decimal((" + this.billMap.get("costInTaxPrice") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))),21,8),c.FPricePrecision)");
        this.billMap.put("costInTaxAmount", "round(decimal((" + this.billMap.get("costInQty") + "*" + this.billMap.get("costInTaxPrice") + "-" + this.billMap.get("costInDiscountAmount") + "),21,8),cur.FPrecision)");
        this.billMap.put("costInTax", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))* decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8)),21,8),cur.FPrecision)");
        this.billMap.put("costInLocalTaxAmount", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTaxAmount") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
        this.billMap.put("costInAmount", "round(decimal((" + this.billMap.get("costInTaxAmount") + "-" + this.billMap.get("costInTax") + "),21,8),cur.FPrecision)");
        this.billMap.put("costInLocalTax", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTax") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTax") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
        this.billMap.put("costInActualTaxPrice", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInActualPrice", "round(decimal((" + this.billMap.get("costInAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInPurchaseCost", "round(decimal((" + this.billMap.get("costInLocalTaxAmount") + "-" + this.billMap.get("costInLocalTax") + "),21,8),lcur.FPrecision)");
        this.billMap.put("costInUnitPurchaseCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInActualCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "+" + this.billMap.get("costInPurchaseFee") + "+" + this.billMap.get("costInMaterialCost") + "),21,8),lcur.FPrecision)");
        this.billMap.put("costInUnitActualCost", "round(decimal((" + this.billMap.get("costInActualCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInUnWriteOffAmount", this.billMap.get("costInPurchaseCost"));
    }

    private void initBillMapForSaleReturn(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo si = (SaleIssueBillInfo)model;
        BigDecimal exchangeRate = si.getExchangeRate().setScale(8, 4);
        this.billMap.put("exchangeRate", exchangeRate);
        this.billMap.put("sourceBillTable", "t_im_saleissuebill");
        this.billMap.put("sourceEntryTable", "t_im_saleissueentry");
        this.billMap.put("coreBillTable", "t_sd_salereturns");
        this.billMap.put("coreBillEntryTable", "t_sd_salereturnsentry");
        this.billMap.put("coreBillIDField", "FSaleOrderID");
        this.billMap.put("coreBillEntryIDField", "FSaleOrderEntryID");
        this.billMap.put("coreBillNumber", "FSaleOrderNumber");
        this.billMap.put("coreBillSeqNo", "FSaleOrderEntrySeq");
        this.billMap.put("supplierSql", "(SELECT TOP 1 FID FROM T_BD_Supplier WHERE FInternalCompanyID = '" + (String)this.billMap.get("invCompanyOrgUnit") + "')");
        this.billMap.put("customerSql", "FCustomerID");
        this.billMap.put("balanceSupplierSql", this.getBalanceSupplierSql(this.billMap));
        this.billMap.put("balanceCustomerSql", this.getBalanceCustomerSql(this.billMap));
        this.billMap.put("storageField", "FStorageOrgUnitID");
        this.billMap.put("costInPrice", "(select top 1 FActualTaxPrice from T_SD_SaleReturnInnerDealPrice where fsaleretrunentryid = b.fid)");
        this.billMap.put("costInAmount", "a.FPrice * a.FQty");
        this.billMap.put("virtualReceiveOrgUnit", "d.FStorageOrgUnitID");
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer();
        sb.append("isnull((select top 1 FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleReturnInnerDealPrice sidp where sidp.fsaleretrunentryid = b.FID),0)");
        this.billMap.put("costInUnitActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1 FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleReturnInnerDealPrice sidp where sidp.fsaleretrunentryid = b.FID),0),21,8) * a.FQty)");
        this.billMap.put("costInActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1 FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleReturnInnerDealPrice sidp where sidp.fsaleretrunentryid = b.FID),0),21,8) * a.FQty)");
        this.billMap.put("costInUnWriteOffAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("(b.FTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID)) ");
        this.billMap.put("costOutPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(b.FTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID),21,8) * a.FQty)");
        this.billMap.put("costOutAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("isnull((select top 1  FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleReturnInnerDealPrice sidp where sidp.fsaleretrunentryid = b.FID),0)");
        this.billMap.put("costOutUnitActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1  FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleReturnInnerDealPrice sidp where sidp.fsaleretrunentryid = b.FID),0),21,8) * a.FQty)");
        this.billMap.put("costOutActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1  FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SD_SaleReturnInnerDealPrice sidp where sidp.fsaleretrunentryid = b.FID),0),21,8) * a.FQty)");
        this.billMap.put("costOutUnWriteOffAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("round((decimal(isnull((select top 1 fprice from T_SD_SaleReturnInnerDealPrice pidp where pidp.FSaleRetrunEntryID = b.FID ) * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("round((decimal(isnull((select top 1 ftaxprice from T_SD_SaleReturnInnerDealPrice pidp where pidp.FSaleRetrunEntryID = b.FID ) * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInTaxPrice", sb.toString());
        this.billMap.put("costInTaxRate", "isnull((select top 1 ftaxrate from T_SD_SaleReturnInnerDealPrice pidp where pidp.FSaleRetrunEntryID = b.FID ),0)");
        this.billMap.put("costInDiscountRate", "isnull((select top 1 fdiscount from T_SD_SaleReturnInnerDealPrice pidp where pidp.FSaleRetrunEntryID = b.FID ),0)");
        this.billMap.put("costInPurchaseFee", "0.00");
        this.billMap.put("costInMaterialCost", "0.00");
        this.billMap.put("costInQty", "decimal(isnull(a.fqty,0),21,8)");
        this.billMap.put("costInExchangeRate", "decimal(isnull(d.FExchangeRate,0),21,8)");
        this.billMap.put("costInConvertMode", "isnull(d.FConvertMode,0)");
        this.billMap.put("costInDiscountAmount", "round(decimal((" + this.billMap.get("costInTaxPrice") + " * " + this.billMap.get("costInDiscountRate") + "/100 * " + this.billMap.get("costInQty") + "),21,8),cur.FPrecision)");
        this.billMap.put("costInPrice", "round(decimal((" + this.billMap.get("costInTaxPrice") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))),21,8),c.FPricePrecision)");
        this.billMap.put("costInTaxAmount", "round(decimal((" + this.billMap.get("costInQty") + "*" + this.billMap.get("costInTaxPrice") + "-" + this.billMap.get("costInDiscountAmount") + "),21,8),cur.FPrecision)");
        this.billMap.put("costInTax", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))*decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8)),21,8),cur.FPrecision)");
        this.billMap.put("costInLocalTaxAmount", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTaxAmount") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
        this.billMap.put("costInAmount", "round(decimal((" + this.billMap.get("costInTaxAmount") + "-" + this.billMap.get("costInTax") + "),21,8),cur.FPrecision)");
        this.billMap.put("costInLocalTax", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTax") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTax") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
        this.billMap.put("costInActualTaxPrice", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInActualPrice", "round(decimal((" + this.billMap.get("costInAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInPurchaseCost", "round(decimal((" + this.billMap.get("costInLocalTaxAmount") + "-" + this.billMap.get("costInLocalTax") + "),21,8),lcur.FPrecision)");
        this.billMap.put("costInUnitPurchaseCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInActualCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "+" + this.billMap.get("costInPurchaseFee") + "+" + this.billMap.get("costInMaterialCost") + "),21,8),lcur.FPrecision)");
        this.billMap.put("costInUnitActualCost", "round(decimal((" + this.billMap.get("costInActualCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInUnWriteOffAmount", this.billMap.get("costInPurchaseCost"));
    }

    private boolean checkIsValidForSaleOrder(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo si = (SaleIssueBillInfo)model;
        SaleIssueEntryInfo sie = si.getEntry().get(0);
        if (!(sie.getCoreBillType() != null && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sie.getCoreBillType().getId().toString()) || si.isIsReversed())) {
            return false;
        }
        SaleOrderInfo so = null;
        boolean val = false;
        ISCMBillCommonFacade iScmFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        Vector<StorageOrgUnitInfo> vector = new Vector<StorageOrgUnitInfo>();
        StringBuffer coreIds = new StringBuffer();
        for (int i = 0; i < si.getEntry().size(); ++i) {
            sie = si.getEntry().get(i);
            if (!sie.isIsCenterBalance() || !sie.isIsBetweenCompanySend() || sie.getSaleOrder() == null) continue;
            if (coreIds.length() > 0) {
                coreIds.append(",");
            }
            coreIds.append(sie.getSaleOrder());
        }
        if (coreIds.length() > 0) {
            HashMap<String, PurchaseOrgUnitInfo> paramMap = new HashMap<String, PurchaseOrgUnitInfo>();
            SaleOrderCollection saleorderCollection = this.getSaleOrderCollection(ctx, coreIds.toString());
            if (saleorderCollection != null && saleorderCollection.size() > 0) {
                val = true;
                int size = saleorderCollection.size();
                for (int i = 0; i < size; ++i) {
                    PurchaseOrgUnitInfo pouInfo;
                    so = saleorderCollection.get(i);
                    if (so.getStorageOrgUnit() == null || vector.contains(so.getStorageOrgUnit())) continue;
                    String souId = so.getStorageOrgUnit().getId().toString();
                    if (paramMap.containsKey(souId)) {
                        pouInfo = (PurchaseOrgUnitInfo)paramMap.get(souId);
                    } else {
                        pouInfo = iScmFacade.getPurchaseByStorageOrg(souId);
                        paramMap.put(souId, pouInfo);
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orderStorageOrgUnit", souId);
                    map.put("orderCompanyOrgUnit", so.getCompanyOrgUnit().getId().toString());
                    map.put("currency", so.getCurrency());
                    map.put("amountPrecision", new Integer(so.getCurrency().getPrecision()));
                    map.put("virtualPurOrgUnit", pouInfo == null ? null : pouInfo.getId().toString());
                    map.put("virtualSaleOrgUnit", so.getSaleOrgUnit().getId().toString());
                    if (so.getWarehouse() != null) {
                        map.put("warehouse", so.getWarehouse().getId().toString());
                        if (so.getWarehouse().getWhman() != null) {
                            map.put("stocker", so.getWarehouse().getWhman().getId().toString());
                        } else {
                            map.put("stocker", "");
                        }
                    }
                    this.sepBillArray.add(map);
                    vector.add(so.getStorageOrgUnit());
                }
            }
        }
        this.checkVirtualBizDateValid(ctx, si, sie, val);
        return val;
    }

    private SaleOrderCollection getSaleOrderCollection(Context ctx, String coreIds) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("currency.precision"));
        sc.add(new SelectorItemInfo("warehouse.id"));
        sc.add(new SelectorItemInfo("warehouse.whman.id"));
        sc.add(new SelectorItemInfo("storageOrgUnit"));
        viewInfo.setSelector(sc);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)coreIds, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
        SaleOrderCollection saleorderCollection = iSaleOrder.getSaleOrderCollection(viewInfo);
        return saleorderCollection;
    }

    private boolean checkIsValidForSaleReturn(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo si = (SaleIssueBillInfo)model;
        if (si == null || si.getEntry() == null || si.getEntry().size() <= 0) {
            return false;
        }
        SaleIssueEntryInfo sie = si.getEntry().get(0);
        if (!(sie.getCoreBillType() != null && "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(sie.getCoreBillType().getId().toString()) || si.isIsReversed())) {
            return false;
        }
        ISaleReturns saleReturns = SaleReturnsFactory.getLocalInstance((Context)ctx);
        SaleReturnsInfo saleReturnsInfo = null;
        boolean val = false;
        ISCMBillCommonFacade iScmFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        Vector<StorageOrgUnitInfo> vector = new Vector<StorageOrgUnitInfo>();
        for (int i = 0; i < si.getEntry().size(); ++i) {
            sie = si.getEntry().get(i);
            if (!sie.isIsCenterBalance() || !sie.isIsBetweenCompanySend() || sie.getSaleOrder() == null || !saleReturns.exists((IObjectPK)new ObjectUuidPK(sie.getSaleOrder()))) continue;
            val = true;
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("currency.precision"));
            saleReturnsInfo = saleReturns.getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(sie.getSaleOrder()), sc);
            if (vector.contains(saleReturnsInfo.getStorageOrgUnit())) continue;
            String souId = saleReturnsInfo.getStorageOrgUnit().getId().toString();
            PurchaseOrgUnitInfo pouInfo = iScmFacade.getPurchaseByStorageOrg(souId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orderStorageOrgUnit", souId);
            map.put("orderCompanyOrgUnit", saleReturnsInfo.getCompanyOrgUnit().getId().toString());
            map.put("currency", saleReturnsInfo.getCurrency());
            map.put("amountPrecision", new Integer(saleReturnsInfo.getCurrency().getPrecision()));
            map.put("virtualPurOrgUnit", pouInfo == null ? null : pouInfo.getId().toString());
            map.put("virtualSaleOrgUnit", saleReturnsInfo.getSaleOrgUnit().getId().toString());
            this.sepBillArray.add(map);
            vector.add(saleReturnsInfo.getStorageOrgUnit());
        }
        return val;
    }

    private boolean checkIsValidForTransferOrder(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo si = (SaleIssueBillInfo)model;
        SaleIssueEntryInfo sie = si.getEntry().get(0);
        if (sie.getCoreBillType() == null) {
            return false;
        }
        if (!("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(si.getBizType().getId().toString()) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(si.getBizType().getId().toString()) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(si.getBizType().getId().toString()) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(si.getBizType().getId().toString()))) {
            return false;
        }
        ITransferOrderBill is = TransferOrderBillFactory.getLocalInstance(ctx);
        TransferOrderBillInfo to = null;
        boolean val = false;
        Vector<StorageOrgUnitInfo> vector = new Vector<StorageOrgUnitInfo>();
        for (int i = 0; i < si.getEntry().size(); ++i) {
            sie = si.getEntry().get(i);
            if (sie.getSaleOrder() == null || !is.exists((IObjectPK)new ObjectUuidPK(sie.getSaleOrder()))) continue;
            val = true;
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("currency.precision"));
            to = is.getTransferOrderBillInfo((IObjectPK)new ObjectUuidPK(sie.getSaleOrder()), sc);
            if (vector.contains(to.getIssueStorageOrgUnit())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orderStorageOrgUnit", to.getIssueStorageOrgUnit().getId().toString());
            map.put("orderCompanyOrgUnit", to.getIssueCompanyOrgUnit().getId().toString());
            map.put("currency", to.getCurrency());
            map.put("amountPrecision", new Integer(to.getCurrency().getPrecision()));
            this.sepBillArray.add(map);
            vector.add(to.getIssueStorageOrgUnit());
        }
        this.checkVirtualBizDateValid(ctx, si, sie, val);
        return val;
    }

    @Override
    protected String getBalanceSupplierSql(Map map) {
        String bizTypeID = (String)map.get("bizTypeID");
        String sql = null;
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID)) {
            sql = "(SELECT TOP 1 FID FROM T_BD_Supplier WHERE FInternalCompanyID = (SELECT FIssueCompanyOrgUnitID FROM T_IM_TransferOrderBillEntry WHERE FID = b.FID))";
        }
        return sql;
    }

    @Override
    protected String getBalanceCustomerSql(Map map) {
        String bizTypeID = (String)map.get("bizTypeID");
        String sql = null;
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID)) {
            sql = "(SELECT TOP 1 FID FROM T_BD_Customer WHERE FInternalCompanyID = (SELECT FReceiveCompanyOrgUnitID FROM T_IM_TransferOrderBillEntry WHERE FID = b.FID))";
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID)) {
            sql = "(SELECT TOP 1 FID FROM T_BD_Customer WHERE FInternalCompanyID = (SELECT FReceiptCompanyOrgUnitID FROM T_IM_TransferOrderBill WHERE FID = d.FID))";
        }
        return sql;
    }

    private void initBillMapForTransferOrder(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo si = (SaleIssueBillInfo)model;
        BigDecimal exchangeRate = si.getExchangeRate().setScale(8, 4);
        this.billMap.put("exchangeRate", exchangeRate);
        this.billMap.put("sourceBillTable", "t_im_saleissuebill");
        this.billMap.put("sourceEntryTable", "t_im_saleissueentry");
        this.billMap.put("coreBillTable", "T_IM_TransferOrderBill");
        this.billMap.put("coreBillEntryTable", "T_IM_TransferOrderBillEntry");
        this.billMap.put("coreBillIDField", "FSaleOrderID");
        this.billMap.put("coreBillEntryIDField", "FSaleOrderEntryID");
        this.billMap.put("coreBillNumber", "FSaleOrderNumber");
        this.billMap.put("coreBillSeqNo", "FSaleOrderEntrySeq");
        this.billMap.put("supplierSql", "(SELECT TOP 1 FID FROM T_BD_Supplier WHERE FInternalCompanyID = '" + (String)this.billMap.get("invCompanyOrgUnit") + "')");
        this.billMap.put("customerSql", "FCustomerID");
        this.billMap.put("balanceSupplierSql", this.getBalanceSupplierSql(this.billMap));
        this.billMap.put("balanceCustomerSql", this.getBalanceCustomerSql(this.billMap));
        this.billMap.put("storageField", "FIssueStorageOrgUnitID");
        this.billMap.put("virtualReceiveOrgUnit", "b.FReceiveStorageOrgUnitID");
        String selectActualPrice = "isnull((SELECT TOP 1 decimal(FActualPrcie,21,8) FROM T_IM_MultiSidesTransferPrices WHERE FTransferBillEntryID = b.FID AND FBizRole = 4),0)";
        StringBuffer sb = new StringBuffer();
        sb.append("(decimal(isnull(");
        sb.append("(").append(selectActualPrice).append(")");
        sb.append("* (select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) ");
        this.billMap.put("costInPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull(");
        sb.append("(").append(selectActualPrice).append(")");
        sb.append("* (select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * decimal(a.FQty,21,8)");
        this.billMap.put("costInAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("((decimal(isnull(");
        sb.append("(").append(selectActualPrice).append(")");
        sb.append("* (select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * ");
        sb.append(exchangeRate).append(")");
        this.billMap.put("costInUnitActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("((decimal(isnull(");
        sb.append("(").append(selectActualPrice).append(")");
        sb.append("* (select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * ");
        sb.append(exchangeRate).append(") * decimal(a.FQty,21,8)");
        this.billMap.put("costInActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("((decimal(isnull(");
        sb.append("(").append(selectActualPrice).append(")");
        sb.append("* (select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * ");
        sb.append(exchangeRate).append(") * decimal(a.FQty,21,8)");
        this.billMap.put("costInUnWriteOffAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull(b.FActualTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8))");
        this.billMap.put("costOutPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull(b.FActualTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * a.FQty");
        this.billMap.put("costOutAmount", sb.toString());
        this.billMap.put("costOutUnitActualCost", "0");
        this.billMap.put("costOutActualCost", "0");
        this.billMap.put("costOutUnWriteOffAmount", "0");
        sb = new StringBuffer();
        sb.append("round((decimal(isnull(isnull((SELECT TOP 1 decimal(fprice,21,8) FROM T_IM_MultiSidesTransferPrices WHERE FTransferBillEntryID = b.FID AND FBizRole = 4),0) * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("round((decimal(isnull(isnull((SELECT TOP 1 decimal(ftaxprice,21,8) FROM T_IM_MultiSidesTransferPrices WHERE FTransferBillEntryID = b.FID AND FBizRole = 4),0) * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInTaxPrice", sb.toString());
        this.billMap.put("costInTaxRate", "decimal(isnull((select top 1 ftaxrate from T_IM_MultiSidesTransferPrices where FTransferBillEntryID = b.FID  AND FBizRole = 4),0),21,8)");
        this.billMap.put("costInDiscountRate", "decimal(isnull((select top 1 fdiscountrate from T_IM_MultiSidesTransferPrices where FTransferBillEntryID = b.FID  AND FBizRole = 4),0),21,8)");
        this.billMap.put("costInConvertMode", " 0 ");
        this.billMap.put("costInPurchaseFee", "0.00");
        this.billMap.put("costInMaterialCost", "0.00");
        this.billMap.put("costInQty", "decimal(isnull(a.fqty,0),21,8)");
        this.billMap.put("costInExchangeRate", "decimal(isnull(d.FExchangeRate,0),21,8)");
        this.billMap.put("costInDiscountAmount", "round(decimal((" + this.billMap.get("costInTaxPrice") + " * " + this.billMap.get("costInDiscountRate") + "/100 * " + this.billMap.get("costInQty") + "),21,8),cur.FPrecision)");
        this.billMap.put("costInPrice", "round(decimal((" + this.billMap.get("costInTaxPrice") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))),21,8),c.FPricePrecision)");
        this.billMap.put("costInTaxAmount", "round(decimal((" + this.billMap.get("costInQty") + "*" + this.billMap.get("costInTaxPrice") + "-" + this.billMap.get("costInDiscountAmount") + "),21,8),cur.FPrecision)");
        this.billMap.put("costInTax", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))* decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8)),21,8),cur.FPrecision)");
        this.billMap.put("costInLocalTaxAmount", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTaxAmount") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
        this.billMap.put("costInAmount", "round(decimal((" + this.billMap.get("costInTaxAmount") + "-" + this.billMap.get("costInTax") + "),21,8),cur.FPrecision)");
        this.billMap.put("costInLocalTax", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTax") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTax") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
        this.billMap.put("costInActualTaxPrice", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInActualPrice", "round(decimal((" + this.billMap.get("costInAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInPurchaseCost", "round(decimal((" + this.billMap.get("costInLocalTaxAmount") + "-" + this.billMap.get("costInLocalTax") + "),21,8),lcur.FPrecision)");
        this.billMap.put("costInUnitPurchaseCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInActualCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "+" + this.billMap.get("costInPurchaseFee") + "+" + this.billMap.get("costInMaterialCost") + "),21,8),lcur.FPrecision)");
        this.billMap.put("costInUnitActualCost", "round(decimal((" + this.billMap.get("costInActualCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        this.billMap.put("costInUnWriteOffAmount", this.billMap.get("costInPurchaseCost"));
    }

    protected void checkVirtualBizDateValid(Context ctx, InvBillBaseInfo bill, InvBillBaseEntryInfo entry, boolean isOK) throws BOSException, EASBizException {
        if (isOK) {
            TransferOrderBillInfo transferOrder;
            SaleIssueBillInfo si = (SaleIssueBillInfo)bill;
            SaleIssueEntryInfo sie = si.getEntry().get(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = entry.getCompanyOrgUnit();
            if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sie.getCoreBillType().getId().toString())) {
                SaleOrderInfo saleOrder;
                if (sie.getSaleOrder() != null && (saleOrder = SaleOrderFactory.getLocalInstance((Context)ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(sie.getSaleOrder()))) != null) {
                    aCompanyOrgUnitInfo = saleOrder.getCompanyOrgUnit();
                }
            } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(sie.getCoreBillType().getId().toString()) && sie.getSaleOrder() != null && (transferOrder = TransferOrderBillFactory.getLocalInstance(ctx).getTransferOrderBillInfo((IObjectPK)new ObjectUuidPK(sie.getSaleOrder()))) != null) {
                aCompanyOrgUnitInfo = transferOrder.getIssueCompanyOrgUnit();
            }
            if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
                aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getId()));
            }
            if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
                PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
                if (currentPeriodInfo == null) {
                    Object[] temp = new String[]{aCompanyOrgUnitInfo.getNumber()};
                    throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL_VIRTUAL, temp);
                }
                if (bill.getBizDate() == null) {
                    throw new SCMBillException(SCMBillException.BIZDATEISNULL_VIRTUAL);
                }
                if (bill.getBizDate().before(currentPeriodInfo.getBeginDate())) {
                    Object[] temp = new String[2];
                    StringBuffer sb = new StringBuffer();
                    sb.append(currentPeriodInfo.getBeginDate().getYear() + 1900);
                    sb.append("-");
                    int month = currentPeriodInfo.getBeginDate().getMonth() + 1;
                    if (month < 10) {
                        sb.append("0");
                    }
                    sb.append(month);
                    sb.append("-");
                    int date = currentPeriodInfo.getBeginDate().getDate();
                    if (date < 10) {
                        sb.append("0");
                    }
                    sb.append(date);
                    temp[0] = aCompanyOrgUnitInfo.getNumber();
                    temp[1] = sb.toString();
                    throw new SCMBillException(SCMBillException.BIZDATEAFTERPERIOD_VIRTUAL, temp);
                }
                if (!bill.getBizDate().before(currentPeriodInfo.getBeginDate()) && !bill.getBizDate().after(currentPeriodInfo.getEndDate()) && SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo)) {
                    Object[] temp = new String[]{aCompanyOrgUnitInfo.getNumber()};
                    throw new SCMBillException(SCMBillException.CURRENT_PERIOD_COLSED_VIRTUAL, temp);
                }
            }
        }
    }

    @Override
    protected String getCostOutHeadSql() {
        return "";
    }

    @Override
    protected String getCostOutEntrySql() {
        return "";
    }
}

