/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.AbstractInvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBillForSaleIssue;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.SaleIssueAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.util.AccountViewUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CreateVirtualBillForSaleIssueViaBotp
extends CreateVirtualBillForSaleIssue {
    protected void createBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (null != model && model instanceof SaleIssueBillInfo && this.isSaleBack((SaleIssueBillInfo)model)) {
            this.createInvVirtualBill(ctx, model, PurInWarehsBillFactory.getLocalInstance(ctx), this.getPurInBOTPName(ctx, model));
            this.createInvVirtualBill(ctx, model, SaleIssueBillFactory.getLocalInstance(ctx), this.getSaleIssueBOTPName(ctx, model));
        } else {
            this.createInvVirtualBill(ctx, model, PurInWarehsBillFactory.getLocalInstance(ctx), this.getPurInBOTPName(ctx, model));
            this.createInvVirtualBill(ctx, model, SaleIssueBillFactory.getLocalInstance(ctx), this.getSaleIssueBOTPName(ctx, model));
        }
    }

    private boolean isSaleBack(SaleIssueBillInfo saleIssueBillInfo) {
        if (null == saleIssueBillInfo || saleIssueBillInfo.getTransactionType() == null) {
            return false;
        }
        BizTypeInfo bizType = saleIssueBillInfo.getBizType();
        TransactionTypeInfo transactionType = saleIssueBillInfo.getTransactionType();
        if (transactionType != null && bizType != null && ("d8e80652-0110-1000-e000-04c5c0a812202407435C".equals(bizType.getId().toString()) || "wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizType.getId().toString()))) {
            return true;
        }
        return saleIssueBillInfo.getEntry().get(0).getCoreBillType() != null && "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(saleIssueBillInfo.getEntry().get(0).getCoreBillType().getId().toString());
    }

    @Override
    protected void createVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!this.checkCreateVirtualBill(ctx, model)) {
            return;
        }
        this.createBill(ctx, model);
    }

    @Override
    protected void updateVirtualBillForReversed(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    private void afterVirtualBill(Context ctx, CoreBillBaseInfo srcBillInfo, CoreBillBaseInfo destBillBaseInfo) throws BOSException, EASBizException {
        SCMServerUtils.traceUpAndDown((Context)ctx, (String)srcBillInfo.getId().toString(), (String)destBillBaseInfo.getId().toString(), (String)srcBillInfo.getBOSType().toString(), (String)destBillBaseInfo.getBOSType().toString());
    }

    private void checkMatCompanyInfo(Context ctx, InvBillBaseInfo info) throws BOSException, EASBizException {
        InvServerUtils.checkMatCompanyInfo(ctx, info, InvBizException.MATERIAL_COMPANY_NULL_VIRTUAL);
        if (info.isIsInitBill()) {
            SCMServerUtils.checkInitBizDate((Context)ctx, (SCMBillBaseInfo)info, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(info), (boolean)true);
        } else {
            SCMServerUtils.checkBizDate((Context)ctx, (IObjectValue)info, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(info), (boolean)true);
        }
    }

    private void createInvVirtualBill(Context ctx, IObjectValue model, IInvBillBase invBillBase, String botpName) throws BOSException, EASBizException {
        InvBillBaseEntryInfo entry;
        InvBillBaseInfo info;
        int i;
        SaleIssueBillInfo saleInfo = (SaleIssueBillInfo)model;
        CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
        coreBillBaseColl.add((CoreBillBaseInfo)model);
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpName + "'");
        }
        catch (Exception e) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
        }
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coreBillBaseColl, botMappingInfo);
        IObjectCollection infos = transformResult.getBills();
        SaleIssueBillCollection saleIssueBillCol = new SaleIssueBillCollection();
        for (i = 0; i < infos.size(); ++i) {
            info = (InvBillBaseInfo)infos.getObject(i);
            if ("com.kingdee.eas.scm.im.inv.PurInWarehsBill".equals(invBillBase.getName()) && info instanceof PurInWarehsBillInfo) {
                PurInWarehsBillInfo purInwarehsInfo = (PurInWarehsBillInfo)info;
                SaleIssueEntryInfo entry2 = null;
                if (saleInfo.getEntry() != null && saleInfo.getEntry().size() > 0 && ((entry2 = saleInfo.getEntry().get(0)).isIsCenterBalance() || entry2.isIsSquareBalance())) {
                    CompanyOrgUnitInfo purCou = purInwarehsInfo.getEntry().get(0).getCompanyOrgUnit();
                    CompanyOrgUnitInfo siCou = entry2.getCompanyOrgUnit();
                    ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                    SupplierCollection innerSupplierCollection = iSupplier.getInterSupplierCollection(siCou.getId().toString(), null);
                    SupplierInfo supplier = null;
                    if (innerSupplierCollection != null && innerSupplierCollection.size() > 0) {
                        for (int j = 0; j < innerSupplierCollection.size(); ++j) {
                            SupplierInfo innerSupplier = innerSupplierCollection.get(j);
                            if (iSupplier.getCompanyInfo(innerSupplier.getNumber(), purCou.getNumber()) == null) continue;
                            supplier = innerSupplier;
                            break;
                        }
                    }
                    if (supplier == null) {
                        throw new InvBizException(InvBizException.HAS_NO_INNER_SUPPLIER);
                    }
                }
            }
            info.setNumber(info.getNumber() + (char)(i + 65));
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setAuditTime(new Timestamp(new Date().getTime()));
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
            info.setIsReversed(false);
            info.put("isSysBill", Boolean.TRUE);
            CompanyOrgUnitInfo company = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)company);
            if (period != null) {
                info.setYear(period.getPeriodYear());
                info.setPeriod(period.getPeriodNumber());
            }
            info.setMonth(model.getInt("month"));
            info.setDay(model.getInt("day"));
            if (model.get("entry") != null) {
                entry = (InvBillBaseEntryInfo)((IObjectCollection)model.get("entry")).getObject(0);
                info.put("VT_StorageOrgUnitID", entry.getStorageOrgUnit().getId().toString());
                info.put("VT_CompanyOrgUnitID", entry.getCompanyOrgUnit().getId().toString());
            }
            if (!(info instanceof SaleIssueBillInfo)) continue;
            saleIssueBillCol.add((SaleIssueBillInfo)info);
        }
        if (saleIssueBillCol.size() > 0) {
            this.calVirtualSaleIssueBillCost(ctx, saleIssueBillCol, saleInfo);
        }
        invBillBase.handleAfterTransform("SAVE", infos);
        for (i = 0; i < infos.size(); ++i) {
            info = (InvBillBaseInfo)infos.getObject(i);
            if (info != null && info.getTransactionType() == null) {
                throw new InvBizException(InvBizException.TRANSACTION_CHECK_ERROR);
            }
            String billTypeID = null;
            if (null != info.getBillType()) {
                billTypeID = info.getBillType().getId().toString();
            }
            IObjectCollection entries = info.getEntries();
            entry = null;
            CoreBaseCollection coll = InvCommonUtils.getSourceBillCollection(ctx, entries);
            if (!CollectionUtil.isEmpty((IObjectCollection)entries)) {
                EntityViewInfo view = null;
                InvUpdateTypeInfo invUpdateType = null;
                int size = entries.size();
                for (int index = 0; index < size; ++index) {
                    entry = (InvBillBaseEntryInfo)entries.getObject(index);
                    view = InvCommonUtils.buildInvUpdateTypeEntityView(ctx, info, index, false, coll);
                    invUpdateType = InvCommonUtils.getDefaultInvUpdateTypeInfo(ctx, view);
                    if (invUpdateType == null) {
                        AbstractInvBillBaseEntryInfo srcEntry = null;
                        if (model.get("entry") != null && !CollectionUtil.isEmpty((IObjectCollection)((IObjectCollection)model.get("entry")))) {
                            IObjectCollection col = (IObjectCollection)model.get("entry");
                            for (int mm = 0; mm < col.size(); ++mm) {
                                if (!col.getObject(mm).get("id").toString().equals(entry.getSourceBillEntryId())) continue;
                                srcEntry = (InvBillBaseEntryInfo)col.getObject(mm);
                                break;
                            }
                        }
                        if (srcEntry == null || srcEntry.getInvUpdateType() == null) continue;
                        InvUpdateTypeInfo srcInvUpdateType = srcEntry.getInvUpdateType();
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("id"));
                        selector.add(new SelectorItemInfo("number"));
                        selector.add(new SelectorItemInfo("name"));
                        selector.add(new SelectorItemInfo("existingQty"));
                        selector.add(new SelectorItemInfo("existingQtyPre"));
                        selector.add(new SelectorItemInfo("isNotUpdateInv"));
                        selector.add(new SelectorItemInfo("scheduled"));
                        selector.add(new SelectorItemInfo("status"));
                        selector.add(new SelectorItemInfo("storeType.id"));
                        selector.add(new SelectorItemInfo("storeType.number"));
                        selector.add(new SelectorItemInfo("storeType.name"));
                        selector.add(new SelectorItemInfo("storeType.storeFlag"));
                        selector.add(new SelectorItemInfo("storeType.isForwardAmt"));
                        selector.add(new SelectorItemInfo("storeState.id"));
                        selector.add(new SelectorItemInfo("storeState.number"));
                        selector.add(new SelectorItemInfo("storeState.name"));
                        selector.add(new SelectorItemInfo("storeTypePre.id"));
                        selector.add(new SelectorItemInfo("storeTypePre.number"));
                        selector.add(new SelectorItemInfo("storeTypePre.name"));
                        selector.add(new SelectorItemInfo("storeTypePre.storeFlag"));
                        selector.add(new SelectorItemInfo("storeTypePre.isForwardAmt"));
                        selector.add(new SelectorItemInfo("storeStatePre.id"));
                        selector.add(new SelectorItemInfo("storeStatePre.number"));
                        selector.add(new SelectorItemInfo("storeStatePre.name"));
                        srcInvUpdateType = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK(srcInvUpdateType.getId()), selector);
                        StoreTypeInfo storeType = srcInvUpdateType.getStoreType();
                        StoreStateInfo storeState = srcInvUpdateType.getStoreState();
                        StoreTypeInfo storeTypePre = srcInvUpdateType.getStoreTypePre();
                        StoreStateInfo storeStatePre = srcInvUpdateType.getStoreStatePre();
                        String storeTypeName = "";
                        String storeStateName = "";
                        if (storeType != null && storeState != null) {
                            storeTypeName = storeType.getName();
                            storeStateName = storeState.getName();
                        } else if (storeTypePre != null && storeStatePre != null) {
                            storeTypeName = storeTypePre.getName();
                            storeStateName = storeStatePre.getName();
                        }
                        if (SCMBaseCommonUtil.isInWarehsBill((String)billTypeID)) {
                            throw new InvBizException(InvBizException.IN_INVUPDATETYPE_ISNOT_EXIST, new String[]{storeTypeName, storeStateName});
                        }
                        if (!SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID)) continue;
                        throw new InvBizException(InvBizException.ISSUE_INVUPDATETYPE_ISNOT_EXIST, new String[]{storeTypeName, storeStateName});
                    }
                    entry.setInvUpdateType(invUpdateType);
                }
            }
            info.setCU(info.getStorageOrgUnit().getCU());
            invBillBase.addnew((CoreBaseInfo)info);
            this.afterVirtualBill(ctx, (CoreBillBaseInfo)model, (CoreBillBaseInfo)info);
            IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
            if (info.getTransactionType() != null) {
                iInventoryUpdate.updateInventory(info.getId().toString(), BizActionEnum.AUDIT);
            }
            if (this.isSaleBack(saleInfo)) {
                StringBuffer updateSql = new StringBuffer();
                String billTable = "T_IM_SALEISSUEBILL";
                String entryTable = "T_IM_SALEISSUEENTRY";
                if (info instanceof PurInWarehsBillInfo) {
                    billTable = "T_IM_PURINWAREHSBILL";
                    entryTable = "T_IM_PURINWAREHSENTRY";
                }
                updateSql.append(" update " + entryTable + " redVSEn set (FSOURCEBILLID,FSOURCEBILLENTRYID) = ");
                updateSql.append(" (select blueVSEn.FPARENTID,blueVSEn.fid ");
                updateSql.append(" from T_IM_SALEISSUEENTRY redSEn inner join " + entryTable);
                updateSql.append(" blueVSEn on blueVSEn.FSOURCEBILLENTRYID = redSEn.FSOURCEBILLENTRYID ");
                updateSql.append(" inner join " + billTable + " blueVS on  blueVS.fid = blueVSEn.FPARENTID ");
                updateSql.append(" where redSEn.FPARENTID  = '" + saleInfo.getId().toString() + "' ");
                updateSql.append(" and blueVS.FISSYSBILL = 1 ");
                updateSql.append(" and redVSEn.FSOURCEBILLENTRYID  = redSEn.fid ");
                updateSql.append(" )");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
            this.calculateBill(ctx, info);
            this.checkMatCompanyInfo(ctx, info);
            AccountViewUtil.updateAccountView(ctx, infos);
        }
    }

    private void calVirtualSaleIssueBillCost(Context ctx, SaleIssueBillCollection infos, SaleIssueBillInfo sourceInfo) throws BOSException {
        if (null == infos || infos.size() == 0) {
            return;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> couIdSet = new HashSet<String>();
        HashSet<String> unitIdSet = new HashSet<String>();
        for (int i = 0; i < infos.size(); ++i) {
            SaleIssueBillInfo info = infos.get(i);
            SaleIssueEntryCollection entryCol = info.getEntry();
            if (null == entryCol || entryCol.size() == 0) continue;
            SaleIssueEntryInfo entry = null;
            int len = entryCol.size();
            for (int j = 0; j < len; ++j) {
                entry = entryCol.get(j);
                if (null != entry.getUnit()) {
                    unitIdSet.add(entry.getUnit().getId().toString());
                }
                if (null == entry.getMaterial() || null == entry.getCompanyOrgUnit()) continue;
                materialIdSet.add(entry.getMaterial().getId().toString());
                couIdSet.add(entry.getCompanyOrgUnit().getId().toString());
            }
        }
        Map materialCompanyMap = this.getMaterialCompanyInfo(ctx, materialIdSet, couIdSet);
        Map mmuMap = this.getMultiMeasureUnit(ctx, materialIdSet, unitIdSet);
        this.calEntryCost(ctx, infos, materialCompanyMap, mmuMap, sourceInfo);
    }

    private String getPurInBOTPName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SaleIssueBillInfo pi = (SaleIssueBillInfo)model;
        SaleIssueEntryInfo pie = pi.getEntry().get(0);
        SaleIssueAlgorithmForInfo siAlg = new SaleIssueAlgorithmForInfo(pi, ctx);
        boolean isNegativeBill = siAlg.isNegativeBill();
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(pie.getCoreBillType().getId().toString())) {
            if (isNegativeBill) {
                return "SaleIssue_PurInVirtualBill_SaleBacking_Ordering";
            }
            return "SaleIssue_PurInVirtualBill_Issuing";
        }
        if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(pie.getCoreBillType().getId().toString())) {
            if (isNegativeBill) {
                return "SaleIssue_PurInVirtualBill_Transfering_Returning";
            }
            return "SaleIssue_PurInVirtualBill_Transfering";
        }
        if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(pie.getCoreBillType().getId().toString())) {
            return "SaleIssue_PurInVirtualBill_SaleBacking_Returning";
        }
        return null;
    }

    private String getSaleIssueBOTPName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SaleIssueBillInfo pi = (SaleIssueBillInfo)model;
        SaleIssueEntryInfo pie = pi.getEntry().get(0);
        SaleIssueAlgorithmForInfo siAlg = new SaleIssueAlgorithmForInfo(pi, ctx);
        boolean isNegativeBill = siAlg.isNegativeBill();
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(pie.getCoreBillType().getId().toString())) {
            if (isNegativeBill) {
                return "SaleIssue_SaleIssueVirtualBill_SaleBacking_Ordering";
            }
            return "SaleIssue_SaleIssueVirtualBill_Issuing";
        }
        if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(pie.getCoreBillType().getId().toString())) {
            if (isNegativeBill) {
                return "SaleIssue_SaleIssueVirtualBill_Transfering_Returning";
            }
            return "SaleIssue_SaleIssueVirtualBill_Transfering";
        }
        if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(pie.getCoreBillType().getId().toString())) {
            return "SaleIssue_SaleIssueVirtualBill_SaleBacking_Returning";
        }
        return null;
    }

    private void calEntryCost(Context ctx, SaleIssueBillCollection objectCollection, Map materialCompanyMap, Map mmuMap, SaleIssueBillInfo sourceInfo) throws BOSException {
        if (null == objectCollection || objectCollection.size() == 0 || null == materialCompanyMap || materialCompanyMap.size() == 0 || null == mmuMap) {
            return;
        }
        BigDecimal convsRate = new BigDecimal("1.0");
        int localAmtPrecision = 2;
        HashMap<String, PurInWarehsEntryInfo> purInEntryMap = new HashMap<String, PurInWarehsEntryInfo>();
        if ("ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(sourceInfo.getBizType().getId().toString())) {
            PurInWarehsEntryCollection purInWarehsEntryCollection = PurInWarehsEntryFactory.getLocalInstance(ctx).getPurInWarehsEntryCollection("select id,sourceBillId,sourceBillEntryId,unitActualCost,actualCost where sourceBillId = '" + sourceInfo.getId().toString() + "'");
            for (int k = 0; k < purInWarehsEntryCollection.size(); ++k) {
                PurInWarehsEntryInfo entryInfo = purInWarehsEntryCollection.get(k);
                if (entryInfo == null) continue;
                purInEntryMap.put(entryInfo.getSourceBillEntryId(), entryInfo);
            }
        }
        int size = objectCollection.size();
        for (int i = 0; i < size; ++i) {
            SaleIssueBillInfo saleIssueBillInfo = objectCollection.get(i);
            SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
            if (null == entryCol || entryCol.size() == 0) continue;
            int len = entryCol.size();
            for (int j = 0; j < len; ++j) {
                MultiMeasureUnitInfo mmu;
                String tKey;
                MaterialCompanyInfoInfo mciInfo;
                SaleIssueEntryInfo saleIssueEntryInfo = entryCol.get(j);
                MaterialInfo materialInfo = saleIssueEntryInfo.getMaterial();
                CompanyOrgUnitInfo companyOrgUnit = saleIssueEntryInfo.getCompanyOrgUnit();
                MeasureUnitInfo unit = saleIssueEntryInfo.getUnit();
                if (null == materialInfo || null == companyOrgUnit || (mciInfo = (MaterialCompanyInfoInfo)materialCompanyMap.get(tKey = materialInfo.getId().toString() + companyOrgUnit.getId().toString())) == null) continue;
                convsRate = null;
                if (null != unit && null != (mmu = (MultiMeasureUnitInfo)mmuMap.get(tKey = materialInfo.getId().toString() + unit.getId().toString()))) {
                    convsRate = mmu.getBaseConvsRate();
                }
                this.calEntryUnitStandardCost(saleIssueEntryInfo, mciInfo, convsRate);
                this.calEntryStandardCostByUnitCost(saleIssueEntryInfo, localAmtPrecision);
                if ("ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(sourceInfo.getBizType().getId().toString()) && AccountType.MOVE_ADD_AVERAGE.equals((Object)mciInfo.getAccountType())) {
                    if (purInEntryMap.get(saleIssueEntryInfo.getSourceBillEntryId().toString()) == null) continue;
                    saleIssueEntryInfo.setUnitActualCost(((PurInWarehsEntryInfo)purInEntryMap.get(saleIssueEntryInfo.getSourceBillEntryId().toString())).getUnitActualCost());
                    saleIssueEntryInfo.setActualCost(((PurInWarehsEntryInfo)purInEntryMap.get(saleIssueEntryInfo.getSourceBillEntryId().toString())).getActualCost());
                    continue;
                }
                if (AccountType.STANDARDCOST.equals((Object)mciInfo.getAccountType())) {
                    saleIssueEntryInfo.setUnitActualCost(saleIssueEntryInfo.getUnitStandardCost());
                }
                this.calEntryActualCostByUnitCost(saleIssueEntryInfo, localAmtPrecision);
            }
        }
    }

    private void calEntryActualCostByUnitCost(InvBillBaseEntryInfo entryInfo, int amtPrecision) {
        if (entryInfo == null) {
            return;
        }
        BigDecimal unitActualCost = entryInfo.getUnitActualCost() == null ? SysConstant.BIGZERO : entryInfo.getUnitActualCost();
        BigDecimal qty = entryInfo.getQty() == null ? SysConstant.BIGZERO : entryInfo.getQty();
        BigDecimal actualCost = unitActualCost.multiply(qty);
        actualCost = actualCost.setScale(amtPrecision, 4);
        entryInfo.setActualCost(actualCost);
    }

    private void calEntryUnitStandardCost(InvBillBaseEntryInfo entryInfo, MaterialCompanyInfoInfo mciInfo, BigDecimal convsRate) {
        if (null == entryInfo || null == mciInfo) {
            return;
        }
        BigDecimal unitStandardCost = mciInfo.getStandardCost();
        BigDecimal bigDecimal = unitStandardCost = unitStandardCost != null ? unitStandardCost : SysConstant.BIGZERO;
        if (null != convsRate) {
            unitStandardCost = unitStandardCost.multiply(convsRate);
        }
        entryInfo.setUnitStandardCost(unitStandardCost);
    }

    private void calEntryStandardCostByUnitCost(InvBillBaseEntryInfo entryInfo, int amtPrecision) {
        if (entryInfo == null) {
            return;
        }
        BigDecimal unitStandardCost = entryInfo.getUnitStandardCost();
        BigDecimal qty = entryInfo.getQty() == null ? SysConstant.BIGZERO : entryInfo.getQty();
        BigDecimal standardCost = unitStandardCost.multiply(qty);
        standardCost = standardCost.setScale(amtPrecision, 4);
        entryInfo.setStandardCost(standardCost);
    }

    private Map getMaterialCompanyInfo(Context ctx, Set materialIdSet, Set couIdSet) throws BOSException {
        if (null == materialIdSet || null == couIdSet || materialIdSet.size() == 0 || couIdSet.size() == 0) {
            return new HashMap();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("mateial.id"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("accountType"));
        selector.add(new SelectorItemInfo("standardCost"));
        selector.add(new SelectorItemInfo("calculateType"));
        entityViewInfo.setSelector(selector);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)couIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        MaterialCompanyInfoCollection col = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(entityViewInfo);
        if (null == col || col.size() == 0) {
            return new HashMap();
        }
        HashMap<String, MaterialCompanyInfoInfo> ret = new HashMap<String, MaterialCompanyInfoInfo>();
        MaterialCompanyInfoInfo mci = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            mci = col.get(i);
            String materialId = mci.getMateial().getId().toString();
            String couId = mci.getCompany().getId().toString();
            ret.put(materialId + couId, mci);
        }
        return ret;
    }

    private Map getMultiMeasureUnit(Context ctx, Set materialIdSet, Set unitIdSet) throws BOSException {
        if (null == unitIdSet || unitIdSet.size() == 0 || null == materialIdSet || materialIdSet.size() == 0) {
            return new HashMap();
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIdSet, CompareType.INCLUDE));
        entity.setFilter(filter);
        MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entity);
        if (null == col || col.size() == 0) {
            return new HashMap();
        }
        HashMap<String, MultiMeasureUnitInfo> map = new HashMap<String, MultiMeasureUnitInfo>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            MultiMeasureUnitInfo mmu = col.get(i);
            String key = mmu.getMaterial().getId().toString() + mmu.getMeasureUnit().getId().toString();
            map.put(key, mmu);
        }
        return map;
    }
}

