/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.scm.im.inv.CalculateLotException;
import com.kingdee.eas.scm.im.inv.CalculateLotLineValue;
import com.kingdee.eas.scm.im.inv.CalculateLotParam;
import com.kingdee.eas.scm.im.inv.CalculateLotValue;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractDateOfMinDurabilityControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DateOfMinDurabilityControllerBean
extends AbstractDateOfMinDurabilityControllerBean {
    private static final long serialVersionUID = 1L;
    private String matpermSql = null;
    private String matpermJoinSql = null;
    private String warepermSql = null;
    private String warepermJoinSql = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.DateOfMinDurabilityControllerBean");

    private String getDateOfMinDurBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new DateOfMinDurabilityInfo().getBOSType().toString();
    }

    @Override
    protected void _insertData(Context ctx, IObjectPK pk, String billTypeID) throws BOSException, EASBizException {
        this._batchInsertData(ctx, new String[]{pk.toString()}, billTypeID);
    }

    @Override
    protected void _unAduitDeleteData(Context ctx, IObjectPK pk, String billTypeID) throws BOSException, EASBizException {
        StringBuffer stringBuffer = new StringBuffer();
        if (pk != null && billTypeID != null) {
            String entryName = InvCommonUtils.getBillEntryTableNameFromBillTypeID(billTypeID);
            stringBuffer.append("Delete T_IM_DateOfMinDurability where fid in ( ");
            stringBuffer.append("select A.fid from T_IM_DateOfMinDurability A ");
            stringBuffer.append("Left Join ");
            stringBuffer.append(entryName);
            stringBuffer.append(" B On A.Flot = B.Flot And  A.FStorageOrgUnitID = B.FStorageOrgUnitID And A.FMaterialID = B.FMaterialID ");
            stringBuffer.append("Where B.FParentId = '");
            stringBuffer.append(pk.toString());
            stringBuffer.append("' )");
            String sqlStr = stringBuffer.toString();
            DbUtil.execute((Context)ctx, (String)sqlStr);
        }
    }

    @Override
    protected RptRowSet _dateOfMinRpt(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.getPerm(ctx, params);
        String conditionOfDateOfMin = this.getConditionOfInventory(ctx, params);
        String conditionOfInventory = this.getConditionOfDateOfMin(params);
        String locName = this.getLocName(ctx);
        StringBuffer sbSelect = new StringBuffer();
        sbSelect.append("Select C.FNumber,C.");
        sbSelect.append(locName).append(",");
        RptRowSet prtRowSet = null;
        Connection conn = null;
        sbSelect.append("C.FShortName");
        sbSelect.append(",C.FModel,H.");
        sbSelect.append(locName);
        sbSelect.append(",A.FLot,A.FMfg,A.FDateOfMinDur,A.FExp,A.FPrepWarnAhead,");
        Date today = new Date();
        sbSelect.append("datediff(DD,A.FExp,to_date('");
        sbSelect.append(InvCommonUtils.getFmtDate(today));
        sbSelect.append("')), ");
        sbSelect.append("I.");
        sbSelect.append(locName);
        sbSelect.append(",B.FCurStoreQty");
        sbSelect.append(",O.FqtyPrecision as qtyPrecision");
        sbSelect.append(",J.");
        sbSelect.append(locName);
        sbSelect.append(",B.FBaseQty");
        sbSelect.append(",P.FqtyPrecision as baseQtyPre");
        sbSelect.append(",K.");
        sbSelect.append(locName);
        sbSelect.append(",B.FCurStoreAssistQty");
        sbSelect.append(",Q.FqtyPrecision as assQtyPre");
        sbSelect.append(",D.");
        sbSelect.append(locName);
        sbSelect.append(",F.");
        sbSelect.append(locName);
        sbSelect.append(",G.");
        sbSelect.append(locName);
        sbSelect.append(",L.");
        sbSelect.append(locName);
        sbSelect.append(",E.");
        sbSelect.append(locName);
        sbSelect.append(",N.");
        sbSelect.append(locName);
        sbSelect.append(",M.");
        sbSelect.append(locName);
        sbSelect.append(",A.FPeriodValid,A.FPeriodValidUnit ");
        StringBuffer sbFrom = new StringBuffer();
        sbFrom.append("From T_IM_DateOfMinDurability A ");
        sbFrom.append("LEFT OUTER JOIN T_IM_Inventory B on B.FLot = A.FLot And A.FStorageOrgUnitID = B.FStorageOrgUnitID And A.FMaterialID= B.FMaterialID ");
        sbFrom.append("Inner JOIN T_BD_Material C on C.FID = A.FMaterialID ");
        sbFrom.append("Inner JOIN T_ORG_Storage D on D.FID = A.FStorageOrgUnitID ");
        sbFrom.append("Inner JOIN T_IM_STORETYPE E on E.FID = B.FStoreTypeID ");
        sbFrom.append("LEFT OUTER JOIN T_DB_WAREHOUSE F on F.FID = B.FWarehouseID ");
        sbFrom.append("LEFT OUTER JOIN T_DB_LOCATION G on G.FID = B.FLocationID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_AsstAttrValue H on H.FID = B.FAssistPropertyID ");
        sbFrom.append("Inner JOIN T_BD_MeasureUnit I on I.FID = B.FUnitID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_MeasureUnit J on J.FID = B.FBaseUnitID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_MeasureUnit K on K.FID = B.FAssistUnitID ");
        sbFrom.append("Inner JOIN T_IM_STORESTATE L on L.FID = B.FStoreStatusID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_Supplier M on M.FID = B.FSupplierID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_Customer N on N.FID = B.FCustomerID ");
        sbFrom.append("INNER JOIN T_BD_MultiMeasureUnit O ON  O.FMaterialID = A.FMaterialID and O.FMeasureUnitID = B.FUnitID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_MultiMeasureUnit P ON  P.FMaterialID = A.FMaterialID and P.FMeasureUnitID = B.FBaseUnitID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_MultiMeasureUnit Q ON  Q.FMaterialID = A.FMaterialID and Q.FMeasureUnitID = B.FAssistUnitID ");
        String materialTypeFrom = null;
        String materialTypeTo = null;
        boolean matFromIsLeaf = false;
        boolean matToIsLeaf = false;
        try {
            Boolean ckBxShowMShortName;
            conn = EJBFactory.getConnection((Context)ctx);
            if (params.getObject("materialTypeFrom") != null) {
                materialTypeFrom = ((MaterialGroupInfo)params.getObject("materialTypeFrom")).getNumber();
                matFromIsLeaf = ((MaterialGroupInfo)params.getObject("materialTypeFrom")).isIsLeaf();
            }
            if (params.getObject("materialTypeTo") != null) {
                materialTypeTo = ((MaterialGroupInfo)params.getObject("materialTypeTo")).getNumber();
                matToIsLeaf = ((MaterialGroupInfo)params.getObject("materialTypeTo")).isIsLeaf();
            }
            if (materialTypeFrom != null || materialTypeTo != null || params.getObject("materialGroupStandard") != null) {
                sbFrom.append("inner join T_BD_MaterialGroupDetial as MGD on MGD.FMaterialID = c.fid ");
                sbFrom.append("inner join t_bd_materialgroup MG on  MG.fid = MGD.fmaterialgroupid  ");
            }
            if (this.matpermJoinSql != null) {
                sbFrom.append(this.matpermJoinSql);
            }
            if (this.warepermJoinSql != null) {
                sbFrom.append(this.warepermJoinSql);
            }
            StringBuffer sbWhere = new StringBuffer();
            sbWhere.append("Where 1 = 1 AND A.FExp is Not Null ");
            if (conditionOfInventory.length() > 0) {
                sbWhere.append("And ");
                sbWhere.append(conditionOfInventory).append(" ");
            }
            if (conditionOfDateOfMin.length() != 0) {
                sbWhere.append(conditionOfDateOfMin);
            }
            if (this.matpermSql != null && this.matpermSql.length() > 0) {
                sbWhere.append(this.matpermSql);
            }
            if (this.warepermSql != null && this.warepermSql.length() > 0) {
                sbWhere.append(this.warepermSql);
            }
            if ((ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName")) != null && ckBxShowMShortName.booleanValue()) {
                String txtMShortNameFrom = (String)params.getObject("shortNameFrom");
                String txtMShortNameTo = (String)params.getObject("shortNameTo");
                if (txtMShortNameFrom == null || txtMShortNameFrom.trim().length() == 0) {
                    txtMShortNameFrom = null;
                }
                if (txtMShortNameTo == null || txtMShortNameTo.trim().length() == 0) {
                    txtMShortNameTo = null;
                }
                if (txtMShortNameFrom != null && txtMShortNameFrom.trim().length() > 0) {
                    if (txtMShortNameFrom.indexOf("'") != -1) {
                        txtMShortNameFrom = txtMShortNameFrom.replaceAll("'", "''");
                    }
                    sbWhere.append(" and C.FShortName >= '").append(txtMShortNameFrom.trim()).append("' ");
                }
                if (txtMShortNameFrom == null && txtMShortNameTo != null && txtMShortNameTo.trim().length() > 0) {
                    if (txtMShortNameTo.indexOf("'") != -1) {
                        txtMShortNameTo = txtMShortNameTo.replaceAll("'", "''");
                    }
                    sbWhere.append(" and ( C.FShortName <= '").append(txtMShortNameTo.trim()).append("' or C.FShortName is null ) ");
                }
                if (txtMShortNameFrom != null && txtMShortNameTo != null && txtMShortNameTo.trim().length() > 0) {
                    if (txtMShortNameTo.indexOf("'") != -1) {
                        txtMShortNameTo = txtMShortNameTo.replaceAll("'", "''");
                    }
                    sbWhere.append(" and C.FShortName <= '").append(txtMShortNameTo.trim()).append("' ");
                }
            }
            if (materialTypeFrom != null || materialTypeTo != null || params.getObject("materialGroupStandard") != null) {
                StringBuffer sql2 = new StringBuffer();
                sql2.append("select distinct mt.flongnumber from t_bd_materialGroup mt where mt.FGROUPSTANDARD = '");
                sql2.append(((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId()).append("'");
                if (materialTypeFrom != null) {
                    sql2.append(" and mt.fnumber >= '").append(materialTypeFrom).append("' ");
                }
                if (materialTypeTo != null) {
                    sql2.append(" and mt.fnumber <= '").append(materialTypeTo).append("' ");
                }
                prtRowSet = DBUtil.executeQuery((String)sql2.toString(), null, (int)0, (int)-1, (Connection)conn);
                boolean rsFirst = true;
                StringBuffer sql3 = new StringBuffer();
                int i = 0;
                while (prtRowSet.next()) {
                    ++i;
                    if (!rsFirst) {
                        sql3.append(" or ");
                    } else {
                        rsFirst = false;
                    }
                    sql3.append(" (MG.flongnumber = '").append(prtRowSet.getString("flongnumber")).append("' ");
                    sql3.append("or MG.flongnumber like '").append(prtRowSet.getString("flongnumber")).append("!%') ");
                }
                if (((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId() != null) {
                    sbWhere.append(" and MGD.FMaterialGroupStandardID = '").append(((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId()).append("' ");
                }
                if (i > 0) {
                    sbWhere.append(" and ( ").append(sql3).append(" ) ");
                } else {
                    sbWhere.append(" and 1 = 2 ");
                }
            }
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append(sbSelect);
            sqlBuff.append(sbFrom);
            sqlBuff.append(sbWhere);
            sqlBuff.append(" order BY ");
            sqlBuff.append("datediff(DD,A.FExp,to_date('");
            sqlBuff.append(InvCommonUtils.getFmtDate(today));
            sqlBuff.append("')) DESC ");
            prtRowSet = DBUtil.executeQuery((String)sqlBuff.toString(), null, (int)0, (int)-1, (Connection)conn);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return prtRowSet;
    }

    private void getPerm(Context ctx, RptParams params) throws BOSException {
        Set cuUnitSets = InvServerUtils.getAuthorizedf7Orgs(ctx, "dateofmindurabilityreport_view");
        Object[] sous = (Object[])params.getObject("fullStorageOrgUnit");
        Set orgUnitSets = InvServerUtils.getSelAuthorUnit(cuUnitSets, sous);
        Map matpermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)orgUnitSets, (String)"bd_material_view", (String)"C", (String)"A");
        Map warepermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)orgUnitSets, (String)"warehous_view", (String)"F", (String)"A");
        if (!CollectionUtil.isEmpty((Map)matpermRuleMap)) {
            this.matpermSql = " and" + (String)matpermRuleMap.get("PERM_WHERE");
            this.matpermJoinSql = (String)matpermRuleMap.get("PERM_JOIN");
        }
        if (!CollectionUtil.isEmpty((Map)warepermRuleMap)) {
            this.warepermSql = " and" + (String)warepermRuleMap.get("PERM_WHERE");
            this.warepermJoinSql = (String)warepermRuleMap.get("PERM_JOIN");
        }
    }

    protected ResultSet _getDateOfMinRpt(Context ctx, RptParams params) throws BOSException, EASBizException {
        ResultSet rs = null;
        return rs;
    }

    @Override
    protected String _getLot(Context ctx, String materialId, String storageUnitID, IssuePriorityEnum issuePriorityEnum) throws BOSException, EASBizException {
        if (materialId == null || materialId.length() == 0 || storageUnitID == null || storageUnitID.length() == 0) {
            return null;
        }
        String lot = null;
        Connection conn = null;
        PreparedStatement perStmt = null;
        ResultSet rs = null;
        StringBuffer sb = new StringBuffer();
        switch (issuePriorityEnum.getValue()) {
            case 2: {
                sb.append("select top 1 inv.FLot from T_IM_Inventory inv right outer join T_IM_DateOfMinDurability dom on inv.FLot = dom.FLot and inv.FStorageOrgUnitID = dom.FStorageOrgUnitID and inv.FMaterialID = dom.FMaterialID ");
                sb.append(" where inv.FStorageOrgUnitID = ? and inv.FMaterialID = ? and inv.FCurStoreQty > 0 and inv.FLot is not null ");
                sb.append(" order by dom.FInWarehouseDate,inv.FLot asc");
                break;
            }
            case 3: {
                sb.append("select top 1 inv.FLot from T_IM_Inventory inv right outer join T_IM_DateOfMinDurability dom on inv.FLot = dom.FLot and inv.FStorageOrgUnitID = dom.FStorageOrgUnitID and inv.FMaterialID = dom.FMaterialID ");
                sb.append(" where inv.FStorageOrgUnitID = ? and inv.FMaterialID = ? and inv.FCurStoreQty > 0 and inv.FLot is not null ");
                sb.append(" order by dom.FInWarehouseDate,inv.FLot asc");
                break;
            }
            case 4: {
                sb.append("select top 1 inv.FLot from T_IM_Inventory inv right outer join T_IM_DateOfMinDurability dom on inv.FLot = dom.FLot and inv.FStorageOrgUnitID = dom.FStorageOrgUnitID and inv.FMaterialID = dom.FMaterialID ");
                sb.append(" where inv.FStorageOrgUnitID = ? and inv.FMaterialID = ? and inv.FCurStoreQty > 0 and inv.FLot is not null ");
                sb.append(" order by dom.FExp,dom.FInWarehouseDate,inv.FLot asc");
                break;
            }
            default: {
                return null;
            }
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            perStmt = conn.prepareStatement(sb.toString());
            perStmt.setString(1, storageUnitID);
            perStmt.setString(2, materialId);
            rs = perStmt.executeQuery();
            while (rs.next()) {
                lot = rs.getString(1);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, perStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
        if ("YNi0IQEOEADgBT3mfwAAAcznrtQ=".equals(lot)) {
            lot = null;
        }
        return lot;
    }

    @Override
    protected IObjectValue _getInventory(Context ctx, String materialId, String storageUnitID, IssuePriorityEnum issuePriorityEnum) throws BOSException, EASBizException {
        if (materialId == null || materialId.length() == 0 || storageUnitID == null || storageUnitID.length() == 0) {
            return null;
        }
        String inventoryID = null;
        Connection conn = null;
        PreparedStatement perStmt = null;
        ResultSet rs = null;
        StringBuffer sb = new StringBuffer();
        switch (issuePriorityEnum.getValue()) {
            case 2: {
                sb.append("Select Top 1 Fid From T_IM_Inventory ");
                sb.append("where FStorageOrgUnitID = ? AND FMaterialID= ? AND FLot <> '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' ");
                sb.append("Order by FLot ASC ");
                break;
            }
            case 3: {
                sb.append("Select Top 1 Fid From T_IM_Inventory ");
                sb.append("where FStorageOrgUnitID = ? AND FMaterialID= ? AND FLot <> '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' ");
                sb.append("Order by FLot DESC ");
                break;
            }
            case 4: {
                sb.append("Select Top 1 B.Fid From T_IM_DateOfMinDurability A ");
                sb.append("LEFT OUTER JOIN T_IM_Inventory B on B.FLot = A.FLot And A.FStorageOrgUnitID = B.FStorageOrgUnitID And A.FMaterialID= B.FMaterialID ");
                sb.append("where A.FStorageOrgUnitID = ? AND A.FMaterialID= ? ");
                sb.append("Order by A.FExp,dom.FInWarehouseDate,inv.FLot ASC ");
                break;
            }
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            perStmt = conn.prepareStatement(sb.toString());
            perStmt.setString(1, storageUnitID);
            perStmt.setString(2, materialId);
            rs = perStmt.executeQuery();
            while (rs.next()) {
                inventoryID = rs.getString(1);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, perStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
        if (inventoryID != null) {
            IInventory iInventory = InventoryFactory.getLocalInstance(ctx);
            InventoryInfo invInfo = iInventory.getInventoryInfo((IObjectPK)new ObjectUuidPK(inventoryID));
            return invInfo;
        }
        return null;
    }

    protected static Timestamp getFilterDate(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if (s.equalsIgnoreCase("startDate")) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        } else if (s.equalsIgnoreCase("endDate")) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    protected String getConditionOfDateOfMin(RptParams params) throws BOSException {
        Date today;
        StringBuffer sb = new StringBuffer();
        boolean isNull = true;
        if (params.getObject("MfgFrom") != null) {
            Date mfgFrom = (Date)params.getObject("MfgFrom");
            Timestamp fromTime = DateOfMinDurabilityControllerBean.getFilterDate(mfgFrom, "startDate");
            mfgFrom = new Date(fromTime.getTime());
            sb.append("A.FMfg >= to_date('");
            sb.append(InvCommonUtils.getFmtDateAndTime(mfgFrom));
            sb.append("') ");
            isNull = false;
        }
        if (params.getObject("MfgTo") != null) {
            Date mfgTo = (Date)params.getObject("MfgTo");
            Timestamp toTime = DateOfMinDurabilityControllerBean.getFilterDate(mfgTo, "endDate");
            mfgTo = new Date(toTime.getTime());
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("A.FMfg <= to_date('");
            sb.append(InvCommonUtils.getFmtDateAndTime(mfgTo));
            sb.append("') ");
            isNull = false;
        }
        if (params.getObject("PeriodValidFrom") != null) {
            BigDecimal periodValidFrom = (BigDecimal)params.getObject("PeriodValidFrom");
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("A.FDateOfMinDur >= ");
            sb.append(periodValidFrom);
            sb.append(" ");
            isNull = false;
        }
        if (params.getObject("PeriodValidTo") != null) {
            BigDecimal periodValidTo = (BigDecimal)params.getObject("PeriodValidTo");
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("A.FDateOfMinDur <= ");
            sb.append(periodValidTo);
            sb.append(" ");
            isNull = false;
        }
        if (params.getObject("PassDateFrom") != null) {
            BigDecimal passDateFrom = (BigDecimal)params.getObject("PassDateFrom");
            if (!isNull) {
                sb.append("AND ");
            }
            today = new Date();
            sb.append("datediff(DD,A.FExp,to_date('");
            sb.append(InvCommonUtils.getFmtDate(today));
            sb.append("')) >= ");
            sb.append(passDateFrom.toString());
            sb.append(" ");
            isNull = false;
        }
        if (params.getObject("PassDateTo") != null) {
            BigDecimal passDateTo = (BigDecimal)params.getObject("PassDateTo");
            if (!isNull) {
                sb.append("AND ");
            }
            today = new Date();
            sb.append("datediff(DD,A.FExp,to_date('");
            sb.append(InvCommonUtils.getFmtDate(today));
            sb.append("')) <= ");
            sb.append(passDateTo.toString());
            sb.append(" ");
            isNull = false;
        }
        if (!isNull) {
            sb.append("AND ");
        }
        sb.append("B.FCurStoreQty > 0");
        return sb.toString();
    }

    protected String getConditionOfInventory(Context ctx, RptParams params) throws BOSException {
        String assistTo;
        String assistFrom;
        String lotTo;
        String lotFrom;
        String materialNumTo;
        String locationTo;
        String warehouseTo;
        String[] numArray;
        StringBuffer sb = new StringBuffer();
        boolean isNull = true;
        if (params.getObject("fullStorageOrgUnit") != null) {
            Set cuUnitSets = InvServerUtils.getAuthorizedf7Orgs(ctx, "dateofmindurabilityreport_view");
            Set orgUnitSets = InvServerUtils.getSelAuthorUnit(cuUnitSets, (Object[])params.getObject("fullStorageOrgUnit"));
            this.addListStOrgUnitFilter(orgUnitSets.toArray(), sb, CompareType.INCLUDE);
            isNull = false;
        }
        if (params.getObject("StoretypeFrom") != null) {
            String storetypeFrom = null;
            storetypeFrom = params.getObject("StoretypeFrom") instanceof StoreTypeInfo ? ((StoreTypeInfo)params.getObject("StoretypeFrom")).getNumber() : params.getObject("StoretypeFrom").toString();
            if (storetypeFrom.trim().length() > 0) {
                if (!isNull) {
                    sb.append("AND ");
                }
                sb.append("E.Fnumber >= '");
                sb.append(storetypeFrom);
                sb.append("' ");
                isNull = false;
            }
        }
        if (params.getObject("StoretypeTo") != null) {
            String storetypeTo = null;
            storetypeTo = params.getObject("StoretypeTo") instanceof StoreTypeInfo ? ((StoreTypeInfo)params.getObject("StoretypeTo")).getNumber() : params.getObject("StoretypeTo").toString();
            if (storetypeTo.trim().length() > 0) {
                if (!isNull) {
                    sb.append("AND ");
                }
                sb.append("E.Fnumber <= '");
                sb.append(storetypeTo);
                sb.append("' ");
                isNull = false;
            }
        }
        if (params.getObject("WarehouseFrom") != null && ((numArray = SCMUtil.getF7Numbers((Object)params.getObject("WarehouseFrom")))[0] != null || numArray[1] != null)) {
            if (!isNull) {
                sb.append("AND ");
            }
            isNull = false;
            if (numArray[0] != null) {
                sb.append("F.Fnumber >= '").append(numArray[0]).append("' ");
            } else {
                sb.append("F.Fnumber in (").append(numArray[1]).append(") ");
            }
        }
        if (params.getObject("WarehouseTo") != null && (warehouseTo = (String)params.getObject("WarehouseTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("F.Fnumber <= '");
            sb.append(warehouseTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("LocationFrom") != null && ((numArray = SCMUtil.getF7Numbers((Object)params.getObject("LocationFrom")))[0] != null || numArray[1] != null)) {
            if (!isNull) {
                sb.append("AND ");
            }
            isNull = false;
            if (numArray[0] != null) {
                sb.append("G.Fnumber >= '").append(numArray[0]).append("' ");
            } else {
                sb.append("G.Fnumber in (").append(numArray[1]).append(") ");
            }
        }
        if (params.getObject("LocationTo") != null && (locationTo = (String)params.getObject("LocationTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("G.Fnumber <= '");
            sb.append(locationTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("MaterialNumFrom") != null && ((numArray = SCMUtil.getF7Numbers((Object)params.getObject("MaterialNumFrom")))[0] != null || numArray[1] != null)) {
            if (!isNull) {
                sb.append("AND ");
            }
            isNull = false;
            if (numArray[0] != null) {
                sb.append("C.Fnumber >= '").append(numArray[0]).append("' ");
            } else {
                sb.append("C.Fnumber in (").append(numArray[1]).append(") ");
            }
        }
        if (params.getObject("MaterialNumTo") != null && (materialNumTo = (String)params.getObject("MaterialNumTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("C.Fnumber <= '");
            sb.append(materialNumTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("LotFrom") != null && (lotFrom = (String)params.getObject("LotFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("A.Flot >= '");
            sb.append(lotFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("LotTo") != null && (lotTo = (String)params.getObject("LotTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("A.Flot <= '");
            sb.append(lotTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("txtLotLike") != null && !params.getString("txtLotLike").trim().equals("")) {
            sb.append("and  A.flot like '%").append((String)params.getObject("txtLotLike")).append("%' ");
        }
        if (params.getObject("AssistFrom") != null && (assistFrom = (String)params.getObject("AssistFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("H.Fnumber >= '");
            sb.append(assistFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("AssistTo") != null && (assistTo = (String)params.getObject("AssistTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("H.Fnumber <= '");
            sb.append(assistTo);
            sb.append("' ");
            isNull = false;
        }
        return sb.toString();
    }

    protected String getTempTableName(Context ctx, String desc) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(desc);
    }

    protected String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    protected void creatTempTable(Context ctx, String strTableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb = sb.append("Create Table ");
        sb = sb.append(strTableName);
        sb = sb.append(" (FID VARCHAR(44) NOT NULL , ");
        sb = sb.append("FCompanyOrgUnitID VARCHAR(44), ");
        sb = sb.append("FStorageOrgUnitID VARCHAR(44), ");
        sb = sb.append("FWarehouseID VARCHAR(44), ");
        sb = sb.append("FLocationID VARCHAR(44), ");
        sb = sb.append("FStoreTypeID VARCHAR(44), ");
        sb = sb.append("FStoreStatusID VARCHAR(44), ");
        sb = sb.append("FLot NVARCHAR(80), ");
        sb = sb.append("FSupplierID VARCHAR(44), ");
        sb = sb.append("FCustomerID VARCHAR(44), ");
        sb = sb.append("FMaterialID VARCHAR(44), ");
        sb = sb.append("FUnitID VARCHAR(44), ");
        sb = sb.append("FCurStoreQty NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FAssistUnitID VARCHAR(44), ");
        sb = sb.append("FCurStoreAssistQty NUMERIC(28,10), ");
        sb = sb.append("FBaseQty NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FAmount NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FControlUnitID VARCHAR(44), ");
        sb = sb.append("FBaseUnitID VARCHAR(44), ");
        sb = sb.append("FExp DateTime, ");
        sb = sb.append("FWarehouseNumber NVARCHAR(80), ");
        sb = sb.append("FMaterialNumber NVARCHAR(80), ");
        sb = sb.append("FAssistPropertyID VARCHAR(44)) ");
        ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        manager.createTempTable(sb.toString());
    }

    @Override
    protected boolean _isDataInInventory(Context ctx, String lot, BOSUuid materialId) throws BOSException, EASBizException {
        if (lot == null || lot.length() == 0 || materialId == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("curStoreQty", (Object)new BigDecimal("0.00"), CompareType.NOTEQUALS));
        IInventory iInventory = InventoryFactory.getLocalInstance(ctx);
        return iInventory.exists(filter);
    }

    @Override
    protected Map _getInventoryCollection(Context ctx, CalculateLotParam param) throws BOSException, EASBizException {
        param.checkValid();
        boolean isUpdateByBaseUnit = param.isUpdateByBaseUnit();
        TransactionTypeInfo tti = param.getTti();
        String souID = param.getSouID();
        String billTypeID = param.getBillTypeID();
        String[] materialIDs = param.getMaterialIDs();
        String[] unitIDs = param.getUnitIDs();
        BigDecimal[] qtys = param.getQtys();
        String[] asstAttrIDs = param.getAsstAttrIDs();
        String[] warehouseIDs = param.getWarehouseIDs();
        String[] locationIDs = param.getLocationIDs();
        String[] supplierIDs = param.getSupplierIDs();
        String[] customerIDs = param.getCustomerIDs();
        String[] storeTypeIDs = param.getStoreTypeIDs();
        String[] storeStatusIDs = param.getStoreStatusIDs();
        String[] projectIDs = param.getProjectIDs();
        String[] trackNumberIDs = param.getTrackNumberIDs();
        HashMap<String, CalculateLotValue> returnMap = new HashMap<String, CalculateLotValue>();
        for (int i = 0; i < materialIDs.length; ++i) {
            MaterialInventoryInfo materialInv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialIDs[i], souID);
            IssuePriorityEnum issuePriority = materialInv.getIssuePriorityMode();
            boolean isNegative = materialInv.isIsNegative();
            InventoryCollection inventoryCollection = InvServerUtils.getInventoryCollectionForCalculateLot(ctx, billTypeID, souID, tti, isUpdateByBaseUnit, materialIDs[i], asstAttrIDs[i], unitIDs[i], warehouseIDs[i], locationIDs[i], storeTypeIDs[i], storeStatusIDs[i], supplierIDs[i], customerIDs[i], issuePriority, projectIDs[i], trackNumberIDs[i]);
            if (inventoryCollection == null) {
                inventoryCollection = new InventoryCollection();
            }
            String key = param.getParamKeys()[i];
            CalculateLotValue value = this.buildValue(inventoryCollection, isUpdateByBaseUnit, qtys[i]);
            this.checkEnough(ctx, isUpdateByBaseUnit, isNegative, materialIDs[i], asstAttrIDs[i], projectIDs[i], trackNumberIDs[i], unitIDs[i], warehouseIDs[i], locationIDs[i], qtys[i], value);
            returnMap.put(key, value);
        }
        return returnMap;
    }

    private void checkEnough(Context ctx, boolean isUpdateByBaseUnit, boolean isNegative, String materialID, String asstAttrID, String projectID, String trackNumberID, String unitID, String warehouseID, String locationID, BigDecimal qty, CalculateLotValue value) throws EASBizException, BOSException {
        BigDecimal qtySum = new BigDecimal("0.00");
        for (int i = 0; i < value.getLineValues().size(); ++i) {
            CalculateLotLineValue lineValue = (CalculateLotLineValue)value.getLineValues().get(i);
            qtySum = qtySum.add(lineValue.getQty());
        }
        if (qty == null) {
            qty = new BigDecimal("0.00");
        }
        if (qtySum.compareTo(qty) < 0) {
            StringBuffer msg = new StringBuffer();
            if (materialID != null) {
                MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                msg.append(material.getNumber());
                msg.append(" ").append(material.getName());
            }
            if (asstAttrID != null) {
                AsstAttrValueInfo asstAttr = AsstAttrValueFactory.getLocalInstance((Context)ctx).getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(asstAttrID));
                msg.append(" ").append(asstAttr.getName());
            }
            if (projectID != null) {
                ProjectInfo project = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(projectID));
                msg.append(" ").append(project.getNumber());
            }
            if (trackNumberID != null) {
                TrackNumberInfo trackNumber = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackNumberID));
                msg.append(" ").append(trackNumber.getNumber());
            }
            if (unitID != null) {
                MeasureUnitInfo unit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitID));
                msg.append(" ").append(unit.getName());
            }
            if (warehouseID != null) {
                WarehouseInfo warehouse = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouseID));
                msg.append(" ").append(warehouse.getName());
            }
            if (locationID != null) {
                LocationInfo location = LocationFactory.getLocalInstance((Context)ctx).getLocationInfo((IObjectPK)new ObjectUuidPK(locationID));
                msg.append(" ").append(location.getName());
            }
            int precision = qty.scale();
            BigDecimal qtyDiff = qty.subtract(qtySum).setScale(precision);
            String qtyDiffStr = InvAppUtils.getDecimalFormatString(ctx, qtyDiff, qtyDiff.scale());
            value.setMatched(false);
            if (isUpdateByBaseUnit || isNegative) {
                CalculateLotException ex = new CalculateLotException(CalculateLotException.NOTENOUGH, new Object[]{msg.toString(), qtyDiffStr});
                value.setFailMsg(ex.getMessage());
            } else {
                CalculateLotException ex = new CalculateLotException(CalculateLotException.NOTENOUGH2, new Object[]{msg.toString(), qtyDiffStr});
                value.setFailMsg(ex.getMessage());
            }
            return;
        }
        value.setMatched(true);
    }

    protected CalculateLotValue buildValue(InventoryCollection inventoryCollection, boolean isUpdateByBaseUnit, BigDecimal qty) {
        CalculateLotValue value = new CalculateLotValue();
        value.setLineValues(new ArrayList());
        BigDecimal totalQty = new BigDecimal("0.00");
        Iterator iter = inventoryCollection.iterator();
        if (qty != null) {
            while (iter.hasNext() && totalQty.compareTo(qty) < 0) {
                InventoryInfo inventory = (InventoryInfo)iter.next();
                CalculateLotLineValue lineValue = new CalculateLotLineValue();
                BigDecimal inventoryQty = isUpdateByBaseUnit ? inventory.getBaseQty() : inventory.getCurStoreQty();
                BigDecimal thisQty = totalQty.add(inventoryQty).compareTo(qty) > 0 ? qty.subtract(totalQty) : inventoryQty;
                lineValue.setQty(thisQty);
                lineValue.setLot(inventory.getLot());
                lineValue.setMfg((Date)inventory.get("mfg"));
                lineValue.setExp((Date)inventory.get("exp"));
                if (inventory.getAssistProperty() != null) {
                    lineValue.setAsstAttrID(inventory.getAssistProperty().getId().toString());
                }
                if (inventory.getProject() != null) {
                    lineValue.setProjectID(inventory.getProject().getId().toString());
                }
                if (inventory.getTrackNumber() != null) {
                    lineValue.setTrackNumberID(inventory.getTrackNumber().getId().toString());
                }
                if (inventory.getWarehouse() != null) {
                    lineValue.setWarehouseID(inventory.getWarehouse().getId().toString());
                }
                if (inventory.getLocation() != null) {
                    lineValue.setLocationID(inventory.getLocation().getId().toString());
                }
                if (inventory.getSupplier() != null) {
                    lineValue.setSupplierID(inventory.getSupplier().getId().toString());
                }
                if (inventory.getCustomer() != null) {
                    lineValue.setCustomerID(inventory.getCustomer().getId().toString());
                }
                value.getLineValues().add(lineValue);
                totalQty = totalQty.add(thisQty);
            }
        }
        return value;
    }

    private void addListStOrgUnitFilter(Object[] stOrgUnits, StringBuffer sb, CompareType compareType) {
        if (compareType == CompareType.INCLUDE) {
            sb.append("AND D.Fid IN('");
        } else if (compareType == CompareType.NOTINCLUDE) {
            sb.append("AND D.Fid NOT IN('");
        }
        if (stOrgUnits != null && stOrgUnits.length > 0) {
            int size = stOrgUnits.length;
            for (int k = 0; k < size; ++k) {
                FullOrgUnitInfo aFullOrgUnitInfo = (FullOrgUnitInfo)stOrgUnits[k];
                sb.append(aFullOrgUnitInfo.getId().toString());
                if (k == size - 1) {
                    sb.append("') ");
                    continue;
                }
                sb.append("','");
            }
        } else {
            sb.append("111111111111111111111111111=").append(") ");
        }
    }

    @Override
    protected String _getLot(Context ctx, String materialId, String storageUnitID, IssuePriorityEnum issuePriorityEnum, String assUnitID) throws BOSException {
        if (materialId == null || materialId.length() == 0 || storageUnitID == null || storageUnitID.length() == 0) {
            return null;
        }
        String lot = null;
        Connection conn = null;
        PreparedStatement perStmt = null;
        ResultSet rs = null;
        StringBuffer sb = new StringBuffer();
        switch (issuePriorityEnum.getValue()) {
            case 2: {
                sb.append("select top 1 inv.FLot from T_IM_Inventory inv right outer join T_IM_DateOfMinDurability dom on inv.FLot = dom.FLot and inv.FStorageOrgUnitID = dom.FStorageOrgUnitID and inv.FMaterialID = dom.FMaterialID ");
                sb.append(" where inv.FStorageOrgUnitID = ? and inv.FMaterialID = ? and inv.FCurStoreQty > 0 and inv.FLot <> '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' ");
                if (assUnitID != null) {
                    sb.append("  and inv.FAssistPropertyID = ? ");
                } else {
                    sb.append("  and inv.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' ");
                }
                sb.append(" order by dom.FInWarehouseDate,inv.FLot asc");
                break;
            }
            case 3: {
                sb.append("select top 1 inv.FLot from T_IM_Inventory inv right outer join T_IM_DateOfMinDurability dom on inv.FLot = dom.FLot and inv.FStorageOrgUnitID = dom.FStorageOrgUnitID and inv.FMaterialID = dom.FMaterialID ");
                sb.append(" where inv.FStorageOrgUnitID = ? and inv.FMaterialID = ? and inv.FCurStoreQty > 0 and inv.FLot <> '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' ");
                if (assUnitID != null) {
                    sb.append("  and inv.FAssistPropertyID = ? ");
                } else {
                    sb.append("  and inv.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' ");
                }
                sb.append(" order by dom.FInWarehouseDate desc,inv.FLot asc");
                break;
            }
            case 4: {
                sb.append("select top 1 inv.FLot from T_IM_Inventory inv right outer join T_IM_DateOfMinDurability dom on inv.FLot = dom.FLot and inv.FStorageOrgUnitID = dom.FStorageOrgUnitID and inv.FMaterialID = dom.FMaterialID ");
                sb.append(" where inv.FStorageOrgUnitID = ? and inv.FMaterialID = ? and inv.FCurStoreQty > 0 and inv.FLot <> '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' ");
                if (assUnitID != null) {
                    sb.append("  and inv.FAssistPropertyID = ? ");
                } else {
                    sb.append("  and inv.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("'");
                }
                sb.append(" order by dom.FExp,dom.FInWarehouseDate,inv.FLot asc");
                break;
            }
            case -1: {
                return null;
            }
            default: {
                return null;
            }
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            perStmt = conn.prepareStatement(sb.toString());
            perStmt.setString(1, storageUnitID);
            perStmt.setString(2, materialId);
            if (assUnitID != null) {
                perStmt.setString(3, assUnitID);
            }
            rs = perStmt.executeQuery();
            while (rs.next()) {
                lot = rs.getString(1);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, perStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
        if ("YNi0IQEOEADgBT3mfwAAAcznrtQ=".equals(lot)) {
            lot = null;
        }
        return lot;
    }

    @Override
    protected void _batchInsertData(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        if (ids != null && billType != null) {
            String ids_str = SCMServerUtils.parseArraytoString((String[])ids);
            String billName = InvCommonUtils.getBillTableNameFromBillTypeID(billType);
            String entryName = InvCommonUtils.getBillEntryTableNameFromBillTypeID(billType);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.getBizSelectSql(ctx, ids_str, billName, entryName));
            try {
                List<Map<String, Object>> list = this.buildResult(rs);
                this.batchAddResult(ctx, list);
            }
            catch (NoSuchAlgorithmException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String getInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" INSERT INTO T_IM_DateOfMinDurability (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,");
        sql.append(" FControlUnitID,FLot,FStorageOrgUnitID,FInWarehouseDate,FMaterialID,FMfg,FDateOfMinDur,FExp,");
        sql.append(" FSupplierBatch,FManufactureBatch,FPeriodValidUnit,FPeriodValid,FPrepWarnAhead,");
        sql.append("FUniqueKey").append(") ");
        sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sql.toString();
    }

    private String getBizSelectSql(Context ctx, String ids_str, String billName, String entryName) throws InvalidDAOMetaDataException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT NEWBOSID('" + this.getDateOfMinDurBOSType(ctx) + "') FID,");
        sql.append(" B.FCreatorID,B.FCreateTime,B.FLastUpdateUserID,B.FLastUpdateTime,B.FControlUnitID,A.FLot,");
        sql.append(" A.FStorageOrgUnitID,B.FBizDate,A.FMaterialID,A.FMfg,datediff(DD,A.FMfg,A.FExp) as FDateOfMinDur,A.FExp,");
        sql.append(" NULL as FSupplierBatch,NULL as FManufactureBatch,C.FPeriodValidUnit,C.FPeriodValid, ");
        sql.append(" CASE WHEN C.FAheadUnit = 1 THEN C.FPrepWarnAhead * 365 WHEN C.FAheadUnit = 2");
        sql.append(" THEN C.FPrepWarnAhead * 30 WHEN C.FAheadUnit = 3 THEN C.FPrepWarnAhead ELSE NULL END as FPrepWarnAhead");
        sql.append(" FROM ");
        sql.append(" (");
        sql.append(" select ");
        sql.append(" FParentID,FLot, FStorageOrgUnitID, FMaterialID, FMfg, FExp ");
        sql.append(" from ").append(entryName);
        sql.append(" Where FParentId in (").append(ids_str).append(") ");
        sql.append(" AND FLot is not null ");
        sql.append(" Group by ");
        sql.append(" FParentID,FLot, FStorageOrgUnitID, FMaterialID, FMfg, FExp ");
        sql.append(" )  A ");
        sql.append(" Inner Join ").append(billName).append(" B ON A.FParentID = B.FID");
        sql.append(" Inner Join T_BD_MaterialInventory C On A.FMaterialID = C.FMaterialID AND A.FStorageOrgUnitID = C.FORGUNIT");
        sql.append(" Left Join T_IM_DateOfMinDurability D On A.Flot = D.Flot And  A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
        sql.append(" And A.FMaterialID = D.FMaterialID ");
        sql.append(" Where ");
        sql.append(" D.FID is null ");
        return sql.toString();
    }

    private List<Map> getDataFromResultSet(IRowSet rs) throws BOSException {
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            HashMap keyMap = new HashMap();
            HashMap<String, String> map = new HashMap<String, String>();
            String key = "";
            while (rs.next()) {
                key = rs.getString("") + rs.getString("") + rs.getString("");
                if (keyMap.containsKey(key)) continue;
                map.put("FID", rs.getString("FID"));
                keyMap.put(key, null);
                map.put("FUniqueKey", BalanceUtil.getMd5((String)key));
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    @Override
    protected Map _batchGetDateOfMin(Context ctx, IObjectCollection entryColl) throws BOSException, EASBizException {
        InvBillBaseEntryInfo invBillBaseEntryInfo = null;
        int count = 0;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        String souID = null;
        String materialID = null;
        String lot = null;
        HashMap result = new HashMap();
        String key = null;
        HashSet<String> keySet = new HashSet<String>();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            invBillBaseEntryInfo = (InvBillBaseEntryInfo)entryColl.getObject(i);
            if (invBillBaseEntryInfo.getStorageOrgUnit() != null && invBillBaseEntryInfo.getMaterial() != null && invBillBaseEntryInfo.getLot() != null) {
                souID = invBillBaseEntryInfo.getStorageOrgUnit().getId().toString();
                materialID = invBillBaseEntryInfo.getMaterial().getId().toString();
                lot = invBillBaseEntryInfo.getLot();
                key = souID + materialID + lot;
                if (!keySet.contains(key)) {
                    if (count != 0) {
                        maskString.append(" or ");
                    }
                    filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)souID, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialID, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
                    maskString.append(" #").append(count * 3).append(" and #").append(count * 3 + 1).append(" and #").append(count * 3 + 2);
                    ++count;
                    keySet.add(key);
                }
            }
            if (count <= 99 && i != size - 1) continue;
            filter.setMaskString(maskString.toString());
            viewInfo.setFilter(filter);
            DateOfMinDurabilityCollection coll = DateOfMinDurabilityFactory.getLocalInstance(ctx).getDateOfMinDurabilityCollection(viewInfo);
            Map temp = this.buildResult(coll);
            result.putAll(temp);
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            count = 0;
            maskString.setLength(0);
        }
        return result;
    }

    protected Map buildResult(DateOfMinDurabilityCollection coll) {
        HashMap<String, DateOfMinDurabilityInfo> res = new HashMap<String, DateOfMinDurabilityInfo>();
        DateOfMinDurabilityInfo info = null;
        String key = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            key = info.getStorageOrgUnit().getId().toString() + info.getMaterial().getId().toString() + info.getLot();
            res.put(key, info);
        }
        return res;
    }

    private List<Map<String, Object>> buildResult(IRowSet rs) throws SQLException, NoSuchAlgorithmException {
        if (rs.size() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        String key = "";
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            key = rs.getString("FStorageOrgUnitID") + rs.getString("FMaterialID") + rs.getString("FLot");
            if (keyMap.containsKey(key)) continue;
            keyMap.put(key, key);
            map.put("FID", rs.getObject("FID"));
            map.put("FCreatorID", rs.getObject("FCreatorID"));
            map.put("FCreateTime", rs.getObject("FCreateTime"));
            map.put("FLastUpdateUserID", rs.getObject("FLastUpdateUserID"));
            map.put("FLastUpdateTime", rs.getObject("FLastUpdateTime"));
            map.put("FControlUnitID", rs.getObject("FControlUnitID"));
            map.put("FLot", rs.getObject("FLot"));
            map.put("FStorageOrgUnitID", rs.getObject("FStorageOrgUnitID"));
            map.put("FInWarehouseDate", rs.getObject("FBizDate"));
            map.put("FMaterialID", rs.getObject("FMaterialID"));
            map.put("FMfg", rs.getObject("FMfg"));
            map.put("FDateOfMinDur", rs.getObject("FDateOfMinDur"));
            map.put("FExp", rs.getObject("FExp"));
            map.put("FSupplierBatch", rs.getObject("FSupplierBatch"));
            map.put("FManufactureBatch", rs.getObject("FManufactureBatch"));
            map.put("FPeriodValidUnit", rs.getObject("FPeriodValidUnit"));
            map.put("FPeriodValid", rs.getObject("FPeriodValid"));
            map.put("FPrepWarnAhead", rs.getObject("FPrepWarnAhead"));
            map.put("FUniqueKey", BalanceUtil.getMd5((String)key));
            list.add(map);
        }
        return list;
    }

    private void batchAddResult(Context ctx, List<Map<String, Object>> list) throws BOSException {
        if (list == null || list.size() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        Map<String, Object> map = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(this.getInsertSql());
            int k = 0;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                map = list.get(i);
                ps.setObject(++k, map.get("FID"));
                ps.setObject(++k, map.get("FCreatorID"));
                ps.setObject(++k, map.get("FCreateTime"));
                ps.setObject(++k, map.get("FLastUpdateUserID"));
                ps.setObject(++k, map.get("FLastUpdateTime"));
                ps.setObject(++k, map.get("FControlUnitID"));
                ps.setObject(++k, map.get("FLot"));
                ps.setObject(++k, map.get("FStorageOrgUnitID"));
                ps.setObject(++k, map.get("FInWarehouseDate"));
                ps.setObject(++k, map.get("FMaterialID"));
                ps.setObject(++k, map.get("FMfg"));
                ps.setObject(++k, map.get("FDateOfMinDur"));
                ps.setObject(++k, map.get("FExp"));
                if (map.get("FSupplierBatch") == null) {
                    ps.setObject(++k, "");
                } else {
                    ps.setObject(++k, map.get("FSupplierBatch"));
                }
                if (map.get("FManufactureBatch") == null) {
                    ps.setObject(++k, "");
                } else {
                    ps.setObject(++k, map.get("FManufactureBatch"));
                }
                ps.setObject(++k, map.get("FPeriodValidUnit"));
                ps.setObject(++k, map.get("FPeriodValid"));
                ps.setObject(++k, map.get("FPrepWarnAhead"));
                ps.setObject(++k, map.get("FUniqueKey"));
                k = 0;
                try {
                    ps.execute();
                    continue;
                }
                catch (SQLException e) {
                    logger.info((Object)"\u8fdd\u53cd\u552f\u4e00\u7ea6\u675f\uff0c\u4e0d\u505a\u5f02\u5e38\u5904\u7406", (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }
}

