/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostComputeReportInfo;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.MoveWeightedAverageCalculate;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.ISCMInitialize;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceCalculatorFactory;
import com.kingdee.eas.scm.framework.balance.app.engine.InvPeriodBalanceInitCalculator;
import com.kingdee.eas.scm.im.inv.CalulateBalanceInfo;
import com.kingdee.eas.scm.im.inv.InvStartSystemException;
import com.kingdee.eas.scm.im.inv.InventoryBalanceInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class IMInitialize
implements ISCMInitialize {
    private Logger logger = Logger.getLogger(IMInitialize.class);

    public void endInitialize(Context ctx, Map params) throws BOSException, EASBizException {
        ICompanyOrgUnit ico;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo;
        PeriodInfo startPeriodInfo;
        ObjectUuidPK companyPK = null;
        String companyID = "";
        HashMap parm = (HashMap)params.get("STOCK");
        if (!parm.isEmpty()) {
            companyID = parm.get("CompanyID").toString();
            companyPK = new ObjectUuidPK(BOSUuid.read((String)companyID));
        }
        if ((startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)(aCompanyOrgUnitInfo = (ico = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitInfo(companyPK)))) == null) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_NOTPERIOD);
        }
        this.setSystemStatus(ctx, aCompanyOrgUnitInfo, true);
    }

    private void setSystemStatus(Context ctx, CompanyOrgUnitInfo coi, boolean isStart) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        if (isStart) {
            if (!iSystemStatusCtrol.isStart(2, coi.getId().toString())) {
                iSystemStatusCtrol.start(SystemEnum.INVENTORYMANAGEMENT, coi, isStart);
            }
        } else if (iSystemStatusCtrol.isStart(2, coi.getId().toString())) {
            iSystemStatusCtrol.start(SystemEnum.INVENTORYMANAGEMENT, coi, isStart);
        }
    }

    public HashMap unInitialize(Context ctx, Map params) throws BOSException, EASBizException {
        params.put("isInit", new Boolean(false));
        if (this.isClosed(ctx, params) == null) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_ALLWAREHOUSENOINIT);
        }
        HashMap successMsg = this.unUpdateBalance(ctx, params);
        boolean isCompanyAllUninit = this.isCompanyAllUninit(ctx, params);
        if (isCompanyAllUninit) {
            successMsg.put("SuccessAllCompany", new Boolean(true));
            HashMap parm = (HashMap)params.get("STOCK");
            String companyID = parm.get("CompanyID").toString();
            CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
            cou.setId(BOSUuid.read((String)companyID));
            this.setSystemStatus(ctx, cou, false);
        }
        return successMsg;
    }

    private HashMap unUpdateBalance(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> successMsg = new HashMap<String, Object>(0);
        successMsg.put("SuccessAllCompany", new Boolean(false));
        String companyID = "";
        String storageID = "";
        String warehouseID = "";
        String calType = "";
        StringBuffer successWarehouseList = new StringBuffer();
        HashMap parm = (HashMap)params.get("STOCK");
        if (parm.isEmpty()) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_INVILDCOMPANY);
        }
        companyID = parm.get("CompanyID").toString();
        storageID = parm.get("StorageID").toString();
        warehouseID = parm.get("WarehouseID").toString();
        calType = parm.get("calType").toString();
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyID));
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        int startPeriod = curPeriod.getPeriodNumber();
        int startYear = curPeriod.getPeriodYear();
        boolean isCalNoNoramlStoreType = false;
        IRowSet rs = null;
        StringBuffer stringBuffer = new StringBuffer();
        String strSql = null;
        if (storageID.length() > 0) {
            strSql = "'" + storageID + "'";
        } else {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection cols = iOrgUnitRelation.getFromUnit(companyID, 1, 4);
            StringBuffer sb = new StringBuffer();
            if (cols == null || cols.size() <= 0) {
                return successMsg;
            }
            int rows = cols.size();
            for (int i = 0; i < rows; ++i) {
                IObjectValue value = cols.getObject(i);
                sb.append("'" + value.get("id").toString() + "',");
            }
            strSql = sb.substring(0, sb.length() - 1);
        }
        stringBuffer.append(" SELECT DISTINCT A.FID AS FID,A.FStorageOrgID AS FStorageOrgID,A.FWarehouseID AS FWarehouseID,");
        stringBuffer.append("B.FNumber as WHFnumber,B.Fname_l1 as Fname_l1,B.Fname_l2 as Fname_l2,B.Fname_l3 as Fname_l3");
        stringBuffer.append(" FROM T_DB_SOACCREDITWH A");
        stringBuffer.append(" LEFT JOIN T_DB_WAREHOUSE B ON A.FWarehouseID = B.FID ");
        stringBuffer.append(" WHERE A.FIsStarted = 1 AND B.FWhState = '1'");
        stringBuffer.append(" AND A.FStorageOrgID IN (" + strSql + ")");
        if (warehouseID != null && warehouseID.length() > 0) {
            stringBuffer.append(" AND A.FWarehouseID  = '" + warehouseID + "'");
        }
        stringBuffer.append(" AND A.FPeriodID = '");
        stringBuffer.append(curPeriod.getId().toString());
        stringBuffer.append("'");
        try {
            LowTimer t = new LowTimer();
            String sqlStr = stringBuffer.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            this.logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"15_IMInitialize", (Locale)ctx.getLocale()) + t.msValue()));
            StringBuffer sqlWhere1 = new StringBuffer();
            StringBuffer sqlWhere2 = new StringBuffer();
            boolean hsWarehsUninit = false;
            while (rs.next()) {
                hsWarehsUninit = true;
                storageID = rs.getString("FStorageOrgID");
                warehouseID = rs.getString("FWarehouseID");
                if (successWarehouseList.toString().length() > 0) {
                    successWarehouseList.append(";\n");
                }
                successWarehouseList.append("[");
                successWarehouseList.append(rs.getString("WHFnumber"));
                successWarehouseList.append("]\t");
                successWarehouseList.append(rs.getString(this.getLocName(ctx)));
                sqlWhere1 = new StringBuffer();
                sqlWhere2 = new StringBuffer();
                sqlWhere1.append("WHERE FCOMPANYORGUNITID = '");
                sqlWhere2.append("WHERE Fcompanyid = '");
                sqlWhere1.append(companyID);
                sqlWhere1.append("' ");
                sqlWhere2.append(companyID);
                sqlWhere2.append("' ");
                if (storageID != null && storageID.length() > 0) {
                    sqlWhere1.append("AND FStorageOrgUnitID = '");
                    sqlWhere1.append(storageID);
                    sqlWhere1.append("' ");
                    sqlWhere2.append("AND FSTORAGEORGID = '");
                    sqlWhere2.append(storageID);
                    sqlWhere2.append("' ");
                }
                if (warehouseID != null && warehouseID.length() > 0) {
                    sqlWhere1.append("AND FWarehouseID = '");
                    sqlWhere1.append(warehouseID);
                    sqlWhere1.append("' ");
                    sqlWhere2.append("AND FWarehouseID = '");
                    sqlWhere2.append(warehouseID);
                    sqlWhere2.append("' ");
                }
                t.reset();
                this.unInitDoCostData(ctx, companyID, storageID, warehouseID, curPeriod, calType);
                this.logger.debug((Object)("unInitDoCostData runtime: " + t.msValue()));
                t.reset();
                this.delCalBalTable(ctx, startPeriod, startYear, sqlWhere1.toString(), companyID, isCalNoNoramlStoreType);
                this.logger.debug((Object)("delCalBalTable runtime: " + t.msValue()));
                t.reset();
                this.logger.debug((Object)("unInsertCalulateBalance runtime: " + t.msValue()));
                t.reset();
                this.setWarehsNoInit(ctx, sqlWhere2.toString());
                this.logger.debug((Object)("setWarehsNoInit runtime: " + t.msValue()));
            }
            if (!hsWarehsUninit) {
                if (warehouseID != null && warehouseID.length() > 0) {
                    throw new InvStartSystemException(InvStartSystemException.IM_INV_WAREHSPERIODNOTCUR);
                }
                throw new InvStartSystemException(InvStartSystemException.IM_INV_NOWAREHSUNINIT);
            }
            successWarehouseList.append(".");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (successWarehouseList.toString().length() > 0) {
            successMsg.put("SuccMsg", successWarehouseList.toString());
        }
        return successMsg;
    }

    private void updateBalance(Context ctx, Map params) throws BOSException, EASBizException {
        String companyID = "";
        String storageID = "";
        String warehouseID = "";
        String calType = "";
        HashMap parm = (HashMap)params.get("STOCK");
        if (parm.isEmpty()) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_INVILDCOMPANY);
        }
        companyID = parm.get("CompanyID").toString();
        storageID = parm.get("StorageID").toString();
        warehouseID = parm.get("WarehouseID").toString();
        calType = parm.get("calType").toString();
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyID));
        PeriodInfo curPeriod = this.checkStartSystem(ctx, companyID, storageID, warehouseID);
        int startPeriod = curPeriod.getPeriodNumber();
        int startYear = curPeriod.getPeriodYear();
        boolean isCalNoNoramlStoreType = false;
        IRowSet rs = null;
        StringBuffer stringBuffer = new StringBuffer();
        String strSql = null;
        if (storageID.length() > 0) {
            strSql = "'" + storageID + "'";
        } else {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection cols = iOrgUnitRelation.getFromUnit(companyID, 1, 4);
            StringBuffer sb = new StringBuffer();
            if (cols == null || cols.size() <= 0) {
                return;
            }
            int rows = cols.size();
            for (int i = 0; i < rows; ++i) {
                IObjectValue value = cols.getObject(i);
                sb.append("'" + value.get("id").toString() + "',");
            }
            strSql = sb.substring(0, sb.length() - 1);
        }
        stringBuffer.append(" SELECT DISTINCT A.FID AS FID,A.FStorageOrgID AS FStorageOrgID,A.FWarehouseID AS FWarehouseID FROM T_DB_SOACCREDITWH A");
        stringBuffer.append(" LEFT JOIN T_DB_WAREHOUSE B ON A.FWarehouseID = B.FID ");
        stringBuffer.append(" WHERE A.FIsStarted = 0 AND B.FWhState = '1'");
        stringBuffer.append(" AND A.FStorageOrgID IN (" + strSql + ")");
        if (warehouseID.length() > 0) {
            stringBuffer.append(" AND A.FWarehouseID  = '" + warehouseID + "'");
        }
        try {
            LowTimer t = new LowTimer();
            String sqlStr = stringBuffer.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            this.logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"15_IMInitialize", (Locale)ctx.getLocale()) + t.msValue()));
            InvPeriodBalanceInitCalculator calculator = (InvPeriodBalanceInitCalculator)BalanceCalculatorFactory.getInvInitPeriodBalanceCalculator((Context)ctx);
            while (rs.next()) {
                storageID = rs.getString("FStorageOrgID");
                warehouseID = rs.getString("FWarehouseID");
                t.reset();
                this.logger.debug((Object)("insertCalBalTable runtime: " + t.msValue()));
                t.reset();
                calculator.calculate(companyID, storageID, warehouseID, curPeriod, OperationTypeEnum.Positive);
                this.insertFIFOBalTable(ctx, startPeriod, startYear, companyID, storageID, warehouseID, isCalNoNoramlStoreType);
                this.logger.debug((Object)("insertInvBalTable runtime: " + t.msValue()));
                t.reset();
                this.insertCostData(ctx, companyID, storageID, warehouseID, curPeriod, calType);
                this.logger.debug((Object)("insertCostData runtime: " + t.msValue()));
                t.reset();
                this.setFlag(ctx, curPeriod.getId().toString(), rs.getString("FID"), companyID);
                this.logger.debug((Object)("setFlag runtime: " + t.msValue()));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void unInitDoCostData(Context ctx, String companyID, String storageID, String warehouseID, PeriodInfo periodInfo, String calType) throws EASBizException, BOSException, UuidException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        sqlBuffer.append("SUM(FPeriodBeginQty) AS FQty,");
        sqlBuffer.append("SUM(FPeriodBeginBalance) AS FCost,");
        sqlBuffer.append("A.FMaterialID AS FMaterialID,B.FAccountType AS FAccountType ,");
        sqlBuffer.append("A.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        if ("0".equals(calType)) {
            sqlBuffer.append("NULL AS FStorageOrgUnitID,");
            sqlBuffer.append("NULL AS FWarehouseID ");
        } else if ("2".equals(calType)) {
            sqlBuffer.append("A.FStorageOrgUnitID AS FStorageOrgUnitID,");
            sqlBuffer.append("A.FWarehouseID AS FWarehouseID ");
        } else {
            sqlBuffer.append("A.FStorageOrgUnitID AS FStorageOrgUnitID,");
            sqlBuffer.append("NULL AS FWarehouseID ");
        }
        sqlBuffer.append("\n FROM T_IM_InventoryBalance A ");
        sqlBuffer.append("INNER JOIN T_IM_StoreType st on A.FStoreTypeId = st.FID ");
        sqlBuffer.append("INNER JOIN T_BD_MaterialCompanyInfo B ON A.FMaterialID = B.FMaterialID AND A.FCompanyOrgUnitID = B.FCompanyID ");
        sqlBuffer.append("WHERE B.FAccountType = 1");
        sqlBuffer.append(" AND A.FCompanyOrgUnitID = '" + companyID + "' ");
        if (storageID.length() > 0) {
            sqlBuffer.append(" AND A.FStorageOrgUnitID = '" + storageID + "' ");
        }
        if (warehouseID.length() > 0) {
            sqlBuffer.append(" AND A.FWarehouseID = '" + warehouseID + "' AND A.FWarehouseID IS NOT NULL ");
        }
        sqlBuffer.append(" AND A.FPeriod = " + periodInfo.getPeriodNumber());
        sqlBuffer.append(" AND A.FYear = " + periodInfo.getPeriodYear());
        sqlBuffer.append(" AND A.FISCALCULATE = 1");
        sqlBuffer.append(" AND st.FIsForwardAmt = 1").append("\n");
        if ("0".equals(calType)) {
            sqlBuffer.append(" GROUP BY A.FCompanyOrgUnitID,A.FMaterialID");
        } else if ("2".equals(calType)) {
            sqlBuffer.append(" GROUP BY A.FCompanyOrgUnitID,A.FStorageOrgUnitID,A.FWarehouseID,A.FMaterialID");
        } else {
            sqlBuffer.append(" GROUP BY A.FCompanyOrgUnitID,A.FStorageOrgUnitID,A.FMaterialID");
        }
        sqlBuffer.append(",B.FAccountType");
        StringBuffer sqltemp = new StringBuffer();
        sqltemp.append(" select FQTY, FCOST, totalsummaterial.FMATERIALID, FAccountType, FCOMPANYORGUNITID, FSTORAGEORGUNITID, FWAREHOUSEID");
        sqltemp.append("        ,MATERIAL.FPricePrecision AS FPricePrecision");
        sqltemp.append("        ,MeasureUnitBase.FQtyPrecision AS FQtyPrecision");
        sqltemp.append("        ,CURRENCY.FPrecision AS FLocalCurrencyPrecision");
        sqltemp.append("        ,T_SCM_BillType.FName_").append(ctx.getLocale().toString()).append(" AS FDescriptionName");
        sqltemp.append(" from (");
        sqltemp.append(sqlBuffer);
        sqltemp.append(" ) totalsummaterial ");
        sqltemp.append(" INNER JOIN T_BD_Material MATERIAL ");
        sqltemp.append(" ON totalsummaterial.FMaterialID = MATERIAL.FId");
        sqltemp.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sqltemp.append(" ON (totalsummaterial.FMaterialID = MeasureUnitBase.FMaterialid");
        sqltemp.append(" AND MATERIAL.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        sqltemp.append(" INNER JOIN T_SCM_BillType ON T_SCM_BillType.FID='").append("528d806a-0106-1000-e000-0194c0a812e6463ED552").append("'");
        sqltemp.append(" INNER JOIN T_ORG_Company AS COMPANY");
        sqltemp.append(" ON totalsummaterial.FCompanyOrgUnitID = COMPANY.FID");
        sqltemp.append(" INNER JOIN T_BD_Currency AS CURRENCY");
        sqltemp.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
        MoveWeightedAverageCalculate mwac = new MoveWeightedAverageCalculate();
        mwac.unCalculateCost(ctx, sqltemp.toString(), CalculateKindEnum.INPUT_WAREHOUSE);
        mwac.commit(ctx);
    }

    private void insertCostData(Context ctx, String companyID, String storageID, String warehouseID, PeriodInfo periodInfo, String calType) throws EASBizException, BOSException, UuidException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        sqlBuffer.append("SUM(FPeriodBeginQty) AS FQty,");
        sqlBuffer.append("SUM(FPeriodBeginBalance) AS FCost,");
        sqlBuffer.append("A.FMaterialID AS FMaterialID,B.FAccountType AS FAccountType,");
        sqlBuffer.append("A.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        if ("0".equals(calType)) {
            sqlBuffer.append("NULL AS FStorageOrgUnitID,");
            sqlBuffer.append("NULL AS FWarehouseID ");
        } else if ("2".equals(calType)) {
            sqlBuffer.append("A.FStorageOrgUnitID AS FStorageOrgUnitID,");
            sqlBuffer.append("A.FWarehouseID AS FWarehouseID ");
        } else {
            sqlBuffer.append("A.FStorageOrgUnitID AS FStorageOrgUnitID,");
            sqlBuffer.append("NULL AS FWarehouseID ");
        }
        sqlBuffer.append("\n FROM T_IM_InventoryBalance A ");
        sqlBuffer.append("INNER JOIN T_IM_StoreType st on A.FStoreTypeId = st.FID ");
        sqlBuffer.append("INNER JOIN T_BD_MaterialCompanyInfo B ON A.FMaterialID = B.FMaterialID AND A.FCompanyOrgUnitID = B.FCompanyID ");
        sqlBuffer.append("\n WHERE B.FAccountType = 1");
        sqlBuffer.append(" AND A.FCompanyOrgUnitID = '" + companyID + "' ");
        if (storageID.length() > 0) {
            sqlBuffer.append(" AND A.FStorageOrgUnitID = '" + storageID + "' ");
        }
        if (warehouseID.length() > 0) {
            sqlBuffer.append(" AND A.FWarehouseID = '" + warehouseID + "' AND A.FWarehouseID IS NOT NULL ");
        }
        sqlBuffer.append(" AND FPeriod = " + periodInfo.getPeriodNumber());
        sqlBuffer.append(" AND FYear = " + periodInfo.getPeriodYear());
        sqlBuffer.append(" AND A.FISCALCULATE = 1");
        sqlBuffer.append(" AND st.FIsForwardAmt = 1 ").append("\n");
        if ("0".equals(calType)) {
            sqlBuffer.append(" GROUP BY A.FCompanyOrgUnitID,A.FMaterialID");
        } else if ("2".equals(calType)) {
            sqlBuffer.append(" GROUP BY A.FCompanyOrgUnitID,A.FStorageOrgUnitID,A.FWarehouseID,A.FMaterialID");
        } else {
            sqlBuffer.append(" GROUP BY A.FCompanyOrgUnitID,A.FStorageOrgUnitID,A.FMaterialID");
        }
        sqlBuffer.append(",B.FAccountType");
        StringBuffer sqltemp = new StringBuffer();
        sqltemp.append(" select FQTY, FCOST, totalsummaterial.FMATERIALID, totalsummaterial.FAccountType, FCOMPANYORGUNITID, FSTORAGEORGUNITID, FWAREHOUSEID");
        sqltemp.append("        ,MATERIAL.FPricePrecision AS FPricePrecision");
        sqltemp.append("        ,MeasureUnitBase.FQtyPrecision AS FQtyPrecision");
        sqltemp.append("        ,CURRENCY.FPrecision AS FLocalCurrencyPrecision");
        sqltemp.append("        ,T_SCM_BillType.FName_").append(ctx.getLocale().toString()).append(" AS FDescriptionName");
        sqltemp.append(" from (");
        sqltemp.append(sqlBuffer);
        sqltemp.append(" ) totalsummaterial ");
        sqltemp.append(" INNER JOIN T_BD_Material MATERIAL ");
        sqltemp.append(" ON totalsummaterial.FMaterialID = MATERIAL.FId");
        sqltemp.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sqltemp.append(" ON (totalsummaterial.FMaterialID = MeasureUnitBase.FMaterialid");
        sqltemp.append(" AND MATERIAL.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        sqltemp.append(" INNER JOIN T_SCM_BillType ON T_SCM_BillType.FID='").append("528d806a-0106-1000-e000-0194c0a812e6463ED552").append("'");
        sqltemp.append(" INNER JOIN T_ORG_Company AS COMPANY");
        sqltemp.append(" ON totalsummaterial.FCompanyOrgUnitID = COMPANY.FID");
        sqltemp.append(" INNER JOIN T_BD_Currency AS CURRENCY");
        sqltemp.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
        MoveWeightedAverageCalculate mwac = new MoveWeightedAverageCalculate();
        mwac.calculateCost(ctx, sqltemp.toString(), true, CalculateKindEnum.INPUT_WAREHOUSE);
        mwac.commit(ctx);
    }

    private void setFlag(Context ctx, String periodID, String fid, String companyID) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("UPDATE T_DB_SOAccreditWH SET ");
        sqlBuffer.append("FPeriodID = '" + periodID + "', ");
        sqlBuffer.append("FComPanyID = '" + companyID + "', ");
        sqlBuffer.append("FIsStarted = 1 ");
        sqlBuffer.append("WHERE FID = '" + fid + "'");
        String sql = sqlBuffer.toString();
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private PeriodInfo checkStartSystem(Context ctx, String companyID, String storageID, String warehouseID) throws BOSException, EASBizException {
        ObjectUuidPK companyPK = new ObjectUuidPK(BOSUuid.read((String)companyID));
        ICompanyOrgUnit ico = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ico.getCompanyOrgUnitInfo((IObjectPK)companyPK);
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (curPeriod == null) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_NOTPERIOD);
        }
        String msg = this.checkInvBillIsAudit(ctx, companyID, storageID, warehouseID, curPeriod);
        if (msg != null && !msg.equals("")) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_BILLNOTAUDIT, new String[]{msg});
        }
        if (!SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo)) {
            this.setSystemStatus(ctx, aCompanyOrgUnitInfo, true);
        }
        return curPeriod;
    }

    private String checkInvBillIsAudit(Context ctx, String CompanyID, String storageID, String warehouseID, PeriodInfo curPeriod) throws EASBizException, BOSException {
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        String returnMsg = "";
        sqlBuffer.append("SELECT DISTINCT b.FNUMBER as FNUMBER ");
        sqlBuffer.append("FROM T_IM_InventoryInitEntry a ");
        sqlBuffer.append("INNER JOIN T_IM_InventoryInitBill b ");
        sqlBuffer.append("ON a.FParentID = b.FID ");
        sqlBuffer.append("WHERE b.FBaseStatus <> 4 ");
        sqlBuffer.append("AND b.FCompanyOrgUnitID = '" + CompanyID + "' ");
        if (storageID.length() > 0) {
            sqlBuffer.append("AND a.FStorageOrgUnitID = '" + storageID + "' ");
        }
        if (warehouseID.length() > 0) {
            sqlBuffer.append("AND a.FWarehouseID = '" + warehouseID + "';");
        }
        sql = sqlBuffer.toString();
        try {
            String sqlStr = sql.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            StringBuffer errorBuffer = new StringBuffer();
            while (rs.next()) {
                errorBuffer.append('\n').append(rs.getString("FNUMBER"));
            }
            returnMsg = errorBuffer.toString();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return returnMsg;
    }

    public String getCalBalBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new CalulateBalanceInfo().getBOSType().toString();
    }

    public String getInvBalBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new InventoryBalanceInfo().getBOSType().toString();
    }

    public String getRecentCostBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new RecentCostInfo().getBOSType().toString();
    }

    public String getSOAccreditWHBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new SOAccreditWHInfo().getBOSType().toString();
    }

    public String getCostComputeRptBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new CostComputeReportInfo().getBOSType().toString();
    }

    private void insertFIFOBalTable(Context ctx, int startPeriod, int startYear, String CompanyID, String storageID, String warehouseID, boolean isCalNNST) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        sqlBuffer.append("INSERT INTO T_CL_InventoryBalance");
        sqlBuffer.append("( ");
        sqlBuffer.append("FStorageOrgUnitID, ");
        sqlBuffer.append("FWarehouseID, ");
        sqlBuffer.append("FLocationID, ");
        sqlBuffer.append("FStoreStatusID, ");
        sqlBuffer.append("FStoreTypeID, ");
        sqlBuffer.append("FAssistPropertyID, ");
        sqlBuffer.append(this.getShareWriteInertSql(false, false));
        sqlBuffer.append("\n SELECT ");
        sqlBuffer.append("b.FStorageOrgUnitID, ");
        sqlBuffer.append("a.FWarehouseID, ");
        sqlBuffer.append("a.FLocationID, ");
        sqlBuffer.append("a.FStoreStatusID, ");
        sqlBuffer.append("a.FStoreTypeID, ");
        sqlBuffer.append("a.FAssistPropertyID, ");
        sqlBuffer.append("NEWBOSID('" + this.getInvBalBOSType(ctx) + "'), ");
        sqlBuffer.append(this.getShareWriteSelectSql(startPeriod, startYear, CompanyID, storageID, warehouseID, isCalNNST, true, false, false));
        sql = sqlBuffer.toString().replaceAll("SUM", "");
        DBUtil.execute((Context)ctx, (String)sql);
    }

    private void delCalBalTable(Context ctx, int startPeriod, int startYear, String sqlWhere, String companyID, boolean isCalNNST) throws BOSException, EASBizException {
        StringBuffer sqlBuffer1 = new StringBuffer();
        StringBuffer sqlBuffer5 = new StringBuffer();
        sqlBuffer1.append("DELETE FROM t_im_inventorybalance ");
        sqlBuffer5.append("DELETE FROM t_cl_inventorybalance ");
        StringBuffer wherePeriod = new StringBuffer();
        wherePeriod.append(" AND FYear = ");
        wherePeriod.append(startYear);
        wherePeriod.append(" AND FPeriod = ");
        wherePeriod.append(startPeriod);
        sqlBuffer1.append(sqlWhere);
        sqlBuffer1.append(wherePeriod);
        sqlBuffer5.append(sqlWhere);
        sqlBuffer5.append(wherePeriod);
        DBUtil.execute((Context)ctx, (String[])new String[]{sqlBuffer1.toString(), sqlBuffer5.toString()});
    }

    private void setWarehsNoInit(Context ctx, String sqlWhere) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update t_db_soaccreditwh set fisstarted = 0 ,FPeriodID = NULL ");
        sqlBuffer.append(sqlWhere);
        DBUtil.execute((Context)ctx, (String[])new String[]{sqlBuffer.toString()});
    }

    private String getShareWriteInertSql(boolean isHasActualCost, boolean hasFisCalcualte) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        sqlBuffer.append("FID, ");
        sqlBuffer.append("FPeriod, ");
        sqlBuffer.append("FYear, ");
        sqlBuffer.append("FCompanyOrgUnitID, ");
        sqlBuffer.append("FMaterialID, ");
        sqlBuffer.append("FLot, ");
        sqlBuffer.append("FProjectID, ");
        sqlBuffer.append("FTrackNumberID, ");
        sqlBuffer.append("FSeqNum, ");
        if (hasFisCalcualte) {
            sqlBuffer.append("FISCALCULATE,");
        }
        sqlBuffer.append("FPeriodBeginQty, ");
        sqlBuffer.append("FPeriodEndQty, ");
        sqlBuffer.append("FPeriodReceiptQty, ");
        sqlBuffer.append("FPeriodIssueQty, ");
        sqlBuffer.append("FPeriodBeginAssistQty, ");
        sqlBuffer.append("FPeriodEndAssistQty, ");
        sqlBuffer.append("FPeriodReceiptAssistQty, ");
        sqlBuffer.append("FPeriodIssueAssistQty, ");
        sqlBuffer.append("FPeriodBeginBalance, ");
        sqlBuffer.append("FPeriodEndBalance, ");
        sqlBuffer.append("FPeriodReceiptAmount, ");
        sqlBuffer.append("FPeriodIssueAmount, ");
        sqlBuffer.append("FPeriodBeginCostDiff, ");
        sqlBuffer.append("FPeriodEndCostDiff, ");
        sqlBuffer.append("FPeriodReceiptCostDiff, ");
        sqlBuffer.append("FPeriodIssueCostDiff, ");
        sqlBuffer.append("FYearIssueAmount, ");
        sqlBuffer.append("FYearReceiptAmount, ");
        sqlBuffer.append("FYearReceiptQty, ");
        sqlBuffer.append("FYearIssueQty, ");
        sqlBuffer.append("FYearReceiptAssistQty, ");
        sqlBuffer.append("FYearIssueAssistQty, ");
        sqlBuffer.append("FYearReceiptCostDiff, ");
        if (isHasActualCost) {
            sqlBuffer.append("FYearIssueCostDiff, ");
            sqlBuffer.append("FPeriodBeginActualCost, ");
            sqlBuffer.append("FPeriodEndActualCost");
        } else {
            sqlBuffer.append("FYearIssueCostDiff");
        }
        sqlBuffer.append(")");
        sql = sqlBuffer.toString();
        return sql;
    }

    private String getShareWriteSelectSql(int startPeriod, int startYear, String CompanyID, String storageID, String warehouseID, boolean isCalNNST, boolean isFIFO, boolean isHasActualCost, boolean isHasFisCalculate) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        sqlBuffer.append(startPeriod + ", ");
        sqlBuffer.append(startYear + ", ");
        sqlBuffer.append("b.FCompanyOrgUnitID, ");
        sqlBuffer.append("a.FMaterialID, ");
        sqlBuffer.append("FLot, ");
        sqlBuffer.append("(CASE ISNULL(MATERIALINVENTORY.FIsProjectNumber,0) WHEN 0 THEN null ELSE a.FProjectID END) AS FProjectID, ");
        sqlBuffer.append("(CASE ISNULL(MATERIALINVENTORY.FIsTrackingNumber,0) WHEN 0 THEN null ELSE a.FTrackNumberID END) AS FTrackNumberID, ");
        sqlBuffer.append("FSeqNum,");
        if (isHasFisCalculate) {
            sqlBuffer.append("1 as FISCALCULATE,");
        }
        sqlBuffer.append("SUM(ISNULL(FBaseQty,0)), ");
        sqlBuffer.append("0 AS FPeriodEndQty, ");
        sqlBuffer.append("0 AS FYearIssueBaseQty, ");
        sqlBuffer.append("0 AS FPeriodIssueQty, ");
        sqlBuffer.append("SUM(ISNULL(FAssistQty,0)) as FPeriodBeginAssistQty, ");
        sqlBuffer.append("SUM(ISNULL(FAssistQty,0)+ISNULL(FYearReceiptAssistQty,0)-ISNULL(FYearIssueAssistQty,0)) AS FPeriodEndAssistQty, ");
        sqlBuffer.append("0 AS FPeriodReceiptAssistQty, ");
        sqlBuffer.append("0 AS FPeriodIssueAssistQty, ");
        sqlBuffer.append("CASE st.FIsForwardAmt when 0 then 0 ELSE SUM(FAmount) END AS FPeriodBeginBalance, ");
        sqlBuffer.append("0 AS FPeriodEndBalance, ");
        sqlBuffer.append("0 AS FPeriodReceiptAmount, ");
        sqlBuffer.append("0 AS FPeriodIssueAmount,");
        sqlBuffer.append("CASE st.FIsForwardAmt when 0 then 0 ELSE SUM(ISNULL(FDiffAmount,0)) END AS FPeriodBeginCostDiff, ");
        sqlBuffer.append("0 AS FPeriodEndCostDiff, ");
        sqlBuffer.append("0 AS FPeriodReceiptCostDiff, ");
        sqlBuffer.append("0 AS FPeriodIssueCostDiff, ");
        sqlBuffer.append("CASE st.FIsForwardAmt when 0 then 0 ELSE SUM(ISNULL(FYearIssueAmount,0)) END AS FYearReceiptAmount, ");
        sqlBuffer.append("CASE st.FIsForwardAmt when 0 then 0 ELSE SUM(ISNULL(FYearReceiptAmount,0)) END AS FYearIssueAmount, ");
        sqlBuffer.append("SUM(ISNULL(FYearReceiptQty,0)) AS FYearReceiptQty, ");
        sqlBuffer.append("SUM(ISNULL(FYearIssueQty,0)) AS FYearIssueQty, ");
        sqlBuffer.append("SUM(ISNULL(FYearReceiptAssistQty,0)) AS FYearReceiptAssistQty, ");
        sqlBuffer.append("SUM(ISNULL(FYearIssueAssistQty,0)) AS FYearIssueAssistQty, ");
        sqlBuffer.append("CASE st.FIsForwardAmt when 0 then 0 ELSE SUM(ISNULL(FYearReceiptCostDiff,0)) END AS FYearReceiptCostDiff, ");
        if (isHasActualCost) {
            sqlBuffer.append("CASE st.FIsForwardAmt when 0 then 0 ELSE SUM(ISNULL(FYearIssueCostDiff,0)) END AS FYearIssueCostDiff, ");
            sqlBuffer.append("CASE st.FIsForwardAmt when 0 then 0 ELSE SUM(FAmount) + SUM(ISNULL(FDiffAmount,0)) END AS FPeriodBeginActualCost, ");
            sqlBuffer.append("0 AS FPeriodEndActualCost ");
        } else {
            sqlBuffer.append("CASE st.FIsForwardAmt when 0 then 0 ELSE SUM(ISNULL(FYearIssueCostDiff,0)) END AS FYearIssueCostDiff ");
        }
        sqlBuffer.append("\n FROM T_IM_InventoryInitEntry a ");
        sqlBuffer.append("INNER JOIN T_IM_InventoryInitBill b ON a.FParentID = b.FID ");
        sqlBuffer.append("INNER JOIN T_IM_StoreType st ON a.FStoreTypeID = st.FID ");
        sqlBuffer.append("LEFT JOIN T_BD_MaterialInventory MATERIALINVENTORY ");
        sqlBuffer.append("ON a.FMaterialID = MATERIALINVENTORY.FMaterialID ");
        sqlBuffer.append(" AND a.FSTORAGEORGUNITID = MATERIALINVENTORY.FOrgUnit ");
        sqlBuffer.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sqlBuffer.append(" ON (a.FMaterialID = MATERIALCOMPANY.FMaterialID");
        sqlBuffer.append(" AND b.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID ) ");
        sqlBuffer.append("\n WHERE (b.FCompanyOrgUnitID ='" + CompanyID + "' ");
        sqlBuffer.append("AND b.FBaseStatus = 4 ");
        if (storageID != null && storageID.length() > 0) {
            sqlBuffer.append("AND a.FStorageOrgUnitID = '" + storageID + "' ");
        }
        if (warehouseID != null && warehouseID.length() > 0) {
            sqlBuffer.append("AND a.FWarehouseID = '" + warehouseID + "' ");
        }
        sqlBuffer.append(") ");
        if (isCalNNST) {
            sqlBuffer.append("OR (b.FCompanyOrgUnitID ='" + CompanyID + "' ");
            sqlBuffer.append("AND b.FBaseStatus = 4 ");
            sqlBuffer.append("AND A.FIsInitClosed = 0 ");
            if (storageID.length() > 0) {
                sqlBuffer.append("AND a.FStorageOrgUnitID = '" + storageID + "' ");
            }
            sqlBuffer.append("AND a.FStoreTypeID IN ('181875d5-0105-1000-e000-011ac0a812fd97D461A6')");
            sqlBuffer.append(") ");
        }
        if (isFIFO && !isHasFisCalculate) {
            sqlBuffer.append(" AND st.FIsForwardAmt = 1 ");
            sqlBuffer.append(" AND MATERIALCOMPANY.FAccountType = 4 ");
        }
        sql = sqlBuffer.toString();
        return sql;
    }

    public void invEndInitialize(Context ctx, Map params) throws BOSException, EASBizException {
        this.updateBalance(ctx, params);
        this.changeStatus(ctx, params);
    }

    public String[] isClosed(Context ctx, Map params) throws BOSException, EASBizException {
        boolean isInit = true;
        if (params.get("isInit") != null) {
            isInit = (Boolean)params.get("isInit");
        }
        String companyID = "";
        HashMap parm = (HashMap)params.get("STOCK");
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
        if (parm.isEmpty()) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_INVILDCOMPANY);
        }
        companyID = parm.get("CompanyID").toString();
        ObjectUuidPK companyPK = new ObjectUuidPK(BOSUuid.read((String)companyID));
        ICompanyOrgUnit ico = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        aCompanyOrgUnitInfo = ico.getCompanyOrgUnitInfo((IObjectPK)companyPK);
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        String strSql = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection cols = iOrgUnitRelation.getFromUnit(companyID, 1, 4);
        StringBuffer sb = new StringBuffer();
        if (cols == null || cols.size() <= 0) {
            return null;
        }
        int rows = cols.size();
        for (int i = 0; i < rows; ++i) {
            IObjectValue value = cols.getObject(i);
            sb.append("'" + value.get("id").toString() + "',");
        }
        strSql = sb.substring(0, sb.length() - 1);
        sqlBuffer.append("SELECT COUNT(FID) ");
        sqlBuffer.append("AS FROWS ");
        sqlBuffer.append("FROM T_DB_SOAccreditWH ");
        if (isInit) {
            sqlBuffer.append("WHERE FIsStarted = 0 ");
        } else {
            sqlBuffer.append("WHERE FIsStarted = 1 ");
        }
        sqlBuffer.append(" AND FStorageOrgID IN (" + strSql + ")");
        sql = sqlBuffer.toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && rs.getInt("FROWS") <= 0) {
                return null;
            }
            return new String[0];
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    public boolean isCompanyAllUninit(Context ctx, Map params) throws BOSException, EASBizException {
        String companyID = "";
        String storageID = "";
        HashMap parm = (HashMap)params.get("STOCK");
        if (parm.isEmpty()) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_INVILDCOMPANY);
        }
        companyID = parm.get("CompanyID").toString();
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        String strSql = null;
        if (storageID.length() > 0) {
            strSql = "'" + storageID + "'";
        } else {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection cols = iOrgUnitRelation.getFromUnit(companyID, 1, 4);
            StringBuffer sb = new StringBuffer();
            if (cols == null || cols.size() <= 0) {
                return true;
            }
            int rows = cols.size();
            for (int i = 0; i < rows; ++i) {
                IObjectValue value = cols.getObject(i);
                sb.append("'" + value.get("id").toString() + "',");
            }
            strSql = sb.substring(0, sb.length() - 1);
        }
        sqlBuffer.append("SELECT COUNT(FID) ");
        sqlBuffer.append("AS FROWS ");
        sqlBuffer.append("FROM T_DB_SOAccreditWH ");
        sqlBuffer.append("WHERE FIsStarted = 1 ");
        sqlBuffer.append(" AND FStorageOrgID IN (" + strSql + ")");
        sql = sqlBuffer.toString();
        try {
            String sqlStr = sql;
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            rs.next();
            return rs.getInt("FROWS") <= 0;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private void changeStatus(Context ctx, Map params) throws EASBizException, BOSException {
        HashMap parm = (HashMap)params.get("STOCK");
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
        if (parm.isEmpty()) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_INVILDCOMPANY);
        }
        String companyID = parm.get("CompanyID").toString();
        ObjectUuidPK companyPK = new ObjectUuidPK(BOSUuid.read((String)companyID));
        ICompanyOrgUnit ico = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        aCompanyOrgUnitInfo = ico.getCompanyOrgUnitInfo((IObjectPK)companyPK);
        boolean isInit = true;
        if (parm.get("isInit") != null) {
            isInit = (Boolean)params.get("isInit");
        }
        if (isInit) {
            this.setSystemStatus(ctx, aCompanyOrgUnitInfo, true);
        }
    }
}

