/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBill;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBillForPurInViaBotp;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBillForSaleIssueViaBotp;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class InvAppUtils {
    public static final HashMap transactionPorpertyMap = new HashMap();
    public static final HashMap transTypeMap = new HashMap();
    public static final int qtyCheckMaxError = 5;
    public static final String maxAllowDiff = "0.0001";
    public static final String lotFixValue = "YNi0IQEOEADgBT3mfwAAAcznrtQ=";
    public static final String InventoryIDList = "InventoryIDList";
    public static final String ShortQtyInvInfoList = "ShortQtyInvInfoList";
    public static String noStr;
    public static String rowStr;
    public static String allowDateRangeStr;
    public static String allowQtyRangeStr;
    public static String materialStr;
    public static String shortQtyStr;
    public static String overQtyStr;
    public static String shortMoneyStr;
    public static String CurStoreQty;
    public static String CurStoreAssistQty;
    public static String entrySeq;
    private static InvAppUtils inst;

    public static synchronized void staticInitial(Context ctx) {
        if (inst == null) {
            try {
                Context tmp = ContextUtils.getContextFromSessionNoException();
                if (tmp != null) {
                    ctx = tmp;
                }
                InvAppUtils.initInventoryResMap(ctx);
                inst = new InvAppUtils();
            }
            catch (Throwable e) {
                inst = null;
                Logger.error((Throwable)e);
            }
        }
    }

    public static TransactionTypeInfo getTransType(Context ctx, String id) throws BOSException, EASBizException {
        InvAppUtils.staticInitial(ctx);
        return SCMBaseCommonUtil.getTransType((Context)ctx, (String)id);
    }

    private static void initInventoryResMap(Context ctx) {
        noStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"No", (Context)ctx);
        rowStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"Row", (Context)ctx);
        allowDateRangeStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"AllowDateRange", (Context)ctx);
        allowQtyRangeStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"AllowQtyRange", (Context)ctx);
        materialStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"Material", (Context)ctx);
        shortQtyStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"ShortQty", (Context)ctx);
        overQtyStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"OverQty", (Context)ctx);
        shortMoneyStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"ShortMoney", (Context)ctx);
        entrySeq = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"ENTRY_SEQ", (Context)ctx);
        CurStoreQty = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"CurStoreQty", (Context)ctx);
        CurStoreAssistQty = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"CurStoreAssistQty", (Context)ctx);
    }

    private InvAppUtils() {
    }

    public static BigDecimal getBaseUnitQty(Context ctx, MeasureUnitInfo mui, MeasureUnitInfo baseUnit, MaterialInfo mi, BigDecimal qty) throws BOSException {
        InvAppUtils.staticInitial(ctx);
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (mui != null && mui.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("MEASUREUNIT.ID", (Object)mui.getId().toString(), CompareType.EQUALS));
        }
        if (mi != null && mi.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("MATERIAL.ID", (Object)mi.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        MultiMeasureUnitInfo mulUnit = immu.getMultiMeasureUnitCollection(viewInfo).get(0);
        coefficient = mulUnit.getBaseConvsRate();
        if (coefficient != null) {
            baseQty = qty.multiply(coefficient);
            viewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            if (mui != null && mui.getId() != null && baseUnit != null && baseUnit.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("MEASUREUNIT.ID", (Object)baseUnit.getId().toString(), CompareType.EQUALS));
            }
            if (mi != null && mi.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("MATERIAL.ID", (Object)mi.getId().toString(), CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            MultiMeasureUnitInfo mulbaseUnit = immu.getMultiMeasureUnitCollection(viewInfo).get(0);
            int precision = mulbaseUnit.getQtyPrecision();
            baseQty = baseQty.setScale(precision, 4);
        }
        return baseQty;
    }

    public static BigDecimal getUnitPrice(Context ctx, MaterialInfo material, BigDecimal fromPrice, MeasureUnitInfo fromUnit, MeasureUnitInfo toUnit) throws BOSException, EASBizException {
        InvAppUtils.staticInitial(ctx);
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo fromMmu = immu.getMultiUnit(material.getId().toString(), fromUnit.getId().toString());
        MultiMeasureUnitInfo toMmu = immu.getMultiUnit(material.getId().toString(), toUnit.getId().toString());
        BigDecimal fromRate = fromMmu.getBaseConvsRate();
        BigDecimal toRate = toMmu.getBaseConvsRate();
        BigDecimal temPrice = fromPrice.divide(fromRate, material.getPricePrecision(), 4);
        BigDecimal toPrice = temPrice.multiply(toRate).setScale(material.getPricePrecision(), 4);
        return toPrice;
    }

    public static BigDecimal getMultiUnitQty(Context ctx, MeasureUnitInfo muiFrom, MeasureUnitInfo muiTo, MaterialInfo mi, BigDecimal qtyFrom) throws BOSException, EASBizException {
        InvAppUtils.staticInitial(ctx);
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal qtyTo = new BigDecimal("0.00");
        if (qtyFrom == null) {
            return qtyFrom;
        }
        qtyTo = qtyFrom;
        MultiMeasureUnitInfo mulUnitFrom = InvAppUtils.getMulUnit(ctx, muiFrom, mi);
        MultiMeasureUnitInfo mulUnitTo = InvAppUtils.getMulUnit(ctx, muiTo, mi);
        if (mulUnitFrom != null && mulUnitTo != null && (coefficient = mulUnitFrom.getBaseConvsRate().divide(mulUnitTo.getBaseConvsRate(), 18, 4)) != null) {
            qtyFrom = qtyFrom.multiply(coefficient);
        }
        if (mulUnitTo != null) {
            qtyTo = qtyFrom.setScale(mulUnitTo.getQtyPrecision(), 4);
        }
        return qtyTo;
    }

    private static MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws BOSException, EASBizException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public static TransactionTypeInfo putTransType(Context ctx, String id) throws BOSException, EASBizException {
        return SCMBaseCommonUtil.putTransType((Context)ctx, (String)id);
    }

    public static HashMap putTransType(Context ctx, Set ids) throws BOSException, InvUpdateException {
        HashMap<String, TransactionTypeInfo> transTypeMap = new HashMap<String, TransactionTypeInfo>();
        TransactionTypeInfo transType = new TransactionTypeInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().addObjectCollection((IObjectCollection)SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        ITransactionType iTransType = TransactionTypeFactory.getLocalInstance((Context)ctx);
        TransactionTypeCollection transTypeCol = iTransType.getTransactionTypeCollection(entityViewInfo);
        for (int i = 0; i < transTypeCol.size(); ++i) {
            transType = transTypeCol.get(0);
            transTypeMap.put(transType.getId().toString(), transType);
        }
        return transTypeMap;
    }

    public static PriceInfo getPriceInfo(PriceInfo priceInfo) {
        BigDecimal zero = new BigDecimal("0.00");
        BigDecimal val = new BigDecimal("0.01");
        BigDecimal one = new BigDecimal("1.00");
        BigDecimal price = new BigDecimal("0.00");
        price = priceInfo.getIsInTax() ? priceInfo.getTaxPrice() : priceInfo.getPrice();
        BigDecimal priceCal = price;
        if (priceInfo.getIsInTax()) {
            if (priceInfo.getTaxRate() != null && priceInfo.getTaxRate().compareTo(zero) > 0) {
                BigDecimal rate = one;
                rate = rate.add(priceInfo.getTaxRate().multiply(val));
                priceCal = price.divide(rate, priceInfo.getPricePrecision(), 4);
            } else {
                priceCal = priceInfo.getTaxPrice();
            }
            priceInfo.setPrice(priceCal);
        } else {
            if (priceInfo.getTaxRate() != null && priceInfo.getTaxRate().compareTo(zero) > 0) {
                priceCal = price.multiply(one.add(priceInfo.getTaxRate().multiply(val)));
                priceCal = priceCal.setScale(priceInfo.getPricePrecision(), 4);
            }
            priceInfo.setTaxPrice(priceCal);
        }
        priceCal = priceInfo.getPrice();
        if (priceInfo.getDiscountRate() != null) {
            if (priceInfo.getDiscountType().equals((Object)DiscountModeEnum.PERCENT)) {
                if (priceInfo.getDiscountRate().compareTo(zero) > 0) {
                    priceCal = priceCal.multiply(one.subtract(priceInfo.getDiscountRate().multiply(val)));
                }
            } else if (priceInfo.getDiscountType().equals((Object)DiscountModeEnum.PERUNIT) && priceInfo.getTaxRate() != null && priceInfo.getTaxRate().compareTo(zero) > 0) {
                BigDecimal temp = one.add(priceInfo.getTaxRate().multiply(val));
                if (priceInfo.getDiscountRate() != null && priceInfo.getDiscountRate().compareTo(zero) > 0) {
                    priceCal = priceCal.subtract(priceInfo.getDiscountRate().divide(temp, 6, 4));
                }
            }
        }
        priceCal = priceCal.setScale(priceInfo.getPricePrecision(), 4);
        priceInfo.setActualPrice(priceCal);
        BigDecimal actualTaxPrice = priceInfo.getTaxPrice();
        if (actualTaxPrice != null && priceInfo.getDiscountRate() != null && priceInfo.getDiscountRate().compareTo(zero) > 0) {
            if (DiscountModeEnum.PERCENT.equals((Object)priceInfo.getDiscountType())) {
                actualTaxPrice = actualTaxPrice.multiply(one.subtract(priceInfo.getDiscountRate().multiply(val)));
                actualTaxPrice = actualTaxPrice.setScale(priceInfo.getPricePrecision(), 4);
            } else if (DiscountModeEnum.PERUNIT.equals((Object)priceInfo.getDiscountType())) {
                actualTaxPrice = actualTaxPrice.subtract(priceInfo.getDiscountRate());
            }
        }
        priceInfo.setActualTaxPrice(actualTaxPrice);
        priceInfo.setTaxPrice(priceInfo.getTaxPrice().setScale(priceInfo.getPricePrecision(), 4));
        priceInfo.setActualTaxPrice(priceInfo.getActualTaxPrice().setScale(priceInfo.getPricePrecision(), 4));
        return priceInfo;
    }

    public static boolean checkBizDate(Context ctx, IObjectValue model, CompanyOrgUnitInfo company, PeriodInfo currentPeriodInfo, boolean isVirtualBill) throws EASBizException, BOSException {
        if (model == null) {
            return false;
        }
        InvBillBaseInfo info = (InvBillBaseInfo)model;
        if (info.getBizDate() == null) {
            if (isVirtualBill) {
                throw new SCMBillException(SCMBillException.BIZDATEISNULL_VIRTUAL);
            }
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        if (currentPeriodInfo == null) {
            if (isVirtualBill) {
                throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL_VIRTUAL, new Object[]{company.getName()});
            }
            throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
        }
        Object[] temp = new String[1];
        StringBuffer sb = new StringBuffer();
        sb.append(currentPeriodInfo.getBeginDate().getYear() + 1900);
        sb.append("-");
        int month = currentPeriodInfo.getBeginDate().getMonth() + 1;
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month);
        sb.append("-");
        int date = currentPeriodInfo.getBeginDate().getDate();
        if (date < 10) {
            sb.append("0");
        }
        sb.append(date);
        temp[0] = sb.toString();
        if (info.isIsInitBill() && !info.getBizDate().before(currentPeriodInfo.getBeginDate())) {
            throw new SCMBillException(SCMBillException.BIZDATEAFTERPERIOD, temp);
        }
        if (info.getBizDate().before(currentPeriodInfo.getBeginDate())) {
            if (isVirtualBill) {
                throw new SCMBillException(SCMBillException.BIZDATEBEFOREPERIOD_VIRTUAL, new Object[]{company.getName(), sb.toString()});
            }
            throw new SCMBillException(SCMBillException.BIZDATEBEFOREPERIOD, temp);
        }
        return true;
    }

    public static Map getMultiMeasureMap(Context ctx, List materialIdList, List unitIdList) throws BOSException {
        HashMap<String, MultiMeasureUnitInfo> result = new HashMap<String, MultiMeasureUnitInfo>();
        if (null == materialIdList || materialIdList.size() == 0 || null == unitIdList || unitIdList.size() == 0) {
            return result;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", new HashSet(materialIdList), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", new HashSet(unitIdList), CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        MultiMeasureUnitCollection mulCol = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        if (null != mulCol && mulCol.size() > 0) {
            int size = mulCol.size();
            for (int i = 0; i < size; ++i) {
                MultiMeasureUnitInfo mulUnitInfo = mulCol.get(i);
                String key = mulUnitInfo.getMaterial().getId().toString() + mulUnitInfo.getMeasureUnit().getId().toString();
                result.put(key, mulUnitInfo);
            }
        }
        return result;
    }

    public static Map getMaterialInventoryMap(Context ctx, Set matIds, String souId) throws BOSException {
        HashMap<String, MaterialInventoryInfo> rs = new HashMap<String, MaterialInventoryInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isProjectNumber"));
        sic.add(new SelectorItemInfo("isTrackingNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)matIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)souId, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        MaterialInventoryCollection col = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(view);
        MaterialInventoryInfo matInvInfo = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            matInvInfo = col.get(i);
            rs.put(matInvInfo.getMaterial().getId().toString(), matInvInfo);
        }
        return rs;
    }

    public static Map getMaterialBaseUnit(Context ctx, Set matIds) throws BOSException {
        HashMap<String, MaterialInfo> rs = new HashMap<String, MaterialInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)matIds, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        MaterialCollection materialColl = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        MaterialInfo matInfo = null;
        int size = materialColl.size();
        for (int i = 0; i < size; ++i) {
            matInfo = materialColl.get(i);
            rs.put(matInfo.getId().toString(), matInfo);
        }
        return rs;
    }

    public static BigDecimal calBaseQtyByQty(Context ctx, BigDecimal qty, MeasureUnitInfo mui, MaterialInfo mi) {
        BigDecimal baseQty = SysConstant.BIGZERO;
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        if (qty != null && qty.compareTo(SysConstant.BIGZERO) == 0) {
            return baseQty;
        }
        MultiMeasureUnitInfo mulUnit = null;
        try {
            mulUnit = InvAppUtils.getMulUnit(ctx, mui, mi);
            if (mulUnit != null) {
                BigDecimal coefficient = mulUnit.getBaseConvsRate();
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId().toString())).getBaseUnit();
                }
                mulUnit = InvAppUtils.getMulUnit(ctx, baseUnit, mi);
                int precision = mulUnit.getQtyPrecision();
                baseQty.setScale(precision, 4);
            }
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return baseQty;
    }

    public static String getDecimalFormatString(Context ctx, BigDecimal dec, int scale) {
        HashMap nationMap;
        if (dec == null) {
            return null;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        try {
            nationMap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(userId, orgId, ctx.getLocale().toString());
        }
        catch (Exception e) {
            return null;
        }
        DecimalFormat df = (DecimalFormat)nationMap.get("numberFormat");
        df.applyPattern(PrecisionUtil.getFmtString((int)scale));
        return df.format(dec);
    }

    public static boolean isNegative(TransactionTypeInfo info) {
        if (info == null || info.getRiType() == null || info.getRiType().getBizDirection() == null) {
            return false;
        }
        int bizDirection = info.getRiType().getBizDirection().getValue();
        return bizDirection == -1;
    }

    public static OrgUnitInfo getDefaultMainBizOrg(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        OrgUnitInfo[] mainOrgs = InvAppUtils.getMainBizOrgList(ctx, orgType, permissionItem);
        OrgUnitInfo currentMainOrg = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType);
        if (currentMainOrg != null && mainOrgs != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return currentMainOrg;
            }
        }
        if (mainOrgs != null && mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    public static OrgUnitInfo getDefaultMainBizOrg(Context ctx, OrgType orgType, OrgUnitInfo[] mainOrgs) throws BOSException, EASBizException {
        OrgUnitInfo currentMainOrg = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType);
        if (currentMainOrg != null && mainOrgs != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return currentMainOrg;
            }
        }
        if (mainOrgs != null && mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    public static OrgUnitInfo[] getMainBizOrgList(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        OrgUnitInfo[] mainOrgs = null;
        mainOrgs = SCMServiceFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), orgType, permissionItem);
        if (mainOrgs == null || mainOrgs.length == 0) {
            return null;
        }
        ArrayList<OrgUnitInfo> tempOrgArray = new ArrayList<OrgUnitInfo>();
        boolean isSealUp = false;
        for (int i = 0; i < mainOrgs.length; ++i) {
            if (mainOrgs[i].get("isSealup") != null) {
                isSealUp = Boolean.valueOf(String.valueOf(mainOrgs[i].get("isSealup")));
            }
            if (!mainOrgs[i].isIsOUSealUp() && !isSealUp) {
                tempOrgArray.add(mainOrgs[i]);
            }
            isSealUp = false;
        }
        mainOrgs = tempOrgArray.toArray(new OrgUnitInfo[tempOrgArray.size()]);
        if (mainOrgs.length > 0) {
            mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
        }
        return mainOrgs;
    }

    private static CreateVirtualBill getCreateVirtualBillInstance(Context ctx, IObjectValue model) {
        InvBillBaseInfo ibb = (InvBillBaseInfo)model;
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(ibb.getBillType().getId().toString())) {
            return new CreateVirtualBillForPurInViaBotp();
        }
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(ibb.getBillType().getId().toString())) {
            return new CreateVirtualBillForSaleIssueViaBotp();
        }
        return null;
    }

    public static boolean checkBillCreateVirtualbill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CreateVirtualBill cvb;
        InvBillBaseInfo ibb = (InvBillBaseInfo)model;
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(ibb.getBillType().getId().toString())) {
            MaterialReqBillInfo info = (MaterialReqBillInfo)model;
            BizTypeInfo bizType = info.getBizType();
            if (bizType == null || bizType.getId() == null) {
                return false;
            }
            String bizTypeID = bizType.getId().toString();
            if (bizTypeID.equals("nhvcdx82RzuTw48FSlV79CQHQ1w=") || bizTypeID.equals("YJN9V65PSkutQxeUH6F72SQHQ1w=") || bizTypeID.equals("i6DbShN4SLaNlFkX90UXOiQHQ1w=")) {
                return true;
            }
        }
        if ((cvb = InvAppUtils.getCreateVirtualBillInstance(ctx, model)) != null) {
            if (ibb.isIsReversed()) {
                return cvb.checkUpdateVirtualBillForReversed(ctx, model);
            }
            return cvb.checkCreateVirtualBill(ctx, model);
        }
        return false;
    }

    public static boolean checkHasVirtualbill(Context ctx, IObjectValue model) {
        if (!(model instanceof SaleIssueBillInfo || model instanceof MaterialReqBillInfo || model instanceof PurInWarehsBillInfo)) {
            return false;
        }
        Vector vecPurVisualBill = (Vector)model.get("purInWarehsVirtualBill");
        Vector vecSaleVisualBill = (Vector)model.get("purSaleIssueVirtualBill");
        Vector vecMoveInVisualBill = (Vector)model.get("purMoveInVirtualBill");
        Vector vecMoveIssueVisualBill = (Vector)model.get("purMoveIssueVirtualBill");
        return vecPurVisualBill != null && vecPurVisualBill.size() > 0 || vecSaleVisualBill != null && vecSaleVisualBill.size() > 0 || vecMoveInVisualBill != null && vecMoveInVisualBill.size() > 0 || vecMoveIssueVisualBill != null && vecMoveIssueVisualBill.size() > 0;
    }

    public static boolean isExecuteBizProcess(Context ctx, InvBillBaseInfo info) throws BOSException, EASBizException {
        boolean isExecute = false;
        if (!(info instanceof SaleIssueBillInfo || info instanceof MaterialReqBillInfo || info instanceof PurInWarehsBillInfo)) {
            return isExecute;
        }
        String transTypeID = info.getTransactionType().getId().toString();
        return InvAppUtils.isExitsBizFlowValue(ctx, info.getId().toString(), transTypeID);
    }

    public static boolean isExitsBizFlowValue(Context ctx, String billID, String transTypeID) throws BOSException, EASBizException {
        boolean isExitsBizFlowValue = false;
        TransactionTypeInfo transType = InvAppUtils.getTransType(ctx, transTypeID);
        String tableName = InvCommonUtils.getBillEntryTableName(transType);
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)billID)) {
            isExitsBizFlowValue = true;
        }
        return isExitsBizFlowValue;
    }

    static {
        inst = null;
    }
}

