/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignCollection;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.BillBaseException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.IManualWriteOffFacade;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.cal.app.help.WriteOffHelp;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseCollection;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMParamFacadeFactory;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.validate.GeneralCurrencyDealBuilder;
import com.kingdee.eas.scm.im.dt.DtTempFacadeFactory;
import com.kingdee.eas.scm.im.dt.IDtTempFacade;
import com.kingdee.eas.scm.im.inv.AbstractInvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.AbstractPurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.AbstractSaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.CalculateLotException;
import com.kingdee.eas.scm.im.inv.CalculateLotLineValue;
import com.kingdee.eas.scm.im.inv.CalculateLotValue;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DecomposeEntryFactory;
import com.kingdee.eas.scm.im.inv.DecomposeEntryInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.IMoveInWarehsBill;
import com.kingdee.eas.scm.im.inv.IMoveIssueBill;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryCollection;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.SplitBillEntryRelationInfo;
import com.kingdee.eas.scm.im.inv.SplitBillRelationInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractInvBillBaseControllerBean;
import com.kingdee.eas.scm.im.inv.app.IUniteBill;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.UniteBillFactory;
import com.kingdee.eas.scm.im.inv.invconfig.app.CalculateLotAppHelper;
import com.kingdee.eas.scm.im.inv.util.CalBillHelper;
import com.kingdee.eas.scm.im.reservation.impl.InvBalanceReservationSplitEntryImpl;
import com.kingdee.eas.scm.im.reservation.service.ReservationSplitEntryService;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InvBillBaseControllerBean
extends AbstractInvBillBaseControllerBean {
    private static final long serialVersionUID = 3332222122221L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.InvBillBaseControllerBean");
    protected static final String CTX_TEMP_CHECKED_BIZDATE = "CTX_CONSTANT_CHECKED_BIZDATE";
    protected static final String CTX_TEMP_BILL_TRANSACTIONTYPE = "CTX_TEMP_BILL_TRANSACTIONTYPE";
    protected Boolean isBotpConfigTransactionType = false;
    private static String[] entryNumberFields = new String[]{"receiptQty", "imputedCost", "drewQty", "receiveAmount", "drewBaseQty", "orderPrice", "taxPrice", "actualPrice", "totalMoveQty", "purInvoiceAmount", "saleInvoiceAmount", "totalAccountPayable", "totalAccountReceivable", "localPrice", "localTax", "localAmount", "qualifiedQty", "unqualifiedQty", "concessiveRecBaseQty", "baseQty", "taxRate", "totalinwarehsqty", "faCardQty", "qty", "assistQty", "reverseQty", "returnsQty", "unitStandardCost", "standardCost", "unitActualCost", "actualCost", "reverseBaseQty", "returnBaseQty", "assCoefficient", "associateQty", "price", "amount", "concessiverecqty"};
    private static String[] headNumberFields = new String[]{"totalQty", "totalAmount", "totalStandardCost", "totalActualCost", "totalLocalAmount"};
    private static String[] headBooleanFields = new String[]{"isReversed", "fiVouchered", "isInitBill"};
    private static String[] entryBooleanFields = new String[]{"isPresent"};
    protected static HashMap paramMap = new HashMap();

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, StorageOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        OrgUnitCollection orgCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(sou.getId().toString(), 4, 1);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
        if (ret != null && ret.getBaseCurrency() != null && ret.getBaseCurrency().getName() == null) {
            try {
                ret.setBaseCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(ret.getBaseCurrency().getId())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static void saveBOTRelation(Context ctx, Map idMap) throws BOSException {
        if (idMap == null || idMap.isEmpty()) {
            return;
        }
        BOTRelationInfo relateInfo = null;
        String srcBillId = null;
        String destBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        for (Map.Entry entry : idMap.entrySet()) {
            srcBillId = (String)entry.getKey();
            destBillId = (String)entry.getValue();
            relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
    }

    public boolean isNeedSourceBillForIndustry() {
        return true;
    }

    public boolean isRITypeForIndustry(Context ctx, IObjectValue model) {
        return false;
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.setNULLToZERO((IObjectValue)model);
        this.setEmptyToNullForLot((IObjectValue)model);
        super.update(ctx, pk, model);
        InvBillBaseInfo info = (InvBillBaseInfo)model;
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk1 = imeataLoader.getEntityObjectPK(info.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk1);
        String tableName = entityObjectInfo.getTable().getName();
        String entryTableName = CalculateUtil.getEntryTableNameFormBillTableName((String)tableName);
        if (!StringUtil.isEmpty((String)tableName) && !StringUtil.isEmpty((String)entryTableName)) {
            this.updateFullReverseBillCost(ctx, tableName, entryTableName, info.getId().toString());
            ArrayList<String> list = new ArrayList<String>();
            if (info instanceof SaleIssueBillInfo || info instanceof PurInWarehsBillInfo) {
                String sourceTableBill = InvCommonUtils.getBillTableNameFromBillType(info.getBillType());
                String sourceTableEntry = InvCommonUtils.getBillEntryTableNameFromBillType(info.getBillType());
                list.add(WriteOffHelp.updateWriteOffRecordPriceSQL((String)sourceTableBill, (String)sourceTableEntry, (BOSUuid)info.getId()));
                list.add(WriteOffHelp.updateWriteOffRecordReverceBillPriceSQL((String)sourceTableBill, (String)sourceTableEntry, (BOSUuid)info.getId()));
                list.add(WriteOffHelp.updateWriteOffRecordMantissaSQL((String)sourceTableBill, (String)sourceTableEntry, (BOSUuid)info.getId()));
                list.add(WriteOffHelp.updateWriteOffRecordMantissaNextSQL((String)sourceTableBill, (String)sourceTableEntry, (BOSUuid)info.getId()));
            }
            String[] str = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                str[i] = (String)list.get(i);
            }
            DBUtil.execute((Context)ctx, (String[])str);
            if (model instanceof MaterialReqBillInfo) {
                int amountScale = 2;
                int size = ((MaterialReqBillInfo)model).getEntry().size();
                for (int i = 0; i < size; ++i) {
                    BigDecimal actualCost = ((MaterialReqBillInfo)model).getEntry().get(0).getActualCost();
                    if (actualCost == null || actualCost.compareTo(BigDecimal.ZERO) == 0) continue;
                    amountScale = actualCost.scale();
                    break;
                }
                StringBuffer sql = new StringBuffer();
                sql.append(" update T_IM_MaterialReqBillEntry set FSCWrittenOffAmount = round(to_decimal(FSubWrittenOffQty * FunitActualCost,17,4),");
                sql.append(amountScale).append(") ,");
                sql.append(" FSCUnWrittenOffAmount = FActualCost - round(to_decimal(FSubWrittenOffQty * FunitActualCost,17,4),");
                sql.append(amountScale).append(") ");
                sql.append(" where fparentid = '" + model.getId().toString() + "'  ");
                DBUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFullReverseBillCost(Context ctx, String tableName, String entryTableName, String billID) throws BOSException {
        if ("T_IM_PurInWarehsBill".equalsIgnoreCase(tableName)) {
            this.updateFullReverseBillCostForPurInWarehs(ctx, tableName, entryTableName, billID);
            return;
        }
        boolean flag = false;
        if ("T_IM_PurInWarehsBill".equalsIgnoreCase(tableName) || "T_IM_SaleIssueBill".equalsIgnoreCase(tableName)) {
            flag = true;
        }
        boolean isMaterialReqBill = false;
        if ("T_IM_MaterialReqBill".equalsIgnoreCase(tableName)) {
            isMaterialReqBill = true;
        }
        StringBuffer querySourceBillSql = new StringBuffer();
        querySourceBillSql.append("select entry.factualCost as actualCost");
        querySourceBillSql.append(" ,entry.funitActualCost as unitActualCost");
        querySourceBillSql.append(" ,entry.fQty as qty");
        querySourceBillSql.append(" ,entry.freverseQty as reverseQty");
        querySourceBillSql.append(" ,entry.fid as entryID");
        querySourceBillSql.append(" from ").append(tableName).append(" as bill");
        querySourceBillSql.append(" inner join ").append(entryTableName).append(" as entry");
        querySourceBillSql.append(" on bill.fid = entry.fparentid");
        querySourceBillSql.append(" where bill.ffiVouchered = 0 and bill.fbaseStatus=4 and bill.fid = ?");
        StringBuffer queryReverseBillSql = new StringBuffer();
        queryReverseBillSql.append("select entry.fid as entryID");
        queryReverseBillSql.append(" ,entry.fqty as qty");
        if (flag) {
            queryReverseBillSql.append(" ,ENTRY.FWrittenOffBaseQty as writtenOffBaseQty");
        }
        if (isMaterialReqBill) {
            queryReverseBillSql.append(" ,ENTRY.FSubWrittenOffBaseQty as writtenOffBaseQty");
        }
        queryReverseBillSql.append(" ,BASECURRENCY.FPrecision as fprecision");
        queryReverseBillSql.append(" from ").append(tableName).append(" as bill");
        queryReverseBillSql.append(" inner join ").append(entryTableName).append(" as entry");
        queryReverseBillSql.append(" on bill.fid = entry.fparentid");
        queryReverseBillSql.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT");
        queryReverseBillSql.append(" ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        queryReverseBillSql.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY");
        queryReverseBillSql.append(" ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        queryReverseBillSql.append(" where bill.FIsReversed = 1 and bill.ffiVouchered = 0");
        queryReverseBillSql.append(" and bill.fbaseStatus=4 and entry.fsourceBillEntryId = ?");
        StringBuffer updateReverseBillSql = new StringBuffer();
        updateReverseBillSql.append("update ").append(entryTableName);
        updateReverseBillSql.append(" set FUnitActualCost=?,FActualCost=?");
        if (flag) {
            updateReverseBillSql.append(",FWrittenOffAmount=?,FUnWriteOffAmount=?");
        }
        if (isMaterialReqBill) {
            updateReverseBillSql.append(",FSCWrittenOffAmount=?,FSCUnWrittenOffAmount=?");
        }
        updateReverseBillSql.append(" where fid=?");
        Connection conn = null;
        PreparedStatement querySourceBillStatement = null;
        PreparedStatement queryReverseBillStatement = null;
        PreparedStatement updateReverseBillStatement = null;
        ResultSet querySourceBillResultSet = null;
        ResultSet queryReverseBillResultSet = null;
        try {
            conn = this.getConnection(ctx);
            querySourceBillStatement = conn.prepareStatement(querySourceBillSql.toString());
            queryReverseBillStatement = conn.prepareStatement(queryReverseBillSql.toString(), 1004, 1007);
            updateReverseBillStatement = conn.prepareStatement(updateReverseBillSql.toString());
            querySourceBillStatement.setString(1, billID);
            querySourceBillResultSet = querySourceBillStatement.executeQuery();
            while (querySourceBillResultSet.next()) {
                String entryID = querySourceBillResultSet.getString("entryID");
                BigDecimal actualCost = querySourceBillResultSet.getBigDecimal("actualCost");
                BigDecimal unitActualCost = querySourceBillResultSet.getBigDecimal("unitActualCost");
                BigDecimal cost = SysConstant.BIGZERO;
                queryReverseBillStatement.setString(1, entryID);
                queryReverseBillResultSet = queryReverseBillStatement.executeQuery();
                int i = 0;
                boolean isNegate = false;
                while (queryReverseBillResultSet.next()) {
                    int precision = queryReverseBillResultSet.getInt("fprecision");
                    BigDecimal reverseCost = unitActualCost.multiply(queryReverseBillResultSet.getBigDecimal("qty")).setScale(precision, 4);
                    isNegate = SysConstant.BIGZERO.compareTo(reverseCost) > 0;
                    if (querySourceBillResultSet.getBigDecimal("qty").compareTo(querySourceBillResultSet.getBigDecimal("reverseQty")) == 0 && queryReverseBillResultSet.isLast() && ++i > 1) {
                        reverseCost = isNegate ? actualCost.abs().subtract(cost).negate() : actualCost.abs().subtract(cost);
                    } else if (querySourceBillResultSet.getBigDecimal("qty").compareTo(querySourceBillResultSet.getBigDecimal("reverseQty")) == 0 && queryReverseBillResultSet.isLast() && i == 1) {
                        reverseCost = actualCost.negate();
                    }
                    cost = cost.add(reverseCost.abs());
                    int y = 1;
                    updateReverseBillStatement.setBigDecimal(y, unitActualCost);
                    updateReverseBillStatement.setBigDecimal(++y, reverseCost);
                    ++y;
                    if (flag || isMaterialReqBill) {
                        BigDecimal writtenOffBaseQty = queryReverseBillResultSet.getBigDecimal("writtenOffBaseQty");
                        updateReverseBillStatement.setBigDecimal(y, SysConstant.BIGZERO.compareTo(writtenOffBaseQty) == 0 ? SysConstant.BIGZERO : reverseCost);
                        updateReverseBillStatement.setBigDecimal(++y, SysConstant.BIGZERO.compareTo(writtenOffBaseQty) == 0 ? reverseCost : SysConstant.BIGZERO);
                        ++y;
                    }
                    updateReverseBillStatement.setString(y, queryReverseBillResultSet.getString("entryID"));
                    updateReverseBillStatement.execute();
                }
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{querySourceBillStatement, queryReverseBillStatement, updateReverseBillStatement}, (ResultSet[])new ResultSet[]{querySourceBillResultSet, queryReverseBillResultSet});
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{querySourceBillStatement, queryReverseBillStatement, updateReverseBillStatement}, (ResultSet[])new ResultSet[]{querySourceBillResultSet, queryReverseBillResultSet});
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit(ctx, pk);
        InvBillBaseInfo model = this.getInvBillBaseInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)model);
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        return batchResults;
    }

    protected void _checkDestIncVisualBills(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        String returnValue;
        String billId = aInvBillBaseInfo.getId().toString();
        String purInWarehsBosType = new PurInWarehsBillInfo().getBOSType().toString();
        String saleIssueBosType = new SaleIssueBillInfo().getBOSType().toString();
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        ArrayList listDestIDs = iBOTRelation.getDestObjIdByDestType(billId, null);
        Vector<String> vecNoVirtualBill = new Vector<String>(0);
        Vector<String> vecPurInwareBill = new Vector<String>(0);
        Vector<String> vecSaleIssueBill = new Vector<String>(0);
        BOSObjectType destBosType = null;
        for (int i = 0; i < listDestIDs.size(); ++i) {
            String destID = (String)listDestIDs.get(i);
            destBosType = BOSUuid.read((String)destID).getType();
            if (purInWarehsBosType.equals(destBosType.toString())) {
                vecPurInwareBill.add(destID);
                continue;
            }
            if (saleIssueBosType.equals(destBosType.toString())) {
                vecSaleIssueBill.add(destID);
                continue;
            }
            vecNoVirtualBill.add(destID);
        }
        if (vecNoVirtualBill.size() > 0) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
        Vector vecPurVisualBill = new Vector(0);
        Vector vecSaleVisualBill = new Vector(0);
        if (vecPurInwareBill.size() > 0) {
            vecPurVisualBill = this.getAndCheckVisualBill(ctx, "pur", vecNoVirtualBill, vecPurInwareBill);
        }
        aInvBillBaseInfo.put("purInWarehsVirtualBill", vecPurVisualBill);
        if (vecPurVisualBill.size() > 0 && null != (returnValue = this.checkIsCLoseVBill(ctx, "pur", vecPurVisualBill))) {
            if ("purDownBillChecked".endsWith(returnValue)) {
                throw new InvException(InvException.PURDOWNBILLCHECKED);
            }
            if ("purDownBillClosed".endsWith(returnValue)) {
                throw new InvException(InvException.PURDOWNBILLCLOSED);
            }
            if ("purDownBillWriteoff".endsWith(returnValue)) {
                throw new InvException(InvException.PURDOWNBILLWRITEOFF);
            }
        }
        if (vecSaleIssueBill.size() > 0) {
            vecSaleVisualBill = this.getAndCheckVisualBill(ctx, "sale", vecNoVirtualBill, vecSaleIssueBill);
        }
        if (vecSaleVisualBill.size() > 0 && null != (returnValue = this.checkIsCLoseVBill(ctx, "sale", vecSaleVisualBill)) && null != returnValue) {
            if ("saleDownBillChecked".endsWith(returnValue)) {
                throw new InvException(InvException.SALEDOWNBILLCHECKED);
            }
            if ("saleDownBillClosed".endsWith(returnValue)) {
                throw new InvException(InvException.SALEDOWNBILLCLOSED);
            }
            if ("saleDownBillWriteoff".endsWith(returnValue)) {
                throw new InvException(InvException.SALEDOWNBILLWRITEOFF);
            }
        }
        aInvBillBaseInfo.put("purSaleIssueVirtualBill", vecSaleVisualBill);
        if (vecNoVirtualBill.size() > 0) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
    }

    protected void _checkIsHaveDestBills(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = aInvBillBaseInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkIsCLoseVBill(Context ctx, String purOrSale, Vector virtrualBills) throws EASBizException, BOSException {
        String returnValue = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select A.FbizDate as FbizDate,A.FSTORAGEORGUNITID as FSTORAGEORGUNITID , B.FCOMPANYORGUNITID ,B.FISPRESENT as FIspresent,isnull(B.FWrittenOffQty,0)  as FWrittenOffQty From ");
        if (purOrSale.equals("pur")) {
            sql.append("T_IM_PurInWarehsBill A inner join T_IM_PurInWarehsEntry B on A.FID = B.FParentID ");
        } else if (purOrSale.equals("sale")) {
            sql.append("T_IM_SaleIssueBill A inner join T_IM_SaleIssueEntry B on A.FID = B.FParentID ");
        }
        sql.append("where A.Fid ");
        sql.append(SCMServerUtils.getInID((Vector)virtrualBills));
        sql.append(" and b.FISPRESENT =0 ");
        try {
            PeriodInfo currentPeriodInfo;
            PeriodInfo vBillPeriod;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo cou = null;
            java.sql.Date bizDate = null;
            String sou = null;
            boolean isPresent = false;
            BigDecimal writternOffQTY = SysConstant.BIGZERO;
            HashMap<String, CompanyOrgUnitInfo> couMap = new HashMap<String, CompanyOrgUnitInfo>();
            HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
            HashMap<String, Boolean> sysConMap = new HashMap<String, Boolean>();
            HashMap<String, PeriodInfo> peroidMap = new HashMap<String, PeriodInfo>();
            do {
                if (!rs.next()) return returnValue;
                bizDate = rs.getDate("FbizDate");
                sou = rs.getString("FSTORAGEORGUNITID");
                writternOffQTY = rs.getBigDecimal("FWrittenOffQty");
                isPresent = rs.getBoolean("FIspresent");
                if (couMap.containsKey(sou)) {
                    cou = (CompanyOrgUnitInfo)couMap.get(sou);
                } else {
                    cou = iSCMBillCommonFacade.getCompanyInfo(BOSUuid.read((String)sou));
                    couMap.put(sou, cou);
                }
                boolean isPresentToInvoice = false;
                if (purOrSale.equals("sale")) {
                    if (paramMap.containsKey(cou.getId().toString())) {
                        isPresentToInvoice = (Boolean)paramMap.get(cou.getId().toString());
                    } else {
                        isPresentToInvoice = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(cou.getId().toString()), "AR_032"));
                        paramMap.put(cou.getId().toString(), isPresentToInvoice);
                    }
                }
                if (purOrSale.equals("pur") && writternOffQTY.compareTo(SysConstant.BIGZERO) > 0 && !isPresent) {
                    return "purDownBillWriteoff";
                }
                if (purOrSale.equals("sale") && writternOffQTY.compareTo(SysConstant.BIGZERO) > 0 && isPresentToInvoice) {
                    return "saleDownBillWriteoff";
                }
                PeriodInfo billPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)cou, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
                PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
                if (billPeriod.getPeriodYear() == curPeriod.getPeriodYear() && billPeriod.getPeriodNumber() == curPeriod.getPeriodNumber()) {
                    boolean isClose = false;
                    if (sysConMap.containsKey(cou.getId().toString())) {
                        isClose = (Boolean)sysConMap.get(cou.getId().toString());
                    } else {
                        isClose = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
                        sysConMap.put(cou.getId().toString(), isClose);
                    }
                    if (isClose) {
                        if (!purOrSale.equals("pur")) return "saleDownBillClosed";
                        return "purDownBillClosed";
                    }
                }
                vBillPeriod = null;
                currentPeriodInfo = null;
                if (peroidMap.containsKey(cou.getId()) && peroidMap.containsKey(bizDate.toString() + cou.getId())) {
                    vBillPeriod = (PeriodInfo)peroidMap.get(bizDate.toString() + cou.getId());
                    currentPeriodInfo = (PeriodInfo)peroidMap.get(cou.getId());
                    continue;
                }
                vBillPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)cou, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
                currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
                peroidMap.put(bizDate.toString() + cou.getId(), vBillPeriod);
                peroidMap.put((String)cou.getId(), vBillPeriod);
            } while (PeriodUtils.PeriodCompare((PeriodInfo)vBillPeriod, (PeriodInfo)currentPeriodInfo));
            if (!purOrSale.equals("pur")) return "saleDownBillChecked";
            return "purDownBillChecked";
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean _checkIsVouchered(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
        String voucherEnum = aInvBillBaseInfo.getString("voucherEnum");
        if (isOk) {
            if (voucherEnum == null && (aInvBillBaseInfo.isFiVouchered() || aInvBillBaseInfo.isPcVouchered()) || "FIVoucher".equals(voucherEnum) && aInvBillBaseInfo.isFiVouchered() || "PCVoucher".equals(voucherEnum) && aInvBillBaseInfo.isPcVouchered()) {
                throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDOK, new Object[]{aInvBillBaseInfo.getNumber(), ""});
            }
        } else if (!(voucherEnum == null && (aInvBillBaseInfo.isFiVouchered() || aInvBillBaseInfo.isPcVouchered()) || "FIVoucher".equals(voucherEnum) && aInvBillBaseInfo.isFiVouchered() || "PCVoucher".equals(voucherEnum) && aInvBillBaseInfo.isPcVouchered())) {
            throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDNOTOK, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
        return true;
    }

    protected boolean _checkUnAuditInParam(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
        if (aInvBillBaseInfo.getBillType() != null) {
            String billTypeId = aInvBillBaseInfo.getBillType().getId().toString();
            String orgUnitID = aInvBillBaseInfo.getStorageOrgUnit().getId().toString();
            boolean isCanUnAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
            if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && "1".equalsIgnoreCase(strCanUnAudit.trim())) {
                isCanUnAudit = true;
            }
            if (!isCanUnAudit) {
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
            }
        }
        return true;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvServerUtils.deleteSerialNumber(ctx, pk);
        super._delete(ctx, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _deleteable(Context ctx, String billId) throws BOSException, EASBizException {
        if (billId == null || billId.trim().length() < 1) {
            return false;
        }
        ObjectUuidPK pk = new ObjectUuidPK(billId.trim());
        try {
            SCMBillBaseInfo aSCMBillBaseInfo = this.getSCMBillBaseInfo(ctx, (IObjectPK)pk);
            this._checkClosed(ctx, (IObjectValue)aSCMBillBaseInfo, true);
            this._checkAudit(ctx, (IObjectValue)aSCMBillBaseInfo, true);
            this._checkOtherWhenDel(ctx, (IObjectValue)aSCMBillBaseInfo);
            if (this.isVoucherFlag(ctx, (IObjectPK)pk)) {
                throw new BillBaseException(BillBaseException.FIVOUCHERED2);
            }
            this.isCanDelete(ctx, (IObjectPK)pk, (CoreBillBaseInfo)aSCMBillBaseInfo);
            Connection cn = null;
            try {
                cn = this.getConnection(ctx);
                this._isReferenced(ctx, (IObjectPK)pk, cn);
                this._canDelete(ctx, (IObjectPK)pk, cn);
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected void _deleteNoCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._deleteNoCheck(ctx, pk);
    }

    @Override
    protected HashMap _executeUniteBill(Context ctx, String id, String billTypeId) throws BOSException, EASBizException {
        UniteBillFactory instance = new UniteBillFactory();
        IUniteBill iUniteBill = instance.create(billTypeId);
        HashMap msgHm = iUniteBill.executeUniteBill(ctx, id);
        return msgHm;
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectValue mode) throws BOSException, EASBizException {
        block21: {
            InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)mode;
            Uuid mutexUuid = null;
            try {
                IOrgUnitRelation iUnitRel;
                OrgUnitCollection orgCol;
                CompanyOrgUnitInfo cou;
                if (aInvBillBaseInfo != null && aInvBillBaseInfo.getId() != null) {
                    String id = aInvBillBaseInfo.getId().toString();
                    mutexUuid = Uuid.create();
                    MutexParameter tempMutext = SCMUtils.setMutexParameter((Uuid)mutexUuid, (String)id, (MutexLockType)MutexLockType.EXCLUSIVE_LOCK);
                    IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                    boolean tag = mutexService.requestMutex(tempMutext);
                    if (!tag) {
                        throw new SCMBillException(SCMBillException.GENERATEVOUCHER_CONFLICT);
                    }
                }
                CoreBillBaseCollection collection = new CoreBillBaseCollection();
                collection.add((CoreBillBaseInfo)aInvBillBaseInfo);
                ObjectUuidPK botMappingPk = null;
                if (aInvBillBaseInfo.getStorageOrgUnit() == null || (cou = (CompanyOrgUnitInfo)(orgCol = (iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(aInvBillBaseInfo.getStorageOrgUnit().getId().toString(), 4, 1)).get(0)) == null) break block21;
                CtrlUnitInfo cu = cou.getCU();
                if (cu != null) {
                    IBOTMapping iBotMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
                    HashMap<String, CtrlUnitInfo> curCtx = new HashMap<String, CtrlUnitInfo>();
                    curCtx.put("TRANSMITCU", cu);
                    String voucherBosType = new VoucherInfo().getBOSType().toString();
                    BOTMappingCollection bc = iBotMapping.getMappingCollectionForSelect(collection, voucherBosType, DefineSysEnum.DAP, curCtx);
                    if (null == bc || bc.size() == 0) {
                        throw new InvBizException(InvBizException.GEN_VOUCHER_NO_BOTP);
                    }
                    botMappingPk = new ObjectUuidPK(bc.get(0).getId());
                }
                boolean b = WfEventListenerStateManager.getInstance().isEnable();
                try {
                    if (!b) {
                        WfEventListenerStateManager.getInstance().enableEventListener();
                    }
                    IDAPTransformer dapTrans = DAPTransformerFactory.getLocalInstance((Context)ctx);
                    dapTrans.generateVoucher(collection, DAPVoucherTypeEnum.FIVoucher, botMappingPk);
                }
                catch (EASBizException e) {
                    throw e;
                }
                finally {
                    if (!b) {
                        WfEventListenerStateManager.getInstance().disableEventListener();
                    }
                }
            }
            catch (EASBizException e) {
                throw e;
            }
            finally {
                try {
                    if (mutexUuid != null) {
                        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                        mutexService.releaseMutex(mutexUuid);
                    }
                }
                catch (Exception ex) {
                    throw new BOSException((Throwable)ex);
                }
            }
        }
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        this.checkTransactionIsCheckAccount(ctx, sourceBillCollection);
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    private void checkTransactionIsCheckAccount(Context ctx, IObjectCollection sourceBillCollection) throws BOSException, EASBizException {
        InvBillBaseInfo billInfo = null;
        String tableName = null;
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            billInfo = (InvBillBaseInfo)sourceBillCollection.getObject(i);
            if (i == 0) {
                IObjectValue info;
                ids.append("'" + billInfo.getId().toString() + "'");
                tableName = BillTypeUtils.getBillHeadTableName((Context)ctx, (String)billInfo.getBOSType().toString());
                if (tableName == null && (info = this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId().toString()))) != null && info.get("billType") != null) {
                    tableName = BillTypeUtils.getBillHeadTableName((Context)ctx, (String)((BillTypeInfo)info.get("billType")).getId().toString());
                }
                if (tableName != null) continue;
                return;
            }
            ids.append(",'" + billInfo.getId().toString() + "'");
        }
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("select bill.fnumber as billNum,tranc.fname_l2 as tranName\r\n");
        sqlBuff.append("from " + tableName + " bill \r\n");
        sqlBuff.append("left outer join t_scm_transactiontype tranc on bill.ftransactiontypeid=tranc.fid\r\n");
        sqlBuff.append("where bill.fid in (" + ids + ") and tranc.fismanucheckaccount = 0");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        try {
            StringBuffer errorMsg = new StringBuffer();
            String billNumb = null;
            String tranName = null;
            while (rs.next()) {
                billNumb = rs.getString("billNum");
                tranName = rs.getString("tranName");
                errorMsg.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"InvBillBaseControllerBean_info", (String[])new String[]{billNumb, tranName}, (Context)ctx));
            }
            if (errorMsg.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("100001", errorMsg.toString()));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._getBizUnitOrgID(ctx, model);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectCollection iObjectCollection;
        ObjectUuidPK pk2 = new ObjectUuidPK(BOSUuid.read((String)pk.toString()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entry.id"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.id"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.number"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.name"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.CU"));
        InvBillBaseInfo objVal = (InvBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk2.getObjectType(), pk, selector);
        if (objVal != null && (iObjectCollection = (IObjectCollection)objVal.get("entry")) != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            return aInvBillBaseEntryInfo.getCompanyOrgUnit();
        }
        return null;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
        IObjectCollection iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entry");
        if (iObjectCollection == null || iObjectCollection.size() == 0) {
            iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entries");
        }
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    @Override
    protected void _nullAuditForLOG(Context ctx, IObjectPK pk) throws BOSException {
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        Boolean hasWriteLog;
        if (pk == null && model == null) {
            return;
        }
        boolean writeLog = false;
        if (model == null) {
            model = this.getSCMBillBaseInfo(ctx, pk, this.getSelector());
        }
        if (model.get("hasWriteLog") != null && !(hasWriteLog = (Boolean)model.get("hasWriteLog")).booleanValue()) {
            writeLog = true;
        }
        String instanceDetail = "";
        instanceDetail = ((InvBillBaseInfo)model).getNumber();
        IObjectPK logPK = null;
        if (writeLog) {
            logPK = LogUtil.beginLog((Context)ctx, (String)"nullAuditForLOG", (BOSObjectType)this.getBOSType(), (IObjectPK)pk, (String)instanceDetail, (String)"im_manufactRec_audit");
        }
        if (pk == null && model != null) {
            pk = new ObjectUuidPK(((InvBillBaseInfo)model).getId());
        }
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        this.checkForOffSet(ctx, invBillBaseInfo);
        if (invBillBaseInfo != null && invBillBaseInfo.getBillType() != null && !"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(invBillBaseInfo.getBillType().getId().toString())) {
            BillTypeInfo sourceBillType;
            Boolean value;
            HashMap map = SCMParamFacadeFactory.getLocalInstance((Context)ctx).getScmSpecialParams(new String[]{"isRefreshing", "isStartLog"});
            if (map.containsKey("isRefreshing") && (value = (Boolean)map.get("isRefreshing")).booleanValue()) {
                throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
            }
            TransactionTypeInfo transType = invBillBaseInfo.getTransactionType();
            String billTypeID = invBillBaseInfo.getBillType().getId().toString();
            if (!(transType != null || "XlazxwEREADgAAAEwKgSxUY+1VI=".equals(billTypeID) || "50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e001-1152c0a812fd463ED552".equals(billTypeID) || "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID))) {
                throw new InvBizException(InvBizException.TRANSACTIONTYPE_CANNOTNULL);
            }
            Map coreBillType = new HashMap();
            coreBillType = this.getCoreBillType(ctx, invBillBaseInfo);
            if (invBillBaseInfo.getBillType() == null || invBillBaseInfo.getBillType().getId() == null) {
                throw new SCMBillException(SCMBillException.BILLTYPE_ISNULL);
            }
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillType = BillTypeUtils.getBillEntryTableName((Context)ctx, coreBillType);
            }
            String billTable = BillTypeUtils.getBillHeadTableName((Context)ctx, (String)invBillBaseInfo.getBillType().getId().toString());
            ArrayList<String> sqlUpdate = new ArrayList<String>();
            if (billTable != null && billTable.length() > 0) {
                sqlUpdate.add(" UPDATE " + billTable + " SET FID = FID  WHERE FID = '" + pk.toString() + "'");
            }
            IObjectCollection entrys = this.getEntryCollection(invBillBaseInfo);
            String tmp = null;
            StringBuffer srcBillSql = new StringBuffer();
            StringBuffer coreBillSql = new StringBuffer();
            for (int i = 0; i < entrys.size(); ++i) {
                if (((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId() == null) continue;
                tmp = ((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId().toString();
                srcBillSql.append("'").append(tmp).append("',");
                tmp = null;
            }
            if (srcBillSql.length() > 0) {
                srcBillSql.setLength(srcBillSql.length() - 1);
            }
            if ((sourceBillType = ((InvBillBaseEntryInfo)entrys.getObject(0)).getSourceBillType()) != null && sourceBillType.getId() != null && srcBillSql.length() > 0 && (tmp = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)sourceBillType.getId().toString())) != null && tmp.trim().length() > 0 && srcBillSql.length() > 0) {
                sqlUpdate.add(" UPDATE " + tmp + " SET FID = FID WHERE FID IN (" + srcBillSql.toString() + ")");
            }
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillSql.append(this.getCoreBillEntryId(ctx, invBillBaseInfo));
                Set set = coreBillType.keySet();
                Iterator ite = set.iterator();
                while (ite.hasNext()) {
                    String next = ite.next().toString();
                    if (!coreBillType.containsKey(next) || coreBillType.get(next) == null || coreBillSql.length() <= 0) continue;
                    sqlUpdate.add(" UPDATE " + coreBillType.get(next) + " SET FID = FID WHERE FID IN (" + coreBillSql.toString() + ")");
                }
            }
            if (sqlUpdate.size() > 0) {
                String[] updSql = new String[sqlUpdate.size()];
                for (int i = 0; i < sqlUpdate.size(); ++i) {
                    updSql[i] = (String)sqlUpdate.get(i);
                }
                com.kingdee.eas.dynbusiness.util.DBUtil.executeBatch((Context)ctx, (String[])updSql);
            }
        }
        invBillBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        InvBillBaseInfo checkInfo = (InvBillBaseInfo)this.getDataNewStatus(ctx, (IObjectValue)invBillBaseInfo);
        this._checkAudit(ctx, (IObjectValue)checkInfo, true);
        this._checkSubmit(ctx, (IObjectValue)checkInfo, false);
        this.isSamePerson4Audit(ctx, invBillBaseInfo);
        if ((ctx.get((Object)CTX_TEMP_CHECKED_BIZDATE) == null || !((Boolean)ctx.get((Object)CTX_TEMP_CHECKED_BIZDATE)).booleanValue()) && this.isCheckBizDate()) {
            if (!invBillBaseInfo.isIsInitBill()) {
                this._checkBizDate(ctx, model);
            } else {
                this._checkInitBizDate(ctx, model);
            }
        }
        this.checkMaterialCost(ctx, invBillBaseInfo);
        if (!this.isUseBusinessChain()) {
            this.checkMaterialInventory(ctx, invBillBaseInfo);
        }
        this.updateAuditStatus(ctx, model);
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance(ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
        this.afterPassAudit(ctx, pk, invBillBaseInfo);
        this.batchExecute(ctx, new Object[]{pk}, BatchActionEnum.AUDIT);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        ctx.remove((Object)CTX_TEMP_CHECKED_BIZDATE);
        ctx.remove((Object)CTX_TEMP_BILL_TRANSACTIONTYPE);
    }

    protected String getCoreBillEntryId(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        return null;
    }

    protected Map getCoreBillType(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        return null;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setNULLToZERO(model);
        this.updateEntryFields(ctx, model);
        this.setEmptyToNullForLot(model);
        InvBillBaseInfo info = (InvBillBaseInfo)model;
        boolean isAddNew = info.getId() == null;
        Calendar cal = Calendar.getInstance();
        if (info.getBizDate() != null) {
            cal.setTime(info.getBizDate());
            info.setYear(cal.get(1));
            info.setMonth(cal.get(1) * 100 + (cal.get(2) + 1));
            info.setDay(cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5));
        }
        IObjectCollection entrys = this.getEntryCollection(info);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        for (int i = 0; i < entrys.size(); ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entrys.getObject(i);
            if (entryInfo.getMfg() == null || entryInfo.getExp() == null) continue;
            try {
                entryInfo.setMfg(sdf.parse(sdf.format(entryInfo.getMfg())));
                entryInfo.setExp(sdf.parse(sdf.format(entryInfo.getExp())));
                continue;
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
        }
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        if (info.isIsReversed() && isAddNew) {
            String srcId = info.getSourceBillId();
            ObjectUuidPK srcPk = new ObjectUuidPK(srcId);
            String bosType = srcPk.getObjectType().toString();
            SCMServerUtils.traceUpAndDown((Context)ctx, (String)srcId, (String)pk.toString(), (String)bosType, (String)bosType);
        }
        SCMBillBaseCollection scmBillBaseCollection = new SCMBillBaseCollection();
        scmBillBaseCollection.add((SCMBillBaseInfo)info);
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        iMaterialSerialNumber.doSerialNumberCarry(scmBillBaseCollection);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateEntryFields(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.updateEntryFields(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected IObjectCollection getEntryCollection(InvBillBaseInfo aInvBillBaseInfo) {
        if (aInvBillBaseInfo == null) {
            return new InvBillBaseEntryCollection();
        }
        if (aInvBillBaseInfo.getBillType() != null && ("50957179-0105-1000-e002-2152c0a812fd463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString()) || "CJewLHpKKe/gU0ETqMDAp0Y+1VI=".equals(aInvBillBaseInfo.getBillType().getId().toString()))) {
            return (IObjectCollection)aInvBillBaseInfo.get("entries");
        }
        return (IObjectCollection)aInvBillBaseInfo.get("entry");
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Date bizDate;
        InvBillBaseEntryInfo entryInfo;
        boolean isAddNew;
        ctx.remove((Object)CTX_TEMP_BILL_TRANSACTIONTYPE);
        this.setNULLToZERO(model);
        this.setEmptyToNullForLot(model);
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
        IObjectCollection entrys = this.getEntryCollection(aInvBillBaseInfo);
        this.checkForOffSet(ctx, aInvBillBaseInfo);
        this.updateEntryFields(ctx, (IObjectValue)aInvBillBaseInfo);
        if (!this.isUseBusinessChain()) {
            String bosType;
            if (aInvBillBaseInfo.isIsInitBill()) {
                this._checkInitBizDate(ctx, (IObjectValue)aInvBillBaseInfo);
            } else if (this.isCheckBizDate()) {
                this._checkBizDate(ctx, (IObjectValue)aInvBillBaseInfo);
            }
            if (this.isCheckBaseData()) {
                Object[] msg = new String[2];
                msg[0] = "";
                if (aInvBillBaseInfo.getNumber() != null) {
                    msg[0] = aInvBillBaseInfo.getNumber();
                }
                for (int i = 0; i < entrys.size(); ++i) {
                    msg[1] = "" + (i + 1);
                    InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
                    if (aInvBillBaseInfo instanceof OtherIssueBillInfo || aInvBillBaseInfo instanceof OtherInWarehsBillInfo) {
                        if (entry != null && entry.getUnit() != null && entry.getBaseUnit() != null && aInvBillBaseInfo.getBizType() != null && !aInvBillBaseInfo.getBizType().getId().toString().equals("mxmcXEczQ52MGxLV1Oyh9SQHQ1w=") && !aInvBillBaseInfo.getBizType().getId().toString().equals("KVe1UEnNT260YmBCLwKZKSQHQ1w=")) {
                            if (entry.getUnit().getId().toString().equals(entry.getBaseUnit().getId().toString()) && entry.getQty().compareTo(entry.getBaseQty()) != 0) {
                                throw new InvBizException(InvBizException.BASEQTYNOTMATCH, msg);
                            }
                            if (entry.getQty() != null && SysConstant.BIGZERO.compareTo(entry.getQty()) != 0 && (entry.getBaseQty() == null || entry.getBaseQty().compareTo(SysConstant.BIGZERO) == 0)) {
                                throw new InvBizException(InvBizException.BASEQTYNULL, msg);
                            }
                        }
                    } else if (entry != null && entry.getUnit() != null && entry.getBaseUnit() != null) {
                        if (entry.getUnit().getId().toString().equals(entry.getBaseUnit().getId().toString()) && entry.getQty().compareTo(entry.getBaseQty()) != 0) {
                            throw new InvBizException(InvBizException.BASEQTYNOTMATCH, msg);
                        }
                        if (entry.getQty() != null && SysConstant.BIGZERO.compareTo(entry.getQty()) != 0 && (entry.getBaseQty() == null || entry.getBaseQty().compareTo(SysConstant.BIGZERO) == 0)) {
                            throw new InvBizException(InvBizException.BASEQTYNULL, msg);
                        }
                    }
                    if (aInvBillBaseInfo.getSourceBillType() == null || entry.getSourceBillType() != null) continue;
                    entry.setSourceBillType(aInvBillBaseInfo.getSourceBillType());
                }
            }
            if (this.isCheckEntrySourceBillInfo()) {
                this.checkEntrySourceBillForBOTP(ctx, aInvBillBaseInfo);
                boolean isSameCoreBillType = this.checkEntryCoreBillType(ctx, aInvBillBaseInfo);
                if (!isSameCoreBillType) {
                    throw new InvBizException(InvBizException.CANNOTSUBMIT_NOTSAMECOREBILL);
                }
            }
            if ((bosType = aInvBillBaseInfo.getBOSType().toString()).equals("A4D04D23") || bosType.equals("A4D04D24") || bosType.equals("8FA62986") || bosType.equals("28F88CF5") || bosType.equals("15F2BD83")) {
                boolean isBotp = false;
                if (aInvBillBaseInfo.getSourceBillType() != null) {
                    isBotp = true;
                }
                HashSet<String> storageIDs = new HashSet<String>();
                HashSet<String> materialIDs = new HashSet<String>();
                String[] companyIDs = new String[entrys.size()];
                String[] matIDS = new String[entrys.size()];
                if (aInvBillBaseInfo.getStorageOrgUnit() != null && aInvBillBaseInfo.getStorageOrgUnit().getId() != null) {
                    storageIDs.add(aInvBillBaseInfo.getStorageOrgUnit().getId().toString());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
                int size = entrys.size();
                for (int i = 0; i < size; ++i) {
                    InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
                    if (entry.getMfg() != null && entry.getExp() != null) {
                        try {
                            entry.setMfg(sdf.parse(sdf.format(entry.getMfg())));
                            entry.setExp(sdf.parse(sdf.format(entry.getExp())));
                        }
                        catch (ParseException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                    if (entry != null && entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                        materialIDs.add(entry.getMaterial().getId().toString());
                        matIDS[i] = entry.getMaterial().getId().toString();
                    }
                    if (entry != null && entry.getCompanyOrgUnit() != null && entry.getCompanyOrgUnit().getId() != null) {
                        companyIDs[i] = entry.getCompanyOrgUnit().getId().toString();
                    }
                    if (entry == null || entry.getMfg() == null || entry.getExp() == null) continue;
                    try {
                        entry.setMfg(sdf.parse(sdf.format(entry.getMfg())));
                        entry.setExp(sdf.parse(sdf.format(entry.getExp())));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                Map materialPlanMap = new HashMap();
                materialPlanMap = SCMServerUtils.getMaterialPlanCollec((Context)ctx, materialIDs, storageIDs);
                Map matCompanyInfo = new HashMap();
                if (bosType.equals("8FA62986")) {
                    matCompanyInfo = InvServerUtils.getMatCompanyInfoCollection(ctx, matIDS, companyIDs);
                }
                int size2 = entrys.size();
                for (int i = 0; i < size2; ++i) {
                    InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
                    if (aInvBillBaseInfo.getStorageOrgUnit() == null || aInvBillBaseInfo.getStorageOrgUnit().getId() == null || entry == null || entry.getMaterial() == null || entry.getMaterial().getId() == null) continue;
                    MaterialPlanInfo mpInfo = (MaterialPlanInfo)materialPlanMap.get(entry.getMaterial().getId().toString() + aInvBillBaseInfo.getStorageOrgUnit().getId().toString());
                    MaterialCompanyInfoInfo companyInfo = null;
                    if (bosType.equals("8FA62986") && entry != null && entry.getCompanyOrgUnit() != null && entry.getCompanyOrgUnit().getId() != null && entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                        companyInfo = (MaterialCompanyInfoInfo)matCompanyInfo.get(entry.getMaterial().getId().toString() + entry.getCompanyOrgUnit().getId().toString());
                    }
                    if (mpInfo == null) continue;
                    if (bosType.equals("A4D04D23") || bosType.equals("A4D04D24") || bosType.equals("8FA62986") || bosType.equals("28F88CF5")) {
                        if (bosType.equals("8FA62986") && companyInfo != null && companyInfo.getAccountType() != null && companyInfo.getAccountType().getValue() == 2 || bosType.equals("28F88CF5")) continue;
                        InvServerUtils.checkProjectTrackIsNotNull(ctx, isBotp, i + 1, mpInfo, entry.getProject(), entry.getTrackNumber());
                        continue;
                    }
                    SCMServerUtils.checkProjectTrackIsNotNull((Context)ctx, (boolean)isBotp, (int)(i + 1), (MaterialPlanInfo)mpInfo, (ProjectInfo)entry.getProject(), (TrackNumberInfo)entry.getTrackNumber());
                }
            }
        }
        boolean bl = isAddNew = aInvBillBaseInfo.getId() == null;
        if (this.isNeedSourceBillForIndustry() && aInvBillBaseInfo.isIsReversed()) {
            if (aInvBillBaseInfo.getSourceBillType() == null) {
                throw new InvBizException(InvBizException.INV_NOSRCBILL);
            }
            if (!(aInvBillBaseInfo instanceof PurInWarehsBillInfo)) {
                this.synchronizationBillPrice(ctx, isAddNew, aInvBillBaseInfo);
            }
        }
        if (!this.isUseBusinessChain()) {
            String msg;
            if (aInvBillBaseInfo.getStorageOrgUnit() != null) {
                String strStorageID = aInvBillBaseInfo.getStorageOrgUnit().getId().toString();
                this.checkMaterialHasCompanyProperty(ctx, entrys, strStorageID);
            }
            boolean isManuAdjustBill = false;
            TransactionTypeInfo transactionTypeInfo = aInvBillBaseInfo.getTransactionType();
            if (transactionTypeInfo == null && aInvBillBaseInfo.getBillType() != null && "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString())) {
                isManuAdjustBill = CostAdjuestCreateTypeEnum.USERINPUT.equals(aInvBillBaseInfo.get("createType"));
            }
            if ((transactionTypeInfo != null || isManuAdjustBill) && (msg = this.checkIsStarted(ctx, transactionTypeInfo, entrys, aInvBillBaseInfo, isManuAdjustBill)) != null && msg.length() > 0) {
                if (transactionTypeInfo != null && "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(transactionTypeInfo.getBillType().getId().toString())) {
                    throw new InvBizException(InvBizException.ISSTARTED, new String[]{msg});
                }
                throw new InvBizException(InvBizException.ISNOTSTARTED, new String[]{msg});
            }
        }
        if (entrys != null) {
            this.setUnAssociationQtyByQty(entrys);
        }
        if (entrys != null && aInvBillBaseInfo.getStorageOrgUnit() != null && (entryInfo = (InvBillBaseEntryInfo)entrys.getObject(0)) != null && entryInfo.getCompanyOrgUnit() == null) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = InvBillBaseControllerBean.getCompanyInfo(ctx, aInvBillBaseInfo.getStorageOrgUnit());
            for (int i = 0; i < entrys.size(); ++i) {
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
                entry.setCompanyOrgUnit(aCompanyOrgUnitInfo);
            }
        }
        if ((bizDate = ((InvBillBaseInfo)model).getBizDate()) != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(bizDate);
            ((InvBillBaseInfo)model).setYear(cal.get(1));
            ((InvBillBaseInfo)model).setMonth(cal.get(1) * 100 + (cal.get(2) + 1));
            ((InvBillBaseInfo)model).setDay(cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5));
        }
        IObjectPK pk = super._submit(ctx, model);
        aInvBillBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        if (aInvBillBaseInfo.isIsReversed() && isAddNew) {
            String srcId = aInvBillBaseInfo.getSourceBillId();
            ObjectUuidPK srcPk = new ObjectUuidPK(srcId);
            String bosType = srcPk.getObjectType().toString();
            SCMServerUtils.traceUpAndDown((Context)ctx, (String)srcId, (String)pk.toString(), (String)bosType, (String)bosType);
        }
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        iMaterialSerialNumber.checkSerialNumberIsNull(aInvBillBaseInfo);
        aInvBillBaseInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        iMaterialSerialNumber.updateMaterialSN(aInvBillBaseInfo);
        this.autoAuditBill(ctx, aInvBillBaseInfo, pk);
        return pk;
    }

    private void autoAuditBill(Context ctx, InvBillBaseInfo aInvBillBaseInfo, IObjectPK pk) throws BOSException, EASBizException {
        if (aInvBillBaseInfo.getBillType() == null) {
            return;
        }
        String billTypeId = aInvBillBaseInfo.getBillType().getId().toString();
        if ("XlazxwEREADgAAAEwKgSxUY+1VI=".equals(billTypeId)) {
            return;
        }
        boolean isAutoAudit = false;
        String orgUnitID = aInvBillBaseInfo.getStorageOrgUnit().getId().toString();
        String strAutoAudit = SCMBillParamFactory.getLocalInstance((Context)ctx).getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeId);
        if (!StringUtil.isEmpty((String)strAutoAudit) && "1".equals(strAutoAudit.trim())) {
            isAutoAudit = true;
        }
        if (isAutoAudit) {
            if (!this.isUseBusinessChain() && this.getAuditPermissionItem() != null) {
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(aInvBillBaseInfo.getStorageOrgUnit().getId().toString()), this.getAuditPermissionItem());
            }
            this.passAudit(ctx, pk, (CoreBillBaseInfo)aInvBillBaseInfo);
            this.executeBizFlow(ctx, (IObjectValue)aInvBillBaseInfo, BatchActionEnum.AUDIT);
        }
    }

    protected String getAuditPermissionItem() {
        return null;
    }

    protected boolean isUseBusinessChain() {
        return false;
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._unAudit(ctx, pk);
        InvBillBaseInfo model = this.getInvBillBaseInfo(ctx, pk, this.getSelector());
        this.unpassAudit(ctx, pk, (CoreBillBaseInfo)model);
    }

    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getInvBillBaseSelector((boolean)true);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        InvBillBaseInfo aInvBillBaseInfo;
        if (pk == null && model == null) {
            return;
        }
        if (pk == null) {
            pk = new ObjectUuidPK(((InvBillBaseInfo)model).getId());
        }
        InvBillBaseInfo invBillBaseInfo = aInvBillBaseInfo = model == null ? null : (InvBillBaseInfo)model;
        if (model == null) {
            aInvBillBaseInfo = this.getInvBillBaseInfo(ctx, pk, this.getSelector());
        }
        if (aInvBillBaseInfo != null && aInvBillBaseInfo.getBillType() != null && !"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString())) {
            BillTypeInfo sourceBillType;
            Boolean value;
            HashMap map = SCMParamFacadeFactory.getLocalInstance((Context)ctx).getScmSpecialParams(new String[]{"isRefreshing"});
            if (map.containsKey("isRefreshing") && (value = (Boolean)map.get("isRefreshing")).booleanValue()) {
                throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
            }
            Map coreBillType = new HashMap();
            coreBillType = this.getCoreBillType(ctx, aInvBillBaseInfo);
            if (aInvBillBaseInfo.getBillType() == null || aInvBillBaseInfo.getBillType().getId() == null) {
                throw new SCMBillException(SCMBillException.BILLTYPE_ISNULL);
            }
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillType = BillTypeUtils.getBillEntryTableName((Context)ctx, coreBillType);
            }
            String billTable = BillTypeUtils.getBillHeadTableName((Context)ctx, (String)aInvBillBaseInfo.getBillType().getId().toString());
            ArrayList<String> sqlUpdate = new ArrayList<String>();
            if (billTable != null && billTable.length() > 0) {
                sqlUpdate.add("UPDATE " + billTable + " SET FID = FID  WHERE FID = '" + pk.toString() + "'");
            }
            IObjectCollection entrys = null;
            entrys = aInvBillBaseInfo.getBillType() != null && "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString()) ? (IObjectCollection)aInvBillBaseInfo.get("entries") : (IObjectCollection)aInvBillBaseInfo.get("entry");
            String tmp = null;
            StringBuffer srcBillSql = new StringBuffer();
            StringBuffer coreBillSql = new StringBuffer();
            for (int i = 0; i < entrys.size(); ++i) {
                if (((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId() == null) continue;
                tmp = ((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId().toString();
                srcBillSql.append("'").append(tmp).append("',");
                tmp = null;
            }
            if (srcBillSql.length() > 40) {
                srcBillSql.setLength(srcBillSql.length() - 1);
            }
            if ((sourceBillType = ((InvBillBaseEntryInfo)entrys.getObject(0)).getSourceBillType()) != null && sourceBillType.getId() != null && srcBillSql.length() > 40 && (tmp = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)sourceBillType.getId().toString())) != null && tmp.trim().length() > 0 && srcBillSql.length() > 40) {
                sqlUpdate.add("UPDATE " + tmp + " SET FID = FID WHERE FID IN (" + srcBillSql.toString() + ")");
            }
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillSql.append(this.getCoreBillEntryId(ctx, aInvBillBaseInfo));
                Set set = coreBillType.keySet();
                Iterator ite = set.iterator();
                while (ite.hasNext()) {
                    String next = ite.next().toString();
                    if (!coreBillType.containsKey(next) || coreBillType.get(next) == null || coreBillSql.length() <= 40) continue;
                    sqlUpdate.add("UPDATE " + coreBillType.get(next) + " SET FID = FID WHERE FID IN (" + coreBillSql.toString() + ")");
                }
            }
            if (sqlUpdate.size() > 0) {
                String[] updSql = new String[sqlUpdate.size()];
                for (int i = 0; i < sqlUpdate.size(); ++i) {
                    updSql[i] = (String)sqlUpdate.get(i);
                }
                com.kingdee.eas.dynbusiness.util.DBUtil.executeBatch((Context)ctx, (String[])updSql);
            }
        }
        aInvBillBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        InvBillBaseInfo checkInfo = (InvBillBaseInfo)this.getDataNewStatus(ctx, (IObjectValue)aInvBillBaseInfo);
        aInvBillBaseInfo.setBaseStatus(checkInfo.getBaseStatus());
        this.checkUnPassAduit(ctx, aInvBillBaseInfo);
        this.isSamePerson4UnAudit(ctx, aInvBillBaseInfo);
        this.updateUnAuditStatus(ctx, (IObjectValue)aInvBillBaseInfo);
        this.afterUnPassAudit(ctx, pk, aInvBillBaseInfo);
        this.batchExecute(ctx, new Object[]{pk}, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected boolean _updateAccount(Context ctx, InvBillBaseInfo invBillBase) throws BOSException, EASBizException {
        return false;
    }

    protected void afterPassAudit(Context ctx, IObjectPK pk, InvBillBaseInfo billInfo) throws EASBizException, BOSException {
        BizTypeInfo bizType;
        if (paramMap.get("isCloseInsertLot") == null || !((Boolean)paramMap.get("isCloseInsertLot")).booleanValue()) {
            this.insertLots(ctx, pk, billInfo);
        }
        if (paramMap.get("isCloseSerialNum") == null || !((Boolean)paramMap.get("isCloseSerialNum")).booleanValue()) {
            IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
            iMaterialSerialNumber.updateSerialInventory(billInfo);
            billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
            iMaterialSerialNumber.updateMaterialSN(billInfo);
        }
        this.buildOrderOrReturnBill(ctx, pk, billInfo);
        if (!(ctx.get((Object)"isNeedUpdateInventory") != null || paramMap.get("isCloseInvUpdate") != null && ((Boolean)paramMap.get("isCloseInvUpdate")).booleanValue())) {
            this.updateInventory(ctx, pk, billInfo, BizActionEnum.AUDIT);
        }
        if ((bizType = billInfo.getBizType()) == null || !"mxmcXEczQ52MGxLV1Oyh9SQHQ1w=".equals(bizType.getId().toString()) && !"KVe1UEnNT260YmBCLwKZKSQHQ1w=".equals(bizType.getId().toString())) {
            this.calculate(ctx, billInfo);
        }
        this.updateFullReverseBillCost(ctx, billInfo);
        if (!(ctx.get((Object)"isNeedUpdateInventory") != null || paramMap.get("isCloseInvUpdate") != null && ((Boolean)paramMap.get("isCloseInvUpdate")).booleanValue())) {
            this.updateBarcodeInventrory(ctx, pk, billInfo, BatchActionEnum.AUDIT);
        }
    }

    protected void afterUnPassAudit(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        iMaterialSerialNumber.unAduitSerialInventory(aInvBillBaseInfo);
        aInvBillBaseInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        iMaterialSerialNumber.updateMaterialSN(aInvBillBaseInfo);
        this.delBuildOrderOrReturnBill(ctx, pk, aInvBillBaseInfo);
        if (ctx.get((Object)"isNeedUpdateInventory") == null) {
            this.updateInventory(ctx, pk, aInvBillBaseInfo, BizActionEnum.UNAUDIT);
        }
        this.unAuditVirtualBill(ctx, pk, aInvBillBaseInfo);
        BizTypeInfo bizType = aInvBillBaseInfo.getBizType();
        if (bizType == null || !"mxmcXEczQ52MGxLV1Oyh9SQHQ1w=".equals(bizType.getId().toString()) && !"KVe1UEnNT260YmBCLwKZKSQHQ1w=".equals(bizType.getId().toString())) {
            this.calculate(ctx, aInvBillBaseInfo);
        }
        if (aInvBillBaseInfo instanceof SaleIssueBillInfo) {
            ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx).inverseWriteOff(new String[]{aInvBillBaseInfo.getId().toString()});
        }
        if (ctx.get((Object)"isNeedUpdateInventory") == null) {
            this.updateBarcodeInventrory(ctx, pk, aInvBillBaseInfo, BatchActionEnum.UNAUDIT);
        }
    }

    protected void checkUnPassAduit(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        if (aInvBillBaseInfo.getBaseStatus() != null && aInvBillBaseInfo.getBaseStatus().getValue() != 4) {
            throw new SCMBillException(SCMBillException.CHECK_UNAUDIT, new Object[]{aInvBillBaseInfo.getString("number"), ""});
        }
        this._checkUnAuditInParam(ctx, (IObjectValue)aInvBillBaseInfo);
        if (aInvBillBaseInfo.isIsReversed()) {
            throw new SCMBillException(SCMBillException.ISREVERSED_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
        this._checkIsVouchered(ctx, (IObjectValue)aInvBillBaseInfo, true);
        this._checkIsHaveDestBills(ctx, aInvBillBaseInfo);
        if (!(aInvBillBaseInfo instanceof MaterialRequestBillInfo) && !aInvBillBaseInfo.isIsInitBill() && this.isCheckBizDate()) {
            this._checkBizDate(ctx, (IObjectValue)aInvBillBaseInfo);
        }
    }

    protected boolean checkForOffSet(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        boolean isOffSet = false;
        String sourceBillId = "";
        if (invBillBaseInfo != null && invBillBaseInfo.isIsReversed()) {
            IObjectCollection iObjectCollection = (IObjectCollection)invBillBaseInfo.get("entry");
            if (iObjectCollection != null && iObjectCollection.size() > 0) {
                CompanyOrgUnitInfo companyOrgUnitInfo;
                InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
                if (aInvBillBaseEntryInfo != null && aInvBillBaseEntryInfo.getSourceBillId() != null) {
                    sourceBillId = aInvBillBaseEntryInfo.getSourceBillId();
                }
                if ((companyOrgUnitInfo = aInvBillBaseEntryInfo.getCompanyOrgUnit()) != null) {
                    PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                    if (currentPeriodInfo == null) {
                        throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
                    }
                    TransactionTypeInfo transactionType = invBillBaseInfo.getTransactionType();
                    InvUpdateTypeInfo invUpdateTypeInfo = null;
                    try {
                        invUpdateTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getDefaultInvUpdateType(transactionType.getId().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (invUpdateTypeInfo != null && invUpdateTypeInfo.isIsNotUpdateInv()) {
                        if (!invBillBaseInfo.isIsInitBill() && invBillBaseInfo.getBizDate().before(currentPeriodInfo.getBeginDate())) {
                            throw new InvBizException(InvBizException.BIZDATEBEFORECURRENTPERIOD, new Object[]{"[" + currentPeriodInfo.getBeginDate().toString() + "]"});
                        }
                        isOffSet = true;
                        ctx.put((Object)CTX_TEMP_CHECKED_BIZDATE, (Object)Boolean.TRUE);
                    } else {
                        isOffSet = true;
                        ctx.put((Object)CTX_TEMP_CHECKED_BIZDATE, (Object)Boolean.TRUE);
                    }
                }
            }
            if (!"".equals(sourceBillId) && invBillBaseInfo.getBizDate() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("bizDate"));
                InvBillBaseInfo sourceBillInfo = this.getInvBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(sourceBillId), sic);
                if (sourceBillInfo != null && sourceBillInfo.getBizDate() != null && invBillBaseInfo.getBizDate().getTime() < sourceBillInfo.getBizDate().getTime()) {
                    throw new InvBizException(InvBizException.BIZDATEBEFORESOURCEBILL, new Object[]{"[" + sourceBillInfo.getBizDate().toString() + "]"});
                }
            }
        } else {
            isOffSet = true;
        }
        return isOffSet;
    }

    protected Vector getAndCheckVisualBill(Context ctx, String purOrSale, Vector vNotVirtrual, Vector vDestBill) throws EASBizException, BOSException {
        Vector<String> vecVisualBill = new Vector<String>(0);
        Connection conn = null;
        Statement stmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select Fid,Fnumber,FIsSysBill From ");
        if (purOrSale.equals("pur")) {
            sql.append("T_IM_PurInWarehsBill ");
        } else if (purOrSale.equals("sale")) {
            sql.append("T_IM_SaleIssueBill ");
        } else if (purOrSale.equals("movein")) {
            sql.append("T_IM_MoveInWarehsBill ");
        } else if (purOrSale.equals("moveissue")) {
            sql.append("T_IM_MoveIssueBill ");
        }
        sql.append("where Fid ");
        sql.append(SCMServerUtils.getInID((Vector)vDestBill));
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            String id = null;
            String number = null;
            int isSysBill = -1;
            while (rs.next()) {
                id = rs.getString("Fid");
                number = rs.getString("Fnumber");
                isSysBill = rs.getInt("FIsSysBill");
                if (isSysBill == 0) {
                    vNotVirtrual.add(id);
                    continue;
                }
                if (isSysBill != 1) continue;
                if (BTPManagerFactory.getLocalInstance((Context)ctx).ifHaveDestBills(id)) {
                    throw new InvBizException(InvBizException.VISUALBILHASDESTBILL, new Object[]{number});
                }
                vecVisualBill.add(id);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return vecVisualBill;
    }

    protected boolean isBaseUnitUpdate(Context ctx, StorageOrgUnitInfo storageOrg) throws BOSException, EASBizException {
        boolean rtValue = false;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String paramValue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(storageOrg.getId().toString()), "INM004").trim();
        if ("true".equals(paramValue)) {
            rtValue = true;
        }
        return rtValue;
    }

    protected boolean isCheckBaseData() {
        return true;
    }

    protected boolean isCheckEntrySourceBillInfo() {
        return true;
    }

    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return true;
    }

    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return false;
    }

    protected boolean isCheckMatCompanyInfo() {
        return false;
    }

    protected boolean isCheckMaterialCost() {
        return false;
    }

    protected boolean isCheckSourceBill() {
        return false;
    }

    protected String saveBotpRelation(Context ctx, SplitBillRelationInfo aSplitBillRelationInfo, HashMap hsSB) throws EASBizException, BOSException {
        String string;
        String insertBotpRelationSql = "insert into T_BOT_RELATION (FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FDate,FOperatorID,FisEffected,FBOTMappingID,FType) values (?,?,?,?,?,?,?,?,?,?)";
        String insertBotpRelationEntrySql = "insert into T_BOT_RelationEntry(FID, FSRCOBJECTID, FDESTOBJECTID, FSRCENTRYID, FDESTENTRYID, FSRCENTRYPROPNAME, FDESTENTRYPROPNAME, FSRCPROPERTYNAME, FDESTPROPERTYNAME, FVALUE, FKEYID)values (?, ?, ?, ?, ?, N'__src.entry', N'__dest.entry', null, N'id', null, ?)";
        IBOTRelation ibotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo ev = new EntityViewInfo();
        PreparedStatement insertMotherRelationStmt = null;
        PreparedStatement insertBotpRelationEntryStmt = null;
        String motherBillID = null;
        String keyID = null;
        BOTRelationInfo aBOTRelationInfo = null;
        Connection conn = null;
        try {
            int n;
            conn = EJBFactory.getConnection((Context)ctx);
            insertMotherRelationStmt = conn.prepareStatement(insertBotpRelationSql);
            insertBotpRelationEntryStmt = conn.prepareStatement(insertBotpRelationEntrySql);
            motherBillID = aSplitBillRelationInfo.getMotherBillID();
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)motherBillID));
            ev.setFilter(filter);
            BOTRelationCollection botpColl = ibotRelation.getCollection(ev);
            for (n = 0; n < botpColl.size(); ++n) {
                aBOTRelationInfo = botpColl.get(n);
                keyID = BOSUuid.create((BOSObjectType)aBOTRelationInfo.getBOSType()).toString();
                this.setMotherRelationStmt(insertMotherRelationStmt, keyID, aBOTRelationInfo, aSplitBillRelationInfo, true);
            }
            if (hsSB.get("hsRe") != null && ((Vector)hsSB.get("hsRe")).size() > 0) {
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)motherBillID));
                ev.setFilter(filter);
                botpColl = ibotRelation.getCollection(ev);
                for (n = 0; n < botpColl.size(); ++n) {
                    aBOTRelationInfo = botpColl.get(n);
                    keyID = BOSUuid.create((BOSObjectType)aBOTRelationInfo.getBOSType()).toString();
                    this.setMotherRelationStmt(insertMotherRelationStmt, keyID, aBOTRelationInfo, aSplitBillRelationInfo, false);
                    this.setBotpRelationEntry(ctx, insertBotpRelationEntryStmt, aSplitBillRelationInfo.getChildBillID(), aBOTRelationInfo.getDestObjectID(), keyID, true);
                    this.setBotpRelationEntry(ctx, insertBotpRelationEntryStmt, aSplitBillRelationInfo.getMotherBillID(), aBOTRelationInfo.getDestObjectID(), aBOTRelationInfo.getId().toString(), false);
                }
            }
            insertMotherRelationStmt.executeBatch();
            insertBotpRelationEntryStmt.executeBatch();
            string = keyID;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertMotherRelationStmt);
                SQLUtils.cleanup(insertBotpRelationEntryStmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertMotherRelationStmt);
        SQLUtils.cleanup((Statement)insertBotpRelationEntryStmt);
        SQLUtils.cleanup((Connection)conn);
        return string;
    }

    protected String saveBotpRelation(Context ctx, Vector vecSBRelation, HashMap hsSB) throws EASBizException, BOSException {
        String i2;
        String insertBotpRelationSql = "insert into T_BOT_RELATION (FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FDate,FOperatorID,FisEffected,FBOTMappingID,FType) values (?,?,?,?,?,?,?,?,?,?)";
        IBOTRelation ibotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo ev = new EntityViewInfo();
        PreparedStatement insertMotherRelationStmt = null;
        String motherBillID = null;
        String keyID = null;
        BOTRelationInfo aBOTRelationInfo = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            insertMotherRelationStmt = conn.prepareStatement(insertBotpRelationSql);
            for (int i2 = 0; i2 < vecSBRelation.size(); ++i2) {
                int n;
                SplitBillRelationInfo aSplitBillRelationInfo = (SplitBillRelationInfo)vecSBRelation.get(i2);
                motherBillID = aSplitBillRelationInfo.getMotherBillID();
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)motherBillID));
                ev.setFilter(filter);
                BOTRelationCollection botpColl = ibotRelation.getCollection(ev);
                for (n = 0; n < botpColl.size(); ++n) {
                    aBOTRelationInfo = botpColl.get(n);
                    keyID = BOSUuid.create((BOSObjectType)aBOTRelationInfo.getBOSType()).toString();
                    this.setMotherRelationStmt(insertMotherRelationStmt, keyID, aBOTRelationInfo, aSplitBillRelationInfo, true);
                }
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)motherBillID));
                ev.setFilter(filter);
                botpColl = ibotRelation.getCollection(ev);
                for (n = 0; n < botpColl.size(); ++n) {
                    aBOTRelationInfo = botpColl.get(n);
                    keyID = BOSUuid.create((BOSObjectType)aBOTRelationInfo.getBOSType()).toString();
                    this.setMotherRelationStmt(insertMotherRelationStmt, keyID, aBOTRelationInfo, aSplitBillRelationInfo, false);
                }
            }
            insertMotherRelationStmt.executeBatch();
            i2 = keyID;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertMotherRelationStmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertMotherRelationStmt);
        SQLUtils.cleanup((Connection)conn);
        return i2;
    }

    protected void saveSplitBillRelation(Context ctx, Vector vecSBRelation, Vector vecSBEntryRelation) throws EASBizException, BOSException {
        String insertMotherRelationSql = "insert into T_IM_SplitBillRelation (Fid,FMotherBillID,FChildBillID,FMotherBillNumber,FChildBillNumber,FStorageOrgUnitID,FBillTypeID,FSplitTime) values (?,?,?,?,?,?,?,?)";
        String insertChildRelationSql = "insert into T_IM_SplitBillEntryRelation (Fid,FMotherBillEntryID,FChildBillEntryID,FSplitQty) values (?,?,?,?)";
        PreparedStatement insertMotherRelationStmt = null;
        PreparedStatement insertChildRelationStmt = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            insertMotherRelationStmt = conn.prepareStatement(insertMotherRelationSql);
            insertChildRelationStmt = conn.prepareStatement(insertChildRelationSql);
            for (int i = 0; i < vecSBRelation.size(); ++i) {
                SplitBillRelationInfo aSplitBillRelationInfo = (SplitBillRelationInfo)vecSBRelation.get(i);
                insertMotherRelationStmt.setString(1, BOSUuid.create((String)"3E71599F").toString());
                insertMotherRelationStmt.setString(2, aSplitBillRelationInfo.getMotherBillID());
                insertMotherRelationStmt.setString(3, aSplitBillRelationInfo.getChildBillID());
                insertMotherRelationStmt.setString(4, aSplitBillRelationInfo.getMotherBillNumber());
                insertMotherRelationStmt.setString(5, aSplitBillRelationInfo.getChildBillNumber());
                insertMotherRelationStmt.setString(6, aSplitBillRelationInfo.getStorageOrgUnit().getId().toString());
                insertMotherRelationStmt.setString(7, aSplitBillRelationInfo.getBillType().getId().toString());
                insertMotherRelationStmt.setTimestamp(8, aSplitBillRelationInfo.getSplitTime());
                insertMotherRelationStmt.addBatch();
            }
            for (int j = 0; j < vecSBEntryRelation.size(); ++j) {
                SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = (SplitBillEntryRelationInfo)vecSBEntryRelation.get(j);
                insertChildRelationStmt.setString(1, BOSUuid.create((String)"98AEC2CB").toString());
                insertChildRelationStmt.setString(2, aSplitBillEntryRelationInfo.getMotherBillEntryID());
                insertChildRelationStmt.setString(3, aSplitBillEntryRelationInfo.getChildBillEntryID());
                insertChildRelationStmt.setBigDecimal(4, aSplitBillEntryRelationInfo.getSplitQty());
                insertChildRelationStmt.addBatch();
            }
            insertMotherRelationStmt.executeBatch();
            insertChildRelationStmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertMotherRelationStmt);
                SQLUtils.cleanup(insertChildRelationStmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertMotherRelationStmt);
        SQLUtils.cleanup((Statement)insertChildRelationStmt);
        SQLUtils.cleanup((Connection)conn);
    }

    protected void setMotherRelationStmt(PreparedStatement insertMotherRelationStmt, String keyID, BOTRelationInfo aBOTRelationInfo, SplitBillRelationInfo aSplitBillRelationInfo, boolean is) throws SQLException {
        insertMotherRelationStmt.setString(1, keyID);
        insertMotherRelationStmt.setString(2, aBOTRelationInfo.getSrcEntityID());
        insertMotherRelationStmt.setString(3, aBOTRelationInfo.getDestEntityID());
        if (is) {
            insertMotherRelationStmt.setString(4, aBOTRelationInfo.getSrcObjectID());
            insertMotherRelationStmt.setString(5, aSplitBillRelationInfo.getChildBillID());
        } else {
            insertMotherRelationStmt.setString(4, aSplitBillRelationInfo.getChildBillID());
            insertMotherRelationStmt.setString(5, aBOTRelationInfo.getDestObjectID());
        }
        insertMotherRelationStmt.setDate(6, (java.sql.Date)aBOTRelationInfo.getDate());
        insertMotherRelationStmt.setString(7, aBOTRelationInfo.getOperatorID());
        insertMotherRelationStmt.setBoolean(8, aBOTRelationInfo.isIsEffected());
        insertMotherRelationStmt.setString(9, aBOTRelationInfo.getBOTMappingID());
        insertMotherRelationStmt.setInt(10, aBOTRelationInfo.getType());
        insertMotherRelationStmt.addBatch();
    }

    protected void setNULLToZERO(IObjectValue invBill) {
        int i;
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)invBill;
        int headSize = headNumberFields.length;
        for (i = 0; i < headSize; ++i) {
            if (!aInvBillBaseInfo.containsKey(headNumberFields[i]) || aInvBillBaseInfo.get(headNumberFields[i]) != null) continue;
            aInvBillBaseInfo.setBigDecimal(headNumberFields[i], SysConstant.BIGZERO);
        }
        int size = headBooleanFields.length;
        for (i = 0; i < size; ++i) {
            if (!aInvBillBaseInfo.containsKey(headBooleanFields[i]) || aInvBillBaseInfo.get(headBooleanFields[i]) != null) continue;
            aInvBillBaseInfo.setBoolean(headBooleanFields[i], false);
        }
        IObjectCollection entrys = null;
        boolean isHDDBill = false;
        if (aInvBillBaseInfo.getBillType() != null && "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString())) {
            isHDDBill = true;
            entrys = (IObjectCollection)aInvBillBaseInfo.get("entries");
        } else {
            entrys = (IObjectCollection)aInvBillBaseInfo.get("entry");
        }
        if (entrys != null) {
            for (int entryLoop = 0; entryLoop < entrys.size(); ++entryLoop) {
                IObjectCollection entrysCollection;
                int fieldLoop;
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(entryLoop);
                for (fieldLoop = 0; fieldLoop < entryNumberFields.length; ++fieldLoop) {
                    if (!entry.containsKey(entryNumberFields[fieldLoop]) || entry.get(entryNumberFields[fieldLoop]) != null) continue;
                    entry.setBigDecimal(entryNumberFields[fieldLoop], SysConstant.BIGZERO);
                }
                for (fieldLoop = 0; fieldLoop < entryBooleanFields.length; ++fieldLoop) {
                    if (!entry.containsKey(entryBooleanFields[fieldLoop]) || entry.get(entryBooleanFields[fieldLoop]) != null) continue;
                    entry.setBoolean(entryBooleanFields[fieldLoop], new Boolean(false));
                }
                if (!isHDDBill || (entrysCollection = (IObjectCollection)entry.get("entries")) == null) continue;
                for (int entryDetailLoop = 0; entryDetailLoop < entrysCollection.size(); ++entryDetailLoop) {
                    InvBillBaseEntryInfo entryDetailInfo = (InvBillBaseEntryInfo)entrysCollection.getObject(entryDetailLoop);
                    for (int fieldLoop2 = 0; fieldLoop2 < entryNumberFields.length; ++fieldLoop2) {
                        if (!entryDetailInfo.containsKey(entryNumberFields[fieldLoop2]) || entryDetailInfo.get(entryNumberFields[fieldLoop2]) != null) continue;
                        entryDetailInfo.setBigDecimal(entryNumberFields[fieldLoop2], SysConstant.BIGZERO);
                    }
                }
            }
        }
    }

    protected void setUnAssociationQtyByQty(IObjectCollection entrys) throws BOSException, EASBizException {
        for (int i = 0; i < entrys.size(); ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
            if (entry.getBaseQty() == null) {
                entry.setBaseQty(SysConstant.BIGZERO);
            }
            entry.setAssociateQty(entry.getBaseQty());
        }
    }

    protected void unAuditVirtualBill(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        String transTypeID;
        IInventoryUpdate iInventoryUpdate;
        String transTypeID2;
        IInventoryUpdate iInventoryUpdate2;
        IManualWriteOffFacade iManualWriteOffFacade;
        String[] strIDs;
        if (!(aInvBillBaseInfo instanceof SaleIssueBillInfo || aInvBillBaseInfo instanceof MaterialReqBillInfo || aInvBillBaseInfo instanceof PurInWarehsBillInfo)) {
            return;
        }
        Vector vecPurVisualBill = (Vector)aInvBillBaseInfo.get("purInWarehsVirtualBill");
        Vector vecSaleVisualBill = (Vector)aInvBillBaseInfo.get("purSaleIssueVirtualBill");
        Vector vecMoveInVisualBill = (Vector)aInvBillBaseInfo.get("purMoveInVirtualBill");
        Vector vecMoveIssueVisualBill = (Vector)aInvBillBaseInfo.get("purMoveIssueVirtualBill");
        if (vecSaleVisualBill != null && vecSaleVisualBill.size() > 0) {
            strIDs = new String[vecSaleVisualBill.size()];
            ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
            iManualWriteOffFacade = ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx);
            for (int j = 0; j < vecSaleVisualBill.size(); ++j) {
                strIDs[j] = (String)vecSaleVisualBill.get(j);
                SaleIssueBillInfo aSaleIssueBillInfo = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(strIDs[j]));
                if (this.isJumpOrg(aSaleIssueBillInfo.getBizType())) {
                    iInventoryUpdate2 = InventoryUpdateFactory.getLocalInstance((Context)ctx);
                    transTypeID2 = null;
                    if (aSaleIssueBillInfo.getTransactionType() != null) {
                        transTypeID2 = aSaleIssueBillInfo.getTransactionType().getId().toString();
                        iInventoryUpdate2.updateInventory(BizActionEnum.UNAUDIT, strIDs[j], transTypeID2);
                    }
                }
                iManualWriteOffFacade.inverseWriteOff(new String[]{strIDs[j]});
                this.updateUnAuditStatus(ctx, (IObjectValue)aSaleIssueBillInfo);
                CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)aSaleIssueBillInfo);
                iSaleIssueBill.delete((IObjectPK)new ObjectUuidPK(strIDs[j]));
            }
        }
        if (vecPurVisualBill != null && vecPurVisualBill.size() > 0) {
            strIDs = new String[vecPurVisualBill.size()];
            IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance(ctx);
            iManualWriteOffFacade = ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < vecPurVisualBill.size(); ++i) {
                strIDs[i] = (String)vecPurVisualBill.get(i);
                PurInWarehsBillInfo aPurInWarehsBillInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(strIDs[i]));
                if (this.isJumpOrg(aPurInWarehsBillInfo.getBizType())) {
                    iInventoryUpdate2 = InventoryUpdateFactory.getLocalInstance((Context)ctx);
                    transTypeID2 = null;
                    if (aPurInWarehsBillInfo.getTransactionType() != null) {
                        transTypeID2 = aPurInWarehsBillInfo.getTransactionType().getId().toString();
                        iInventoryUpdate2.updateInventory(BizActionEnum.UNAUDIT, strIDs[i], transTypeID2);
                    }
                }
                iManualWriteOffFacade.inverseWriteOff(new String[]{strIDs[i]});
                this.updateUnAuditStatus(ctx, (IObjectValue)aPurInWarehsBillInfo);
                this.calculate(ctx, aPurInWarehsBillInfo);
                iPurInWarehsBill.delete((IObjectPK)new ObjectUuidPK(strIDs[i]));
            }
        }
        if (vecMoveInVisualBill != null && vecMoveInVisualBill.size() > 0) {
            strIDs = new String[vecMoveInVisualBill.size()];
            IMoveInWarehsBill imoveInWarehsBill = MoveInWarehsBillFactory.getLocalInstance(ctx);
            for (int i = 0; i < vecMoveInVisualBill.size(); ++i) {
                strIDs[i] = (String)vecMoveInVisualBill.get(i);
                MoveInWarehsBillInfo moveInInfo = imoveInWarehsBill.getMoveInWarehsBillInfo((IObjectPK)new ObjectUuidPK(strIDs[i]));
                if (this.isJumpOrg(moveInInfo.getBizType())) {
                    iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
                    transTypeID = null;
                    if (moveInInfo.getTransactionType() != null) {
                        transTypeID = moveInInfo.getTransactionType().getId().toString();
                        iInventoryUpdate.updateInventory(BizActionEnum.UNAUDIT, strIDs[i], transTypeID);
                    }
                }
                this.updateUnAuditStatus(ctx, (IObjectValue)moveInInfo);
                this.calculate(ctx, moveInInfo);
                imoveInWarehsBill.delete((IObjectPK)new ObjectUuidPK(strIDs[i]));
            }
        }
        if (vecMoveIssueVisualBill != null && vecMoveIssueVisualBill.size() > 0) {
            strIDs = new String[vecMoveIssueVisualBill.size()];
            IMoveIssueBill iMoveIssueBill = MoveIssueBillFactory.getLocalInstance(ctx);
            for (int i = 0; i < vecMoveIssueVisualBill.size(); ++i) {
                strIDs[i] = (String)vecMoveIssueVisualBill.get(i);
                MoveIssueBillInfo moveIssueBillInfo = iMoveIssueBill.getMoveIssueBillInfo((IObjectPK)new ObjectUuidPK(strIDs[i]));
                if (this.isJumpOrg(moveIssueBillInfo.getBizType())) {
                    iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
                    transTypeID = null;
                    if (moveIssueBillInfo.getTransactionType() != null) {
                        transTypeID = moveIssueBillInfo.getTransactionType().getId().toString();
                        iInventoryUpdate.updateInventory(BizActionEnum.UNAUDIT, strIDs[i], transTypeID);
                    }
                }
                this.updateUnAuditStatus(ctx, (IObjectValue)moveIssueBillInfo);
                CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)moveIssueBillInfo);
                iMoveIssueBill.delete((IObjectPK)new ObjectUuidPK(strIDs[i]));
            }
        }
    }

    protected void updateInventory(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo, BizActionEnum bizAction) throws EASBizException, BOSException {
        IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
        String transTypeID = null;
        if (aInvBillBaseInfo.getTransactionType() != null) {
            transTypeID = aInvBillBaseInfo.getTransactionType().getId().toString();
            iInventoryUpdate.updateInventory(bizAction, pk.toString(), transTypeID);
        }
    }

    void calculate(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        if (!this.isJumpOrg(aInvBillBaseInfo.getBizType())) {
            CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)aInvBillBaseInfo);
        }
    }

    private boolean isJumpOrg(BizTypeInfo bizTypeInfo) {
        boolean flag = false;
        if (bizTypeInfo == null || bizTypeInfo.getId() == null) {
            return flag;
        }
        String bizTypeID = bizTypeInfo.getId().toString();
        if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizTypeID) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizTypeID) || "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizTypeID)) {
            flag = true;
        }
        return flag;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildOrderOrReturnBill(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        Statement stmt;
        Connection conn;
        String tempTable;
        block25: {
            TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
            if (tti == null) {
                return;
            }
            if (!this.isBuildOrderOrRetBill(ctx, aInvBillBaseInfo)) {
                return;
            }
            boolean isReversed = aInvBillBaseInfo.isIsReversed();
            BillTypeInfo bti = aInvBillBaseInfo.getBillType();
            if (tti.getBillType() == null || tti.getRiType() == null) {
                ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
                tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tti.getId()), SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
            }
            String transType = null;
            int bizDirection = 0;
            if (tti.getRiType() != null && tti.getRiType().getBizDirection() != null) {
                bizDirection = tti.getRiType().getBizDirection().getValue();
            }
            if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(bti.getId().toString()) && 1 == bizDirection) {
                transType = "pur";
            } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(bti.getId().toString()) && 1 == bizDirection) {
                transType = "sal";
            } else if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(bti.getId().toString()) && -1 == bizDirection) {
                transType = "purRet";
            } else {
                if (!"50957179-0105-1000-e000-015bc0a812fd463ED552".equals(bti.getId().toString())) return;
                if (-1 != bizDirection) return;
                transType = "salRet";
            }
            CompanyOrgUnitInfo cou = this.getComanyOrgUnit(ctx, aInvBillBaseInfo);
            int precision = cou.getBaseCurrency().getPrecision();
            StringBuffer createTempTable = new StringBuffer();
            createTempTable.append("Create Table tt").append("(");
            createTempTable.append("FSaleOrderNumber Varchar(200),");
            createTempTable.append("FSaleOrderEntrySeq int default 0,");
            createTempTable.append("FSaleOrderID Varchar(44),");
            createTempTable.append("FSaleOrderEntryID Varchar(44),");
            createTempTable.append("FCoreBillTypeID Varchar(44),");
            createTempTable.append("FEntryID Varchar(44));");
            tempTable = KsqlUtil.createTempTable((Context)ctx, (String)createTempTable.toString());
            conn = null;
            stmt = null;
            try {
                block29: {
                    block31: {
                        StringBuffer stringBuff;
                        String bizTypeID;
                        String billTypeID;
                        String entryBosType;
                        String billBosType;
                        String ordEntryName;
                        String ordTableName;
                        String invEntryName;
                        String invTableName;
                        IRowSet rs;
                        block30: {
                            block26: {
                                block28: {
                                    StringBuffer stringBuff2;
                                    String bizTypeID2;
                                    String billTypeID2;
                                    String entryBosType2;
                                    String billBosType2;
                                    String ordEntryName2;
                                    String ordTableName2;
                                    String invEntryName2;
                                    String invTableName2;
                                    block27: {
                                        conn = EJBFactory.getConnection((Context)ctx);
                                        stmt = conn.createStatement();
                                        rs = null;
                                        if (transType.equals("sal")) {
                                            if (isReversed) {
                                                SaleIssueBillInfo siInfo = (SaleIssueBillInfo)aInvBillBaseInfo;
                                                this.updateSaleOrderBill(siInfo, conn, ctx);
                                                break block25;
                                            } else {
                                                CoreBaseCollection infos = this.transformSystemBillViaBotp((CoreBillBaseInfo)aInvBillBaseInfo, ctx);
                                                this.fillAndSaveSystemBill(infos, ctx);
                                                this.reWriteSaleIssueBill(infos, conn, ctx);
                                            }
                                            break block25;
                                        }
                                        if (!transType.equals("pur")) break block26;
                                        invTableName2 = "T_IM_PurInWarehsBill";
                                        invEntryName2 = "T_IM_PurInwarehsEntry";
                                        ordTableName2 = "T_SM_PurOrder";
                                        ordEntryName2 = "T_SM_PurOrderEntry";
                                        billBosType2 = new PurOrderInfo().getBOSType().toString();
                                        entryBosType2 = new PurOrderEntryInfo().getBOSType().toString();
                                        billTypeID2 = "510b6503-0105-1000-e000-010bc0a812fd463ED552";
                                        bizTypeID2 = "d8e80652-0106-1000-e000-04c5c0a812202407435C";
                                        stringBuff2 = new StringBuffer();
                                        stringBuff2.append("select FPurchaseOrgUnitID, FPurchaseGroupID, FPurchasePersonID from T_IM_PurInwarehsEntry where FParentID = '");
                                        stringBuff2.append(pk.toString());
                                        stringBuff2.append("' Group By FPurchaseOrgUnitID, FPurchaseGroupID, FPurchasePersonID");
                                        if (!isReversed) break block27;
                                        ArrayList orderList = this.getPurOrdersID(ctx, pk, aInvBillBaseInfo, transType);
                                        if (orderList != null) {
                                            int size = orderList.size();
                                            for (int index = 0; index < size; ++index) {
                                                this.updateOrderOrReturnBill(ctx, stmt, transType, invEntryName2, ordTableName2, ordEntryName2, pk.toString(), (String)orderList.get(index), precision);
                                            }
                                        }
                                        break block28;
                                    }
                                    rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff2.toString());
                                    String numberTag = "*";
                                    while (rs.next()) {
                                        String orderBillID = BOSUuid.create((String)billBosType2).toString();
                                        String purOrgUnit = rs.getString("FPurchaseOrgUnitID");
                                        String purGroup = rs.getString("FPurchaseGroupID");
                                        String purPerson = rs.getString("FPurchasePersonID");
                                        String number = numberTag + aInvBillBaseInfo.getNumber();
                                        String insertOrderEntrySql = this.getInsertOrderEntrySql(transType, invTableName2, invEntryName2, ordEntryName2, entryBosType2, pk.toString(), orderBillID, precision, purOrgUnit, purGroup, purPerson);
                                        String insertOrderBillSql = this.getInsertOrderBillSql(transType, invTableName2, invEntryName2, ordTableName2, ordEntryName2, number, pk.toString(), orderBillID, billTypeID2, bizTypeID2, purOrgUnit, purGroup, purPerson);
                                        String updateSql = this.getUpdateSql(ctx, transType, invTableName2, invEntryName2, ordTableName2, ordEntryName2, orderBillID, pk.toString(), tempTable);
                                        stmt.addBatch(insertOrderEntrySql);
                                        stmt.addBatch(insertOrderBillSql);
                                        stmt.addBatch(updateSql.split(";")[0]);
                                        stmt.addBatch(updateSql.split(";")[1]);
                                        numberTag = numberTag + "*";
                                    }
                                }
                                stmt.executeBatch();
                                break block25;
                            }
                            if (!transType.equals("purRet")) break block29;
                            invTableName = "T_IM_PurInWarehsBill";
                            invEntryName = "T_IM_PurInwarehsEntry";
                            ordTableName = "T_SM_PurReturns";
                            ordEntryName = "T_SM_PurReturnsEntry";
                            billBosType = new PurReturnsInfo().getBOSType().toString();
                            entryBosType = new PurReturnsEntryInfo().getBOSType().toString();
                            billTypeID = "50957179-0105-1000-e006-6152c0a812fd463ED552";
                            bizTypeID = "d8e80652-0107-1000-e000-04c5c0a812202407435C";
                            stringBuff = new StringBuffer();
                            stringBuff.append("select FPurchaseOrgUnitID, FPurchaseGroupID, FPurchasePersonID from T_IM_PurInwarehsEntry where FParentID =  '");
                            stringBuff.append(pk.toString());
                            stringBuff.append("' Group By FPurchaseOrgUnitID, FPurchaseGroupID, FPurchasePersonID");
                            if (!isReversed) break block30;
                            ArrayList orderList = this.getPurOrdersID(ctx, pk, aInvBillBaseInfo, transType);
                            if (orderList != null) {
                                int size = orderList.size();
                                for (int index = 0; index < size; ++index) {
                                    this.updateOrderOrReturnBill(ctx, stmt, transType, invEntryName, ordTableName, ordEntryName, pk.toString(), (String)orderList.get(index), precision);
                                }
                            }
                            break block31;
                        }
                        rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff.toString());
                        String numberTag = "*";
                        while (rs.next()) {
                            String orderBillID = BOSUuid.create((String)billBosType).toString();
                            String purOrgUnit = rs.getString("FPurchaseOrgUnitID");
                            String purGroup = rs.getString("FPurchaseGroupID");
                            String purPerson = rs.getString("FPurchasePersonID");
                            String number = numberTag + aInvBillBaseInfo.getNumber();
                            String insertOrderEntrySql = this.getInsertOrderEntrySql(transType, invTableName, invEntryName, ordEntryName, entryBosType, pk.toString(), orderBillID, precision, purOrgUnit, purGroup, purPerson);
                            String insertOrderBillSql = this.getInsertOrderBillSql(transType, invTableName, invEntryName, ordTableName, ordEntryName, number, pk.toString(), orderBillID, billTypeID, bizTypeID, purOrgUnit, purGroup, purPerson);
                            String updateSql = this.getUpdateSql(ctx, transType, invTableName, invEntryName, ordTableName, ordEntryName, orderBillID, pk.toString(), tempTable);
                            stmt.addBatch(insertOrderEntrySql);
                            stmt.addBatch(insertOrderBillSql);
                            stmt.addBatch(updateSql.split(";")[0]);
                            stmt.addBatch(updateSql.split(";")[1]);
                            numberTag = numberTag + "*";
                        }
                    }
                    stmt.executeBatch();
                    break block25;
                }
                if (transType.equals("salRet")) {
                    this.updateSoureBill(ctx, pk, aInvBillBaseInfo, true);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
    }

    private void updateSaleOrderBill(SaleIssueBillInfo siInfo, Connection conn, Context ctx) throws BOSException, EASBizException, SQLException {
        this.updateSaleOrderEntry(siInfo, conn, ctx);
        this.updateSaleOrderHead(siInfo, conn, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSaleOrderHead(SaleIssueBillInfo siInfo, Connection conn, Context ctx) throws BOSException, EASBizException, SQLException {
        String updateHeadSql = "update t_sd_saleorder set ftotalamount = (select sum(isnull(famount, 0)) from t_sd_saleorderentry where fparentid=?),ftotalTax = (select sum(isnull(ftax, 0)) from t_sd_saleorderentry where fparentid=?),ftotaltaxamount = (select sum(isnull(ftaxamount, 0)) from t_sd_saleorderentry where fparentid=?), FLocalTotalAmount = (select sum(isnull(flocalamount, 0)) from t_sd_saleorderentry where fparentid=?), flocaltotaltaxamount = (select sum(isnull(flocaltaxamount, 0)) from t_sd_saleorderentry where fparentid=?) where fid = ?";
        PreparedStatement pmUpdateHead = null;
        try {
            pmUpdateHead = conn.prepareStatement("update t_sd_saleorder set ftotalamount = (select sum(isnull(famount, 0)) from t_sd_saleorderentry where fparentid=?),ftotalTax = (select sum(isnull(ftax, 0)) from t_sd_saleorderentry where fparentid=?),ftotaltaxamount = (select sum(isnull(ftaxamount, 0)) from t_sd_saleorderentry where fparentid=?), FLocalTotalAmount = (select sum(isnull(flocalamount, 0)) from t_sd_saleorderentry where fparentid=?), flocaltotaltaxamount = (select sum(isnull(flocaltaxamount, 0)) from t_sd_saleorderentry where fparentid=?) where fid = ?");
            HashSet<String> soSet = new HashSet<String>();
            for (int i = 0; i < siInfo.getEntry().size(); ++i) {
                SaleIssueEntryInfo entry = siInfo.getEntry().get(i);
                if (soSet.contains(entry.getSaleOrder())) continue;
                soSet.add(entry.getSaleOrder());
                pmUpdateHead.setString(1, entry.getSaleOrder());
                pmUpdateHead.setString(2, entry.getSaleOrder());
                pmUpdateHead.setString(3, entry.getSaleOrder());
                pmUpdateHead.setString(4, entry.getSaleOrder());
                pmUpdateHead.setString(5, entry.getSaleOrder());
                pmUpdateHead.setString(6, entry.getSaleOrder());
                pmUpdateHead.addBatch();
            }
            pmUpdateHead.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Statement)pmUpdateHead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSaleOrderEntry(SaleIssueBillInfo siInfo, Connection conn, Context ctx) throws BOSException, EASBizException, SQLException {
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)ctx);
        String updateEntrySql = "update t_sd_saleorderentry set FQty=?,FAssistQty=?,FBaseQty=?,FDiscountAmount=?,FAmount=?,FLocalAmount=?,FTax=?,FLocalTax=?,FTaxAmount=?,FLocalTaxAmount=? where fid = ?";
        PreparedStatement pmUpdateEntry = null;
        try {
            pmUpdateEntry = conn.prepareStatement("update t_sd_saleorderentry set FQty=?,FAssistQty=?,FBaseQty=?,FDiscountAmount=?,FAmount=?,FLocalAmount=?,FTax=?,FLocalTax=?,FTaxAmount=?,FLocalTaxAmount=? where fid = ?");
            for (int i = 0; i < siInfo.getEntry().size(); ++i) {
                SaleIssueEntryInfo entry = siInfo.getEntry().get(i);
                SaleOrderEntryInfo saleOrderEntry = iSaleOrderEntry.getSaleOrderEntryInfo("where id='" + entry.getSaleOrderEntry() + "'");
                BigDecimal qty = saleOrderEntry.getQty().subtract(entry.getQty().abs());
                BigDecimal assistQty = saleOrderEntry.getAssistQty().subtract(entry.getAssistQty().abs());
                BigDecimal baseQty = saleOrderEntry.getBaseQty().subtract(entry.getBaseQty().abs());
                BigDecimal discountAmount = saleOrderEntry.getDiscountAmount().subtract(entry.getDiscountAmount().abs());
                BigDecimal amount = saleOrderEntry.getAmount().subtract(entry.getNonTaxAmount().abs());
                BigDecimal localAmount = saleOrderEntry.getLocalAmount().subtract(entry.getLocalNonTaxAmount().abs());
                BigDecimal tax = saleOrderEntry.getTax().subtract(entry.getTax().abs());
                BigDecimal localTax = saleOrderEntry.getLocalTax().subtract(entry.getLocalTax().abs());
                BigDecimal taxAmount = saleOrderEntry.getTaxAmount().subtract(entry.getAmount().abs());
                BigDecimal localTaxAmount = saleOrderEntry.getLocalTaxAmount().subtract(entry.getLocalAmount().abs());
                pmUpdateEntry.setBigDecimal(1, qty);
                pmUpdateEntry.setBigDecimal(2, assistQty);
                pmUpdateEntry.setBigDecimal(3, baseQty);
                pmUpdateEntry.setBigDecimal(4, discountAmount);
                pmUpdateEntry.setBigDecimal(5, amount);
                pmUpdateEntry.setBigDecimal(6, localAmount);
                pmUpdateEntry.setBigDecimal(7, tax);
                pmUpdateEntry.setBigDecimal(8, localTax);
                pmUpdateEntry.setBigDecimal(9, taxAmount);
                pmUpdateEntry.setBigDecimal(10, localTaxAmount);
                pmUpdateEntry.setString(11, entry.getSaleOrderEntry());
                pmUpdateEntry.addBatch();
            }
            pmUpdateEntry.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Statement)pmUpdateEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reWriteSaleIssueBill(CoreBaseCollection infos, Connection conn, Context ctx) throws BOSException, EASBizException, SQLException {
        String updateSql = "update T_IM_SaleIssueEntry set FSaleOrderNumber = ?, FSaleOrderEntrySeq = ?, FSaleOrderID = ?, FSaleOrderEntryID = ?, FCoreBillTypeID = ? where fid = ?";
        PreparedStatement pmUpdate = null;
        try {
            pmUpdate = conn.prepareStatement("update T_IM_SaleIssueEntry set FSaleOrderNumber = ?, FSaleOrderEntrySeq = ?, FSaleOrderID = ?, FSaleOrderEntryID = ?, FCoreBillTypeID = ? where fid = ?");
            for (int infoLoop = 0; infoLoop < infos.size(); ++infoLoop) {
                SaleOrderInfo info = (SaleOrderInfo)infos.getObject(infoLoop);
                for (int entryLoop = 0; entryLoop < info.getEntries().size(); ++entryLoop) {
                    SaleOrderEntryInfo entry = info.getEntries().get(entryLoop);
                    pmUpdate.setString(1, info.getNumber());
                    pmUpdate.setInt(2, entry.getSeq());
                    pmUpdate.setString(3, info.getId().toString());
                    pmUpdate.setString(4, entry.getId().toString());
                    pmUpdate.setString(5, "510b6503-0105-1000-e000-0113c0a812fd463ED552");
                    pmUpdate.setString(6, entry.getSourceBillEntryId());
                    pmUpdate.addBatch();
                }
            }
            pmUpdate.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Statement)pmUpdate);
        }
    }

    private void fillAndSaveSystemBill(CoreBaseCollection infos, Context ctx) throws BOSException, EASBizException {
        String numberFlag = "";
        for (int infoLoop = 0; infoLoop < infos.size(); ++infoLoop) {
            SaleOrderInfo info = (SaleOrderInfo)infos.getObject(infoLoop);
            numberFlag = numberFlag + "*";
            info.setNumber(numberFlag + info.getNumber());
            info.setIsSysBill(true);
            BigDecimal totalAmount = SysConstant.BIGZERO;
            BigDecimal totalLocalAmount = SysConstant.BIGZERO;
            BigDecimal totalTaxAmount = SysConstant.BIGZERO;
            BigDecimal totalLocalTaxAmount = SysConstant.BIGZERO;
            BigDecimal totalTax = SysConstant.BIGZERO;
            for (int entryLoop = 0; entryLoop < info.getEntries().size(); ++entryLoop) {
                SaleOrderEntryInfo entry = info.getEntries().get(entryLoop);
                entry.setSeq(entryLoop + 1);
                totalAmount = totalAmount.add(entry.getAmount() == null ? SysConstant.BIGZERO : entry.getAmount());
                totalLocalAmount = totalLocalAmount.add(entry.getLocalAmount() == null ? SysConstant.BIGZERO : entry.getLocalAmount());
                totalTaxAmount = totalTaxAmount.add(entry.getTaxAmount() == null ? SysConstant.BIGZERO : entry.getTaxAmount());
                totalLocalTaxAmount = totalLocalTaxAmount.add(entry.getLocalTaxAmount() == null ? SysConstant.BIGZERO : entry.getLocalTaxAmount());
                totalTax = totalTax.add(entry.getTax() == null ? SysConstant.BIGZERO : entry.getTax());
            }
            info.setTotalAmount(totalAmount);
            info.setTotalTax(totalTax);
            info.setTotalTaxAmount(totalTaxAmount);
            info.setLocalTotalAmount(totalLocalAmount);
            info.setLocalTotalTaxAmount(totalLocalTaxAmount);
        }
        ISaleOrder iTransferOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
        iTransferOrder.handleAfterTransform("SAVE", (IObjectCollection)infos);
        iTransferOrder.addnew(infos);
    }

    private CoreBaseCollection transformSystemBillViaBotp(CoreBillBaseInfo aInvBillBaseInfo, Context ctx) throws BOSException, EASBizException {
        CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
        coreBillBaseColl.add(aInvBillBaseInfo);
        BOTMappingInfo botMappingInfo = null;
        String botpName = "SaleIssue_SaleOrder_SysOrderBill";
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='SaleIssue_SaleOrder_SysOrderBill'");
        }
        catch (Exception e) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{"SaleIssue_SaleOrder_SysOrderBill"});
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{"SaleIssue_SaleOrder_SysOrderBill"});
        }
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coreBillBaseColl, botMappingInfo);
        IObjectCollection infos = transformResult.getBills();
        CoreBaseCollection bills = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            infos.getObject(i).setString("number", aInvBillBaseInfo.getNumber());
            bills.add((CoreBaseInfo)infos.getObject(i));
        }
        return bills;
    }

    protected String checkIsStarted(Context ctx, TransactionTypeInfo tti, IObjectCollection iObjectCollection, InvBillBaseInfo aInvBillBaseInfo, boolean isNotChkTti) throws BOSException, EASBizException {
        String msg = "";
        if (aInvBillBaseInfo.isIsInitBill()) {
            return msg.toString();
        }
        InvUpdateTypeInfo invUpdateTypeInfo = null;
        try {
            invUpdateTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getDefaultInvUpdateType(tti.getId().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((isNotChkTti || invUpdateTypeInfo != null && !invUpdateTypeInfo.isIsNotUpdateInv()) && iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            String storageOrgUnitID = "";
            if (aInvBillBaseInfo.getStorageOrgUnit() != null) {
                storageOrgUnitID = aInvBillBaseInfo.getStorageOrgUnit().getId().toString();
                Vector<BOSUuid> vctSou = new Vector<BOSUuid>();
                for (int i = 0; i < iObjectCollection.size(); ++i) {
                    aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
                    if (aInvBillBaseEntryInfo.getWarehouse() == null || vctSou.contains(aInvBillBaseEntryInfo.getWarehouse().getId())) continue;
                    vctSou.add(aInvBillBaseEntryInfo.getWarehouse().getId());
                }
                Object[] warehouses = null;
                if (vctSou.size() > 0) {
                    ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
                    if (tti.getBillType() == null) {
                        ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
                        tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tti.getId()));
                    }
                    warehouses = !isNotChkTti && "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(tti.getBillType().getId().toString()) ? iso.isStarted(storageOrgUnitID, vctSou.toArray(), true) : iso.isStarted(storageOrgUnitID, vctSou.toArray(), false);
                }
                if (warehouses != null && warehouses.length > 0) {
                    IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("name"));
                    StorageOrgUnitInfo sou = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitID), sic);
                    for (int i = 0; i < warehouses.length; ++i) {
                        msg = msg + "\n" + sou.getName() + " - " + warehouses[i].toString();
                    }
                }
            }
        }
        return msg;
    }

    protected void checkEntrySourceBillForBOTP(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        if (this.isBotpBill(aInvBillBaseInfo)) {
            IObjectCollection col = aInvBillBaseInfo.getEntries();
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = null;
            String billtypeId = null;
            BillTypeInfo billtype = new BillTypeInfo();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)col.getObject(i);
                if (aInvBillBaseEntryInfo.getSourceBillType() != null) continue;
                if (billtypeId == null) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select fid from t_scm_billtype where fbostype in ").append("(select FSrcEntityID from t_bot_relation where FDestObjectID = '").append(aInvBillBaseInfo.getId().toString()).append("')");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        if (rs.next()) {
                            billtypeId = rs.getString("fid");
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                billtype.setId(BOSUuid.read(billtypeId));
                aInvBillBaseInfo.setSourceBillType(billtype);
            }
        }
    }

    protected boolean checkEntryCoreBillType(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        return true;
    }

    protected void checkMaterialPeriodValid(Context ctx, InvBillBaseInfo invBillInfo) throws BOSException, EASBizException {
        int i;
        StorageOrgUnitInfo sou = invBillInfo.getStorageOrgUnit();
        if (null == sou) {
            return;
        }
        InvBillBaseEntryInfo entry = null;
        MaterialInfo material = null;
        HashSet<String> materialIdSet = new HashSet<String>();
        IObjectCollection entryCol = this.getEntryCollection(invBillInfo);
        int size = entryCol.size();
        for (int i2 = 0; i2 < size; ++i2) {
            entry = (InvBillBaseEntryInfo)entryCol.getObject(i2);
            material = entry.getMaterial();
            if (null == material) continue;
            materialIdSet.add(material.getId().toString());
        }
        if (materialIdSet.size() <= 0) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isPeriodValid"));
        sic.add(new SelectorItemInfo("material.id"));
        entityViewInfo.setSelector(sic);
        MaterialInventoryCollection miCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(entityViewInfo);
        if (miCol == null) {
            return;
        }
        HashMap isPeriodMaterailMap = new HashMap();
        int size2 = miCol.size();
        for (i = 0; i < size2; ++i) {
            MaterialInventoryInfo materialInventory = miCol.get(i);
            if (!materialInventory.isIsPeriodValid()) continue;
            isPeriodMaterailMap.put(materialInventory.getMaterial().getId().toString(), null);
        }
        size2 = entryCol.size();
        for (i = 0; i < size2; ++i) {
            entry = (InvBillBaseEntryInfo)entryCol.getObject(i);
            material = entry.getMaterial();
            if (null == material || !isPeriodMaterailMap.containsKey(material.getId().toString()) || entry.getMfg() != null && entry.getExp() != null) continue;
            throw new InvBizException(InvBizException.MATERIAL_IS_PERIODVALID);
        }
    }

    private void checkMaterialCost(Context ctx, InvBillBaseInfo billInfo) throws EASBizException, BOSException {
        if (!this.isCheckMaterialCost()) {
            return;
        }
        InvServerUtils.checkMaterialCost(ctx, billInfo, "entry");
    }

    private void checkMaterialHasCompanyProperty(Context ctx, IObjectCollection iObjectCollection, String strStorageID) throws BOSException, EASBizException {
        ArrayList<String> al = new ArrayList<String>();
        if (iObjectCollection != null) {
            for (int i = 0; i < iObjectCollection.size(); ++i) {
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
                if (entry.getMaterial() == null) continue;
                al.add(entry.getMaterial().getId().toString());
            }
        }
        if (al.size() > 0) {
            OrgUnitCollection orgCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(strStorageID, 4, 1);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)orgCol.get(0);
            SCMServerUtils.checkMaterialFiProperty((Context)ctx, al, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        }
    }

    private void delBuildOrderOrReturnBill(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
        if (tti == null) {
            return;
        }
        if (!this.isDeleteOrderOrRetBill(ctx, aInvBillBaseInfo)) {
            return;
        }
        boolean isReversed = aInvBillBaseInfo.isIsReversed();
        String invTableName = null;
        String invEntryName = null;
        String ordTableName = null;
        String ordEntryName = null;
        BillTypeInfo bti = aInvBillBaseInfo.getBillType();
        if (tti.getBillType() == null || tti.getRiType() == null) {
            ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
            tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tti.getId()), SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
        }
        String transType = null;
        int bizDirection = 0;
        if (tti.getRiType() != null && tti.getRiType().getBizDirection() != null) {
            bizDirection = tti.getRiType().getBizDirection().getValue();
        }
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(bti.getId().toString()) && 1 == bizDirection) {
            transType = "pur";
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(bti.getId().toString()) && 1 == bizDirection) {
            transType = "sal";
        } else if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(bti.getId().toString()) && -1 == bizDirection) {
            transType = "purRet";
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(bti.getId().toString()) && -1 == bizDirection) {
            transType = "salRet";
        } else {
            return;
        }
        if (transType.equals("pur")) {
            invTableName = "T_IM_PurInWarehsBill";
            invEntryName = "T_IM_PurInwarehsEntry";
            ordTableName = "T_SM_PurOrder";
            ordEntryName = "T_SM_PurOrderEntry";
        } else if (transType.equals("sal")) {
            invTableName = "T_IM_SaleIssueBill";
            invEntryName = "T_IM_SaleIssueEntry";
            ordTableName = "T_SD_SaleOrder";
            ordEntryName = "T_SD_SaleOrderEntry";
        } else if (transType.equals("purRet")) {
            invTableName = "T_IM_PurInWarehsBill";
            invEntryName = "T_IM_PurInwarehsEntry";
            ordTableName = "T_SM_PurReturns";
            ordEntryName = "T_SM_PurReturnsEntry";
        }
        try {
            IRowSet rs = null;
            IRowSet rsSaleIssuer = null;
            if (transType.equals("sal")) {
                if (!isReversed) {
                    StringBuffer stringBuff = new StringBuffer();
                    stringBuff.append("select FSaleOrderID from T_IM_SaleIssueEntry where FParentID = '");
                    stringBuff.append(pk.toString());
                    stringBuff.append("'");
                    rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff.toString());
                    StringBuffer strSaleIssue = new StringBuffer();
                    HashSet<String> soIds = new HashSet<String>();
                    while (rs.next()) {
                        if (rs.getString("FSaleOrderID") == null) continue;
                        soIds.add(rs.getString("FSaleOrderID"));
                    }
                    String ids = InvServerUtils.getSqlIdsStrForColl(soIds);
                    strSaleIssue.setLength(0);
                    strSaleIssue.append("select bill.FID from T_IM_SaleIssueBill bill ");
                    strSaleIssue.append(" inner join T_IM_SaleIssueEntry entry on bill.FID = entry.FParentID ");
                    strSaleIssue.append(" where entry.FSaleOrderID in (").append(ids).append(")");
                    strSaleIssue.append(" and bill.FBaseStatus = 4");
                    rsSaleIssuer = DbUtil.executeQuery((Context)ctx, (String)strSaleIssue.toString());
                    if (rsSaleIssuer.next()) {
                        return;
                    }
                    if (ids != null && ids.length() > 0) {
                        String delOrderEntrySql = "delete " + ordEntryName + " where Fparentid in (" + ids + " )";
                        DbUtil.execute((Context)ctx, (String)delOrderEntrySql);
                        String delOrderBillSql = "delete " + ordTableName + " where Fid in (" + ids + " )";
                        DbUtil.execute((Context)ctx, (String)delOrderBillSql);
                        String sql = this.getUpdateClearSql(transType, invTableName, invEntryName, pk.toString());
                        DbUtil.execute((Context)ctx, (String)sql);
                    }
                }
            } else if (transType.equals("pur")) {
                StringBuffer stringBuff = new StringBuffer();
                stringBuff.append("select distinct FPurOrderID from T_IM_PurInwarehsEntry where FParentID = '");
                stringBuff.append(pk.toString());
                stringBuff.append("'");
                if (!isReversed) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff.toString());
                    Vector<String> vOrderID = new Vector<String>(0);
                    while (rs.next()) {
                        vOrderID.add(rs.getString("FPurOrderID"));
                    }
                    if (vOrderID.size() > 0) {
                        String inid = SCMServerUtils.getInID(vOrderID);
                        String delOrderEntrySql = "delete " + ordEntryName + " where Fparentid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderEntrySql);
                        String delOrderBillSql = "delete " + ordTableName + " where Fid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderBillSql);
                        String sql = this.getUpdateClearSql(transType, invTableName, invEntryName, pk.toString());
                        DbUtil.execute((Context)ctx, (String)sql);
                    }
                }
            } else if (transType.equals("purRet")) {
                StringBuffer stringBuff = new StringBuffer();
                stringBuff.append("select distinct FPurOrderID from T_IM_PurInwarehsEntry where FParentID = '");
                stringBuff.append(pk.toString());
                stringBuff.append("'");
                if (!isReversed) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff.toString());
                    Vector<String> vOrderID = new Vector<String>(0);
                    while (rs.next()) {
                        vOrderID.add(rs.getString("FPurOrderID"));
                    }
                    if (vOrderID.size() > 0) {
                        String inid = SCMServerUtils.getInID(vOrderID);
                        String delOrderEntrySql = "delete " + ordEntryName + " where Fparentid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderEntrySql);
                        String delOrderBillSql = "delete " + ordTableName + " where Fid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderBillSql);
                        String sql = this.getUpdateClearSql(transType, invTableName, invEntryName, pk.toString());
                        DbUtil.execute((Context)ctx, (String)sql);
                    }
                }
            } else if (transType.equals("salRet")) {
                this.updateSoureBill(ctx, pk, aInvBillBaseInfo, false);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void delMaterialSN(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        InvBillBaseInfo info = (InvBillBaseInfo)model;
        IObjectCollection entries = (IObjectCollection)info.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)info.get("entries");
        }
        if (entries == null) {
            return;
        }
        Vector<String> vecNew = new Vector<String>();
        for (int i = 0; i < entries.size(); ++i) {
            if (entries.getObject(i) == null || ((InvBillBaseEntryInfo)entries.getObject(i)).getId() == null) continue;
            vecNew.add(((InvBillBaseEntryInfo)entries.getObject(i)).getId().toString());
        }
        HashSet<String> vecDel = new HashSet<String>();
        if (info.getId() != null) {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("entry.id"));
            InvBillBaseInfo oldInfo = this.getInvBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), sc);
            if (oldInfo != null && oldInfo.get("entry") != null) {
                IObjectCollection oldEntries = (IObjectCollection)oldInfo.get("entry");
                String tempOldID = "";
                for (int i = 0; i < oldEntries.size(); ++i) {
                    if (oldEntries.getObject(i) == null || ((InvBillBaseEntryInfo)oldEntries.getObject(i)).getId() == null || vecNew.contains(tempOldID = ((InvBillBaseEntryInfo)oldEntries.getObject(i)).getId().toString())) continue;
                    vecDel.add(tempOldID);
                }
            }
        }
        if (vecDel.size() > 0) {
            IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billEntryID", vecDel, CompareType.INCLUDE));
            iMaterialSerialNumber.delete(filterInfo);
        }
    }

    private CompanyOrgUnitInfo getComanyOrgUnit(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        IObjectCollection iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entry");
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
            if (aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
                throw new InvBizException(InvBizException.AP_NOCOMPANY);
            }
            if (aCompanyOrgUnitInfo.getBaseCurrency() == null || aCompanyOrgUnitInfo.getBaseCurrency().getId() == null) {
                ICompanyOrgUnit icou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("baseCurrency.id"));
                sic.add(new SelectorItemInfo("baseCurrency.precision"));
                aCompanyOrgUnitInfo = icou.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getId()));
            }
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    private String getInsertOrderBillSql(String transType, String invTableName, String invEntryName, String ordTableName, String ordEntryName, String number, String billID, String orderBillID, String billTypeID, String bizTypeID, String orgID, String groupID, String personID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO " + ordTableName + "(");
        stringBuffer.append("FID,");
        stringBuffer.append("FCreatorID,");
        stringBuffer.append("FCreateTime,");
        stringBuffer.append("FModifierID,");
        stringBuffer.append("FModificationTime,");
        stringBuffer.append("FLastUpdateUserID,");
        stringBuffer.append("FLastUpdateTime,");
        stringBuffer.append("FControlUnitID,");
        stringBuffer.append("FNumber,");
        stringBuffer.append("FBizDate,");
        stringBuffer.append("FHandlerID,");
        stringBuffer.append("FAuditorID,");
        stringBuffer.append("FAuditTime,");
        stringBuffer.append("FBaseStatus,");
        stringBuffer.append("FBillTypeID,");
        stringBuffer.append("FBizTypeID,");
        stringBuffer.append("FYear,");
        stringBuffer.append("FPeriod,");
        stringBuffer.append("FCurrencyID,");
        stringBuffer.append("FExchangeRate,");
        stringBuffer.append("FAdminOrgUnitID,");
        stringBuffer.append("FTotalAmount,");
        stringBuffer.append("FTotalTax,");
        stringBuffer.append("FTotalTaxAmount,");
        stringBuffer.append("FIsSysBill,");
        if (transType.equals("pur")) {
            stringBuffer.append("FCompanyOrgUnitID,");
            stringBuffer.append("FVersion,");
            stringBuffer.append("FPaymentTypeID,");
            stringBuffer.append("FSupplierID,");
            stringBuffer.append("FSupplierAddress,");
            stringBuffer.append("FSettlementTypeID,");
            stringBuffer.append("FCashDiscountID,");
            stringBuffer.append("FIsInnerSale,");
            stringBuffer.append("FIsDirectSend,");
            stringBuffer.append("FPurchaseOrgUnitID,");
            stringBuffer.append("FPurchaseGroupID,");
            stringBuffer.append("FIsInTax,");
            stringBuffer.append("FIsPriceInTax,");
            stringBuffer.append("FConvertMode,");
            stringBuffer.append("FPurchasePersonID)");
        } else if (transType.equals("sal")) {
            stringBuffer.append("FCompanyOrgUnitID,");
            stringBuffer.append("FPaymentTypeID,");
            stringBuffer.append("FDeliveryTypeID,");
            stringBuffer.append("FOrderCustomerID,");
            stringBuffer.append("FSendAddress,");
            stringBuffer.append("FSettlementTypeID,");
            stringBuffer.append("FCashDiscountID,");
            stringBuffer.append("FIsInnerSale,");
            stringBuffer.append("FSaleOrgUnitID,");
            stringBuffer.append("FSaleGroupID,");
            stringBuffer.append("FSalePersonID)");
        } else if (transType.equals("purRet")) {
            stringBuffer.append("FSupplierID,");
            stringBuffer.append("FPurchaseOrgUnitID,");
            stringBuffer.append("FPurchaseGroupID,");
            stringBuffer.append("FPurchasePersonID,");
            stringBuffer.append("FConvertMode,");
            stringBuffer.append("FIsInTax)");
        }
        stringBuffer.append("SELECT DISTINCT ");
        stringBuffer.append("'" + orderBillID + "',");
        stringBuffer.append("A.FCreatorID,");
        stringBuffer.append("A.FCreateTime,");
        stringBuffer.append("A.FLastUpdateUserID,");
        stringBuffer.append("A.FLastUpdateTime,");
        stringBuffer.append("A.FLastUpdateUserID,");
        stringBuffer.append("A.FLastUpdateTime,");
        stringBuffer.append("A.FControlUnitID,");
        stringBuffer.append("'" + number + "',");
        stringBuffer.append("A.FBizDate,");
        stringBuffer.append("A.FHandlerID,");
        stringBuffer.append("A.FLastUpdateUserID,");
        stringBuffer.append("A.FLastUpdateTime,");
        stringBuffer.append("7,");
        stringBuffer.append("'" + billTypeID + "',");
        stringBuffer.append("'" + bizTypeID + "',");
        stringBuffer.append("A.FYear,");
        stringBuffer.append("A.FPeriod,");
        stringBuffer.append("A.FCurrencyID,");
        stringBuffer.append("A.FExchangeRate,");
        stringBuffer.append("A.FAdminOrgUnitID,");
        stringBuffer.append("ISNULL((SELECT SUM(FAmount) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),0),");
        stringBuffer.append("ISNULL((SELECT SUM(FTax) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),0),");
        stringBuffer.append("ISNULL((SELECT SUM(FTaxAmount) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),0),");
        stringBuffer.append("1,");
        if (transType.equals("pur")) {
            stringBuffer.append("B.FCompanyOrgUnitID,");
            stringBuffer.append("0,");
            stringBuffer.append("A.FPaymentTypeID,");
            stringBuffer.append("A.FSupplierID,");
            stringBuffer.append("(SELECT FAddress FROM T_BD_Supplier WHERE FID = A.FSupplierID),");
            stringBuffer.append("(SELECT FSettlementTypeID FROM T_BD_SupplierCompanyInfo WHERE FComOrgID = B.FCompanyOrgUnitID AND FSupplierID = A.FSupplierID),");
            stringBuffer.append("NULL,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("B.FPurchaseOrgUnitID,");
            stringBuffer.append("B.FPurchaseGroupID,");
            stringBuffer.append("A.FIsInTax,");
            stringBuffer.append("A.FIsPriceInTax,");
            stringBuffer.append("A.FConvertMode,");
            stringBuffer.append("B.FPurchasePersonID");
        } else if (transType.equals("sal")) {
            stringBuffer.append("B.FCompanyOrgUnitID,");
            stringBuffer.append("A.FPaymentTypeID,");
            stringBuffer.append("'521733ca-0105-1000-e000-00e2c0a8123362E9EE3F',");
            stringBuffer.append("A.FCustomerID,");
            stringBuffer.append("(SELECT FAddress FROM T_BD_Customer WHERE FID = A.FCustomerID),");
            stringBuffer.append("(SELECT FSettlementTypeID FROM T_BD_CustomerCompanyInfo WHERE FComOrgID = B.FCompanyOrgUnitID AND FCustomerID = A.FCustomerID),");
            stringBuffer.append("NULL,");
            stringBuffer.append("(CASE WHEN (SELECT FIsInternalCompany FROM T_BD_Customer WHERE FID = A.FCustomerID) = 1 THEN 1 ELSE 0 END),");
            stringBuffer.append("B.FSaleOrgUnitID,");
            stringBuffer.append("B.FSaleGroupID,");
            stringBuffer.append("B.FSalePersonID");
        } else if (transType.equals("purRet")) {
            stringBuffer.append("A.FSupplierID,");
            stringBuffer.append("B.FPurchaseOrgUnitID,");
            stringBuffer.append("B.FPurchaseGroupID,");
            stringBuffer.append("B.FPurchasePersonID,");
            stringBuffer.append("A.FConvertMode,");
            stringBuffer.append("A.FIsInTax");
        }
        stringBuffer.append(" FROM " + invTableName + " A");
        stringBuffer.append(" INNER JOIN " + invEntryName + " B ON A.FID = B.FParentID");
        stringBuffer.append(" WHERE A.FID = '" + billID + "'");
        if (transType.equals("pur")) {
            if (orgID == null) {
                stringBuffer.append(" AND B.FPurchaseOrgUnitID is null");
            } else {
                stringBuffer.append(" AND B.FPurchaseOrgUnitID = '" + orgID + "'");
            }
            if (groupID == null) {
                stringBuffer.append(" AND B.FPurchaseGroupID is null");
            } else {
                stringBuffer.append(" AND B.FPurchaseGroupID = '" + groupID + "'");
            }
            if (personID == null) {
                stringBuffer.append(" AND B.FPurchasePersonID is null ;");
            } else {
                stringBuffer.append(" AND B.FPurchasePersonID = '" + personID + "';");
            }
        } else if (transType.equals("sal")) {
            if (orgID == null) {
                stringBuffer.append(" AND B.FSaleOrgUnitID is null");
            } else {
                stringBuffer.append(" AND B.FSaleOrgUnitID = '" + orgID + "'");
            }
            if (groupID == null) {
                stringBuffer.append(" AND B.FSaleGroupID is null");
            } else {
                stringBuffer.append(" AND B.FSaleGroupID = '" + groupID + "'");
            }
            if (personID == null) {
                stringBuffer.append(" AND B.FSalePersonID is null;");
            } else {
                stringBuffer.append(" AND B.FSalePersonID = '" + personID + "';");
            }
        } else if (transType.equals("purRet")) {
            if (orgID == null) {
                stringBuffer.append(" AND B.FPurchaseOrgUnitID is null");
            } else {
                stringBuffer.append(" AND B.FPurchaseOrgUnitID = '" + orgID + "'");
            }
            if (groupID == null) {
                stringBuffer.append(" AND B.FPurchaseGroupID is null");
            } else {
                stringBuffer.append(" AND B.FPurchaseGroupID = '" + groupID + "'");
            }
            if (personID == null) {
                stringBuffer.append(" AND B.FPurchasePersonID is null ;");
            } else {
                stringBuffer.append(" AND B.FPurchasePersonID = '" + personID + "';");
            }
        }
        return stringBuffer.toString();
    }

    private String getInsertOrderEntrySql(String transType, String invTableName, String invEntryName, String ordEntryName, String bosType, String billID, String orderBillID, int precision, String orgID, String groupID, String personID) {
        String taxRate = null;
        taxRate = transType.equals("pur") || transType.equals("purRet") ? "Decimal(ISNULL((SELECT ISNULL(FTaxRate/100, 0) FROM T_BD_SUPPLIER WHERE FID = (SELECT FSupplierID FROM T_IM_PurInWarehsBill WHERE FID = '" + billID + "')),0),21,8)" : "Decimal(ISNULL((SELECT ISNULL(FTaxRate/100, 0) FROM T_BD_MaterialSales WHERE FMaterialID = A.FMaterialID AND FOrgUnit = A.FSaleOrgUnitID),0),21,8)";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO " + ordEntryName + "(");
        stringBuffer.append("FID,");
        stringBuffer.append("FSeq,");
        stringBuffer.append("FAssCoefficient,");
        stringBuffer.append("FBaseStatus,");
        stringBuffer.append("FMaterialID,");
        stringBuffer.append("FUnitID,");
        stringBuffer.append("FBaseUnitID,");
        stringBuffer.append("FAssistUnitID,");
        stringBuffer.append("FIsPresent,");
        stringBuffer.append("FAssistPropertyID,");
        stringBuffer.append("FQty,");
        stringBuffer.append("FStorageOrgUnitID,");
        stringBuffer.append("FCompanyOrgUnitID,");
        stringBuffer.append("FAssistQty,");
        stringBuffer.append("FBaseQty,");
        stringBuffer.append("FRemark,");
        stringBuffer.append("FParentID,");
        if (transType.equals("pur")) {
            stringBuffer.append("FVersion,");
            stringBuffer.append("FRequestOrgUnitID,");
            stringBuffer.append("FTotalUnReturnBaseQty,");
            stringBuffer.append("FDeliveryDate,");
            stringBuffer.append("FCloseDate,");
            stringBuffer.append("FTaxPrice,");
            stringBuffer.append("FActualTaxPrice,");
            stringBuffer.append("FTaxAmount,");
            stringBuffer.append("FPrice,");
            stringBuffer.append("FTaxRate,");
            stringBuffer.append("FAmount,");
            stringBuffer.append("FTax,");
            stringBuffer.append("FLocalAmount,");
            stringBuffer.append("FLocalTax,");
            stringBuffer.append("FLocalTaxAmount,");
            stringBuffer.append("FPREPAYMENT,");
            stringBuffer.append("FDemandQty,");
            stringBuffer.append("FTotalUnReceiveBaseQty,");
            stringBuffer.append("FTotalUnReceiveQty,");
            stringBuffer.append("FDiscountRate,");
            stringBuffer.append("FDiscountAmount,");
            stringBuffer.append("FActualPrice, ");
            stringBuffer.append("FPRERECEIVED, ");
            stringBuffer.append("FUNPRERECEIVEDAM) ");
        } else if (transType.equals("sal")) {
            stringBuffer.append("FDeliveryCustomerID,");
            stringBuffer.append("FReceiveCustomerID,");
            stringBuffer.append("FPaymentCustomerID,");
            stringBuffer.append("FDiscountType,");
            stringBuffer.append("FTotalUnReturnBaseQty,");
            stringBuffer.append("FDeliveryDate,");
            stringBuffer.append("FWarehouseID,");
            stringBuffer.append("FTaxPrice,");
            stringBuffer.append("FActualTaxPrice,");
            stringBuffer.append("FTaxAmount,");
            stringBuffer.append("FPrice,");
            stringBuffer.append("FTaxRate,");
            stringBuffer.append("FAmount,");
            stringBuffer.append("FTax,");
            stringBuffer.append("FSendDate,");
            stringBuffer.append("FLocalAmount) ");
        } else if (transType.equals("purRet")) {
            stringBuffer.append("FClosedDate,");
            stringBuffer.append("FWarehouseID,");
            stringBuffer.append("FLocationID,");
            stringBuffer.append("FLot,");
            stringBuffer.append("FUninvoicedQty,");
            stringBuffer.append("FUninvoicedBaseQty,");
            stringBuffer.append("FUnreturnedQty,");
            stringBuffer.append("FUnReturnedBaseQty,");
            stringBuffer.append("FReturnedQty,");
            stringBuffer.append("FReturnedBaseQty,");
            stringBuffer.append("FInvoicedQty,");
            stringBuffer.append("FInvoicedAmount,");
            stringBuffer.append("FInvoicedBaseQty,");
            stringBuffer.append("FTotalReturnAmt,");
            stringBuffer.append("FLocalAmount,");
            stringBuffer.append("FLocalTax,");
            stringBuffer.append("FLocalTaxAmount,");
            stringBuffer.append("FTotalInvoicedAmt,");
            stringBuffer.append("FReturnsDate,");
            stringBuffer.append("FTaxPrice,");
            stringBuffer.append("FTaxAmount,");
            stringBuffer.append("FPrice,");
            stringBuffer.append("FTaxRate,");
            stringBuffer.append("FAmount,");
            stringBuffer.append("FTax) ");
        }
        stringBuffer.append("SELECT ");
        stringBuffer.append("NEWBOSID('" + bosType + "'),");
        stringBuffer.append("A.FSeq,");
        stringBuffer.append("0,");
        stringBuffer.append("7,");
        stringBuffer.append("A.FMaterialID,");
        stringBuffer.append("A.FUnitID,");
        stringBuffer.append("A.FBaseUnitID,");
        stringBuffer.append("A.FAssistUnitID,");
        stringBuffer.append("A.FIsPresent,");
        stringBuffer.append("A.FAssistPropertyID,");
        stringBuffer.append("ABS(A.FQty),");
        stringBuffer.append("C.FStorageOrgUnitID,");
        stringBuffer.append("A.FCompanyOrgUnitID,");
        stringBuffer.append("ABS(A.FAssistQty),");
        stringBuffer.append("ABS(A.FBaseQty),");
        stringBuffer.append("A.FRemark,");
        stringBuffer.append("'" + orderBillID + "',");
        if (transType.equals("pur")) {
            stringBuffer.append("0,");
            stringBuffer.append("C.FStorageOrgUnitID,");
            stringBuffer.append("A.FBaseQty,");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("A.FTaxPrice,");
            stringBuffer.append("A.FActualTaxPrice,");
            stringBuffer.append("A.FTaxAmount,");
            stringBuffer.append("A.FPrice,");
            stringBuffer.append("A.FTaxRate,");
            stringBuffer.append("A.FAmount,");
            stringBuffer.append("A.FTax,");
            stringBuffer.append("A.FPurchaseCost,");
            stringBuffer.append("A.FLocalTax,");
            stringBuffer.append("A.FLocalTaxAmount,");
            stringBuffer.append("0,");
            stringBuffer.append("A.FQty,");
            stringBuffer.append("A.FBaseQty,");
            stringBuffer.append("A.FQty,");
            stringBuffer.append("A.FDiscountRate,");
            stringBuffer.append("A.FDiscountAmount,");
            stringBuffer.append("A.FActualPrice,");
            stringBuffer.append("0,");
            stringBuffer.append("0");
        } else if (transType.equals("sal")) {
            stringBuffer.append("C.FCustomerID,");
            stringBuffer.append("A.FBalanceCustomerID,");
            stringBuffer.append("A.FPaymentCustomerID,");
            stringBuffer.append("-1,");
            stringBuffer.append("A.FBaseQty,");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("A.FWarehouseID,");
            stringBuffer.append("A.FPrice,");
            stringBuffer.append("A.FPrice,");
            stringBuffer.append("ROUND(A.FAmount," + precision + "),");
            stringBuffer.append("ROUND(Decimal(A.FPrice / (1 + " + taxRate + "),21,8),B.FPricePrecision),");
            stringBuffer.append(taxRate + " * 100,");
            stringBuffer.append("ROUND(Decimal(A.FAmount / (1 + " + taxRate + "),17,4)," + precision + "),");
            stringBuffer.append("ROUND(A.FAmount," + precision + ") - ROUND(Decimal(A.FAmount / (1 + " + taxRate + "),17,4)," + precision + "),");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("ROUND(Decimal(A.FAmount / (1 + " + taxRate + "),17,4)," + precision + ")");
        } else if (transType.equals("purRet")) {
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("A.FWarehouseID,");
            stringBuffer.append("A.FLocationID,");
            stringBuffer.append("A.FLot,");
            stringBuffer.append("ABS(A.FQty),");
            stringBuffer.append("ABS(A.FBaseQty),");
            stringBuffer.append("ABS(A.FQty),");
            stringBuffer.append("ABS(A.FBaseQty),");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("A.FPurchaseCost,");
            stringBuffer.append("A.FLocalTax,");
            stringBuffer.append("A.FLocalTaxAmount,");
            stringBuffer.append("0,");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("A.FActualTaxPrice,");
            stringBuffer.append("A.FTaxAmount,");
            stringBuffer.append("A.FActualPrice,");
            stringBuffer.append("A.FTaxRate,");
            stringBuffer.append("A.FAmount,");
            stringBuffer.append("A.FTax");
        }
        stringBuffer.append(" FROM " + invEntryName + " A");
        stringBuffer.append(" INNER JOIN T_BD_Material B ON A.FMaterialID = B.FID ");
        stringBuffer.append(" LEFT JOIN ").append(invTableName).append(" C ON C.FID = A.FParentID ");
        stringBuffer.append(" WHERE A.FParentID = '" + billID + "'");
        if (transType.equals("sal")) {
            if (orgID == null || orgID.equals("")) {
                stringBuffer.append(" And A.FSaleOrgUnitID is null");
            } else {
                stringBuffer.append(" And A.FSaleOrgUnitID ='" + orgID + "'");
            }
            if (groupID == null || groupID.equals("")) {
                stringBuffer.append(" And A.FSaleGroupID is null");
            } else {
                stringBuffer.append(" And A.FSaleGroupID ='" + groupID + "'");
            }
            if (personID == null || personID.equals("")) {
                stringBuffer.append(" And A.FSalePersonID is null");
            } else {
                stringBuffer.append(" And A.FSalePersonID ='" + personID + "'");
            }
        } else if (transType.equals("pur") || transType.equals("purRet")) {
            if (orgID == null || orgID.equals("")) {
                stringBuffer.append(" And A.FPurchaseOrgUnitID is null");
            } else {
                stringBuffer.append(" And A.FPurchaseOrgUnitID ='" + orgID + "'");
            }
            if (groupID == null || groupID.equals("")) {
                stringBuffer.append(" And A.FPurchaseGroupID is null");
            } else {
                stringBuffer.append(" And A.FPurchaseGroupID ='" + groupID + "'");
            }
            if (personID == null || personID.equals("")) {
                stringBuffer.append(" And A.FPurchasePersonID is null");
            } else {
                stringBuffer.append(" And A.FPurchasePersonID ='" + personID + "'");
            }
        }
        return stringBuffer.toString();
    }

    private ArrayList getPurOrdersID(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo, String transType) throws BOSException, EASBizException {
        ArrayList<String> arrayList = new ArrayList<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.purOrder"));
        PurInWarehsBillInfo purInfo = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillInfo(pk, sic);
        PurInWarehsEntryCollection entryCollection = purInfo.getEntry();
        if (entryCollection != null) {
            for (int index = 0; index < entryCollection.size(); ++index) {
                String purOrderID = entryCollection.get(index).getPurOrder();
                if (arrayList.contains(purOrderID)) continue;
                arrayList.add(purOrderID);
            }
        }
        return arrayList;
    }

    private String getUpdateClearSql(String transType, String invTableName, String invEntryName, String billId) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE " + invEntryName + " SET");
        if (transType.equals("pur")) {
            stringBuffer.append(" FPurOrderNumber = null,FPurOrderEntrySeq = null,FPurOrderID = null,FPurOrderEntryID = null,FCoreBillTypeID  = null ");
        } else if (transType.equals("sal")) {
            stringBuffer.append(" FSaleOrderNumber = null,FSaleOrderEntrySeq = null,FSaleOrderID = null,FSaleOrderEntryID = null,FCoreBillTypeID = null ");
        } else {
            stringBuffer.append(" FPurOrderNumber = null,FPurOrderEntrySeq = null,FPurOrderID = null,FPurOrderEntryID = null,FCoreBillTypeID = null ");
        }
        stringBuffer.append(" WHERE " + invEntryName + ".FParentID = '" + billId + "'");
        if (transType.equals("purRet")) {
            stringBuffer.append(" and " + invEntryName + ".FSourceBillEntryID is null");
        }
        return stringBuffer.toString();
    }

    private String getUpdateSql(Context ctx, String transType, String invTableName, String invEntryName, String ordTableName, String ordEntryName, String orderBillID, String billID, String tempTable) throws BOSException, EASBizException {
        StringBuffer stringBuffer = new StringBuffer();
        if (transType.equals("pur")) {
            stringBuffer.append("insert into ").append(tempTable).append(" ");
            stringBuffer.append("SELECT A.FNumber, B.FSeq, A.FID, B.FID,'");
            stringBuffer.append("510b6503-0105-1000-e000-010bc0a812fd463ED552");
            stringBuffer.append("', c.fid FROM " + ordTableName + " A INNER JOIN " + ordEntryName + " B ON A.FID = B.FParentID ");
            stringBuffer.append(" INNER JOIN " + invEntryName + " c ON c.FSeq = B.FSeq");
            stringBuffer.append(" WHERE A.FID = '").append(orderBillID).append("' ");
            stringBuffer.append("AND c.FParentID='").append(billID).append("' ;");
            stringBuffer.append("UPDATE " + invEntryName + " SET ");
            stringBuffer.append("(FPurOrderNumber, FPurOrderEntrySeq,  ");
            stringBuffer.append("FPurOrderID, FPurOrderEntryID, FCoreBillTypeID) = ");
            stringBuffer.append("(SELECT FSaleOrderNumber, FSaleOrderEntrySeq, FSaleOrderID, ");
            stringBuffer.append("FSaleOrderEntryID, FCoreBillTypeID FROM  ").append(tempTable);
            stringBuffer.append(" t WHERE t.FEntryID=" + invEntryName + ".FID);");
        } else if (transType.equals("sal")) {
            stringBuffer.append("insert into ").append(tempTable).append(" ");
            stringBuffer.append("SELECT A.FNumber, B.FSeq, A.FID, B.FID,'");
            stringBuffer.append("510b6503-0105-1000-e000-0113c0a812fd463ED552");
            stringBuffer.append("',c.fid FROM " + ordTableName + " A INNER JOIN " + ordEntryName + " B ON A.FID = B.FParentID ");
            stringBuffer.append(" INNER JOIN " + invEntryName + " c ON c.FSeq = B.FSeq");
            stringBuffer.append(" WHERE A.FID = '").append(orderBillID).append("' ");
            stringBuffer.append("AND c.FParentID='").append(billID).append("' ;");
            stringBuffer.append("UPDATE " + invEntryName + " SET ");
            stringBuffer.append("(FSaleOrderNumber, FSaleOrderEntrySeq,  ");
            stringBuffer.append("FSaleOrderID, FSaleOrderEntryID, FCoreBillTypeID) = ");
            stringBuffer.append("(SELECT FSaleOrderNumber, FSaleOrderEntrySeq, FSaleOrderID, ");
            stringBuffer.append("FSaleOrderEntryID, FCoreBillTypeID FROM  ").append(tempTable);
            stringBuffer.append(" t WHERE t.FEntryID=" + invEntryName + ".FID);");
        } else if ("purRet".equals(transType)) {
            stringBuffer.append("insert into ").append(tempTable).append(" ");
            stringBuffer.append("SELECT A.FNumber, B.FSeq, A.FID, B.FID,'");
            stringBuffer.append("50957179-0105-1000-e006-6152c0a812fd463ED552");
            stringBuffer.append("',c.fid FROM " + ordTableName + " A INNER JOIN " + ordEntryName + " B ON A.FID = B.FParentID ");
            stringBuffer.append(" INNER JOIN " + invEntryName + " c ON c.FSeq = B.FSeq");
            stringBuffer.append(" WHERE A.FID = '").append(orderBillID).append("' ");
            stringBuffer.append("AND c.FParentID='").append(billID).append("' ;");
            stringBuffer.append("UPDATE " + invEntryName + " SET ");
            stringBuffer.append("(FPurOrderNumber, FPurOrderEntrySeq,  ");
            stringBuffer.append("FPurOrderID, FPurOrderEntryID, FCoreBillTypeID) = ");
            stringBuffer.append("(SELECT FSaleOrderNumber, FSaleOrderEntrySeq, FSaleOrderID, ");
            stringBuffer.append("FSaleOrderEntryID, FCoreBillTypeID FROM  ").append(tempTable);
            stringBuffer.append(" t WHERE t.FEntryID=" + invEntryName + ".FID);");
        } else {
            stringBuffer.append("insert into ").append(tempTable).append(" ");
            stringBuffer.append("SELECT A.FNumber, B.FSeq, A.FID, B.FID,'");
            stringBuffer.append("510b6503-0105-1000-e000-010bc0a812fd463ED552");
            stringBuffer.append("',c.fid FROM " + ordTableName + " A INNER JOIN " + ordEntryName + " B ON A.FID = B.FParentID ");
            stringBuffer.append(" INNER JOIN " + invEntryName + " c ON c.FSeq = B.FSeq");
            stringBuffer.append(" WHERE A.FID = '").append(orderBillID).append("' ");
            stringBuffer.append("AND c.FParentID='").append(billID).append("' ;");
            stringBuffer.append("UPDATE " + invEntryName + " SET ");
            stringBuffer.append("(FPurOrderNumber, FPurOrderEntrySeq,  ");
            stringBuffer.append("FPurOrderID, FPurOrderEntryID, FCoreBillTypeID) = ");
            stringBuffer.append("(SELECT FSaleOrderNumber, FSaleOrderEntrySeq, FSaleOrderID, ");
            stringBuffer.append("FSaleOrderEntryID, FCoreBillTypeID FROM  ").append(tempTable);
            stringBuffer.append(" t WHERE t.FEntryID=" + invEntryName + ".FID);");
        }
        return stringBuffer.toString();
    }

    protected void insertLots(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
        if (tti == null) {
            return;
        }
        if (tti.getBillType() == null || tti.getRiType().getBizDirection() == null) {
            ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
            tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tti.getId()), SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
        }
        String billTypeID = tti.getBillType().getId().toString();
        int bizDerection = tti.getRiType().getBizDirection().getValue();
        if (SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) && bizDerection == 1 || SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID) && bizDerection == -1 || this.isRITypeForIndustry(ctx, (IObjectValue)aInvBillBaseInfo) && !aInvBillBaseInfo.isIsInitBill() && !aInvBillBaseInfo.isIsReversed() || "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID)) {
            if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID) && !this.isNeedInsertLots4PurRec(ctx, aInvBillBaseInfo)) {
                return;
            }
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getLocalInstance(ctx);
            if (aInvBillBaseInfo.getBillType().getId() != null) {
                ido.batchInsertData(new String[]{String.valueOf(pk)}, aInvBillBaseInfo.getBillType().getId().toString());
            }
        }
    }

    private boolean isNeedInsertLots4PurRec(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 1 from T_IM_PurReceivalBill bill").append(" inner join T_IM_PurReceivalEntry e on e.fparentid = bill.fid ").append(" inner join T_IM_InvUpdateType invupd on e.finvUpdateTypeID = invupd.fid ").append(" where invupd.FIsNotUpdateInv = 0 and bill.fid = '").append(aInvBillBaseInfo.getId().toString()).append("' ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private boolean isBuildOrderOrRetBill(Context ctx, InvBillBaseInfo ivbInfo) throws EASBizException, BOSException {
        String bizCategoryId;
        String billType = ivbInfo.getBillType().getId().toString();
        if (!"50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType) && !"50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType)) {
            return false;
        }
        BizTypeInfo bizType = ivbInfo.getBizType();
        if (bizType.getBizCategory() == null) {
            bizType = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK(bizType.getId()));
        }
        if ("+f4mYqj4xUGaNf69/HWRdqk4kCA=".equals(bizCategoryId = bizType.getBizCategory().getId().toString()) || "6LFeB81CJ0mD3wyAekUV7Kk4kCA=".equals(bizCategoryId)) {
            return false;
        }
        String coreBillEntryId = null;
        coreBillEntryId = this.getCoreBillEntryId(ctx, ivbInfo);
        return ("88a7587a-e010-497b-9f86-b8f00ab2fe72A9389020".equals(bizCategoryId) || "88a7587a-e015-497b-9f86-b8f00ab2fe72A9389020".equals(bizCategoryId)) && StringUtil.isEmpty((String)coreBillEntryId);
    }

    private boolean isDeleteOrderOrRetBill(Context ctx, InvBillBaseInfo ivbInfo) throws EASBizException, BOSException {
        String billType = ivbInfo.getBillType().getId().toString();
        if (!"50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType) && !"50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType)) {
            return false;
        }
        String bizTypeID = "";
        if (ivbInfo.getBizType() != null) {
            bizTypeID = ivbInfo.getBizType().getId().toString();
        }
        if (bizTypeID.equals("1x7KMBq4mUmpj58T4jNPqiQHQ1w=") || bizTypeID.equals("WelYLYZybUG8XkVZygC6PSQHQ1w=") || bizTypeID.equals("fJRJ3EF19QngQKjAYj0KxSQHQ1w=") || bizTypeID.equals("cm2OIC07JkyQ+M1S9LxbyCQHQ1w=") || bizTypeID.equals("gD7iVt0xekC5tFu/OjJ/dyQHQ1w=")) {
            return false;
        }
        String coreBillTypeId = "";
        String coreBillId = "";
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType)) {
            PurReturnsInfo purRet;
            PurOrderInfo purOrder;
            PurInWarehsBillInfo piInfo = (PurInWarehsBillInfo)ivbInfo;
            coreBillTypeId = piInfo.getEntry().get(0).getCoreBillTypeId();
            coreBillId = piInfo.getEntry().get(0).getPurOrder();
            if (StringUtil.isEmpty((String)coreBillId)) {
                return false;
            }
            if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeId) ? (purOrder = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderInfo((IObjectPK)new ObjectUuidPK(coreBillId))) != null && purOrder.isIsSysBill() : "50957179-0105-1000-e006-6152c0a812fd463ED552".equals(coreBillTypeId) && (purRet = PurReturnsFactory.getLocalInstance((Context)ctx).getPurReturnsInfo((IObjectPK)new ObjectUuidPK(coreBillId))) != null && purRet.isIsSysBill()) {
                return true;
            }
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType)) {
            SaleOrderInfo saleOrder;
            SaleIssueBillInfo siInfo = (SaleIssueBillInfo)ivbInfo;
            coreBillTypeId = siInfo.getEntry().get(0).getCoreBillTypeId();
            coreBillId = siInfo.getEntry().get(0).getSaleOrder();
            if (StringUtil.isEmpty((String)coreBillId)) {
                return false;
            }
            if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeId) ? (saleOrder = SaleOrderFactory.getLocalInstance((Context)ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(coreBillId))) != null && saleOrder.isIsSysBill() : "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(coreBillTypeId)) {
                return true;
            }
        }
        return false;
    }

    private void setEmptyToNullForLot(IObjectValue invBill) {
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)invBill;
        IObjectCollection entrys = this.getEntryCollection(aInvBillBaseInfo);
        boolean isHDDBill = false;
        String LOT = "lot";
        if (aInvBillBaseInfo.getBillType() != null && "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString())) {
            isHDDBill = true;
        }
        IObjectCollection entrysCollection = null;
        if (entrys != null) {
            for (int i = 0; i < entrys.size(); ++i) {
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
                if (entry.get("lot") != null && entry.get("lot").toString().trim().length() == 0) {
                    entry.setString("lot", null);
                }
                if (!isHDDBill || (entrysCollection = (IObjectCollection)entry.get("entries")) == null) continue;
                for (int m = 0; m < entrysCollection.size(); ++m) {
                    InvBillBaseEntryInfo entryDetailInfo = (InvBillBaseEntryInfo)entrysCollection.getObject(m);
                    if (entry.get("lot") == null || entry.get("lot").toString().trim().length() != 0) continue;
                    entryDetailInfo.setString("lot", null);
                }
            }
        }
    }

    private void synchronizationBillPrice(Context ctx, boolean isAddNew, InvBillBaseInfo invBillBaseInfo) throws EASBizException, BOSException {
        Connection conn = this.getConnection(ctx);
        String sourceTableBill = InvCommonUtils.getBillTableName(SCMUtils.getBillTypeNOFormBillTypeID((BillTypeInfo)invBillBaseInfo.getBillType()));
        String sourceTableEntry = InvCommonUtils.getBillEntryTableName(SCMUtils.getBillTypeNOFormBillTypeID((BillTypeInfo)invBillBaseInfo.getBillType()));
        String sourceid = invBillBaseInfo.getSourceBillId();
        try {
            if (sourceid == null) {
                StringBuffer sqlid = new StringBuffer();
                sqlid.append("select FSourceBillId from ");
                sqlid.append(sourceTableBill);
                sqlid.append(" WHERE fid='").append(invBillBaseInfo.getId()).append("'");
                JdbcRowSet rsid = (JdbcRowSet)SQLUtils.getJdbcRowSet((Connection)conn, (String)sqlid.toString());
                if (rsid.next()) {
                    sourceid = rsid.getString("FSourceBillId");
                }
            }
            if (sourceid == null) {
                throw new InvBizException(InvBizException.INV_NOSRCBILL);
            }
            JdbcRowSet rs = null;
            StringBuffer sql = new StringBuffer();
            sql.append(" select ENTRY.FID,Entry.FUnitActualCost,Entry.fseq,CURRENCY.FPrecision as fcurrencyPerision from ");
            sql.append(sourceTableEntry).append(" AS Entry");
            sql.append(" INNER JOIN T_ORG_Company AS COMPANY");
            sql.append(" ON Entry.FCompanyOrgUnitID = COMPANY.FID");
            sql.append(" INNER JOIN T_BD_Currency AS CURRENCY");
            sql.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
            sql.append(" WHERE Entry.fparentid='").append(sourceid).append("'");
            sql.append(" order by Entry.fseq");
            rs = (JdbcRowSet)SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
            IObjectCollection coll = (IObjectCollection)invBillBaseInfo.get("entry");
            while (rs.next()) {
                if (rs.getBigDecimal("FUnitActualCost") == null) continue;
                for (int j = 0; j < coll.size(); ++j) {
                    BigDecimal tax;
                    BigDecimal exchangeRate;
                    BigDecimal localTax;
                    InvBillBaseEntryInfo info;
                    InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)coll.getObject(j);
                    if (!rs.getString("FID").equals(aInvBillBaseEntryInfo.getSourceBillEntryId()) || rs.getBigDecimal("FUnitActualCost").compareTo(aInvBillBaseEntryInfo.getUnitActualCost()) == 0) continue;
                    int currencyPerision = rs.getInt("fcurrencyPerision");
                    BigDecimal diffAmt = rs.getBigDecimal("FUnitActualCost").multiply(aInvBillBaseEntryInfo.getQty()).setScale(currencyPerision, 4);
                    diffAmt = aInvBillBaseEntryInfo.getActualCost().abs().subtract(diffAmt.abs());
                    aInvBillBaseEntryInfo.setUnitActualCost(rs.getBigDecimal("FUnitActualCost"));
                    aInvBillBaseEntryInfo.setActualCost(rs.getBigDecimal("FUnitActualCost").multiply(aInvBillBaseEntryInfo.getQty()).setScale(currencyPerision, 4));
                    if (aInvBillBaseEntryInfo instanceof PurInWarehsEntryInfo) {
                        info = (PurInWarehsEntryInfo)aInvBillBaseEntryInfo;
                        ((AbstractPurInWarehsEntryInfo)info).setWrittenOffAmount(SysConstant.BIGZERO);
                        ((AbstractPurInWarehsEntryInfo)info).setUnWriteOffAmount(SysConstant.BIGZERO);
                        if (!info.isIsPresent()) {
                            ((AbstractPurInWarehsEntryInfo)info).setUnWriteOffAmount(((AbstractPurInWarehsEntryInfo)info).getPurchaseCost());
                        }
                        localTax = ((AbstractPurInWarehsEntryInfo)info).getLocalAmount().subtract(info.getActualCost());
                        localTax = localTax.setScale(currencyPerision, 4);
                        ((AbstractPurInWarehsEntryInfo)info).setLocalTax(localTax);
                        exchangeRate = ((PurInWarehsBillInfo)invBillBaseInfo).getExchangeRate();
                        if (exchangeRate == null) {
                            exchangeRate = new BigDecimal("1.00");
                        }
                        tax = localTax.divide(exchangeRate, ((AbstractPurInWarehsEntryInfo)info).getTax().scale(), 4);
                        ((AbstractPurInWarehsEntryInfo)info).setTax(tax);
                    }
                    if (aInvBillBaseEntryInfo instanceof SaleIssueEntryInfo) {
                        info = (SaleIssueEntryInfo)aInvBillBaseEntryInfo;
                        ((AbstractSaleIssueEntryInfo)info).setWrittenOffAmount(SysConstant.BIGZERO);
                        if (!info.isIsPresent()) {
                            ((AbstractSaleIssueEntryInfo)info).setUnWriteOffAmount(aInvBillBaseEntryInfo.getActualCost());
                        } else {
                            ((AbstractSaleIssueEntryInfo)info).setUnWriteOffAmount(SysConstant.BIGZERO);
                        }
                        localTax = ((AbstractSaleIssueEntryInfo)info).getLocalAmount().subtract(info.getActualCost());
                        localTax = localTax.setScale(currencyPerision, 4);
                        ((AbstractSaleIssueEntryInfo)info).setLocalTax(localTax);
                        exchangeRate = ((SaleIssueBillInfo)invBillBaseInfo).getExchangeRate();
                        if (exchangeRate == null) {
                            exchangeRate = SCMConstant.BIGDECIMAL_ONE;
                        }
                        tax = localTax.divide(exchangeRate, ((AbstractSaleIssueEntryInfo)info).getTax().scale(), 4);
                        ((AbstractSaleIssueEntryInfo)info).setTax(tax);
                    }
                    if (invBillBaseInfo.getTotalActualCost() == null) {
                        invBillBaseInfo.setTotalActualCost(SysConstant.BIGZERO);
                    }
                    if (invBillBaseInfo.getTotalStandardCost() == null) {
                        invBillBaseInfo.setTotalStandardCost(SysConstant.BIGZERO);
                    }
                    if (invBillBaseInfo.getTotalAmount() == null) {
                        invBillBaseInfo.setTotalAmount(SysConstant.BIGZERO);
                    }
                    invBillBaseInfo.setTotalActualCost(invBillBaseInfo.getTotalActualCost().subtract(diffAmt.multiply(aInvBillBaseEntryInfo.getQty().abs().divide(aInvBillBaseEntryInfo.getQty(), 0, 4))));
                    invBillBaseInfo.setTotalAmount(invBillBaseInfo.getTotalActualCost().add(invBillBaseInfo.getTotalStandardCost()));
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void updateFullReverseBillCost(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException {
        if (aInvBillBaseInfo instanceof PurInWarehsBillInfo) {
            this.updateFullReversePurInBillCost(ctx, (PurInWarehsBillInfo)aInvBillBaseInfo);
            return;
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk1 = imeataLoader.getEntityObjectPK(aInvBillBaseInfo.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk1);
        String tableName = entityObjectInfo.getTable().getName();
        String entryTableName = CalculateUtil.getEntryTableNameFormBillTableName((String)tableName);
        if (!aInvBillBaseInfo.isIsReversed() || StringUtil.isEmpty((String)tableName) || StringUtil.isEmpty((String)entryTableName)) {
            return;
        }
        this.updateFullReverseBillCost(ctx, tableName, entryTableName, aInvBillBaseInfo.getSourceBillId());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFullReverseBillCostForPurInWarehs(Context ctx, String tableName, String entryTableName, String billID) throws BOSException {
        StringBuffer querySourceBillSql = new StringBuffer();
        querySourceBillSql.append("select entry.factualCost as actualCost");
        querySourceBillSql.append(" ,entry.funitActualCost as unitActualCost");
        querySourceBillSql.append(" ,entry.fpurchaseCost as purchaseCost");
        querySourceBillSql.append(" ,entry.funitPurchaseCost as unitPurchaseCost");
        querySourceBillSql.append(" ,entry.fpurchaseFee as purchaseFee");
        querySourceBillSql.append(" ,entry.fQty as qty");
        querySourceBillSql.append(" ,entry.freverseQty as reverseQty");
        querySourceBillSql.append(" ,entry.fid as entryID");
        querySourceBillSql.append(" from ").append(tableName).append(" as bill");
        querySourceBillSql.append(" inner join ").append(entryTableName).append(" as entry");
        querySourceBillSql.append(" on bill.fid = entry.fparentid");
        querySourceBillSql.append(" where bill.ffiVouchered = 0 and bill.fbaseStatus=4 and bill.fid = ?");
        StringBuffer queryReverseBillSql = new StringBuffer();
        queryReverseBillSql.append("select entry.fid as entryID");
        queryReverseBillSql.append(" ,entry.fqty as qty");
        queryReverseBillSql.append(" ,ENTRY.FWrittenOffBaseQty as writtenOffBaseQty");
        queryReverseBillSql.append(" ,BASECURRENCY.FPrecision as fprecision");
        queryReverseBillSql.append(" ,MATERIAL.FPricePrecision as fpriceprecision");
        queryReverseBillSql.append(" from ").append(tableName).append(" as bill");
        queryReverseBillSql.append(" inner join ").append(entryTableName).append(" as entry");
        queryReverseBillSql.append(" on bill.fid = entry.fparentid");
        queryReverseBillSql.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT");
        queryReverseBillSql.append(" ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        queryReverseBillSql.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY");
        queryReverseBillSql.append(" ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        queryReverseBillSql.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL");
        queryReverseBillSql.append(" ON MATERIAL.Fid = entry.FMaterialID");
        queryReverseBillSql.append(" where bill.FIsReversed = 1 and bill.ffiVouchered = 0");
        queryReverseBillSql.append(" and bill.fbaseStatus=4 and entry.fsourceBillEntryId = ?");
        StringBuffer updateReverseBillSql = new StringBuffer();
        updateReverseBillSql.append("update ").append(entryTableName);
        updateReverseBillSql.append(" set FUnitActualCost=?,FActualCost=?");
        updateReverseBillSql.append(",FWrittenOffAmount=?,FUnWriteOffAmount=?");
        updateReverseBillSql.append(",FUnitPurchaseCost=?,FPurchaseCost=?,FPurchaseFee=?");
        updateReverseBillSql.append(" where fid=?");
        Connection conn = null;
        PreparedStatement querySourceBillStatement = null;
        PreparedStatement queryReverseBillStatement = null;
        PreparedStatement updateReverseBillStatement = null;
        ResultSet querySourceBillResultSet = null;
        ResultSet queryReverseBillResultSet = null;
        try {
            conn = this.getConnection(ctx);
            querySourceBillStatement = conn.prepareStatement(querySourceBillSql.toString());
            queryReverseBillStatement = conn.prepareStatement(queryReverseBillSql.toString(), 1004, 1007);
            updateReverseBillStatement = conn.prepareStatement(updateReverseBillSql.toString());
            querySourceBillStatement.setString(1, billID);
            querySourceBillResultSet = querySourceBillStatement.executeQuery();
            while (querySourceBillResultSet.next()) {
                String entryID = querySourceBillResultSet.getString("entryID");
                BigDecimal actualCost = querySourceBillResultSet.getBigDecimal("actualCost");
                BigDecimal unitActualCost = querySourceBillResultSet.getBigDecimal("unitActualCost");
                BigDecimal purchaseFee = querySourceBillResultSet.getBigDecimal("purchaseFee");
                BigDecimal cost = SysConstant.BIGZERO;
                queryReverseBillStatement.setString(1, entryID);
                queryReverseBillResultSet = queryReverseBillStatement.executeQuery();
                int i = 0;
                while (queryReverseBillResultSet.next()) {
                    int precision = queryReverseBillResultSet.getInt("fprecision");
                    int pricePrecision = queryReverseBillResultSet.getInt("fpriceprecision");
                    BigDecimal reverseCost = unitActualCost.multiply(queryReverseBillResultSet.getBigDecimal("qty")).setScale(precision, 4);
                    if (querySourceBillResultSet.getBigDecimal("qty").compareTo(querySourceBillResultSet.getBigDecimal("reverseQty")) == 0 && queryReverseBillResultSet.isLast() && ++i > 1) {
                        reverseCost = actualCost.subtract(cost).negate();
                    } else if (querySourceBillResultSet.getBigDecimal("qty").compareTo(querySourceBillResultSet.getBigDecimal("reverseQty")) == 0 && queryReverseBillResultSet.isLast() && i == 1) {
                        reverseCost = actualCost.negate();
                    }
                    BigDecimal reversePurchaseFee = purchaseFee.multiply(queryReverseBillResultSet.getBigDecimal("qty")).divide(querySourceBillResultSet.getBigDecimal("qty"), precision, 4);
                    BigDecimal reversePurchaseCost = reverseCost.subtract(reversePurchaseFee);
                    BigDecimal reverseUnitPurchaseCost = reversePurchaseCost.divide(queryReverseBillResultSet.getBigDecimal("qty"), pricePrecision, 4);
                    cost = cost.add(reverseCost.abs());
                    int y = 1;
                    updateReverseBillStatement.setBigDecimal(y, unitActualCost);
                    updateReverseBillStatement.setBigDecimal(++y, reverseCost);
                    BigDecimal writtenOffBaseQty = queryReverseBillResultSet.getBigDecimal("writtenOffBaseQty");
                    updateReverseBillStatement.setBigDecimal(++y, SysConstant.BIGZERO.compareTo(writtenOffBaseQty) == 0 ? SysConstant.BIGZERO : reversePurchaseCost);
                    updateReverseBillStatement.setBigDecimal(++y, SysConstant.BIGZERO.compareTo(writtenOffBaseQty) == 0 ? reversePurchaseCost : SysConstant.BIGZERO);
                    updateReverseBillStatement.setBigDecimal(++y, reverseUnitPurchaseCost);
                    updateReverseBillStatement.setBigDecimal(++y, reversePurchaseCost);
                    updateReverseBillStatement.setBigDecimal(++y, reversePurchaseFee);
                    updateReverseBillStatement.setString(++y, queryReverseBillResultSet.getString("entryID"));
                    updateReverseBillStatement.execute();
                }
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{querySourceBillStatement, queryReverseBillStatement, updateReverseBillStatement}, (ResultSet[])new ResultSet[]{querySourceBillResultSet, queryReverseBillResultSet});
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{querySourceBillStatement, queryReverseBillStatement, updateReverseBillStatement}, (ResultSet[])new ResultSet[]{querySourceBillResultSet, queryReverseBillResultSet});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFullReversePurInBillCost(Context ctx, PurInWarehsBillInfo aInvBillBaseInfo) throws BOSException {
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk1 = imeataLoader.getEntityObjectPK(aInvBillBaseInfo.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk1);
        String tableName = entityObjectInfo.getTable().getName();
        String entryTableName = CalculateUtil.getEntryTableNameFormBillTableName((String)tableName);
        if (!aInvBillBaseInfo.isIsReversed()) return;
        if (StringUtil.isEmpty((String)tableName)) return;
        if (StringUtil.isEmpty((String)entryTableName)) {
            return;
        }
        StringBuffer bf1 = new StringBuffer();
        bf1.append("select entry.factualCost as actualCost");
        bf1.append(" ,entry.funitActualCost as unitActualCost");
        bf1.append(" ,entry.fpurchasecost as purchaseCost");
        bf1.append(" ,entry.funitpurchasecost as unitPurchaseCost");
        bf1.append(" ,entry.fQty as qty");
        bf1.append(" ,entry.freverseQty as reverseQty");
        bf1.append(" ,entry.fid as entryID");
        bf1.append(" from ").append(tableName).append(" as bill");
        bf1.append(" inner join ").append(entryTableName).append(" as entry");
        bf1.append(" on bill.fid = entry.fparentid");
        bf1.append(" where bill.FIsReversed = 0 and bill.fbaseStatus=4 and bill.fid = ?");
        String querySourceBillSql = bf1.toString();
        StringBuffer bf2 = new StringBuffer();
        bf2.append("select entry.fid as entryID");
        bf2.append(" ,entry.fqty as qty");
        bf2.append(" ,entry.factualCost as actualCost");
        bf2.append(" ,entry.fpurchasecost as purchaseCost");
        bf2.append(" ,bill.ffiVouchered as fiVouchered");
        bf2.append(" ,BASECURRENCY.FPrecision as fprecision");
        bf2.append(" from ").append(tableName).append(" as bill");
        bf2.append(" inner join ").append(entryTableName).append(" as entry");
        bf2.append(" on bill.fid = entry.fparentid");
        bf2.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT");
        bf2.append(" ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf2.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY");
        bf2.append(" ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        bf2.append(" where bill.FIsReversed = 1");
        bf2.append(" and bill.fbaseStatus=4 and entry.fsourceBillEntryId = ?");
        bf2.append(" order by fivouchered desc");
        String queryReverseBillSql = bf2.toString();
        StringBuffer bf3 = new StringBuffer();
        bf3.append("update ").append(entryTableName);
        bf3.append(" set FAssociateQty=FBaseQty,FPurchaseCost=?");
        bf3.append(" where fid=?");
        String updateReverseBillSql = bf3.toString();
        Connection conn = null;
        PreparedStatement pm1 = null;
        PreparedStatement pm2 = null;
        PreparedStatement pm3 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            conn = this.getConnection(ctx);
            pm1 = conn.prepareStatement(querySourceBillSql);
            pm2 = conn.prepareStatement(queryReverseBillSql, 1004, 1007);
            pm3 = conn.prepareStatement(updateReverseBillSql);
            pm1.setString(1, aInvBillBaseInfo.getSourceBillId());
            rs1 = pm1.executeQuery();
            while (rs1.next()) {
                String entryID = rs1.getString("entryID");
                BigDecimal purchaseCost = rs1.getBigDecimal("purchaseCost");
                BigDecimal unitPurchaseCost = rs1.getBigDecimal("unitPurchaseCost").abs();
                BigDecimal cost = new BigDecimal("0.00");
                pm2.setString(1, entryID);
                rs2 = pm2.executeQuery();
                int i = 0;
                while (rs2.next()) {
                    BigDecimal reverseCost;
                    BigDecimal reversePurchaseCost = rs2.getBigDecimal("purchaseCost");
                    boolean isVouchered = rs2.getBoolean("fiVouchered");
                    int precision = rs2.getInt("fprecision");
                    BigDecimal bigDecimal = reverseCost = isVouchered ? reversePurchaseCost : unitPurchaseCost.multiply(rs2.getBigDecimal("qty")).setScale(precision, 4);
                    if (rs1.getBigDecimal("qty").abs().compareTo(rs1.getBigDecimal("reverseQty").abs()) == 0 && rs2.isLast() && ++i > 1) {
                        reverseCost = purchaseCost.abs().subtract(cost.abs()).negate();
                        if (purchaseCost.signum() == -1) {
                            reverseCost = reverseCost.multiply(new BigDecimal("-1"));
                        }
                    } else if (rs1.getBigDecimal("qty").abs().compareTo(rs1.getBigDecimal("reverseQty").abs()) == 0 && rs2.isLast() && i == 1) {
                        reverseCost = purchaseCost.negate();
                    }
                    cost = cost.add(reverseCost.abs());
                    int y = 1;
                    pm3.setBigDecimal(y, reverseCost);
                    pm3.setString(++y, rs2.getString("entryID"));
                    pm3.addBatch();
                }
            }
            pm3.executeBatch();
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm1, pm2, pm3}, (ResultSet[])new ResultSet[]{rs1, rs2});
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{pm1, pm2, pm3}, (ResultSet[])new ResultSet[]{rs1, rs2});
    }

    private void updateOrderOrReturnBill(Context ctx, Statement stmt, String transType, String invEntryName, String ordTableName, String ordEntryName, String billID, String orderBillID, int precision) throws BOSException, EASBizException {
        StringBuffer updateEntryFields = new StringBuffer();
        updateEntryFields.append("UPDATE " + ordEntryName);
        if (transType.equals("pur")) {
            updateEntryFields.append(" SET (FTotalUnReturnBaseQty,FDemandQty,FQty,FAssistQty,FBaseQty,FAmount,FTax,FTaxAmount) = ");
        } else if (transType.equals("sal")) {
            updateEntryFields.append(" SET (FTotalUnReturnBaseQty,FQty,FAssistQty,FBaseQty,FAmount,FTax,FTaxAmount) = ");
        } else {
            updateEntryFields.append(" SET (FUninvoicedQty,FUninvoicedBaseQty,FQty,FAssistQty,FBaseQty,FAmount,FTax,FTaxAmount) = ");
        }
        updateEntryFields.append(" (SELECT ");
        if (transType.equals("pur")) {
            updateEntryFields.append(" (" + ordEntryName + ".FTotalUnReturnBaseQty - ABS(A.FBaseQty)),");
            updateEntryFields.append(" (" + ordEntryName + ".FDemandQty - ABS(A.FQty)),");
        } else if (transType.equals("sal")) {
            updateEntryFields.append(" (" + ordEntryName + ".FTotalUnReturnBaseQty - ABS(A.FBaseQty)),");
        } else {
            updateEntryFields.append(" (" + ordEntryName + ".FUninvoicedQty - ABS(A.FQty)),");
            updateEntryFields.append(" (" + ordEntryName + ".FUninvoicedBaseQty - ABS(A.FBaseQty)),");
        }
        updateEntryFields.append(" (" + ordEntryName + ".FQty - ABS(A.FQty)),");
        updateEntryFields.append(" (" + ordEntryName + ".FAssistQty - ABS(A.FAssistQty)),");
        updateEntryFields.append(" (" + ordEntryName + ".FBaseQty - ABS(A.FBaseQty)),");
        updateEntryFields.append(" ROUND(Decimal((" + ordEntryName + ".FQty - ABS(A.FQty)) * " + ordEntryName + ".FPrice,17,4)," + precision + "),");
        updateEntryFields.append(" ROUND(Decimal(Decimal(((" + ordEntryName + ".FQty - ABS(A.FQty)) * " + ordEntryName + ".FPrice),17,4) * Decimal(" + ordEntryName + ".FTAXRATE/100,21,8),17,4)," + precision + "),");
        updateEntryFields.append(" ROUND(Decimal((" + ordEntryName + ".FQty - ABS(A.FQty)) * " + ordEntryName + ".FPrice,17,4)," + precision + ") + ");
        updateEntryFields.append(" ROUND(Decimal(Decimal(((" + ordEntryName + ".FQty - ABS(A.FQty)) * " + ordEntryName + ".FPrice),17,4) * Decimal(" + ordEntryName + ".FTAXRATE/100,21,8),17,4)," + precision + ")");
        updateEntryFields.append(" FROM " + invEntryName + " A ");
        if (transType.equals("sal")) {
            updateEntryFields.append(" WHERE A.FSaleOrderEntryID = " + ordEntryName + ".FID");
        } else {
            updateEntryFields.append(" WHERE A.FPurOrderEntryID = " + ordEntryName + ".FID");
        }
        updateEntryFields.append(" AND " + ordEntryName + ".FParentID = '" + orderBillID + "' AND A.FParentID = '" + billID + "');");
        StringBuffer updateHeadFields = new StringBuffer();
        updateHeadFields.append("UPDATE " + ordTableName);
        updateHeadFields.append(" SET FTotalAmount = (SELECT ISNULL(SUM(FAmount),0) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),");
        updateHeadFields.append(" FTotalTax = (SELECT ISNULL(SUM(FTax),0) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),");
        updateHeadFields.append(" FTotalTaxAmount = (SELECT ISNULL(SUM(FTaxAmount),0) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "')");
        updateHeadFields.append(" WHERE FID = '" + orderBillID + "';");
        try {
            stmt.addBatch(updateEntryFields.toString());
            stmt.addBatch(updateHeadFields.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateSoureBill(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo, boolean isAudit) throws BOSException, EASBizException {
        if (aInvBillBaseInfo.isIsReversed()) {
            return;
        }
        String billTypeID = aInvBillBaseInfo.getBillType().getId().toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            int i;
            int size;
            AbstractObjectCollection coll;
            String billTypeid;
            String sql;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("entry.id"));
            sic.add(new SelectorItemInfo("entry.seq"));
            if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID) && aInvBillBaseInfo instanceof SaleIssueBillInfo) {
                if (isAudit) {
                    sql = "update T_IM_SaleIssueEntry set FSaleOrderNumber =?,FSaleOrderID =?,FSaleOrderEntrySeq=?,FSaleOrderEntryID=?,FCoreBillTypeID=?  where fid = ?";
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.prepareStatement(sql);
                    ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
                    SaleIssueBillInfo aSaleIssueBillInfo = iSaleIssueBill.getSaleIssueBillInfo(pk, sic);
                    String saleOrderNumber = aSaleIssueBillInfo.getNumber().trim();
                    String saleOrderID = aSaleIssueBillInfo.getId().toString();
                    billTypeid = billTypeID;
                    coll = aSaleIssueBillInfo.getEntry();
                    if (coll != null) {
                        size = coll.size();
                        for (i = 0; i < size; ++i) {
                            SaleIssueEntryInfo aSaleIssueEntryInfo = coll.get(i);
                            stmt.setString(1, saleOrderNumber);
                            stmt.setString(2, saleOrderID);
                            stmt.setInt(3, aSaleIssueEntryInfo.getSeq());
                            stmt.setString(4, aSaleIssueEntryInfo.getId().toString());
                            stmt.setString(5, billTypeid);
                            stmt.setString(6, aSaleIssueEntryInfo.getId().toString());
                            stmt.addBatch();
                        }
                        if (coll.size() > 0) {
                            stmt.executeBatch();
                        }
                    }
                } else if (!this.isBotpBill(aInvBillBaseInfo)) {
                    sql = "update T_IM_SaleIssueEntry set FSaleOrderNumber =null,FSaleOrderID =null,FSaleOrderEntrySeq= null,FSaleOrderEntryID=null,FCoreBillTypeID=null  where fparentid = '" + aInvBillBaseInfo.getId().toString() + "'";
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.prepareStatement(sql);
                    stmt.execute();
                }
            }
            if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID) && aInvBillBaseInfo instanceof PurInWarehsBillInfo) {
                if (isAudit) {
                    sql = "update T_IM_PurInWarehsEntry set FPurOrderNumber =?,FPurOrderID =?,FPurOrderEntrySeq=?,FPurOrderEntryID=?,FCoreBillTypeID=?  where fid = ?";
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.prepareStatement(sql);
                    IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance(ctx);
                    PurInWarehsBillInfo aPurInWarehsBillInfo = iPurInWarehsBill.getPurInWarehsBillInfo(pk, sic);
                    String purOrderNumber = aPurInWarehsBillInfo.getNumber().trim();
                    String purOrderID = aPurInWarehsBillInfo.getId().toString();
                    billTypeid = billTypeID;
                    coll = aPurInWarehsBillInfo.getEntry();
                    if (coll != null) {
                        size = coll.size();
                        for (i = 0; i < size; ++i) {
                            PurInWarehsEntryInfo aPurInWarehsEntryInfo = coll.get(i);
                            stmt.setString(1, purOrderNumber);
                            stmt.setString(2, purOrderID);
                            stmt.setInt(3, aPurInWarehsEntryInfo.getSeq());
                            stmt.setString(4, aPurInWarehsEntryInfo.getId().toString());
                            stmt.setString(5, billTypeid);
                            stmt.setString(6, aPurInWarehsEntryInfo.getId().toString());
                            stmt.addBatch();
                        }
                        if (coll.size() > 0) {
                            stmt.executeBatch();
                        }
                    }
                } else {
                    sql = "update T_IM_PurInWarehsEntry set FPurOrderNumber =null,FPurOrderID =null,FPurOrderEntrySeq=null,FPurOrderEntryID=null,FCoreBillTypeID=null  where fparentid = '" + aInvBillBaseInfo.getId().toString() + "'";
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.prepareStatement(sql);
                    stmt.execute();
                }
            }
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(stmt, conn);
        }
    }

    private void checkMaterialInventory(Context ctx, InvBillBaseInfo billInfo) throws EASBizException, BOSException {
        if (!this.isCheckMaterialInventory()) {
            return;
        }
        IObjectCollection entryCol = (IObjectCollection)billInfo.get("entry");
        if (entryCol == null) {
            return;
        }
        MaterialInventoryCollection matCouInfoCol = this.getMaterialInventoryCollection(ctx, billInfo);
        if (matCouInfoCol.size() == entryCol.size()) {
            return;
        }
        String errorMsg = InvBillBaseControllerBean.getMaterialInventoryNullMsg(matCouInfoCol, billInfo, ctx);
        if (errorMsg != null && errorMsg.length() != 0) {
            throw new InvBizException(InvBizException.MATERIAL_INVENTORY_UNAPPROVE, new String[]{errorMsg});
        }
    }

    protected boolean isCheckMaterialInventory() {
        return false;
    }

    private MaterialInventoryCollection getMaterialInventoryCollection(Context ctx, InvBillBaseInfo billInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object entryCol = null;
        if (billInfo.getBillType() != null && "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(billInfo.getBillType().getId().toString())) {
            IObjectCollection entries = (IObjectCollection)billInfo.get("entries");
            entryCol = new InvBillBaseEntryCollection();
            HashSet<String> entryIdSet = new HashSet<String>();
            for (int i = 0; i < entries.size(); ++i) {
                DecomposeEntryInfo entryInfo = (DecomposeEntryInfo)entries.getObject(i);
                entryIdSet.add(entryInfo.getId().toString());
                entryCol.addObject((IObjectValue)entryInfo);
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            SelectorItemCollection siCol = new SelectorItemCollection();
            siCol.add(new SelectorItemInfo("id"));
            siCol.add(new SelectorItemInfo("material"));
            entityViewInfo.setSelector(siCol);
            CoreBaseCollection baseCol = DecomposeEntryFactory.getLocalInstance(ctx).getCollection(entityViewInfo);
            int size = baseCol.size();
            for (int i = 0; i < size; ++i) {
                entryCol.addObject((IObjectValue)((DecomposeEntryInfo)baseCol.get(i)));
            }
        } else {
            entryCol = (IObjectCollection)billInfo.get("entry");
        }
        if (billInfo.getStorageOrgUnit() == null) {
            return null;
        }
        HashSet<String> materialIDs = new HashSet<String>();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            MaterialInfo matInfo = entryInfo.getMaterial();
            if (matInfo == null || matInfo.getId() == null) continue;
            materialIDs.add(matInfo.getId().toString());
        }
        if (materialIDs.size() == 0) {
            return null;
        }
        filter.appendFilterItem("orgUnit", (Object)billInfo.getStorageOrgUnit().getId().toString());
        filter.getFilterItems().add(new FilterItemInfo("material", materialIDs, CompareType.INCLUDE));
        filter.appendFilterItem("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()));
        if (filter.getFilterItems().size() <= 0) {
            return null;
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("id");
        viewInfo.getSelector().add("orgUnit");
        viewInfo.getSelector().add("material");
        viewInfo.getSelector().add("isLotNumber");
        return MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewInfo);
    }

    private static String getMaterialInventoryNullMsg(MaterialInventoryCollection materialInventoryCol, InvBillBaseInfo billInfo, Context ctx) throws EASBizException, BOSException {
        MaterialInfo matInfo;
        IObjectCollection entryCol = (IObjectCollection)billInfo.get("entry");
        String storageOrg = billInfo.getStorageOrgUnit().getId().toString();
        HashMap matInvMap = new HashMap(materialInventoryCol.size() * 2);
        int size = materialInventoryCol.size();
        for (int i = 0; i < size; ++i) {
            matInfo = materialInventoryCol.get(i).getMaterial();
            matInvMap.put(storageOrg + matInfo.getId().toString(), null);
        }
        StringBuffer errorMsg = new StringBuffer();
        int size2 = entryCol.size();
        for (int i = 0; i < size2; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            matInfo = entryInfo.getMaterial();
            if (matInvMap.containsKey(storageOrg + matInfo.getId().toString())) continue;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            if (matInfo.getName() == null) {
                matInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(matInfo.getId()), sic);
            }
            String storageOrgName = billInfo.getStorageOrgUnit().getName();
            if (billInfo.getStorageOrgUnit().getName() == null) {
                StorageOrgUnitInfo storageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(billInfo.getStorageOrgUnit().getId()), sic);
                storageOrgName = storageOrgUnit.getName();
            }
            errorMsg.append("\r\n").append(matInfo.getName());
            errorMsg.append("      ").append(storageOrgName);
        }
        return errorMsg.toString();
    }

    protected void _audit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null && pk != null) {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("transactionType.*"));
            sc.add(new SelectorItemInfo("entry.*"));
            sc.add(new SelectorItemInfo("entry.material.*"));
            sc.add(new SelectorItemInfo("entry.companyOrgUnit.name"));
            model = this.getSCMBillBaseInfo(ctx, pk, sc);
        }
        if (pk == null && model != null) {
            pk = new ObjectUuidPK(((InvBillBaseInfo)model).getId());
        }
        if (pk == null && model == null) {
            return;
        }
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        this.checkInvUpdateType(invBillBaseInfo);
        if (invBillBaseInfo != null && invBillBaseInfo.getBillType() != null && !"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(invBillBaseInfo.getBillType().getId().toString())) {
            BillTypeInfo sourceBillType;
            Boolean value;
            HashMap map = SCMParamFacadeFactory.getLocalInstance((Context)ctx).getScmSpecialParams(new String[]{"isRefreshing", "isStartLog"});
            if (map.containsKey("isRefreshing") && (value = (Boolean)map.get("isRefreshing")).booleanValue()) {
                throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
            }
            TransactionTypeInfo transType = invBillBaseInfo.getTransactionType();
            if (transType == null && !"XlazxwEREADgAAAEwKgSxUY+1VI=".equals(invBillBaseInfo.getBillType().getId().toString()) && !"50957179-0105-1000-e001-1152c0a812fd463ED552".equals(invBillBaseInfo.getBillType().getId().toString())) {
                throw new InvBizException(InvBizException.TRANSACTIONTYPE_CANNOTNULL);
            }
            Map coreBillType = new HashMap();
            coreBillType = this.getCoreBillType(ctx, invBillBaseInfo);
            if (invBillBaseInfo.getBillType() == null || invBillBaseInfo.getBillType().getId() == null) {
                throw new SCMBillException(SCMBillException.BILLTYPE_ISNULL);
            }
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillType = BillTypeUtils.getBillEntryTableName((Context)ctx, coreBillType);
            }
            String billTable = BillTypeUtils.getBillHeadTableName((Context)ctx, (String)invBillBaseInfo.getBillType().getId().toString());
            ArrayList<String> sqlUpdate = new ArrayList<String>();
            if (billTable != null && billTable.length() > 0) {
                sqlUpdate.add(" UPDATE " + billTable + " SET FID = FID  WHERE FID = '" + pk.toString() + "'");
            }
            IObjectCollection entrys = this.getEntryCollection(invBillBaseInfo);
            String tmp = null;
            StringBuffer srcBillSql = new StringBuffer();
            StringBuffer coreBillSql = new StringBuffer();
            for (int i = 0; i < entrys.size(); ++i) {
                if (((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId() == null) continue;
                tmp = ((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId().toString();
                srcBillSql.append("'").append(tmp).append("',");
                tmp = null;
            }
            if (srcBillSql.length() > 40) {
                srcBillSql.setLength(srcBillSql.length() - 1);
            }
            if ((sourceBillType = ((InvBillBaseEntryInfo)entrys.getObject(0)).getSourceBillType()) != null && sourceBillType.getId() != null && srcBillSql.length() > 40 && (tmp = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)sourceBillType.getId().toString())) != null && tmp.trim().length() > 0 && srcBillSql.length() > 40) {
                sqlUpdate.add(" UPDATE " + tmp + " SET FID = FID WHERE FID IN (" + srcBillSql.toString() + ")");
            }
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillSql.append(this.getCoreBillEntryId(ctx, invBillBaseInfo));
                Set set = coreBillType.keySet();
                Iterator ite = set.iterator();
                while (ite.hasNext()) {
                    String next = ite.next().toString();
                    if (!coreBillType.containsKey(next) || coreBillType.get(next) == null || coreBillSql.length() <= 40) continue;
                    sqlUpdate.add(" UPDATE " + coreBillType.get(next) + " SET FID = FID WHERE FID IN (" + coreBillSql.toString() + ")");
                }
            }
            if (sqlUpdate.size() > 0) {
                String[] updSql = new String[sqlUpdate.size()];
                for (int i = 0; i < sqlUpdate.size(); ++i) {
                    updSql[i] = (String)sqlUpdate.get(i);
                }
                com.kingdee.eas.dynbusiness.util.DBUtil.executeBatch((Context)ctx, (String[])updSql);
            }
        }
        invBillBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        if (!this.isAddNew(ctx, (IObjectValue)invBillBaseInfo)) {
            InvBillBaseInfo checkInfo = (InvBillBaseInfo)this.getDataNewStatus(ctx, (IObjectValue)invBillBaseInfo);
            this._checkAudit(ctx, (IObjectValue)checkInfo, true);
            this._checkSubmit(ctx, (IObjectValue)checkInfo, false);
        }
        if ((ctx.get((Object)CTX_TEMP_CHECKED_BIZDATE) == null || !((Boolean)ctx.get((Object)CTX_TEMP_CHECKED_BIZDATE)).booleanValue()) && this.isCheckBizDate()) {
            if (!invBillBaseInfo.isIsInitBill()) {
                this._checkBizDate(ctx, model);
            } else {
                this._checkInitBizDate(ctx, model);
            }
        }
        this.checkMaterialCost(ctx, invBillBaseInfo);
        this.checkMaterialInventory(ctx, invBillBaseInfo);
        this.updateAuditStatus(ctx, model);
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance(ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
        this.afterPassAudit(ctx, pk, invBillBaseInfo);
        this.batchExecute(ctx, new Object[]{pk}, BatchActionEnum.AUDIT);
        ctx.remove((Object)CTX_TEMP_CHECKED_BIZDATE);
        ctx.remove((Object)CTX_TEMP_BILL_TRANSACTIONTYPE);
    }

    protected TransactionTypeInfo getTransactionTypeInfo(Context ctx, InvBillBaseInfo invBillInfo) throws EASBizException, BOSException {
        Map<String, TransactionTypeInfo> transactionTypeMap;
        if (null == invBillInfo || invBillInfo.getTransactionType() == null) {
            return null;
        }
        if (ctx.get((Object)CTX_TEMP_BILL_TRANSACTIONTYPE) != null && ctx.get((Object)CTX_TEMP_BILL_TRANSACTIONTYPE) instanceof Map) {
            transactionTypeMap = (Map)ctx.get((Object)CTX_TEMP_BILL_TRANSACTIONTYPE);
        } else {
            transactionTypeMap = new HashMap();
            ctx.put((Object)CTX_TEMP_BILL_TRANSACTIONTYPE, transactionTypeMap);
        }
        String transactionTypeId = invBillInfo.getTransactionType().getId().toString();
        TransactionTypeInfo result = null;
        if (transactionTypeMap.containsKey(transactionTypeId)) {
            result = (TransactionTypeInfo)transactionTypeMap.get(transactionTypeId);
        } else {
            result = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeId));
            transactionTypeMap.put(transactionTypeId, result);
        }
        if (result == null) {
            result = invBillInfo.getTransactionType();
        }
        return result;
    }

    protected void _unAudit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
        if (aInvBillBaseInfo != null && aInvBillBaseInfo.getBillType() != null && !"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString())) {
            BillTypeInfo sourceBillType;
            Boolean value;
            HashMap map = SCMParamFacadeFactory.getLocalInstance((Context)ctx).getScmSpecialParams(new String[]{"isRefreshing"});
            if (map.containsKey("isRefreshing") && (value = (Boolean)map.get("isRefreshing")).booleanValue()) {
                throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
            }
            TransactionTypeInfo transType = aInvBillBaseInfo.getTransactionType();
            if (transType == null && !"XlazxwEREADgAAAEwKgSxUY+1VI=".equals(aInvBillBaseInfo.getBillType().getId().toString())) {
                throw new InvBizException(InvBizException.TRANSACTIONTYPE_CANNOTNULL);
            }
            Map coreBillType = new HashMap();
            coreBillType = this.getCoreBillType(ctx, aInvBillBaseInfo);
            if (aInvBillBaseInfo.getBillType() == null || aInvBillBaseInfo.getBillType().getId() == null) {
                throw new SCMBillException(SCMBillException.BILLTYPE_ISNULL);
            }
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillType = BillTypeUtils.getBillEntryTableName((Context)ctx, coreBillType);
            }
            String billTable = BillTypeUtils.getBillHeadTableName((Context)ctx, (String)aInvBillBaseInfo.getBillType().getId().toString());
            ArrayList<String> sqlUpdate = new ArrayList<String>();
            if (billTable != null && billTable.length() > 0) {
                sqlUpdate.add("UPDATE " + billTable + " SET FID = FID  WHERE FID = '" + pk.toString() + "'");
            }
            IObjectCollection entrys = null;
            entrys = aInvBillBaseInfo.getBillType() != null && "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString()) ? (IObjectCollection)aInvBillBaseInfo.get("entries") : (IObjectCollection)aInvBillBaseInfo.get("entry");
            String tmp = null;
            StringBuffer srcBillSql = new StringBuffer();
            StringBuffer coreBillSql = new StringBuffer();
            for (int i = 0; i < entrys.size(); ++i) {
                if (((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId() == null) continue;
                tmp = ((InvBillBaseEntryInfo)entrys.getObject(i)).getSourceBillEntryId().toString();
                srcBillSql.append("'").append(tmp).append("',");
                tmp = null;
            }
            if (srcBillSql.length() > 40) {
                srcBillSql.setLength(srcBillSql.length() - 1);
            }
            if ((sourceBillType = ((InvBillBaseEntryInfo)entrys.getObject(0)).getSourceBillType()) != null && sourceBillType.getId() != null && srcBillSql.length() > 40 && (tmp = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)sourceBillType.getId().toString())) != null && tmp.trim().length() > 0 && srcBillSql.length() > 40) {
                sqlUpdate.add("UPDATE " + tmp + " SET FID = FID WHERE FID IN (" + srcBillSql.toString() + ")");
            }
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillSql.append(this.getCoreBillEntryId(ctx, aInvBillBaseInfo));
                Set set = coreBillType.keySet();
                Iterator ite = set.iterator();
                while (ite.hasNext()) {
                    String next = ite.next().toString();
                    if (!coreBillType.containsKey(next) || coreBillType.get(next) == null || coreBillSql.length() <= 40) continue;
                    sqlUpdate.add("UPDATE " + coreBillType.get(next) + " SET FID = FID WHERE FID IN (" + coreBillSql.toString() + ")");
                }
            }
            if (sqlUpdate.size() > 0) {
                String[] updSql = new String[sqlUpdate.size()];
                for (int i = 0; i < sqlUpdate.size(); ++i) {
                    updSql[i] = (String)sqlUpdate.get(i);
                }
                com.kingdee.eas.dynbusiness.util.DBUtil.executeBatch((Context)ctx, (String[])updSql);
            }
        }
        aInvBillBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        InvBillBaseInfo checkInfo = (InvBillBaseInfo)this.getDataNewStatus(ctx, (IObjectValue)aInvBillBaseInfo);
        aInvBillBaseInfo.setBaseStatus(checkInfo.getBaseStatus());
        this.checkUnPassAduit(ctx, aInvBillBaseInfo);
        this.updateUnAuditStatus(ctx, (IObjectValue)aInvBillBaseInfo);
        this.afterUnPassAudit(ctx, pk, aInvBillBaseInfo);
        this.batchExecute(ctx, new Object[]{pk}, BatchActionEnum.UNAUDIT);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        String companyId;
        AbstractObjectCollection coll;
        this.setNULLToZERO((IObjectValue)((InvBillBaseInfo)model));
        this.setEmptyToNullForLot(model);
        if (model != null && model.get("$BillQuery") != null) {
            this.checkMaterialCost(ctx, (InvBillBaseInfo)model);
            InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
            if (this._exists(ctx, (IObjectPK)new ObjectUuidPK(aInvBillBaseInfo.getId()))) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("fiVouchered"));
                InvBillBaseInfo temp = (InvBillBaseInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(aInvBillBaseInfo.getId()), selector);
                if (temp.isFiVouchered()) {
                    throw new InvBizException(InvBizException.SAVE_ERROR_HAVE_VOUCHER);
                }
            }
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            aInvBillBaseInfo.setModificationTime(ts);
            IObjectPK userID = ctx.getCaller();
            UserInfo modifier = new UserInfo();
            modifier.setId(BOSUuid.read((String)userID.toString()));
            aInvBillBaseInfo.setModifier(modifier);
        }
        this.delMaterialSN(ctx, pk, model);
        InvBillBaseInfo info = (InvBillBaseInfo)model;
        int precision = 2;
        if (info instanceof SaleIssueBillInfo) {
            SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)info;
            coll = saleIssueBillInfo.getEntry();
            if (coll.size() > 0) {
                companyId = coll.get(0).getCompanyOrgUnit().getId().toString();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("baseCurrency.precision"));
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
                precision = company.getBaseCurrency().getPrecision();
            }
            for (int i = 0; i < coll.size(); ++i) {
                SaleIssueEntryInfo saleIssueEntryInfo = coll.get(i);
                if (saleIssueEntryInfo.getQty().compareTo(saleIssueEntryInfo.getWrittenOffQty()) == 0) {
                    saleIssueEntryInfo.setWrittenOffAmount(saleIssueEntryInfo.getActualCost());
                    saleIssueEntryInfo.setUnWriteOffAmount(new BigDecimal("0.00"));
                    continue;
                }
                if (saleIssueEntryInfo.getUnitActualCost() != null) {
                    saleIssueEntryInfo.setWrittenOffAmount(saleIssueEntryInfo.getUnitActualCost().multiply(saleIssueEntryInfo.getWrittenOffQty()).setScale(precision, 4));
                }
                if (saleIssueEntryInfo.getActualCost() == null) continue;
                saleIssueEntryInfo.setUnWriteOffAmount(saleIssueEntryInfo.getActualCost().subtract(saleIssueEntryInfo.getWrittenOffAmount()));
            }
            super._update(ctx, pk, (IObjectValue)saleIssueBillInfo);
        } else if (info instanceof PurInWarehsBillInfo) {
            BigDecimal exchangeRate;
            PurInWarehsBillInfo purInWarehsBillInfo = (PurInWarehsBillInfo)info;
            coll = purInWarehsBillInfo.getEntry();
            if (coll.size() > 0) {
                companyId = coll.get(0).getCompanyOrgUnit().getId().toString();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("baseCurrency.precision"));
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
                precision = company.getBaseCurrency().getPrecision();
            }
            if ((exchangeRate = purInWarehsBillInfo.getExchangeRate()) == null) {
                exchangeRate = SCMConstant.BIGDECIMAL_ONE;
            }
            for (int i = 0; i < coll.size(); ++i) {
                PurInWarehsEntryInfo purInWarehsEntryInfo = coll.get(i);
                if (purInWarehsEntryInfo.getQty().compareTo(purInWarehsEntryInfo.getWrittenOffQty()) == 0) {
                    purInWarehsEntryInfo.setWrittenOffAmount(purInWarehsEntryInfo.getPurchaseCost());
                    purInWarehsEntryInfo.setUnWriteOffAmount(SysConstant.BIGZERO);
                } else {
                    if (purInWarehsEntryInfo.getUnitPurchaseCost() != null) {
                        purInWarehsEntryInfo.setWrittenOffAmount(purInWarehsEntryInfo.getUnitPurchaseCost().multiply(purInWarehsEntryInfo.getWrittenOffQty()).setScale(precision, 4));
                    }
                    if (purInWarehsEntryInfo.getPurchaseCost() != null) {
                        purInWarehsEntryInfo.setUnWriteOffAmount(purInWarehsEntryInfo.getPurchaseCost().subtract(purInWarehsEntryInfo.getWrittenOffAmount()));
                    }
                }
                purInWarehsEntryInfo.setLocalPrice(purInWarehsEntryInfo.getPrice().multiply(exchangeRate));
            }
            super._update(ctx, pk, (IObjectValue)purInWarehsBillInfo);
        } else {
            super._update(ctx, pk, model);
        }
    }

    private boolean checkCanMatchLot(Context ctx, IObjectValue billInfo) throws InvBizException, SCMBillException {
        InvBillBaseInfo info = null;
        if (!(billInfo instanceof InvBillBaseInfo)) {
            return false;
        }
        info = (InvBillBaseInfo)billInfo;
        String billTypeId = null;
        if (info.getBillType() == null || info.getBillType().getId() == null) {
            throw new SCMBillException(SCMBillException.BILLTYPE_ISNULL, new Object[]{info.getString("number")});
        }
        billTypeId = info.getBillType().getId().toString();
        if (!("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeId))) {
            return false;
        }
        if (info.getStorageOrgUnit() == null) {
            throw new InvBizException(InvBizException.STOREORG_IS_NULL, new String[]{info.getNumber()});
        }
        IObjectCollection entryColl = (IObjectCollection)info.get("entry");
        if (entryColl.size() == 0) {
            return false;
        }
        if (info.getTransactionType() == null) {
            throw new InvBizException(InvBizException.TRANSTYPE_IS_NULL, new Object[]{info.getNumber()});
        }
        return !info.isIsReversed();
    }

    protected void matchLotInfoNew(Context ctx, InvBillBaseInfo info) throws BOSException, EASBizException {
        Map conditions = this.getMatchLotConditions(ctx, info);
        ArrayList<IObjectValue> billEntryList = new ArrayList<IObjectValue>();
        IObjectCollection entryColl = (IObjectCollection)info.get("entry");
        for (int i = 0; i < entryColl.size(); ++i) {
            billEntryList.add(entryColl.getObject(i));
        }
        try {
            new CalculateLotAppHelper().matchLot(billEntryList, conditions);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map getMatchLotConditions(Context ctx, InvBillBaseInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        conditions.put("StorageOrgUnitInfo", info.getStorageOrgUnit());
        conditions.put("billInfo", info);
        conditions.put("isBOTP", Boolean.TRUE);
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String val = ipc.getParamValue((IObjectPK)new ObjectUuidPK(info.getStorageOrgUnit().getId().toString()), "INM004");
        boolean isUpdateByBaseUnit = false;
        if (val != null) {
            isUpdateByBaseUnit = val.equalsIgnoreCase("true");
        }
        conditions.put("isUpdateByBaseUnit", isUpdateByBaseUnit);
        conditions.put("entryName", "entry");
        conditions.put("context", ctx);
        return conditions;
    }

    @Override
    protected IObjectValue _matchLotInfo(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        if (!this.checkCanMatchLot(ctx, billInfo)) {
            return billInfo;
        }
        InvBillBaseInfo info = (InvBillBaseInfo)billInfo;
        this.matchLotInfoNew(ctx, info);
        this.setNULLToZERO((IObjectValue)info);
        this.reCalByQty(ctx, info);
        return info;
    }

    protected boolean isGetCustomerForMatchLotInfo(StoreTypeInfo storeTypeInfo) {
        return storeTypeInfo.getStoreFlag() != null && (storeTypeInfo.getStoreFlag().getValue() == 3 || storeTypeInfo.getStoreFlag().getValue() == 4);
    }

    protected boolean isGetSupplierForMatchLotInfo(StoreTypeInfo storeTypeInfo) {
        return storeTypeInfo.getStoreFlag() != null && (storeTypeInfo.getStoreFlag().getValue() == 2 || storeTypeInfo.getStoreFlag().getValue() == 5);
    }

    protected InvBillBaseEntryInfo getCloneEntryInfo(InvBillBaseEntryInfo source) {
        InvBillBaseEntryInfo result = new InvBillBaseEntryInfo();
        result.putAll((IObjectValue)source);
        return result;
    }

    protected String getEntryBOSUuid() {
        return null;
    }

    protected CalculateLotValue buildMatchLotValue(InventoryCollection inventoryCollection, boolean isUpdateByBaseUnit, BigDecimal qty, InvBillBaseEntryInfo entry, boolean isNegative) throws CalculateLotException {
        CalculateLotValue value = new CalculateLotValue();
        value.setLineValues(new ArrayList());
        BigDecimal totalQty = new BigDecimal("0.00");
        Iterator iter = inventoryCollection.iterator();
        if (qty != null) {
            while (iter.hasNext() && totalQty.compareTo(qty) < 0) {
                InventoryInfo inventory = (InventoryInfo)iter.next();
                CalculateLotLineValue lineValue = new CalculateLotLineValue();
                BigDecimal inventoryQty = isUpdateByBaseUnit ? inventory.getBaseQty() : inventory.getCurStoreQty();
                BigDecimal thisQty = totalQty.add(inventoryQty).compareTo(qty) > 0 ? qty.subtract(totalQty) : inventoryQty;
                lineValue.setQty(thisQty);
                lineValue.setLot(inventory.getLot());
                lineValue.setMfg((java.sql.Date)inventory.get("mfg"));
                lineValue.setExp((java.sql.Date)inventory.get("exp"));
                if (inventory.getAssistProperty() != null) {
                    lineValue.setAsstAttrID(inventory.getAssistProperty().getId().toString());
                }
                if (inventory.getProject() != null) {
                    lineValue.setProjectID(inventory.getProject().getId().toString());
                }
                if (inventory.getTrackNumber() != null) {
                    lineValue.setTrackNumberID(inventory.getTrackNumber().getId().toString());
                }
                if (inventory.getWarehouse() != null) {
                    lineValue.setWarehouseID(inventory.getWarehouse().getId().toString());
                }
                if (inventory.getLocation() != null) {
                    lineValue.setLocationID(inventory.getLocation().getId().toString());
                }
                if (inventory.getSupplier() != null) {
                    lineValue.setSupplierID(inventory.getSupplier().getId().toString());
                }
                if (inventory.getCustomer() != null) {
                    lineValue.setCustomerID(inventory.getCustomer().getId().toString());
                }
                value.getLineValues().add(lineValue);
                totalQty = totalQty.add(thisQty);
            }
        }
        if (totalQty.compareTo(qty) < 0) {
            StringBuffer msg = new StringBuffer();
            if (entry.getMaterial() != null) {
                msg.append(entry.getMaterial().getName());
            }
            if (entry.getAssistProperty() != null) {
                msg.append(" ").append(entry.getAssistProperty().getName());
            }
            if (entry.getProject() != null) {
                msg.append(" ").append(entry.getProject().getName());
            }
            if (entry.getTrackNumber() != null) {
                msg.append(" ").append(entry.getTrackNumber().getName());
            }
            if (entry.getUnit() != null) {
                if (isUpdateByBaseUnit) {
                    msg.append(" ").append(entry.getBaseUnit().getName());
                } else {
                    msg.append(" ").append(entry.getUnit().getName());
                }
            }
            if (entry.getWarehouse() != null) {
                msg.append(" ").append(entry.getWarehouse().getName());
            }
            if (entry.getLocation() != null) {
                msg.append(" ").append(entry.getLocation().getName());
            }
            BigDecimal qtyDiff = qty.subtract(totalQty);
            if (isUpdateByBaseUnit && !isNegative) {
                throw new CalculateLotException(CalculateLotException.NOTENOUGH, new Object[]{msg.toString(), String.valueOf(qtyDiff)});
            }
            if (!isUpdateByBaseUnit && !isNegative) {
                throw new CalculateLotException(CalculateLotException.NOTENOUGH2, new Object[]{msg.toString(), String.valueOf(qtyDiff)});
            }
        }
        return value;
    }

    protected void reCalByQty(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        HashSet<String> unitSet = new HashSet<String>();
        IObjectCollection entryColl = (IObjectCollection)info.get("entry");
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entryColl.getObject(i);
            if (entry.getUnit() == null || entry.getBaseUnit() == null) continue;
            unitSet.add(entry.getMaterial().getId().toString() + "," + entry.getUnit().getId().toString());
            if (entry.getAssistUnit() == null) continue;
            unitSet.add(entry.getMaterial().getId().toString() + "," + entry.getAssistUnit().getId().toString());
        }
        Map mulUnitMap = InvServerUtils.getMultiUnitMap(ctx, unitSet);
        Map<String, MultiMeasureUnitInfo> mulUnitAllMap = InvServerUtils.getMultiMeasureUnitMap(ctx, info);
        BigDecimal assUnitConv = null;
        int assUnitPricision = 0;
        Map entryMulAssUnitMap = null;
        MultiMeasureUnitInfo mmUnitInfo = null;
        int baseQtyPrecision = 8;
        int size2 = entryColl.size();
        for (int i = 0; i < size2; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entryColl.getObject(i);
            if (entry.getMaterial() == null || entry.getUnit() == null || entry.getBaseUnit() == null) continue;
            mmUnitInfo = mulUnitAllMap.get(entry.getMaterial().getId().toString() + entry.getUnit().getId().toString());
            baseQtyPrecision = 8;
            if (mulUnitAllMap.get(entry.getMaterial().getId().toString() + entry.getBaseUnit().getId().toString()) != null) {
                baseQtyPrecision = mulUnitAllMap.get(entry.getMaterial().getId().toString() + entry.getBaseUnit().getId().toString()).getQtyPrecision();
            }
            if (mmUnitInfo != null) {
                BigDecimal baseQty = entry.getQty().multiply(mmUnitInfo.getBaseConvsRate()).setScale(baseQtyPrecision, 4);
                entry.setBaseQty(baseQty);
            }
            if (entry.getAssistQty() != null && (entry.getAssistQty().compareTo(BigDecimal.ZERO) != 0 || info.getSourceBillType() != null)) continue;
            entryMulAssUnitMap = null;
            if (entry.getAssistUnit() != null) {
                entryMulAssUnitMap = (Map)mulUnitMap.get(entry.getMaterial().getId().toString() + entry.getAssistUnit().getId().toString());
            }
            if (entryMulAssUnitMap == null) continue;
            assUnitConv = new BigDecimal((String)entryMulAssUnitMap.get("fbaseconvsrate"));
            assUnitPricision = Integer.parseInt((String)entryMulAssUnitMap.get("fqtyprecision"));
            entry.setAssistQty(entry.getBaseQty().divide(assUnitConv, assUnitPricision, 4));
        }
    }

    protected IObjectCollection getNewEntryCollection() {
        return new InvBillBaseEntryCollection();
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void updateEntryFields(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
        String billTypeId = null;
        String billBosType = aInvBillBaseInfo.getBOSType().toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        try {
            aInvBillBaseInfo.setBizDate(sdf.parse(sdf.format(aInvBillBaseInfo.getBizDate())));
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        if (SCMConstant.BOSTYPE_SALEISSUE.equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e000-015bc0a812fd463ED552";
        }
        if (SCMConstant.BOSTYPE_PURINWAREHS.equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e000-015fc0a812fd463ED552";
        }
        if ("E3DAFF63".equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e000-0172c0a812fd463ED552";
        }
        if ("71D272F1".equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e000-016ec0a812fd463ED552";
        }
        if ("FA1292B4".equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e000-0167c0a812fd463ED552";
        }
        if ("500AB75E".equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e000-0163c0a812fd463ED552";
        }
        if ("A4D04D23".equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e000-017bc0a812fd463ED552";
        }
        if ("A4D04D24".equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e000-0177c0a812fd463ED552";
        }
        if ("8FA62986".equals(billBosType)) {
            billTypeId = "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552";
        }
        if ("A4D04D25".equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e001-1152c0a812fd463ED552";
        }
        if (SCMConstant.BOSTYPE_STOCKTRANSFER.equals(billBosType)) {
            billTypeId = "50957179-0105-1000-e003-3152c0a812fd463ED552";
        }
        if (billTypeId != null && aInvBillBaseInfo.get("entry") != null) {
            IObjectCollection entryCol = (IObjectCollection)aInvBillBaseInfo.get("entry");
            InvBillBaseEntryInfo entryInfo = null;
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
                if (entryInfo == null || aInvBillBaseInfo.getBizDate() == null) continue;
                entryInfo.setDate("bizDate", aInvBillBaseInfo.getBizDate());
            }
        }
    }

    public String getParamCon4Audit() {
        return "INM103";
    }

    public String getParamCon4UnAudit() {
        return "INM104";
    }

    public boolean isInclundCostCenter(Context ctx, String costCenterInfoID, String companyOrgInfoID) throws EASBizException, BOSException {
        boolean flag = false;
        if (costCenterInfoID == null || companyOrgInfoID == null) {
            return flag;
        }
        Set ids = SCMUtils.getCostCenterByCompanyOrgInfo((Context)ctx, (String)companyOrgInfoID);
        flag = ids.contains(costCenterInfoID);
        return flag;
    }

    public void isRemoveCostCenter(Context ctx, InvBillBaseInfo info, String companyOrgInfoID) throws EASBizException, BOSException {
        boolean flag;
        String costCenterOrgUnitID = null;
        if (info.getCostCenterOrgUnit() != null && info.getCostCenterOrgUnit().getId() != null) {
            costCenterOrgUnitID = info.getCostCenterOrgUnit().getId().toString();
        }
        if (!(flag = this.isInclundCostCenter(ctx, costCenterOrgUnitID, companyOrgInfoID))) {
            info.setCostCenterOrgUnit(null);
        }
    }

    protected void handleDefaultBotpTransaction(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        if (null == info) {
            return;
        }
        TransactionTypeInfo transactionType = info.getTransactionType();
        if (transactionType == null) {
            info.setTransactionType(this.getDefaultBotpTransaction(ctx, info));
        } else {
            this.isBotpConfigTransactionType = true;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)transactionType.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            CoreBaseCollection collection = TransactionTypeFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
            if (collection.size() > 0) {
                info.setTransactionType(TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionType.getId().toString()), InvCommonUtils.getTransactionSelectorItemCol()));
            } else {
                info.setTransactionType(null);
            }
        }
    }

    protected TransactionTypeInfo getDefaultBotpTransaction(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        TransactionTypeInfo transactionType = null;
        if (null == info) {
            return transactionType;
        }
        transactionType = info.getTransactionType();
        TransactionTypeCollection col = null;
        if (null == info.getTransactionType()) {
            transactionType = info.getBillType() != null && info.getBillType().getId().toString().equals("50957179-0105-1000-e001-1152c0a812fd463ED552") ? InvCommonUtils.getDefaultTransactionType(ctx, info.getBillType().getId().toString()) : InvCommonUtils.getDefaultTransactionType(ctx, this.getBillTypeId(), info.getBizType().getId().toString());
        } else {
            this.isBotpConfigTransactionType = true;
            col = InvCommonUtils.getTransactionTypeColForBOTP(ctx, this.getBillTypeId());
            if (!this.isTransTypeValid(col, info)) {
                transactionType = null;
            }
        }
        if (transactionType != null && transactionType.getRiType() != null && transactionType.getRiType().size() == 1) {
            transactionType = InvAppUtils.getTransType(ctx, transactionType.getId().toString());
        }
        return transactionType;
    }

    protected void initBotpData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        InvBillBaseInfo info = (InvBillBaseInfo)model;
        SCMUtil.succeedSourceBillReservationInfo((Context)ctx, (IObjectValue)model);
        if (info.getBillType() != null && !info.getBillType().getId().toString().equals("50957179-0105-1000-e001-1152c0a812fd463ED552") && null == info.getBizType()) {
            String msg = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"BIZTYPE_CANNOT_NULL", (Context)ctx);
            throw new BOSException(msg);
        }
        if (info.getSourceBillType() == null) {
            throw new SCMBillException(SCMBillException.SOURCEBILLTYPE_IS_NULL);
        }
        if (null == info.getBizDate()) {
            info.setBizDate(Calendar.getInstance().getTime());
        }
        this.handleDefaultBotpTransaction(ctx, info);
        ReservationSplitEntryService service = ReservationSplitEntryService.getInstance(ctx, model);
        service.setReservationSplitEntry(new InvBalanceReservationSplitEntryImpl());
        service.splitReservationEntry();
        CompanyOrgUnitInfo cou = InvBillBaseControllerBean.getCompanyInfo(ctx, info.getStorageOrgUnit());
        this.isRemoveAdminOrgUnit(ctx, info);
        IObjectValue adminOrgUnit = info.getObjectValue("adminOrgUnit");
        if (cou != null && adminOrgUnit != null && info.getCostCenterOrgUnit() == null) {
            CostCenterOrgUnitInfo costCenter = SCMUtils.getCostCenterByOrgInfo((Context)ctx, (String)cou.getId().toString(), (String)adminOrgUnit.getBOSUuid("id").toString());
            info.setCostCenterOrgUnit(costCenter);
        }
        if (cou != null) {
            this.isRemoveCostCenter(ctx, info, cou.getId().toString());
        }
        InvUpdateTypeInfo invUpdateType = null;
        IObjectCollection entries = this.getEntryCollection(info);
        InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entries.getObject(0);
        BigDecimal assistQty = null;
        CoreBaseCollection coll = InvCommonUtils.getSourceBillCollection(ctx, entries);
        String materialID = "";
        int localAmountPrecision = 2;
        if (cou != null) {
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
            localAmountPrecision = currencyInfo.getPrecision();
        }
        if (!CollectionUtil.isEmpty((IObjectCollection)entries) && info.getTransactionType() != null) {
            EntityViewInfo view = null;
            String storageOrgUnitId = info.getStorageOrgUnit().getId().toString();
            HashSet<String> materialIdSet = new HashSet<String>();
            HashSet<String> storageOrgUnitIdSet = new HashSet<String>();
            storageOrgUnitIdSet.add(storageOrgUnitId);
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (InvBillBaseEntryInfo)entries.getObject(i);
                entry.setCompanyOrgUnit(cou);
                if (entry.getMaterial() == null || entry.getMaterial().getId() == null) continue;
                materialIdSet.add(entry.getMaterial().getId().toString());
            }
            Map<String, MaterialCompanyInfoInfo> companyInfoMap = InvServerUtils.getMatCompanyInfoMap(ctx, info);
            Map<String, MultiMeasureUnitInfo> muMap = InvServerUtils.getMultiMeasureUnitMap(ctx, info);
            Map isLotMap = InvServerUtils.getMaterialInvMap(ctx, storageOrgUnitIdSet, materialIdSet, new String[]{"FIsLotNumber"});
            int size2 = entries.size();
            for (int i = 0; i < size2; ++i) {
                entry = (InvBillBaseEntryInfo)entries.getObject(i);
                if (null == entry.getInvUpdateType()) {
                    view = InvCommonUtils.buildInvUpdateTypeEntityView(ctx, info, i, false, coll);
                    invUpdateType = InvCommonUtils.getDefaultInvUpdateTypeInfo(ctx, view);
                    entry.setInvUpdateType(invUpdateType);
                }
                if (entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                    materialID = entry.getMaterial().getId().toString();
                    MaterialCompanyInfoInfo materialCompanyInfo = companyInfoMap.get(materialID);
                    int pricePrecision = 6;
                    pricePrecision = materialCompanyInfo != null ? materialCompanyInfo.getMateial().getPricePrecision() : entry.getMaterial().getPricePrecision();
                    if (materialCompanyInfo != null && materialCompanyInfo.getStandardCost() != null) {
                        MeasureUnitInfo unit = entry.getUnit();
                        if (unit == null) {
                            throw new InvException(InvException.MEASURE_UNIT_NOT_NULL_BOTP);
                        }
                        MultiMeasureUnitInfo multiUnitInfo = muMap.get(entry.getMaterial().getId().toString() + entry.getUnit().getId().toString());
                        BigDecimal coefficient = new BigDecimal("1.00");
                        if (multiUnitInfo != null) {
                            coefficient = multiUnitInfo.getBaseConvsRate();
                        }
                        BigDecimal unitStandardCost = materialCompanyInfo.getStandardCost();
                        if (coefficient != null) {
                            unitStandardCost = unitStandardCost.multiply(coefficient).setScale(pricePrecision, 4);
                        }
                        entry.setUnitStandardCost(unitStandardCost);
                        entry.setStandardCost(entry.getQty().multiply(entry.getUnitStandardCost()).setScale(localAmountPrecision, 4));
                    }
                    if (materialCompanyInfo != null && AccountType.STANDARDCOST.equals((Object)materialCompanyInfo.getAccountType())) {
                        if (entry.getUnitActualCost() == null) {
                            entry.setUnitActualCost(BigDecimal.ZERO);
                        } else {
                            entry.setUnitActualCost(entry.getUnitStandardCost().setScale(pricePrecision, 4));
                        }
                    }
                    if (entry.getActualCost() == null) {
                        BigDecimal unitActualCost = entry.getUnitActualCost() == null ? BigDecimal.ZERO : entry.getUnitActualCost();
                        entry.setUnitActualCost(unitActualCost.setScale(pricePrecision, 4));
                        BigDecimal qty = entry.getQty() == null ? BigDecimal.ZERO : entry.getQty();
                        entry.setActualCost(unitActualCost.multiply(qty).setScale(localAmountPrecision, 4));
                    }
                }
                if (entry.getUnVmiSettleBaseQty() == null) {
                    entry.setUnVmiSettleBaseQty(entry.getBaseQty() == null ? BigDecimal.ZERO : entry.getBaseQty());
                }
                if (entry.getTotalVmiSettleBaseQty() == null) {
                    entry.setTotalVmiSettleBaseQty(BigDecimal.ZERO);
                }
                if (entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                    String materialId = entry.getMaterial().getId().toString();
                    boolean isLotNumber = false;
                    if (isLotMap.get(storageOrgUnitId + materialId) != null) {
                        isLotNumber = "1".equals(((Map)isLotMap.get(storageOrgUnitId + materialId)).get("FIsLotNumber"));
                    }
                    if (entry.getLot() != null && !isLotNumber) {
                        entry.setLot(null);
                    }
                }
                if (entry.getAssistUnit() == null || entry.getAssistQty() != null) continue;
                assistQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), entry.getAssistUnit(), entry.getMaterial(), entry.getQty());
                entry.setAssistQty(assistQty);
            }
        }
        if (!(info instanceof PurInWarehsBillInfo) && !(info instanceof SaleIssueBillInfo)) {
            this.reCalBillBaseQty(ctx, info);
        }
    }

    private void reCalBillBaseQty(Context ctx, InvBillBaseInfo info) {
        InvBillBaseEntryInfo entry = null;
        IObjectCollection entries = this.getEntryCollection(info);
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (InvBillBaseEntryInfo)entries.getObject(i);
            if (entry.getBaseQty() != null && BigDecimal.ZERO.compareTo(entry.getBaseQty()) != 0) continue;
            this.calBaseQtyByQty(ctx, entry);
        }
    }

    protected void calBaseQtyByQty(Context ctx, InvBillBaseEntryInfo entry) {
        BigDecimal qty = entry.getQty();
        BigDecimal baseQty = SysConstant.BIGZERO;
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        if (qty != null && qty.compareTo(SysConstant.BIGZERO) == 0) {
            entry.setBaseQty(baseQty);
            return;
        }
        try {
            BigDecimal coefficient;
            MultiMeasureUnitInfo mulUnit = this.getMulUnit(ctx, entry.getUnit(), entry.getMaterial());
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = entry.getMaterial().getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(entry.getMaterial().getId())).getBaseUnit();
                }
                mulUnit = this.getMulUnit(ctx, baseUnit, entry.getMaterial());
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            entry.setBaseQty(baseQty);
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = null;
        immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    protected boolean isTransTypeValid(TransactionTypeCollection col, InvBillBaseInfo info) throws EASBizException, BOSException {
        String transID = info.getTransactionType().getId().toString();
        int size = col.size();
        for (int index = 0; index < size; ++index) {
            if (!col.get(index).getId().toString().equals(transID)) continue;
            return true;
        }
        return false;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        AbstractInvBillBaseEntryInfo entry = null;
        CompanyOrgUnitInfo cou = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            InvBillBaseInfo info = (InvBillBaseInfo)collection.getObject(i);
            if (info == null) continue;
            this.initBotpData(ctx, (IObjectValue)info);
            IObjectCollection entrys = this.getEntryCollection(info);
            if (entrys != null) {
                entry = (InvBillBaseEntryInfo)entrys.getObject(0);
            }
            if (entry == null) continue;
            cou = entry.getCompanyOrgUnit();
            if (cou == null) {
                cou = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            }
            if (entry.getCompanyOrgUnit() != null || cou == null) continue;
            entry.setCompanyOrgUnit(cou);
        }
    }

    public Map getMaterialPlanCollec(Context ctx, Set materialIDS, Set orgIDs) throws BOSException {
        if (materialIDS == null || orgIDs == null) {
            return new HashMap();
        }
        HashMap<String, MaterialPlanInfo> matPlans = new HashMap<String, MaterialPlanInfo>();
        MaterialPlanInfo matPlanInfo = null;
        IMaterialPlan iMatPlan = MaterialPlanFactory.getLocalInstance((Context)ctx);
        String key = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIDS, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgIDs, CompareType.INCLUDE));
        view.setFilter(filter);
        MaterialPlanCollection coll = iMatPlan.getMaterialPlanCollection(view);
        for (int j = 0; j < coll.size(); ++j) {
            matPlanInfo = coll.get(j);
            if (matPlanInfo == null || matPlanInfo.getMaterial() == null || matPlanInfo.getOrgUnit() == null) continue;
            key = matPlanInfo.getMaterial().getId().toString() + matPlanInfo.getOrgUnit().getId().toString();
            matPlans.put(key, matPlanInfo);
        }
        return matPlans;
    }

    protected void _fillLotFrame(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        HashMap<String, MaterialInventoryInfo> minvmap = null;
        MaterialInventoryCollection matInvcol = this.getMaterialInventoryCollection(ctx, (InvBillBaseInfo)model);
        if (matInvcol != null && matInvcol.size() > 0) {
            minvmap = new HashMap<String, MaterialInventoryInfo>();
            MaterialInventoryInfo matInvInfo = null;
            String materialID = null;
            int size = matInvcol.size();
            for (int i = 0; i < size; ++i) {
                matInvInfo = matInvcol.get(i);
                if (matInvInfo == null || matInvInfo.getMaterial() == null || matInvInfo.getMaterial().getId() == null) continue;
                materialID = matInvInfo.getMaterial().getId().toString();
                minvmap.put(materialID, matInvInfo);
            }
        }
        this.resetEntryMaterialInfo(ctx, (InvBillBaseInfo)model);
        if (minvmap != null) {
            List FrameList = this.getlotFrameList(ctx, model, minvmap);
            if (FrameList == null || FrameList.size() == 0) {
                return;
            }
            try {
                List retLotFrameList = LotRuleFactory.getLocalInstance((Context)ctx).fillLotFrames(FrameList);
                for (LotFrame lf : retLotFrameList) {
                    if (lf == null) continue;
                    String entryid = lf.getEntryID();
                    this.fillLotNumber(ctx, model, lf, entryid);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void resetEntryMaterialInfo(Context ctx, InvBillBaseInfo billInfo) throws BOSException {
        int i;
        int size;
        MaterialCollection matInvcol = InvBillBaseControllerBean.getMaterialCollection(ctx, billInfo);
        HashMap<String, MaterialInfo> minvmap = new HashMap<String, MaterialInfo>();
        if (matInvcol != null && matInvcol.size() > 0) {
            MaterialInfo matInvInfo = null;
            String materialID = null;
            size = matInvcol.size();
            for (i = 0; i < size; ++i) {
                matInvInfo = matInvcol.get(i);
                if (matInvInfo == null || matInvInfo.getId() == null) continue;
                materialID = matInvInfo.getId().toString();
                minvmap.put(materialID, matInvInfo);
            }
        }
        IObjectCollection entryCol = null;
        entryCol = billInfo.getBillType() != null && "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(billInfo.getBillType().getId().toString()) ? (IObjectCollection)billInfo.get("entries") : (IObjectCollection)billInfo.get("entry");
        size = entryCol.size();
        for (i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            if (null == entryInfo.getMaterial() || null == entryInfo.getMaterial().getId() || null == minvmap.get(entryInfo.getMaterial().getId().toString())) continue;
            entryInfo.setMaterial((MaterialInfo)minvmap.get(entryInfo.getMaterial().getId().toString()));
        }
    }

    private static MaterialCollection getMaterialCollection(Context ctx, InvBillBaseInfo billInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> matidSet = new HashSet<String>();
        IObjectCollection entryCol = null;
        entryCol = billInfo.getBillType() != null && "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(billInfo.getBillType().getId().toString()) ? (IObjectCollection)billInfo.get("entries") : (IObjectCollection)billInfo.get("entry");
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            MaterialInfo matInfo = entryInfo.getMaterial();
            if (matInfo == null || matInfo.getId() == null) continue;
            matidSet.add(matInfo.getId().toString());
        }
        if (matidSet.size() < 1) {
            return null;
        }
        FilterItemInfo fii = new FilterItemInfo("id", matidSet, CompareType.INCLUDE);
        filter.getFilterItems().add(fii);
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("pricePrecision");
        selector.add("baseUnit.id");
        viewInfo.setSelector(selector);
        return MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
    }

    private List getlotFrameList(Context ctx, IObjectValue model, HashMap minvmap) {
        if (model == null) {
            return null;
        }
        LinkedList<LotFrame> FrameList = new LinkedList<LotFrame>();
        IObjectCollection entryCol = null;
        InvBillBaseInfo billInfo = (InvBillBaseInfo)model;
        entryCol = (IObjectCollection)billInfo.get("entry");
        StorageOrgUnitInfo storage = null;
        storage = billInfo.getStorageOrgUnit();
        String lot = null;
        String materialID = null;
        MaterialInventoryInfo matInvInfo = null;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            MaterialInfo matInfo = entryInfo.getMaterial();
            lot = entryInfo.getLot();
            if (matInfo == null || matInfo.getId() == null || (matInvInfo = (MaterialInventoryInfo)minvmap.get(materialID = matInfo.getId().toString())) == null || !matInvInfo.isIsLotNumber() || lot != null) continue;
            LotFrame lotFrame = new LotFrame();
            lotFrame.setSeq(entryInfo.getSeq());
            lotFrame.setEntryID(entryInfo.getId().toString());
            if (storage != null && storage.getId() != null) {
                lotFrame.setMainBizOrg(storage.getId().toString());
            }
            lotFrame.setMaterial(matInfo.getId().toString());
            FrameList.add(lotFrame);
        }
        return FrameList;
    }

    protected void fillFrameFreeProp(LotFrame lotFrame, InvBillBaseInfo billInfo, InvBillBaseEntryInfo entryInfo) {
    }

    protected void fillLotNumber(Context ctx, IObjectValue model, LotFrame lotFrame, String entryid) throws BOSException, EASBizException {
        int bizDirection;
        if (model == null) {
            return;
        }
        InvBillBaseInfo billInfo = (InvBillBaseInfo)model;
        TransactionTypeInfo tranType = null;
        tranType = billInfo.getTransactionType();
        if (tranType == null) {
            return;
        }
        HashMap<String, InvBillBaseEntryInfo> entryMap = new HashMap<String, InvBillBaseEntryInfo>();
        IObjectCollection entryCol = null;
        InvBillBaseEntryInfo entryInfo = null;
        String enID = null;
        entryCol = (IObjectCollection)billInfo.get("entry");
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            if (entryInfo == null) {
                return;
            }
            if (entryInfo == null || entryInfo.getId() == null) continue;
            enID = entryInfo.getId().toString();
            entryMap.put(enID, entryInfo);
        }
        entryInfo = null;
        if (entryMap != null && entryMap.containsKey(entryid)) {
            entryInfo = (InvBillBaseEntryInfo)entryMap.get(entryid);
        }
        if (entryInfo == null) {
            return;
        }
        String billTypeID = tranType.getBillType().getId().toString();
        if (tranType.getRiType() == null || tranType.getRiType().getBizDirection() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("riType.id"));
            selector.add(new SelectorItemInfo("riType.name"));
            selector.add(new SelectorItemInfo("riType.number"));
            selector.add(new SelectorItemInfo("riType.bizDirection"));
            tranType = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tranType.getId().toString()), selector);
        }
        if ((bizDirection = tranType.getRiType().getBizDirection().getValue()) == -1 && ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID) && entryInfo.getInvUpdateType().isIsNotUpdateInv())) {
            return;
        }
        MaterialInfo material = entryInfo.getMaterial();
        if (material == null) {
            return;
        }
        LotRuleInfo lotRult = lotFrame.getLotRule();
        String billNumber = billInfo.getNumber();
        if (LotRuleInfo.containsBillNumber((LotRuleInfo)lotFrame.getLotRule()) && (billNumber == null || billNumber.trim().length() == 0)) {
            return;
        }
        lotFrame.setBillNumber(billNumber);
        StorageOrgUnitInfo mainBizOrg = billInfo.getStorageOrgUnit();
        if (LotRuleInfo.containsMainOrg((LotRuleInfo)lotRult) && mainBizOrg == null) {
            return;
        }
        if (mainBizOrg != null) {
            lotFrame.setMainBizOrg(mainBizOrg.getNumber());
        } else {
            lotFrame.setMainBizOrg(null);
        }
        AdminOrgUnitInfo department = billInfo.getAdminOrgUnit();
        if (LotRuleInfo.containsDepartment((LotRuleInfo)lotRult) && department == null) {
            return;
        }
        if (department != null) {
            lotFrame.setDepartment(department.getNumber());
        } else {
            lotFrame.setDepartment(null);
        }
        java.sql.Date bizDate = (java.sql.Date)billInfo.getBizDate();
        if (LotRuleInfo.containsBizDate((LotRuleInfo)lotRult) && bizDate == null) {
            return;
        }
        lotFrame.setBizDate((Date)bizDate);
        if (material != null) {
            lotFrame.setMaterial(material.getNumber());
        }
        WarehouseInfo warehouse = entryInfo.getWarehouse();
        if (LotRuleInfo.containsWarehouse((LotRuleInfo)lotRult) && warehouse == null) {
            return;
        }
        if (warehouse != null) {
            lotFrame.setWarehouse(warehouse.getNumber());
        } else {
            lotFrame.setWarehouse(null);
        }
        java.sql.Date mfg = (java.sql.Date)entryInfo.getMfg();
        if (LotRuleInfo.containsMFG((LotRuleInfo)lotRult) && mfg == null) {
            return;
        }
        lotFrame.setMfg((Date)mfg);
        java.sql.Date exp = (java.sql.Date)entryInfo.getExp();
        if (LotRuleInfo.containsEXP((LotRuleInfo)lotRult) && exp == null) {
            return;
        }
        lotFrame.setExp((Date)exp);
        this.fillFrameFreeProp(lotFrame, billInfo, entryInfo);
        this.fillLotNumber(ctx, model, lotFrame, entryInfo);
        String supplierLotNo = lotFrame.getSupplierlotno();
        if (LotRuleInfo.containsSupplierNo((LotRuleInfo)lotRult) && supplierLotNo == null) {
            return;
        }
        String customer = lotFrame.getCustomer();
        if (LotRuleInfo.containsCustomer((LotRuleInfo)lotRult) && customer == null) {
            return;
        }
        String supplier = lotFrame.getSupplier();
        if (LotRuleInfo.containsSupplier((LotRuleInfo)lotRult) && supplier == null) {
            return;
        }
        long currentSerial = this.getSerialNumber(ctx, lotFrame, material.getId().toString());
        lotFrame.setCurrentSerial(currentSerial);
        String lotNumber = lotFrame.getLotNumber(ctx);
        entryInfo.setLot(lotNumber);
    }

    protected LotFrame fillLotNumber(Context ctx, IObjectValue model, LotFrame lotFrame, InvBillBaseEntryInfo entryInfo) throws EASBizException, BOSException {
        return lotFrame;
    }

    private long getSerialNumber(Context ctx, LotFrame lotFrame, String materialID) throws BOSException {
        if (lotFrame == null) {
            return 0L;
        }
        LotRuleInfo lotRult = lotFrame.getLotRule();
        String lotRuleAssign = lotFrame.getLotRuleAssign();
        long serialNumber = 0L;
        try {
            serialNumber = LotRuleFactory.getLocalInstance((Context)ctx).fillSerialNumber(materialID, lotRult, lotRuleAssign);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return serialNumber;
    }

    protected boolean isNeedCheckInvUpdateType() {
        return false;
    }

    private final void checkInvUpdateType(InvBillBaseInfo info) throws EASBizException, BOSException {
        if (null == info || CollectionUtil.isEmpty((IObjectCollection)info.getEntries()) || !this.isNeedCheckInvUpdateType()) {
            return;
        }
        IObjectCollection col = info.getEntries();
        InvBillBaseEntryInfo entry = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = (InvBillBaseEntryInfo)col.getObject(i);
            if (entry.getInvUpdateType() != null) continue;
            throw new InvBizException(InvBizException.INVUPDATETYPE_ISNULL);
        }
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        InvBillBaseInfo model = this.getInvBillBaseInfo(ctx, (IObjectPK)new ObjectStringPK(id), this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected SelectorItemCollection getSelector(boolean isNeedEntrySelector) {
        return SCMSelectorFactory.getInvBillBaseSelector((boolean)isNeedEntrySelector);
    }

    protected void reCalCost4UnitSource(Context ctx, InvBillBaseInfo invBillBaseInfo, InvBillBaseEntryInfo invBillBaseEntryInfo, String sourceUnitId) throws BOSException, EASBizException {
        BigDecimal unitActualCost = invBillBaseEntryInfo.getUnitActualCost();
        unitActualCost = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)unitActualCost, (SCMBillEntryBaseInfo)invBillBaseEntryInfo, (String)sourceUnitId);
        invBillBaseEntryInfo.setUnitActualCost(unitActualCost);
        BigDecimal actualCost = SCMCommonUtil.calActualCost((Context)ctx, (BigDecimal)unitActualCost, (BigDecimal)invBillBaseEntryInfo.getQty(), (StorageOrgUnitInfo)invBillBaseInfo.getStorageOrgUnit());
        invBillBaseEntryInfo.setActualCost(actualCost);
    }

    protected void setBotpRelationEntry(Context ctx, PreparedStatement insertBotpRelationEntryStmt, String srcObjectID, String destObjectID, String keyID, boolean isChildBill) throws BOSException, SQLException {
    }

    protected boolean _checkOtherWhenDel(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        if (invBillBaseInfo.getBaseStatus() == BillBaseStatusEnum.DELETED) {
            throw new InvBizException(InvBizException.CANCELLATION_CANT_DELETE);
        }
        return super._checkOtherWhenDel(ctx, model);
    }

    @Override
    protected void _updateBillsFlagSQL(Context ctx, IObjectValue model, int flag) throws BOSException, EASBizException {
        try {
            CalBillHelper.setIsGenCalFlag(ctx, model, flag);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected void updateBarcodeInventrory(Context ctx, IObjectPK pk, InvBillBaseInfo billInfo, BatchActionEnum actionName) throws BOSException {
        try {
            Class<?> barcodeBaseDataClass = Class.forName("com.kingdee.eas.barcode.scm.util.BarcodeInvServerUtils");
            Method method = barcodeBaseDataClass.getMethod("updateBarcodeInventrory", Context.class, BatchActionEnum.class, IObjectValue.class, String.class);
            method.invoke(barcodeBaseDataClass.newInstance(), ctx, actionName, billInfo, billInfo.getBOSType().toString());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectValue _matchLotInfo4Required(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        return this._matchLotInfo(ctx, billInfo);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._submit(ctx, model);
    }

    public void isRemoveAdminOrgUnit(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        if (info.getAdminOrgUnit() == null || info.getAdminOrgUnit().getId() == null) {
            return;
        }
        if (info.getStorageOrgUnit() == null) {
            return;
        }
        String adminOrgUnitId = info.getAdminOrgUnit().getId().toString();
        OrgUnitCollection orgs = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(info.getStorageOrgUnit().getId().toString(), 4, 0);
        boolean isInclude = false;
        if (orgs != null && orgs.size() > 0) {
            for (int i = 0; i < orgs.size(); ++i) {
                if (!adminOrgUnitId.equals(orgs.get(i).getId().toString())) continue;
                isInclude = true;
                break;
            }
        }
        if (!isInclude) {
            info.setAdminOrgUnit(null);
        }
    }

    protected void checkCloseAccount(Context ctx, InvBillBaseInfo model) throws EASBizException, BOSException {
        boolean isShuted;
        Date bizDate = model.getBizDate();
        if (bizDate == null) {
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        CompanyOrgUnitInfo cou = this._getCompanyOrgUnit(ctx, (IObjectValue)model);
        if (cou != null && (isShuted = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou))) {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)cou);
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            if (periodInfo != null && periodInfo.equals((Object)curPeriodInfo)) {
                throw new SCMBillException(SCMBillException.CURRENT_PERIOD_COLSED, (Object[])new String[]{cou.getName()});
            }
        }
    }

    protected Map<String, LocationInfo> getDefaultLocation(Context ctx, InvBillBaseInfo bill) throws EASBizException, BOSException {
        HashMap<String, LocationInfo> defaultLocationMap = new HashMap<String, LocationInfo>();
        StorageOrgUnitInfo sou = bill.getStorageOrgUnit();
        if (null == sou || bill.getEntries().size() == 0) {
            return defaultLocationMap;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> warehsIdSet = new HashSet<String>();
        int size = bill.getEntries().size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)bill.getEntries().getObject(i);
            MaterialInfo materialInfo = entryInfo.getMaterial();
            if (materialInfo != null) {
                materialIdSet.add(materialInfo.getId().toString());
            }
            if (entryInfo.getWarehouse() == null) continue;
            warehsIdSet.add(entryInfo.getWarehouse().getId().toString());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)sou.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("ISDEFAULTLOCATION", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("warehouse.id", warehsIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection si = new SelectorItemCollection();
        si.add(new SelectorItemInfo("id"));
        si.add(new SelectorItemInfo("material.id"));
        si.add(new SelectorItemInfo("storageOrg.id"));
        si.add(new SelectorItemInfo("warehouse.id"));
        si.add(new SelectorItemInfo("location.id"));
        si.add(new SelectorItemInfo("location.name"));
        si.add(new SelectorItemInfo("location.number"));
        entityViewInfo.setSelector(si);
        IMaterialStorageAssign iMatStoAssign = MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
        MaterialStorageAssignCollection mic = iMatStoAssign.getMaterialStorageAssignCollection(entityViewInfo);
        if (null == mic || mic.size() == 0) {
            return defaultLocationMap;
        }
        MaterialStorageAssignInfo info = null;
        int size2 = mic.size();
        for (int i = 0; i < size2; ++i) {
            info = mic.get(i);
            String key = info.getMaterial().getId().toString() + info.getWarehouse().getId().toString();
            defaultLocationMap.put(key, info.getLocation());
        }
        return defaultLocationMap;
    }

    protected final void setCurrency(Context ctx, IObjectValue model, AbstractObjectCollection entries) throws BOSException, EASBizException {
        if (!entries.isEmpty()) {
            String descBosType = model.getBOSType().toString();
            HashSet<String> sourceBillIds = new HashSet<String>();
            HashSet<String> coreBillIds = new HashSet<String>();
            boolean isCentralBalance = false;
            for (int i = 0; i < entries.size(); ++i) {
                IObjectValue entry = entries.getObject(i);
                Object sourceBillId = entry.get("sourceBillId");
                if (null != sourceBillId && !StringUtils.isEmpty((String)sourceBillId.toString())) {
                    sourceBillIds.add(sourceBillId.toString());
                }
                if ("783061E3".equals(descBosType)) {
                    Object purorderid = entry.get("purorder");
                    if (null != purorderid && !StringUtils.isEmpty((String)purorderid.toString())) {
                        coreBillIds.add(purorderid.toString());
                    }
                    isCentralBalance = entry.getBoolean("iscenterbalance");
                    continue;
                }
                if (!"CC3E933B".equals(descBosType)) continue;
                Object saleorderid = entry.get("saleorder");
                if (null != saleorderid && !StringUtils.isEmpty((String)saleorderid.toString())) {
                    coreBillIds.add(saleorderid.toString());
                }
                isCentralBalance = entry.getBoolean("iscenterbalance");
            }
            if (isCentralBalance) {
                return;
            }
            if (sourceBillIds.isEmpty()) {
                return;
            }
            GeneralCurrencyDealBuilder currencyDeal = new GeneralCurrencyDealBuilder(ctx, new ArrayList(sourceBillIds), new ArrayList(coreBillIds), descBosType);
            String currencyId = currencyDeal.getCurrency();
            if (null != currencyId) {
                CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                model.put("currency", (Object)currencyInfo);
                Object storageOrgUnit = model.get("storageorgunit");
                if (null != storageOrgUnit) {
                    BOSUuid storageOrgUnitId = null;
                    if (storageOrgUnit instanceof String) {
                        storageOrgUnitId = BOSUuid.read((String)((String)storageOrgUnit));
                    } else if (storageOrgUnit instanceof StorageOrgUnitInfo) {
                        storageOrgUnitId = ((StorageOrgUnitInfo)storageOrgUnit).getId();
                    } else {
                        return;
                    }
                    CompanyOrgUnitInfo cou = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(storageOrgUnitId);
                    if (null != cou && currencyId.equals(cou.getBaseCurrency().getId().toString())) {
                        model.put("exchangerate", (Object)BigDecimal.ONE);
                    }
                }
            }
        }
    }
}

