/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.cssp.CSOptionFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.SCMFetchDataFacadeFactory;
import com.kingdee.eas.scm.common.SCMParamFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractInvBillEditUIHandler;
import com.kingdee.eas.util.app.ContextUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class InvBillEditUIHandler
extends AbstractInvBillEditUIHandler {
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        if (!(BatchActionEnum.AUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.UNAUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.SUBMIT.equals(request.get("BATCH_ACTION")))) {
            this.fillCouBySou(request, response, context);
            this.fillParamValue(request, context);
            this.fillTransactionType(request, response, context);
        }
        SCMParamFacadeFactory.getLocalInstance((Context)context).getScmSpecialParams(new String[]{"isCanOffSet"});
        String userId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        CSOptionFactory.getLocalInstance((Context)context).getCSOptionCollection("select csName,csNumber,csAssistNumber where userID = '" + userId + "' AND csType = 1");
        CSOptionFactory.getLocalInstance((Context)context).getCSOptionCollection("select csName,csNumber,csAssistNumber where userID = '" + userId + "' AND csType = 2");
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou != null) {
            ParamControlFactory.getLocalInstance((Context)context).getParamValue((IObjectPK)new ObjectUuidPK(cou.getId().toString()), "SCM_CAL_011");
        }
    }

    protected void fillTransactionType(RequestContext request, ResponseContext response, Context ctx) throws Exception {
    }

    private void fillParamValue(RequestContext request, Context ctx) throws Exception {
        BOSUuid souPk;
        String couId = (String)request.get("INV_MAIN_COU_ID");
        if (null != couId) {
            ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(couId), "SCM_CAL_011");
        }
        InvBillBaseInfo invInfo = (InvBillBaseInfo)request.getValue();
        String souId = (String)request.get("STORAGE_ORGUNIT_ID");
        if ((invInfo == null || invInfo.getStorageOrgUnit() == null) && souId == null) {
            return;
        }
        BOSUuid bOSUuid = souPk = souId == null ? invInfo.getStorageOrgUnit().getId() : BOSUuid.read((String)souId);
        if (souPk != null) {
            ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(souPk), "INM008");
        }
    }

    protected void _handleActionCopy(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionCopy(request, response, context);
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
    }

    @Override
    protected void _handleActionSerialNumber(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSNsplit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public void handleQuickAddLine(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.cachedInfosForQuickAddLine(request, response, context);
    }

    protected void cachedInfosForQuickAddLine(RequestContext request, ResponseContext response, Context context) throws Exception {
        InventoryInfo[] inventorys = (InventoryInfo[])request.get("INV_QUTICKADDLINEINVENTORYS");
        if (inventorys != null && inventorys.length > 1) {
            int size = inventorys.length;
            InventoryInfo inventoryInfo = null;
            MaterialInfo materialInfo = null;
            StorageOrgUnitInfo storageInfo = null;
            MaterialInventoryInfo materialInventoryInfo = null;
            IMaterial iMaterialInv = MaterialFactory.getLocalInstance((Context)context);
            IDateOfMinDurability iDateOfMinDurability = DateOfMinDurabilityFactory.getLocalInstance(context);
            for (int index = 0; index < size; ++index) {
                inventoryInfo = inventorys[index];
                materialInfo = inventoryInfo.getMaterial();
                storageInfo = inventoryInfo.getStorageOrgUnit();
                if (materialInfo == null || storageInfo == null || (materialInventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)context).getInventoryInfo(materialInfo.getId().toString(), storageInfo.getId().toString())) == null || !materialInventoryInfo.isIsLotNumber()) continue;
                iDateOfMinDurability.getLot(materialInfo.getId().toString(), storageInfo.getId().toString(), materialInventoryInfo.getIssuePriorityMode());
            }
        }
    }

    protected SCMFetchData fetchData(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        if (!this.isFetchData()) {
            return null;
        }
        SCMFetchDataCondition condition = this.buildCondition(request, response, ctx);
        if (condition == null) {
            return null;
        }
        EntityViewInfo[] view = condition.toEntiryView();
        HashMap<String, SCMFetchDataCondition> initFetchPara = new HashMap<String, SCMFetchDataCondition>();
        initFetchPara.put("Condition", condition);
        return SCMFetchDataFacadeFactory.getLocalInstance((Context)ctx).fetchData(view, initFetchPara);
    }

    protected SCMFetchDataCondition buildCondition(RequestContext request, ResponseContext response, Context context) throws Exception {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        InvBillBaseInfo invbInfo = (InvBillBaseInfo)request.getValue();
        if (invbInfo == null) {
            return null;
        }
        CompanyOrgUnitInfo couInfo = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (this.isFetchData()) {
            condition = this.getNormalCondtion();
            this.setConditionContents(invbInfo, condition, couInfo);
        }
        return condition;
    }

    protected boolean isFetchData() {
        return true;
    }

    protected SCMFetchDataCondition getNormalCondtion() {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        if (this.isFetchData()) {
            condition.setFetchMaterial(true);
            condition.setFetchID(true);
            condition.setFetchNumber(true);
            condition.setFetchName(true);
            condition.setFetchBaseUnit(true);
            condition.setFetchAssistUnit(true);
            condition.setFetchAsstAttrType(true);
            condition.setFetchUseAsstAttrRelation(true);
            condition.setFetchPricePrecision(true);
            condition.setFetchModel(true);
            condition.setFetchSou(true);
            condition.setFetchIsLotNumber(true);
            condition.setFetchIsBatchNo(true);
            condition.setFetchIsSequenceNo(true);
            condition.setFetchIsPeriodValid(true);
            condition.setFetchIsNegative(true);
            condition.setFetchInventoryUnit(true);
            condition.setFetchIssuePriorityMode(true);
            condition.setFetchCompany(true);
            condition.setFetchAccountType(true);
            condition.setFetchStandardCost(true);
            condition.setFetchCompanyStatus(true);
            condition.setFetchUnitPrecision(true);
            condition.setFetchBaseUnitPrecision(true);
            condition.setFetchAsstUnitPrecision(true);
            condition.setFetchDefaultWarehouse(true);
            condition.setFetchDefaultLocation(true);
            condition.setFetchDurability(true);
            condition.setfetchMaterialPlan(true);
            condition.setFetchCloseDateCalMode(true);
        }
        return condition;
    }

    protected void setConditionContents(InvBillBaseInfo invbInfo, SCMFetchDataCondition condition, CompanyOrgUnitInfo couInfo) {
        if (invbInfo.getStorageOrgUnit() == null) {
            return;
        }
        IObjectCollection entryColl = (IObjectCollection)invbInfo.get("entry");
        if (entryColl == null) {
            entryColl = (IObjectCollection)invbInfo.get("entries");
        }
        if (entryColl == null) {
            return;
        }
        int arryLength = 0;
        for (int i = 0; i < entryColl.size(); ++i) {
            MaterialInfo material = ((InvBillBaseEntryInfo)entryColl.getObject(i)).getMaterial();
            if (material == null) continue;
            ++arryLength;
        }
        String[] materialPKs = new String[arryLength];
        String[] unitPKs = new String[arryLength];
        String[] baseUnitPKs = new String[arryLength];
        String[] asstUnitPKs = new String[arryLength];
        String[] warehsPKs = new String[arryLength];
        String[] lots = new String[arryLength];
        String[] locationPks = new String[arryLength];
        String[] assistProperyPKs = new String[arryLength];
        InvBillBaseEntryInfo entryInfo = null;
        int cursor = 0;
        for (int i = 0; i < entryColl.size(); ++i) {
            LocationInfo location;
            WarehouseInfo warehs;
            MeasureUnitInfo asstUnit;
            MeasureUnitInfo baseUnit;
            entryInfo = (InvBillBaseEntryInfo)entryColl.getObject(i);
            MaterialInfo material = entryInfo.getMaterial();
            if (material == null) continue;
            if (material != null) {
                materialPKs[cursor] = material.getId().toString();
            } else if (entryColl.size() == 1) {
                materialPKs = null;
            }
            MeasureUnitInfo unit = entryInfo.getUnit();
            if (unit != null) {
                unitPKs[cursor] = unit.getId().toString();
            }
            if ((baseUnit = entryInfo.getBaseUnit()) != null) {
                baseUnitPKs[cursor] = baseUnit.getId().toString();
            }
            if ((asstUnit = entryInfo.getAssistUnit()) != null) {
                asstUnitPKs[cursor] = asstUnit.getId().toString();
            }
            if ((warehs = entryInfo.getWarehouse()) != null) {
                warehsPKs[cursor] = warehs.getId().toString();
            }
            if ((location = entryInfo.getLocation()) != null) {
                locationPks[cursor] = location.getId().toString();
            }
            lots[cursor] = entryInfo.getLot();
            AsstAttrValueInfo assistProperty = entryInfo.getAssistProperty();
            if (assistProperty != null) {
                assistProperyPKs[cursor] = assistProperty.getId().toString();
            }
            ++cursor;
        }
        InvBillBaseEntryInfo invEntryInfo = (InvBillBaseEntryInfo)entryColl.getObject(0);
        if (couInfo != null) {
            condition.setCou(couInfo);
        } else if (invEntryInfo != null) {
            condition.setCou(invEntryInfo.getCompanyOrgUnit());
        }
        condition.setMaterialPKs(materialPKs);
        condition.setUnitPKs(unitPKs);
        condition.setBaseUnitPKs(baseUnitPKs);
        condition.setAsstUnitPKs(asstUnitPKs);
        condition.setWarehousePKs(warehsPKs);
        condition.setLots(lots);
        condition.setLocationPks(locationPks);
        condition.setSou(invbInfo.getStorageOrgUnit());
        condition.setAssistPropertyPKs(assistProperyPKs);
        condition.setLotFrameList(this.getLotFrameList(invbInfo));
    }

    private List getLotFrameList(InvBillBaseInfo invbInfo) {
        LinkedList<LotFrame> _lotFrameList = new LinkedList<LotFrame>();
        IObjectCollection objectCollection = (IObjectCollection)invbInfo.get("entry");
        if (objectCollection == null || objectCollection.isEmpty()) {
            return null;
        }
        int n = objectCollection.size();
        for (int i = 0; i < n; ++i) {
            InvBillBaseEntryInfo invBillBaseEntryInfo = (InvBillBaseEntryInfo)objectCollection.getObject(i);
            MaterialInfo materialInfo = invBillBaseEntryInfo.getMaterial();
            if (materialInfo == null) continue;
            LotFrame lotFrame = new LotFrame();
            lotFrame.setSeq(invBillBaseEntryInfo.getSeq());
            lotFrame.setMainBizOrg(invbInfo.getStorageOrgUnit().getId().toString());
            lotFrame.setMaterial(materialInfo.getId().toString());
            _lotFrameList.add(lotFrame);
        }
        return _lotFrameList;
    }

    protected void fillCouBySou(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        BOSUuid souPk;
        InvBillBaseInfo invInfo = (InvBillBaseInfo)request.getValue();
        String souId = (String)request.get("STORAGE_ORGUNIT_ID");
        if ((invInfo == null || invInfo.getStorageOrgUnit() == null) && souId == null || request.get("INV_MAIN_COU") != null) {
            return;
        }
        BOSUuid bOSUuid = souPk = souId == null ? invInfo.getStorageOrgUnit().getId() : BOSUuid.read((String)souId);
        if (souPk != null) {
            ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(souPk), "INM009");
        }
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo mainCouInfo = iSCMBillCommonFacade.getCompanyInfo(souPk);
        request.put("INV_MAIN_COU", (Object)mainCouInfo);
        request.put("INV_MAIN_COU_ID", mainCouInfo == null ? null : mainCouInfo.getId().toString());
        if (mainCouInfo != null) {
            SCMUtils.getCostCenterByCompanyOrgInfo((Context)ctx, (String)mainCouInfo.getId().toString());
        }
    }

    protected void addToResponse(ResponseContext response, Class bosObject, String methodName, Class[] params, Object[] paramValue, Object value) throws Exception {
        if (response == null) {
            response = new ResponseContext();
        }
        Method method = bosObject.getMethod(methodName, params);
        response.put((Object)MultiParamKey.create((Method)method, (Object[])paramValue).toString(), value);
    }

    protected void _handleActionFirst(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionFirst(request, response, context);
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
    }

    public void _handleActionLast(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionLast(request, response, context);
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
    }

    public void _handleActionNext(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionNext(request, response, context);
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
    }

    public void _handleActionPre(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionPre(request, response, context);
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
    }

    public void _handleActionRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionRemove(request, response, context);
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
    }

    protected void _handleActionAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAudit(request, response, context);
    }

    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSave(request, response, context);
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
    }

    public void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionEdit(request, response, context);
        this.fetchData(request, response, context);
    }

    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAddNew(request, response, context);
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
    }

    protected void fillServerDate(ResponseContext response, Context ctx) throws Exception {
        SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
    }

    protected void fillPaymentType(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String ptId = (String)request.get("PAYMENTTYPE_ID");
        if (ptId != null) {
            ObjectUuidPK pk = new ObjectUuidPK(ptId);
            PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeInfo((IObjectPK)pk);
        }
    }

    protected void fillAdminOrgUnitInfo(StorageOrgUnitInfo souInfo, ResponseContext response, Context ctx) throws Exception {
        if (souInfo == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(souInfo.getId());
        IFullOrgUnit iFou = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        this.findAndFillAdminOrgUnit(iFou, (IObjectPK)pk, response, ctx);
    }

    private void findAndFillAdminOrgUnit(IFullOrgUnit iFou, IObjectPK pk, ResponseContext response, Context ctx) throws Exception {
        FullOrgUnitInfo fouInfo = iFou.getFullOrgUnitInfo(pk);
        if (!fouInfo.isIsAdminOrgUnit()) {
            ObjectUuidPK parentPk = new ObjectUuidPK(fouInfo.getParent().getId());
            this.findAndFillAdminOrgUnit(iFou, (IObjectPK)parentPk, response, ctx);
        }
    }

    protected void fillDefaultTransactionType(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String ttId = (String)request.get("DEFAULT_TRANSACTION_TYPE_ID");
        if (ttId != null) {
            TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ttId)));
        }
    }

    protected void fillDefaultBillType(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String btId = (String)request.get("DEFAULT_BILLTYPE_ID");
        if (btId != null) {
            BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)btId)));
        }
    }

    protected void fillAuthorizedOrgs(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        ObjectUuidPK otiPk = new ObjectUuidPK(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000074F2827FD"));
        PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgs(request.getUserPK(), OrgType.Storage, (IObjectPK)otiPk, null, null);
    }

    protected void fillAuthorizedOrg(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        ObjectUuidPK otiPk = new ObjectUuidPK(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000074F2827FD"));
        String permItem = (String)request.get("PERMISSION_ITEM");
        PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg(request.getUserPK(), OrgType.Storage, (IObjectPK)otiPk, permItem);
    }

    protected void fillCurrentPeriod(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        SystemEnum systemEnum;
        String couId = (String)request.get("INV_MAIN_COU_ID");
        if (couId == null) {
            this.fillCouBySou(request, response, ctx);
            couId = (String)request.get("INV_MAIN_COU_ID");
        }
        systemEnum = (systemEnum = (SystemEnum)request.get("SCM_SYSTEM_ENUM")) == null ? SystemEnum.INVENTORYMANAGEMENT : systemEnum;
        SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(systemEnum.getValue(), couId);
    }

    protected void fillLocalCurrency(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String couId = (String)request.get("INV_MAIN_COU_ID");
        if (couId == null || couId.length() <= 0) {
            this.fillCouBySou(request, response, ctx);
            couId = (String)request.get("INV_MAIN_COU_ID");
        }
        if (couId == null || couId.length() <= 0) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)couId)));
        if (companyInfo != null) {
            CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()));
        }
    }

    protected void fillCurMainOrgAdminOrg(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        IObjectPK mainOrgID = request.getOrg();
        if (mainOrgID != null) {
            SCMServerUtils.getAdminOrgUnitInfo((Context)ctx, (String)mainOrgID.toString());
            return;
        }
    }

    protected void fillUseWarehsRelationParam(RequestContext request, ResponseContext response, Context ctx) throws Exception {
    }

    public void handleActionCopy(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.handleActionCopy(request, response, context);
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
        this.createNewData(request, response, context);
    }

    protected void _handleActionUnAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionUnAudit(request, response, context);
    }

    protected String getAdminOrgUnitInfo(String orgID, Context context) throws Exception {
        ObjectUuidPK pk;
        if (orgID == null || orgID.length() == 0) {
            return null;
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)context);
        FullOrgUnitInfo aFullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)(pk = new ObjectUuidPK(orgID)));
        if (aFullOrgUnitInfo.isIsAdminOrgUnit()) {
            return orgID;
        }
        String parentID = aFullOrgUnitInfo.getParent().getId().toString();
        return this.getAdminOrgUnitInfo(parentID, context);
    }
}

