/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractInvBuildARAPBillFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.UuidException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Locale;

public class InvBuildARAPBillFacadeControllerBean
extends AbstractInvBuildARAPBillFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private String languaeTag = "";
    public static final String SUB_SYSTEM_AP = "com.kingdee.eas.fi.ar.ap.ap";
    public static final String SUB_SYSTEM_AR = "com.kingdee.eas.fi.ar.ar";

    private String getAPBillBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return "48DA3A71";
    }

    private String getAPBillEntryBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return "ED4DBC81";
    }

    private String getAPPlanBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return "838B993A";
    }

    private String getARBillBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return "FC910EF3";
    }

    private String getARBillEntryBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return "BC91693F";
    }

    private String getARPlanBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return "1EE05CBC";
    }

    private String getPurInBillBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new PurInWarehsBillInfo().getBOSType().toString();
    }

    private String getSaleOutBillBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new SaleIssueBillInfo().getBOSType().toString();
    }

    private CompanyOrgUnitInfo getComanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
        IObjectCollection iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entry");
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
            if (aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
                throw new InvBizException(InvBizException.AP_NOCOMPANY);
            }
            ICurrency ic = CurrencyFactory.getLocalInstance((Context)ctx);
            if (aCompanyOrgUnitInfo.getBaseCurrency() == null || aCompanyOrgUnitInfo.getBaseCurrency().getId() == null) {
                ICompanyOrgUnit icou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                aCompanyOrgUnitInfo = icou.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getId()));
            }
            CurrencyInfo ci = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getBaseCurrency().getId()));
            aCompanyOrgUnitInfo.setBaseCurrency(ci);
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    private int getCurrency(Context ctx, Object objCurrency) throws BOSException, EASBizException, UuidException {
        if (objCurrency == null) {
            throw new InvBizException(InvBizException.ARAP_NOCURRENCY);
        }
        ICurrency ic = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo ci = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(((CurrencyInfo)objCurrency).getId()));
        return ci.getPrecision();
    }

    private boolean checkEntryIsPresent(Context ctx, String entryTable, String billID) throws EASBizException, BOSException {
        IRowSet rs = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT COUNT(FID) AS RESC FROM " + entryTable);
        stringBuffer.append(" WHERE FParentID = '" + billID + "'");
        stringBuffer.append(" AND FIsPresent = 0");
        try {
            String sqlStr = stringBuffer.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            if (rs.next() && rs.getInt("RESC") > 0) {
                return false;
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return true;
    }

    private boolean checkSupplierRefCompany(Context ctx, String supplierID, String companyID) throws EASBizException, BOSException {
        ISupplierCompanyInfo isc = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("supplier", (Object)supplierID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)companyID, CompareType.EQUALS));
        evi.setFilter(fi);
        return isc.getCollection(evi) != null && isc.getCollection(evi).size() > 0;
    }

    private boolean checkCustomerRefCompany(Context ctx, String customerID, String companyID) throws EASBizException, BOSException {
        ICustomerCompanyInfo isc = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("customer", (Object)customerID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)companyID, CompareType.EQUALS));
        evi.setFilter(fi);
        return isc.getCollection(evi) != null && isc.getCollection(evi).size() > 0;
    }

    private String getAPBillInsertSql() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append("T_AP_OTHERBILL");
        stringBuffer.append("(FID,");
        stringBuffer.append("FCreatorID,");
        stringBuffer.append("FCreateTime,");
        stringBuffer.append("FBillStatus,");
        stringBuffer.append("FBillType,");
        stringBuffer.append("FBillDate,");
        stringBuffer.append("FNumber,");
        stringBuffer.append("FBizDate,");
        stringBuffer.append("FAuditorID,");
        stringBuffer.append("FAuditDate,");
        stringBuffer.append("FControlUnitID,");
        stringBuffer.append("FCompanyID,");
        stringBuffer.append("FAdminOrgUnitId,");
        stringBuffer.append("FAsstActTypeID,");
        stringBuffer.append("FAsstActID,");
        stringBuffer.append("FAsstActNumber,");
        stringBuffer.append("FAsstActName_" + this.languaeTag + ",");
        stringBuffer.append("FAmount,");
        stringBuffer.append("FAmountLocal,");
        stringBuffer.append("FUnVerifyAmount,");
        stringBuffer.append("FUnVerifyAmountLocal,");
        stringBuffer.append("FVerifyAmount,");
        stringBuffer.append("FVerifyAmountLocal,");
        stringBuffer.append("FSourceBillID,");
        stringBuffer.append("FSourceBillType,");
        stringBuffer.append("FVoucherID,");
        stringBuffer.append("FFiVouchered,");
        stringBuffer.append("FIsTransBill,");
        stringBuffer.append("FAbstractName,");
        stringBuffer.append("FCurrencyID,");
        stringBuffer.append("FExchangeRate,");
        stringBuffer.append("FSettleTypeID,");
        stringBuffer.append("FCashDiscountID,");
        stringBuffer.append("FPurOrgID,");
        stringBuffer.append("FPersonId) ");
        return stringBuffer.toString();
    }

    private String getAPBillSelectSql(Context ctx, String bizTypeID, String APBillID, String billNumber, String billID, String tableName, String companyID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ");
        stringBuffer.append("'" + APBillID + "',");
        stringBuffer.append("A.FCreatorID,");
        stringBuffer.append("A.FCreateTime,");
        stringBuffer.append("3,");
        stringBuffer.append("202,");
        stringBuffer.append("A.FBizDate,");
        stringBuffer.append("'" + billNumber + "',");
        stringBuffer.append("A.FAuditTime,");
        stringBuffer.append("A.FAuditorID,");
        stringBuffer.append("A.FAuditTime,");
        stringBuffer.append("A.FControlUnitID,");
        stringBuffer.append("'" + companyID + "',");
        stringBuffer.append("A.FAdminOrgUnitID,");
        stringBuffer.append("(SELECT TOP 1 FID FROM T_BD_AsstActType WHERE FRealtionDataObject = 'T_BD_Supplier'),");
        stringBuffer.append("A.FSupplierID,");
        stringBuffer.append("D.FNumber,");
        stringBuffer.append("D.FName,");
        stringBuffer.append("(SELECT ISNULL(SUM(FRecievePayAmount),0) FROM T_AP_OtherBillentry WHERE FParentID = '" + APBillID + "'),");
        stringBuffer.append("(SELECT ISNULL(SUM(FRecievePayAmountLocal),0) FROM T_AP_OtherBillentry WHERE FParentID = '" + APBillID + "'),");
        stringBuffer.append("(SELECT ISNULL(SUM(FRecievePayAmount),0) FROM T_AP_OtherBillentry WHERE FParentID = '" + APBillID + "'),");
        stringBuffer.append("(SELECT ISNULL(SUM(FRecievePayAmountLocal),0) FROM T_AP_OtherBillentry WHERE FParentID = '" + APBillID + "'),");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("A.FID,");
        stringBuffer.append("12,");
        stringBuffer.append("NULL,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("NULL,");
        stringBuffer.append("C.FCurrencyID,");
        stringBuffer.append("C.FExchangeRate,");
        if (bizTypeID.equalsIgnoreCase("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("NULL,");
            stringBuffer.append("NULL,");
            stringBuffer.append("NULL,");
            stringBuffer.append("NULL");
        } else if (bizTypeID.equalsIgnoreCase("d8e80652-0107-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("NULL,");
            stringBuffer.append("NULL,");
            stringBuffer.append("C.FPurchaseOrgUnitID,");
            stringBuffer.append("(SELECT TOP 1 FPERSONID FROM T_BD_PURCHASEPERSON WHERE FID = C.FPurchasePersonID)");
        } else if (bizTypeID.equalsIgnoreCase("d8e80652-0106-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("C.FSettlementTypeID,");
            stringBuffer.append("C.FCashDiscountID,");
            stringBuffer.append("C.FPurchaseOrgUnitID,");
            stringBuffer.append("(SELECT TOP 1 FPERSONID FROM T_BD_PURCHASEPERSON WHERE FID = C.FPurchasePersonID)");
        }
        stringBuffer.append(" FROM T_IM_PurInWarehsBill A");
        stringBuffer.append(" INNER JOIN T_IM_PurInWarehsEntry B ON A.FID = B.FParentID");
        stringBuffer.append(" INNER JOIN " + tableName + " C ON B.FPurOrderID = C.FID");
        stringBuffer.append(" INNER JOIN (SELECT E.FID,E.FNumber,E.FName_" + this.languaeTag + " AS FNAME");
        stringBuffer.append(" FROM T_BD_Supplier E INNER JOIN T_BD_SupplierCompanyInfo F ON E.FID = F.FSupplierID");
        stringBuffer.append(" AND F.FComOrgID = '" + companyID + "') D ON A.FSupplierID = D.FID");
        stringBuffer.append(" WHERE A.FID = '" + billID + "' AND B.FIsPresent = 0;");
        return stringBuffer.toString();
    }

    private String getARBillInsertSql() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append("T_AR_OTHERBILL");
        stringBuffer.append("(FID,");
        stringBuffer.append("FCreatorID,");
        stringBuffer.append("FCreateTime,");
        stringBuffer.append("FBillStatus,");
        stringBuffer.append("FBillType,");
        stringBuffer.append("FBillDate,");
        stringBuffer.append("FNumber,");
        stringBuffer.append("FBizDate,");
        stringBuffer.append("FAuditorID,");
        stringBuffer.append("FAuditDate,");
        stringBuffer.append("FControlUnitID,");
        stringBuffer.append("FCompanyID,");
        stringBuffer.append("FAdminOrgUnitId,");
        stringBuffer.append("FAsstActTypeID,");
        stringBuffer.append("FAsstActID,");
        stringBuffer.append("FAsstActNumber,");
        stringBuffer.append("FAsstActName_" + this.languaeTag + ",");
        stringBuffer.append("FAmount,");
        stringBuffer.append("FAmountLocal,");
        stringBuffer.append("FUnVerifyAmount,");
        stringBuffer.append("FUnVerifyAmountLocal,");
        stringBuffer.append("FTotalBadAmount,");
        stringBuffer.append("FTotalBadAmountLocal,");
        stringBuffer.append("FVerifyAmount,");
        stringBuffer.append("FVerifyAmountLocal,");
        stringBuffer.append("FSourceBillID,");
        stringBuffer.append("FSourceBillType,");
        stringBuffer.append("FVoucherID,");
        stringBuffer.append("FFiVouchered,");
        stringBuffer.append("FIsTransBill,");
        stringBuffer.append("FAbstractName,");
        stringBuffer.append("FCurrencyID,");
        stringBuffer.append("FExchangeRate,");
        stringBuffer.append("FSettleTypeID,");
        stringBuffer.append("FCashDiscountID,");
        stringBuffer.append("FSaleOrgID,");
        stringBuffer.append("FPersonId) ");
        return stringBuffer.toString();
    }

    private String getARBillSelectSql(Context ctx, String bizTypeID, String ARBillID, String billNumber, String billID, String tableName, String companyID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ");
        stringBuffer.append("'" + ARBillID + "',");
        stringBuffer.append("A.FCreatorID,");
        stringBuffer.append("A.FCreateTime,");
        stringBuffer.append("3,");
        stringBuffer.append("102,");
        stringBuffer.append("A.FBizDate,");
        stringBuffer.append("'" + billNumber + "',");
        stringBuffer.append("A.FAuditTime,");
        stringBuffer.append("A.FAuditorID,");
        stringBuffer.append("A.FAuditTime,");
        stringBuffer.append("A.FControlUnitID,");
        stringBuffer.append("'" + companyID + "',");
        stringBuffer.append("A.FAdminOrgUnitID,");
        stringBuffer.append("(SELECT TOP 1 FID FROM T_BD_AsstActType WHERE FRealtionDataObject = 'T_BD_Customer'),");
        stringBuffer.append("A.FCustomerID,");
        stringBuffer.append("D.FNumber,");
        stringBuffer.append("D.FName,");
        stringBuffer.append("(SELECT ISNULL(SUM(FRecievePayAmount),0) FROM T_AR_OtherBillentry WHERE FParentID = '" + ARBillID + "'),");
        stringBuffer.append("(SELECT ISNULL(SUM(FRecievePayAmountLocal),0) FROM T_AR_OtherBillentry WHERE FParentID = '" + ARBillID + "'),");
        stringBuffer.append("(SELECT ISNULL(SUM(FRecievePayAmount),0) FROM T_AR_OtherBillentry WHERE FParentID = '" + ARBillID + "'),");
        stringBuffer.append("(SELECT ISNULL(SUM(FRecievePayAmountLocal),0) FROM T_AR_OtherBillentry WHERE FParentID = '" + ARBillID + "'),");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("A.FID,");
        stringBuffer.append("13,");
        stringBuffer.append("NULL,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("NULL,");
        stringBuffer.append("C.FCurrencyID,");
        stringBuffer.append("C.FExchangeRate,");
        if (bizTypeID.equalsIgnoreCase("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("NULL,");
            stringBuffer.append("NULL,");
            stringBuffer.append("NULL,");
            stringBuffer.append("NULL");
        } else if (bizTypeID.equalsIgnoreCase("d8e80652-0110-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("NULL,");
            stringBuffer.append("NULL,");
            stringBuffer.append("C.FSaleOrgUnitID,");
            stringBuffer.append("(SELECT FPERSONID FROM T_BD_SALEPERSON WHERE FID = C.FSalePersonID)");
        } else if (bizTypeID.equalsIgnoreCase("d8e80652-010e-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("C.FSettlementTypeID,");
            stringBuffer.append("C.FCashDiscountID,");
            stringBuffer.append("C.FSaleOrgUnitID,");
            stringBuffer.append("(SELECT FPERSONID FROM T_BD_SALEPERSON WHERE FID = C.FSalePersonID)");
        }
        stringBuffer.append(" FROM T_IM_SaleIssueBill A");
        stringBuffer.append(" INNER JOIN T_IM_SaleIssueEntry B ON A.FID = B.FParentID");
        stringBuffer.append(" INNER JOIN " + tableName + " C ON B.FSaleOrderID = C.FID");
        stringBuffer.append(" INNER JOIN (SELECT E.FID,E.FNumber,E.FName_" + this.languaeTag + " AS FNAME");
        stringBuffer.append(" FROM T_BD_Customer E INNER JOIN T_BD_CustomerCompanyInfo F ON E.FID = F.FCustomerID");
        stringBuffer.append(" AND F.FComOrgID = '" + companyID + "') D ON A.FCustomerID = D.FID");
        stringBuffer.append(" WHERE A.FID = '" + billID + "' AND B.FIsPresent = 0;");
        return stringBuffer.toString();
    }

    private String getAPBillEntryInsertSql() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append("T_AP_OtherBillentry");
        stringBuffer.append("(FID,");
        stringBuffer.append("FParentID,");
        stringBuffer.append("FSeq,");
        stringBuffer.append("FMaterialID,");
        stringBuffer.append("FAssistPropertyID,");
        stringBuffer.append("FMeasureUnitID,");
        stringBuffer.append("FQuantity,");
        stringBuffer.append("FVerifyAmount,");
        stringBuffer.append("FVerifyAmountLocal,");
        stringBuffer.append("FLockVerifyAmt,");
        stringBuffer.append("FLockVerifyAmtLocal,");
        stringBuffer.append("FAccountID,");
        stringBuffer.append("FSourceBillId,");
        stringBuffer.append("FSourceBillEntryId,");
        stringBuffer.append("FCoreBillId,");
        stringBuffer.append("FCoreBillEntryId,");
        stringBuffer.append("FCoreBillTypeID,");
        stringBuffer.append("FCoreBillNumber,");
        stringBuffer.append("FCoreBillEntrySeq,");
        stringBuffer.append("FRemark,");
        stringBuffer.append("FTaxRate,");
        stringBuffer.append("FPrice,");
        stringBuffer.append("FTaxPrice,");
        stringBuffer.append("FDiscountRate,");
        stringBuffer.append("FActualPrice,");
        stringBuffer.append("FAmount,");
        stringBuffer.append("FAmountLocal,");
        stringBuffer.append("FDiscountAmount,");
        stringBuffer.append("FDiscountAmountLocal,");
        stringBuffer.append("FRecievePayAmount,");
        stringBuffer.append("FRecievePayAmountLocal,");
        stringBuffer.append("FUnVerifyAmount,");
        stringBuffer.append("FUnVerifyAmountLocal,");
        stringBuffer.append("FLockUnVerifyAmt,");
        stringBuffer.append("FLockUnVerifyAmtLocal,");
        stringBuffer.append("FTaxAmount,");
        stringBuffer.append("FTaxAmountLocal)");
        return stringBuffer.toString();
    }

    private String getAPBillEntrySelectSql(Context ctx, String bizTypeID, String APBillID, String billNumber, String billID, String tableName, String tableEntryName, boolean convertMode, int precision) throws InvalidDAOMetaDataException {
        String opt = null;
        opt = convertMode ? "/" : "*";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append("NEWBOSID('" + this.getAPBillEntryBOSType(ctx) + "'),");
        stringBuffer.append("'" + APBillID + "',");
        stringBuffer.append("A.FSeq,");
        stringBuffer.append("A.FMaterialID,");
        stringBuffer.append("A.FAssistPropertyID,");
        stringBuffer.append("A.FUnitID,");
        stringBuffer.append("A.FQty,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("NULL,");
        stringBuffer.append("B.FID,");
        stringBuffer.append("A.FID,");
        stringBuffer.append("A.FPurOrderID,");
        stringBuffer.append("A.FPurOrderEntryID,");
        stringBuffer.append("A.FCoreBillTypeID,");
        stringBuffer.append("A.FPurOrderNumber,");
        stringBuffer.append("A.FPurOrderEntrySeq,");
        stringBuffer.append("A.FRemark,");
        stringBuffer.append("C.FTaxRate,");
        stringBuffer.append("A.FOrderPrice,");
        stringBuffer.append("A.FTaxPrice,");
        String getTaxAmountSql = "Round(Decimal(A.FQty * A.FOrderPrice,17,4) * Decimal(C.FTaxRate * 0.01,21,8)," + precision + ")";
        String getPayAmountSql = "Round(Decimal(A.FQty * A.FOrderPrice,17,4)," + precision + ") + ISNULL(" + getTaxAmountSql + ",0)";
        if (bizTypeID.equalsIgnoreCase("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("0,");
            stringBuffer.append("A.FTaxPrice,");
            stringBuffer.append("(A.FQty * A.FOrderPrice),");
            stringBuffer.append("(Round((Decimal(A.FQty * A.FOrderPrice,17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append(getPayAmountSql + ",");
            stringBuffer.append("(Round((Decimal(" + getPayAmountSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getPayAmountSql + ",");
            stringBuffer.append("(Round((Decimal(" + getPayAmountSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getPayAmountSql + ",");
            stringBuffer.append("(Round((Decimal(" + getPayAmountSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getTaxAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getTaxAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate");
        } else if (bizTypeID.equalsIgnoreCase("d8e80652-0107-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("0,");
            stringBuffer.append("A.FTaxPrice,");
            stringBuffer.append("(A.FQty * A.FOrderPrice),");
            stringBuffer.append("(Round((Decimal(A.FQty * A.FOrderPrice,17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append(getPayAmountSql + ",");
            stringBuffer.append("(Round((Decimal(" + getPayAmountSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getPayAmountSql + ",");
            stringBuffer.append("(Round((Decimal(" + getPayAmountSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getPayAmountSql + ",");
            stringBuffer.append("(Round((Decimal(" + getPayAmountSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getTaxAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getTaxAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate");
        } else if (bizTypeID.equalsIgnoreCase("d8e80652-0106-1000-e000-04c5c0a812202407435C")) {
            String getTaxAmountByOrdSql = "Decimal(A.FQty * A.FActualPrice,17,4) * Decimal(C.FTaxRate * 0.01,21,8)";
            String getPayAmountByOrdSql = "(A.FQty * A.FActualPrice) + ISNULL(" + getTaxAmountByOrdSql + ",0)";
            stringBuffer.append("C.FDiscountRate,");
            stringBuffer.append("ROUND(Decimal(A.FUnitActualCost * (1 + C.FTaxRate/100),21,8),E.FPricePrecision),");
            stringBuffer.append("(A.FQty * A.FActualPrice),");
            stringBuffer.append("Round(Decimal(A.FQty * A.FActualPrice,17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append("Decimal(A.FQty * A.FTaxPrice,17,4) * Decimal(C.FDiscountRate * 0.01,17,4),");
            stringBuffer.append("(Round((Decimal(Decimal(A.FQty * A.FTaxPrice,17,4) * Decimal(C.FDiscountRate * 0.01,17,4),17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getPayAmountByOrdSql + ",");
            stringBuffer.append("(Round((Decimal(" + getPayAmountByOrdSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getPayAmountByOrdSql + ",");
            stringBuffer.append("(Round((Decimal(" + getPayAmountByOrdSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getPayAmountByOrdSql + ",");
            stringBuffer.append("(Round((Decimal(" + getPayAmountByOrdSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getTaxAmountByOrdSql + ",");
            stringBuffer.append("Round(Decimal(" + getTaxAmountByOrdSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate");
        }
        stringBuffer.append(" FROM T_IM_PurInWarehsEntry A");
        stringBuffer.append(" INNER JOIN T_IM_PurInWarehsBill B ON A.FParentID = B.FID AND B.FID = '" + billID + "'");
        stringBuffer.append(" INNER JOIN " + tableEntryName + " C ON A.FPurOrderEntryID = C.FID");
        stringBuffer.append(" INNER JOIN " + tableName + " D ON A.FPurOrderID = D.FID");
        stringBuffer.append(" INNER JOIN t_bd_material E ON A.FMaterialID = E.FID");
        stringBuffer.append(" WHERE A.FIsPresent = 0;");
        return stringBuffer.toString();
    }

    private String getARBillEntryInsertSql() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append("T_AR_OtherBillentry");
        stringBuffer.append("(FID,");
        stringBuffer.append("FParentID,");
        stringBuffer.append("FSeq,");
        stringBuffer.append("FMaterialID,");
        stringBuffer.append("FAssistPropertyID,");
        stringBuffer.append("FMeasureUnitID,");
        stringBuffer.append("FQuantity,");
        stringBuffer.append("FVerifyAmount,");
        stringBuffer.append("FVerifyAmountLocal,");
        stringBuffer.append("FLockVerifyAmt,");
        stringBuffer.append("FLockVerifyAmtLocal,");
        stringBuffer.append("FAccountID,");
        stringBuffer.append("FSourceBillId,");
        stringBuffer.append("FSourceBillEntryId,");
        stringBuffer.append("FCoreBillId,");
        stringBuffer.append("FCoreBillEntryId,");
        stringBuffer.append("FCoreBillTypeID,");
        stringBuffer.append("FCoreBillNumber,");
        stringBuffer.append("FCoreBillEntrySeq,");
        stringBuffer.append("FRemark,");
        stringBuffer.append("FBadAmout,");
        stringBuffer.append("FLocalBadAmout,");
        stringBuffer.append("FTaxRate,");
        stringBuffer.append("FPrice,");
        stringBuffer.append("FTaxPrice,");
        stringBuffer.append("FDiscountRate,");
        stringBuffer.append("FActualPrice,");
        stringBuffer.append("FAmount,");
        stringBuffer.append("FAmountLocal,");
        stringBuffer.append("FDiscountAmount,");
        stringBuffer.append("FDiscountAmountLocal,");
        stringBuffer.append("FRecievePayAmount,");
        stringBuffer.append("FRecievePayAmountLocal,");
        stringBuffer.append("FUnVerifyAmount,");
        stringBuffer.append("FUnVerifyAmountLocal,");
        stringBuffer.append("FLockUnVerifyAmt,");
        stringBuffer.append("FLockUnVerifyAmtLocal,");
        stringBuffer.append("FTaxAmount,");
        stringBuffer.append("FTaxAmountLocal)");
        return stringBuffer.toString();
    }

    private String getARBillEntrySelectSql(Context ctx, String bizTypeID, String ARBillID, String billNumber, String billID, String tableName, String tableEntryName, boolean convertMode, int precision) throws InvalidDAOMetaDataException {
        String opt = null;
        opt = convertMode ? "/" : "*";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append("NEWBOSID('" + this.getARBillEntryBOSType(ctx) + "'),");
        stringBuffer.append("'" + ARBillID + "',");
        stringBuffer.append("A.FSeq,");
        stringBuffer.append("A.FMaterialID,");
        stringBuffer.append("A.FAssistPropertyID,");
        stringBuffer.append("A.FUnitID,");
        stringBuffer.append("A.FQty,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("NULL,");
        stringBuffer.append("B.FID,");
        stringBuffer.append("A.FID,");
        stringBuffer.append("A.FSaleOrderID,");
        stringBuffer.append("A.FSaleOrderEntryID,");
        stringBuffer.append("A.FCoreBillTypeID,");
        stringBuffer.append("A.FSaleOrderNumber,");
        stringBuffer.append("A.FSaleOrderEntrySeq,");
        stringBuffer.append("A.FRemark,");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("C.FTaxRate,");
        stringBuffer.append("A.FOrderPrice,");
        stringBuffer.append("A.FTaxPrice,");
        String getTaxAmountSql = "Round(Decimal(A.FQty * A.FOrderPrice,17,4) * Decimal(C.FTaxRate * 0.01,21,8)," + precision + ")";
        String getRecAmountSql = "Round((A.FQty * A.FOrderPrice)," + precision + ") + " + getTaxAmountSql;
        if (bizTypeID.equalsIgnoreCase("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("0,");
            stringBuffer.append("A.FPrice,");
            stringBuffer.append("(A.FQty * A.FOrderPrice),");
            stringBuffer.append("(Round((Decimal(A.FQty * A.FOrderPrice,17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append(getRecAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getRecAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append(getRecAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getRecAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append(getRecAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getRecAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append(getTaxAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getTaxAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate");
        } else if (bizTypeID.equalsIgnoreCase("d8e80652-0110-1000-e000-04c5c0a812202407435C")) {
            stringBuffer.append("0,");
            stringBuffer.append("A.FPrice,");
            stringBuffer.append("(A.FQty * A.FOrderPrice),");
            stringBuffer.append("(Round((Decimal(A.FQty * A.FOrderPrice,17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append(getRecAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getRecAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append(getRecAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getRecAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append(getRecAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getRecAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append(getTaxAmountSql + ",");
            stringBuffer.append("Round(Decimal(" + getTaxAmountSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate");
        } else if (bizTypeID.equalsIgnoreCase("d8e80652-010e-1000-e000-04c5c0a812202407435C")) {
            String getActualCostSql = "(CASE WHEN C.FDiscountType = 0 THEN Decimal(A.FOrderPrice * (1 - Decimal(C.FDiscount * 0.01,21,8)),21,8) WHEN C.FDiscountType = 1 THEN (A.FOrderPrice - Decimal(C.FDiscount / (1 + C.FTaxRate * 0.01),21,8)) ELSE A.FOrderPrice END)";
            String getTaxAmountByOrdSql = "(Decimal(A.FQty * " + getActualCostSql + ",17,4) * Decimal(C.FTaxRate * 0.01,21,8))";
            String getRecAmoutByOrdSql = "(A.FQty * " + getActualCostSql + " + " + getTaxAmountByOrdSql + ")";
            String getDiscountAmountSql = "(CASE WHEN C.FDiscountType = 0 THEN (Decimal(A.FQty * A.FPrice,17,4) * Decimal(C.FDiscount * 0.01,21,8)) WHEN C.FDiscountType = 1 THEN (A.FQty * C.FDiscount) ELSE 0 END)";
            stringBuffer.append("C.FDiscount,");
            stringBuffer.append("A.FPrice,");
            stringBuffer.append("(A.FQty * " + getActualCostSql + "),");
            stringBuffer.append("(Round((Decimal(A.FQty * " + getActualCostSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getDiscountAmountSql + ",");
            stringBuffer.append("(Round((Decimal(" + getDiscountAmountSql + ",17,4)), " + precision + ") " + opt + " D.FExchangeRate),");
            stringBuffer.append(getRecAmoutByOrdSql + ",");
            stringBuffer.append("Round(Decimal(" + getRecAmoutByOrdSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append(getRecAmoutByOrdSql + ",");
            stringBuffer.append("Round(Decimal(" + getRecAmoutByOrdSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append(getRecAmoutByOrdSql + ",");
            stringBuffer.append("Round(Decimal(" + getRecAmoutByOrdSql + ",17,4), " + precision + ") " + opt + " D.FExchangeRate,");
            stringBuffer.append(getTaxAmountByOrdSql + ",");
            stringBuffer.append("Round(Decimal(" + getTaxAmountByOrdSql + ",17,4), " + precision + " ) " + opt + " D.FExchangeRate");
        }
        stringBuffer.append(" FROM T_IM_SaleIssueEntry A");
        stringBuffer.append(" INNER JOIN T_IM_SaleIssueBill B ON A.FParentID = B.FID AND B.FID = '" + billID + "'");
        stringBuffer.append(" INNER JOIN " + tableEntryName + " C ON A.FSaleOrderEntryID = C.FID");
        stringBuffer.append(" INNER JOIN " + tableName + " D ON A.FSaleOrderID = D.FID");
        stringBuffer.append(" WHERE A.FIsPresent = 0;");
        return stringBuffer.toString();
    }

    private String getARAPPlanInsertSql(String planTableName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(planTableName + " ");
        stringBuffer.append("(FID,");
        stringBuffer.append("FSeq,");
        stringBuffer.append("FRecievePayDate,");
        stringBuffer.append("FRecievePayAmount,");
        stringBuffer.append("FRecievePayAmountLocal,");
        stringBuffer.append("FParentID,");
        stringBuffer.append("FVerifyAmount,");
        stringBuffer.append("FVerifyAmountLocal,");
        stringBuffer.append("FRemark) ");
        return stringBuffer.toString();
    }

    private String getAPPlanSelectSql(String billID, String bosType, String APBillID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ");
        stringBuffer.append("NEWBOSID('" + bosType + "'),");
        stringBuffer.append("1,");
        stringBuffer.append("FBizDate,");
        stringBuffer.append("FAmount,");
        stringBuffer.append("FAmountLocal,");
        stringBuffer.append("'" + APBillID + "',");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("NULL");
        stringBuffer.append(" FROM T_AP_OtherBill WHERE FID = '" + APBillID + "';");
        return stringBuffer.toString();
    }

    private String getARPlanSelectSql(String billID, String bosType, String ARBillID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT ");
        stringBuffer.append("NEWBOSID('" + bosType + "'),");
        stringBuffer.append("1,");
        stringBuffer.append("FBizDate,");
        stringBuffer.append("FAmount,");
        stringBuffer.append("FAmountLocal,");
        stringBuffer.append("'" + ARBillID + "',");
        stringBuffer.append("0,");
        stringBuffer.append("0,");
        stringBuffer.append("NULL");
        stringBuffer.append(" FROM T_AR_OtherBill WHERE FID = '" + ARBillID + "';");
        return stringBuffer.toString();
    }

    private boolean checkBuildAPBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT COUNT(FID) AS RECS FROM T_SM_PurOrder");
        stringBuffer.append(" WHERE FPaymentTypeID = '2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5'");
        stringBuffer.append(" AND FID IN (");
        stringBuffer.append(" SELECT FPurOrderID FROM T_IM_PurInWarehsEntry A");
        stringBuffer.append(" INNER JOIN T_IM_PurInWarehsBill B");
        stringBuffer.append(" ON A.FParentID = B.FID");
        stringBuffer.append(" WHERE B.FID = '" + pk.toString() + "'");
        stringBuffer.append(" AND B.FBizTypeID = 'd8e80652-0106-1000-e000-04c5c0a812202407435C')");
        try {
            String sqlStr = stringBuffer.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            rs.next();
            return rs.getInt("RECS") >= 1;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private boolean checkBuildARBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT COUNT(FID) AS RECS FROM T_SD_SaleOrder");
        stringBuffer.append(" WHERE FPaymentTypeID = '91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5'");
        stringBuffer.append(" AND FID IN (");
        stringBuffer.append(" SELECT FSaleOrderID FROM T_IM_SaleIssueEntry A");
        stringBuffer.append(" INNER JOIN T_IM_SaleIssueBill B");
        stringBuffer.append(" ON A.FParentID = B.FID");
        stringBuffer.append(" WHERE B.FID = '" + pk.toString() + "'");
        stringBuffer.append(" AND B.FBizTypeID = 'd8e80652-010e-1000-e000-04c5c0a812202407435C')");
        try {
            String sqlStr = stringBuffer.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            rs.next();
            return rs.getInt("RECS") >= 1;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private boolean getConvertMode(Context ctx, CompanyOrgUnitInfo cou, CurrencyInfo currencyInfo) throws BOSException, EASBizException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (currencyInfo == null) {
            return true;
        }
        if (cou == null) {
            return true;
        }
        if (cou.getBaseExchangeTable() == null) {
            return true;
        }
        excTablepk = new ObjectUuidPK(cou.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = cou.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)currencyInfo.getId())) {
                return true;
            }
        } else {
            return true;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(currencyInfo.getId());
        ExchangeRateInfo rateInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (rateInfo == null) {
            throw new InvBizException(InvBizException.RATEINFOISNULL);
        }
        if (rateInfo.getExchangeAux() == null) {
            return true;
        }
        return !ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode());
    }

    private String getUpdatePrecisionAPAREntry(String tableName, String entryName, String APARBillID, int precision) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" UPDATE " + entryName);
        stringBuffer.append(" SET FAmount = ");
        stringBuffer.append(" ROUND(FAmount, " + precision + "),");
        stringBuffer.append(" FDiscountAmount = ");
        stringBuffer.append(" ROUND(FDiscountAmount, " + precision + "),");
        stringBuffer.append(" FRecievePayAmount = ");
        stringBuffer.append(" ROUND(FRecievePayAmount, " + precision + "),");
        stringBuffer.append(" FUnVerifyAmount = ");
        stringBuffer.append(" ROUND(FUnVerifyAmount, " + precision + "),");
        stringBuffer.append(" FLockUnVerifyAmt = ");
        stringBuffer.append(" ROUND(FLockUnVerifyAmt, " + precision + "),");
        stringBuffer.append(" FTaxAmount = ");
        stringBuffer.append(" ROUND(FTaxAmount, " + precision + "),");
        stringBuffer.append(" FVerifyAmount = ");
        stringBuffer.append(" ROUND(FVerifyAmount, " + precision + "),");
        stringBuffer.append(" FLockVerifyAmt = ");
        stringBuffer.append(" ROUND(FLockVerifyAmt, " + precision + ")");
        stringBuffer.append(" WHERE FParentID = '" + APARBillID + "'");
        return stringBuffer.toString();
    }

    private String getUpdatePrecisionAPAREntryLocal(String tableName, String entryName, String APARBillID, int localPrecision) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" UPDATE " + entryName);
        stringBuffer.append(" SET FAmountLocal = ");
        stringBuffer.append(" ROUND(FAmountLocal, " + localPrecision + "),");
        stringBuffer.append(" FDiscountAmountLocal = ");
        stringBuffer.append(" ROUND(FDiscountAmountLocal, " + localPrecision + "),");
        stringBuffer.append(" FRecievePayAmountLocal = ");
        stringBuffer.append(" ROUND(FRecievePayAmountLocal, " + localPrecision + "),");
        stringBuffer.append(" FUnVerifyAmountLocal = ");
        stringBuffer.append(" ROUND(FUnVerifyAmountLocal, " + localPrecision + "),");
        stringBuffer.append(" FLockUnVerifyAmtLocal = ");
        stringBuffer.append(" ROUND(FLockUnVerifyAmtLocal, " + localPrecision + "),");
        stringBuffer.append(" FTaxAmountLocal = ");
        stringBuffer.append(" ROUND(FTaxAmountLocal, " + localPrecision + "),");
        stringBuffer.append(" FVerifyAmountLocal = ");
        stringBuffer.append(" ROUND(FVerifyAmountLocal, " + localPrecision + "),");
        stringBuffer.append(" FLockVerifyAmtLocal = ");
        stringBuffer.append(" ROUND(FLockVerifyAmtLocal, " + localPrecision + ")");
        stringBuffer.append(" WHERE FParentID = '" + APARBillID + "'");
        return stringBuffer.toString();
    }

    private void calAPARAmount(Context ctx, String tableName, String entryName, String APARBillID) throws BOSException, EASBizException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" UPDATE " + entryName);
        stringBuffer.append(" SET FRecievePayAmount = ");
        stringBuffer.append(" (FAmount + FTaxAmount),");
        stringBuffer.append(" FRecievePayAmountLocal = ");
        stringBuffer.append(" (FAmountLocal + FTaxAmountLocal),");
        stringBuffer.append(" FUnVerifyAmount = (FAmount + FTaxAmount),");
        stringBuffer.append(" FUnVerifyAmountLocal = (FAmountLocal + FTaxAmountLocal),");
        stringBuffer.append(" FLockUnVerifyAmt = (FAmount + FTaxAmount),");
        stringBuffer.append(" FLockUnVerifyAmtLocal = (FAmountLocal + FTaxAmountLocal)");
        stringBuffer.append(" WHERE FParentID = '" + APARBillID + "'");
        String sqlStr = stringBuffer.toString();
        DbUtil.execute((Context)ctx, (String)sqlStr);
    }

    private void updateAPFieldPrecision(Context ctx, String APBillID, int localPrecision, int precision) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)this.getUpdatePrecisionAPAREntry("T_AP_OTHERBILL", "T_AP_OTHERBILLENTRY", APBillID, precision));
        DbUtil.execute((Context)ctx, (String)this.getUpdatePrecisionAPAREntryLocal("T_AP_OTHERBILL", "T_AP_OTHERBILLENTRY", APBillID, localPrecision));
    }

    private void updateARFieldPrecision(Context ctx, String ARBillID, int localPrecision, int precision) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)this.getUpdatePrecisionAPAREntry("T_AR_OTHERBILL", "T_AR_OTHERBILLENTRY", ARBillID, precision));
        DbUtil.execute((Context)ctx, (String)this.getUpdatePrecisionAPAREntryLocal("T_AR_OTHERBILL", "T_AR_OTHERBILLENTRY", ARBillID, localPrecision));
    }

    private void insertAPBillData(Context ctx, String bizTypeID, String APBillID, String billNumber, String billID, String tableName, String tableEntryName, boolean convertMode, String planTableName, String planBosType, String companyID, int localPrecision, int precision) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)(this.getAPBillEntryInsertSql() + this.getAPBillEntrySelectSql(ctx, bizTypeID, APBillID, billNumber, billID, tableName, tableEntryName, convertMode, precision)));
        this.updateAPFieldPrecision(ctx, APBillID, localPrecision, precision);
        this.calAPARAmount(ctx, "T_AP_OTHERBILL", "T_AP_OTHERBILLENTRY", APBillID);
        DbUtil.execute((Context)ctx, (String)(this.getAPBillInsertSql() + this.getAPBillSelectSql(ctx, bizTypeID, APBillID, billNumber, billID, tableName, companyID)));
        DbUtil.execute((Context)ctx, (String)(this.getARAPPlanInsertSql(planTableName) + this.getAPPlanSelectSql(billID, planBosType, APBillID)));
    }

    private void insertARBillData(Context ctx, String bizTypeID, String ARBillID, String billNumber, String billID, String tableName, String tableEntryName, boolean convertMode, String planTableName, String planBosType, String companyID, int localPrecision, int precision) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)(this.getARBillEntryInsertSql() + this.getARBillEntrySelectSql(ctx, bizTypeID, ARBillID, billNumber, billID, tableName, tableEntryName, convertMode, precision)));
        this.updateARFieldPrecision(ctx, ARBillID, localPrecision, precision);
        this.calAPARAmount(ctx, "T_AR_OTHERBILL", "T_AR_OTHERBILLENTRY", ARBillID);
        DbUtil.execute((Context)ctx, (String)(this.getARBillInsertSql() + this.getARBillSelectSql(ctx, bizTypeID, ARBillID, billNumber, billID, tableName, companyID)));
        DbUtil.execute((Context)ctx, (String)(this.getARAPPlanInsertSql(planTableName) + this.getARPlanSelectSql(billID, planBosType, ARBillID)));
    }

    @Override
    protected void _buildAPBill(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BizTypeInfo bizType = (BizTypeInfo)model.get("bizType");
        String bizTypeID = null;
        if (bizType != null) {
            bizTypeID = bizType.getId().toString();
        }
        if (bizTypeID != null && (bizTypeID.equalsIgnoreCase("d8e80652-0117-1000-e000-04c5c0a812202407435C") || bizTypeID.equalsIgnoreCase("d8e80652-0107-1000-e000-04c5c0a812202407435C") || bizTypeID.equalsIgnoreCase("d8e80652-0106-1000-e000-04c5c0a812202407435C"))) {
            String supplierID;
            Object o = model.get("isInitBill");
            if (o != null && o.toString().equals("1")) {
                return;
            }
            if (bizTypeID.equalsIgnoreCase("d8e80652-0106-1000-e000-04c5c0a812202407435C")) {
                if (!this.checkBuildAPBill(ctx, pk)) {
                    return;
                }
            } else if (bizTypeID.equalsIgnoreCase("d8e80652-0107-1000-e000-04c5c0a812202407435C")) {
                // empty if block
            }
            if (this.checkEntryIsPresent(ctx, "T_IM_PurInWarehsEntry", pk.toString())) {
                return;
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = this.getComanyOrgUnit(ctx, model);
            String companyID = companyOrgUnitInfo.getId().toString();
            if (!InvBuildARAPBillFacadeControllerBean.isAPRelationSCM(ctx, companyID) || InvBuildARAPBillFacadeControllerBean.isAPByPurchaseInvoice(ctx, companyID)) {
                return;
            }
            if (model.getObjectValue("supplier") != null && !this.checkSupplierRefCompany(ctx, supplierID = ((SupplierInfo)model.getObjectValue("supplier")).getId().toString(), companyID)) {
                throw new InvBizException(InvBizException.SUPPLIERNOREFCOMPANY);
            }
            boolean isStarted = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            if (!isStarted) {
                throw new InvBizException(InvBizException.AP_NOSTARTED);
            }
            PeriodInfo currentPeriod = InvBuildARAPBillFacadeControllerBean.getApCurrentPeriod(ctx, companyOrgUnitInfo);
            Date bizDate = model.getDate("bizDate");
            if (bizDate.before(currentPeriod.getBeginDate())) {
                throw new InvBizException(InvBizException.AP_BIZDATE_BEF_CURPER);
            }
            String APBillID = BOSUuid.create((String)this.getAPBillBOSType(ctx)).toString();
            CoreBillBaseInfo otherBillInfo = this.getNewInstance("com.kingdee.eas.fi.ap.OtherBillInfo");
            String billNumber = null;
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)otherBillInfo, companyID);
            boolean convertMode = true;
            if (model.get("currency") != null && companyOrgUnitInfo.getBaseCurrency() != null) {
                convertMode = this.getConvertMode(ctx, companyOrgUnitInfo, (CurrencyInfo)model.get("currency"));
            }
            String tableName = null;
            String tableEntryName = null;
            if (bizTypeID.equalsIgnoreCase("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
                tableName = "T_IM_StockTransferBill";
                tableEntryName = "T_IM_StockTransferBillEntry";
            } else if (bizTypeID.equalsIgnoreCase("d8e80652-0107-1000-e000-04c5c0a812202407435C")) {
                tableName = "T_SM_PurReturns";
                tableEntryName = "T_SM_PurReturnsEntry";
            } else if (bizTypeID.equalsIgnoreCase("d8e80652-0106-1000-e000-04c5c0a812202407435C")) {
                tableName = "T_SM_PurOrder";
                tableEntryName = "T_SM_PurOrderEntry";
            }
            this.languaeTag = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            if (this.languaeTag.trim().length() <= 0) {
                this.languaeTag = "L2";
            }
            this.insertAPBillData(ctx, bizTypeID, APBillID, billNumber, pk.toString(), tableName, tableEntryName, convertMode, "T_AP_OtherBillPlan", this.getAPPlanBOSType(ctx), companyID, companyOrgUnitInfo.getBaseCurrency().getPrecision(), this.getCurrency(ctx, model.get("currency")));
            SCMServerUtils.traceUpAndDown((Context)ctx, (String)pk.toString(), (String)APBillID, (String)this.getPurInBillBOSType(ctx), (String)this.getAPBillBOSType(ctx));
        }
    }

    private static boolean getDefaulParam(Context ctx, String number, String system) throws BOSException, EASBizException {
        IParam iParam = ParamFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer("");
        oql.append(" select * where number ='").append(number).append("'");
        oql.append(" and subSysID ='").append(system).append("'");
        ParamCollection paramCollection = iParam.getParamCollection(oql.toString());
        ParamInfo paramInfo = null;
        if (paramCollection != null) {
            paramInfo = paramCollection.get(0);
            if (paramInfo != null) {
                return "true".equalsIgnoreCase(paramInfo.getDefaultValue()) || "1".equals(paramInfo.getDefaultValue());
            }
            return true;
        }
        return true;
    }

    public static boolean isAPRelationSCM(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "AP_SCM_001");
        if (value == null) {
            return InvBuildARAPBillFacadeControllerBean.getDefaulParam(ctx, "AP_SCM_001", SUB_SYSTEM_AP);
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isAPByPurchaseInvoice(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "AP_BY_INV_001");
        if (value == null) {
            return InvBuildARAPBillFacadeControllerBean.getDefaulParam(ctx, "AP_BY_INV_001", SUB_SYSTEM_AP);
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static PeriodInfo getApCurrentPeriod(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = InvBuildARAPBillFacadeControllerBean.getApStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getCurrentPeriod();
        }
        return null;
    }

    public static SystemStatusCtrolInfo getApStatusCtrolInfo(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = InvBuildARAPBillFacadeControllerBean.getSysStatusCtrolInfo(ctx, cmpnyOrgUntInfObj, SystemEnum.ACCOUNTSPAYABLE);
        return systmSttsCtrlInf;
    }

    public static SystemStatusCtrolInfo getSysStatusCtrolInfo(Context ctx, Object cmpnyOrgUntInfObj, SystemEnum system) throws BOSException, EASBizException {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (!(cmpnyOrgUntInfObj instanceof CompanyOrgUnitInfo)) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo cmpnyOrgUntInf = (CompanyOrgUnitInfo)cmpnyOrgUntInfObj;
        String cmpnyOrgUntID = cmpnyOrgUntInf.getId().toString();
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        String cndtn0 = "(company='" + cmpnyOrgUntID + "')";
        String cndtn1 = "(systemStatus.name=" + system.getValue() + ")";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "select *,startPeriod.*,currentPeriod.* where " + cndtn;
        SystemStatusCtrolCollection systmStsCtrlCllctn = systemStatusCtrol.getSystemStatusCtrolCollection(oql);
        int size = systmStsCtrlCllctn.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            SystemStatusCtrolInfo systmStsCtrlInf = systmStsCtrlCllctn.get(0);
            return systmStsCtrlInf;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void _buildARBill(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BizTypeInfo bizType = (BizTypeInfo)model.get("bizType");
        String bizTypeID = null;
        if (bizType != null) {
            bizTypeID = bizType.getId().toString();
        }
        if (bizTypeID != null && (bizTypeID.equalsIgnoreCase("d8e80652-0117-1000-e000-04c5c0a812202407435C") || bizTypeID.equalsIgnoreCase("d8e80652-010e-1000-e000-04c5c0a812202407435C") || bizTypeID.equalsIgnoreCase("d8e80652-0110-1000-e000-04c5c0a812202407435C"))) {
            String customerID;
            Object o = model.get("isInitBill");
            if (o != null && o.toString().equals("1")) {
                return;
            }
            if (bizTypeID.equalsIgnoreCase("d8e80652-010e-1000-e000-04c5c0a812202407435C") && !this.checkBuildARBill(ctx, pk)) {
                return;
            }
            if (this.checkEntryIsPresent(ctx, "T_IM_SaleIssueEntry", pk.toString())) {
                return;
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = this.getComanyOrgUnit(ctx, model);
            String companyID = companyOrgUnitInfo.getId().toString();
            if (!InvBuildARAPBillFacadeControllerBean.isARRelationSCM(ctx, companyID) || InvBuildARAPBillFacadeControllerBean.isARBySaleInvouce(ctx, companyID)) {
                return;
            }
            if (model.getObjectValue("customer") != null && !this.checkCustomerRefCompany(ctx, customerID = ((CustomerInfo)model.getObjectValue("customer")).getId().toString(), companyID)) {
                throw new InvBizException(InvBizException.CUSTOMERNOREFCOMPANY);
            }
            boolean isStarted = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            if (!isStarted) {
                throw new InvBizException(InvBizException.AR_NOSTARTED);
            }
            PeriodInfo currentPeriod = InvBuildARAPBillFacadeControllerBean.getArCurrentPeriod(ctx, companyOrgUnitInfo);
            Date bizDate = model.getDate("bizDate");
            if (bizDate.before(currentPeriod.getBeginDate())) {
                throw new InvBizException(InvBizException.AR_BIZDATE_BEF_CURPER);
            }
            String ARBillID = BOSUuid.create((String)this.getARBillBOSType(ctx)).toString();
            CoreBillBaseInfo otherBillInfo = this.getNewInstance("com.kingdee.eas.fi.ar.OtherBillInfo");
            String billNumber = null;
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)otherBillInfo, companyID);
            boolean convertMode = true;
            if (model.get("currency") != null && companyOrgUnitInfo.getBaseCurrency() != null) {
                convertMode = this.getConvertMode(ctx, companyOrgUnitInfo, (CurrencyInfo)model.get("currency"));
            }
            String tableName = null;
            String tableEntryName = null;
            if (bizTypeID.equalsIgnoreCase("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
                tableName = "T_IM_StockTransferBill";
                tableEntryName = "T_IM_StockTransferBillEntry";
            } else if (bizTypeID.equalsIgnoreCase("d8e80652-0110-1000-e000-04c5c0a812202407435C")) {
                tableName = "T_SD_SaleReturns";
                tableEntryName = "T_SD_SaleReturnsEntry";
            } else if (bizTypeID.equalsIgnoreCase("d8e80652-010e-1000-e000-04c5c0a812202407435C")) {
                tableName = "T_SD_SaleOrder";
                tableEntryName = "T_SD_SaleOrderEntry";
            }
            this.languaeTag = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            if (this.languaeTag.trim().length() <= 0) {
                this.languaeTag = "L2";
            }
            this.insertARBillData(ctx, bizTypeID, ARBillID, billNumber, pk.toString(), tableName, tableEntryName, convertMode, "T_AR_OtherBillPlan", this.getARPlanBOSType(ctx), companyID, companyOrgUnitInfo.getBaseCurrency().getPrecision(), this.getCurrency(ctx, model.get("currency")));
            SCMServerUtils.traceUpAndDown((Context)ctx, (String)pk.toString(), (String)ARBillID, (String)this.getSaleOutBillBOSType(ctx), (String)this.getARBillBOSType(ctx));
            CoreBillBaseInfo billInfo = this.getNewInstance("com.kingdee.eas.fi.ar.OtherBillInfo");
            billInfo.setId(BOSUuid.read((String)ARBillID));
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{ARBillID}, CreditOperationEnum.AUDIT);
        }
    }

    private CoreBillBaseInfo getNewInstance(String classPath) throws BOSException {
        CoreBillBaseInfo result;
        try {
            Class<?> clz = Class.forName(classPath);
            Constructor<?> constructor = clz.getConstructor(new Class[0]);
            result = (CoreBillBaseInfo)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static boolean isARBySaleInvouce(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "AR_BY_INV_001");
        if (value == null) {
            return InvBuildARAPBillFacadeControllerBean.getDefaulParam(ctx, "AR_BY_INV_001", SUB_SYSTEM_AR);
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isARRelationSCM(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "AR_SCM_001");
        if (value == null) {
            return InvBuildARAPBillFacadeControllerBean.getDefaulParam(ctx, "AR_SCM_001", SUB_SYSTEM_AR);
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static PeriodInfo getArCurrentPeriod(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = InvBuildARAPBillFacadeControllerBean.getArStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getCurrentPeriod();
        }
        return null;
    }

    public static SystemStatusCtrolInfo getArStatusCtrolInfo(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = InvBuildARAPBillFacadeControllerBean.getSysStatusCtrolInfo(ctx, cmpnyOrgUntInfObj, SystemEnum.ACCOUNTSRECEIVABLE);
        return systmSttsCtrlInf;
    }
}

