/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBizHasDeal;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;

public class InvMaterialBizHasDeal
implements IBizHasDeal {
    private final String SQL_UNION_ALL = " UNION ALL ";
    private final String[][] tableArray = new String[][]{{"T_IM_StockTransferBillEntry", "50957179-0105-1000-e003-3152c0a812fd463ED552", "true"}, {"T_CL_StandardCostAdjEntry", "3a3b5446-0106-1000-e000-01c3c0a812e6463ED552", "false"}, {"T_CL_CostAdjustBillEntry", "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552", "true"}, {"T_IM_DecomposeEntry", "50957179-0105-1000-e002-2152c0a812fd463ED552", "true"}, {"T_IM_InventoryInitEntry", "528d806a-0106-1000-e000-0194c0a812e6463ED552", "true"}, {"T_IM_InvStateAdjustBillEntry", "50957179-0105-1000-e000-0152c0a812fd463ED552", "true"}, {"T_IM_PurReceivalEntry", "50957179-0105-1000-e000-0157c0a812fd463ED552", "true"}, {"T_IM_PurInWarehsEntry", "50957179-0105-1000-e000-015fc0a812fd463ED552", "true"}, {"T_IM_ManufactureRecBillEntry", "50957179-0105-1000-e000-0167c0a812fd463ED552", "true"}, {"T_IM_MoveInWarehsBillEntry", "50957179-0105-1000-e000-0172c0a812fd463ED552", "true"}, {"T_IM_OtherInWarehsBillEntry", "50957179-0105-1000-e000-017bc0a812fd463ED552", "true"}, {"T_IM_SaleIssueEntry", "50957179-0105-1000-e000-015bc0a812fd463ED552", "true"}, {"T_IM_MoveIssueBillEntry", "50957179-0105-1000-e000-016ec0a812fd463ED552", "true"}, {"T_IM_MaterialReqBillEntry", "50957179-0105-1000-e000-0163c0a812fd463ED552", "true"}, {"T_IM_OtherIssueBillEntry", "50957179-0105-1000-e000-0177c0a812fd463ED552", "true"}, {"T_IM_MoveLocationBillEntry", "50957179-0105-1000-e001-1152c0a812fd463ED552", "true"}, {"T_IM_MatAttrChangeBeforeEntry", "50957179-0105-1000-e000-888880a812fd463ED552", "true"}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BizCheckResult checkHasDeal(Context ctx, BOSUuid id) throws BizHasDealException {
        if (id == null) {
            return new BizCheckResult(true, (EASBizException)new InvBizException(InvBizException.MATERIAL_IS_NULL));
        }
        BizCheckResult bcr = new BizCheckResult(false);
        BOSObjectType bosTypeMaterialInventory = new MaterialInventoryInfo().getBOSType();
        BOSObjectType bosTypeMaterialCompany = new MaterialCompanyInfo().getType();
        BOSObjectType bosTypeMaterialMeasureUnit = new MultiMeasureUnitInfo().getBOSType();
        StringBuffer sql = new StringBuffer();
        if (id.getType().equals((Object)bosTypeMaterialInventory)) {
            sql = this.getMaterialSQLInventory(ctx, id);
        }
        if (id.getType().equals((Object)bosTypeMaterialCompany)) {
            sql = this.getMaterialSQLCompany(ctx, id);
        }
        if (id.getType().equals((Object)bosTypeMaterialMeasureUnit)) {
            sql = this.getMaterialSQLMultiMeasure(ctx, id);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            JdbcRowSet rs = (JdbcRowSet)SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
            while (rs.next()) {
                HashMap<String, String> detailMap = new HashMap<String, String>();
                detailMap.put(rs.getString(1), rs.getString(2));
                bcr = new BizCheckResult(true, null, detailMap);
            }
        }
        catch (SQLException e) {
            bcr = new BizCheckResult(true, (EASBizException)new InvBizException(InvBizException.SQL_QUERY_ERROR));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bcr;
    }

    private StringBuffer getMaterialSQLMultiMeasure(Context ctx, BOSUuid id) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t1.FMaterialId");
        sql.append(" ,T_SCM_BillType.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sql.append(" FROM (");
        sql.append("\t\n");
        for (int i = 0; i < this.tableArray.length; ++i) {
            sql.append(" SELECT ");
            sql.append(" Bill.FMaterialId");
            sql.append(" ,'").append(this.tableArray[i][1]).append("' as billtype");
            sql.append(" FROM ").append(this.tableArray[i][0]).append(" AS BILL");
            sql.append(" inner join t_bd_multimeasureunit Material");
            sql.append(" on Material.fmaterialid=BILL.fmaterialid and (Material.fmeasureunitid=Bill.funitid or Material.fmeasureunitid=Bill.fbaseunitid or Material.fmeasureunitid=Bill.fassistunitid )");
            sql.append(" where Material.FId = '").append(id.toString()).append("'");
            sql.append("\t\n");
            if (i != this.tableArray.length - 1) {
                sql.append(" UNION ALL ");
            }
            sql.append("\t\n");
        }
        sql.append(" ) t1 inner join T_SCM_BillType");
        sql.append(" on t1.billtype = T_SCM_BillType.fid");
        return sql;
    }

    private StringBuffer getMaterialSQLCompany(Context ctx, BOSUuid id) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t1.FMaterialId");
        sql.append(" ,T_SCM_BillType.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sql.append(" FROM (");
        sql.append("\t\n");
        for (int i = 0; i < this.tableArray.length; ++i) {
            if (this.tableArray[i][2].equals("false")) continue;
            if (i == 0) {
                sql.append(" SELECT ");
                sql.append(" Bill.FMaterialId");
                sql.append(" ,'").append(this.tableArray[i][1]).append("' as billtype");
                sql.append(" FROM ").append(this.tableArray[i][0]).append(" AS BILL");
                sql.append(" inner join T_IM_StockTransferBill Entry");
                sql.append(" on bill.fparentid = ENTRY.fid");
                sql.append(" inner join t_bd_materialCompanyInfo Material");
                sql.append(" on (Material.fcompanyid=ENTRY.freceiptcompanyorgunitid or Material.fcompanyid=ENTRY.fissuecompanyorgunitid) and Material.fmaterialid=Bill.fmaterialid");
                sql.append(" where Material.FId = '").append(id.toString()).append("'");
                sql.append("\t\n");
                if (i != this.tableArray.length - 1) {
                    sql.append(" UNION ALL ");
                }
                sql.append("\t\n");
                continue;
            }
            sql.append(" SELECT ");
            sql.append(" Bill.FMaterialId");
            sql.append(" ,'").append(this.tableArray[i][1]).append("' as billtype");
            sql.append(" FROM ").append(this.tableArray[i][0]).append(" AS BILL");
            sql.append(" inner join t_bd_materialCompanyInfo Material");
            sql.append(" on Material.fcompanyid=BILL.fcompanyorgunitid and Material.fmaterialid=Bill.fmaterialid");
            sql.append(" where Material.FId = '").append(id.toString()).append("'");
            sql.append("\t\n");
            if (i != this.tableArray.length - 1) {
                sql.append(" UNION ALL ");
            }
            sql.append("\t\n");
        }
        sql.append(" ) t1 inner join T_SCM_BillType");
        sql.append(" on t1.billtype = T_SCM_BillType.fid");
        return sql;
    }

    private StringBuffer getMaterialSQLInventory(Context ctx, BOSUuid id) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t1.FMaterialId");
        sql.append(" ,T_SCM_BillType.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sql.append(" FROM (");
        sql.append("\t\n");
        for (int i = 0; i < this.tableArray.length; ++i) {
            if (this.tableArray[i][2].equals("false")) continue;
            if (i == 0) {
                sql.append(" SELECT ");
                sql.append(" Bill.FMaterialId");
                sql.append(" ,'").append(this.tableArray[i][1]).append("' as billtype");
                sql.append(" FROM ").append(this.tableArray[i][0]).append(" AS BILL");
                sql.append(" inner join T_IM_StockTransferBill Entry");
                sql.append(" on bill.fparentid = ENTRY.fid");
                sql.append(" inner join t_bd_materialinventory Material");
                sql.append(" on (Material.forgunit=ENTRY.freceiptstorageorgunitid or Material.forgunit=ENTRY.fissuestorageorgunitid)and Material.fmaterialid=Bill.fmaterialid");
                sql.append(" where Material.FId = '").append(id.toString()).append("'");
                sql.append("\t\n");
                if (i != this.tableArray.length - 1) {
                    sql.append(" UNION ALL ");
                }
                sql.append("\t\n");
                continue;
            }
            sql.append(" SELECT ");
            sql.append(" Bill.FMaterialId");
            sql.append(" ,'").append(this.tableArray[i][1]).append("' as billtype");
            sql.append(" FROM ").append(this.tableArray[i][0]).append(" AS BILL");
            sql.append(" inner join t_bd_materialinventory Material");
            sql.append(" on Material.forgunit=BILL.fstorageorgunitid and Material.fmaterialid=Bill.fmaterialid");
            sql.append(" where Material.FId = '").append(id.toString()).append("'");
            sql.append("\t\n");
            if (i != this.tableArray.length - 1) {
                sql.append(" UNION ALL ");
            }
            sql.append("\t\n");
        }
        sql.append(" ) t1 inner join T_SCM_BillType");
        sql.append(" on t1.billtype = T_SCM_BillType.fid");
        return sql;
    }

    private StringBuffer getMaterialSQL(Context ctx, BOSUuid id) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t1.FMaterialId");
        sql.append(" ,T_SCM_BillType.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sql.append(" FROM (");
        sql.append("\t\n");
        for (int i = 0; i < this.tableArray.length; ++i) {
            sql.append(" SELECT ");
            sql.append(" Bill.FMaterialId");
            sql.append(" ,'").append(this.tableArray[i][1]).append("' as billtype");
            sql.append(" FROM ").append(this.tableArray[i][0]).append(" AS BILL");
            sql.append(" where BILL.FMaterialId = '").append(id.toString()).append("'");
            sql.append("\t\n");
            if (i != this.tableArray.length - 1) {
                sql.append(" UNION ALL ");
            }
            sql.append("\t\n");
        }
        sql.append(" ) t1 left outer join T_SCM_BillType");
        sql.append(" on t1.billtype = T_SCM_BillType.fid");
        return sql;
    }
}

