/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.planning.IReqPlanForSCMFacade;
import com.kingdee.eas.mm.planning.ReqPlanForSCMFacadeFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.qm.qc.QCReturnResultCollection;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.InvBillBaseCollection;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryCollection;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalException;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class InvServerUtils {
    public static final String resource = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    public static final String SP = "\r\n";
    private static String COREBILL_ENTRY_ID_KEY = "FID";

    public static InventoryCollection getInventoryCollectionForCalculateLot(Context ctx, String billTypeID, String souID, TransactionTypeInfo tti, boolean isUpdateByBaseUnit, String materialID, String asstattrID, String unitID, String warehouseID, String locationID, String storeTypeID, String storeStatusID, String supplierID, String customerID, IssuePriorityEnum issuePriority) throws BOSException {
        IRowSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select inv.FStorageOrgUnitID as souID, ");
            sql.append("inv.FMaterialID as materialID, ");
            sql.append("case when inv.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' then null else inv.FAssistPropertyID end as asstattrID, ");
            sql.append("case when inv.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' then null else inv.FWarehouseID end as warehouseID, ");
            sql.append("case when inv.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' then null else inv.FLocationID end as locationID, ");
            sql.append("case when inv.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' then null else inv.FCustomerID end as customerID, ");
            sql.append("case when inv.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' then null else inv.FSupplierID end as supplierID, ");
            sql.append("case when inv.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' then null else inv.FLot end as lot, ");
            sql.append("inv.FCurStoreQty as qty, ");
            sql.append("inv.FBaseQty as baseQty, ");
            sql.append("dom.FMfg as mfg, ");
            sql.append("dom.FExp as exp ");
            sql.append("from T_IM_Inventory inv left outer join T_IM_DateOfMinDurability dom ");
            sql.append(" on inv.FLot = dom.FLot and inv.FStorageOrgUnitID = dom.FStorageOrgUnitID and inv.FMaterialID = dom.FMaterialID ");
            sql.append(" where inv.FStorageOrgUnitID = '").append(souID).append("'");
            sql.append(" and inv.FMaterialID = '").append(materialID).append("'");
            if (isUpdateByBaseUnit) {
                sql.append(" and inv.FBaseUnitID = '").append(unitID).append("'");
            } else {
                sql.append(" and inv.FUnitID = '").append(unitID).append("'");
            }
            if (asstattrID != null) {
                sql.append(" and inv.FAssistPropertyID = '").append(asstattrID).append("'");
            }
            if (warehouseID != null) {
                sql.append(" and inv.FWarehouseID = '").append(warehouseID).append("'");
            }
            if (locationID != null) {
                sql.append(" and inv.FLocationID = '").append(locationID).append("'");
            }
            sql.append(" and inv.FBaseQty > 0 and inv.FLot is not null ");
            if (billTypeID != null) {
                if (billTypeID.equals("50957179-0105-1000-e000-0177c0a812fd463ED552")) {
                    if (storeTypeID != null) {
                        sql.append(" and inv.FStoreTypeID = '").append(storeTypeID).append("'");
                    }
                    if (storeStatusID != null) {
                        sql.append(" and inv.FStoreStatusID = '").append(storeStatusID).append("'");
                    }
                } else if (billTypeID.equals("50957179-0105-1000-e003-3152c0a812fd463ED552")) {
                    if (storeTypeID != null) {
                        sql.append(" and inv.FStoreTypeID = '").append(storeTypeID).append("'");
                    }
                    if (storeStatusID != null) {
                        sql.append(" and inv.FStoreStatusID = '").append(storeStatusID).append("'");
                    }
                } else if (billTypeID.equals("50957179-0105-1000-e000-016ec0a812fd463ED552")) {
                    if (storeTypeID != null) {
                        sql.append(" and inv.FStoreTypeID = '").append(storeTypeID).append("'");
                    }
                    if (storeStatusID != null) {
                        sql.append(" and inv.FStoreStatusID = '").append(storeStatusID).append("'");
                    }
                } else {
                    if (storeTypeID != null) {
                        sql.append(" and inv.FStoreTypeID = '").append(storeTypeID).append("'");
                    }
                    if (storeStatusID != null) {
                        sql.append(" and inv.FStoreStatusID = '").append(storeStatusID).append("'");
                    }
                }
                if (customerID != null) {
                    sql.append(" and inv.FCustomerID = '").append(customerID).append("'");
                } else if (supplierID != null) {
                    sql.append(" and inv.FSupplierID = '").append(supplierID).append("'");
                }
            }
            if (issuePriority != null) {
                switch (issuePriority.getValue()) {
                    case 1: {
                        sql.append(" order by dom.FLot asc");
                        break;
                    }
                    case 2: {
                        sql.append(" order by dom.FInWarehouseDate,inv.FLot asc ");
                        break;
                    }
                    case 3: {
                        sql.append(" order by dom.FInWarehouseDate desc,inv.FLot asc");
                        break;
                    }
                    case 4: {
                        sql.append(" order by dom.FExp,dom.FInWarehouseDate,inv.FLot asc");
                        break;
                    }
                    default: {
                        sql.append(" order by dom.FInWarehouseDate ,inv.FLot asc ");
                        break;
                    }
                }
            } else {
                sql.append(" order by dom.FInWarehouseDate ,inv.FLot asc ");
            }
            String sqlStr = sql.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            InventoryCollection coll = new InventoryCollection();
            while (rs.next()) {
                InventoryInfo info = new InventoryInfo();
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                sou.setId(BOSUuid.read((String)rs.getString("souID")));
                info.setStorageOrgUnit(sou);
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)rs.getString("materialID")));
                info.setMaterial(material);
                if (isUpdateByBaseUnit) {
                    MeasureUnitInfo baseUnit = new MeasureUnitInfo();
                    baseUnit.setId(BOSUuid.read((String)unitID));
                    info.setBaseUnit(baseUnit);
                    info.setBaseQty(rs.getBigDecimal("baseQty"));
                } else {
                    MeasureUnitInfo unit = new MeasureUnitInfo();
                    unit.setId(BOSUuid.read((String)unitID));
                    info.setUnit(unit);
                    info.setCurStoreQty(rs.getBigDecimal("qty"));
                }
                if (rs.getString("asstattrID") != null) {
                    AsstAttrValueInfo asstAttr = new AsstAttrValueInfo();
                    asstAttr.setId(BOSUuid.read((String)rs.getString("asstattrID")));
                    info.setAssistProperty(asstAttr);
                }
                if (rs.getString("warehouseID") != null) {
                    WarehouseInfo warehouse = new WarehouseInfo();
                    warehouse.setId(BOSUuid.read((String)rs.getString("warehouseID")));
                    info.setWarehouse(warehouse);
                }
                if (rs.getString("locationID") != null) {
                    LocationInfo location = new LocationInfo();
                    location.setId(BOSUuid.read((String)rs.getString("locationID")));
                    info.setLocation(location);
                }
                if (rs.getString("customerID") != null) {
                    CustomerInfo customer = new CustomerInfo();
                    customer.setId(BOSUuid.read((String)rs.getString("customerID")));
                    info.setCustomer(customer);
                }
                if (rs.getString("supplierID") != null) {
                    SupplierInfo supplier = new SupplierInfo();
                    supplier.setId(BOSUuid.read((String)rs.getString("supplierID")));
                    info.setSupplier(supplier);
                }
                info.setLot(rs.getString("lot"));
                info.setDate("mfg", rs.getDate("mfg"));
                info.setDate("exp", rs.getDate("exp"));
                coll.add(info);
            }
            return coll;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static InventoryCollection getInventoryCollectionForCalculateLot(Context ctx, String billTypeID, String souID, TransactionTypeInfo tti, boolean isUpdateByBaseUnit, String materialID, String asstattrID, String unitID, String warehouseID, String locationID, String storeTypeID, String storeStatusID, String supplierID, String customerID, IssuePriorityEnum issuePriority, String projectID, String trackNumberID) throws BOSException {
        InventoryCollection inventoryCollection;
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select inv.FStorageOrgUnitID as souID, ");
            sql.append("inv.FMaterialID as materialID, ");
            sql.append("case when inv.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' then null else inv.FAssistPropertyID end as asstattrID, ");
            sql.append("case when inv.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' then null else inv.FWarehouseID end as warehouseID, ");
            sql.append("case when inv.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' then null else inv.FLocationID end as locationID, ");
            sql.append("case when inv.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' then null else inv.FCustomerID end as customerID, ");
            sql.append("case when inv.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' then null else inv.FSupplierID end as supplierID, ");
            sql.append("case when inv.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' then null else inv.FLot end as lot, ");
            sql.append("inv.FCurStoreQty as qty, ");
            sql.append("inv.FBaseQty as baseQty, ");
            sql.append("dom.FMfg as mfg, ");
            sql.append("dom.FExp as exp ");
            sql.append(", case when inv.FProjectID = '").append("EgkAAABc3Xza3gXu").append("' then null else inv.FProjectID end as projectID ");
            sql.append(", case when inv.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' then null else inv.FTrackNumberID end as trackNumberID ");
            sql.append("from T_IM_Inventory inv left outer join T_IM_DateOfMinDurability dom ");
            sql.append(" on inv.FLot = dom.FLot and inv.FStorageOrgUnitID = dom.FStorageOrgUnitID and inv.FMaterialID = dom.FMaterialID ");
            sql.append(" where inv.FStorageOrgUnitID = '").append(souID).append("'");
            sql.append(" and inv.FMaterialID = '").append(materialID).append("'");
            if (isUpdateByBaseUnit) {
                sql.append(" and inv.FBaseUnitID = '").append(unitID).append("'");
            } else {
                sql.append(" and inv.FUnitID = '").append(unitID).append("'");
            }
            if (asstattrID != null) {
                sql.append(" and inv.FAssistPropertyID = '").append(asstattrID).append("'");
            }
            if (projectID != null) {
                sql.append(" and inv.FProjectID = '").append(projectID).append("'");
            }
            if (trackNumberID != null) {
                sql.append(" and inv.FTrackNumberID = '").append(trackNumberID).append("'");
            }
            if (warehouseID != null) {
                sql.append(" and inv.FWarehouseID = '").append(warehouseID).append("'");
            }
            if (locationID != null) {
                sql.append(" and inv.FLocationID = '").append(locationID).append("'");
            }
            sql.append(" and inv.FBaseQty > 0 and inv.FLot is not null ");
            if (billTypeID != null) {
                if (billTypeID.equals("50957179-0105-1000-e000-0177c0a812fd463ED552")) {
                    if (storeTypeID != null) {
                        sql.append(" and inv.FStoreTypeID = '").append(storeTypeID).append("'");
                    }
                    if (storeStatusID != null) {
                        sql.append(" and inv.FStoreStatusID = '").append(storeStatusID).append("'");
                    }
                } else if (billTypeID.equals("50957179-0105-1000-e003-3152c0a812fd463ED552")) {
                    if (storeTypeID != null) {
                        sql.append(" and inv.FStoreTypeID = '").append(storeTypeID).append("'");
                    }
                    if (storeStatusID != null) {
                        sql.append(" and inv.FStoreStatusID = '").append(storeStatusID).append("'");
                    }
                } else if (billTypeID.equals("50957179-0105-1000-e000-016ec0a812fd463ED552")) {
                    if (storeTypeID != null) {
                        sql.append(" and inv.FStoreTypeID = '").append(storeTypeID).append("'");
                    }
                    if (storeStatusID != null) {
                        sql.append(" and inv.FStoreStatusID = '").append(storeStatusID).append("'");
                    }
                } else {
                    if (storeTypeID != null) {
                        sql.append(" and inv.FStoreTypeID = '").append(storeTypeID).append("'");
                    }
                    if (storeStatusID != null) {
                        sql.append(" and inv.FStoreStatusID = '").append(storeStatusID).append("'");
                    }
                }
                if (customerID != null) {
                    sql.append(" and inv.FCustomerID = '").append(customerID).append("'");
                } else if (supplierID != null) {
                    sql.append(" and inv.FSupplierID = '").append(supplierID).append("'");
                }
            }
            if (issuePriority != null) {
                switch (issuePriority.getValue()) {
                    case 1: {
                        sql.append(" order by dom.FLot asc");
                        break;
                    }
                    case 2: {
                        sql.append(" order by dom.FInWarehouseDate,inv.FLot asc ");
                        break;
                    }
                    case 3: {
                        sql.append(" order by dom.FInWarehouseDate desc,inv.FLot asc");
                        break;
                    }
                    case 4: {
                        sql.append(" order by dom.FExp,dom.FInWarehouseDate,inv.FLot asc");
                        break;
                    }
                    default: {
                        sql.append(" order by dom.FInWarehouseDate ,inv.FLot asc ");
                        break;
                    }
                }
            } else {
                sql.append(" order by dom.FInWarehouseDate ,inv.FLot asc ");
            }
            preStmt = conn.prepareStatement(sql.toString());
            rs = preStmt.executeQuery();
            InventoryCollection coll = new InventoryCollection();
            while (rs.next()) {
                InventoryInfo info = new InventoryInfo();
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                sou.setId(BOSUuid.read((String)rs.getString("souID")));
                info.setStorageOrgUnit(sou);
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)rs.getString("materialID")));
                info.setMaterial(material);
                if (isUpdateByBaseUnit) {
                    MeasureUnitInfo baseUnit = new MeasureUnitInfo();
                    baseUnit.setId(BOSUuid.read((String)unitID));
                    info.setBaseUnit(baseUnit);
                    info.setBaseQty(rs.getBigDecimal("baseQty"));
                } else {
                    MeasureUnitInfo unit = new MeasureUnitInfo();
                    unit.setId(BOSUuid.read((String)unitID));
                    info.setUnit(unit);
                    info.setCurStoreQty(rs.getBigDecimal("qty"));
                }
                if (rs.getString("asstattrID") != null) {
                    AsstAttrValueInfo asstAttr = new AsstAttrValueInfo();
                    asstAttr.setId(BOSUuid.read((String)rs.getString("asstattrID")));
                    info.setAssistProperty(asstAttr);
                }
                if (rs.getString("projectID") != null) {
                    ProjectInfo project = new ProjectInfo();
                    project.setId(BOSUuid.read((String)rs.getString("projectID")));
                    info.setProject(project);
                }
                if (rs.getString("trackNumberID") != null) {
                    TrackNumberInfo trackNumber = new TrackNumberInfo();
                    trackNumber.setId(BOSUuid.read((String)rs.getString("trackNumberID")));
                    info.setTrackNumber(trackNumber);
                }
                if (rs.getString("warehouseID") != null) {
                    WarehouseInfo warehouse = new WarehouseInfo();
                    warehouse.setId(BOSUuid.read((String)rs.getString("warehouseID")));
                    info.setWarehouse(warehouse);
                }
                if (rs.getString("locationID") != null) {
                    LocationInfo location = new LocationInfo();
                    location.setId(BOSUuid.read((String)rs.getString("locationID")));
                    info.setLocation(location);
                }
                if (rs.getString("customerID") != null) {
                    CustomerInfo customer = new CustomerInfo();
                    customer.setId(BOSUuid.read((String)rs.getString("customerID")));
                    info.setCustomer(customer);
                }
                if (rs.getString("supplierID") != null) {
                    SupplierInfo supplier = new SupplierInfo();
                    supplier.setId(BOSUuid.read((String)rs.getString("supplierID")));
                    info.setSupplier(supplier);
                }
                info.setLot(rs.getString("lot"));
                info.setDate("mfg", rs.getDate("mfg"));
                info.setDate("exp", rs.getDate("exp"));
                coll.add(info);
            }
            inventoryCollection = coll;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return inventoryCollection;
    }

    public static String getInStringFromList(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static String getInStringFromArray(String[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        for (int i = 0; i < arr.length; ++i) {
            in.append("'").append(arr[i]).append("'");
            if (i == arr.length - 1) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static TransactionTypeInfo getTransaction(Context ctx, String billTypeID, String bizTypeID, String srcBillTypeID) throws EASBizException, BOSException {
        TransactionTypeCollection tic;
        TransactionTypeInfo transaction = null;
        if (billTypeID != null && srcBillTypeID != null && (tic = TransactionTypeFactory.getLocalInstance((Context)ctx).getCollection(billTypeID, bizTypeID)) != null) {
            for (int i = 0; i < tic.size(); ++i) {
                transaction = tic.get(i);
                if (transaction.getStatus().getValue() != 1) continue;
                return transaction;
            }
        }
        return null;
    }

    public static String getMaterialCompanyOQL(Object[] materials, String companyID) {
        StringBuffer oqlWhere = new StringBuffer();
        oqlWhere.append("select id,mateial.id,company.id where ");
        oqlWhere.append("mateial.id  in(");
        int size = materials.length;
        for (int i = 0; i < size; ++i) {
            if (StringUtils.isEmpty((String)((MaterialInfo)materials[i]).getId().toString())) continue;
            oqlWhere.append("'").append(((MaterialInfo)materials[i]).getId().toString()).append("',");
        }
        oqlWhere.delete(oqlWhere.length() - 1, oqlWhere.length());
        oqlWhere.append(")");
        oqlWhere.append(" and company.id = '").append(companyID).append("' ");
        return oqlWhere.toString();
    }

    public static BigDecimal getBaseUnitQty(Context ctx, MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty) throws EASBizException, BOSException {
        MultiMeasureUnitInfo multUnitInfo;
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        if (mui != null && mi != null && (multUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(mi.getId().toString(), mui.getId().toString())) != null) {
            coefficient = multUnitInfo.getBaseConvsRate();
            baseQty = qty.multiply(coefficient);
            if (mi.getBaseUnit() == null) {
                SelectorItemCollection sics = new SelectorItemCollection();
                sics.add(new SelectorItemInfo("id"));
                sics.add(new SelectorItemInfo("baseUnit.id"));
                mi = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId()), sics);
            }
            if ((multUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(mi.getId().toString(), mi.getBaseUnit().getId().toString())) == null) {
                return null;
            }
            int precision = multUnitInfo.getQtyPrecision();
            baseQty = baseQty.setScale(precision, 4);
        }
        return baseQty;
    }

    public static BigDecimal getAssUnitQty(Context ctx, MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty) throws EASBizException, BOSException {
        MultiMeasureUnitInfo multiUnitInfo;
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal assQty = new BigDecimal("0.00");
        if (baseQty != null) {
            assQty = baseQty;
        } else {
            baseQty = assQty;
        }
        if (mui != null && mi != null && (multiUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(mi.getId().toString(), mui.getId().toString())) != null) {
            coefficient = multiUnitInfo.getBaseConvsRate();
            int precision = multiUnitInfo.getQtyPrecision();
            if (coefficient != null) {
                assQty = baseQty.divide(coefficient, precision, 4);
            }
        }
        return assQty;
    }

    public static BigDecimal getUnitPrice(Context ctx, MeasureUnitInfo mui, MaterialInfo mi, BigDecimal basePrice) throws EASBizException, BOSException {
        MultiMeasureUnitInfo multiUnitInfo;
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal price = new BigDecimal("0.00");
        if (basePrice != null) {
            price = basePrice;
        }
        if (mui != null && mi != null && (coefficient = (multiUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(mi.getId().toString(), mui.getId().toString())).getBaseConvsRate()) != null) {
            price = price.multiply(coefficient);
        }
        return price;
    }

    public static TransactionTypeInfo getTransaction(Context ctx, String billTypeID, BizTypeInfo bizType, BillTypeInfo srcBillType) throws EASBizException, BOSException {
        TransactionTypeCollection tic;
        String bizTypeID = null;
        String srcBillTypeID = null;
        TransactionTypeInfo transaction = null;
        if (bizType != null) {
            bizTypeID = bizType.getId().toString();
        }
        if (srcBillType != null) {
            srcBillTypeID = srcBillType.getId().toString();
        }
        if (billTypeID != null && srcBillTypeID != null && (tic = TransactionTypeFactory.getLocalInstance((Context)ctx).getCollection(billTypeID, bizTypeID)) != null) {
            for (int i = 0; i < tic.size(); ++i) {
                transaction = tic.get(i);
                if (transaction.getStatus().getValue() != 1) continue;
                return transaction;
            }
        }
        return null;
    }

    public static WarehouseInfo getDefaultWarehouse(Context ctx, StorageOrgUnitInfo sou, MaterialInfo mi, int isStarted) throws EASBizException, BOSException {
        if (sou != null && mi != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("MATERIAL.ID", (Object)mi.getId().toString(), CompareType.EQUALS));
            IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
            IObjectPK[] pks = imsa.getPKList(filterInfo, null);
            IWarehouse iw = WarehouseFactory.getLocalInstance((Context)ctx);
            int recs2 = pks.length;
            ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("whman.number"));
            sic.add(new SelectorItemInfo("whman.name"));
            if (recs2 > 0) {
                if (isStarted != 0) {
                    ObjectUuidPK pk = new ObjectUuidPK(imsa.getMaterialStorageAssignInfo(pks[0]).getWarehouse().getBOSUuid("id"));
                    WarehouseInfo wi = iw.getWarehouseInfo((IObjectPK)pk, sic);
                    return wi;
                }
                for (int i = 0; i < recs2; ++i) {
                    ObjectUuidPK pk = new ObjectUuidPK(imsa.getMaterialStorageAssignInfo(pks[i]).getWarehouse().getBOSUuid("id"));
                    WarehouseInfo wi = iw.getWarehouseInfo((IObjectPK)pk, sic);
                    if (iso.isStarted(sou, wi)) continue;
                    return wi;
                }
            }
        }
        return null;
    }

    public static LocationInfo getDefaultLocation(Context ctx, StorageOrgUnitInfo sou, MaterialInfo mi, WarehouseInfo wi) throws EASBizException, BOSException {
        if (sou != null && mi != null && wi != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("MATERIAL.ID", (Object)mi.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("WAREHOUSE.ID", (Object)wi.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
            if (imsa != null) {
                IObjectPK[] pks = imsa.getPKList(filterInfo, null);
                ILocation il = LocationFactory.getLocalInstance((Context)ctx);
                int recs = pks.length;
                if (recs > 0) {
                    if (imsa.getMaterialStorageAssignInfo(pks[0]).getLocation() != null) {
                        ObjectUuidPK pk = new ObjectUuidPK(imsa.getMaterialStorageAssignInfo(pks[0]).getLocation().getBOSUuid("id"));
                        return il.getLocationInfo((IObjectPK)pk);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static PersonInfo getDefaultStocker(Context ctx, String warehsID) throws EASBizException, BOSException {
        if (warehsID != null) {
            IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
            WarehouseInfo wareInfo = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("whman.id"));
            sic.add(new SelectorItemInfo("whman.number"));
            sic.add(new SelectorItemInfo("whman.name"));
            ObjectUuidPK pk = new ObjectUuidPK(warehsID);
            wareInfo = iWarehouse.getWarehouseInfo((IObjectPK)pk, sic);
            if (wareInfo.getWhman() != null) {
                return wareInfo.getWhman();
            }
        }
        return null;
    }

    public static String getMultiMeasureUnitOQL(String[] matId, String[] mUnitId) {
        String oqlWhere = "material.id = null or measureUnit.id = null";
        boolean isFirst = true;
        int size = matId.length;
        for (int i = 0; i < size; ++i) {
            if (StringUtils.isEmpty((String)matId[i]) || StringUtils.isEmpty((String)mUnitId[i])) continue;
            if (isFirst) {
                isFirst = false;
                oqlWhere = "(material.id = '" + matId[i] + "' and measureUnit.id = '" + mUnitId[i] + "')";
                continue;
            }
            oqlWhere = oqlWhere + " or (material.id = '" + matId[i] + "' and measureUnit.id = '" + mUnitId[i] + "')";
        }
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return oqlWhere;
        }
        oqlWhere = "select material.id, measureUnit.id, qtyPrecision,baseConvsRate where " + oqlWhere;
        return oqlWhere;
    }

    public static MaterialCompanyInfoCollection getMatCompanyInfoCollection_Backup20110426(Context ctx, InvBillBaseInfo billInfo) throws BOSException {
        MaterialCompanyInfoCollection result = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IObjectCollection entryCol = (IObjectCollection)billInfo.get("entry");
        if (entryCol == null) {
            entryCol = (IObjectCollection)billInfo.get("entries");
        }
        boolean isNeedQuery = false;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            CompanyOrgUnitInfo couInfo = entryInfo.getCompanyOrgUnit();
            MaterialInfo matInfo = entryInfo.getMaterial();
            if (couInfo == null || matInfo == null) continue;
            isNeedQuery = true;
            filter.appendFilterItem("company", (Object)couInfo.getId().toString());
            filter.appendFilterItem("mateial", (Object)matInfo.getId().toString());
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()), CompareType.NOTEQUALS));
        }
        StringBuffer maskString = new StringBuffer(filter.getFilterItems().size() * 13);
        int size2 = filter.getFilterItems().size();
        for (int i = 0; i < size2; i += 3) {
            maskString.append("(#").append(i).append(" and #").append(i + 1).append(" and #");
            maskString.append(i + 2).append(") or ");
        }
        int length = maskString.length();
        maskString = length > 0 ? maskString.delete(length - 4, length) : maskString;
        filter.setMaskString(maskString.toString());
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("id");
        viewInfo.getSelector().add("company");
        viewInfo.getSelector().add("company.id");
        viewInfo.getSelector().add("company.name");
        viewInfo.getSelector().add("company.number");
        viewInfo.getSelector().add("mateial");
        viewInfo.getSelector().add("mateial.id");
        viewInfo.getSelector().add("mateial.number");
        result = isNeedQuery ? MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(viewInfo) : new MaterialCompanyInfoCollection();
        return result;
    }

    public static Map<String, MaterialCompanyInfoInfo> getMatCompanyInfoMap(Context ctx, InvBillBaseInfo billInfo) throws BOSException {
        MaterialCompanyInfoCollection coll = InvServerUtils.getMatCompanyInfoCollection(ctx, billInfo);
        HashMap<String, MaterialCompanyInfoInfo> retValue = new HashMap<String, MaterialCompanyInfoInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            MaterialCompanyInfoInfo info = coll.get(i);
            retValue.put(info.getMateial().getId().toString(), info);
        }
        return retValue;
    }

    public static MaterialCompanyInfoCollection getMatCompanyInfoCollection(Context ctx, InvBillBaseInfo billInfo) throws BOSException {
        MaterialInfo matInfo;
        CompanyOrgUnitInfo couInfo;
        InvBillBaseEntryInfo entryInfo;
        MaterialCompanyInfoCollection result = null;
        IObjectCollection entryCol = (IObjectCollection)billInfo.get("entry");
        if (entryCol == null) {
            entryCol = (IObjectCollection)billInfo.get("entries");
        }
        boolean isNeedQuery = false;
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> companyIdSet = new HashSet<String>();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            couInfo = entryInfo.getCompanyOrgUnit();
            matInfo = entryInfo.getMaterial();
            if (couInfo == null || matInfo == null) continue;
            isNeedQuery = true;
            materialIdSet.add(matInfo.getId().toString());
            companyIdSet.add(couInfo.getId().toString());
        }
        if (isNeedQuery) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company", companyIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("mateial", materialIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add("id");
            viewInfo.getSelector().add("company");
            viewInfo.getSelector().add("company.id");
            viewInfo.getSelector().add("company.name");
            viewInfo.getSelector().add("company.number");
            viewInfo.getSelector().add("mateial");
            viewInfo.getSelector().add("mateial.id");
            viewInfo.getSelector().add("mateial.number");
            viewInfo.getSelector().add("mateial.pricePrecision");
            viewInfo.getSelector().add("standardCost");
            viewInfo.getSelector().add("accountType");
            MaterialCompanyInfoCollection temp = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(viewInfo);
            result = new MaterialCompanyInfoCollection();
            if (temp != null && temp.size() > 0) {
                MaterialCompanyInfoInfo mcInfo;
                int i;
                HashMap<String, MaterialCompanyInfoInfo> materialCompanyMap = new HashMap<String, MaterialCompanyInfoInfo>();
                int size2 = temp.size();
                for (i = 0; i < size2; ++i) {
                    mcInfo = temp.get(i);
                    materialCompanyMap.put(mcInfo.getMateial().getId().toString() + mcInfo.getCompany().getId().toString(), mcInfo);
                }
                size2 = entryCol.size();
                for (i = 0; i < size2; ++i) {
                    entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
                    couInfo = entryInfo.getCompanyOrgUnit();
                    matInfo = entryInfo.getMaterial();
                    if (couInfo == null || matInfo == null || null == (mcInfo = (MaterialCompanyInfoInfo)materialCompanyMap.get(matInfo.getId().toString() + couInfo.getId().toString()))) continue;
                    result.add(mcInfo);
                }
            }
        } else {
            result = new MaterialCompanyInfoCollection();
        }
        return result;
    }

    public static MaterialCompanyInfoCollection getStandardCostMatCompanyCollection(Context ctx, InvBillBaseInfo billInfo) throws BOSException {
        MaterialCompanyInfoInfo mciInfo;
        int i;
        MaterialInfo matInfo;
        CompanyOrgUnitInfo couInfo;
        InvBillBaseEntryInfo entryInfo;
        IObjectCollection entryCol = (IObjectCollection)billInfo.get("entry");
        HashSet<String> couIdSet = new HashSet<String>();
        HashSet<String> matIdSet = new HashSet<String>();
        int size = entryCol.size();
        for (int i2 = 0; i2 < size; ++i2) {
            entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i2);
            couInfo = entryInfo.getCompanyOrgUnit();
            matInfo = entryInfo.getMaterial();
            if (couInfo == null || matInfo == null) continue;
            couIdSet.add(couInfo.getId().toString());
            matIdSet.add(matInfo.getId().toString());
        }
        MaterialCompanyInfoCollection result = new MaterialCompanyInfoCollection();
        if (couIdSet.size() == 0 || matIdSet.size() == 0) {
            return result;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", couIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("mateial", matIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("accountType", (Object)new Integer(2)));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("id");
        viewInfo.getSelector().add("company");
        viewInfo.getSelector().add("mateial");
        MaterialCompanyInfoCollection tempCol = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(viewInfo);
        if (tempCol == null || tempCol.size() == 0) {
            return result;
        }
        HashMap<String, MaterialCompanyInfoInfo> tempMap = new HashMap<String, MaterialCompanyInfoInfo>();
        int size2 = tempCol.size();
        for (i = 0; i < size2; ++i) {
            mciInfo = tempCol.get(i);
            tempMap.put(mciInfo.getMateial().getId().toString() + mciInfo.getCompany().getId().toString(), mciInfo);
        }
        size2 = entryCol.size();
        for (i = 0; i < size2; ++i) {
            entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            couInfo = entryInfo.getCompanyOrgUnit();
            matInfo = entryInfo.getMaterial();
            if (couInfo == null || matInfo == null || null == (mciInfo = (MaterialCompanyInfoInfo)tempMap.get(matInfo.getId().toString() + couInfo.getId().toString()))) continue;
            result.add(mciInfo);
        }
        return result;
    }

    public static MaterialCompanyInfoCollection getStandardCostMatCompanyCollection_backup20110428(Context ctx, InvBillBaseInfo billInfo) throws BOSException {
        int fiterLoop;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IObjectCollection entryCol = (IObjectCollection)billInfo.get("entry");
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            CompanyOrgUnitInfo couInfo = entryInfo.getCompanyOrgUnit();
            MaterialInfo matInfo = entryInfo.getMaterial();
            filter.appendFilterItem("company", (Object)couInfo.getId().toString());
            filter.appendFilterItem("mateial", (Object)matInfo.getId().toString());
        }
        StringBuffer maskString = new StringBuffer(filter.getFilterItems().size() * 13);
        maskString.append("(");
        int size2 = filter.getFilterItems().size();
        for (fiterLoop = 0; fiterLoop < size2; fiterLoop += 2) {
            maskString.append("(#").append(fiterLoop).append(" and #").append(fiterLoop + 1).append(") or ");
        }
        int length = maskString.length();
        maskString = length > 0 ? maskString.delete(length - 4, length) : maskString;
        maskString.append(")");
        filter.appendFilterItem("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()));
        filter.appendFilterItem("accountType", (Object)new Integer(2));
        maskString.append(" and #").append(fiterLoop++);
        maskString.append(" and #").append(fiterLoop++);
        filter.setMaskString(maskString.toString());
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("id");
        viewInfo.getSelector().add("company");
        viewInfo.getSelector().add("mateial");
        return MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(viewInfo);
    }

    public static String getMatCompanyInfoNullMsg(Context ctx, MaterialCompanyInfoCollection matCouInfoCol, InvBillBaseInfo billInfo) throws BOSException {
        IObjectCollection entryCol = (IObjectCollection)billInfo.get("entry");
        InvBillBaseEntryInfo entryInfo = null;
        CompanyOrgUnitInfo couInfo = null;
        MaterialInfo matInfo = null;
        HashMap matCouMap = new HashMap(matCouInfoCol.size() * 2);
        int size = matCouInfoCol.size();
        for (int i = 0; i < size; ++i) {
            couInfo = matCouInfoCol.get(i).getCompany();
            matInfo = matCouInfoCol.get(i).getMateial();
            if (couInfo == null || matInfo == null) continue;
            matCouMap.put(couInfo.getId().toString() + matInfo.getId().toString(), null);
        }
        StringBuffer errorMsg = new StringBuffer();
        int size2 = entryCol.size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            couInfo = entryInfo.getCompanyOrgUnit();
            matInfo = entryInfo.getMaterial();
            if (couInfo == null || matInfo == null || matCouMap.containsKey(couInfo.getId().toString() + matInfo.getId().toString())) continue;
            errorMsg.append(SP).append(matInfo.getNumber());
            if (couInfo != null && couInfo.getNumber() != null) {
                errorMsg.append("      ").append(couInfo.getNumber());
                continue;
            }
            errorMsg.append("      ").append(" No companyOrgUnit ");
        }
        return errorMsg.toString();
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, SaleOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 2, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 2, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    public static CompanyOrgUnitInfo getCompanyInfoForStorage(Context ctx, StorageOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 4, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    public static <T extends OrgUnitInfo> T getOrgInfoFromOrgInfo(Context ctx, OrgUnitInfo fromOrgInfo, int fromType, int toType, T toOrgInfo) throws BOSException, EASBizException {
        if (fromOrgInfo == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        toOrgInfo = iUnitRel.getDefaultToUnit(fromOrgInfo.getId().toString(), fromType, toType);
        if (toOrgInfo == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(fromOrgInfo.getId().toString(), fromType, toType);
            toOrgInfo = orgCol.get(0);
        }
        return toOrgInfo;
    }

    public static CompanyOrgUnitInfo getCompanyInfoForCostCenter(Context ctx, CostCenterOrgUnitInfo cou) throws BOSException, EASBizException {
        if (cou == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(cou.getId().toString(), 5, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(cou.getId().toString(), 5, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    public static CompanyOrgUnitInfo getCompanyInfoForPurchase(Context ctx, PurchaseOrgUnitInfo purInfo) throws BOSException, EASBizException {
        if (purInfo == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(purInfo.getId().toString(), 3, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(purInfo.getId().toString(), 3, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    public static void checkMatCompanyInfo(Context ctx, InvBillBaseInfo billInfo, NumericExceptionSubItem item) throws EASBizException, BOSException {
        MaterialCompanyInfoCollection matCouInfoCol = InvServerUtils.getMatCompanyInfoCollection(ctx, billInfo);
        InvBillBaseEntryInfo entryInfo = null;
        MaterialInfo matInfo = null;
        HashSet<String> materialSet = new HashSet<String>();
        IObjectCollection entryCol = (IObjectCollection)billInfo.get("entry");
        if (entryCol == null) {
            entryCol = (IObjectCollection)billInfo.get("entries");
        }
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            matInfo = entryInfo.getMaterial();
            if (matInfo == null) continue;
            materialSet.add(matInfo.getId().toString());
        }
        if (matCouInfoCol.size() == materialSet.size()) {
            return;
        }
        String errorMsg = InvServerUtils.getMatCompanyInfoNullMsg(ctx, matCouInfoCol, billInfo);
        if (errorMsg != null && errorMsg.length() != 0) {
            throw new InvBizException(item, new String[]{errorMsg});
        }
    }

    public static void checkMaterialCost(Context ctx, InvBillBaseInfo billInfo, String entryName) throws EASBizException, BOSException {
        IObjectCollection entryCol = (IObjectCollection)billInfo.get(entryName);
        Set matCouSet = InvServerUtils.getStandardCostMatCompanyCollectionWithKSql(ctx, billInfo);
        StringBuffer unitMsg = new StringBuffer();
        StringBuffer totalMsg = new StringBuffer();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            CompanyOrgUnitInfo couInfo = entryInfo.getCompanyOrgUnit();
            MaterialInfo matInfo = entryInfo.getMaterial();
            if (!matCouSet.contains(couInfo.getId().toString() + matInfo.getId().toString())) continue;
            if (entryInfo.getStandardCost().compareTo(entryInfo.getActualCost()) != 0) {
                totalMsg.append(new Integer(entryInfo.getSeq())).append("\u3001");
            }
            if (entryInfo.getUnitStandardCost().compareTo(entryInfo.getUnitActualCost()) == 0) continue;
            unitMsg.append(new Integer(entryInfo.getSeq())).append("\u3001");
        }
        if (totalMsg.length() > 0 && unitMsg.length() > 0) {
            totalMsg.deleteCharAt(totalMsg.length() - 1);
            unitMsg.deleteCharAt(unitMsg.length() - 1);
            throw new InvBizException(InvBizException.COSTNOTEQUAL, new String[]{unitMsg.toString(), totalMsg.toString()});
        }
        if (totalMsg.length() > 0) {
            totalMsg.deleteCharAt(totalMsg.length() - 1);
            throw new InvBizException(InvBizException.TOTALCOSTNOTEQUAL, new String[]{totalMsg.toString()});
        }
        if (unitMsg.length() > 0) {
            unitMsg.deleteCharAt(unitMsg.length() - 1);
            throw new InvBizException(InvBizException.UNITCOSTNOTEQUAL, new String[]{unitMsg.toString()});
        }
    }

    public static IRowSet executeQuery(Connection conn, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Connection conn, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                stmt.setObject(i, params[i]);
            }
            rs = stmt.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return jdbcRowSet;
    }

    public static void execute(Connection conn, String sql) throws BOSException {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
    }

    public static String getInvDataByBillTypeId(Context ctx, String billid, String entryid, String billtypeId) throws BOSException, EASBizException {
        if (billid == null || billid.trim().length() < 1 || billtypeId == null || billtypeId.trim().length() < 1) {
            return null;
        }
        String tempTable = "InvTempTableForManuf";
        tempTable = KsqlUtil.createTempTable((Context)ctx, (String)InvServerUtils.getCreateTempTable(tempTable));
        InvServerUtils.insertBillata(ctx, billid, entryid, billtypeId, tempTable);
        return tempTable;
    }

    private static void insertBillata(Context ctx, String billid, String entryid, String billtypeId, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlTable = new StringBuffer();
        if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
            sqlTable.append(" t_im_otherinwarehsbill bill , t_im_otherinwarehsbillentry entry ");
        }
        if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
            sqlTable.append("  t_im_otherissuebill bill , t_im_otherissuebillentry entry ");
        }
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
            sqlTable.append("  t_im_purinwarehsbill  bill , t_im_purinwarehsentry entry ");
        }
        if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
            sqlTable.append(" t_im_manufacturerecbill  bill , t_im_manufacturerecbillentry entry ");
        }
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
            sqlTable.append("  t_im_saleissuebill  bill , t_im_saleissueentry entry ");
        }
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
            sqlTable.append("  t_sd_saleorder  bill , t_sd_saleorderentry entry ");
        }
        if (sqlTable != null && sqlTable.toString().length() > 0) {
            sql.append("insert into ").append(tempTable).append(" ").append("(FID,FNumber,").append("FEntryID,FSeq,FBillTypeID, ").append("FSourceBillTypeID,FStorageOrgUnitID, ").append("FMaterialID,FDate, ").append("FUnitID,FBaseUnitID, ").append("FQty,FBaseQty, ").append("FSourceBillID,FSourceBillEntryID, ").append("FSourceSUID,FCreatorID,FProjectID,FTrackNumberID ").append(") ").append(SP).append("select ").append("  bill.fid  as FID, bill.fnumber as FNumber, entry.fid as FEntryID,entry.fseq as FSeq ,bill.fbilltypeid as FBillTypeID ,bill.fsourcebilltypeid as FSourceBillTypeID, ").append(" entry.fstorageorgunitid as FStorageOrgUnitID,entry.fmaterialid as FMaterialID,bill.fbizdate as FDate,entry.funitid as FUnitID,entry.fbaseunitid as FBaseUnitID,  ").append(" entry.fqty as FQty ,entry.fbaseqty as FBaseQty, entry.fsourcebillid as FSourceBillID, entry.fsourcebillentryid as FSourceBillEntryID,entry.fstorageorgunitid as FSourceSUID,bill.FCreatorID as FCreatorID ").append(",entry.FProjectID as FProjectID,entry.FTrackNumberID as FTrackNumberID ").append(" from ").append(sqlTable).append(" where bill.fid = entry.fparentid and bill.fid = '" + billid + "' ");
        } else {
            if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
                sqlTable.append("   t_im_moveissuebill  bill , t_im_moveissuebillentry  entry ");
                sql.append("insert into ").append(tempTable).append(" ").append("(FID,FNumber,").append("FEntryID,FSeq,FBillTypeID, ").append("FSourceBillTypeID,FStorageOrgUnitID, ").append("FMaterialID,FDate, ").append("FUnitID,FBaseUnitID, ").append("FQty,FBaseQty, ").append("FSourceBillID,FSourceBillEntryID, ").append("FSourceSUID ,FCreatorID ,FProjectID,FTrackNumberID ").append(") ").append(SP).append("select ").append("  bill.fid  as FID, bill.fnumber as FNumber, entry.fid as FEntryID,entry.fseq as FSeq ,bill.fbilltypeid as FBillTypeID ,bill.fsourcebilltypeid as FSourceBillTypeID, ").append("  bill.fstorageorgunitid  as FStorageOrgUnitID,entry.fmaterialid as FMaterialID,bill.fbizdate as FDate,entry.funitid as FUnitID,entry.fbaseunitid as FBaseUnitID,  ").append(" entry.fqty as FQty ,entry.fbaseqty as FBaseQty, entry.fsourcebillid as FSourceBillID, entry.fsourcebillentryid as FSourceBillEntryID,bill.FReceiptStorageOrgUnitID  as FSourceSUID ,bill.FCreatorID as FCreatorID ").append(",entry.FProjectID as FProjectID,entry.FTrackNumberID as FTrackNumberID ").append(" from ").append(sqlTable).append(" where bill.fid = entry.fparentid and bill.fid = '" + billid + "' ");
            }
            if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equalsIgnoreCase(billtypeId)) {
                sqlTable.append("   t_im_stocktransferbill  bill ,  t_im_stocktransferbillentry  entry ");
                sql.append("insert into ").append(tempTable).append(" ").append("(FID,FNumber,").append("FEntryID,FSeq,FBillTypeID, ").append("FSourceBillTypeID,FStorageOrgUnitID, ").append("FMaterialID,FDate, ").append("FUnitID,FBaseUnitID, ").append("FQty,FBaseQty, ").append("FSourceBillID,FSourceBillEntryID, ").append("FSourceSUID,FCreatorID,FProjectID,FTrackNumberID ").append(") ").append(SP).append("select ").append("  bill.fid  as FID, bill.fnumber as FNumber, entry.fid as FEntryID,entry.fseq as FSeq ,bill.fbilltypeid as FBillTypeID ,bill.fsourcebilltypeid as FSourceBillTypeID, ").append("  bill.FIssueStorageOrgUnitID  as FStorageOrgUnitID,entry.fmaterialid as FMaterialID,entry.fissueplandate as FDate,entry.funitid as FUnitID,entry.fbaseunitid as FBaseUnitID,  ").append(" entry.fqty as FQty ,entry.fbaseqty as FBaseQty, entry.fsourcebillid as FSourceBillID, entry.fsourcebillentryid as FSourceBillEntryID,bill.FReceiptStorageOrgUnitID as FSourceSUID,bill.FCreatorID as FCreatorID ").append(",entry.FProjectID as FProjectID,entry.FTrackNumberID as FTrackNumberID ").append(" from ").append(sqlTable).append(" where bill.fid = entry.fparentid and bill.fid = '" + billid + "' ");
            }
            if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equalsIgnoreCase(billtypeId)) {
                sqlTable.append("   t_im_transferorderbill  bill ,  t_im_transferorderbillentry  entry ");
                sql.append("insert into ").append(tempTable).append(" ").append("(FID,FNumber,").append("FEntryID,FSeq,FBillTypeID, ").append("FSourceBillTypeID,FStorageOrgUnitID, ").append("FMaterialID,FDate, ").append("FUnitID,FBaseUnitID, ").append("FQty,FBaseQty, ").append("FSourceBillID,FSourceBillEntryID, ").append("FSourceSUID,FCreatorID,FProjectID,FTrackNumberID ").append(") ").append(SP).append("select ").append("  bill.fid  as FID, bill.fnumber as FNumber, entry.fid as FEntryID,entry.fseq as FSeq ,bill.fbilltypeid as FBillTypeID ,bill.fsourcebilltypeid as FSourceBillTypeID, ").append("  entry.FIssueStorageOrgUnitID  as FStorageOrgUnitID,entry.fmaterialid as FMaterialID,entry.fissueplandate as FDate,entry.funitid as FUnitID,entry.fbaseunitid as FBaseUnitID,  ").append(" entry.fqty as FQty ,entry.fbaseqty as FBaseQty, entry.fsourcebillid as FSourceBillID, entry.fsourcebillentryid as FSourceBillEntryID,entry.FReceiveStorageOrgUnitID as FSourceSUID,bill.FCreatorID as FCreatorID ").append(",entry.FProjectID as FProjectID,entry.FTrackNumberID as FTrackNumberID ").append(" from ").append(sqlTable).append(" where bill.fid = entry.fparentid and bill.fid = '" + billid + "' ");
            }
        }
        if (sqlTable != null && sqlTable.toString().length() > 0) {
            if (entryid != null && entryid.trim().length() > 0) {
                sql.append(" and entry.fid ='" + entryid + "' ");
            }
            InvServerUtils.executeSQL(ctx, sql.toString());
        }
    }

    private static String getCreateTempTable(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ").append(tempTable).append("(");
        sql.append("FID Varchar(44),");
        sql.append("FNumber nvarchar(80),");
        sql.append("FEntryID Varchar(44),");
        sql.append("FSeq INT,");
        sql.append("FBillTypeID Varchar(44),");
        sql.append("FSourceBillTypeID Varchar(44),");
        sql.append("FStorageOrgUnitID Varchar(44),");
        sql.append("FMaterialID Varchar(44),");
        sql.append("FDate datetime,");
        sql.append("FUnitID Varchar(44),");
        sql.append("FBaseUnitID Varchar(44),");
        sql.append("FQty Decimal(28,10) not null default 0,");
        sql.append("FBaseQty Decimal(28,10) not null default 0,");
        sql.append("FSourceBillID Varchar(44),");
        sql.append("FSourceBillEntryID Varchar(44),");
        sql.append("FSourceSUID Varchar(44),");
        sql.append("FCreatorID Varchar(44),");
        sql.append("FProjectID Varchar(44),");
        sql.append("FTrackNumberID Varchar(44) ");
        sql.append(");");
        return sql.toString();
    }

    private static void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            Connection con = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                DBUtil.executeUpdate((String)sql, null, (Connection)con);
            }
            catch (SQLException e) {
                e.setNextException(new SQLException("SQL: " + sql));
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup(null, null, (Connection)con);
            }
        }
    }

    public static void handleReqPlan(String billID, String billTypeId, BizActionEnum operateType, Context ctx) throws BOSException, EASBizException {
        IReqPlanForSCMFacade iReqPlanForSCMFacade = ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx);
        if (!StringUtil.isEmpty((String)billID) && operateType != null && !StringUtil.isEmpty((String)billTypeId)) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(billID);
            iReqPlanForSCMFacade.counteractFromInvBill(billTypeId, list, operateType);
        }
    }

    public static void handleBatchReqPlan(Set billInfos, String billTypeId, BizActionEnum operateType, Context ctx) throws BOSException, EASBizException {
        IReqPlanForSCMFacade iReqPlanForSCMFacade = ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx);
        Iterator it = billInfos.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            SCMBillBaseInfo billInfo = (SCMBillBaseInfo)it.next();
            if (billInfo == null || operateType == null || billInfo.getId() == null || billInfo.getId().toString().length() <= 0 || billTypeId == null || billTypeId.length() <= 1) continue;
            list.add(billInfo.getId().toString());
        }
        iReqPlanForSCMFacade.counteractFromInvBill(billTypeId, list, operateType);
    }

    private static Set getStandardCostMatCompanyCollectionWithKSql(Context ctx, InvBillBaseInfo billInfo) throws BOSException {
        HashSet<String> matCouSet = new HashSet<String>();
        StringBuffer ksql = new StringBuffer();
        IObjectCollection entryCol = (IObjectCollection)billInfo.get("entry");
        HashSet<String> companyIDSet = new HashSet<String>();
        HashSet<String> materialIDSet = new HashSet<String>();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            if (entryInfo.getCompanyOrgUnit() != null) {
                companyIDSet.add(entryInfo.getCompanyOrgUnit().getId().toString());
            }
            if (entryInfo.getMaterial() == null) continue;
            materialIDSet.add(entryInfo.getMaterial().getId().toString());
        }
        ksql.append("select FMaterialID, FCompanyID").append(SP);
        ksql.append("from t_bd_materialcompanyinfo mcinfo").append(SP);
        ksql.append("where mcinfo.FStatus = 1").append(SP);
        ksql.append("and mcinfo.FAccountType = 2").append(SP);
        ksql.append("and (1 != 1 ").append(SP);
        Iterator iter = companyIDSet.iterator();
        while (iter.hasNext()) {
            ksql.append("or mcinfo.fcompanyid = '").append(iter.next()).append("'");
        }
        ksql.append(") and (1 != 1 ").append(SP);
        iter = companyIDSet.iterator();
        while (iter.hasNext()) {
            ksql.append("or mcinfo.fmaterialid = '").append(iter.next()).append("'");
        }
        ksql.append(")");
        JdbcRowSet rowSet = (JdbcRowSet)DbUtil.executeQuery((Context)ctx, (String)ksql.toString());
        String companyID = null;
        String materialID = null;
        try {
            if (rowSet.next()) {
                companyID = rowSet.getString("FCompanyID");
                materialID = rowSet.getString("FMaterialID");
                matCouSet.add(companyID + materialID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return matCouSet;
    }

    public static void canCancelResultHandler(Context ctx, String srcBillID, String srcBillEntryID, QCReturnResultCollection rsList) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> bosType = new HashSet<String>();
        bosType.add("B2ABD4E9");
        bosType.add("751CA7E1");
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcBillID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", bosType, CompareType.NOTINCLUDE));
        viewInfo.setFilter(filterInfo);
        BOTRelationCollection collection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            throw new PurReceivalException(PurReceivalException.CREATED_INWAREHS_CANNOT_CANCEL_CHECKRESULT);
        }
    }

    public static void checkMaterialCompanyOrgAndCost(Context ctx, InvBillBaseInfo billInfo, String entryName) throws EASBizException, BOSException {
        MaterialInfo matInfo;
        CompanyOrgUnitInfo couInfo;
        String errorMsg;
        MaterialCompanyInfoCollection matCouInfoCol = InvServerUtils.getMatCompanyInfoCollection(ctx, billInfo);
        IObjectCollection entryCol = (IObjectCollection)billInfo.get(entryName);
        if (matCouInfoCol.size() != entryCol.size() && (errorMsg = InvServerUtils.getMatCompanyInfoNullMsg(ctx, matCouInfoCol, billInfo)) != null && errorMsg.length() != 0) {
            throw new InvBizException(InvBizException.MATERIAL_COMPANY_NULL, new String[]{errorMsg});
        }
        HashMap<String, MaterialCompanyInfoInfo> matCouMap = new HashMap<String, MaterialCompanyInfoInfo>(matCouInfoCol.size() * 2);
        Integer accountType = new Integer(2);
        int size = matCouInfoCol.size();
        for (int i = 0; i < size; ++i) {
            couInfo = matCouInfoCol.get(i).getCompany();
            matInfo = matCouInfoCol.get(i).getMateial();
            if (!accountType.equals(matCouInfoCol.get(i).getAccountType())) continue;
            matCouMap.put(couInfo.getId().toString() + matInfo.getId().toString(), matCouInfoCol.get(i));
        }
        StringBuffer unitMsg = new StringBuffer();
        StringBuffer totalMsg = new StringBuffer();
        int size2 = entryCol.size();
        for (int i = 0; i < size2; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(i);
            couInfo = entryInfo.getCompanyOrgUnit();
            matInfo = entryInfo.getMaterial();
            if (matCouMap.get(couInfo.getId().toString() + matInfo.getId().toString()) == null) continue;
            if (entryInfo.getStandardCost().compareTo(entryInfo.getActualCost()) != 0) {
                totalMsg.append(new Integer(entryInfo.getSeq())).append("\u3001");
            }
            if (entryInfo.getUnitStandardCost().compareTo(entryInfo.getUnitActualCost()) == 0) continue;
            unitMsg.append(new Integer(entryInfo.getSeq())).append("\u3001");
        }
        if (totalMsg.length() > 0 && unitMsg.length() > 0) {
            totalMsg.deleteCharAt(totalMsg.length() - 1);
            unitMsg.deleteCharAt(unitMsg.length() - 1);
            throw new InvBizException(InvBizException.COSTNOTEQUAL, new String[]{unitMsg.toString(), totalMsg.toString()});
        }
        if (totalMsg.length() > 0) {
            totalMsg.deleteCharAt(totalMsg.length() - 1);
            throw new InvBizException(InvBizException.TOTALCOSTNOTEQUAL, new String[]{totalMsg.toString()});
        }
        if (unitMsg.length() > 0) {
            unitMsg.deleteCharAt(unitMsg.length() - 1);
            throw new InvBizException(InvBizException.UNITCOSTNOTEQUAL, new String[]{unitMsg.toString()});
        }
    }

    public static Map getMaterialInvMap(Context ctx, Collection storageOrgIds, Collection materialIds, String[] fields) throws BOSException {
        HashMap map = new HashMap();
        if (fields.length == 0 || storageOrgIds.size() == 0 || materialIds.size() == 0) {
            return map;
        }
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        String storageOrgStr = InvServerUtils.getSqlIdsStrForColl(storageOrgIds);
        String materialStr = InvServerUtils.getSqlIdsStrForColl(materialIds);
        StringBuffer sql = new StringBuffer();
        sql.append(" select fmaterialid,forgunit,");
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].equals("fmaterialid") || fields[i].equals("forgunit")) continue;
            if (i == fields.length - 1) {
                sql.append(fields[i]);
                continue;
            }
            sql.append(fields[i] + ",");
        }
        sql.append(" from T_BD_MaterialInventory ").append(" where Fmaterialid in (" + materialStr + ")").append(" and forgunit in (" + storageOrgStr + ")").append(" and fstatus=1");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sql.toString());
            rs = preStmt.executeQuery();
            while (rs.next()) {
                HashMap<String, String> temp = new HashMap<String, String>();
                for (int i = 0; i < fields.length; ++i) {
                    temp.put(fields[i], rs.getString(fields[i]));
                }
                map.put(rs.getString("forgunit") + rs.getString("fmaterialid"), temp);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return map;
    }

    public static String getSqlIdsStrForColl(Collection coll) {
        StringBuffer str = new StringBuffer();
        Iterator it = coll.iterator();
        int i = 0;
        while (it.hasNext()) {
            String id;
            Object obj = it.next();
            if (obj == null || StringUtil.isEmpty((String)(id = obj.toString()))) continue;
            if (i != 0) {
                str.append(",'" + id + "'");
            } else {
                str.append("'" + id + "'");
            }
            ++i;
        }
        return str.toString();
    }

    public static Map getMultiUnitMap(Context ctx, Set unitSet) throws BOSException {
        HashMap result = new HashMap();
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        if (unitSet.size() == 0) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fmaterialid,fmeasureunitid,fbaseconvsrate,fqtyprecision from T_BD_MultiMeasureUnit where 1=1 and (");
        Iterator it = unitSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            String matIdAndUnitId = (String)it.next();
            String[] ids = matIdAndUnitId.split(",");
            if (i != 0) {
                sql.append(" or ");
            }
            sql.append(" (fmaterialid='" + ids[0] + "' and fmeasureunitid='" + ids[1] + "')");
            ++i;
        }
        sql.append(" )");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sql.toString());
            rs = preStmt.executeQuery();
            while (rs.next()) {
                HashMap<String, String> temp = new HashMap<String, String>();
                temp.put("fbaseconvsrate", rs.getString("fbaseconvsrate"));
                temp.put("fqtyprecision", rs.getString("fqtyprecision"));
                result.put(rs.getString("fmaterialid") + rs.getString("fmeasureunitid"), temp);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return result;
    }

    public static String getResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }

    public static Map getMatCompanyInfoCollection(Context ctx, String[] materialIDS, String[] OrgIDs) throws BOSException {
        if (null == materialIDS || null == OrgIDs || materialIDS.length != OrgIDs.length || materialIDS.length == 0) {
            return new HashMap();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashMap<String, MaterialCompanyInfoInfo> matCompany = new HashMap<String, MaterialCompanyInfoInfo>();
        String key = "";
        MaterialCompanyInfoInfo materialCompanyInfoInfo = null;
        IMaterialCompanyInfo iMaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        if (materialIDS != null && OrgIDs != null) {
            int size = materialIDS.length;
            for (int i = 0; i < size; ++i) {
                if (materialIDS[i] == null || OrgIDs[i] == null) continue;
                filter.appendFilterItem("company", (Object)OrgIDs[i]);
                filter.appendFilterItem("mateial", (Object)materialIDS[i]);
                filter.appendFilterItem("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()));
            }
            StringBuffer maskString = new StringBuffer(filter.getFilterItems().size() * 13);
            int size2 = filter.getFilterItems().size();
            for (int i = 0; i < size2; i += 3) {
                maskString.append("(#").append(i).append(" and #").append(i + 1).append(" and #");
                maskString.append(i + 2).append(") or ");
            }
            int length = maskString.length();
            maskString = length > 0 ? maskString.delete(length - 4, length) : maskString;
            filter.setMaskString(maskString.toString());
            viewInfo.setFilter(filter);
            MaterialCompanyInfoCollection coll = iMaterialCompany.getMaterialCompanyInfoCollection(viewInfo);
            if (coll != null) {
                for (int j = 0; j < coll.size(); ++j) {
                    materialCompanyInfoInfo = coll.get(j);
                    if (materialCompanyInfoInfo == null || materialCompanyInfoInfo.getMateial() == null || materialCompanyInfoInfo.getCompany() == null) continue;
                    key = materialCompanyInfoInfo.getMateial().getId().toString() + materialCompanyInfoInfo.getCompany().getId().toString();
                    matCompany.put(key, materialCompanyInfoInfo);
                }
            }
        }
        return matCompany;
    }

    public static List fillInfoIdsArray(Context ctx, InvBillBaseCollection billColl, OrgType orgType) throws EASBizException, BOSException {
        HashSet<String> tempSet = new HashSet<String>();
        InvBillBaseInfo invBillBaseInfo = null;
        IObjectCollection entryColl = null;
        InvBillBaseEntryInfo entry = null;
        for (int i = 0; i < billColl.size(); ++i) {
            invBillBaseInfo = billColl.get(i);
            if (invBillBaseInfo == null) continue;
            entryColl = InvServerUtils.getEntryCollection(invBillBaseInfo);
            for (int j = 0; j < entryColl.size(); ++j) {
                entry = (InvBillBaseEntryInfo)entryColl.getObject(j);
                if (entry == null || entry.getMaterial() == null) continue;
                if (OrgType.Storage.equals((Object)orgType)) {
                    if (invBillBaseInfo.getStorageOrgUnit() == null) continue;
                    tempSet.add(entry.getMaterial().getId().toString() + "," + invBillBaseInfo.getStorageOrgUnit().getId().toString());
                    continue;
                }
                if (!OrgType.Company.equals((Object)orgType) || entry.getCompanyOrgUnit() == null) continue;
                tempSet.add(entry.getMaterial().getId().toString() + "," + entry.getCompanyOrgUnit().getId().toString());
            }
        }
        String[] materialIds = new String[tempSet.size()];
        String[] orgUnitIds = new String[tempSet.size()];
        Iterator it = tempSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            String[] tempStr = ((String)it.next()).split(",");
            materialIds[i] = tempStr[0];
            orgUnitIds[i] = tempStr[1];
            ++i;
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        result.add(materialIds);
        result.add(orgUnitIds);
        return result;
    }

    protected static IObjectCollection getEntryCollection(InvBillBaseInfo aInvBillBaseInfo) {
        if (aInvBillBaseInfo == null) {
            return new InvBillBaseEntryCollection();
        }
        if (aInvBillBaseInfo.getBillType() != null && "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString())) {
            return (IObjectCollection)aInvBillBaseInfo.get("entries");
        }
        return (IObjectCollection)aInvBillBaseInfo.get("entry");
    }

    public static Set getAuthorizedf7Orgs(Context ctx) {
        OrgViewType[] orgViewTypes = new OrgViewType[]{OrgViewType.STORAGE};
        OrgType orgType = NewOrgViewHelper.convert((OrgViewType)orgViewTypes[0]);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        IObjectPK userPK = ctx.getCaller();
        HashSet<String> orgUnitSet = new HashSet<String>();
        Set fullUnitSet = new HashSet();
        FullOrgUnitCollection unitCol = null;
        try {
            unitCol = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg(userPK, orgType, (IObjectPK)treePK, "inoutstoregatherreport_view");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return orgUnitSet;
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            orgUnitSet.add(unitCol.get(i).getId().toString());
        }
        fullUnitSet = InvServerUtils.getFullOrgUnit(ctx, orgUnitSet);
        return fullUnitSet;
    }

    private static Set getFullOrgUnit(Context ctx, Set orgUnitSet) {
        FullOrgUnitCollection orgUnitCollection = null;
        HashSet<FullOrgUnitInfo> fullUnitSet = new HashSet<FullOrgUnitInfo>();
        try {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("ID", (Object)orgUnitSet, CompareType.INCLUDE));
            ev.setSelector(sic);
            ev.setFilter(fi);
            orgUnitCollection = iFullOrgUnit.getFullOrgUnitCollection(ev);
            for (int i = 0; i < orgUnitCollection.size(); ++i) {
                fullUnitSet.add(orgUnitCollection.get(i));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return fullUnitSet;
    }

    public static Map getPemissionSqlMap(Context ctx, Set cuUnitSets, String repStr, String permItem) {
        FullOrgUnitInfo cuUnit2 = null;
        EntityViewInfo matEntityViewInfo = null;
        String orgId = null;
        HashMap<String, String> permMap = new HashMap<String, String>();
        boolean hasDataPermission = false;
        if (cuUnitSets != null && cuUnitSets.size() > 0) {
            for (FullOrgUnitInfo cuUnit2 : cuUnitSets) {
                try {
                    orgId = cuUnit2.isIsCU() ? cuUnit2.getId().toString() : cuUnit2.getCU().getId().toString();
                    matEntityViewInfo = InvServerUtils.getDataPermissionEntity(ctx, orgId, permItem);
                    if (matEntityViewInfo != null) {
                        if ("bd_material_view".equals(permItem)) {
                            permMap.put(cuUnit2.getId().toString(), InvServerUtils.getmaterialPermSql(ctx, matEntityViewInfo, repStr));
                            hasDataPermission = true;
                        }
                        if (!"warehous_view".equals(permItem)) continue;
                        permMap.put(cuUnit2.getId().toString(), InvServerUtils.getwarePermSql(ctx, matEntityViewInfo, repStr));
                        hasDataPermission = true;
                        continue;
                    }
                    permMap.put(cuUnit2.getId().toString(), " 1 = 1");
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (!hasDataPermission) {
                return null;
            }
        }
        return permMap;
    }

    public static String getwarePermSql(Context ctx, EntityViewInfo entityViewInfo, String repStr) {
        String fsql = null;
        String oriSql = null;
        String finalSql = null;
        MetaDataPK warehousQuery = MetaDataPK.create((String)"com.kingdee.eas.basedata.scm.im.inv.app", (String)"WarehouseQuery");
        try {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)warehousQuery);
            exec.setObjectView(entityViewInfo);
            oriSql = exec.getSQL();
            int posWhere = oriSql.indexOf("WHERE");
            if (posWhere > 0) {
                String toSql = oriSql.substring(posWhere + 5, oriSql.length());
                int posORDER = toSql.indexOf("ORDER");
                if (posORDER > 0) {
                    finalSql = toSql.substring(0, posORDER - 1);
                    fsql = finalSql.replaceAll("\"WAREHOUSE\".", repStr);
                    fsql = fsql + " or " + repStr + "FNumber Is NULL ";
                } else {
                    fsql = toSql.replaceAll("\"WAREHOUSE\".", repStr);
                    fsql = fsql + " or " + repStr + "FNumber Is NULL ";
                }
            }
        }
        catch (BOSException e) {
            return null;
        }
        return fsql;
    }

    public static String getmaterialPermSql(Context ctx, EntityViewInfo entityViewInfo, String repStr) {
        String fsql = null;
        String oriSql = null;
        String finalSql = null;
        MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.material.app", (String)"MaterialQuery");
        try {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
            exec.setObjectView(entityViewInfo);
            oriSql = exec.getSQL();
            int posWhere = oriSql.indexOf("WHERE");
            if (posWhere > 0) {
                String toSql = oriSql.substring(posWhere + 5, oriSql.length());
                int posORDER = toSql.indexOf("ORDER");
                if (posORDER > 0) {
                    finalSql = toSql.substring(0, posORDER - 1);
                    fsql = finalSql.replaceAll("\"MATERIAL\".", repStr);
                } else {
                    fsql = toSql.replaceAll("\"MATERIAL\".", repStr);
                }
            }
        }
        catch (BOSException e) {
            return null;
        }
        return fsql;
    }

    public static String getPermSql(Map matpermMap, String repStr) {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        if (matpermMap != null && matpermMap.size() > 0) {
            String orgid = null;
            String orgMatPerm = null;
            Map.Entry entry = null;
            Iterator iter = matpermMap.entrySet().iterator();
            while (iter.hasNext()) {
                ++count;
                entry = iter.next();
                orgid = (String)entry.getKey();
                orgMatPerm = (String)entry.getValue();
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append(" ( ").append(repStr).append("FStorageOrgUnitID  = '").append(orgid);
                sb.append("' AND ").append(orgMatPerm).append(" )");
            }
        }
        if (sb.length() > 0) {
            sb.append(")");
            return " AND ( " + sb.toString();
        }
        return null;
    }

    public static EntityViewInfo getDataPermissionEntity(Context ctx, String storageOrgID, String PermissionItem) throws Exception {
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPK = null;
        if (storageOrgID != null) {
            orgPK = new ObjectUuidPK(storageOrgID);
        }
        if (orgPK == null) {
            return null;
        }
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String oql = provider.getPermissionRule(userPK, (IObjectPK)orgPK, PermissionItem);
        if (oql == null) {
            return null;
        }
        StringBuffer permision = new StringBuffer();
        permision.append(" select * ");
        permision.append(oql);
        oql = permision.toString();
        EntityViewInfo view = null;
        FilterInfo filter = null;
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            return null;
        }
        if (view.getFilter() != null && view.getFilter().getFilterItems() != null && view.getFilter().getFilterItems().size() > 0) {
            filter = view.getFilter();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filter);
            return entityViewInfo;
        }
        return null;
    }

    public static void checkProjectTrackIsNotNull(Context ctx, boolean isBotp, int rowIdx, MaterialPlanInfo matPlanInfo, ProjectInfo projectNum, TrackNumberInfo trackNum) throws EASBizException, BOSException {
        Object[] msg = new String[2];
        msg[0] = "" + rowIdx;
        if (matPlanInfo != null && matPlanInfo.getStatus() == UsedStatusEnum.APPROVED) {
            if (matPlanInfo.getManufactureStrategy() != null && matPlanInfo.getManufactureStrategy().getId() != null && (matPlanInfo.getManufactureStrategy().getId().toString().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || matPlanInfo.getManufactureStrategy().getId().toString().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) && trackNum == null) {
                throw new SCMBillException(SCMBillException.TRACKNUM_IS_NOT_NULL, msg);
            }
            if (matPlanInfo.getManufactureStrategy() != null && matPlanInfo.getManufactureStrategy().getId() != null && matPlanInfo.getManufactureStrategy().getId().toString().equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                if (matPlanInfo.getIsolatedRule() != null && matPlanInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM && projectNum == null) {
                    throw new SCMBillException(SCMBillException.PROJECTNUM_IS_NOT_NULL, msg);
                }
                if (matPlanInfo.getIsolatedRule() != null && matPlanInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO) {
                    if (trackNum == null && projectNum == null) {
                        throw new SCMBillException(SCMBillException.PROJECTTRACKNUM_IS_NOT_NULL, msg);
                    }
                    if (projectNum == null) {
                        throw new SCMBillException(SCMBillException.PROJECTNUM_IS_NOT_NULL, msg);
                    }
                    if (trackNum == null) {
                        throw new SCMBillException(SCMBillException.TRACKNUM_IS_NOT_NULL, msg);
                    }
                }
            }
        }
    }

    public static Map getMatInventoryInfoCollection(Context ctx, String[] materialIDS, String[] OrgIDs) throws BOSException {
        if (null == materialIDS || null == OrgIDs || materialIDS.length != OrgIDs.length || materialIDS.length == 0) {
            return new HashMap();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashMap<String, MaterialInventoryInfo> inventoryMap = new HashMap<String, MaterialInventoryInfo>();
        String key = "";
        MaterialInventoryInfo materialInventoryInfo = null;
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        if (materialIDS != null && OrgIDs != null) {
            int size = materialIDS.length;
            for (int i = 0; i < size; ++i) {
                if (materialIDS[i] == null || OrgIDs[i] == null) continue;
                filter.appendFilterItem("orgUnit", (Object)OrgIDs[i]);
                filter.appendFilterItem("material", (Object)materialIDS[i]);
                filter.appendFilterItem("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()));
            }
            StringBuffer maskString = new StringBuffer(filter.getFilterItems().size() * 13);
            int size2 = filter.getFilterItems().size();
            for (int i = 0; i < size2; i += 3) {
                maskString.append("(#").append(i).append(" and #").append(i + 1).append(" and #");
                maskString.append(i + 2).append(") or ");
            }
            int length = maskString.length();
            maskString = length > 0 ? maskString.delete(length - 4, length) : maskString;
            filter.setMaskString(maskString.toString());
            viewInfo.setFilter(filter);
            MaterialInventoryCollection coll = iMaterialInventory.getMaterialInventoryCollection(viewInfo);
            if (coll != null) {
                for (int j = 0; j < coll.size(); ++j) {
                    materialInventoryInfo = coll.get(j);
                    if (materialInventoryInfo == null || materialInventoryInfo.getMaterial() == null || materialInventoryInfo.getOrgUnit() == null) continue;
                    key = materialInventoryInfo.getMaterial().getId().toString() + materialInventoryInfo.getOrgUnit().getId().toString();
                    inventoryMap.put(key, materialInventoryInfo);
                }
            }
        }
        return inventoryMap;
    }

    public static EntityViewInfo getStorageOrgIdFilter(String storageOrgid) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)storageOrgid, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        return null;
    }

    private static String getAuthorizedOrgIdsSQL(Context ctx, IObjectPK userPK, String permItemID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String userID = userPK.toString();
        sql.append(" SELECT 1 FROM (SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = '").append(userID).append("' AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(10).append(" UNION ALL ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(10);
        return sql.toString();
    }

    private static String getForbiddenOrgIdsSQL(Context ctx, IObjectPK userPK, String permItemID) throws BOSException, EASBizException {
        String userID = userPK.toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1 FROM  ( SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = '").append(userID).append("' AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(20).append(" UNION ALL ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(20);
        return sql.toString();
    }

    private static IRowSet getBizFlowRelation(Context ctx, Set<String> idSet, String tableName) throws BOSException, EASBizException {
        IRowSet resRow = null;
        if (idSet == null || idSet.size() == 0 || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        StringBuilder querySql = new StringBuilder();
        if (!StringUtils.isEmpty((String)tableName) && SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && idSet.size() > 0) {
            querySql.append(" select ").append(COREBILL_ENTRY_ID_KEY).append(",").append("FBizFlowRelation").append(" from ");
            querySql.append(tableName).append(" where ").append(COREBILL_ENTRY_ID_KEY).append(" in ").append(CommonUtils.getInID(idSet));
            resRow = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        }
        return resRow;
    }

    public static Map<String, String> getBillBizFlowRelation(Context ctx, Set<String> idSet, String tableName) throws EASBizException, BOSException {
        HashMap<String, String> flowMap = new HashMap<String, String>();
        String value = "";
        if (idSet == null || idSet.size() == 0 || StringUtils.isEmpty((String)tableName)) {
            return flowMap;
        }
        IRowSet rs = InvServerUtils.getBizFlowRelation(ctx, idSet, tableName);
        if (rs == null || rs.size() == 0) {
            return flowMap;
        }
        try {
            while (rs.next()) {
                if (StringUtils.isEmpty((String)rs.getString(COREBILL_ENTRY_ID_KEY)) || StringUtils.isEmpty((String)rs.getString("FBizFlowRelation"))) continue;
                value = rs.getString("FBizFlowRelation");
                value = value.substring(0, value.lastIndexOf("#"));
                flowMap.put(rs.getString(COREBILL_ENTRY_ID_KEY), value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return flowMap;
    }

    public static void writeBizFlowRelation(Context ctx, Map<String, String> flowMap, String tableName) throws BOSException {
        if (flowMap == null || flowMap.size() == 0 || StringUtils.isEmpty((String)tableName)) {
            return;
        }
        String key = "";
        StringBuilder sql = new StringBuilder();
        Iterator<String> it = flowMap.keySet().iterator();
        while (it.hasNext()) {
            key = it.next().toString();
            if (StringUtils.isEmpty((String)key) || flowMap.get(key) == null) continue;
            sql.append("update ").append(tableName).append(" set ").append("FBizFlowRelation").append(" = '");
            sql.append(flowMap.get(key).toString()).append("' where fid = '").append(key).append("' ");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static boolean isReturnRIType(Context ctx, TransactionTypeInfo transType) {
        if (transType == null || transType.getRiType() == null || transType.getRiType().getBizDirection() == null) {
            return false;
        }
        int bizDirection = transType.getRiType().getBizDirection().getValue();
        return bizDirection == -1;
    }

    public static Map<String, MultiMeasureUnitInfo> getMultiMeasureUnitMap(Context ctx, InvBillBaseInfo info) throws BOSException {
        IObjectCollection entries = info.getEntries();
        HashSet<String> unitSet = new HashSet<String>();
        HashSet<String> materialSet = new HashSet<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entries.getObject(i);
            if (entryInfo.getUnit() != null) {
                unitSet.add(entryInfo.getUnit().getId().toString());
            }
            if (entryInfo.getBaseUnit() != null) {
                unitSet.add(entryInfo.getBaseUnit().getId().toString());
            }
            if (entryInfo.getAssistUnit() != null) {
                unitSet.add(entryInfo.getAssistUnit().getId().toString());
            }
            if (entryInfo.getMaterial() == null) continue;
            materialSet.add(entryInfo.getMaterial().getId().toString());
        }
        return InvServerUtils.getMultiMeasureUnitMap(ctx, materialSet, unitSet);
    }

    public static Map<String, MultiMeasureUnitInfo> getMultiMeasureUnitMap(Context ctx, Set materialIdSet, Set unitIdSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        MultiMeasureUnitCollection multiMUCol = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        HashMap<String, MultiMeasureUnitInfo> muMap = new HashMap<String, MultiMeasureUnitInfo>();
        int size = multiMUCol.size();
        for (int i = 0; i < size; ++i) {
            muMap.put(multiMUCol.get(i).getMaterial().getId().toString() + multiMUCol.get(i).getMeasureUnit().getId().toString(), multiMUCol.get(i));
        }
        return muMap;
    }

    public static Set getAuthorizedf7Orgs(Context ctx, String permName) {
        OrgViewType[] orgViewTypes = new OrgViewType[]{OrgViewType.STORAGE};
        OrgType orgType = NewOrgViewHelper.convert((OrgViewType)orgViewTypes[0]);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        IObjectPK userPK = ctx.getCaller();
        HashSet<String> orgUnitSet = new HashSet<String>();
        Set fullUnitSet = new HashSet();
        FullOrgUnitCollection unitCol = null;
        try {
            unitCol = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg(userPK, orgType, (IObjectPK)treePK, permName);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return orgUnitSet;
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            orgUnitSet.add(unitCol.get(i).getId().toString());
        }
        fullUnitSet = InvServerUtils.getFullOrgUnit(ctx, orgUnitSet);
        return fullUnitSet;
    }

    public static Set getSelAuthorUnit(Set authorUnitSet, Object[] storageOrgs) {
        HashSet<Object> cuUnitSets = new HashSet<Object>();
        Iterator it = authorUnitSet.iterator();
        FullOrgUnitInfo cuUnit = null;
        OrgUnitInfo selUnit = null;
        String orgId = null;
        block0: while (it.hasNext()) {
            cuUnit = (FullOrgUnitInfo)it.next();
            for (int i = 0; i < storageOrgs.length; ++i) {
                if (storageOrgs[i] instanceof OrgUnitInfo) {
                    selUnit = (OrgUnitInfo)storageOrgs[i];
                    if (!cuUnit.getId().toString().equals(selUnit.getId().toString())) continue;
                    if (selUnit.getCU() == null) {
                        selUnit.setCU(cuUnit.getCU());
                    }
                    cuUnitSets.add(selUnit);
                    continue block0;
                }
                if (!(storageOrgs[i] instanceof String)) continue;
                orgId = (String)storageOrgs[i];
                if (!cuUnit.getId().toString().equals(orgId)) continue;
                cuUnitSets.add(cuUnit);
                continue block0;
            }
        }
        return cuUnitSets;
    }

    public static void deleteSerialNumber(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        String oql = "where billID = '" + pk.toString() + "'";
        MaterialSerialNumberCollection MaterialSerialNumberColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(oql);
        HashSet<ObjectUuidPK> materialSerialNoSet = new HashSet<ObjectUuidPK>();
        if (MaterialSerialNumberColl != null && MaterialSerialNumberColl.size() > 0) {
            int size = MaterialSerialNumberColl.size();
            for (int j = 0; j < size; ++j) {
                MaterialSerialNumberInfo bMaterialSerialNumberInfo = MaterialSerialNumberColl.get(j);
                if (bMaterialSerialNumberInfo == null) continue;
                materialSerialNoSet.add(new ObjectUuidPK(bMaterialSerialNumberInfo.getId()));
            }
        }
        if (materialSerialNoSet.size() > 0) {
            Iterator it = materialSerialNoSet.iterator();
            IObjectPK ipk = null;
            IObjectPK[] ipkArr = new IObjectPK[materialSerialNoSet.size()];
            int index = 0;
            while (it.hasNext()) {
                ipkArr[index] = ipk = (IObjectPK)it.next();
                ++index;
            }
            iMaterialSerialNumber.deleteBatchData(ipkArr);
        }
    }

    public static String generateQuestionMark(int size) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i != size - 1) {
                result.append(" ?, ");
                continue;
            }
            result.append(" ? ");
        }
        return result.toString();
    }
}

