/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.util.SCMMDUtil;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.app.InventoryPageHelper;
import com.kingdee.eas.scm.im.inv.invconfig.SQLDataAccessFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.util.BalanceCfgUtil;
import com.kingdee.eas.scm.util.entity.EntityObjectInfoHelp;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InventoryF7PageHelper
extends InventoryPageHelper {
    protected String billTypeId = null;
    String queryParam = null;
    String storageOrgUnitID = null;
    private List storeTypeList = null;
    private List storeStateList = null;
    boolean isOnload = false;
    private static Map dateFieldsMap = null;

    public InventoryF7PageHelper() {
    }

    public InventoryF7PageHelper(Context ctx) {
        this.ctx = ctx;
    }

    public Map buildTableConfigData(IObjectValue info, IObjectValue entryinfo, String billBosType, String entryBosType, String ttid, String storageOrgUnitID, String entryName) throws Exception {
        this.entryName = entryName;
        if (entryinfo == null) {
            EntityObjectInfo entityEntryObj = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)entryBosType));
            Class entryClass = entityEntryObj.getObjectValueClazzRuntime();
            entryinfo = (IObjectValue)entryClass.newInstance();
        }
        this.getTransactionInvUpdateTypeCol(ttid);
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        this.buildConfigMapping(this.ctx, info, entryinfo, 1);
        this.initFieldSQL();
        this.initDefaultProperty();
        this.initCreateTempTableSQL();
        this.initBalanceModeResouse(new StringBuilder(), new StringBuilder(), new StringBuilder());
        List<Map<String, Object>> fileds = this.buildBalanceModelFilter();
        retValue.put("headColumn", this.fieldSQL.toString().replace(" ", "").split(","));
        retValue.put("takeMapping", this.mapping);
        retValue.put("resMap", this.resMap);
        retValue.put("fileds", fileds);
        return retValue;
    }

    private List<Map<String, Object>> buildBalanceModelFilter() throws Exception {
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>();
        BalanceModelInfo balanceModelInfo = BalanceCfgUtil.getBalanceModelInfo(null);
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        coll.sort("seq");
        int size = coll.size();
        dateFieldsMap = new HashMap();
        for (int i = 0; i < size; ++i) {
            BalanceFieldModelInfo field = coll.get(i);
            HashMap<String, Object> col = new HashMap<String, Object>();
            if ("EntrySeq".equals(field.getName()) || "BillEntryID".equals(field.getName())) continue;
            if (DataTypeEnum.BOSUuid.equals((Object)field.getDataType()) && !StringUtil.isEmpty((String)field.getBaseDataBOSType())) {
                String bosType = field.getBaseDataBOSType();
                EntityObjectInfo entity = SCMMDUtil.getEntityByBosType((String)bosType);
                String defaultF7Query = entity.getExtendedProperty("defaultF7Query");
                col.put("type", "link");
                col.put("filterName", field.getName());
                col.put("promptQuery", defaultF7Query);
                col.put("alias", field.getAlias());
                col.put("value", field.getName() + ".id");
                col.put("displayFormat", field.getDisplayFormat());
                filters.add(col);
                col = new HashMap();
                col.put("type", "String");
                col.put("alias", field.getAlias() + ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"number", null));
                col.put("value", field.getName() + ".fnumber");
                filters.add(col);
                col = new HashMap();
                col.put("type", "String");
                col.put("alias", field.getAlias() + ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"name", null));
                col.put("value", field.getName() + ".fname_" + this.loc);
                filters.add(col);
                if (field.getBaseDataBOSType() == null || !field.getBaseDataBOSType().equals("4409E7F0")) continue;
                col = new HashMap();
                col.put("type", "String");
                col.put("alias", field.getAlias() + ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"model", null));
                col.put("value", field.getName() + ".fmodel");
                filters.add(col);
                continue;
            }
            if (DataTypeEnum.Enum.equals((Object)field.getDataType())) {
                boolean test = false;
                col.put("type", "EnumString");
                List emList = EnumUtils.getEnumList((String)field.getBaseDataBOSType());
                col.put("enumSource", emList);
                col.put("alias", field.getAlias());
                col.put("value", "INVENTORY." + field.getFieldName());
                filters.add(col);
                continue;
            }
            if (DataTypeEnum.Amount.equals((Object)field.getDataType()) || DataTypeEnum.Qty.equals((Object)field.getDataType()) || DataTypeEnum.String.equals((Object)field.getDataType()) || DataTypeEnum.Price.equals((Object)field.getDataType()) || DataTypeEnum.Integer.equals((Object)field.getDataType())) {
                col.put("type", "String");
                col.put("alias", field.getAlias());
                col.put("value", "INVENTORY." + field.getFieldName());
                filters.add(col);
                continue;
            }
            if (DataTypeEnum.Date.equals((Object)field.getDataType())) {
                col.put("type", "Date");
                col.put("alias", field.getAlias());
                col.put("value", "INVENTORY." + field.getFieldName());
                filters.add(col);
                dateFieldsMap.put("INVENTORY." + field.getFieldName(), "TO_CHAR(" + field.getFieldName() + ", 'YYYY-MM-DD HH24:MI:SS')");
                continue;
            }
            if (!DataTypeEnum.Boolean.equals((Object)field.getDataType())) continue;
            col.put("type", "Boolean");
            col.put("alias", field.getAlias());
            col.put("value", "INVENTORY." + field.getFieldName());
            filters.add(col);
        }
        return filters;
    }

    public Map getInventoryF7Data(IObjectValue info, IObjectValue entryinfo, String billBosType, String entryBosType, String ttid, String billTypeID, String entryName, String storageOrgUnitID, String filterItems, String tempTableName, int from, int len) throws Exception {
        this.billTypeId = billTypeID;
        this.entryName = entryName;
        this.storageOrgUnitID = storageOrgUnitID;
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        if (tempTableName == null || "".equals(tempTableName)) {
            if (entryinfo == null) {
                EntityObjectInfo entityEntryObj = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)entryBosType));
                Class entryClass = entityEntryObj.getObjectValueClazzRuntime();
                entryinfo = (IObjectValue)entryClass.newInstance();
            }
            this.buildConfigMapping(this.ctx, info, entryinfo, 1);
            if (!StringUtils.isEmpty((String)ttid)) {
                this.getTransactionInvUpdateTypeCol(ttid);
            }
            String sql = this.getQuerySQL(filterItems, billBosType);
            tempTableName = this.createTempTable(this.fieldSQL.toString(), this.getCreateTempTableSQL(), sql);
            int rowCount = this.getRowCount(tempTableName);
            IRowSet rs = this.executeQuery(tempTableName, from, len);
            retValue.put("headColumn", this.fieldSQL.toString().replace(" ", "").split(","));
            retValue.put("rowCount", rowCount);
            retValue.put("tempTableName", tempTableName);
            retValue.put("rs", rs);
        } else {
            IRowSet rs = this.executeQuery(tempTableName, from, len);
            int rowCount = this.getRowCount(tempTableName);
            retValue.put("rowCount", rowCount);
            this.initFieldSQL();
            retValue.put("headColumn", this.fieldSQL.toString().replace(" ", "").split(","));
            retValue.put("tempTableName", tempTableName);
            retValue.put("rs", rs);
        }
        return retValue;
    }

    private int getRowCount(String tempTableName) throws EASBizException, BOSException, SQLException {
        int rowCount = 0;
        String sql = "select count (id) as count from " + tempTableName;
        try {
            IRowSet rs = SQLDataAccessFacadeFactory.getLocalInstance(this.ctx).executeQuery(sql);
            if (rs.next()) {
                rowCount = rs.getInt("count");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowCount;
    }

    private String createTempTable(String fieldSQL, String createTempTableSQL, String sql) throws EASBizException, BOSException {
        String finalSQL = this.getFinalSQL(sql);
        String tempTableName = SQLDataAccessFacadeFactory.getLocalInstance(this.ctx).createTempTable(createTempTableSQL, finalSQL, fieldSQL, null);
        return tempTableName;
    }

    private IRowSet executeQuery(String tempTableName, int from, int len) throws EASBizException, BOSException {
        StringBuilder querySQL = new StringBuilder();
        querySQL.append("select * from ").append(tempTableName);
        querySQL.append(" ORDER BY ");
        querySQL.append(" WAREHOUSENUMBER ASC, LOCATIONNUMBER ASC, MATERIALNUMBER ASC,FLOT ASC, ID asc ");
        return SQLDataAccessFacadeFactory.getLocalInstance(this.ctx).getRowSet(querySQL.toString(), from, len);
    }

    protected String getQuerySQL(String filterItems, String billBosType) throws Exception {
        this.initDefaultProperty();
        StringBuilder sqlSelect = this.getDefaultSelectSQL();
        StringBuilder sqlFrom = this.getDefaultFromSQL();
        StringBuilder sqlWhere = "A4D04D25".equals(billBosType) ? this.getDefaultWhereSQLForMoveLocation() : this.getDefaultWhereSQL();
        StringBuilder extendFilterSQL = new StringBuilder();
        this.initCreateTempTableSQL();
        this.initFieldSQL();
        this.tableHeadKeyList.clear();
        this.initBalanceModeResouse(sqlSelect, sqlFrom, extendFilterSQL);
        StringBuilder sql = new StringBuilder();
        if (!StringUtil.isEmpty((String)extendFilterSQL.toString())) {
            sqlWhere.append((CharSequence)extendFilterSQL);
        }
        sql.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom).append((CharSequence)sqlWhere);
        filterItems = this.getFilterSQL(filterItems);
        sql.append(filterItems);
        return sql.toString();
    }

    private String getFilterSQL(String sql) {
        String loc = "l2";
        if (SysContext.getSysContext().getLocale() != null) {
            loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        }
        if (sql.length() < 1) {
            return "";
        }
        sql = " and " + sql;
        sql = sql.replaceAll("WHERE", " ");
        sql = sql.replaceAll(".id", ".fid");
        sql = sql.replaceAll("LastUpdateUser", "T19");
        sql = sql.replaceAll("Creator", "T20");
        for (Map.Entry entry : dateFieldsMap.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            sql = sql.replaceAll(key.toString(), val.toString());
        }
        return sql;
    }

    private void handleFilterInfo() {
    }

    private void initBalanceModeResouse(StringBuilder sqlSelect, StringBuilder sqlFrom, StringBuilder extendFilterSQL) throws Exception {
        BalanceFieldModelCollection coll = this.getBalanceFieldModelCollInOrder();
        BalanceFieldModelInfo fieldInfo = null;
        String invField = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.getBizDataType() == BizDataTypeEnum.AssistInfo && !fieldInfo.isIsSPvisible()) continue;
            invField = fieldInfo.getFieldName();
            if (DataTypeEnum.Boolean.equals((Object)fieldInfo.getDataType())) {
                this.boolPropSet.add(invField);
            } else if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                this.linkPropBosTypeMap.put(invField, fieldInfo.getBaseDataBOSType());
            }
            if (this.defaultProperty.contains(invField)) {
                if (invField.equalsIgnoreCase("FMaterialID")) {
                    this.tableHeadKeyList.add(invField);
                    this.tableHeadKeyList.add("MaterialNumber");
                    this.tableHeadKeyList.add("MaterialName");
                    this.tableHeadKeyList.add("MaterialModel");
                    this.tableHeadKeyList.add("MaterialHelpCode");
                    this.resMap.put("MaterialNumber", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"materialNumber", null));
                    this.resMap.put("MaterialName", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"materialName", null));
                    this.resMap.put("MaterialModel", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"materialModel", null));
                    this.resMap.put("MaterialHelpCode", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"MaterialHelpCode", null));
                } else if (invField.equalsIgnoreCase("FLot")) {
                    this.tableHeadKeyList.add(invField);
                    this.tableHeadKeyList.add("Mfg");
                    this.tableHeadKeyList.add("Exp");
                    this.resMap.put(invField, fieldInfo.getAlias());
                    this.resMap.put("Mfg", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"mfg", null));
                    this.resMap.put("Exp", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"exp", null));
                } else {
                    this.tableHeadKeyList.add(invField);
                    String key = invField;
                    if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                        if (fieldInfo.getBaseDataBOSType() == null) {
                            this.tableHeadKeyList.add("id");
                            continue;
                        }
                        key = invField + "pk_hide";
                        this.tableHeadKeyList.add(key);
                    }
                    this.resMap.put(key, fieldInfo.getAlias());
                }
            } else {
                this.tableHeadKeyList.add(invField);
                String tableAlias = "t" + i;
                if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                    sqlSelect.append(", ").append(tableAlias).append(".fname_").append(this.loc).append(" as ").append(invField + "pk_hide").append(" \r\n");
                    sqlSelect.append(", ").append(tableAlias).append(".fid as ").append(invField).append(" \r\n");
                    IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                    IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldInfo.getBaseDataBOSType()));
                    EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                    String linkTable = entityObjInfo.getTable().getName();
                    sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on inventory.").append(invField).append("=").append(tableAlias).append(".fid \r\n");
                    String key = invField + "pk_hide";
                    this.tableHeadKeyList.add(key);
                    this.resMap.put(key, fieldInfo.getAlias());
                    this.createTempTableSQL.append(", ").append(invField + "pk_hide").append(" nvarchar(255)");
                    this.createTempTableSQL.append(", ").append(invField).append(" varchar(44)");
                    this.fieldSQL.append(" , ").append(invField + "pk_hide");
                    this.fieldSQL.append(" , ").append(invField);
                } else if (!"FEntrySeq".equals(invField)) {
                    this.fieldSQL.append(" , ").append(invField);
                    sqlSelect.append(", INVENTORY.").append(invField);
                    this.resMap.put(invField, fieldInfo.getAlias());
                    DataTypeEnum dataType = fieldInfo.getDataType();
                    if (DataTypeEnum.String.equals((Object)dataType)) {
                        this.createTempTableSQL.append(", ").append(invField).append(" nvarchar(255)");
                    } else if (DataTypeEnum.Integer.equals((Object)dataType) || DataTypeEnum.Boolean.equals((Object)dataType) || DataTypeEnum.Enum.equals((Object)dataType)) {
                        this.createTempTableSQL.append(", ").append(invField).append(" int");
                    } else if (DataTypeEnum.Date.equals((Object)dataType)) {
                        this.createTempTableSQL.append(", ").append(invField).append(" datetime");
                    } else if (DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Amount.equals((Object)dataType) || DataTypeEnum.Price.equals((Object)dataType)) {
                        this.createTempTableSQL.append(", ").append(invField).append(" Decimal(28,10) default 0");
                    }
                }
            }
            if (invField.equals("FCustomerID") && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.billTypeId) || invField.equals("FSupplierID") && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(this.billTypeId)) {
                IObjectValue objVal = (IObjectValue)this.propMap.get(invField);
                if (objVal == null) continue;
                this.getSupCustomerWhereSQL(extendFilterSQL, invField, objVal.getString("id").toString());
                continue;
            }
            Object propValue = this.propMap.get(invField);
            String propStr = this.getPropStringValue(propValue);
            if (StringUtil.isEmpty((String)propStr)) continue;
            extendFilterSQL.append(" and inventory.").append(invField);
            if (propValue instanceof Date) {
                extendFilterSQL.append(" = to_date('").append(propStr).append("') ");
                continue;
            }
            extendFilterSQL.append(" = '").append(propStr).append("' ");
        }
        this.tableHeadKeyList.remove("FCompanyOrgUnitID");
        this.tableHeadKeyList.remove("FCompanyOrgUnitIDpk_hide");
        this.tableHeadKeyList.remove("FID");
        this.tableHeadKeyList.remove("FAmount");
        this.tableHeadKeyList.remove("FLockQty");
        this.tableHeadKeyList.remove("FLockBaseQty");
        this.tableHeadKeyList.remove("FLockAssistQty");
        this.resMap.put("boolFieldSet", this.boolPropSet);
        this.tableHeadKeyList.add("FReservationQty");
        this.tableHeadKeyList.add("FReservationBaseQty");
        this.tableHeadKeyList.add("FReservationAssistQty");
        this.resMap.put("FReservationQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationQty", null));
        this.resMap.put("FReservationBaseQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationBaseQty", null));
        this.resMap.put("FReservationAssistQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationAssistQty", null));
        this.resMap.put("FCurStoreQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realQty", null));
        this.resMap.put("FCurStoreAssistQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realAssistQty", null));
        this.resMap.put("FBaseQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realBaseQty", null));
    }

    @Override
    public String getCreateTempTableSQL() {
        return this.createTempTableSQL.toString() + ");";
    }

    @Override
    protected void initCreateTempTableSQL() {
        this.createTempTableSQL = new StringBuilder();
        this.createTempTableSQL.append(" create table temp_table(");
        this.createTempTableSQL.append(" id varchar(44),");
        this.createTempTableSQL.append(" FWarehouseID varchar(44),");
        this.createTempTableSQL.append(" WAREHOUSENUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FWarehouseIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FLocationID varchar(44),");
        this.createTempTableSQL.append(" LOCATIONNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FLocationIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FStoreTypeID varchar(44),");
        this.createTempTableSQL.append(" STORETYPENUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FStoreTypeIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FCurStoreQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FBaseQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FAssistUnitID varchar(44),");
        this.createTempTableSQL.append(" ASSISTUNITNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FAssistUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FCurStoreAssistQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FLOT nvarchar(80),");
        this.createTempTableSQL.append(" FCustomerID varchar(44),");
        this.createTempTableSQL.append(" FCustomerIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" CUSTOMERNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FSupplierID varchar(44),");
        this.createTempTableSQL.append(" SUPPLIERNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FSupplierIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FStorageOrgUnitID varchar(44),");
        this.createTempTableSQL.append(" STORAGEORGUNITNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FStorageOrgUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FAssistPropertyIDpk_hide nvarchar(2000),");
        this.createTempTableSQL.append(" FStoreStatusID varchar(44),");
        this.createTempTableSQL.append(" STORESTATUSNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FStoreStatusIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" MULTIASSISTUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" FAssistPropertyID varchar(44),");
        this.createTempTableSQL.append(" ASSISTPROPERTYTYPE nvarchar(2000),");
        this.createTempTableSQL.append(" ASSISTPROPERTYNUMBER nvarchar(510),");
        this.createTempTableSQL.append(" FReservationBaseQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FReservationQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FReservationAssistQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" COMPANYORGUNITID varchar(44),");
        this.createTempTableSQL.append(" FProjectID varchar(44),");
        this.createTempTableSQL.append(" FProjectIDpk_hide nvarchar(80),");
        this.createTempTableSQL.append(" FTrackNumberID varchar(44),");
        this.createTempTableSQL.append(" FTrackNumberIDpk_hide nvarchar(80),");
        this.createTempTableSQL.append(" MaterialModel nvarchar(255),");
        this.createTempTableSQL.append(" MaterialName nvarchar(255),");
        this.createTempTableSQL.append(" MaterialNumber nvarchar(80),");
        this.createTempTableSQL.append(" MaterialHelpCode nvarchar(80),");
        this.createTempTableSQL.append(" MaterialGroupID nvarchar(44),");
        this.createTempTableSQL.append(" FMaterialID varchar(44),");
        this.createTempTableSQL.append(" FUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" UNITNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FUnitID varchar(44),");
        this.createTempTableSQL.append(" FBaseUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" BBASEUNITNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FBaseUnitID varchar(44),");
        this.createTempTableSQL.append(" MULTIUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" MULTIBASEUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" PRICEPRECISION int,");
        this.createTempTableSQL.append(" INVENTORYUNITNAME nvarchar(255),");
        this.createTempTableSQL.append(" MULTIINVENTORYUNITQTYPRECIS54 int,");
        this.createTempTableSQL.append(" MFG nvarchar(80),");
        this.createTempTableSQL.append(" EXP nvarchar(80)");
    }

    @Override
    public String getFieldSQL() {
        return this.fieldSQL.toString();
    }

    @Override
    protected void initFieldSQL() {
        this.fieldSQL = new StringBuilder();
        this.fieldSQL.append(" MaterialNumber, ");
        this.fieldSQL.append(" MaterialName, ");
        this.fieldSQL.append(" FMaterialID, ");
        this.fieldSQL.append(" PricePrecision, ");
        this.fieldSQL.append(" MaterialModel, ");
        this.fieldSQL.append(" MaterialGroupID, ");
        this.fieldSQL.append(" MaterialHelpCode, ");
        this.fieldSQL.append(" FLot, ");
        this.fieldSQL.append(" Mfg, ");
        this.fieldSQL.append(" Exp, ");
        this.fieldSQL.append(" FUnitIDpk_hide, ");
        this.fieldSQL.append(" UNITNUMBER, ");
        this.fieldSQL.append(" FUnitID, ");
        this.fieldSQL.append(" FCurStoreQty, ");
        this.fieldSQL.append(" FBaseUnitIDpk_hide, ");
        this.fieldSQL.append(" BBASEUNITNUMBER, ");
        this.fieldSQL.append(" FBaseUnitID, ");
        this.fieldSQL.append(" FBaseQty, ");
        this.fieldSQL.append(" FAssistUnitID, ");
        this.fieldSQL.append(" ASSISTUNITNUMBER, ");
        this.fieldSQL.append(" FAssistUnitIDpk_hide, ");
        this.fieldSQL.append(" FCurStoreAssistQty, ");
        this.fieldSQL.append(" FAssistPropertyIDpk_hide, ");
        this.fieldSQL.append(" FAssistPropertyID, ");
        this.fieldSQL.append(" ASSISTPROPERTYTYPE, ");
        this.fieldSQL.append(" ASSISTPROPERTYNUMBER, ");
        this.fieldSQL.append(" FWarehouseID, ");
        this.fieldSQL.append(" WAREHOUSENUMBER, ");
        this.fieldSQL.append(" FWarehouseIDpk_hide, ");
        this.fieldSQL.append(" FLocationID, ");
        this.fieldSQL.append(" LOCATIONNUMBER, ");
        this.fieldSQL.append(" FLocationIDpk_hide, ");
        this.fieldSQL.append(" FProjectID, ");
        this.fieldSQL.append(" FProjectIDpk_hide, ");
        this.fieldSQL.append(" FTrackNumberID, ");
        this.fieldSQL.append(" FTrackNumberIDpk_hide, ");
        this.fieldSQL.append(" FStoreTypeID, ");
        this.fieldSQL.append(" STORETYPENUMBER, ");
        this.fieldSQL.append(" FStoreTypeIDpk_hide, ");
        this.fieldSQL.append(" FStoreStatusID, ");
        this.fieldSQL.append(" STORESTATUSNUMBER, ");
        this.fieldSQL.append(" FStoreStatusIDpk_hide, ");
        this.fieldSQL.append(" FCustomerID, ");
        this.fieldSQL.append(" FCustomerIDpk_hide, ");
        this.fieldSQL.append(" CUSTOMERNUMBER, ");
        this.fieldSQL.append(" FSupplierID, ");
        this.fieldSQL.append(" SUPPLIERNUMBER, ");
        this.fieldSQL.append(" FSupplierIDpk_hide, ");
        this.fieldSQL.append(" FStorageOrgUnitID, ");
        this.fieldSQL.append(" STORAGEORGUNITNUMBER, ");
        this.fieldSQL.append(" FStorageOrgUnitIDpk_hide, ");
        this.fieldSQL.append(" id, ");
        this.fieldSQL.append(" MULTIASSISTUNITQTYPRECISION, ");
        this.fieldSQL.append(" FReservationBaseQty, ");
        this.fieldSQL.append(" FReservationQty, ");
        this.fieldSQL.append(" FReservationAssistQty, ");
        this.fieldSQL.append(" COMPANYORGUNITID, ");
        this.fieldSQL.append(" MULTIBASEUNITQTYPRECISION, ");
        this.fieldSQL.append(" MULTIUNITQTYPRECISION, ");
        this.fieldSQL.append(" INVENTORYUNITNAME, ");
        this.fieldSQL.append(" MULTIINVENTORYUNITQTYPRECIS54");
    }

    @Override
    protected StringBuilder getDefaultSelectSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT ");
        sb.append(" MATERIAL.FNumber AS MaterialNumber,    \r\n");
        sb.append(" MATERIAL.FName_").append(this.loc).append(" AS MaterialName,    \r\n");
        sb.append(" INVENTORY.FMaterialID AS FMaterialID,    \r\n");
        sb.append(" MATERIAL.FPricePrecision AS FPricePrecision,    \r\n");
        sb.append(" MATERIAL.FModel AS MaterialModel,   \r\n");
        sb.append(" MATERIAL.FMaterialGroupID AS MaterialGroupID,   \r\n");
        sb.append(" MATERIAL.FHELPCODE AS MaterialHelpCode,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE INVENTORY.FLot END AS FLot,  \r\n");
        sb.append(" to_char(DATEOFMINDURABILITY.FMfg,'yyyy-mm-dd') AS Mfg,     \r\n");
        sb.append(" to_char(DATEOFMINDURABILITY.FExp,'yyyy-mm-dd') AS Exp,   \r\n");
        sb.append(" UNIT.FName_").append(this.loc).append(" AS FUnitIDpk_hide,    \r\n");
        sb.append(" UNIT.FNumber AS UNITNUMBER,    \r\n");
        sb.append(" INVENTORY.FUnitID AS FUnitID,     \r\n");
        sb.append(" round(ISNULL(INVENTORY.FCurStoreQty, 0) ");
        sb.append(" - ");
        sb.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0),ISNULL(MULTIUNIT.FQtyPrecision,8)) ");
        sb.append(" AS FCurStoreQty,  \r\n");
        sb.append(" BBASEUNIT.FName_").append(this.loc).append(" AS FBaseUnitIDpk_hide,     \r\n");
        sb.append(" BBASEUNIT.FNumber AS BBASEUNITNUMBER,    \r\n");
        sb.append(" INVENTORY.FBaseUnitID AS FBaseUnitID,     \r\n");
        sb.append(" round(ISNULL(INVENTORY.FBaseQty, 0) - ISNULL(RESERVATION.FReservationBaseQty, 0),ISNULL(MULTIBASEUNIT.FQtyPrecision,8)) AS FBaseQty,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FAssistUnitID = '").append("EgkAAAA5EWFbglxX").append("' THEN NULL ELSE INVENTORY.FAssistUnitID END AS FAssistUnitID,   \r\n");
        sb.append(" ASSISTUNIT.FNumber AS ASSISTUNITNUMBER,   \r\n");
        sb.append(" ASSISTUNIT.FName_").append(this.loc).append(" AS FAssistUnitIDpk_hide,   \r\n");
        sb.append(" round(ISNULL(INVENTORY.FCurStoreAssistQty, 0) - ISNULL(RESERVATION.FReservationAssistQty, 0),ISNULL(MULTIASSISTUNIT.FQtyPrecision,8)) AS FCurStoreAssistQty,   \r\n");
        sb.append(" ASSISTPROPERTY.FName_").append(this.loc).append(" AS FAssistPropertyIDpk_hide,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' THEN NULL ELSE INVENTORY.FAssistPropertyID END AS FAssistPropertyID,    \r\n");
        sb.append(" ASSISTPROPERTY.FType AS ASSISTPROPERTYTYPE,   \r\n");
        sb.append(" ASSISTPROPERTY.FNumber AS ASSISTPROPERTYNUMBER,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' THEN NULL ELSE INVENTORY.FWarehouseID END AS FWarehouseID,  \r\n");
        sb.append(" WAREHOUSE.FNumber AS WAREHOUSENUMBER,  \r\n");
        sb.append(" WAREHOUSE.FName_").append(this.loc).append(" AS FWarehouseIDpk_hide,  \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' THEN NULL ELSE INVENTORY.FLocationID END AS FLocationID,  \r\n");
        sb.append(" LOCATION.FNumber AS LOCATIONNUMBER,  \r\n");
        sb.append(" LOCATION.FName_").append(this.loc).append(" AS FLocationIDpk_hide,  \r\n");
        sb.append(" CASE  WHEN INVENTORY.FProjectID = '").append("EgkAAABc3Xza3gXu").append("' THEN NULL ELSE INVENTORY.FProjectID END AS FProjectID,   \r\n");
        sb.append(" PROJECT.FNumber AS FProjectIDpk_hide,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' THEN NULL ELSE INVENTORY.FTrackNumberID END AS FTrackNumberID,   \r\n");
        sb.append(" TRACKNUMBER.FNumber AS FTrackNumberIDpk_hide,    \r\n");
        sb.append(" INVENTORY.FStoreTypeID AS FStoreTypeID,  \r\n");
        sb.append(" STORETYPE.FNumber AS STORETYPENUMBER,  \r\n");
        sb.append(" STORETYPE.FName_").append(this.loc).append(" AS FStoreTypeIDpk_hide,  \r\n");
        sb.append(" INVENTORY.FStoreStatusID AS FStoreStatusID,  \r\n");
        sb.append(" STORESTATUS.FNumber AS STORESTATUSNUMBER,   \r\n");
        sb.append(" STORESTATUS.FName_").append(this.loc).append(" AS FStoreStatusIDpk_hide,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' THEN NULL ELSE INVENTORY.FCustomerID END AS FCustomerID,   \r\n");
        sb.append(" CUSTOMER.FName_").append(this.loc).append(" AS FCustomerIDpk_hide,  \r\n");
        sb.append(" CUSTOMER.FNumber AS CUSTOMERNUMBER,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' THEN NULL ELSE INVENTORY.FSupplierID END AS FSupplierID,   \r\n");
        sb.append(" SUPPLIER.FNumber AS SUPPLIERNUMBER,   \r\n");
        sb.append(" SUPPLIER.FName_").append(this.loc).append(" AS FSupplierIDpk_hide,   \r\n");
        sb.append(" INVENTORY.FStorageOrgUnitID AS FStorageOrgUnitID,  \r\n");
        sb.append(" STORAGEORGUNIT.FNumber AS STORAGEORGNUMBER,  \r\n");
        sb.append(" STORAGEORGUNIT.FName_").append(this.loc).append(" AS FStorageOrgUnitIDpk_hide,  \r\n");
        sb.append(" INVENTORY.FID AS id, \r\n");
        sb.append(" MULTIASSISTUNIT.FQtyPrecision AS MULTIASSISTUNITQTYPRECISION,    \r\n");
        sb.append(" ISNULL(RESERVATION.FReservationBaseQty,0) AS FReservationBaseQty,    \r\n");
        sb.append(" ISNULL(RESERVATION.FReservationQty, 0) AS FReservationQty,   \r\n");
        sb.append(" ISNULL(RESERVATION.FReservationAssistQty, 0) AS FReservationAssistQty,   \r\n");
        sb.append(" INVENTORY.FCompanyOrgUnitID AS COMPANYORGUNITID,    \r\n");
        sb.append(" MULTIBASEUNIT.FQtyPrecision AS MULTIBASEUNITQTYPRECISION,     \r\n");
        sb.append(" MULTIUNIT.FQtyPrecision AS MULTIUNITQTYPRECISION,    \r\n");
        sb.append(" INVENTORYUNIT.FName_").append(this.loc).append(" AS INVENTORYUNITNAME,     \r\n");
        sb.append(" MULTIINVENTORYUNIT.FQtyPrecision AS MULTIINVENTORYUNITQTYPRECIS54 ");
        return sb;
    }

    @Override
    protected StringBuilder getDefaultFromSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM T_IM_Inventory AS INVENTORY \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON INVENTORY.FCustomerID = CUSTOMER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON INVENTORY.FSupplierID = SUPPLIER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATUS ON INVENTORY.FStoreStatusID = STORESTATUS.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON INVENTORY.FStoreTypeID = STORETYPE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON INVENTORY.FLocationID = LOCATION.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT ON INVENTORY.FStorageOrgUnitID = STORAGEORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON INVENTORY.FMaterialID = MATERIAL.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON INVENTORY.FUnitID = UNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS BBASEUNIT ON INVENTORY.FBaseUnitID = BBASEUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON INVENTORY.FAssistUnitID = ASSISTUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON INVENTORY.FMaterialID = MULTIBASEUNIT.FMaterialID AND INVENTORY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSISTUNIT ON INVENTORY.FMaterialID = MULTIASSISTUNIT.FMaterialID AND INVENTORY.FAssistUnitID = MULTIASSISTUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON INVENTORY.FAssistPropertyID = ASSISTPROPERTY.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ON INVENTORY.FCompanyOrgUnitID = COMPANYORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON INVENTORY.FProjectID = PROJECT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON INVENTORY.FTrackNumberID = TRACKNUMBER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialInventory AS MATINVENTORY ON INVENTORY.FStorageOrgUnitID = MATINVENTORY.FOrgUnit AND INVENTORY.FMaterialID = MATINVENTORY.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON INVENTORY.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND INVENTORY.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND INVENTORY.FLot = DATEOFMINDURABILITY.FLot \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS INVENTORYUNIT ON MATINVENTORY.FUnitID = INVENTORYUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIINVENTORYUNIT ON MATINVENTORY.FMaterialID = MULTIINVENTORYUNIT.FMaterialID AND MATINVENTORY.FUnitID = MULTIINVENTORYUNIT.FMeasureUnitID \r\n");
        sb.append((CharSequence)this.getReservationSQL());
        return sb;
    }

    @Override
    protected StringBuilder getDefaultWhereSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE STORAGEORGUNIT.fid in " + this.storageOrgUnitID);
        sb.append(" and ((INVENTORY.FBaseQty - ISNULL(RESERVATION.FReservationBaseQty, 0)) <> 0) ");
        String tempStoreType = null;
        String tempstoreState = null;
        if (this.storeTypeList != null && !this.storeTypeList.isEmpty()) {
            sb.append(" and (");
            for (int i = 0; i < this.storeTypeList.size(); ++i) {
                tempstoreState = this.storeStateList.get(i).toString();
                tempStoreType = this.storeTypeList.get(i).toString();
                if (i > 0) {
                    sb.append(" or ");
                }
                sb.append(" STORETYPE.fid ='").append(tempStoreType).append("' and ");
                sb.append(" STORESTATUS.fid =  '").append(tempstoreState).append("' ");
            }
            sb.append(")");
        }
        return sb;
    }

    protected StringBuilder getDefaultWhereSQLForMoveLocation() {
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE STORAGEORGUNIT.fid in" + this.storageOrgUnitID);
        sb.append(" and ((INVENTORY.FBaseQty - ISNULL(RESERVATION.FReservationBaseQty, 0)) <> 0) ");
        String tempStoreType = null;
        String tempstoreState = null;
        if (this.storeTypeList != null && !this.storeTypeList.isEmpty()) {
            sb.append(" and (");
            for (int i = 0; i < this.storeTypeList.size(); ++i) {
                tempstoreState = this.storeStateList.get(i).toString();
                tempStoreType = this.storeTypeList.get(i).toString();
                if (i > 0) {
                    sb.append(" or ");
                }
                sb.append(" STORETYPE.fid ='").append(tempStoreType).append("' and ");
                sb.append(" STORESTATUS.fid =  '").append(tempstoreState).append("' ");
            }
            sb.append(")");
        }
        sb.append("  and inventory.FLocationID <> 'EgkAAABc3XMgX/hq'");
        return sb;
    }

    private void getSupCustomerWhereSQL(StringBuilder sb, String invField, String objValueID) {
        if (invField.equals("FCustomerID")) {
            sb.append(" AND ((STORETYPE.FStoreFlag = 3 OR STORETYPE.FStoreFlag = 4) AND ");
            sb.append(" INVENTORY.FCustomerID = '").append(objValueID).append("' ");
            sb.append(" OR (STORETYPE.FStoreFlag <> 3 AND STORETYPE.FStoreFlag <> 4)) ");
        } else if (invField.equals("FSupplierID")) {
            sb.append(" AND ((STORETYPE.FStoreFlag = 2 OR STORETYPE.FStoreFlag = 5) AND ");
            sb.append(" INVENTORY.FSupplierID = '").append(objValueID).append("' ");
            sb.append(" OR (STORETYPE.FStoreFlag <> 2 AND STORETYPE.FStoreFlag <> 5)) ");
        }
    }

    @Override
    protected StringBuilder getDefaultOrderBySQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ORDER BY WAREHOUSE.NUMBER ASC, LOCATION.NUMBER ASC, MATERIAL.NUMBER ASC");
        return sb;
    }

    private String getFinalSQL(String sql) {
        String filterSQL = this.getFilterSQL();
        StringBuilder resultSQL = new StringBuilder(sql);
        if (filterSQL != null && filterSQL.length() > 0) {
            resultSQL.append(" and ").append(filterSQL);
        }
        resultSQL.append(" ORDER BY WAREHOUSE.FNUMBER ASC, LOCATION.FNUMBER ASC, MATERIAL.FNUMBER ASC ");
        return resultSQL.toString();
    }

    private String getFilterSQL() {
        StringBuffer sb = new StringBuffer();
        if (this.queryParam != null && this.queryParam.length() > 0) {
            sb.append("  (MATERIAL.fnumber like '%" + this.queryParam + "%'  or MATERIAL.FhelpCode  ").append(" LIKE '%" + this.queryParam + "%'    ");
            sb.append(" or  MATERIAL.fname_").append(this.loc).append(" LIKE '%" + this.queryParam + "%'  ");
            sb.append(" or WAREHOUSE.fnumber like '%" + this.queryParam + "%' or  WAREHOUSE.fname_").append(this.loc);
            sb.append("  LIKE '%" + this.queryParam + "%' ");
            sb.append(" or INVENTORY.flot  LIKE '%" + this.queryParam + "%'  ");
            sb.append(" or ASSISTPROPERTY.fnumber like '%" + this.queryParam + "%' or  ASSISTPROPERTY.fname_").append(this.loc);
            sb.append("  LIKE '%" + this.queryParam + "%' )   ");
        }
        return sb.toString();
    }

    private void getTransactionInvUpdateTypeCol(String ttif) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.id", (Object)ttif, CompareType.EQUALS));
        view.setFilter(filterInfo);
        TransactionInvUpdateTypeCollection coll = InvCommonUtils.getTransactionInvUpdateTypeCol(null, view);
        InvUpdateTypeInfo updateTypeInfo = null;
        this.storeStateList = new ArrayList();
        this.storeTypeList = new ArrayList();
        for (int i = 0; i < coll.size(); ++i) {
            updateTypeInfo = coll.get(i).getInvUpdateType();
            if (updateTypeInfo.getStoreState() != null) {
                this.storeStateList.add(updateTypeInfo.getStoreState().getId().toString());
            }
            if (updateTypeInfo.getStoreStatePre() != null) {
                this.storeStateList.add(updateTypeInfo.getStoreStatePre().getId().toString());
            }
            if (updateTypeInfo.getStoreType() != null) {
                this.storeTypeList.add(updateTypeInfo.getStoreType().getId().toString());
            }
            if (updateTypeInfo.getStoreTypePre() == null) continue;
            this.storeTypeList.add(updateTypeInfo.getStoreTypePre().getId().toString());
        }
    }
}

