/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.InvInitTransAccountException;
import com.kingdee.eas.scm.im.inv.app.AbstractInventoryInitCheckAccountControllerBean;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processorbuilder.InvInitChkAccountBusinessProcessorBuilder;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryInitCheckAccountControllerBean
extends AbstractInventoryInitCheckAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.InventoryInitCheckAccountControllerBean");
    private static final String Material = "material";
    private static final String StorageOrg = "storeageOrg";
    private static final String CompanyOrg = "companyOrg";

    protected String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    @Override
    protected Vector _getAccountBalance(Context ctx, String accountID, String companyOrgUnitID) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyOrgUnitID)));
        CurrencyInfo currencyInfo = company.getBaseCurrency();
        if (!SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company)) {
            return this.getInitAccountBalance(ctx, accountID, companyOrgUnitID);
        }
        IRowSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        ObjectUuidPK companyPK = new ObjectUuidPK(BOSUuid.read((String)companyOrgUnitID));
        int periodNumber = 0;
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)companyPK);
        if (periodInfo == null) {
            return null;
        }
        periodNumber = periodInfo.getNumber();
        Vector<Object> rsV = new Vector<Object>();
        try {
            sqlBuff.append(" select T1.FAccountId as FAccountID,\r\n");
            sqlBuff.append("( isnull(T1.FYearDebitLocal,0.0) - isnull(T1.FDebitLocal,0.0) ) as FYearDebitLocal,\r\n");
            sqlBuff.append(" (isnull(T1.FYearCreditLocal,0.0) - isnull(T1.FCreditLocal,0.0)) as FYearCreditLocal,\r\n");
            sqlBuff.append(" (isnull(T1.FBeginBalanceLocal,0.0)) as FBeginBalanceLocal\r\n");
            sqlBuff.append(" from  t_gl_accountbalance_1l T1\r\n");
            sqlBuff.append("WHERE ");
            sqlBuff.append("T1.FPeriod = ? AND ");
            sqlBuff.append("T1.FAccountID = ? AND ");
            sqlBuff.append("T1.FOrgUnitID = ? ");
            Object[] params = new Object[]{periodNumber, accountID, companyOrgUnitID};
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params);
            if (rs.next()) {
                rsV.add(rs.getString(1));
                rsV.add(rs.getBigDecimal(2));
                rsV.add(rs.getBigDecimal(3));
                rsV.add(rs.getBigDecimal(4));
                return rsV;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected List _getInventoryMaterialAccount(Context ctx, String companyOrgUnitID) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        ArrayList rtnList = new ArrayList();
        try {
            sqlBuff.append("SELECT ");
            sqlBuff.append("ISNULL(F.FID,X.FID) AS FID,");
            sqlBuff.append("ISNULL(F.FNumber,X.FNumber) AS FNumber,");
            sqlBuff.append("ISNULL(F.FName_" + this.getLoc(ctx) + ",X.FName_" + this.getLoc(ctx) + ") AS FName_" + this.getLoc(ctx) + ",");
            sqlBuff.append("ISNULL(SUM(A.FYearReceiptAmount),0.0) AS FYearReceiptAmount,");
            sqlBuff.append("ISNULL(SUM(A.FYearIssueAmount),0.0) AS FYearIssueAmount,");
            sqlBuff.append("ISNULL(SUM(A.FAmount),0.0) AS FAmount ");
            sqlBuff.append("FROM ");
            sqlBuff.append(" T_IM_InventoryInitBill A0\r\n");
            sqlBuff.append(" inner join T_IM_InventoryInitEntry A on  A0.FID = A.FParentID \r\n");
            sqlBuff.append(" inner join T_DB_SOAccreditWH B on  A.FWarehouseID = B.FWarehouseID AND A.FStorageOrgUnitID = B.FStorageOrgID and  A.FCompanyOrgUnitID = B.FCompanyID\r\n");
            sqlBuff.append(" left join T_BD_AccountView F on A.FaccountViewId = F.FID\r\n");
            sqlBuff.append(" inner join T_BD_MaterialCompanyInfo C on A.FCompanyOrgUnitID = C.FCompanyID and A.FMaterialID = C.FMaterialID \r\n");
            sqlBuff.append(" left join T_BD_KAClassificationDetail D on C.FKAClassID = D.FKaclassficlink and exists(select 1 from T_BD_KAccountItem E where E.FNumber = '1001' and e.fid =  D.FAccountitemlinkID ) \r\n");
            sqlBuff.append(" left join T_BD_AccountView X on D.FAccountlinkID = X.FID \r\n");
            sqlBuff.append(" \r\n");
            sqlBuff.append("WHERE ");
            sqlBuff.append("B.FIsStarted = 0 ");
            sqlBuff.append("AND A0.FBaseStatus = " + BillBaseStatusEnum.AUDITED.getValue() + " ");
            sqlBuff.append("AND A.FCompanyOrgUnitID = '" + companyOrgUnitID + "' ");
            sqlBuff.append("GROUP BY  ");
            sqlBuff.append("ISNULL(F.FID,X.FID),");
            sqlBuff.append("ISNULL(F.FNumber,X.FNumber),");
            sqlBuff.append("ISNULL(F.FName_" + this.getLoc(ctx) + ",X.FName_" + this.getLoc(ctx) + ") ");
            String sqlStr = sqlBuff.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            while (rs.next()) {
                Vector<Object> rsV = new Vector<Object>();
                rsV.add(rs.getString(1));
                rsV.add(rs.getString(2));
                rsV.add(rs.getString(3));
                rsV.add(rs.getBigDecimal(4));
                rsV.add(rs.getBigDecimal(5));
                rsV.add(rs.getBigDecimal(6));
                rtnList.add(rsV);
            }
            return rtnList;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected List _getInventoryDiffAccount(Context ctx, String companyOrgUnitID) throws BOSException {
        IRowSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        ArrayList rtnList = new ArrayList();
        try {
            sqlBuff.append("SELECT ");
            sqlBuff.append("F.FID AS FID,");
            sqlBuff.append("F.FNumber AS FNumber,");
            sqlBuff.append("F.FName_" + this.getLoc(ctx) + " AS FName_" + this.getLoc(ctx) + ",");
            sqlBuff.append("ISNULL(SUM(A.FYearReceiptCostDiff),0.0) AS FYearReceiptCostDiff,");
            sqlBuff.append("ISNULL(SUM(A.FYearIssueCostDiff),0.0) AS FYearIssueCostDiff,");
            sqlBuff.append("ISNULL(SUM(A.FDiffAmount),0.0) AS FDiffAmount ");
            sqlBuff.append("FROM ");
            sqlBuff.append("T_IM_InventoryInitBill A0,");
            sqlBuff.append("T_IM_InventoryInitEntry A,");
            sqlBuff.append("T_DB_SOAccreditWH B,");
            sqlBuff.append("T_BD_MaterialCompanyInfo C,");
            sqlBuff.append("T_BD_KAClassificationDetail D,");
            sqlBuff.append("T_BD_KAccountItem E,");
            sqlBuff.append("T_BD_AccountView F ");
            sqlBuff.append("WHERE ");
            sqlBuff.append("A0.FID = A.FParentID ");
            sqlBuff.append("AND A.FWarehouseID = B.FWarehouseID ");
            sqlBuff.append("AND A.FStorageOrgUnitID = B.FStorageOrgID ");
            sqlBuff.append("AND A.FCompanyOrgUnitID = B.FCompanyID ");
            sqlBuff.append("AND A.FMaterialID = C.FMaterialID ");
            sqlBuff.append("AND A.FCompanyOrgUnitID = C.FCompanyID ");
            sqlBuff.append("AND C.FKAClassID = D.FKaclassficlink ");
            sqlBuff.append("AND D.FAccountitemlinkID = E.FID ");
            sqlBuff.append("AND D.FAccountlinkID = F.FID ");
            sqlBuff.append("AND E.FNumber = '1005' ");
            sqlBuff.append("AND B.FIsStarted = 0 ");
            sqlBuff.append("AND A0.FBaseStatus = " + BillBaseStatusEnum.AUDITED.getValue() + " ");
            sqlBuff.append("AND A.FCompanyOrgUnitID = '" + companyOrgUnitID + "' ");
            sqlBuff.append("GROUP BY  ");
            sqlBuff.append("F.FID,");
            sqlBuff.append("F.FNumber,");
            sqlBuff.append("F.FName_" + this.getLoc(ctx) + " ");
            String sqlStr = sqlBuff.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            while (rs.next()) {
                Vector<Object> rsV = new Vector<Object>();
                rsV.add(rs.getString(1));
                rsV.add(rs.getString(2));
                rsV.add(rs.getString(3));
                rsV.add(rs.getBigDecimal(4));
                rsV.add(rs.getBigDecimal(5));
                rsV.add(rs.getBigDecimal(6));
                rtnList.add(rsV);
            }
            return rtnList;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected List _getInitAccount(Context ctx, String companyOrgUnitID) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        ArrayList<AccountViewInfo> rtnList = new ArrayList<AccountViewInfo>();
        IAccountView iActView = AccountViewFactory.getLocalInstance((Context)ctx);
        try {
            sqlBuff.append("SELECT ");
            sqlBuff.append("F.FID AS FID ");
            sqlBuff.append("FROM ");
            sqlBuff.append("T_IM_InventoryInitBill A0,");
            sqlBuff.append("T_IM_InventoryInitEntry A,");
            sqlBuff.append("T_DB_SOAccreditWH B,");
            sqlBuff.append("T_BD_MaterialCompanyInfo C,");
            sqlBuff.append("T_BD_KAClassificationDetail D,");
            sqlBuff.append("T_BD_KAccountItem E,");
            sqlBuff.append("T_BD_AccountView F ");
            sqlBuff.append("WHERE ");
            sqlBuff.append("A0.FID = A.FParentID ");
            sqlBuff.append("AND A.FWarehouseID = B.FWarehouseID ");
            sqlBuff.append("AND A.FStorageOrgUnitID = B.FStorageOrgID ");
            sqlBuff.append("AND A.FCompanyOrgUnitID = B.FCompanyID ");
            sqlBuff.append("AND A.FMaterialID = C.FMaterialID ");
            sqlBuff.append("AND A.FCompanyOrgUnitID = C.FCompanyID ");
            sqlBuff.append("AND C.FKAClassID = D.FKaclassficlink ");
            sqlBuff.append("AND D.FAccountitemlinkID = E.FID ");
            sqlBuff.append("AND D.FAccountlinkID = F.FID ");
            sqlBuff.append("AND (E.FNumber = '1001' OR E.FNumber = '1005')");
            sqlBuff.append("AND B.FIsStarted = 0 ");
            sqlBuff.append("AND A0.FBaseStatus = " + BillBaseStatusEnum.AUDITED.getValue() + " ");
            sqlBuff.append("AND A.FCompanyOrgUnitID = ? ");
            sqlBuff.append("GROUP BY  ");
            sqlBuff.append("E.FNumber,");
            sqlBuff.append("F.FID ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])new Object[]{companyOrgUnitID});
            while (rs.next()) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("CAA.*");
                sic.add("CAA.asstActGpDt.asstActType.*");
                AccountViewInfo actViewInfo = iActView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rs.getString("FID"))), sic);
                rtnList.add(actViewInfo);
            }
            return rtnList;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected void _transferAccount(Context ctx, String companyOrgUnitID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo comOrgUnitInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.checkSystemStatus(ctx, comOrgUnitInfo);
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.putData("companyOrgUnitID", (Object)companyOrgUnitID);
        applicationContext.putData("selectAcctSql", (Object)this.getSelectAcctSql(this.getLoc(ctx)));
        applicationContext.putData("selectMaterialAsstSql", (Object)this.getSelectAsstSql(Material, this.getLoc(ctx)));
        applicationContext.putData("selectStorageOrgAsstSql", (Object)this.getSelectAsstSql(StorageOrg, this.getLoc(ctx)));
        BatchActionResults batchResults = BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{companyOrgUnitID}, (BatchActionEnum)InvInitChkAccountBusinessProcessorBuilder.TRANSFER_ACCOUNT, InvInitChkAccountBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
    }

    public AssistantHGInfo constructAssistInfo(Context ctx, AssistantHGInfo assGrp, String bookId, AsstActTypeCollection items) throws BOSException, EASBizException {
        IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        AssistantHGInfo assistHGInfo = iAssistantHG.getAssistantHG(assGrp, bookId, items);
        return assistHGInfo;
    }

    public String getSelectAcctSql(String lm) {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("SELECT ");
        sqlBuff.append("E.FNumber AS DFNumber,");
        sqlBuff.append("F.FID AS FID,");
        sqlBuff.append("F.FNumber AS FNumber,");
        sqlBuff.append("F.FName_" + lm + " AS FName_" + lm + ",");
        sqlBuff.append("ISNULL(SUM(A.FYearReceiptAmount),0.0) AS FYearReceiptAmount,");
        sqlBuff.append("ISNULL(SUM(A.FYearIssueAmount),0.0) AS FYearIssueAmount,");
        sqlBuff.append("ISNULL(SUM(A.FAmount),0.0) AS FAmount,");
        sqlBuff.append("ISNULL(SUM(A.FYearReceiptCostDiff),0.0) AS FYearReceiptCostDiff,");
        sqlBuff.append("ISNULL(SUM(A.FYearIssueCostDiff),0.0) AS FYearIssueCostDiff,");
        sqlBuff.append("ISNULL(SUM(A.FDiffAmount),0.0) AS FDiffAmount ");
        sqlBuff.append("FROM ");
        sqlBuff.append("T_IM_InventoryInitBill A0,");
        sqlBuff.append("T_IM_InventoryInitEntry A,");
        sqlBuff.append("T_DB_SOAccreditWH B,");
        sqlBuff.append("T_BD_MaterialCompanyInfo C,");
        sqlBuff.append("T_BD_KAClassificationDetail D,");
        sqlBuff.append("T_BD_KAccountItem E,");
        sqlBuff.append("T_BD_AccountView F ");
        sqlBuff.append("WHERE ");
        sqlBuff.append("A0.FID = A.FParentID ");
        sqlBuff.append("AND A.FWarehouseID = B.FWarehouseID ");
        sqlBuff.append("AND A.FStorageOrgUnitID = B.FStorageOrgID ");
        sqlBuff.append("AND A.FCompanyOrgUnitID = B.FCompanyID ");
        sqlBuff.append("AND A.FMaterialID = C.FMaterialID ");
        sqlBuff.append("AND A.FCompanyOrgUnitID = C.FCompanyID ");
        sqlBuff.append("AND C.FKAClassID = D.FKaclassficlink ");
        sqlBuff.append("AND D.FAccountitemlinkID = E.FID ");
        sqlBuff.append("AND D.FAccountlinkID = F.FID ");
        sqlBuff.append("AND (E.FNumber = '1001' OR E.FNumber = '1005')");
        sqlBuff.append("AND B.FIsStarted = 0 ");
        sqlBuff.append("AND A0.FBaseStatus = " + BillBaseStatusEnum.AUDITED.getValue() + " ");
        sqlBuff.append("AND A.FCompanyOrgUnitID = ? ");
        sqlBuff.append("GROUP BY  ");
        sqlBuff.append("E.FNumber,");
        sqlBuff.append("F.FID,");
        sqlBuff.append("F.FNumber,");
        sqlBuff.append("F.FName_" + lm + "  ");
        return sqlBuff.toString();
    }

    public String getSelectAsstSql(String attributeName, String lm) {
        if (attributeName == null) {
            attributeName = "";
        }
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("SELECT ");
        if (attributeName.equals(Material)) {
            sqlBuff.append("A.FMaterialID AS FMaterialID,");
        } else if (attributeName.equals(StorageOrg)) {
            sqlBuff.append("A.FStorageOrgUnitID AS FStorageOrgUnitID,");
        }
        sqlBuff.append("E.FNumber AS DFNumber,");
        sqlBuff.append("F.FID AS FID,");
        sqlBuff.append("F.FNumber AS FNumber,");
        sqlBuff.append("F.FName_" + lm + " AS FName_" + lm + ",");
        sqlBuff.append("ISNULL(SUM(A.FYearReceiptAmount),0.0) AS FYearReceiptAmount,");
        sqlBuff.append("ISNULL(SUM(A.FYearIssueAmount),0.0) AS FYearIssueAmount,");
        sqlBuff.append("ISNULL(SUM(A.FAmount),0.0) AS FAmount,");
        sqlBuff.append("ISNULL(SUM(A.FYearReceiptCostDiff),0.0) AS FYearReceiptCostDiff,");
        sqlBuff.append("ISNULL(SUM(A.FYearIssueCostDiff),0.0) AS FYearIssueCostDiff,");
        sqlBuff.append("ISNULL(SUM(A.FDiffAmount),0.0) AS FDiffAmount ");
        sqlBuff.append("FROM ");
        sqlBuff.append("T_IM_InventoryInitBill A0,");
        sqlBuff.append("T_IM_InventoryInitEntry A,");
        sqlBuff.append("T_DB_SOAccreditWH B,");
        sqlBuff.append("T_BD_MaterialCompanyInfo C,");
        sqlBuff.append("T_BD_KAClassificationDetail D,");
        sqlBuff.append("T_BD_KAccountItem E,");
        sqlBuff.append("T_BD_AccountView F ");
        sqlBuff.append("WHERE ");
        sqlBuff.append("A0.FID = A.FParentID ");
        sqlBuff.append("AND A.FWarehouseID = B.FWarehouseID ");
        sqlBuff.append("AND A.FStorageOrgUnitID = B.FStorageOrgID ");
        sqlBuff.append("AND A.FCompanyOrgUnitID = B.FCompanyID ");
        sqlBuff.append("AND A.FMaterialID = C.FMaterialID ");
        sqlBuff.append("AND A.FCompanyOrgUnitID = C.FCompanyID ");
        sqlBuff.append("AND C.FKAClassID = D.FKaclassficlink ");
        sqlBuff.append("AND D.FAccountitemlinkID = E.FID ");
        sqlBuff.append("AND D.FAccountlinkID = F.FID ");
        sqlBuff.append("AND (E.FNumber = '1001' OR E.FNumber = '1005')");
        sqlBuff.append("AND B.FIsStarted = 0 ");
        sqlBuff.append("AND A0.FBaseStatus = " + BillBaseStatusEnum.AUDITED.getValue() + " ");
        sqlBuff.append("AND A.FCompanyOrgUnitID = ? ");
        sqlBuff.append("AND F.FID = ? ");
        sqlBuff.append("GROUP BY  ");
        if (attributeName.equals(Material)) {
            sqlBuff.append("A.FMaterialID,");
        } else if (attributeName.equals(StorageOrg)) {
            sqlBuff.append("A.FStorageOrgUnitID,");
        }
        sqlBuff.append("E.FNumber,");
        sqlBuff.append("F.FID,");
        sqlBuff.append("F.FNumber,");
        sqlBuff.append("F.FName_" + lm + " ");
        return sqlBuff.toString();
    }

    private Vector getInitAccountBalance(Context ctx, String accountID, String companyOrgUnit) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        ObjectUuidPK companyPK = new ObjectUuidPK(BOSUuid.read((String)companyOrgUnit));
        CompanyOrgUnitInfo comOrgUnitInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CurrencyInfo currencyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getBaseCurrency();
        String periodID = null;
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (IObjectPK)companyPK);
        if (periodInfo == null) {
            return null;
        }
        periodID = periodInfo.getId().toString();
        Vector<Object> rsV = new Vector<Object>();
        try {
            sqlBuff.append("SELECT ");
            sqlBuff.append("A.FAccountID AS FAccountID,");
            sqlBuff.append("ISNULL(A.FYearDebitLocal,0.0) AS FYearDebitLocal,");
            sqlBuff.append("ISNULL(A.FYearCreditLocal,0.0) AS FYearCreditLocal,");
            sqlBuff.append("ISNULL(A.FBeginBalanceLocal,0.0) AS FBeginBalanceLocal ");
            sqlBuff.append("FROM ");
            sqlBuff.append("T_GL_InitAccountBalance A ");
            sqlBuff.append("WHERE ");
            sqlBuff.append("A.FAccountID = ? AND ");
            sqlBuff.append("A.FOrgUnitID = ? AND ");
            sqlBuff.append("A.FCurrencyID = ?");
            Object[] params = new Object[]{accountID, companyOrgUnit, "11111111-1111-1111-1111-111111111111DEB58FDC"};
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params);
            if (rs.next()) {
                rsV.add(rs.getString(1));
                rsV.add(rs.getBigDecimal(2));
                rsV.add(rs.getBigDecimal(3));
                rsV.add(rs.getBigDecimal(4));
                return rsV;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    public void checkSystemStatus(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        SystemStatusCtrolUtils sysStatusCtrl = new SystemStatusCtrolUtils();
        if (SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company)) {
            throw new InvInitTransAccountException(InvInitTransAccountException.ACCOUNTHASSTART);
        }
        if (!SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company)) {
            throw new InvInitTransAccountException(InvInitTransAccountException.INVENTORYNOTRELACCOUNT);
        }
        if (!sysStatusCtrl.isEqualsCurPeriodAndRelPeriod(ctx, company.getId().toString(), SystemEnum.INVENTORYMANAGEMENT)) {
            throw new InvInitTransAccountException(InvInitTransAccountException.INVENTORYSTARTNOTEQUALACCOUNT);
        }
    }
}

