/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.CommonBalanceFilterPanel;
import com.kingdee.eas.scm.im.inv.invconfig.BillInvConfigFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.util.BalanceCfgUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class InventoryPageHelper {
    protected String loc = "l2";
    protected static final String resClassName = "com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource";
    protected Map<String, Object> resMap = new HashMap<String, Object>();
    protected List<String> tableHeadKeyList = new ArrayList<String>();
    protected Map<String, String> mapping = null;
    protected Map<String, Object> propMap = null;
    protected Set<String> defaultProperty = null;
    protected String entryName = null;
    protected String transactionTypeID = null;
    protected Set<String> boolPropSet = new HashSet<String>();
    protected StringBuilder createTempTableSQL = null;
    protected StringBuilder fieldSQL = null;
    private static Map<String, BillInventoryConfigInfo> configMap = new HashMap<String, BillInventoryConfigInfo>();
    protected Map<String, String> linkPropBosTypeMap = new HashMap<String, String>();
    protected Context ctx = null;
    protected Map<String, String> fieldTypeMap = new HashMap<String, String>();

    public InventoryPageHelper() {
        this.initLoc();
    }

    private void initLoc() {
        if (SysContext.getSysContext().getLocale() != null) {
            this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        }
    }

    protected String getQuerySQL() throws Exception {
        this.initDefaultProperty();
        BalanceFieldModelCollection balanceFieldModelCol = this.getBalanceFieldModelCollInOrder();
        String invField = null;
        String tableAlias = null;
        String linkTable = null;
        StringBuilder sqlSelect = this.getDefaultSelectSQL();
        StringBuilder sqlFrom = this.getDefaultFromSQL();
        StringBuilder sqlWhere = this.getDefaultWhereSQL();
        this.initCreateTempTableSQL();
        this.initFieldSQL();
        BalanceFieldModelInfo fieldModeInfo = null;
        this.tableHeadKeyList.clear();
        int size = balanceFieldModelCol.size();
        for (int i = 0; i < size; ++i) {
            fieldModeInfo = balanceFieldModelCol.get(i);
            if (fieldModeInfo.getBizDataType() == BizDataTypeEnum.AssistInfo && !fieldModeInfo.isIsSPvisible()) continue;
            invField = fieldModeInfo.getFieldName();
            this.fieldTypeMap.put(invField, fieldModeInfo.getDataType().getValue());
            if (DataTypeEnum.Boolean.equals((Object)fieldModeInfo.getDataType())) {
                this.boolPropSet.add(invField);
            }
            if (this.defaultProperty.contains(invField)) {
                if (invField.equalsIgnoreCase("FMaterialID")) {
                    this.tableHeadKeyList.add("MaterialNumber");
                    this.tableHeadKeyList.add("MaterialName");
                    this.tableHeadKeyList.add("MaterialModel");
                    this.resMap.put("MaterialNumber", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"materialNumber", null));
                    this.resMap.put("MaterialName", fieldModeInfo.getAlias());
                    this.resMap.put("MaterialModel", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"materialModel", null));
                    continue;
                }
                if (invField.equalsIgnoreCase("FLot")) {
                    this.tableHeadKeyList.add(invField);
                    this.tableHeadKeyList.add("Mfg");
                    this.tableHeadKeyList.add("Exp");
                    this.resMap.put(invField, fieldModeInfo.getAlias());
                    this.resMap.put("Mfg", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"mfg", null));
                    this.resMap.put("Exp", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"exp", null));
                    continue;
                }
                String key = invField;
                if (DataTypeEnum.BOSUuid.equals((Object)fieldModeInfo.getDataType())) {
                    if (fieldModeInfo.getBaseDataBOSType() == null) {
                        this.tableHeadKeyList.add("id");
                        continue;
                    }
                    key = invField + "pk_hide";
                }
                this.tableHeadKeyList.add(key);
                this.resMap.put(key, fieldModeInfo.getAlias());
                continue;
            }
            tableAlias = "t" + i;
            if (DataTypeEnum.BOSUuid.equals((Object)fieldModeInfo.getDataType())) {
                sqlSelect.append(", ").append(tableAlias).append(".fname_").append(this.loc).append(" as ").append(invField + "pk_hide").append(" \r\n");
                sqlSelect.append(", ").append(tableAlias).append(".fid as ").append(invField).append(" \r\n");
                IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldModeInfo.getBaseDataBOSType()));
                EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                linkTable = entityObjInfo.getTable().getName();
                sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on inventory.").append(invField).append("=").append(tableAlias).append(".fid \r\n");
                String key = invField + "pk_hide";
                this.tableHeadKeyList.add(invField);
                this.tableHeadKeyList.add(key);
                this.resMap.put(key, fieldModeInfo.getAlias());
                this.createTempTableSQL.append(", ").append(invField + "pk_hide").append(" nvarchar(255)");
                this.createTempTableSQL.append(", ").append(invField).append(" varchar(44)");
                this.fieldSQL.append(" , ").append(invField + "pk_hide");
                this.fieldSQL.append(" , ").append(invField);
                continue;
            }
            sqlSelect.append(", INVENTORY.").append(invField).append(" as ").append(invField);
            this.tableHeadKeyList.add(invField);
            this.resMap.put(invField, fieldModeInfo.getAlias());
            DataTypeEnum dataType = fieldModeInfo.getDataType();
            if (DataTypeEnum.String.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" nvarchar(255)");
            } else if (DataTypeEnum.Integer.equals((Object)dataType) || DataTypeEnum.Boolean.equals((Object)dataType) || DataTypeEnum.Enum.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" int");
            } else if (DataTypeEnum.Date.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" datetime");
            } else if (DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Amount.equals((Object)dataType) || DataTypeEnum.Price.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" Decimal(28,10) default 0");
            }
            this.fieldSQL.append(" , ").append(invField);
        }
        this.tableHeadKeyList.remove("FCompanyOrgUnitID");
        this.tableHeadKeyList.remove("FCompanyOrgUnitIDpk_hide");
        this.tableHeadKeyList.remove("FAmount");
        this.tableHeadKeyList.remove("FID");
        this.tableHeadKeyList.add("FStorageOrgUnitID");
        this.tableHeadKeyList.add("FStoreTypeID");
        this.tableHeadKeyList.add("FStoreStatusID");
        this.tableHeadKeyList.add("multiUnitbaseConvsRate");
        this.tableHeadKeyList.add("multiUnitqtyPrecision");
        this.tableHeadKeyList.add("multiBaseUnitqtyPrecision");
        this.tableHeadKeyList.add("multiAssitUnitqtyPrecision");
        this.tableHeadKeyList.add("FReservationQty");
        this.tableHeadKeyList.add("FReservationBaseQty");
        this.tableHeadKeyList.add("FReservationAssistQty");
        int index = this.tableHeadKeyList.indexOf("FCurStoreQty");
        this.tableHeadKeyList.add(index + 1, "FRealQty");
        this.tableHeadKeyList.add(index + 4, "FRealBaseQty");
        this.tableHeadKeyList.add(index + 7, "FRealAssistQty");
        index = this.tableHeadKeyList.indexOf("FCurStoreQty");
        this.tableHeadKeyList.add(index + 2, "INVENTORYUNITNAME");
        this.tableHeadKeyList.add(index + 3, "CURMATSTOREQTY");
        this.resMap.put("FReservationQty", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"reservationQty", null));
        this.resMap.put("FReservationBaseQty", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"reservationBaseQty", null));
        this.resMap.put("FReservationAssistQty", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"reservationAssistQty", null));
        this.resMap.put("FRealQty", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"realQty", null));
        this.resMap.put("FRealAssistQty", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"realAssistQty", null));
        this.resMap.put("FRealBaseQty", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"realBaseQty", null));
        this.resMap.put("INVENTORYUNITNAME", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"inventoryUnit", null));
        this.resMap.put("CURMATSTOREQTY", ResourceUtil.getMessage((Context)this.ctx, (String)resClassName, (String)"inventoryQty", null));
        StringBuilder sql = new StringBuilder();
        sql.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom).append((CharSequence)sqlWhere);
        return sql.toString();
    }

    public String getCreateTempTableSQL() {
        return this.createTempTableSQL.toString() + ");";
    }

    protected void initCreateTempTableSQL() {
        this.createTempTableSQL = new StringBuilder();
        this.createTempTableSQL.append(" create table temp_table(");
        this.createTempTableSQL.append(" MaterialName nvarchar(255),");
        this.createTempTableSQL.append(" MaterialNumber nvarchar(80),");
        this.createTempTableSQL.append(" FStorageOrgUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" MaterialModel nvarchar(255),");
        this.createTempTableSQL.append(" FMaterialID varchar(44),");
        this.createTempTableSQL.append(" FWarehouseID varchar(44),");
        this.createTempTableSQL.append(" STORAGEORGUNITNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FAssistPropertyIDpk_hide nvarchar(2000),");
        this.createTempTableSQL.append(" FLOT nvarchar(80),");
        this.createTempTableSQL.append(" FUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FBaseUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FBaseQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FRealBaseQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FCurStoreQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FRealQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FCurStoreAssistQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FRealAssistQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" ID varchar(44),");
        this.createTempTableSQL.append(" FSupplierIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FCustomerIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FStoreStatusIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FStoreTypeIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FWarehouseIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FLocationIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FProjectIDpk_hide nvarchar(80),");
        this.createTempTableSQL.append(" FTrackNumberIDpk_hide nvarchar(80),");
        this.createTempTableSQL.append(" MULTIUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" MULTIBASEUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" MULTIASSISTUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" COMPANYORGUNITNAME nvarchar(255),");
        this.createTempTableSQL.append(" FAssistUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FStorageOrgUnitID varchar(44),");
        this.createTempTableSQL.append(" FReservationQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FReservationBaseQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FReservationAssistQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" INVENTORYUNITNAME nvarchar(255),");
        this.createTempTableSQL.append(" CURMATSTOREQTY Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" MULTIINVENTORYUNITQTYPRECIS32 int,");
        this.createTempTableSQL.append(" MULTIBASEUNITBASECONVSRATE Decimal(28,10) not null default 1,");
        this.createTempTableSQL.append(" FStoreTypeID varchar(44),");
        this.createTempTableSQL.append(" FStoreStatusID varchar(44),");
        this.createTempTableSQL.append(" MULTIUNITBASECONVSRATE Decimal(28,10) not null default 1,");
        this.createTempTableSQL.append(" MULTIASSITUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" MFG datetime,");
        this.createTempTableSQL.append(" EXP datetime");
    }

    public String getFieldSQL() {
        return this.fieldSQL.toString();
    }

    protected void initFieldSQL() {
        this.fieldSQL = new StringBuilder();
        this.fieldSQL.append(" MaterialNumber, ");
        this.fieldSQL.append(" MaterialName, ");
        this.fieldSQL.append(" MaterialModel, ");
        this.fieldSQL.append(" FMaterialID, ");
        this.fieldSQL.append(" FWarehouseID, ");
        this.fieldSQL.append(" FStorageOrgUnitIDpk_hide, ");
        this.fieldSQL.append(" STORAGEORGUNITNUMBER, ");
        this.fieldSQL.append(" FAssistPropertyIDpk_hide, ");
        this.fieldSQL.append(" FLot, ");
        this.fieldSQL.append(" FUnitIDpk_hide, ");
        this.fieldSQL.append(" FBaseUnitIDpk_hide, ");
        this.fieldSQL.append(" FBaseQty, ");
        this.fieldSQL.append(" FCurStoreQty, ");
        this.fieldSQL.append(" FCurStoreAssistQty, ");
        this.fieldSQL.append(" FRealBaseQty, ");
        this.fieldSQL.append(" FRealQty, ");
        this.fieldSQL.append(" FRealAssistQty, ");
        this.fieldSQL.append(" ID, ");
        this.fieldSQL.append(" FSupplierIDpk_hide, ");
        this.fieldSQL.append(" FCustomerIDpk_hide\t, ");
        this.fieldSQL.append(" FStoreStatusIDpk_hide, ");
        this.fieldSQL.append(" FStoreTypeIDpk_hide, ");
        this.fieldSQL.append(" FWarehouseIDpk_hide, ");
        this.fieldSQL.append(" FLocationIDpk_hide, ");
        this.fieldSQL.append(" FProjectIDpk_hide, ");
        this.fieldSQL.append(" FTrackNumberIDpk_hide, ");
        this.fieldSQL.append(" MULTIUNITQTYPRECISION, ");
        this.fieldSQL.append(" MULTIBASEUNITQTYPRECISION, ");
        this.fieldSQL.append(" MULTIASSISTUNITQTYPRECISION, ");
        this.fieldSQL.append(" COMPANYORGUNITNAME, ");
        this.fieldSQL.append(" FAssistUnitIDpk_hide, ");
        this.fieldSQL.append(" FStorageOrgUnitID, ");
        this.fieldSQL.append(" FReservationQty, ");
        this.fieldSQL.append(" FReservationBaseQty, ");
        this.fieldSQL.append(" FReservationAssistQty, ");
        this.fieldSQL.append(" INVENTORYUNITNAME, ");
        this.fieldSQL.append(" CURMATSTOREQTY, ");
        this.fieldSQL.append(" MULTIINVENTORYUNITQTYPRECIS32, ");
        this.fieldSQL.append(" MULTIBASEUNITBASECONVSRATE, ");
        this.fieldSQL.append(" FStoreTypeID, ");
        this.fieldSQL.append(" FStoreStatusID, ");
        this.fieldSQL.append(" MULTIUNITBASECONVSRATE, ");
        this.fieldSQL.append(" MULTIASSITUNITQTYPRECISION, ");
        this.fieldSQL.append(" Mfg, ");
        this.fieldSQL.append(" Exp ");
    }

    protected StringBuilder getDefaultSelectSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT MATERIAL.FName_").append(this.loc).append(" AS MaterialName, \r\n");
        sb.append(" MATERIAL.FNumber AS MaterialNumber, \r\n");
        sb.append(" MATERIAL.FModel AS MaterialModel, \r\n");
        sb.append(" INVENTORY.FMaterialID AS FMaterialID, \r\n");
        sb.append(" INVENTORY.FWarehouseID AS FWarehouseID, \r\n");
        sb.append(" STORAGEORGUNIT.FName_").append(this.loc).append(" AS FStorageOrgUnitIDpk_hide, \r\n");
        sb.append(" STORAGEORGUNIT.FNumber AS STORAGEORGUNITNUMBER,  \r\n");
        sb.append(" ASSISTPROPERTY.FName_").append(this.loc).append(" AS FAssistPropertyIDpk_hide, \r\n");
        sb.append(" CASE WHEN INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE INVENTORY.FLot END AS FLOT, \r\n");
        sb.append(" UNIT.FName_").append(this.loc).append(" AS FUnitIDpk_hide, \r\n");
        sb.append(" BASEUNIT.FName_").append(this.loc).append(" AS FBaseUnitIDpk_hide,  \r\n");
        sb.append(" ISNULL(INVENTORY.FBaseQty, 0) AS FBaseQty,  \r\n");
        sb.append(" ISNULL(INVENTORY.FCurStoreQty, 0) AS FCurStoreQty,  \r\n");
        sb.append(" ISNULL(INVENTORY.FCurStoreAssistQty, 0) AS FCurStoreAssistQty,  \r\n");
        sb.append(" ISNULL(INVENTORY.FBaseQty, 0) - ISNULL(RESERVATION.FReservationBaseQty, 0) AS FRealBaseQty,  \r\n");
        sb.append(" ISNULL(INVENTORY.FCurStoreQty, 0) ");
        sb.append(" - ");
        sb.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0) ");
        sb.append(" AS FRealQty,  \r\n");
        sb.append(" ISNULL(INVENTORY.FCurStoreAssistQty, 0) - ISNULL(RESERVATION.FReservationAssistQty, 0) AS FRealAssistQty,  \r\n");
        sb.append(" INVENTORY.FID AS ID,  \r\n");
        sb.append(" SUPPLIER.FName_").append(this.loc).append(" AS FSupplierIDpk_hide,  \r\n");
        sb.append(" CUSTOMER.FName_").append(this.loc).append(" AS FCustomerIDpk_hide,  \r\n");
        sb.append(" STORESTATUS.FName_").append(this.loc).append(" AS FStoreStatusIDpk_hide,  \r\n");
        sb.append(" STORETYPE.FName_").append(this.loc).append(" AS FStoreTypeIDpk_hide, \r\n");
        sb.append(" WAREHOUSE.FName_").append(this.loc).append(" AS FWarehouseIDpk_hide, \r\n");
        sb.append(" LOCATION.FName_").append(this.loc).append(" AS FLocationIDpk_hide,  \r\n");
        sb.append(" PROJECT.FNumber AS FProjectIDpk_hide,  \r\n");
        sb.append(" TRACKNUMBER.FNumber AS FTrackNumberIDpk_hide,  \r\n");
        sb.append(" MULTIUNIT.FQtyPrecision AS MULTIUNITQTYPRECISION,  \r\n");
        sb.append(" MULTIBASEUNIT.FQtyPrecision AS MULTIBASEUNITQTYPRECISION,  \r\n");
        sb.append(" MULTIASSITUNIT.FQtyPrecision AS MULTIASSISTUNITQTYPRECISION,  \r\n");
        sb.append(" COMPANYORGUNIT.FName_").append(this.loc).append(" AS COMPANYORGUNITNAME, \r\n");
        sb.append(" ASSISTUNIT.FName_").append(this.loc).append(" AS FAssistUnitIDpk_hide,  \r\n");
        sb.append(" INVENTORY.FStorageOrgUnitID AS FStorageOrgUnitID,  \r\n");
        sb.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0) AS FReservationQty, \r\n");
        sb.append(" ISNULL(RESERVATION.FReservationBaseQty,0) AS FReservationBaseQty,  \r\n");
        sb.append(" ISNULL(RESERVATION.FReservationAssistQty,0) AS FReservationAssistQty, \r\n");
        sb.append(" INVENTORYUNIT.FName_").append(this.loc).append(" AS INVENTORYUNITNAME, \r\n");
        sb.append(" ISNULL(ROUND(DECIMAL((INVENTORY.FBaseQty / MULTIINVENTORYUNIT.FBaseConvsRate), 21, 8), MULTIINVENTORYUNIT.FQtyPrecision), 0) AS CURMATSTOREQTY, \r\n");
        sb.append(" MULTIINVENTORYUNIT.FQtyPrecision AS MULTIINVENTORYUNITQTYPRECIS32,  \r\n");
        sb.append(" ISNULL(MULTIBASEUNIT.FBaseConvsRate, 1) AS MULTIBASEUNITBASECONVSRATE,  \r\n");
        sb.append(" INVENTORY.FStoreTypeID AS FStoreTypeID,  \r\n");
        sb.append(" INVENTORY.FStoreStatusID AS FStoreStatusID, \r\n");
        sb.append(" ISNULL(MULTIUNIT.FBaseConvsRate, 1) AS MULTIUNITBASECONVSRATE,  \r\n");
        sb.append(" MULTIASSITUNIT.FQtyPrecision AS MULTIASSITUNITQTYPRECISION,  \r\n");
        sb.append(" DATEOFMINDURABILITY.FMfg AS MFG,  \r\n");
        sb.append(" DATEOFMINDURABILITY.FExp AS EXP  \r\n");
        return sb;
    }

    protected StringBuilder getDefaultFromSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM T_IM_Inventory AS INVENTORY \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON INVENTORY.FSupplierID = SUPPLIER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATUS ON INVENTORY.FStoreStatusID = STORESTATUS.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON INVENTORY.FStoreTypeID = STORETYPE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON INVENTORY.FLocationID = LOCATION.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT ON INVENTORY.FStorageOrgUnitID = STORAGEORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ON INVENTORY.FCompanyOrgUnitID = COMPANYORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON INVENTORY.FMaterialID = MATERIAL.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON INVENTORY.FUnitID = UNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON INVENTORY.FAssistUnitID = ASSISTUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON INVENTORY.FCustomerID = CUSTOMER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON INVENTORY.FMaterialID = MULTIBASEUNIT.FMaterialID AND INVENTORY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSITUNIT ON INVENTORY.FMaterialID = MULTIASSITUNIT.FMaterialID AND INVENTORY.FAssistUnitID = MULTIASSITUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON INVENTORY.FAssistPropertyID = ASSISTPROPERTY.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS BASEUNIT ON INVENTORY.FBaseUnitID = BASEUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialCost AS MATERIALCOST ON INVENTORY.FCompanyOrgUnitID = MATERIALCOST.FOrgUnit AND INVENTORY.FMaterialID = MATERIALCOST.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON INVENTORY.FTrackNumberID = TRACKNUMBER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON INVENTORY.FProjectID = PROJECT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialInventory AS MATERIALINVENTORY ON INVENTORY.FStorageOrgUnitID = MATERIALINVENTORY.FOrgUnit AND INVENTORY.FMaterialID = MATERIALINVENTORY.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON INVENTORY.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND INVENTORY.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND INVENTORY.FLot = DATEOFMINDURABILITY.FLot \r\n");
        sb.append(" INNER JOIN T_BD_MaterialGroupDetial AS MATERIALGROUPDETAILS ON INVENTORY.FMaterialID = MATERIALGROUPDETAILS.FMaterialID \r\n");
        sb.append(" INNER JOIN T_BD_MaterialGroup AS MATERIALGROUP ON MATERIALGROUPDETAILS.FMaterialGroupID = MATERIALGROUP.FID \r\n");
        sb.append(" INNER JOIN T_BD_MaterialGroupStandard AS GROUPSTANDARD ON MATERIALGROUP.FGroupStandard = GROUPSTANDARD.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS INVENTORYUNIT ON MATERIALINVENTORY.FUnitID = INVENTORYUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIINVENTORYUNIT ON MATERIALINVENTORY.FMaterialID = MULTIINVENTORYUNIT.FMaterialID AND MATERIALINVENTORY.FUnitID = MULTIINVENTORYUNIT.FMeasureUnitID \r\n");
        sb.append(" ");
        sb.append((CharSequence)this.getReservationSQL());
        return sb;
    }

    protected StringBuilder getDefaultWhereSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE ((INVENTORY.FBaseQty <> 0) OR (INVENTORY.FCurStoreQty <> 0) OR (INVENTORY.FCurStoreAssistQty <> 0)) \r\n");
        return sb;
    }

    protected StringBuilder getDefaultOrderBySQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ORDER BY INVENTORY.FMaterialID ASC, ");
        sb.append(" STORAGEORGUNIT.FID ASC, ");
        sb.append(" CASE WHEN INVENTORY.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' THEN NULL ELSE INVENTORY.FWarehouseID END ASC \r\n");
        return sb;
    }

    protected StringBuilder getSupCustomerWhereSQL(StringBuilder sup, StringBuilder cust, IObjectValue billEntryInfo) {
        StringBuilder sb = new StringBuilder();
        if (sup.length() == 0 && cust.length() == 0 || billEntryInfo.get("invUpdateType") == null || this.mapping.get("FStoreTypeID") == null) {
            return sb;
        }
        String storeType = this.mapping.get("FStoreTypeID");
        String[] str = storeType.split("\\.");
        StoreTypeInfo storeTypeInfo = (StoreTypeInfo)billEntryInfo.getObjectValue("invUpdateType").getObjectValue(str[2]);
        if (storeTypeInfo == null) {
            return sb;
        }
        if (StoreFlagEnum.SUPPLIER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOSUPPLIER.equals((Object)storeTypeInfo.getStoreFlag())) {
            sb.append((CharSequence)sup);
        }
        if (StoreFlagEnum.CUSTOMER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOCUSTOMER.equals((Object)storeTypeInfo.getStoreFlag())) {
            sb.append((CharSequence)cust);
        }
        return sb;
    }

    protected StringBuilder getReservationSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append(" LEFT OUTER JOIN (");
        sql.append(" SELECT FInventoryID, ");
        sql.append(" ISNULL(SUM(FReservationQty), 0) AS FReservationQty, ").append(" ISNULL(SUM(FReservationBaseQty), 0) AS FReservationBaseQty, ").append(" ISNULL(SUM(FReservationAssistQty), 0) AS FReservationAssistQty ");
        sql.append(" FROM T_IM_Reservation ");
        sql.append(" GROUP BY FInventoryID) AS RESERVATION ");
        sql.append(" ON RESERVATION.FInventoryID = INVENTORY.FID \r\n");
        return sql;
    }

    protected void initDefaultProperty() {
        String[] fields = new String[]{"FID", "FCompanyOrgUnitID", "FStorageOrgUnitID", "FWarehouseID", "FLocationID", "FStoreTypeID", "FStoreStatusID", "FSupplierID", "FCustomerID", "FMaterialID", "FLot", "FProjectID", "FTrackNumberID", "FUnitID", "FCurStoreQty", "FAssistUnitID", "FCurStoreAssistQty", "FBaseQty", "FAmount", "FBaseUnitID", "FExp", "FAssistPropertyID"};
        this.defaultProperty = new HashSet<String>(Arrays.asList(fields));
    }

    protected boolean isInvUpdateType() {
        String storeType = this.mapping.get("FStoreTypeID");
        String storeState = this.mapping.get("FStoreStatusID");
        if (storeType != null && storeType.indexOf("invUpdateType") > -1) {
            return true;
        }
        return storeState != null && storeState.indexOf("invUpdateType") > -1;
    }

    public void setInvUpdateType(IObjectValue billEntryInfo) throws EASBizException, BOSException {
        Object storeType = billEntryInfo.get("FStoreTypeID");
        Object storeState = billEntryInfo.get("FStoreStatusID");
        if (storeType == null || storeState == null) {
            return;
        }
        String storeTypeId = storeType.toString();
        String storestateId = storeState.toString();
        InvUpdateTypeInfo invUpdateType = SCMBaseCommonUtil.getInvUpdateType(null, (String)this.transactionTypeID, (String)storeTypeId, (String)storestateId);
        InvUpdateTypeInfo defalutInvUpdateType = (InvUpdateTypeInfo)billEntryInfo.get("invUpdateType");
        if (invUpdateType != null || defalutInvUpdateType == null || !defalutInvUpdateType.isIsNotUpdateInv()) {
            billEntryInfo.put("invUpdateType", (Object)invUpdateType);
        }
    }

    public List<String> getTableHeadKeyList() {
        return this.tableHeadKeyList;
    }

    public Set<String> getBoolPropSet() {
        return this.boolPropSet;
    }

    public Map<String, Object> getData() {
        return this.resMap;
    }

    protected static Set<String> getDefaultProperty() {
        String[] fields = new String[]{"FID", "FControlUnitID", "FLastUpdateTime", "FLastUpdateUserID", "FCreateTime", "FCreatorID", "FAssistPropertyID", "FExp", "FBaseUnitID", "FAmount", "FBaseQty", "FCurStoreAssistQty", "FAssistUnitID", "FCurStoreQty", "FUnitID", "FTrackNumberID", "FProjectID", "FLot", "FMaterialID", "FCustomerID", "FSupplierID", "FStoreStatusID", "FStoreTypeID", "FLocationID", "FWarehouseID", "FStorageOrgUnitID", "FCompanyOrgUnitID"};
        return new HashSet<String>(Arrays.asList(fields));
    }

    protected BillInventoryConfigInfo getConfigInfo(String bosType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        SorterItemCollection sic = new SorterItemCollection();
        sic.add(new SorterItemInfo("number"));
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sic);
        BillInventoryConfigCollection col = BillInventoryConfigFactory.getLocalInstance(this.ctx).getBillInventoryConfigCollection(viewInfo);
        return col.get(0);
    }

    public static CommonBalanceFilterPanel getFilterPanel() {
        return null;
    }

    protected BalanceFieldModelCollection getBalanceFieldModelCollInOrder() throws Exception {
        BalanceFieldModelCollection coll = BalanceCfgUtil.getBalanceFieldModelColl(this.ctx);
        BalanceFieldModelCollection orderColl = new BalanceFieldModelCollection();
        Object[] orderFields = this.getOrderFields();
        if (ArrayUtil.isEmpty((Object[])orderFields)) {
            orderColl = coll;
        } else {
            Object field2 = null;
            BalanceFieldModelInfo fieldInfo = null;
            for (Object field2 : orderFields) {
                fieldInfo = this.getBalanceFieldModelInfo(coll, (String)field2);
                if (fieldInfo == null) continue;
                orderColl.add(fieldInfo);
                coll.remove(fieldInfo);
            }
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
                orderColl.addCollection(coll);
            }
        }
        return orderColl;
    }

    private BalanceFieldModelInfo getBalanceFieldModelInfo(BalanceFieldModelCollection coll, String fieldName) {
        BalanceFieldModelInfo fieldInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = coll.get(i);
            if (!fieldName.equals(fieldInfo.getFieldName())) continue;
            return fieldInfo;
        }
        return null;
    }

    protected String[] getOrderFields() {
        String[] orderFields = new String[]{"FID", "FControlUnitID", "FMaterialID", "FLot", "FUnitID", "FCurStoreQty", "FBaseUnitID", "FBaseQty", "FAssistUnitID", "FCurStoreAssistQty", "FAssistPropertyID", "FWarehouseID", "FLocationID", "FStoreTypeID", "FStoreStatusID", "FProjectID", "FTrackNumberID", "FCustomerID", "FSupplierID", "FStorageOrgUnitID", "FLastUpdateUserID", "FCreatorID", "FLastUpdateTime", "FCreateTime", "FExp", "FAmount", "FCompanyOrgUnitID"};
        return orderFields;
    }

    protected void buildConfigMapping(Context ctx, IObjectValue billInfo, IObjectValue billEntryInfo, int filterType) throws Exception {
        HashMap<String, String> bosType2EntryName;
        String entryBosType;
        String billBosType = billInfo.getBOSType().toString();
        BillInventoryConfigInfo configInfo = BalanceCfgUtil.getConfigInfo(ctx, billBosType, entryBosType = billEntryInfo.getBOSType().toString(), billInfo, bosType2EntryName = new HashMap<String, String>());
        if (configInfo == null) {
            this.propMap = new HashMap<String, Object>();
            return;
        }
        this.mapping = new HashMap<String, String>();
        BillInventoryConfigEntryInfo entryInfo = null;
        int size = configInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = configInfo.getEntry().get(i);
            if (entryInfo == null || !entryInfo.isIsAssign() || entryInfo.getInvField() == null || entryInfo.getBillProperty() == null) continue;
            String propertyStr = entryInfo.getBillProperty();
            if (propertyStr.indexOf("__src") != -1) {
                propertyStr = propertyStr.substring("__src".length() + 1);
            }
            this.mapping.put(entryInfo.getInvField(), propertyStr);
        }
        if (bosType2EntryName.get(entryBosType) != null) {
            this.entryName = (String)bosType2EntryName.get(entryBosType);
        }
        this.propMap = BillInvConfigFacadeFactory.getLocalInstance(ctx).evalBillInventoryConfigValue(billInfo, billEntryInfo, this.entryName, configInfo, false, filterType);
    }

    protected BigDecimal getQtyFromBaseQty(String materialID, String unitID, BigDecimal baseQty) throws EASBizException, BOSException {
        BigDecimal qty = baseQty != null ? baseQty : new BigDecimal("0.00000");
        MultiMeasureUnitInfo mmu = null;
        if (!StringUtil.isEmpty((String)materialID) && !StringUtil.isEmpty((String)unitID)) {
            mmu = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx).getMultiUnit(materialID, unitID);
        }
        if (mmu != null) {
            BigDecimal coefficient = mmu.getBaseConvsRate();
            int precision = mmu.getQtyPrecision();
            qty = baseQty.divide(coefficient, precision, 4);
        }
        return qty;
    }

    protected String getPropStringValue(Object propValue) {
        if (propValue == null) {
            return null;
        }
        String propStr = "";
        propStr = propValue instanceof IObjectValue ? ((IObjectValue)propValue).get("id").toString() : (propValue instanceof Boolean ? ((Boolean)propValue != false ? "1" : "0") : (propValue instanceof Date ? DateTimeUtil.getFmtDate((Date)((Date)propValue)) : StringUtils.replace((String)propValue.toString(), (String)"'", (String)"''")));
        return propStr;
    }

    protected ICoreBase getICoreBase(String invField, String id) throws BOSException {
        BOSObjectType bosObjectType = null;
        bosObjectType = this.linkPropBosTypeMap.get(invField) != null ? BOSObjectType.create((String)this.linkPropBosTypeMap.get(invField)) : BOSUuid.read((String)id).getType();
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, ICoreBase.class);
        return iCoreBase;
    }
}

