/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.app.InventoryPageHelper;
import com.kingdee.eas.scm.im.inv.invconfig.BillInvConfigFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.SQLDataAccessFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.util.BalanceCfgUtil;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InventorySumPageHelper
extends InventoryPageHelper {
    private static final String invColName = "inventorySum";
    private static final String invUnitColName = "unitInventorySum";
    private static final String invAssistUnitColName = "assistUnitInventorySum";
    private String entryIDColName = "id";
    Map<String, Object> inventorySumConditionMap = null;
    private Set<String> billIDs = null;
    private Map IDMap = new HashMap();
    private SelectorItemCollection selectors = null;
    private String tempTableName = null;
    private static final String inventoryAlias = "INVENTORY.";
    private static final String reservationAlias = "RESERVATION.";
    private boolean isBatch = false;
    private static final String permItem = "inventory";
    private Set<String> authorizedOrgIDSet = null;
    private Map<String, MaterialInventoryInfo> matInvMap = new HashMap<String, MaterialInventoryInfo>();

    public InventorySumPageHelper(Context ctx, Map<String, Object> inventorySumConditionMap) {
        this.inventorySumConditionMap = inventorySumConditionMap;
        this.ctx = ctx;
    }

    public InventorySumPageHelper(Context ctx, String entryName, Set<String> billIDs, Map IDMap, SelectorItemCollection selectors) {
        this.ctx = ctx;
        this.inventorySumConditionMap = new HashMap<String, Object>();
        this.inventorySumConditionMap.put("billEntryName", entryName);
        this.billIDs = billIDs;
        this.selectors = selectors;
        this.IDMap = IDMap;
        this.entryIDColName = entryName + ".id";
        this.isBatch = true;
    }

    public Object doProcess() throws Exception {
        if (!this.dataCheck()) {
            return null;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(this.ctx.getCaller().toString());
        this.authorizedOrgIDSet = PermissionUtil.getAuthorizedOrgIDSet((Context)this.ctx, (IObjectPK)userPK, (String)permItem);
        if (this.isBatch) {
            return this.batchSummaryByStep();
        }
        return this.summaryByStep();
    }

    private boolean dataCheck() {
        if (this.inventorySumConditionMap == null) {
            return false;
        }
        return this.isBatch || this.inventorySumConditionMap.get("model") != null && !StringUtil.isEmpty((String)((String)this.inventorySumConditionMap.get("billEntryName")));
    }

    private Map batchSummaryByStep() throws Exception {
        this.createTempTable();
        this.batchInsertData();
        this.calculateUnitQty();
        this.calculateAssistUnitQty();
        IRowSet rs = this.getSummaryData();
        Map map = this.batchLoadData(rs);
        this.dropTempTable();
        return map;
    }

    private Map[] summaryByStep() throws Exception {
        BillInventoryConfigInfo configInfo = this.getConfigInfo();
        this.createTempTable();
        this.insertData(configInfo);
        this.calculateUnitQty();
        this.calculateAssistUnitQty();
        IRowSet rs = this.getSummaryData();
        Map[] list = this.loadData(rs);
        this.dropTempTable();
        return list;
    }

    private Map batchLoadData(IRowSet rs) throws SQLException {
        BigDecimal baseQty = null;
        BigDecimal qty = null;
        String entryId = null;
        BigDecimal asisitQty = null;
        HashMap listMap = new HashMap();
        ArrayList records = new ArrayList();
        DecimalFormat d1 = new DecimalFormat("#,##0.########");
        while (rs.next()) {
            entryId = rs.getString("fentryid");
            baseQty = rs.getBigDecimal("FTotalBaseQty");
            qty = rs.getBigDecimal("fTotalUnitQty");
            asisitQty = rs.getBigDecimal("fTotalAssistQty");
            HashMap<String, String> row = new HashMap<String, String>();
            row.put(invUnitColName, d1.format(qty));
            row.put(invColName, d1.format(baseQty));
            row.put(invAssistUnitColName, d1.format(asisitQty));
            listMap.put(entryId, row);
        }
        return listMap;
    }

    private Map[] loadData(IRowSet rs) throws SQLException, BaseException {
        int seq = 0;
        BigDecimal baseQty = null;
        BigDecimal qty = null;
        BigDecimal asisitQty = null;
        DecimalFormat d1 = new DecimalFormat("#,##0.########");
        d1.setRoundingMode(RoundingMode.FLOOR);
        int length = Integer.valueOf((String)this.inventorySumConditionMap.get("length"));
        Map[] records = new HashMap[length];
        while (rs.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            seq = rs.getInt("fseq");
            baseQty = rs.getBigDecimal("FTotalBaseQty");
            if (baseQty != null) {
                row.put(invColName, d1.format(baseQty));
            }
            if ((qty = rs.getBigDecimal("fTotalUnitQty")) != null) {
                row.put(invUnitColName, d1.format(qty));
            }
            if ((asisitQty = rs.getBigDecimal("fTotalAssistQty")) != null) {
                row.put(invAssistUnitColName, d1.format(asisitQty));
            }
            records[seq] = row;
        }
        return records;
    }

    private void calculateAssistUnitQty() throws EASBizException, BOSException {
        StringBuffer buf = new StringBuffer();
        buf.append("update " + this.tempTableName + " a set fTotalAssistQty = ").append("(").append(" select case WHEN temp1.fAssistUnitId IS NULL then round(fTotalAssistQty,0) else round(fTotalAssistQty,b.FQtyPrecision) end ").append(" from " + this.tempTableName + " temp1 left join T_BD_MultiMeasureUnit b ").append(" on temp1.fMateiralId = b.FMaterialID and temp1.fAssistUnitId = b.FMeasureUnitID  ").append(" where a.FEntryID=temp1.FEntryID ").append(")");
        String[] sqls = new String[]{buf.toString()};
        SQLDataAccessFacadeFactory.getRemoteInstance().executeBatch(sqls);
    }

    private void calculateUnitQty() throws EASBizException, BOSException {
        StringBuffer buf = new StringBuffer();
        buf.append("update " + this.tempTableName + " a set fTotalUnitQty = ").append("(isnull(").append(" select round(decimal(temp1.FTotalBaseQty/b.FBaseConvsRate,21,8),b.FQtyPrecision) ").append(" from " + this.tempTableName + " temp1 inner join T_BD_MultiMeasureUnit b ").append(" on temp1.fMateiralId = b.FMaterialID and temp1.fUnitId = b.FMeasureUnitID  ").append(" where a.FEntryID=temp1.FEntryID ").append(",0))");
        String[] sqls = new String[]{buf.toString()};
        SQLDataAccessFacadeFactory.getLocalInstance(this.ctx).executeBatch(sqls);
    }

    private IRowSet getSummaryData() throws EASBizException, BOSException {
        StringBuilder sql = new StringBuilder(100);
        sql.append("select fentryid, fseq, FTotalBaseQty,fTotalUnitQty,fTotalAssistQty from ").append(this.tempTableName);
        return DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
    }

    private void insertData(BillInventoryConfigInfo configInfo) throws EASBizException, BOSException {
        IObjectValue srcObjectValue = (IObjectValue)this.inventorySumConditionMap.get("model");
        IObjectValue srcParentObjectValue = (IObjectValue)this.inventorySumConditionMap.get("parentModel");
        String entryName = (String)this.inventorySumConditionMap.get("billEntryName");
        ArrayList valueList = BillInvConfigFacadeFactory.getLocalInstance(this.ctx).evalBillInventoryConfigValue(configInfo, srcObjectValue, srcParentObjectValue, entryName, false, 0);
        Map billIdAndStorageIdMap = (Map)this.inventorySumConditionMap.get("billIdAndStorageOrgUnitIdMap");
        HashSet<String> materialIDSet = new HashSet<String>();
        HashSet<String> souIDSet = new HashSet<String>();
        for (int j = 0; j < valueList.size(); ++j) {
            if (((Map)valueList.get(j)).get("FMaterialID") != null) {
                materialIDSet.add(((MaterialInfo)((Map)valueList.get(j)).get("FMaterialID")).getId().toString());
            }
            if (billIdAndStorageIdMap != null || ((Map)valueList.get(j)).get("FStorageOrgUnitID") == null) continue;
            souIDSet.add(((StorageOrgUnitInfo)((Map)valueList.get(j)).get("FStorageOrgUnitID")).getId().toString());
        }
        if (billIdAndStorageIdMap != null && !billIdAndStorageIdMap.isEmpty()) {
            String id = ((MaterialReqBillInfo)srcObjectValue).getId().toString();
            souIDSet.add((String)billIdAndStorageIdMap.get(id));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", souIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        view.setFilter(filter);
        MaterialInventoryCollection coll = MaterialInventoryFactory.getLocalInstance((Context)this.ctx).getMaterialInventoryCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            this.matInvMap.put(coll.get(i).getMaterial().getId().toString() + coll.get(i).getOrgUnit().getId().toString(), coll.get(i));
        }
        ArrayList<String> sqls = this.getInsertSQL(configInfo, valueList);
        if (CollectionUtil.isEmpty(sqls)) {
            return;
        }
        SQLDataAccessFacadeFactory.getLocalInstance(this.ctx).executeBatch(sqls.toArray(new String[0]));
    }

    private void batchInsertData() throws Exception {
        int i;
        String entryName;
        CoreBaseCollection billInfoColl = BalanceCfgUtil.getBillInfoColl(this.billIDs, this.selectors);
        Map<String, BillInventoryConfigInfo> configInfoMap = BalanceCfgUtil.getConfigInfoMap(null, billInfoColl, entryName = (String)this.inventorySumConditionMap.get("billEntryName"));
        if (configInfoMap == null || configInfoMap.size() == 0) {
            return;
        }
        Map entryPropMap = BillInvConfigFacadeFactory.getLocalInstance(this.ctx).evalBillInventoryConfigValue((IObjectCollection)billInfoColl, entryName, false, 0, configInfoMap);
        ArrayList<String> billSQLs = new ArrayList<String>();
        String billId = null;
        ArrayList valueList = null;
        BillInventoryConfigInfo configInfo = null;
        CoreBaseInfo objValue = null;
        HashSet<String> materialIDSet = new HashSet<String>();
        HashSet<String> souIDSet = new HashSet<String>();
        int size = billInfoColl.size();
        for (int i2 = 0; i2 < size; ++i2) {
            objValue = billInfoColl.get(i2);
            billId = objValue.get("id").toString();
            valueList = (ArrayList)entryPropMap.get(billId);
            for (int j = 0; j < valueList.size(); ++j) {
                if (((Map)valueList.get(j)).get("FMaterialID") != null) {
                    materialIDSet.add(((MaterialInfo)((Map)valueList.get(j)).get("FMaterialID")).getId().toString());
                }
                if (((Map)valueList.get(j)).get("FStorageOrgUnitID") == null) continue;
                souIDSet.add(((StorageOrgUnitInfo)((Map)valueList.get(j)).get("FStorageOrgUnitID")).getId().toString());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", souIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        view.setFilter(filter);
        MaterialInventoryCollection coll = MaterialInventoryFactory.getLocalInstance((Context)this.ctx).getMaterialInventoryCollection(view);
        for (i = 0; i < coll.size(); ++i) {
            this.matInvMap.put(coll.get(i).getMaterial().getId().toString() + coll.get(i).getOrgUnit().getId().toString(), coll.get(i));
        }
        int size2 = billInfoColl.size();
        for (i = 0; i < size2; ++i) {
            objValue = billInfoColl.get(i);
            this.inventorySumConditionMap.put("model", objValue);
            this.inventorySumConditionMap.put("parentModel", objValue);
            billId = objValue.get("id").toString();
            valueList = (ArrayList)entryPropMap.get(billId);
            configInfo = configInfoMap.get(billId);
            ArrayList<String> sqls = this.getInsertSQL(configInfo, valueList);
            billSQLs.addAll(sqls);
        }
        SQLDataAccessFacadeFactory.getLocalInstance(this.ctx).executeBatch(billSQLs.toArray(new String[0]));
    }

    private ArrayList<String> getInsertSQL(BillInventoryConfigInfo configInfo, ArrayList<Map<String, Object>> valueList) throws EASBizException, BOSException {
        AbstractObjectCollection billEntryColl = (AbstractObjectCollection)((IObjectValue)this.inventorySumConditionMap.get("parentModel")).get((String)this.inventorySumConditionMap.get("billEntryName"));
        String sql = null;
        ArrayList<String> sqls = new ArrayList<String>();
        Map<String, Object> billPropMap = valueList.get(valueList.size() - 1);
        Map<String, Object> entryPropMap = null;
        IObjectValue billEntryInfo = null;
        String billEntryID = "";
        String billId = ((IObjectValue)this.inventorySumConditionMap.get("parentModel")).get("id").toString();
        ArrayList entryIdList = (ArrayList)this.IDMap.get(billId);
        int size = billEntryColl.size();
        for (int i = 0; i < size; ++i) {
            billEntryInfo = billEntryColl.getObject(i);
            billEntryID = billEntryInfo.get("id") != null ? billEntryInfo.get("id").toString() : BOSUuid.create((String)"ABF2CCE2").toString();
            if (entryIdList != null && entryIdList.size() > 0 && !entryIdList.contains(billEntryID) || (entryPropMap = valueList.get(i)).get("FMaterialID") == null || entryPropMap.get("FUnitID") == null || !this.isAuthorized(billPropMap, entryPropMap) || StringUtil.isEmpty((String)(sql = this.getInsertSQL(configInfo, billEntryID, i, billPropMap, entryPropMap)))) continue;
            sqls.add(sql);
        }
        return sqls;
    }

    private String getInsertSQL(BillInventoryConfigInfo configInfo, String billEntryID, int seq, Map<String, Object> billPropMap, Map<String, Object> entryPropMap) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into ").append(this.tempTableName).append(" (FEntryID, FSeq, FTotalBaseQty, fMateiralId, fUnitId,fTotalAssistQty,fAssistUnitId) ");
        sql.append(" select '").append(billEntryID).append("', ").append(seq);
        sql.append(" , sum( ").append(inventoryAlias).append("fbaseqty ").append(" - ").append(" isnull(").append(reservationAlias).append("FReservationBaseQty, 0)), ").append(" '" + ((MaterialInfo)entryPropMap.get("FMaterialID")).getId().toString() + "', ").append("'" + ((MeasureUnitInfo)entryPropMap.get("FUnitID")).getId().toString() + "',").append(" sum( ").append(inventoryAlias).append("FCurStoreAssistQty ").append(" - ").append(" isnull(").append(reservationAlias).append("FReservationAssistQty, 0)), ");
        if ((MeasureUnitInfo)entryPropMap.get("FAssistUnitID") != null) {
            sql.append("'" + ((MeasureUnitInfo)entryPropMap.get("FAssistUnitID")).getId().toString() + "'");
        } else {
            sql.append(" null ");
        }
        sql.append(" from t_im_inventory inventory ");
        sql.append((CharSequence)this.getReservationSQL());
        BillInventoryConfigEntryCollection configEntryCol = configInfo.getEntry();
        BillInventoryConfigEntryInfo configEntryInfo = null;
        StoreTypeInfo storeTypeInfo = (StoreTypeInfo)entryPropMap.get("FStoreTypeID");
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)billPropMap.get("FStorageOrgUnitID");
        MaterialInfo materialInfo = (MaterialInfo)entryPropMap.get("FMaterialID");
        boolean isSupplierFilter = this.isSupplierFilter(storeTypeInfo);
        boolean isCustomerFilter = this.isCustomerFilter(storeTypeInfo);
        boolean isTrackNumberFilter = false;
        boolean isProjectNumberFilter = false;
        boolean isAllPropNULL = true;
        StringBuilder whereSQL = new StringBuilder(" where ");
        StringBuilder groupbySQL = new StringBuilder(" group by ");
        String invField = null;
        Object compareValue = null;
        int size = configEntryCol.size();
        for (int i = 0; i < size; ++i) {
            configEntryInfo = configEntryCol.get(i);
            if (!configEntryInfo.isIsMatQueryFilter() || "FSupplierID".equals(invField = configEntryInfo.getInvField()) && !isSupplierFilter || "FCustomerID".equals(invField) && !isCustomerFilter || "FTrackNumberID".equals(invField) && !isTrackNumberFilter || "FProjectID".equals(invField) && !isProjectNumberFilter) continue;
            Object propValue = entryPropMap.get(invField);
            if (propValue == null) {
                propValue = billPropMap.get(invField);
            }
            if ((compareValue = this.getCompareValue(propValue)) == null) continue;
            if ("FStorageOrgUnitID".equals(invField)) {
                isTrackNumberFilter = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FTrackNumber", compareValue);
                isProjectNumberFilter = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FProjectNumber", compareValue);
                Map billIdAndStorageIdMap = (Map)this.inventorySumConditionMap.get("billIdAndStorageOrgUnitIdMap");
                if (billIdAndStorageIdMap != null && !billIdAndStorageIdMap.isEmpty()) {
                    IObjectValue srcObjectValue = (IObjectValue)this.inventorySumConditionMap.get("model");
                    String id = ((MaterialReqBillInfo)srcObjectValue).getId().toString();
                    compareValue = billIdAndStorageIdMap.get(id);
                }
            }
            isAllPropNULL = false;
            if (propValue instanceof Date) {
                whereSQL.append(inventoryAlias).append(invField).append("= to_date('").append(compareValue).append("') and ");
            } else {
                compareValue = StringUtils.replace((String)String.valueOf(compareValue), (String)"'", (String)"''");
                whereSQL.append(inventoryAlias).append(invField).append("='").append(compareValue).append("' and ");
            }
            groupbySQL.append(invField).append(",");
        }
        if (isAllPropNULL) {
            return null;
        }
        whereSQL.setLength(whereSQL.length() - 4);
        groupbySQL.setLength(groupbySQL.length() - 1);
        sql.append((CharSequence)whereSQL).append((CharSequence)groupbySQL);
        return sql.toString();
    }

    private boolean isCustomerFilter(StoreTypeInfo storeTypeInfo) {
        if (storeTypeInfo == null) {
            return false;
        }
        return StoreFlagEnum.CUSTOMER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOCUSTOMER.equals((Object)storeTypeInfo.getStoreFlag());
    }

    private boolean isSupplierFilter(StoreTypeInfo storeTypeInfo) {
        if (storeTypeInfo == null) {
            return false;
        }
        return StoreFlagEnum.SUPPLIER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOSUPPLIER.equals((Object)storeTypeInfo.getStoreFlag());
    }

    private boolean isTrackNumberOrProjectNumberFilter(MaterialInfo materialInfo, String trOrPr, Object compareValue) throws EASBizException, BOSException {
        if (materialInfo == null) {
            return false;
        }
        MaterialInventoryInfo inventoryInfo = null;
        inventoryInfo = this.matInvMap.get(materialInfo.getId().toString() + compareValue);
        if (trOrPr.equals("FTrackNumber")) {
            return inventoryInfo == null ? false : inventoryInfo.isIsTrackingNumber();
        }
        if (trOrPr.equals("FProjectNumber")) {
            return inventoryInfo == null ? false : inventoryInfo.isIsProjectNumber();
        }
        return false;
    }

    private void createTempTable() throws EASBizException, BOSException {
        StringBuilder createTempTableSQL = new StringBuilder();
        createTempTableSQL.append(" create table temp_table(");
        createTempTableSQL.append(" fentryid varchar(44), ");
        createTempTableSQL.append(" fseq int,");
        createTempTableSQL.append(" fMateiralId varchar(44),");
        createTempTableSQL.append(" fUnitId varchar(44),");
        createTempTableSQL.append(" fAssistUnitId varchar(44),");
        createTempTableSQL.append(" fTotalUnitQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" fTotalAssistQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" FTotalBaseQty Decimal(28,10) not null default 0);");
        this.tempTableName = SQLDataAccessFacadeFactory.getLocalInstance(this.ctx).createTempTable(createTempTableSQL.toString(), null, null, null);
    }

    private void dropTempTable() throws EASBizException, BOSException {
        SQLDataAccessFacadeFactory.getLocalInstance(this.ctx).dropTable(this.tempTableName);
    }

    private BillInventoryConfigInfo getConfigInfo() throws BOSException {
        AbstractObjectCollection objColl;
        String billEntryBosType;
        IObjectValue srcParentObj = (IObjectValue)this.inventorySumConditionMap.get("parentModel");
        String billBosType = ((IObjectValue)this.inventorySumConditionMap.get("model")).getBOSType().toString();
        BillInventoryConfigInfo configInfo = BalanceCfgUtil.getConfigInfo(null, billBosType, billEntryBosType = (objColl = (AbstractObjectCollection)srcParentObj.get((String)this.inventorySumConditionMap.get("billEntryName"))).getObject(0).getBOSType().toString(), (IObjectValue)this.inventorySumConditionMap.get("model"));
        if (configInfo == null) {
            String msg = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"configInfoInvalid");
            throw new BOSException(msg);
        }
        return configInfo;
    }

    private Object getCompareValue(Object propValue) {
        if (propValue == null) {
            return null;
        }
        String compareValue = null;
        compareValue = propValue instanceof IObjectValue ? ((IObjectValue)propValue).get("id").toString() : (propValue instanceof Boolean ? ((Boolean)propValue != false ? "1" : "0") : (propValue instanceof Date ? DateTimeUtil.getFmtDate((Date)((Date)propValue)) : propValue.toString()));
        return compareValue;
    }

    private boolean isAuthorized(Map<String, Object> billPropMap, Map<String, Object> entryPropMap) {
        IObjectValue storeOrgUnit = (IObjectValue)entryPropMap.get("FStorageOrgUnitID");
        if (storeOrgUnit == null) {
            storeOrgUnit = (IObjectValue)billPropMap.get("FStorageOrgUnitID");
        }
        if (storeOrgUnit == null) {
            return false;
        }
        String souID = storeOrgUnit.get("id").toString();
        return this.authorizedOrgIDSet.contains(souID);
    }
}

