/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceCalculatorFactory;
import com.kingdee.eas.scm.framework.balance.app.engine.IBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.IRenovator;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractInventoryUpdateControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.invupdate.IMBussinessProcessorFacade;
import com.kingdee.eas.scm.im.inv.app.invupdate.engin.IDecompose;
import com.kingdee.eas.scm.im.inv.app.invupdate.engin.InvDecomposeCalculator;
import com.kingdee.eas.scm.im.inv.app.invupdate.engin.InventoryRenovator;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBaceFactory;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.eas.scm.im.inv.invconfig.app.CountingTableAppHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InventoryUpdateControllerBean
extends AbstractInventoryUpdateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.InventoryUpdateControllerBean");
    private static final long serialVersionUID = 2309587345891L;
    protected static final String OUT_EFFECT = "OUT_EFFECT";
    protected static final String IN_EFFECT = "IN_EFFECT";
    private static final String PARAM_ISBASEUNITUPDATE = "INM004";
    private static final String PARAM_ISARUPDATE = "CONSIGNSALES";
    private static final String IS_BASEUNIT_UPDATE = "isBaseUpdate";
    private static final String IS_AR_UPDATE = "isArUpdate";
    private static List<String> extendsFieldList = null;
    private static Map mapping = null;

    @Override
    protected void _updateInventory(Context ctx, BizActionEnum bizAction, String billID, String transTypeID) throws BOSException, EASBizException {
        if (!InvAppUtils.isExitsBizFlowValue(ctx, billID, transTypeID)) {
            this._reWriteSrcAndCoreBill(ctx, bizAction, billID, transTypeID);
        }
        this.updateInventory(ctx, bizAction, billID);
    }

    @Override
    protected void _updateInventory(Context ctx, String billID, BizActionEnum bizAction) throws BOSException, EASBizException {
        this.updateInventory(ctx, bizAction, billID);
    }

    @Override
    protected void _updateInventory(Context ctx, String billID, String transTypeID, boolean isRewriteOrder, BizActionEnum bizAction) throws BOSException, EASBizException {
        if (isRewriteOrder && !InvAppUtils.isExitsBizFlowValue(ctx, billID, transTypeID)) {
            this._reWriteSrcAndCoreBill(ctx, bizAction, billID, transTypeID);
        }
        this.updateInventory(ctx, bizAction, billID);
    }

    private void updateInventory(Context ctx, BizActionEnum bizAction, String billID) throws BOSException, EASBizException {
        String bosType = new ObjectUuidPK(billID).getObjectType().toString();
        IBalanceCalculator calculator = BalanceCalculatorFactory.getCalculator((Context)ctx, (IObjectPK)new ObjectUuidPK("SOYjDrxMRamtGGENYUm98SPUYjI="));
        OperationTypeEnum OPType = OperationTypeEnum.Positive;
        if (!BizActionEnum.AUDIT.equals((Object)bizAction)) {
            OPType = OperationTypeEnum.Reverse;
        }
        calculator.calculate(bosType, billID, OPType);
    }

    @Override
    protected void _reWriteSrcAndCoreBill(Context ctx, BizActionEnum bizAction, String billID, String transTypeID) throws BOSException, EASBizException {
        long lstart = System.currentTimeMillis();
        WriteBackParamInfo wbParam = WriteBaceFactory.getWriteBackParamInfo(ctx, bizAction, billID, transTypeID);
        if ("T_IM_PurInWarehsBill".equals(wbParam.getBillTable()) && "141".equals(wbParam.getSourceBillType())) {
            this.chechSourceBillOfTransfer(ctx, billID, bizAction);
        }
        IMBussinessProcessorFacade.doWriteBack(ctx, wbParam);
        long lstop = System.currentTimeMillis();
        logger.info((Object)("write back spend total time:" + (lstop - lstart)));
    }

    private void chechSourceBillOfTransfer(Context ctx, String billId, BizActionEnum bizAction) throws EASBizException, BOSException {
        PurInWarehsBillInfo info = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(billId));
        PurInWarehsEntryCollection entryCollection = info.getEntry();
        if (entryCollection.get(0).getSourceBillId() != null) {
            HashSet<String> sourceIds = new HashSet<String>();
            for (int i = 0; i < entryCollection.size(); ++i) {
                String billtype = entryCollection.get(i).getCoreBillTypeId();
                if (billtype == null || !billtype.equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) continue;
                String coreId = entryCollection.get(i).getSourceBillEntryId();
                sourceIds.add(coreId);
            }
            if (!sourceIds.isEmpty() && BizActionEnum.AUDIT.equals((Object)bizAction)) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", sourceIds, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("baseStatus"));
                viewInfo.setSelector(selector);
                TransferOrderBillEntryCollection entryInfoCol = TransferOrderBillEntryFactory.getLocalInstance(ctx).getTransferOrderBillEntryCollection(viewInfo);
                for (int j = 0; j < entryInfoCol.size(); ++j) {
                    TransferOrderBillEntryInfo transferBillentryInfo = entryInfoCol.get(j);
                    if (transferBillentryInfo.getBaseStatus() != EntryBaseStatusEnum.CLOSED) continue;
                    throw new SCMBillException(SCMBillException.CLOSE_NOT_AUDIT);
                }
            }
        }
    }

    @Override
    protected void _refreshInventory(Context ctx, Map params) throws BOSException, EASBizException {
        IObjectPK pklog = this.writeLog(ctx, params);
        IRenovator renovator = InventoryRenovator.getInstance(ctx);
        renovator.refresh(params);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
    }

    private IObjectPK writeLog(Context ctx, Map params) throws BOSException, EASBizException {
        Set material;
        String className = "com.kingdee.eas.scm.im.inv.InventoryResource";
        String storageId = (String)params.get("StorageID");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("number");
        StorageOrgUnitInfo storage = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageId), selector);
        StringBuffer opreateObject = new StringBuffer(SCMUtils.getResource((String)className, (String)"STORAGE", (Context)ctx));
        opreateObject.append(": ").append(storage.getNumber());
        EntityViewInfo view = new EntityViewInfo();
        Set warehouse = (Set)params.get("WarehouseIDs");
        if (warehouse != null && warehouse.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)warehouse, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(selector);
            WarehouseCollection coll = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(view);
            opreateObject.append("  ").append(SCMUtils.getResource((String)className, (String)"WAREHOUSE", (Context)ctx)).append(": ");
            for (int i = 0; i < coll.size(); ++i) {
                if (i > 0) {
                    opreateObject.append(",");
                }
                opreateObject.append(coll.get(i).getNumber());
            }
        }
        if ((material = (Set)params.get("MaterialIDs")) != null && material.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)material, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(selector);
            MaterialCollection coll = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
            opreateObject.append("  ").append(SCMUtils.getResource((String)className, (String)"MATERIAL", (Context)ctx)).append(": ");
            for (int i = 0; i < coll.size(); ++i) {
                if (i > 0) {
                    opreateObject.append(",");
                }
                opreateObject.append(coll.get(i).getNumber());
            }
        }
        if (opreateObject.length() > 1024) {
            opreateObject.subSequence(0, 1023);
        }
        String facadeAlias = SCMUtils.getResource((String)className, (String)"REFRESH_INVENTORY", (Context)ctx);
        IObjectPK pklog = LogUtil.beginLogWithDescription((Context)ctx, null, (BOSObjectType)this.getBOSType(), null, (String)opreateObject.toString(), (String)facadeAlias);
        return pklog;
    }

    protected void _check(Context ctx, String billID, String transTypeID) throws EASBizException, BOSException {
    }

    @Override
    protected HashMap _getDecomposePara(Context ctx, String billID) throws BOSException, EASBizException {
        IDecompose calculator = InvDecomposeCalculator.getInstance(ctx);
        String bosType = new ObjectUuidPK(billID).getObjectType().toString();
        return (HashMap)calculator.doDecompose(billID, bosType);
    }

    @Override
    protected void _autoRefreshInventory(Context ctx, BOSUuid[] storageOrgIds) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        Map sou2CouMap = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfos(storageOrgIds);
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<String> orgIdList = new ArrayList<String>();
        int size = storageOrgIds.length;
        for (int i = 0; i < size; ++i) {
            paramList.add(PARAM_ISBASEUNITUPDATE);
            orgIdList.add(storageOrgIds[i].toString());
            companyInfo = (CompanyOrgUnitInfo)sou2CouMap.get(storageOrgIds[i].toString());
            if (companyInfo == null) continue;
            paramList.add(PARAM_ISARUPDATE);
            paramList.add(companyInfo.getId().toString());
        }
        ArrayList reqParamSetting = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMapBatch(paramList, orgIdList);
        ArrayList<String> baseAndArUpdateList = new ArrayList<String>();
        ArrayList<String> baseNotArUpdateList = new ArrayList<String>();
        ArrayList<String> notBaseButArUpdateList = new ArrayList<String>();
        ArrayList<String> notBaseNotArUpdateList = new ArrayList<String>();
        HashMap<String, String> paramMap = new HashMap<String, String>(reqParamSetting.size() * 2);
        int size2 = reqParamSetting.size();
        for (int i = 0; i < size2; ++i) {
            ParamSimpleInfo paramInfo = (ParamSimpleInfo)reqParamSetting.get(i);
            paramMap.put(paramInfo.getOrgUnitPK() + paramInfo.getParamNumber(), paramInfo.getParamValue());
        }
        int size3 = storageOrgIds.length;
        for (int i = 0; i < size3; ++i) {
            boolean isArUpdate;
            boolean isBaseUpdate = "true".equals(paramMap.get(storageOrgIds[i].toString() + PARAM_ISBASEUNITUPDATE));
            companyInfo = (CompanyOrgUnitInfo)sou2CouMap.get(storageOrgIds[i].toString());
            boolean bl = isArUpdate = companyInfo == null ? false : "true".equals(paramMap.get(companyInfo.getId() + PARAM_ISARUPDATE));
            if (isBaseUpdate && isArUpdate) {
                baseAndArUpdateList.add(storageOrgIds[i].toString());
                continue;
            }
            if (isBaseUpdate && !isArUpdate) {
                baseNotArUpdateList.add(storageOrgIds[i].toString());
                continue;
            }
            if (!isBaseUpdate && isArUpdate) {
                notBaseButArUpdateList.add(storageOrgIds[i].toString());
                continue;
            }
            notBaseNotArUpdateList.add(storageOrgIds[i].toString());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("refreshType", "storage");
        if (baseAndArUpdateList.size() > 0) {
            params.put(IS_BASEUNIT_UPDATE, Boolean.TRUE);
            params.put(IS_AR_UPDATE, Boolean.TRUE);
            this._refreshInventory(ctx, params);
        }
        if (baseNotArUpdateList.size() > 0) {
            params.put(IS_BASEUNIT_UPDATE, Boolean.TRUE);
            params.put(IS_AR_UPDATE, Boolean.FALSE);
            this._refreshInventory(ctx, params);
        }
        if (notBaseButArUpdateList.size() > 0) {
            params.put(IS_BASEUNIT_UPDATE, Boolean.FALSE);
            params.put(IS_AR_UPDATE, Boolean.TRUE);
            this._refreshInventory(ctx, params);
        }
        if (notBaseNotArUpdateList.size() > 0) {
            params.put(IS_BASEUNIT_UPDATE, Boolean.FALSE);
            params.put(IS_AR_UPDATE, Boolean.FALSE);
            this._refreshInventory(ctx, params);
        }
    }

    private void checkRefreshPermission(Context ctx, String storageId) throws EASBizException, BOSException {
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(storageId), "refreshInventory");
    }

    private void insertBillData(Context ctx, Map params, String tempTable, StringBuffer msWhere) throws BOSException, EASBizException {
        mapping = CountingTableAppHelper.getExtendField4Bill(ctx);
        extendsFieldList = (List)mapping.get("extendFieldList");
        boolean isBuildCountTable = false;
        StringBuffer sqlIn = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        String[][] tableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}, {"T_IM_PurReceivalBill", "T_IM_PurReceivalEntry"}, {"T_IM_InventoryInitBill", "T_IM_InventoryInitEntry"}, {"T_IM_MoveLocationBill", "T_IM_MoveLocationBillEntry"}, {"T_IM_InvStateAdjustBill", "T_IM_InvStateAdjustBillEntry"}};
        sqlIn.append("insert into ").append(tempTable).append(" ");
        sqlIn.append("(fid,fcompanyorgunitid,fstorageorgunitid,fmaterialid,funitid,fbaseunitid,");
        sqlIn.append("fassistunitid,fassistpropertyid,fstoretypeid,fstorestatusid,fsupplierid,fcustomerid,");
        sqlIn.append("fwarehouseid,flocationid,flot,fcurstoreqty,fbaseqty,fcurstoreassistqty,FProjectID,FTrackNumberID ");
        for (int i = 0; i < extendsFieldList.size(); ++i) {
            sqlIn.append(",").append(extendsFieldList.get(i));
        }
        sqlIn.append(")");
        int billCount = tableName.length;
        boolean isArUpdateInventory = (Boolean)params.get(IS_AR_UPDATE);
        String[] sqls = isArUpdateInventory ? new String[billCount * 2 + 1] : new String[billCount * 2];
        if (ctx.get((Object)"BuildCountingTable") != null && "BuildCountingTable".equals(ctx.get((Object)"BuildCountingTable").toString())) {
            isBuildCountTable = true;
        }
        int count = 0;
        for (int i = 0; i < billCount; ++i) {
            sql = new StringBuffer();
            sql.append(sqlIn).append(this.getBillSql2(tableName[i][0], tableName[i][1], msWhere.toString(), IN_EFFECT, isArUpdateInventory, isBuildCountTable));
            sqls[count++] = sql.toString();
            if ("T_IM_InventoryInitBill".equals(tableName[i][0])) continue;
            sql = new StringBuffer();
            sql.append(sqlIn).append(this.getBillSql2(tableName[i][0], tableName[i][1], msWhere.toString(), OUT_EFFECT, isArUpdateInventory, isBuildCountTable));
            sqls[count++] = sql.toString();
        }
        sqls[count++] = this.getDecomposeBillSql(sqlIn.toString(), msWhere.toString());
        if (isArUpdateInventory) {
            sqls[count++] = this.getArBillSql(sqlIn.toString(), msWhere.toString());
        }
        DBUtil.executeBatch((Context)ctx, (String[])sqls);
    }

    private String getBillSql2(String billHead, String billEntry, String msWhere, String effectString, boolean isArUpdateInventory, boolean isBuildCountTable) {
        int index;
        String fieldStoreStatusId;
        String fieldStoreTypeId;
        String fieldLocationId;
        String fieldWarehouseId;
        String fieldSupplierId;
        String fieldCustomerId;
        StringBuffer sql = new StringBuffer();
        boolean isInEffect = IN_EFFECT.endsWith(effectString);
        boolean isOutEffect = OUT_EFFECT.endsWith(effectString);
        int customerValue = 3;
        int toCustomerValue = 4;
        int supplierValue = 2;
        int toSupplierValue = 5;
        if ("T_IM_SaleIssueBill".equals(billHead)) {
            fieldCustomerId = "isnull(a.FCustomerId, 'EgkAAABc3Xu/DAQO')";
            fieldSupplierId = "isnull(b.FSupplierId, 'EgkAAABc3Xo3xn38')";
        } else if ("T_IM_PurInWarehsBill".equals(billHead)) {
            fieldCustomerId = "isnull(b.FCustomerId, 'EgkAAABc3Xu/DAQO')";
            fieldSupplierId = "isnull(a.FSupplierId, 'EgkAAABc3Xo3xn38')";
        } else if ("T_IM_PurReceivalBill".equals(billHead)) {
            fieldCustomerId = "isnull(a.FCustomerId, 'EgkAAABc3Xu/DAQO')";
            fieldSupplierId = "isnull(a.FSupplierId, 'EgkAAABc3Xo3xn38')";
        } else {
            fieldCustomerId = "isnull(b.FCustomerId, 'EgkAAABc3Xu/DAQO')";
            fieldSupplierId = "isnull(b.FSupplierId, 'EgkAAABc3Xo3xn38')";
        }
        if ("T_IM_MoveLocationBill".equals(billHead) && isInEffect) {
            fieldWarehouseId = "isnull(b.FWarehouseId, 'EgkAAABc3XG76fiu')";
            fieldLocationId = "isnull(b.FReceiptLocationID, 'EgkAAABc3XMgX/hq')";
        } else if ("T_IM_PurInWarehsBill".equals(billHead) && isOutEffect) {
            fieldWarehouseId = "isnull(b.FOutWarehouseId, 'EgkAAABc3XG76fiu')";
            fieldLocationId = "isnull(b.FOutLocationId, 'EgkAAABc3XMgX/hq')";
        } else {
            fieldWarehouseId = "isnull(b.FWarehouseId, 'EgkAAABc3XG76fiu')";
            fieldLocationId = "isnull(b.FLocationId, 'EgkAAABc3XMgX/hq')";
        }
        if (isInEffect) {
            if ("T_IM_InventoryInitBill".equals(billHead) || "T_IM_MoveLocationBill".equals(billHead)) {
                fieldStoreTypeId = "b.FStoreTypeId";
                fieldStoreStatusId = "b.FStoreStatusId";
            } else if ("T_IM_InvStateAdjustBill".equals(billHead)) {
                fieldStoreTypeId = "b.FStoreTypeId";
                fieldStoreStatusId = "b.FDestStoreStatusID";
            } else {
                fieldStoreTypeId = "c.FStoreTypeId";
                fieldStoreStatusId = "c.FStoreStateId";
            }
        } else if ("T_IM_InventoryInitBill".equals(billHead) || "T_IM_MoveLocationBill".equals(billHead)) {
            fieldStoreTypeId = "b.FStoreTypeId";
            fieldStoreStatusId = "b.FStoreStatusId";
        } else if ("T_IM_InvStateAdjustBill".equals(billHead)) {
            fieldStoreTypeId = "b.FStoreTypeId";
            fieldStoreStatusId = "b.FSrcStoreStatusID";
        } else {
            fieldStoreTypeId = "c.FStoreTypePreId";
            fieldStoreStatusId = "c.FStoreStatePreId";
        }
        String fieldEffectQty = isInEffect ? "FExistingQty" : "FExistingQtyPre";
        sql.append("select newbosid('BA8AD747'),b.fcompanyorgunitid,b.fstorageorgunitid,");
        sql.append("b.fmaterialid,b.funitid,b.fbaseunitid,\n");
        sql.append(" isnull(b.fassistunitid,'").append("EgkAAAA5EWFbglxX").append("'),");
        sql.append(" isnull(b.fassistpropertyid,'").append("EgkAAAA5EWALxvQu").append("'),");
        sql.append(fieldStoreTypeId).append(",");
        sql.append(" isnull(").append(fieldStoreStatusId).append(",'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'), ");
        sql.append("case d.FStoreFlag when ").append(toSupplierValue).append(" then ");
        sql.append(fieldSupplierId);
        sql.append(" when ").append(supplierValue).append(" then ");
        sql.append(fieldSupplierId);
        sql.append(" else '").append("EgkAAABc3Xo3xn38").append("' end,");
        sql.append("case d.FStoreFlag when ").append(toCustomerValue).append(" then ");
        sql.append(fieldCustomerId);
        sql.append(" when ").append(customerValue).append(" then ");
        sql.append(fieldCustomerId);
        sql.append(" else '").append("EgkAAABc3Xu/DAQO").append("' end,");
        sql.append(fieldWarehouseId).append(",");
        sql.append(fieldLocationId).append(",");
        sql.append("isnull(b.FLot, '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("'),");
        if (isInEffect) {
            sql.append("sum(b.fqty) as fqty,sum(b.fbaseqty) as fbaseqty,sum(b.fassistqty) as fassistqty,");
        } else {
            sql.append("sum((-1)*b.fqty) as fqty,sum((-1)*b.fbaseqty) as fbaseqty,sum((-1)*b.fassistqty) as fassistqty,");
        }
        sql.append("(case when e.FisProjectNumber=0 or b.FProjectID is null then '").append("EgkAAABc3Xza3gXu").append("' else b.FProjectID end) as FProjectID,");
        sql.append("(case when e.FisTrackingNumber=0 or b.FTrackNumberID is null then '").append("EgkAAABc3X0Ibpg9").append("' else b.FTrackNumberID end) as FTrackNumberID ");
        Map map = (Map)mapping.get(billHead);
        String fieldName = null;
        for (index = 0; index < extendsFieldList.size(); ++index) {
            fieldName = (String)map.get(extendsFieldList.get(index));
            if (fieldName == null) {
                sql.append(", null");
                continue;
            }
            sql.append(", b.").append(fieldName).append(" as ").append(fieldName);
        }
        sql.append(" from ").append(billHead).append(" a ");
        sql.append("left join ").append(billEntry).append(" b on b.fparentid = a.fid ");
        if (!("T_IM_InventoryInitBill".equalsIgnoreCase(billHead) || "T_IM_MoveLocationBill".equalsIgnoreCase(billHead) || "T_IM_InvStateAdjustBill".equalsIgnoreCase(billHead))) {
            sql.append("inner join t_im_invupdatetype c on c.fid = b.finvupdatetypeid ");
        }
        sql.append("left join t_im_storetype d on d.fid = ").append(fieldStoreTypeId).append(" ");
        sql.append("left join T_BD_MaterialInventory e on e.FMaterialID = b.FMaterialID and e.FOrgUnit = b.FStorageOrgUnitID ");
        if (isBuildCountTable && "T_IM_InventoryInitEntry".equals(billEntry)) {
            sql.append("inner join T_DB_SOAccreditWH sowh on sowh.FWareHouseID = b.FWarehouseID and sowh.FstorageOrgID = b.fstorageorgunitid ");
        }
        sql.append(msWhere);
        sql.append(" and a.fbasestatus in ('4','7') and isnull(a.fisinitbill,0) = 0");
        if (!("T_IM_InventoryInitBill".equalsIgnoreCase(billHead) || "T_IM_MoveLocationBill".equalsIgnoreCase(billHead) || "T_IM_InvStateAdjustBill".equalsIgnoreCase(billHead))) {
            sql.append(" and c.fisnotupdateinv = 0 ");
        }
        if (!("T_IM_InventoryInitBill".equalsIgnoreCase(billHead) || "T_IM_MoveLocationBill".equalsIgnoreCase(billHead) || "T_IM_InvStateAdjustBill".equalsIgnoreCase(billHead))) {
            sql.append(" and c.").append(fieldEffectQty).append(" <> 0 ");
        }
        if (isBuildCountTable && "T_IM_InventoryInitEntry".equals(billEntry)) {
            sql.append("and sowh.FIsStarted = 0 ");
        }
        sql.append("group by b.fcompanyorgunitid,b.fstorageorgunitid,b.fmaterialid,b.funitid,b.fbaseunitid,");
        sql.append("b.fassistunitid,b.fassistpropertyid,b.FLot,b.fispresent,d.fstoreflag,");
        sql.append(fieldStoreTypeId).append(",").append(fieldStoreStatusId).append(",");
        sql.append(fieldWarehouseId).append(",").append(fieldLocationId).append(",");
        sql.append(fieldSupplierId).append(",").append(fieldCustomerId).append(",");
        sql.append("(case when e.FisProjectNumber=0 or b.FProjectID is null then '").append("EgkAAABc3Xza3gXu").append("' else b.FProjectID end),");
        sql.append("(case when e.FisTrackingNumber=0 or b.FTrackNumberID is null then '").append("EgkAAABc3X0Ibpg9").append("' else b.FTrackNumberID end) ");
        for (index = 0; index < extendsFieldList.size(); ++index) {
            fieldName = (String)map.get(extendsFieldList.get(index));
            if (fieldName == null) continue;
            sql.append(",b.").append(fieldName);
        }
        return sql.toString();
    }

    public String getIDSql(Context ctx, Object[] nums, String keyName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer idSql = new StringBuffer();
        String tableName = "";
        if (keyName.equals("material")) {
            tableName = "t_bd_material";
        } else if (keyName.equals("storage")) {
            tableName = "t_org_storage";
        }
        if (nums.length != 0) {
            sql.append("select distinct fid as fid from ").append(tableName).append(" where fnumber in (");
            int size = nums.length;
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    sql.append(",");
                }
                sql.append("'").append(nums[i]).append("'");
            }
            sql.append(") ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                idSql.append(",'").append(rs.getString("fid")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idSql.substring(1).toString();
    }

    protected String getCreateTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table T_IM_Inventory_temp (").append("FID VARCHAR(44) NOT NULL ,").append("FCompanyOrgUnitID VARCHAR(44),").append("FStorageOrgUnitID VARCHAR(44),").append("FWarehouseID VARCHAR(44),").append("FLocationID VARCHAR(44),").append("FStoreTypeID VARCHAR(44),").append("FStoreStatusID VARCHAR(44),").append("FLot NVARCHAR(80),").append("FSupplierID VARCHAR(44),").append("FCustomerID VARCHAR(44),").append("FMaterialID VARCHAR(44),").append("FUnitID VARCHAR(44),").append("FCurStoreQty NUMERIC(28,16) DEFAULT 0,").append("FAssistUnitID VARCHAR(44),").append("FCurStoreAssistQty NUMERIC(28,16),").append("FBaseQty NUMERIC(28,16) DEFAULT 0,").append("FBaseUnitID VARCHAR(44),").append("FLockQty NUMERIC(28,16) DEFAULT 0,").append("FLockBaseQty NUMERIC(28,16) DEFAULT 0,").append("FLockAssistQty NUMERIC(28,16) DEFAULT 0,").append("FAssistPropertyID VARCHAR(44),").append("FProjectID VARCHAR(44),").append("FTrackNumberID VARCHAR(44));");
        return sql.toString();
    }

    private String getArBillSql(String sqlIn, String msWhere) {
        String where = msWhere.replaceAll("b.fstorageorgunitid", "c.fstorageorgunitid");
        StringBuffer result = new StringBuffer(sqlIn);
        String saleIssue = this.getARsqlFromSaleIssue(where);
        result.append(saleIssue);
        return result.toString();
    }

    private String getARsqlFromSaleIssue(String where) {
        int index;
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("select Newbosid('BA8AD747') as Fid,a.FCompanyID,c.fstorageorgunitid,b.fmaterialid,");
        sqlSelect.append(" case when isnull(param.FValue_L2,'false')='true'");
        sqlSelect.append(" then b.fbaseunitid");
        sqlSelect.append(" else c.funitid end as UnitID,b.fbaseunitid,");
        sqlSelect.append(" isnull(b.fassistunitid,'").append("EgkAAAA5EWFbglxX").append("'),");
        sqlSelect.append(" isnull(b.fassistpropertyid,'").append("EgkAAAA5EWALxvQu").append("'),");
        sqlSelect.append("'").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("',");
        sqlSelect.append("'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("',");
        sqlSelect.append("'").append("EgkAAABc3Xo3xn38").append("',");
        sqlSelect.append(" isnull(b.FServiceCustomerID,'").append("EgkAAABc3Xu/DAQO").append("'),");
        sqlSelect.append(" isnull(c.FWareHouseID,'").append("EgkAAABc3XG76fiu").append("'),");
        sqlSelect.append(" isnull(c.FLocationID,'").append("EgkAAABc3XMgX/hq").append("'),");
        sqlSelect.append(" isnull(c.Flot,'").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("'),");
        sqlSelect.append(" case when isnull(param.FValue_L2,'false') = 'true'");
        sqlSelect.append(" then ");
        sqlSelect.append("(case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.fbaseqty)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.fbaseqty)) ");
        sqlSelect.append("else 0 end)");
        sqlSelect.append(" else ");
        sqlSelect.append(" case when b.FMeasureUnitID = C.FUnitID ");
        sqlSelect.append(" then  ");
        sqlSelect.append("(case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.FQuantity)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.FQuantity)) ");
        sqlSelect.append("else 0 end )");
        sqlSelect.append(" else");
        sqlSelect.append(" round(decimal(");
        sqlSelect.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.fbaseqty)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.fbaseqty)) ");
        sqlSelect.append("else 0 end ");
        sqlSelect.append("/ M.FBaseConvsRate,21,8),M.FQtyPrecision)");
        sqlSelect.append(" end ");
        sqlSelect.append("end AS FQty, ");
        sqlSelect.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.fbaseqty)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.fbaseqty)) ");
        sqlSelect.append("else 0 end, ");
        sqlSelect.append("case A.FBizTypeId when '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen sum(abs(b.FAssistQty)) ");
        sqlSelect.append("when '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("\tthen (-1) * sum(abs(b.FAssistQty)) ");
        sqlSelect.append("else 0 end, ");
        sqlSelect.append("(case when mi.FisProjectNumber=0 or C.FProjectID is null then '").append("EgkAAABc3Xza3gXu").append("' else C.FProjectID end) as FProjectID, ");
        sqlSelect.append("(case when mi.FisTrackingNumber=0 or C.FTrackNumberID is null then '").append("EgkAAABc3X0Ibpg9").append("' else C.FTrackNumberID end) as FTrackNumberID ");
        Map map = (Map)mapping.get("T_AR_OtherBill");
        String fieldName = null;
        for (index = 0; index < extendsFieldList.size(); ++index) {
            fieldName = (String)map.get(extendsFieldList.get(index));
            if (fieldName != null) {
                sqlSelect.append(",b.").append(fieldName);
                continue;
            }
            sqlSelect.append(", null");
        }
        sqlSelect.append(" FROM T_AR_OtherBill A ");
        sqlSelect.append("INNER JOIN T_AR_OTHERBILLENTRY B on A.FID = B.FParentID ");
        sqlSelect.append("INNER JOIN T_IM_SaleIssueEntry C on C.FID = B.FSOURCEBILLENTRYID ");
        sqlSelect.append("INNER JOIN T_BD_multimeasureunit M on (C.FUnitID = M.fmeasureunitid and C.FMaterialID = M.FMaterialID) ");
        sqlSelect.append("inner join T_BD_MaterialInventory mi on (mi.FMaterialID = C.FMaterialID and mi.FOrgUnit = C.FStorageOrgUnitID) ");
        sqlSelect.append(" LEFT JOIN (select Fid, FValue_L1,FValue_L2,FValue_L3,FOrgUnitID from t_bas_paramitem WHERE FKEYID = (select fid from t_bas_param where fnumber = 'INM004')) param ");
        sqlSelect.append(" on c.fstorageorgunitid = param.FOrgUnitID ");
        sqlSelect.append(where).append("AND (A.FBizTypeId = '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("OR A.FBizTypeId = '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("') ");
        sqlSelect.append("AND isnull(A.FIsInitializeBill,0) = 0 AND A.FBillStatus = 3 AND A.FisBizBill = 0  ");
        sqlSelect.append("GROUP BY a.FCompanyID,c.fstorageorgunitid,b.fmaterialid,b.FServiceCustomerID,c.FWareHouseID,c.FLocationID,c.flot,");
        sqlSelect.append("b.FMeasureUnitID,b.FQuantity,b.fbaseunitid,b.fbaseqty,b.fassistunitid,b.FAssistQty,b.fassistpropertyid,a.fbiztypeid,");
        sqlSelect.append("param.FValue_L2, c.FUnitid,M.FBaseConvsRate,M.FQtyPrecision,");
        sqlSelect.append("(case when mi.FisProjectNumber=0 or C.FProjectID is null then '").append("EgkAAABc3Xza3gXu").append("' else C.FProjectID end),");
        sqlSelect.append("(case when mi.FisTrackingNumber=0 or C.FTrackNumberID is null then '").append("EgkAAABc3X0Ibpg9").append("' else C.FTrackNumberID end) ");
        for (index = 0; index < extendsFieldList.size(); ++index) {
            fieldName = (String)map.get(extendsFieldList.get(index));
            if (fieldName == null) continue;
            sqlSelect.append(",b.").append(fieldName);
        }
        return sqlSelect.toString();
    }

    private String getDecomposeBillSql(String sqlIn, String msWhere) {
        StringBuffer sqlSelect = new StringBuffer();
        String[] entryNames = new String[]{"T_IM_DecomposeEntry", "T_IM_DecomposeEntryDetail"};
        String[] symbols = new String[]{"-1", "1"};
        StringBuffer sql = new StringBuffer(sqlIn);
        sql.append("(");
        Map map = (Map)mapping.get("T_IM_DecomposeBill");
        for (int i = 0; i < symbols.length; ++i) {
            int index;
            if ("T_IM_DecomposeEntryDetail".equalsIgnoreCase(entryNames[i])) {
                map = (Map)mapping.get("T_IM_DecomposeEntryDetail");
            }
            sqlSelect.append("select Newbosid('BA8AD747'),b.fcompanyorgunitid,b.fstorageorgunitid,b.fmaterialid,b.funitid,");
            sqlSelect.append("b.fbaseunitid,");
            sqlSelect.append("isnull(b.fassistunitid,'").append("EgkAAAA5EWFbglxX").append("'),");
            sqlSelect.append("isnull(b.fassistpropertyid,'").append("EgkAAAA5EWALxvQu").append("'),");
            sqlSelect.append("b.fstoretypeid,");
            sqlSelect.append("isnull(b.fstorestatusid,'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'),");
            sqlSelect.append("isnull(b.fsupplierid,'").append("EgkAAABc3Xo3xn38").append("'),");
            sqlSelect.append("isnull(b.fcustomerid,'").append("EgkAAABc3Xu/DAQO").append("'),");
            sqlSelect.append("isnull(b.fwarehouseid,'").append("EgkAAABc3XG76fiu").append("'),");
            sqlSelect.append("isnull(b.flocationid,'").append("EgkAAABc3XMgX/hq").append("'),");
            sqlSelect.append("isnull(b.flot,'").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("'),");
            sqlSelect.append("sum(").append(symbols[i]).append(" * b.fqty),");
            sqlSelect.append("sum(").append(symbols[i]).append(" * b.fbaseqty),");
            sqlSelect.append("sum(").append(symbols[i]).append(" * b.fassistqty),");
            sqlSelect.append("(case when mi.FisProjectNumber=0 or b.FProjectID is null then '").append("EgkAAABc3Xza3gXu").append("' else b.FProjectID end) as FProjectID,");
            sqlSelect.append("(case when mi.FisTrackingNumber=0 or b.FTrackNumberID is null then '").append("EgkAAABc3X0Ibpg9").append("' else b.FTrackNumberID end) as FTrackNumberID ");
            String fieldName = null;
            for (index = 0; index < extendsFieldList.size(); ++index) {
                fieldName = (String)map.get(extendsFieldList.get(index));
                if (fieldName != null) {
                    sqlSelect.append(",b.").append(fieldName);
                    continue;
                }
                sqlSelect.append(", null");
            }
            sqlSelect.append(" FROM ").append(entryNames[i]).append(" b ");
            if ("T_IM_DecomposeEntryDetail".equalsIgnoreCase(entryNames[i])) {
                sqlSelect.append("left join T_IM_DecomposeEntry c on b.FDecompEntryID = c.fid ");
                sqlSelect.append("left join T_IM_DecomposeBill a on a.fid = c.fparentid ");
            } else {
                sqlSelect.append("left join T_IM_DecomposeBill a on a.fid = b.fparentid ");
            }
            sqlSelect.append("left join T_BD_MaterialInventory mi on mi.FMaterialID = b.FMaterialID and mi.FOrgUnit = b.FStorageOrgUnitID ");
            sqlSelect.append(msWhere).append(" AND a.fbasestatus = 4 AND isnull(a.fisinitbill,0) = 0 ");
            sqlSelect.append("GROUP BY b.fcompanyorgunitid,b.fstorageorgunitid,b.fwarehouseid, b.flocationid,b.fstoretypeid,b.fsupplierid,");
            sqlSelect.append("b.fcustomerid,b.fstorestatusid,b.flot,b.fmaterialid,b.funitid,b.fbaseunitid,b.fassistunitid,b.fassistpropertyid,");
            sqlSelect.append("(case when mi.FisProjectNumber=0 or b.FProjectID is null then '").append("EgkAAABc3Xza3gXu").append("' else b.FProjectID end),");
            sqlSelect.append("(case when mi.FisTrackingNumber=0 or b.FTrackNumberID is null then '").append("EgkAAABc3X0Ibpg9").append("' else b.FTrackNumberID end) ");
            for (index = 0; index < extendsFieldList.size(); ++index) {
                fieldName = (String)map.get(extendsFieldList.get(index));
                if (fieldName == null) continue;
                sqlSelect.append(",b.").append(fieldName);
            }
            if (i >= symbols.length - 1) continue;
            sqlSelect.append(" union all ");
        }
        sql.append(sqlSelect).append(")");
        return sql.toString();
    }

    @Override
    protected void _getBillDataSQL(Context ctx, Map params, String tempTable, StringBuffer msWhere) throws BOSException, EASBizException {
        this.insertBillData(ctx, params, tempTable, msWhere);
    }
}

