/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.util.DataImportUtils;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ManufactureRecImport
extends InvDataImport {
    ManufactureRecBillInfo manufactureRecBillInfo = null;
    private static final String RESOURCE = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    StorageOrgUnitInfo sou = null;
    TransactionTypeInfo tti = null;
    CompanyOrgUnitInfo cou = null;
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL = new String[]{"FEntry_qty", "FEntry_unitActualCost", "FEntry_actualCost"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL_KEY = new String[]{"qty", "unitActualCost", "actualCost"};
    private static final String[] ENTRY_QTY_AMOUNT_FIELDS = new String[]{"qty", "assistQty", "baseQty", "reverseQty", "reverseBaseQty", "returnsQty", "returnBaseQty", "amount", "actualCost", "standardCost", "recQty", "baseRecQty"};
    private static final String[] ENTRY_PRICE_FIELDS = new String[]{"price", "unitActualCost", "unitStandardCost"};
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ManufactureRecBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.manufactureRecBillInfo = null;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            Map lineData = (Map)hsData.get(i);
            if (i == 0) {
                try {
                    this.manufactureRecBillInfo = this.transmitHead(lineData, ctx);
                    if (this.manufactureRecBillInfo == null) {
                        return null;
                    }
                    this.afterBuildHead(ctx, this.manufactureRecBillInfo, lineData);
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, this.manufactureRecBillInfo);
                    break;
                }
            }
            try {
                ManufactureRecBillEntryInfo entryInfo = this.transmitEntry(lineData, ctx);
                int seq = this.manufactureRecBillInfo.getEntry().size() + 1;
                entryInfo.setSeq(seq);
                entryInfo.setParent(this.manufactureRecBillInfo);
                entryInfo.setStorageOrgUnit(this.sou);
                entryInfo.setCompanyOrgUnit(this.cou);
                this.afterBuildEntry(ctx, this.manufactureRecBillInfo, entryInfo, lineData);
                this.manufactureRecBillInfo.getEntry().add(entryInfo);
                continue;
            }
            catch (TaskExternalException e) {
                tex.addEntryErrorReason(i, e.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, this.manufactureRecBillInfo);
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.manufactureRecBillInfo;
    }

    public int getSubmitType() {
        return 1;
    }

    private ManufactureRecBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        this.manufactureRecBillInfo = new ManufactureRecBillInfo();
        this.doDescription(lineData);
        this.doStorageOrgUnit(ctx, lineData);
        this.doBizType(ctx, lineData);
        this.doTransactionType(ctx, lineData);
        this.manufactureRecBillInfo.setCU(this.sou.getCU());
        this.cou = this.getCompanyOrgFromStorageOrg(ctx, this.sou);
        this.doBizDate(ctx, lineData);
        this.manufactureRecBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        Object data = ((DataToken)lineData.get((Object)"FCreator_number")).data;
        UserInfo creator = this.getCreator(ctx, data);
        this.manufactureRecBillInfo.setCreator(creator);
        this.doCreateTime();
        this.doBillType();
        this.doAdminOrgUnit(ctx, lineData);
        return this.manufactureRecBillInfo;
    }

    private void doAdminOrgUnit(Context ctx, Map lineData) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FAdminOrgUnit_number")).data;
        AdminOrgUnitInfo adminOrgUnit = this.getAdminOrgUnit(ctx, "number", data);
        if (!this.isEmpty(data) && adminOrgUnit == null) {
            throw new TaskExternalException(data.toString() + "  " + ManufactureRecImport.getResource((Context)ctx, (String)"ADMINORG_NOT_EXISTS", (String)RESOURCE));
        }
        this.manufactureRecBillInfo.setAdminOrgUnit(adminOrgUnit);
    }

    private void doBillType() {
        BillTypeInfo manufactureRecBillType = new BillTypeInfo();
        manufactureRecBillType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0167c0a812fd463ED552"));
        manufactureRecBillType.setNumber("105");
        this.manufactureRecBillInfo.setBillType(manufactureRecBillType);
    }

    private void doCreateTime() {
        this.manufactureRecBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
    }

    private void doBizDate(Context ctx, Map lineData) throws TaskExternalException {
        try {
            Date da = DataImportUtils.formatNationalDate((Context)ctx, (String)lineData.get("FBizDate").toString());
            if (da == null) {
                da = new Date();
            }
            this.manufactureRecBillInfo.setBizDate(da);
        }
        catch (Exception e1) {
            throw new TaskExternalException(lineData.get("FBizDate").toString() + ManufactureRecImport.getResource((Context)ctx, (String)"InvalidDateFormat", (String)RESOURCE));
        }
    }

    private void doStorageOrgUnit(Context ctx, Map lineData) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FStorageOrgUnit_number")).data;
        try {
            this.sou = this.getStorageOrgUnit(ctx, "number", data);
        }
        catch (TaskExternalException numberException) {
            data = ((DataToken)lineData.get((Object)"FStorageOrgUnit_name_l2")).data;
            try {
                this.sou = this.getStorageOrgUnit(ctx, "name", data);
            }
            catch (TaskExternalException nameException) {
                throw numberException;
            }
        }
        this.manufactureRecBillInfo.setStorageOrgUnit(this.sou);
    }

    private void doDescription(Map lineData) {
        Object data = ((DataToken)lineData.get((Object)"FDescription")).data;
        if (data != null && data.toString().trim().length() > 0) {
            String description = data.toString().trim();
            if (description.length() > 80) {
                description = description.substring(0, 80);
            }
            this.manufactureRecBillInfo.setDescription(description);
        } else {
            this.manufactureRecBillInfo.setDescription("");
        }
    }

    private ManufactureRecBillEntryInfo transmitEntry(Map lineData, Context ctx) throws TaskExternalException {
        ManufactureRecBillEntryInfo entryInfo = new ManufactureRecBillEntryInfo();
        this.doEntryMaterial(ctx, lineData, entryInfo);
        this.doEntryQty(ctx, lineData, entryInfo);
        this.doEntryLot(ctx, lineData, entryInfo);
        this.doEntryMfgExp(ctx, lineData, entryInfo);
        this.doEntryUnit(ctx, lineData, entryInfo);
        entryInfo.setAssistUnit(entryInfo.getMaterial().getAssistUnit());
        this.doEntryAssistQty(ctx, lineData, entryInfo);
        Object data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
        entryInfo.setAssistProperty(this.getAsstAttr(ctx, data, entryInfo.getMaterial().getAssistAttr()));
        data = ((DataToken)lineData.get((Object)"FEntry$costObject_number")).data;
        entryInfo.setCostObject(this.getCostObject(ctx, this.cou, data));
        data = ((DataToken)lineData.get((Object)"FEntry$warehouse_number")).data;
        WarehouseInfo warehouse = this.getWarehouse(ctx, (OrgUnitInfo)this.sou, data);
        entryInfo.setWarehouse(warehouse);
        data = ((DataToken)lineData.get((Object)"FEntry$stocker_number")).data;
        entryInfo.setStocker(this.getStocker(ctx, data));
        data = ((DataToken)lineData.get((Object)"FEntry$location_number")).data;
        entryInfo.setLocation(this.getLocation(ctx, data, warehouse));
        Object manuBillNumber = ((DataToken)lineData.get((Object)"FEntry_manuBillNumber")).data;
        if (manuBillNumber != null && manuBillNumber.toString().trim().length() > 0 && manuBillNumber.toString().length() > 0) {
            entryInfo.setManuBillNumber(manuBillNumber.toString());
        }
        this.doRemark(lineData, entryInfo);
        this.doEntryAmountPriceField(ctx, entryInfo, lineData);
        this.doEntryFilesByRI(entryInfo);
        if ((entryInfo.getUnitActualCost().compareTo(ZERO) != 0 || entryInfo.getActualCost().compareTo(ZERO) != 0) && entryInfo.getQty() != null) {
            CompanyOrgUnitInfo couTemp;
            BigDecimal unitActualCost = entryInfo.getUnitActualCost();
            BigDecimal actualCost = entryInfo.getActualCost();
            BigDecimal qty = entryInfo.getQty();
            int localPrecision = 0;
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("baseCurrency.id"));
                sic.add(new SelectorItemInfo("baseCurrency.number"));
                sic.add(new SelectorItemInfo("baseCurrency.name"));
                sic.add(new SelectorItemInfo("baseCurrency.precision"));
                couTemp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.cou.getId().toString()), sic);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (couTemp != null) {
                localPrecision = couTemp.getBaseCurrency().getPrecision();
            }
            if (qty.multiply(unitActualCost).setScale(localPrecision, 4).compareTo(actualCost) != 0) {
                throw new TaskExternalException(ManufactureRecImport.getResource((Context)ctx, (String)"CANNOT_IMPORT_ACTUALPRICE", (String)RESOURCE));
            }
        }
        try {
            IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(entryInfo.getMaterial().getBaseUnit().getId());
            MeasureUnitInfo baseUnit = imu.getMeasureUnitInfo((IObjectPK)pk);
            entryInfo.setBaseUnit(baseUnit);
            BigDecimal qty = entryInfo.getQty();
            BigDecimal baseQty = InvAppUtils.getBaseUnitQty(ctx, entryInfo.getUnit(), baseUnit, entryInfo.getMaterial(), qty);
            entryInfo.setBaseQty(baseQty);
            MaterialCompanyInfoInfo materialCompanyInfo = this.getMaterialCompany(ctx, entryInfo.getMaterial(), this.cou);
            if (materialCompanyInfo != null) {
                BigDecimal standardCost = materialCompanyInfo.getStandardCost();
                if (standardCost != null) {
                    BigDecimal unitstandardcost = InvAppUtils.getUnitPrice(ctx, entryInfo.getMaterial(), standardCost, baseUnit, entryInfo.getUnit());
                    if (entryInfo.getQty() != null) {
                        BigDecimal standardcost = unitstandardcost.multiply(entryInfo.getQty());
                        entryInfo.setUnitStandardCost(unitstandardcost);
                        entryInfo.setStandardCost(standardcost);
                    }
                } else {
                    entryInfo.setUnitStandardCost(null);
                    entryInfo.setStandardCost(null);
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data;
        entryInfo.setProject(this.getProject(ctx, data, this.sou.getCU()));
        data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data;
        entryInfo.setTrackNumber(this.getTrackNumber(ctx, data, this.sou.getCU()));
        data = ((DataToken)lineData.get((Object)"FEntry$AdminOrgUnit1_number")).data;
        entryInfo.setAdminOrgUnit(this.getAdminOrgUnit(ctx, "number", data));
        this.doEntryInvUpdateType(ctx, lineData, entryInfo);
        try {
            this.checkQtyPrecision(ctx, entryInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return entryInfo;
    }

    private void doEntryAssistQty(Context ctx, Map lineData, ManufactureRecBillEntryInfo entryInfo) throws TaskExternalException {
        BigDecimal assistQty = entryInfo.getAssistQty();
        MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
        if (assistUnit != null && (entryInfo.getAssistQty() == null || entryInfo.getAssistQty().compareTo(ZERO) == 0)) {
            Object data = ((DataToken)lineData.get((Object)"FEntry_assistQty")).data;
            assistQty = DataImportUtils.getDataDeciaml((Context)ctx, (String)((String)data));
        }
        assistQty = assistQty == null ? BigDecimal.ZERO : assistQty;
        entryInfo.setAssistQty(assistQty);
    }

    private void doRemark(Map lineData, ManufactureRecBillEntryInfo entryInfo) throws TaskExternalException {
        Object o = ((DataToken)lineData.get((Object)"FEntry_remark")).data;
        if (o != null && o.toString().trim().length() > 0) {
            String remark = o.toString().trim();
            if (remark.length() > 255) {
                remark = remark.substring(0, 255);
            }
            entryInfo.setRemark(remark);
        }
    }

    private void doEntryUnit(Context ctx, Map lineData, ManufactureRecBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
        entryInfo.setUnit(this.getMeasureUnit(ctx, data, entryInfo.getMaterial()));
    }

    private void doEntryMfgExp(Context ctx, Map lineData, ManufactureRecBillEntryInfo entryInfo) throws TaskExternalException {
        Object mfg = ((DataToken)lineData.get((Object)"FEntry_mfg")).data;
        Object exp = ((DataToken)lineData.get((Object)"FEntry_exp")).data;
        Date[] mfgAndExp = this.getMfgAndExp(ctx, entryInfo.getMaterial(), entryInfo.getLot(), this.sou, mfg, exp);
        if (mfgAndExp != null) {
            entryInfo.setMfg(mfgAndExp[0]);
            entryInfo.setExp(mfgAndExp[1]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doEntryLot(Context ctx, Map lineData, ManufactureRecBillEntryInfo entryInfo) throws TaskExternalException {
        if (this.checkLotInfo(ctx, entryInfo.getMaterial(), this.sou)) {
            Object data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
            if (data == null || data.toString().trim().length() <= 0) throw new TaskExternalException(entryInfo.getMaterial().getNumber() + " " + ManufactureRecImport.getResource((Context)ctx, (String)"LotManager", (String)RESOURCE));
            entryInfo.setLot(data.toString().trim());
            return;
        } else {
            entryInfo.setLot(null);
        }
    }

    private void doEntryQty(Context ctx, Map lineData, ManufactureRecBillEntryInfo entryInfo) throws TaskExternalException {
        BigDecimal qty;
        Object data = ((DataToken)lineData.get((Object)"FEntry_qty")).data;
        if (data != null && data.toString().length() > 0) {
            qty = DataImportUtils.getDataDeciaml((Context)ctx, (String)data.toString());
            if (qty == null || qty.compareTo(ZERO) == 0) {
                throw new TaskExternalException(ManufactureRecImport.getResource((Context)ctx, (String)"QTY_NOT_ZERO", (String)RESOURCE));
            }
        } else {
            throw new TaskExternalException(ManufactureRecImport.getResource((Context)ctx, (String)"Numbercannotbenull", (String)RESOURCE));
        }
        entryInfo.setQty(qty);
    }

    private void doEntryMaterial(Context ctx, Map lineData, ManufactureRecBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
        entryInfo.setMaterial(this.getMaterial(ctx, data, new OrgUnitInfo[]{this.sou, this.cou}));
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo mmui = immu.getMultiUnit(materialInfo.getId().toString(), mui.getId().toString());
        if (mmui == null) {
            throw new TaskExternalException(materialInfo.getNumber() + ManufactureRecImport.getResource((Context)ctx, (String)"UnitNotExists", (String)RESOURCE));
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal qty;
            if (rs.getString("Number") != null) {
                result.put("FNumber", rs.getString("Number"));
            }
            if (rs.getString("BizDate") != null) {
                result.put("FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("BizDate")));
            }
            if (rs.getString("bizType.number") != null) {
                result.put("FBizType_number", rs.getString("bizType.number"));
            }
            if (rs.getString("bizType.name") != null) {
                result.put("FBizType_name_l2", rs.getString("bizType.name"));
            }
            if (rs.getString("TRANSACTIONTYPE.NUMBER") != null) {
                result.put("FTransactionType_number", rs.getString("TRANSACTIONTYPE.NUMBER"));
            }
            if (rs.getString("TRANSACTIONTYPE.NAME") != null) {
                result.put("FTransactionType_name_l2", rs.getString("TRANSACTIONTYPE.NAME"));
            }
            if (rs.getString("STORAGEORGUNIT.NUMBER") != null) {
                result.put("FStorageOrgUnit_number", rs.getString("STORAGEORGUNIT.NUMBER"));
            }
            if (rs.getString("STORAGEORGUNIT.NAME") != null) {
                result.put("FStorageOrgUnit_name_l2", rs.getString("STORAGEORGUNIT.NAME"));
            }
            if (rs.getString("COSTCENTERORGUNIT.NUMBER") != null) {
                result.put("FCostCenterOrgUnit_number", rs.getString("COSTCENTERORGUNIT.NUMBER"));
            }
            if (rs.getString("ADMINORGUNIT.NUMBER") != null) {
                result.put("FAdminOrgUnit_number", rs.getString("ADMINORGUNIT.NUMBER"));
            }
            if (rs.getString("MATERIAL.NUMBER") != null) {
                result.put("FEntry$material_number", rs.getString("MATERIAL.NUMBER"));
            }
            if (rs.getString("MATERIAL.NAME") != null) {
                result.put("FEntry$material_name_l2", rs.getString("MATERIAL.NAME"));
            }
            if (rs.getString("MATERIAL.MODEL") != null) {
                result.put("FEntry$material_model", rs.getString("MATERIAL.MODEL"));
            }
            if (rs.getString("ASSISTPROPERTY.NUMBER") != null) {
                result.put("FEntry$assistProperty_number", rs.getString("ASSISTPROPERTY.NUMBER"));
            }
            if (rs.getString("COSTOBJECT.NUMBER") != null) {
                result.put("FEntry$costObject_number", rs.getString("COSTOBJECT.NUMBER"));
            }
            if (rs.getString("COSTOBJECT.NAME") != null) {
                result.put("FEntry$costObject_name_l2", rs.getString("COSTOBJECT.NAME"));
            }
            if (rs.getString("ENTRY.LOT") != null) {
                result.put("FEntry_lot", rs.getString("ENTRY.LOT"));
            }
            if (rs.getString("ENTRY.MFG") != null) {
                result.put("FEntry_mfg", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.MFG")));
            }
            if (rs.getString("ENTRY.EXP") != null) {
                result.put("FEntry_exp", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.EXP")));
            }
            if (rs.getString("UNIT.NUMBER") != null) {
                result.put("FEntry$unit_number", rs.getString("UNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.QTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString().length() < 1) {
                    result.put("FEntry_qty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.QTY"));
                    result.put("FEntry_qty", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qty));
                }
            }
            if (rs.getString("ASSISTUNIT.NUMBER") != null) {
                result.put("FEntry$assistUnit_number", rs.getString("ASSISTUNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.ASSISTQTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString().length() < 1) {
                    result.put("FEntry_assistQty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.ASSISTQTY"));
                    result.put("FEntry_assistQty", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qty));
                }
            }
            if (rs.getString("WAREHOUSE.NUMBER") != null) {
                result.put("FEntry$warehouse_number", rs.getString("WAREHOUSE.NUMBER"));
            }
            if (rs.getString("STOCKER1.NUMBER") != null) {
                result.put("FEntry$stocker_number", rs.getString("STOCKER1.NUMBER"));
            }
            if (rs.getString("LOCATION.NUMBER") != null) {
                result.put("FEntry$location_number", rs.getString("LOCATION.NUMBER"));
            }
            if (rs.getString("ENTRY.actualCost") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.actualCost")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.actualCost")).toString().length() < 1) {
                    result.put("FEntry_actualCost", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.actualCost"));
                    result.put("FEntry_actualCost", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qty));
                }
            }
            if (rs.getString("ENTRY.UNITACTUALCOST") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.UNITACTUALCOST")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.UNITACTUALCOST")).toString().length() < 1) {
                    result.put("FEntry_unitActualCost", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.UNITACTUALCOST"));
                    result.put("FEntry_unitActualCost", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qty));
                }
            }
            if (rs.getString("Entry.manuBillNumber") != null) {
                result.put("FEntry_manuBillNumber", rs.getString("Entry.manuBillNumber"));
            }
            if (rs.getString("Entry.remark") != null) {
                result.put("FEntry_remark", rs.getString("Entry.remark"));
            }
            if (rs.getString("CreateTime") != null) {
                result.put("FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("CreateTime")));
            }
            if (rs.getString("Project.number") != null) {
                result.put("FEntry$project_number", rs.getString("Project.number"));
            }
            if (rs.getString("TrackNumber.number") != null) {
                result.put("FEntry$trackNumber_number", rs.getString("TrackNumber.number"));
            }
            if (rs.getString("description") != null) {
                result.put("FDescription", rs.getString("description"));
            }
            if (rs.getString("adminOrgUnit1.number") != null) {
                result.put("FEntry$AdminOrgUnit1_number", rs.getString("adminOrgUnit1.number"));
            }
            if (rs.getString("adminOrgUnit1.name") != null) {
                result.put("FEntry$AdminOrgUnit1_name", rs.getString("adminOrgUnit1.name"));
            }
            if (rs.getString("costCenterOrgUnit1.number") != null) {
                result.put("FEntry$CostCenterOrgUnit1_number", rs.getString("costCenterOrgUnit1.number"));
            }
            if (rs.getString("costCenterOrgUnit1.name") != null) {
                result.put("FEntry$CostCenterOrgUnit1_name", rs.getString("costCenterOrgUnit1.name"));
            }
            if (rs.getString("invUpdateType.number") != null) {
                result.put("FInvUpdateType_number", rs.getString("invUpdateType.number"));
            }
            if (rs.getString("invUpdateType.name") != null) {
                result.put("FInvUpdateType_name_l2", rs.getString("invUpdateType.name"));
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.ManufactureRecDataImportQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "manufacturerec_export");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException e) {
                    Logger.error((Throwable)e);
                }
            }
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return oldFilterInfo;
    }

    private boolean checkLotInfo(Context ctx, MaterialInfo materialInfo, Object data, StorageOrgUnitInfo sou, ManufactureRecBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        MaterialInventoryInfo materialInventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
        boolean isLotNumber = materialInventoryInfo.isIsLotNumber();
        if (!isLotNumber && data != null && data.toString().length() > 0) {
            return false;
        }
        if (isLotNumber && (data == null || data.toString().length() <= 0)) {
            throw new TaskExternalException(materialInfo.getNumber() + ManufactureRecImport.getResource((Context)ctx, (String)"LotManager", (String)RESOURCE));
        }
        return true;
    }

    public static Date getEXP(Date curDate, int unit, int unitValue) {
        if (curDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(curDate);
            int field = 5;
            switch (unit) {
                case 1: {
                    field = 1;
                    break;
                }
                case 2: {
                    field = 2;
                    break;
                }
                case 3: {
                    field = 5;
                    break;
                }
                default: {
                    field = 5;
                }
            }
            calendar.add(field, unitValue);
            return calendar.getTime();
        }
        return null;
    }

    private void doBizType(Context ctx, Map lineData) throws TaskExternalException {
        BizTypeInfo bizType;
        Object data = ((DataToken)lineData.get((Object)"FBizType_number")).data;
        try {
            bizType = this.getBizType(ctx, "50957179-0105-1000-e000-0167c0a812fd463ED552", "number", data);
        }
        catch (TaskExternalException numberException) {
            data = ((DataToken)lineData.get((Object)"FBizType_name_l2")).data;
            try {
                bizType = this.getBizType(ctx, "50957179-0105-1000-e000-0167c0a812fd463ED552", "name", data);
            }
            catch (TaskExternalException nameException) {
                throw numberException;
            }
        }
        this.manufactureRecBillInfo.setBizType(bizType);
    }

    private void doTransactionType(Context ctx, Map lineData) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FTransactionType_number")).data;
        try {
            this.tti = this.getTransaction(ctx, "number", data, "50957179-0105-1000-e000-0167c0a812fd463ED552", this.manufactureRecBillInfo.getBizType());
        }
        catch (TaskExternalException numberException) {
            data = ((DataToken)lineData.get((Object)"FTransactionType_name_l2")).data;
            try {
                this.tti = this.getTransaction(ctx, "name", data, "50957179-0105-1000-e000-0167c0a812fd463ED552", this.manufactureRecBillInfo.getBizType());
            }
            catch (TaskExternalException nameException) {
                throw numberException;
            }
        }
        this.manufactureRecBillInfo.setTransactionType(this.tti);
    }

    public static BigDecimal getBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty, Context ctx) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            MultiMeasureUnitInfo mulUnit = ManufactureRecImport.getMulUnit(mui, mi, ctx);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = ManufactureRecImport.getMulUnit(baseUnit, mi, ctx);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException e) {
            Logger.error((Throwable)e, (String)e.getMessage());
            return null;
        }
    }

    public static MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi, Context ctx) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    private void doEntryAmountPriceField(Context ctx, ManufactureRecBillEntryInfo entryInfo, Map lineData) {
        for (int i = 0; i < DECIMAL_ENTRY_PROPERTY_ALL.length; ++i) {
            BigDecimal value;
            Object o = ((DataToken)lineData.get((Object)ManufactureRecImport.DECIMAL_ENTRY_PROPERTY_ALL[i])).data;
            try {
                o = o == null || o.toString().equals("") ? null : o;
                value = DataImportUtils.getDataDeciaml((Context)ctx, (String)(o == null ? null : o.toString()));
            }
            catch (Exception e) {
                continue;
            }
            entryInfo.put(DECIMAL_ENTRY_PROPERTY_ALL_KEY[i], value.abs());
        }
    }

    private void doEntryFilesByRI(ManufactureRecBillEntryInfo entryInfo) {
        String entryField2 = null;
        BigDecimal value = null;
        for (String entryField2 : ENTRY_PRICE_FIELDS) {
            if (entryInfo.get(entryField2) == null) continue;
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs());
        }
        boolean flag = !InvAppUtils.isNegative(this.manufactureRecBillInfo.getTransactionType());
        for (String entryField2 : ENTRY_QTY_AMOUNT_FIELDS) {
            if (entryInfo.get(entryField2) == null) continue;
            if (flag) {
                value = (BigDecimal)entryInfo.get(entryField2);
                entryInfo.put(entryField2, value.abs());
                continue;
            }
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs().negate());
        }
    }

    private void doEntryInvUpdateType(Context ctx, Map lineData, ManufactureRecBillEntryInfo entryInfo) throws TaskExternalException {
        InvUpdateTypeInfo invUpdateType;
        Object data = ((DataToken)lineData.get((Object)"FInvUpdateType_number")).data;
        try {
            invUpdateType = this.getInvUpdateType(ctx, "number", this.manufactureRecBillInfo.getTransactionType(), data);
        }
        catch (TaskExternalException numberException) {
            data = ((DataToken)lineData.get((Object)"FInvUpdateType_name_l2")).data;
            try {
                invUpdateType = this.getInvUpdateType(ctx, "name", this.manufactureRecBillInfo.getTransactionType(), data);
            }
            catch (TaskExternalException nameException) {
                throw numberException;
            }
        }
        entryInfo.setInvUpdateType(invUpdateType);
    }

    public String getImportPermissionItem() {
        return "manufacturerec_new";
    }

    protected String[] getLocalAmountFields() {
        return new String[]{"standardCost", "actualCost"};
    }

    protected String[] getPriceFields() {
        return new String[]{"unitStandardCost", "unitActualCost"};
    }
}

