/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractManufactureRecWebFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManufactureRecWebFacadeControllerBean
extends AbstractManufactureRecWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.ManufactureRecWebFacadeControllerBean");

    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManufactureRecBillInfo billInfo = (ManufactureRecBillInfo)model;
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        Timestamp serverDate = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        billInfo.setBizDate(serverDate);
        billInfo.setAuditTime(null);
        billInfo.setCreateTime(serverDate);
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        billInfo.setCreator(aUserInfo);
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0167c0a812fd463ED552"));
        billInfo.setBillType(aBillTypeInfo);
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo(null, (String)"Nz878AEgEADgAABFwKg/GiQHQ1w=", (String)"50957179-0105-1000-e000-0167c0a812fd463ED552");
        billInfo.setBizType(bizType);
        if (bizType != null) {
            TransactionTypeInfo tti = InvCommonUtils.getDefaultTransactionType(null, "50957179-0105-1000-e000-0167c0a812fd463ED552", bizType.getId().toString());
            billInfo.setTransactionType(tti);
        }
        StorageOrgUnitInfo sou = null;
        sou = billInfo.getStorageOrgUnit() != null ? billInfo.getStorageOrgUnit() : (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "manufacturerec_new");
        if (sou == null) {
            return billInfo;
        }
        if (sou.getCU() != null) {
            billInfo.setCU(sou.getCU());
        }
        billInfo.setStorageOrgUnit(sou);
        ManufactureRecBillEntryInfo entryInfo = (ManufactureRecBillEntryInfo)this.createNewDetailData(ctx);
        if (billInfo.getTransactionType() != null) {
            InvUpdateTypeInfo invUpdateTypeInfo = InvCommonUtils.getDefaultInvUpdateType("50957179-0105-1000-e000-0167c0a812fd463ED552", billInfo.getTransactionType());
            entryInfo.setInvUpdateType(invUpdateTypeInfo);
        }
        billInfo.getEntry().add(entryInfo);
        return billInfo;
    }

    public IObjectValue createNewDetailData(Context context) throws BOSException, EASBizException {
        ManufactureRecBillEntryInfo entryInfo = new ManufactureRecBillEntryInfo();
        entryInfo.setBaseStatus(EntryBaseStatusEnum.NULL);
        return entryInfo;
    }

    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ManufactureRecBillInfo info = (ManufactureRecBillInfo)model;
        String storageOrgFilter = this.getMainOrgFilter(ctx);
        map.put("storageOrgFilter", storageOrgFilter);
        if (info.getStorageOrgUnit() == null) {
            return map;
        }
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(info.getStorageOrgUnit().getId().toString());
        map.put("bizOrgCUID", bizOrgCUID);
        CompanyOrgUnitInfo cou = null;
        cou = this.getCouBySou(ctx, info.getStorageOrgUnit().getId().toString());
        map.put("cou", cou);
        map.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        Map paramMap = this.getParamsMap(ctx, info.getStorageOrgUnit().getId().toString(), cou.getId().toString());
        map.put("params", paramMap);
        if (info.getBaseStatus() == BillBaseStatusEnum.ADD && info.getTransactionType() != null && info.getTransactionType().getRiType() != null) {
            SelectorItemCollection selector = SCMSelectorFactory.getTransactionTypeSelector((boolean)false);
            TransactionTypeInfo transactionTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(info.getTransactionType().getId()), selector);
            info.setTransactionType(transactionTypeInfo);
        }
        info.setCU(info.getStorageOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new ManufactureRecBillInfo(), info.getStorageOrgUnit().getId().toString());
        if (ruleInfo != null) {
            map.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                map.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getStorageOrgUnit().getId().toString()));
            }
        }
        if (info.getSourceBillType() != null && info.getBaseStatus() == BillBaseStatusEnum.ADD) {
            ManufactureRecBillEntryInfo entry = null;
            ManufactureRecBillEntryCollection entryColl = info.getEntry();
            if (entryColl != null && entryColl.size() > 0) {
                for (int i = 0; i < entryColl.size(); ++i) {
                    entry = entryColl.get(i);
                    if (entry == null || entry.getMaterial() == null) continue;
                    IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                    MaterialInfo material = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(entry.getMaterial().getId().toString()));
                    entry.setMaterial(material);
                }
            }
        }
        HashSet contractNumberSet = new HashSet();
        HashSet sendAddressInfoSet = new HashSet();
        HashMap entryParamMap = new HashMap();
        map.put("entryParamMap", entryParamMap);
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        map.put("currentPeriodinfo", currentPeriodinfo);
        boolean costManageIsStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.COSTMANAGEMENT, (CompanyOrgUnitInfo)cou);
        map.put("costManageIsStart", costManageIsStart);
        return map;
    }

    public String getPermissionItem() {
        return "manufacturerec_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    private Map getParamsMap(Context ctx, String souId, String couId) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map souParamMap = this.batchGetParamValue(ctx, souId, new String[]{"INM004", "INM100", "INM008"});
        paramMap.putAll(souParamMap);
        Map couParamMap = this.batchGetParamValue(ctx, couId, new String[]{"CONSIGNSALES", "AR_032"});
        paramMap.putAll(couParamMap);
        Map noOrgParamMap = this.batchGetParamValue(ctx, null, new String[]{"DISCOUNTRATEPRECISION"});
        paramMap.putAll(noOrgParamMap);
        return paramMap;
    }

    protected Map _handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        return super._handleMainOrgChange(ctx, mainOrgId);
    }

    public IObjectValue createNewData(Context context, IObjectValue model) throws BOSException, EASBizException {
        return super.createNewData(context, model);
    }

    protected Map _handleBillByCopy(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        return super._handleBillByCopy(ctx, info);
    }

    protected Map _handleBillByOprtState(Context ctx, String billId, String oprtState) throws BOSException, EASBizException {
        return super._handleBillByOprtState(ctx, billId, oprtState);
    }

    @Override
    protected Map _getDataForOrgChange(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        String orgId = (String)requestMap.get("orgId");
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, orgId);
        if (cou == null) {
            return responseMap;
        }
        responseMap.put("cou", cou);
        responseMap.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        responseMap.put("exchangeRateColl", this.getExchangeRateCollByCou(ctx, cou.getId().toString()));
        SaleOrgUnitInfo saleOu = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getSaleOrgByStorageOrg(orgId);
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(orgId);
        responseMap.put("bizOrgCUID", bizOrgCUID);
        responseMap.put("params", this.getParamsMap(ctx, orgId, cou.getId().toString()));
        HashMap<String, Map> entryParamMap = new HashMap<String, Map>();
        if (saleOu != null) {
            entryParamMap.put(saleOu.getId().toString(), this.batchGetParamValue(ctx, saleOu.getId().toString(), new String[]{"SALEBILL001"}));
        }
        responseMap.put("entryParamMap", entryParamMap);
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        responseMap.put("currentPeriodinfo", currentPeriodinfo);
        ManufactureRecBillInfo info = new ManufactureRecBillInfo();
        StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        info.setStorageOrgUnit(sou);
        info.setCU(sou.getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, orgId);
        if (ruleInfo != null) {
            responseMap.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (ruleInfo.isIsAddView()) {
                responseMap.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)info, orgId));
            }
        }
        return responseMap;
    }

    private void _handleCostCenterOrgUnit() {
    }
}

