/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.im.dt.DtTempFacadeFactory;
import com.kingdee.eas.scm.im.dt.IDtTempFacade;
import com.kingdee.eas.scm.im.inv.IOtherInWarehsBill;
import com.kingdee.eas.scm.im.inv.IOtherIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MatAssembleAfterEntryCollection;
import com.kingdee.eas.scm.im.inv.MatAssembleAfterEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleBeforeEntryCollection;
import com.kingdee.eas.scm.im.inv.MatAssembleBeforeEntryFactory;
import com.kingdee.eas.scm.im.inv.MatAssembleBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMatAssembleBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MatAssembleBillControllerBean
extends AbstractMatAssembleBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MatAssembleBillControllerBean");

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = super.getSelector();
        sic.add(new SelectorItemInfo("entry.processCharge"));
        sic.add(new SelectorItemInfo("entry.storeType.id"));
        sic.add(new SelectorItemInfo("entry.storeType.name"));
        sic.add(new SelectorItemInfo("entry.storeType.number"));
        sic.add(new SelectorItemInfo("entry.storeType.storeFlag"));
        sic.add(new SelectorItemInfo("entry.storeStatus.id"));
        sic.add(new SelectorItemInfo("entry.storeStatus.name"));
        sic.add(new SelectorItemInfo("entry.storeStatus.number"));
        sic.add(new SelectorItemInfo("entry.customer.id"));
        sic.add(new SelectorItemInfo("entry.customer.name"));
        sic.add(new SelectorItemInfo("entry.customer.number"));
        sic.add(new SelectorItemInfo("entry.supplier.id"));
        sic.add(new SelectorItemInfo("entry.supplier.name"));
        sic.add(new SelectorItemInfo("entry.supplier.number"));
        sic.add(new SelectorItemInfo("entry.entry1.id"));
        sic.add(new SelectorItemInfo("entry.entry1.material.id"));
        sic.add(new SelectorItemInfo("entry.entry1.material.name"));
        sic.add(new SelectorItemInfo("entry.entry1.material.number"));
        sic.add(new SelectorItemInfo("entry.entry1.material.model"));
        sic.add(new SelectorItemInfo("entry.entry1.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.entry1.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("entry.entry1.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("entry.entry1.material.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.entry1.material.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.entry1.material.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.entry1.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entry.entry1.material.seqUnit"));
        sic.add(new SelectorItemInfo("entry.entry1.material.assistAttr"));
        sic.add(new SelectorItemInfo("entry.entry1.material.materialGroup.id"));
        sic.add(new SelectorItemInfo("entry.entry1.material.materialGroup.name"));
        sic.add(new SelectorItemInfo("entry.entry1.material.materialGroup.number"));
        sic.add(new SelectorItemInfo("entry.entry1.assistProperty.id"));
        sic.add(new SelectorItemInfo("entry.entry1.assistProperty.name"));
        sic.add(new SelectorItemInfo("entry.entry1.assistProperty.number"));
        sic.add(new SelectorItemInfo("entry.entry1.lot"));
        sic.add(new SelectorItemInfo("entry.entry1.mfg"));
        sic.add(new SelectorItemInfo("entry.entry1.exp"));
        sic.add(new SelectorItemInfo("entry.entry1.project.id"));
        sic.add(new SelectorItemInfo("entry.entry1.project.name"));
        sic.add(new SelectorItemInfo("entry.entry1.project.number"));
        sic.add(new SelectorItemInfo("entry.entry1.trackNumber.id"));
        sic.add(new SelectorItemInfo("entry.entry1.trackNumber.name"));
        sic.add(new SelectorItemInfo("entry.entry1.trackNumber.number"));
        sic.add(new SelectorItemInfo("entry.entry1.unitQty"));
        sic.add(new SelectorItemInfo("entry.entry1.unit.id"));
        sic.add(new SelectorItemInfo("entry.entry1.unit.name"));
        sic.add(new SelectorItemInfo("entry.entry1.unit.number"));
        sic.add(new SelectorItemInfo("entry.entry1.qty"));
        sic.add(new SelectorItemInfo("entry.entry1.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.entry1.baseUnit.name"));
        sic.add(new SelectorItemInfo("entry.entry1.baseUnit.number"));
        sic.add(new SelectorItemInfo("entry.entry1.baseQty"));
        sic.add(new SelectorItemInfo("entry.entry1.assCoefficient"));
        sic.add(new SelectorItemInfo("entry.entry1.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.entry1.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.entry1.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.entry1.assistQty"));
        sic.add(new SelectorItemInfo("entry.entry1.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.entry1.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.entry1.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.entry1.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.entry1.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.entry1.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.entry1.warehouse.id"));
        sic.add(new SelectorItemInfo("entry.entry1.warehouse.name"));
        sic.add(new SelectorItemInfo("entry.entry1.warehouse.number"));
        sic.add(new SelectorItemInfo("entry.entry1.location.id"));
        sic.add(new SelectorItemInfo("entry.entry1.location.name"));
        sic.add(new SelectorItemInfo("entry.entry1.location.number"));
        sic.add(new SelectorItemInfo("entry.entry1.stocker.id"));
        sic.add(new SelectorItemInfo("entry.entry1.stocker.name"));
        sic.add(new SelectorItemInfo("entry.entry1.stocker.number"));
        sic.add(new SelectorItemInfo("entry.entry1.storeType.id"));
        sic.add(new SelectorItemInfo("entry.entry1.storeType.name"));
        sic.add(new SelectorItemInfo("entry.entry1.storeType.number"));
        sic.add(new SelectorItemInfo("entry.entry1.storeType.storeFlag"));
        sic.add(new SelectorItemInfo("entry.entry1.storeStatus.id"));
        sic.add(new SelectorItemInfo("entry.entry1.storeStatus.name"));
        sic.add(new SelectorItemInfo("entry.entry1.storeStatus.number"));
        sic.add(new SelectorItemInfo("entry.entry1.customer.id"));
        sic.add(new SelectorItemInfo("entry.entry1.customer.name"));
        sic.add(new SelectorItemInfo("entry.entry1.customer.number"));
        sic.add(new SelectorItemInfo("entry.entry1.supplier.id"));
        sic.add(new SelectorItemInfo("entry.entry1.supplier.name"));
        sic.add(new SelectorItemInfo("entry.entry1.supplier.number"));
        sic.add(new SelectorItemInfo("entry.entry1.sourceBillNumber"));
        sic.add(new SelectorItemInfo("entry.entry1.sourceBillEntrySeq"));
        sic.add(new SelectorItemInfo("entry.entry1.sourceBillType.id"));
        sic.add(new SelectorItemInfo("entry.entry1.sourceBillType.name"));
        sic.add(new SelectorItemInfo("entry.entry1.sourceBillType.number"));
        sic.add(new SelectorItemInfo("entry.entry1.remark"));
        sic.add(new SelectorItemInfo("entry.entry1.seq"));
        return sic;
    }

    protected void buildMatCostObjectMap(Context ctx, HashMap<String, MatCostObject> matCostObjMap, InvBillBaseEntryInfo entry, boolean isIssueEntry) {
        String sourceEntryID = entry.getSourceBillEntryId();
        MatCostObject vo = matCostObjMap.get(sourceEntryID);
        if (vo == null) {
            vo = new MatCostObject(ctx, sourceEntryID);
        }
        if (isIssueEntry) {
            vo.addIssueEntry(entry);
        } else {
            vo.addInWarehsEntry(entry);
        }
        matCostObjMap.put(sourceEntryID, vo);
    }

    public void updateMaterialSerialNumber(Context ctx, InvBillBaseInfo matAttrInfo, InvBillBaseInfo otherInfo, String otherBillTypeID, String matBillTypeID) throws BOSException, EASBizException {
        try {
            IObjectCollection entryOtherColl = (IObjectCollection)otherInfo.get("entry");
            InvBillBaseEntryInfo entryOtherInfo = null;
            HashSet<String> entrySet = new HashSet<String>();
            IObjectCollection entryMatColl = (IObjectCollection)matAttrInfo.get("entry");
            InvBillBaseEntryInfo entryBeforeInfo = null;
            for (int i = 0; i < entryOtherColl.size(); ++i) {
                entryBeforeInfo = (InvBillBaseEntryInfo)entryMatColl.getObject(i);
                if (otherInfo instanceof OtherIssueBillInfo) {
                    entrySet.add(entryBeforeInfo.getId().toString());
                    continue;
                }
                IObjectCollection entryAfterColl = (IObjectCollection)entryBeforeInfo.get("entry1");
                for (int j = 0; j < entryAfterColl.size(); ++j) {
                    InvBillBaseEntryInfo entryAfterInfo = (InvBillBaseEntryInfo)entryAfterColl.getObject(j);
                    for (int k = 0; k < entryOtherColl.size(); ++k) {
                        entryOtherInfo = (InvBillBaseEntryInfo)entryOtherColl.getObject(k);
                        if (!entryOtherInfo.getSourceBillEntryId().toString().equals(entryBeforeInfo.getId().toString())) continue;
                        entrySet.add(entryAfterInfo.getId().toString());
                    }
                }
            }
            if (matAttrInfo != null && matAttrInfo.getBillType() != null && matAttrInfo.getNumber() != null && entrySet != null && entrySet.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)matAttrInfo.getBillType().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("billId", (Object)matAttrInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("billNumber", (Object)matAttrInfo.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("billEntryId", entrySet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                MaterialSerialNumberCollection msnCol = MaterialSerialNumberFactory.getLocalInstance(ctx).getMaterialSerialNumberCollection(viewInfo);
                if (msnCol != null && msnCol.size() > 0) {
                    MaterialSerialNumberInfo msnInfo = null;
                    MaterialSerialNumberEntryInfo entryInfo = null;
                    HashMap<String, MaterialSerialNumberInfo> map = new HashMap<String, MaterialSerialNumberInfo>();
                    int col = msnCol.size();
                    for (int i = 0; i < col; ++i) {
                        msnInfo = msnCol.get(i);
                        if (msnInfo == null) continue;
                        msnInfo.setId(BOSUuid.create((BOSObjectType)msnInfo.getBOSType()));
                        msnInfo.setBillType(otherInfo.getBillType());
                        msnInfo.setBillID(otherInfo.getId().toString());
                        msnInfo.setBillNumber(otherInfo.getNumber());
                        if (msnInfo.getEntry() != null) {
                            int count = msnInfo.getEntry().size();
                            for (int j = 0; j < count; ++j) {
                                entryInfo = msnInfo.getEntry().get(j);
                                entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                                entryInfo.setParent(msnInfo);
                            }
                        }
                        map.put(msnInfo.getBillEntryID(), msnInfo);
                    }
                    CoreBaseCollection coll = new CoreBaseCollection();
                    for (int i = 0; i < entryOtherColl.size(); ++i) {
                        entryBeforeInfo = (InvBillBaseEntryInfo)entryMatColl.getObject(i);
                        if (otherInfo instanceof OtherIssueBillInfo) {
                            entryOtherInfo = (InvBillBaseEntryInfo)entryOtherColl.getObject(i);
                            if (entryBeforeInfo.getId() == null || !map.containsKey(entryBeforeInfo.getId().toString()) || (msnInfo = (MaterialSerialNumberInfo)map.get(entryBeforeInfo.getId().toString())) == null) continue;
                            msnInfo.setBillEntryID(entryOtherInfo.getId().toString());
                            coll.addObject((IObjectValue)msnInfo);
                            continue;
                        }
                        IObjectCollection entryAfterColl = (IObjectCollection)entryBeforeInfo.get("entry1");
                        for (int j = 0; j < entryAfterColl.size(); ++j) {
                            InvBillBaseEntryInfo entryAfterInfo = (InvBillBaseEntryInfo)entryAfterColl.getObject(j);
                            for (int k = 0; k < entryOtherColl.size(); ++k) {
                                entryOtherInfo = (InvBillBaseEntryInfo)entryOtherColl.getObject(k);
                                if (entryOtherInfo.getSourceBillEntryId() == null || !map.containsKey(entryAfterInfo.getId().toString()) || !entryOtherInfo.getSourceBillEntryId().toString().equals(entryBeforeInfo.getId().toString()) || (msnInfo = (MaterialSerialNumberInfo)map.get(entryAfterInfo.getId().toString())) == null) continue;
                                msnInfo.setBillEntryID(entryOtherInfo.getId().toString());
                                coll.addObject((IObjectValue)msnInfo);
                            }
                        }
                    }
                    MaterialSerialNumberFactory.getLocalInstance(ctx).addnew(coll);
                }
            }
        }
        catch (Exception e) {
            throw new InvBizException(InvBizException.IDCARD_INVALID);
        }
    }

    private void updateDateOfMinDurability(Context ctx, String id, BillBaseStatusEnum status) throws BOSException, EASBizException {
        String rt = " \r\n";
        StringBuffer strSQL = new StringBuffer();
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance(ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
        if (status.getValue() == 4) {
            strSQL.append(" update T_IM_DateOfMinDurability as t1 set (FMfg,FExp)= (").append(rt);
            strSQL.append(" select FMfg,FExp from T_IM_MatDisassembleAfterEntry t2 where  ").append(rt);
            strSQL.append(" t2.FLot is not null and t2.FParentID ").append(rt);
            strSQL.append(" in(select entry.FID from T_IM_MatDisassembleBeforeEntry entry, T_IM_MatAssembleBill bill  ").append(rt);
            strSQL.append(" where entry.FParentID=bill.FID and bill.FID='" + id + "'").append(rt);
            strSQL.append(" and entry.FSeq in ( ").append(rt);
            strSQL.append(" select FSeq from(select entry.FStorageOrgUnitID,entry.FLot,entry.FMaterialID, max(entry.FSeq) FSeq  ").append(rt);
            strSQL.append(" from T_IM_MatDisassembleBeforeEntry entry inner join T_IM_MatAssembleBill bill  ").append(rt);
            strSQL.append(" on entry.FParentID=bill.FID and bill.FID='" + id + "'").append(rt);
            strSQL.append(" group by entry.FStorageOrgUnitID,entry.FLot,entry.FMaterialID) a ").append(rt);
            strSQL.append(" ) )  ").append(rt);
            strSQL.append(" and t1.FStorageOrgUnitID=t2.FStorageOrgUnitID and ").append(rt);
            strSQL.append(" t1.FMaterialID=t2.FMaterialID and t1.FLot=t2.FLot) ").append(rt);
        } else {
            strSQL.append(" update T_IM_DateOfMinDurability as t1 set (FMfg,FExp)= (").append(rt);
            strSQL.append(" select FMfg,FExp from T_IM_MatDisassembleBeforeEntry t2 where  ").append(rt);
            strSQL.append(" t2.FLot is not null and t2.FParentID ").append(rt);
            strSQL.append(" in (select bill.FID from T_IM_MatAssembleBill bill  ").append(rt);
            strSQL.append(" where bill.FID='" + id + "'").append(rt);
            strSQL.append(" ) and t2.FSeq in ( ").append(rt);
            strSQL.append(" select FSeq from(select entry.FStorageOrgUnitID,entry.FLot,entry.FMaterialID, max(entry.FSeq) FSeq  ").append(rt);
            strSQL.append(" from T_IM_MatDisassembleBeforeEntry entry inner join T_IM_MatAssembleBill bill  ").append(rt);
            strSQL.append(" on entry.FParentID=bill.FID and bill.FID='" + id + "'").append(rt);
            strSQL.append(" group by entry.FStorageOrgUnitID,entry.FLot,entry.FMaterialID) a ").append(rt);
            strSQL.append(" )  ").append(rt);
            strSQL.append(" and t1.FStorageOrgUnitID=t2.FStorageOrgUnitID and ").append(rt);
            strSQL.append(" t1.FMaterialID=t2.FMaterialID and t1.FLot=t2.FLot) ").append(rt);
        }
        if (paramMap.get("isCloseInsertLot") == null || !((Boolean)paramMap.get("isCloseInsertLot")).booleanValue()) {
            DbUtil.execute((Context)ctx, (String)strSQL.toString());
        }
    }

    public Map<String, MaterialSerialNumberInfo> getMaterialSerialNumber(Context ctx, MatAssembleBillInfo matAssembleBillInfo, IObjectCollection entryColl) throws BOSException {
        HashMap<String, MaterialSerialNumberInfo> map = new HashMap<String, MaterialSerialNumberInfo>();
        if (matAssembleBillInfo == null || matAssembleBillInfo.getId() == null) {
            return map;
        }
        String billID = matAssembleBillInfo.getId().toString();
        HashSet<String> entryIdSet = new HashSet<String>();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        MatAssembleBeforeEntryInfo beforeEntryInfo = null;
        MatAssembleAfterEntryInfo afterEntryInfo = null;
        MatAssembleAfterEntryCollection afterEntryColl = null;
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                beforeEntryInfo = (MatAssembleBeforeEntryInfo)entryColl.getObject(i);
                if (beforeEntryInfo != null && beforeEntryInfo.getId() != null) {
                    entryIdSet.add(beforeEntryInfo.getId().toString());
                }
                if ((afterEntryColl = beforeEntryInfo.getEntry1()) == null) continue;
                for (int j = 0; j < afterEntryColl.size(); ++j) {
                    if (afterEntryColl.get(j) == null || afterEntryColl.get(j).getId() == null) continue;
                    afterEntryInfo = afterEntryColl.get(j);
                    entryIdSet.add(afterEntryInfo.getId().toString());
                }
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        filter.getFilterItems().add(new FilterItemInfo("billEntryID", entryIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("snQty", (Object)BigDecimal.ZERO, CompareType.GREATER));
        ev.setFilter(filter);
        MaterialSerialNumberCollection snColl = MaterialSerialNumberFactory.getLocalInstance(ctx).getMaterialSerialNumberCollection(ev);
        MaterialSerialNumberInfo msnInfo = null;
        String billEntryId = null;
        if (snColl != null && snColl.size() > 0) {
            for (int i = 0; i < snColl.size(); ++i) {
                msnInfo = snColl.get(i);
                billEntryId = msnInfo.getBillEntryID();
                map.put(billEntryId, msnInfo);
            }
        }
        return map;
    }

    protected boolean isSerial(Context ctx, MaterialInfo material, MeasureUnitInfo kdUnitInfo, StorageOrgUnitInfo sou) throws EASBizException, BOSException {
        boolean isSerial = false;
        MaterialInventoryInfo invInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(material.getId().toString(), sou.getId().toString());
        if (invInfo != null && invInfo.isIsSequenceNo() && material.getSeqUnit() != null && kdUnitInfo != null && material.getSeqUnit().getId().equals((Object)kdUnitInfo.getId())) {
            isSerial = true;
        }
        return isSerial;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSubmitCheckSerialNumber(ctx, (MatAssembleBillInfo)model);
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    private void beforeSubmitCheckSerialNumber(Context ctx, MatAssembleBillInfo model) throws BOSException, EASBizException {
        MatAssembleBillInfo info = model;
        StorageOrgUnitInfo storageOrgUnit = info.getStorageOrgUnit();
        if (!InvCommonUtils.isSerialRequired(storageOrgUnit.getId().toString(), ctx).booleanValue()) {
            return;
        }
        String resource = "com.kingdee.eas.scm.im.inv.MatAssembleResource";
        MatAssembleBeforeEntryCollection coll = info.getEntry();
        Map<String, MaterialSerialNumberInfo> map = this.getMaterialSerialNumber(ctx, info, (IObjectCollection)coll);
        MatAssembleAfterEntryCollection afterColl = null;
        MatAssembleBeforeEntryInfo beforeEntryInfo = null;
        MatAssembleAfterEntryInfo afterEntryInfo = null;
        boolean isSerialNumber = false;
        StringBuffer sbSN = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            beforeEntryInfo = coll.get(i);
            if (beforeEntryInfo.getMaterial() != null && beforeEntryInfo.getUnit() != null && this.isSerial(ctx, beforeEntryInfo.getMaterial(), beforeEntryInfo.getUnit(), storageOrgUnit) && (beforeEntryInfo.getId() == null || map.get(beforeEntryInfo.getId().toString()) == null)) {
                sbSN.append(ResourceUtil.getMessage((String)resource, (String)"BEFORECHANGE_SERIL_RES", (String[])new String[]{String.valueOf(i + 1), beforeEntryInfo.getMaterial().getNumber()})).append("\r\n");
            }
            afterColl = beforeEntryInfo.getEntry1();
            for (int j = 0; j < afterColl.size(); ++j) {
                afterEntryInfo = afterColl.get(j);
                if (afterEntryInfo.getMaterial() == null || afterEntryInfo.getUnit() == null || !this.isSerial(ctx, afterEntryInfo.getMaterial(), afterEntryInfo.getUnit(), storageOrgUnit) || afterEntryInfo.getId() != null && map.get(afterEntryInfo.getId().toString()) != null) continue;
                sbSN.append(ResourceUtil.getMessage((String)resource, (String)"AFTERCHANGE_RES", (String[])new String[]{String.valueOf(i + 1), String.valueOf(j + 1), afterEntryInfo.getMaterial().getNumber()})).append("\r\n");
            }
        }
        if (sbSN.toString().length() > 0) {
            throw new BOSException(sbSN.toString());
        }
    }

    @Override
    protected void checkUnPassAduit(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        if (aInvBillBaseInfo.getBaseStatus() != null && aInvBillBaseInfo.getBaseStatus().getValue() != 4) {
            throw new SCMBillException(SCMBillException.CHECK_UNAUDIT, new Object[]{aInvBillBaseInfo.getString("number"), ""});
        }
        this._checkUnAuditInParam(ctx, (IObjectValue)aInvBillBaseInfo);
        if (aInvBillBaseInfo.isIsReversed()) {
            throw new SCMBillException(SCMBillException.ISREVERSED_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
        this._checkIsVouchered(ctx, (IObjectValue)aInvBillBaseInfo, true);
        if (!(aInvBillBaseInfo instanceof MaterialRequestBillInfo) && !aInvBillBaseInfo.isIsInitBill()) {
            this._checkBizDate(ctx, (IObjectValue)aInvBillBaseInfo);
        }
        this.isSamePerson4UnAudit(ctx, aInvBillBaseInfo);
    }

    public String getOtherID(Context ctx, String sourceBillID, String billTbl, String billEntryTbl) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT OIS.FID FROM " + billTbl + " OIS, " + billEntryTbl + " OISE ");
        sql.append(" WHERE OIS.FID = OISE.FPARENTID AND OISE.Fsourcebillid = ? ");
        String otherID = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = conn.prepareStatement(sql.toString());
            pstm.setString(1, sourceBillID);
            rs = pstm.executeQuery();
            if (rs.next()) {
                otherID = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)conn);
        return otherID;
    }

    public void unAuditDelOther(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof MatAssembleBillInfo) {
            ArrayList<String> idList = new ArrayList<String>();
            MatAssembleBillInfo billInfo = (MatAssembleBillInfo)model;
            IOtherInWarehsBill iInWarehs = OtherInWarehsBillFactory.getLocalInstance(ctx);
            String inWarehsID = this.getOtherID(ctx, billInfo.getId().toString(), "T_IM_OTHERINWAREHSBILL", "T_IM_OTHERINWAREHSBILLENTRY");
            if (!StringUtils.isEmpty((String)inWarehsID)) {
                idList.add(inWarehsID);
                iInWarehs.unAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inWarehsID)));
                iInWarehs.deleteNocheck((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inWarehsID)));
                this.delCostAdjustBill(ctx, inWarehsID);
            }
            IOtherIssueBill iIssue = OtherIssueBillFactory.getLocalInstance(ctx);
            String isSueID = this.getOtherID(ctx, billInfo.getId().toString(), "T_IM_OTHERISSUEBILL", "T_IM_OTHERISSUEBILLENTRY");
            if (!StringUtils.isEmpty((String)isSueID)) {
                idList.add(isSueID);
                iIssue.unAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)isSueID)));
                iIssue.deleteNocheck((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)isSueID)));
            }
            if (billInfo.getBizType().getId().toString().equals("CJeXjSzsKhfgU0ETqMA1niQHQ1w=")) {
                this.updateDateOfMinDurability(ctx, ((InvBillBaseInfo)model).getId().toString(), BillBaseStatusEnum.SUBMITED);
            }
            if (idList != null && idList.size() > 0) {
                this.deleteMaterialSerialByUnAudit(ctx, idList);
            }
        }
    }

    private void deleteMaterialSerialByUnAudit(Context ctx, List idList) throws BOSException {
        if (idList != null && idList.size() > 0) {
            Connection conn = this.getConnection(ctx);
            Statement batchStatment = null;
            try {
                String ids = InvServerUtils.getInStringFromList(idList);
                batchStatment = conn.createStatement();
                StringBuffer sql = new StringBuffer();
                sql.append("delete from T_IV_MaterialSerialNumberEntry where fparentid in (select fid from ");
                sql.append("T_IV_MaterialSerialNumber where FBillId in ").append(ids).append(" )");
                batchStatment.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("delete from T_IV_MaterialSerialNumber where fbillid in ").append(ids);
                batchStatment.addBatch(sql.toString());
                batchStatment.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatment, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)batchStatment, (Connection)conn);
        }
    }

    public void checkAutoAuditPermission(Context ctx, SCMBillBaseInfo aSCMBillBaseInfo, OrgType orgType, IObjectPK orgPK, String permItemName) throws EASBizException, BOSException {
    }

    private void delCostAdjustBill(Context ctx, String inWarehsID) throws EASBizException, BOSException {
        String sql = "select fid from T_CL_CostAdjustBill where  FSourceBillID in ('" + inWarehsID + "')  and  (FCreateType = 14 or FCreateType = 15)";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<ObjectUuidPK> idSet = new HashSet<ObjectUuidPK>();
        try {
            while (rs.next()) {
                ObjectUuidPK costID = new ObjectUuidPK(rs.getString("fid"));
                idSet.add(costID);
            }
            for (IObjectPK iObjectPK : idSet) {
                CostAdjustBillFactory.getLocalInstance((Context)ctx).unAudit(iObjectPK);
                CostAdjustBillFactory.getLocalInstance((Context)ctx).delete(iObjectPK);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        MatAssembleBillInfo info = this.getMatAssembleBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MatAssembleBillInfo info = this.getMatAssembleBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    class MatCostObject {
        Context ctx;
        String sourceBillEntryID;
        List<InvBillBaseEntryInfo> issueList;
        List<InvBillBaseEntryInfo> inWarehsList;

        public MatCostObject(Context ctx, String sourceBillEntryID) {
            this.ctx = ctx;
            this.sourceBillEntryID = sourceBillEntryID;
            this.issueList = new ArrayList<InvBillBaseEntryInfo>();
            this.inWarehsList = new ArrayList<InvBillBaseEntryInfo>();
        }

        public void addIssueEntry(InvBillBaseEntryInfo entry) {
            this.issueList.add(entry);
        }

        public void addInWarehsEntry(InvBillBaseEntryInfo entry) {
            this.inWarehsList.add(entry);
        }

        public boolean isNeedSyncCost() throws BOSException {
            if (this.inWarehsList.size() <= 0) {
                return false;
            }
            String materialId = this.inWarehsList.get(0).getMaterial().getId().toString();
            String couID = this.inWarehsList.get(0).getCompanyOrgUnit().getId().toString();
            MaterialCompanyInfoInfo matComInfo = MaterialFactory.getLocalInstance((Context)this.ctx).getCompanyInfo(materialId, couID);
            return matComInfo != null && AccountType.MOVE_ADD_AVERAGE.equals((Object)matComInfo.getAccountType());
        }

        public void calculateCost() throws BOSException, EASBizException {
            BigDecimal totalCost = this.getTotalOutCost();
            BigDecimal processCharge = this.getProcessCharge();
            totalCost = totalCost.add(processCharge);
            BigDecimal totalQty = this.getTotalInQty();
            BigDecimal dealCost = new BigDecimal("0");
            BigDecimal recentCost = new BigDecimal("0");
            InvBillBaseEntryInfo entry = null;
            for (int i = 0; i < this.inWarehsList.size(); ++i) {
                entry = this.inWarehsList.get(i);
                recentCost = totalCost.multiply(entry.getQty().divide(totalQty, 8, 4)).setScale(entry.getCompanyOrgUnit().getBaseCurrency().getPrecision(), 4);
                if (i == this.inWarehsList.size() - 1) {
                    recentCost = totalCost.subtract(dealCost);
                }
                if (recentCost.compareTo(BigDecimal.ZERO) == 0) {
                    throw new InvBizException(InvBizException.INWAREHS_ACTCOSTISNULL);
                }
                entry.setActualCost(recentCost);
                entry.setUnitActualCost(entry.getActualCost().divide(entry.getQty(), entry.getMaterial().getPricePrecision(), 4));
                entry.setBoolean("isNeedUpdate", true);
                dealCost = dealCost.add(entry.getActualCost());
            }
        }

        public void updateInWarehsEntryCost() throws BOSException {
            String updateSQL = "update t_im_otherinwarehsbillentry set FUnitActualCost = ?, FActualCost = ? where fid = ?";
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                conn = EJBFactory.getConnection((Context)this.ctx);
                ps = conn.prepareStatement(updateSQL);
                InvBillBaseEntryInfo entry = null;
                for (int i = 0; i < this.inWarehsList.size(); ++i) {
                    entry = this.inWarehsList.get(i);
                    ps.setBigDecimal(1, entry.getUnitActualCost());
                    ps.setBigDecimal(2, entry.getActualCost());
                    ps.setString(3, entry.getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }

        private BigDecimal getTotalOutCost() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.issueList.size(); ++i) {
                InvBillBaseEntryInfo entry = this.issueList.get(i);
                result = result.add(entry.getActualCost());
            }
            return result;
        }

        private BigDecimal getTotalInQty() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.inWarehsList.size(); ++i) {
                InvBillBaseEntryInfo entry = this.inWarehsList.get(i);
                result = result.add(entry.getQty());
            }
            return result;
        }

        private BigDecimal getProcessCharge() throws BOSException, EASBizException {
            MatAssembleBeforeEntryInfo beforeEntryInfo = MatAssembleBeforeEntryFactory.getLocalInstance(this.ctx).getMatAssembleBeforeEntryInfo((IObjectPK)new ObjectUuidPK(this.sourceBillEntryID));
            return beforeEntryInfo.getProcessCharge() == null ? BigDecimal.ZERO : beforeEntryInfo.getProcessCharge();
        }
    }
}

