/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.im.dt.DtTempFacadeFactory;
import com.kingdee.eas.scm.im.dt.IDtTempFacade;
import com.kingdee.eas.scm.im.inv.IOtherInWarehsBill;
import com.kingdee.eas.scm.im.inv.IOtherIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MatDisassembleAfterEntryCollection;
import com.kingdee.eas.scm.im.inv.MatDisassembleAfterEntryInfo;
import com.kingdee.eas.scm.im.inv.MatDisassembleBeforeEntryCollection;
import com.kingdee.eas.scm.im.inv.MatDisassembleBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMatDisassembleBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MatDisassembleBillControllerBean
extends AbstractMatDisassembleBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MatDisassembleBillControllerBean");

    @Override
    protected void _revoke(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = super.getSelector();
        for (int i = 0; i < sic.size(); ++i) {
            SelectorItemInfo si = sic.get(i);
            String name = si.getPropertyName();
            if (!name.contains("entry")) continue;
            name = name.replaceAll("entry", "entries");
            si.setPropertyName(name);
        }
        sic.add(new SelectorItemInfo("entries.processCharge"));
        sic.add(new SelectorItemInfo("entries.storeType.id"));
        sic.add(new SelectorItemInfo("entries.storeType.name"));
        sic.add(new SelectorItemInfo("entries.storeType.number"));
        sic.add(new SelectorItemInfo("entries.storeType.storeFlag"));
        sic.add(new SelectorItemInfo("entries.storeStatus.id"));
        sic.add(new SelectorItemInfo("entries.storeStatus.name"));
        sic.add(new SelectorItemInfo("entries.storeStatus.number"));
        sic.add(new SelectorItemInfo("entries.customer.id"));
        sic.add(new SelectorItemInfo("entries.customer.name"));
        sic.add(new SelectorItemInfo("entries.customer.number"));
        sic.add(new SelectorItemInfo("entries.supplier.id"));
        sic.add(new SelectorItemInfo("entries.supplier.name"));
        sic.add(new SelectorItemInfo("entries.supplier.number"));
        sic.add(new SelectorItemInfo("entries.entries.id"));
        sic.add(new SelectorItemInfo("entries.entries.material.id"));
        sic.add(new SelectorItemInfo("entries.entries.material.name"));
        sic.add(new SelectorItemInfo("entries.entries.material.number"));
        sic.add(new SelectorItemInfo("entries.entries.material.model"));
        sic.add(new SelectorItemInfo("entries.entries.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.entries.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.entries.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.entries.material.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.entries.material.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.entries.material.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.entries.material.seqUnit"));
        sic.add(new SelectorItemInfo("entries.entries.material.assistAttr"));
        sic.add(new SelectorItemInfo("entries.entries.material.materialGroup.id"));
        sic.add(new SelectorItemInfo("entries.entries.material.materialGroup.name"));
        sic.add(new SelectorItemInfo("entries.entries.material.materialGroup.number"));
        sic.add(new SelectorItemInfo("entries.entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.entries.lot"));
        sic.add(new SelectorItemInfo("entries.entries.mfg"));
        sic.add(new SelectorItemInfo("entries.entries.exp"));
        sic.add(new SelectorItemInfo("entries.entries.project.id"));
        sic.add(new SelectorItemInfo("entries.entries.project.name"));
        sic.add(new SelectorItemInfo("entries.entries.project.number"));
        sic.add(new SelectorItemInfo("entries.entries.trackNumber.id"));
        sic.add(new SelectorItemInfo("entries.entries.trackNumber.name"));
        sic.add(new SelectorItemInfo("entries.entries.trackNumber.number"));
        sic.add(new SelectorItemInfo("entries.entries.unitQty"));
        sic.add(new SelectorItemInfo("entries.entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.entries.qty"));
        sic.add(new SelectorItemInfo("entries.entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.entries.baseQty"));
        sic.add(new SelectorItemInfo("entries.entries.assCoefficient"));
        sic.add(new SelectorItemInfo("entries.entries.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.entries.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.entries.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.entries.assistQty"));
        sic.add(new SelectorItemInfo("entries.entries.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.entries.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.entries.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.entries.warehouse.id"));
        sic.add(new SelectorItemInfo("entries.entries.warehouse.name"));
        sic.add(new SelectorItemInfo("entries.entries.warehouse.number"));
        sic.add(new SelectorItemInfo("entries.entries.location.id"));
        sic.add(new SelectorItemInfo("entries.entries.location.name"));
        sic.add(new SelectorItemInfo("entries.entries.location.number"));
        sic.add(new SelectorItemInfo("entries.entries.stocker.id"));
        sic.add(new SelectorItemInfo("entries.entries.stocker.name"));
        sic.add(new SelectorItemInfo("entries.entries.stocker.number"));
        sic.add(new SelectorItemInfo("entries.entries.storeType.id"));
        sic.add(new SelectorItemInfo("entries.entries.storeType.name"));
        sic.add(new SelectorItemInfo("entries.entries.storeType.number"));
        sic.add(new SelectorItemInfo("entries.entries.storeType.storeFlag"));
        sic.add(new SelectorItemInfo("entries.entries.storeStatus.id"));
        sic.add(new SelectorItemInfo("entries.entries.storeStatus.name"));
        sic.add(new SelectorItemInfo("entries.entries.storeStatus.number"));
        sic.add(new SelectorItemInfo("entries.entries.customer.id"));
        sic.add(new SelectorItemInfo("entries.entries.customer.name"));
        sic.add(new SelectorItemInfo("entries.entries.customer.number"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.id"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.name"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.number"));
        sic.add(new SelectorItemInfo("entries.entries.sourceBillNumber"));
        sic.add(new SelectorItemInfo("entries.entries.sourceBillentriesSeq"));
        sic.add(new SelectorItemInfo("entries.entries.sourceBillType.id"));
        sic.add(new SelectorItemInfo("entries.entries.sourceBillType.name"));
        sic.add(new SelectorItemInfo("entries.entries.sourceBillType.number"));
        sic.add(new SelectorItemInfo("entries.entries.remark"));
        sic.add(new SelectorItemInfo("entries.entries.unitQty"));
        sic.add(new SelectorItemInfo("entries.entries.processCharge"));
        sic.add(new SelectorItemInfo("entries.entries.price"));
        sic.add(new SelectorItemInfo("entries.entries.amount"));
        sic.add(new SelectorItemInfo("entries.entries.costRate"));
        sic.add(new SelectorItemInfo("entries.entries.seq"));
        return sic;
    }

    private void updateDateOfMinDurability(Context ctx, String id, BillBaseStatusEnum status) throws BOSException, EASBizException {
        String rt = " \r\n";
        StringBuffer strSQL = new StringBuffer();
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance(ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
        if (status.getValue() == 4) {
            strSQL.append(" update T_IM_DateOfMinDurability as t1 set (FMfg,FExp)= (").append(rt);
            strSQL.append(" select FMfg,FExp from T_IM_MatDisassembleAfterEntry t2 where  ").append(rt);
            strSQL.append(" t2.FLot is not null and t2.FParentID ").append(rt);
            strSQL.append(" in(select entries.FID from T_IM_MatDisassemblebillEntry entries, T_IM_MatDisassembleBill bill  ").append(rt);
            strSQL.append(" where entries.FParentID=bill.FID and bill.FID='" + id + "'").append(rt);
            strSQL.append(" and entries.FSeq in ( ").append(rt);
            strSQL.append(" select FSeq from(select entries.FStorageOrgUnitID,entries.FLot,entries.FMaterialID, max(entries.FSeq) FSeq  ").append(rt);
            strSQL.append(" from T_IM_MatDisassembleBeforeEntry entries inner join T_IM_MatdisassembleBill bill  ").append(rt);
            strSQL.append(" on entries.FParentID=bill.FID and bill.FID='" + id + "'").append(rt);
            strSQL.append(" group by entries.FStorageOrgUnitID,entries.FLot,entries.FMaterialID) a ").append(rt);
            strSQL.append(" ) )  ").append(rt);
            strSQL.append(" and t1.FStorageOrgUnitID=t2.FStorageOrgUnitID and ").append(rt);
            strSQL.append(" t1.FMaterialID=t2.FMaterialID and t1.FLot=t2.FLot) ").append(rt);
        } else {
            strSQL.append(" update T_IM_DateOfMinDurability as t1 set (FMfg,FExp)= (").append(rt);
            strSQL.append(" select FMfg,FExp from T_IM_MatDisassembleBeforeEntry t2 where  ").append(rt);
            strSQL.append(" t2.FLot is not null and t2.FParentID ").append(rt);
            strSQL.append(" in (select bill.FID from T_IM_MatDisassembleBill bill  ").append(rt);
            strSQL.append(" where bill.FID='" + id + "'").append(rt);
            strSQL.append(" ) and t2.FSeq in ( ").append(rt);
            strSQL.append(" select FSeq from(select entries.FStorageOrgUnitID,entries.FLot,entries.FMaterialID, max(entries.FSeq) FSeq  ").append(rt);
            strSQL.append(" from T_IM_MatDisassembleBeforeEntry entries inner join T_IM_MatDisassembleBill bill  ").append(rt);
            strSQL.append(" on entries.FParentID=bill.FID and bill.FID='" + id + "'").append(rt);
            strSQL.append(" group by entries.FStorageOrgUnitID,entries.FLot,entries.FMaterialID) a ").append(rt);
            strSQL.append(" )  ").append(rt);
            strSQL.append(" and t1.FStorageOrgUnitID=t2.FStorageOrgUnitID and ").append(rt);
            strSQL.append(" t1.FMaterialID=t2.FMaterialID and t1.FLot=t2.FLot) ").append(rt);
        }
        if (paramMap.get("isCloseInsertLot") == null || !((Boolean)paramMap.get("isCloseInsertLot")).booleanValue()) {
            DbUtil.execute((Context)ctx, (String)strSQL.toString());
        }
    }

    protected void buildMatCostObjectMap(Context ctx, HashMap<String, MatCostObject> matCostObjMap, InvBillBaseEntryInfo entries, boolean isIssueEntry, Map<String, MatDisAfterEntryData> dataMap) {
        String sourceEntryID = entries.getSourceBillEntryId();
        MatCostObject vo = matCostObjMap.get(sourceEntryID);
        if (vo == null) {
            vo = new MatCostObject(ctx, sourceEntryID);
        }
        if (isIssueEntry) {
            vo.addIssueEntry(entries);
        } else {
            vo.addAmount(dataMap.get(entries.getId().toString()).getAmount());
            vo.addEntryData(dataMap);
            vo.addInWarehsEntry(entries);
        }
        matCostObjMap.put(sourceEntryID, vo);
    }

    private void setEntryDataMap(Context ctx, OtherInWarehsBillInfo inWarehsInfo, Map<String, MatDisAfterEntryData> dataMap) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.FID,afterEntry.FCostRate,afterEntry.FAmount,afterEntry.FProcessCharge from T_IM_OtherInwarehsbill bill inner join T_IM_OtherInwarehsbillentry entry on bill.fid = entry.fparentid");
        sql.append(" inner join T_IM_MatDisassembleAfterEntry afterEntry on afterEntry.FparentID  = entry.FSourceBillEntryID and entry.FSOURCEBILLENTRYSEQ = afterEntry.FSeq ");
        sql.append(" inner join T_BD_Material m on m.fid = entry.fmaterialID ");
        sql.append(" where bill.FID = '").append(inWarehsInfo.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                MatDisAfterEntryData data = new MatDisAfterEntryData();
                data.setCostRate(rs.getBigDecimal("FCostRate"));
                data.setAmount(rs.getBigDecimal("FAmount"));
                data.setProcessCharge(rs.getBigDecimal("FProcessCharge"));
                dataMap.put(rs.getString("FID"), data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void updateMaterialSerialNumber(Context ctx, InvBillBaseInfo matAttrInfo, InvBillBaseInfo otherInfo, String otherBillTypeID, String matBillTypeID) throws BOSException, EASBizException {
        try {
            IObjectCollection entriesOtherColl = (IObjectCollection)otherInfo.get("entries");
            InvBillBaseEntryInfo entriesOtherInfo = null;
            HashSet<String> entriesSet = new HashSet<String>();
            IObjectCollection entriesMatColl = (IObjectCollection)matAttrInfo.get("entries");
            InvBillBaseEntryInfo entriesBeforeInfo = null;
            for (int i = 0; i < entriesOtherColl.size(); ++i) {
                entriesBeforeInfo = (InvBillBaseEntryInfo)entriesMatColl.getObject(i);
                if (otherInfo instanceof OtherIssueBillInfo) {
                    entriesSet.add(entriesBeforeInfo.getId().toString());
                    continue;
                }
                IObjectCollection entriesAfterColl = (IObjectCollection)entriesBeforeInfo.get("entries1");
                for (int j = 0; j < entriesAfterColl.size(); ++j) {
                    InvBillBaseEntryInfo entriesAfterInfo = (InvBillBaseEntryInfo)entriesAfterColl.getObject(j);
                    for (int k = 0; k < entriesOtherColl.size(); ++k) {
                        entriesOtherInfo = (InvBillBaseEntryInfo)entriesOtherColl.getObject(k);
                        if (!entriesOtherInfo.getSourceBillEntryId().toString().equals(entriesBeforeInfo.getId().toString())) continue;
                        entriesSet.add(entriesAfterInfo.getId().toString());
                    }
                }
            }
            if (matAttrInfo != null && matAttrInfo.getBillType() != null && matAttrInfo.getNumber() != null && entriesSet != null && entriesSet.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)matAttrInfo.getBillType().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("billId", (Object)matAttrInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("billNumber", (Object)matAttrInfo.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("billEntryId", entriesSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                MaterialSerialNumberCollection msnCol = MaterialSerialNumberFactory.getLocalInstance(ctx).getMaterialSerialNumberCollection(viewInfo);
                if (msnCol != null && msnCol.size() > 0) {
                    MaterialSerialNumberInfo msnInfo = null;
                    MaterialSerialNumberEntryInfo entriesInfo = null;
                    HashMap<String, MaterialSerialNumberInfo> map = new HashMap<String, MaterialSerialNumberInfo>();
                    int col = msnCol.size();
                    for (int i = 0; i < col; ++i) {
                        msnInfo = msnCol.get(i);
                        if (msnInfo == null) continue;
                        msnInfo.setId(BOSUuid.create((BOSObjectType)msnInfo.getBOSType()));
                        msnInfo.setBillType(otherInfo.getBillType());
                        msnInfo.setBillID(otherInfo.getId().toString());
                        msnInfo.setBillNumber(otherInfo.getNumber());
                        if (msnInfo.getEntry() != null) {
                            int count = msnInfo.getEntry().size();
                            for (int j = 0; j < count; ++j) {
                                entriesInfo = msnInfo.getEntry().get(j);
                                entriesInfo.setId(BOSUuid.create((BOSObjectType)entriesInfo.getBOSType()));
                                entriesInfo.setParent(msnInfo);
                            }
                        }
                        map.put(msnInfo.getBillEntryID(), msnInfo);
                    }
                    CoreBaseCollection coll = new CoreBaseCollection();
                    for (int i = 0; i < entriesOtherColl.size(); ++i) {
                        entriesBeforeInfo = (InvBillBaseEntryInfo)entriesMatColl.getObject(i);
                        if (otherInfo instanceof OtherIssueBillInfo) {
                            entriesOtherInfo = (InvBillBaseEntryInfo)entriesOtherColl.getObject(i);
                            if (entriesBeforeInfo.getId() == null || !map.containsKey(entriesBeforeInfo.getId().toString()) || (msnInfo = (MaterialSerialNumberInfo)map.get(entriesBeforeInfo.getId().toString())) == null) continue;
                            msnInfo.setBillEntryID(entriesOtherInfo.getId().toString());
                            coll.addObject((IObjectValue)msnInfo);
                            continue;
                        }
                        IObjectCollection entriesAfterColl = (IObjectCollection)entriesBeforeInfo.get("entries1");
                        for (int j = 0; j < entriesAfterColl.size(); ++j) {
                            InvBillBaseEntryInfo entriesAfterInfo = (InvBillBaseEntryInfo)entriesAfterColl.getObject(j);
                            for (int k = 0; k < entriesOtherColl.size(); ++k) {
                                entriesOtherInfo = (InvBillBaseEntryInfo)entriesOtherColl.getObject(k);
                                if (entriesOtherInfo.getSourceBillEntryId() == null || !map.containsKey(entriesAfterInfo.getId().toString()) || !entriesOtherInfo.getSourceBillEntryId().toString().equals(entriesBeforeInfo.getId().toString()) || (msnInfo = (MaterialSerialNumberInfo)map.get(entriesAfterInfo.getId().toString())) == null) continue;
                                msnInfo.setBillEntryID(entriesOtherInfo.getId().toString());
                                coll.addObject((IObjectValue)msnInfo);
                            }
                        }
                    }
                    MaterialSerialNumberFactory.getLocalInstance(ctx).addnew(coll);
                }
            }
        }
        catch (Exception e) {
            throw new InvBizException(InvBizException.IDCARD_INVALID);
        }
    }

    protected boolean isSerial(Context ctx, MaterialInfo material, MeasureUnitInfo kdUnitInfo, StorageOrgUnitInfo sou) throws EASBizException, BOSException {
        boolean isSerial = false;
        MaterialInventoryInfo invInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(material.getId().toString(), sou.getId().toString());
        if (invInfo != null && invInfo.isIsSequenceNo() && material.getSeqUnit() != null && kdUnitInfo != null && material.getSeqUnit().getId().equals((Object)kdUnitInfo.getId())) {
            isSerial = true;
        }
        return isSerial;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSubmitCheckSerialNumber(ctx, (MatDisassembleBillInfo)model);
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    private void beforeSubmitCheckSerialNumber(Context ctx, MatDisassembleBillInfo model) throws BOSException, EASBizException {
        MatDisassembleBillInfo info = model;
        StorageOrgUnitInfo storageOrgUnit = info.getStorageOrgUnit();
        if (!InvCommonUtils.isSerialRequired(storageOrgUnit.getId().toString(), ctx).booleanValue()) {
            return;
        }
        String resource = "com.kingdee.eas.scm.im.inv.MatDisassembleResource";
        MatDisassembleBeforeEntryCollection coll = info.getEntries();
        Map<String, MaterialSerialNumberInfo> map = this.getMaterialSerialNumber(ctx, info, (IObjectCollection)coll);
        MatDisassembleAfterEntryCollection afterColl = null;
        MatDisassembleBeforeEntryInfo beforeEntryInfo = null;
        MatDisassembleAfterEntryInfo afterEntryInfo = null;
        boolean isSerialNumber = false;
        StringBuffer sbSN = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            beforeEntryInfo = coll.get(i);
            if (beforeEntryInfo.getMaterial() != null && beforeEntryInfo.getUnit() != null && this.isSerial(ctx, beforeEntryInfo.getMaterial(), beforeEntryInfo.getUnit(), storageOrgUnit) && (beforeEntryInfo.getId() == null || map.get(beforeEntryInfo.getId().toString()) == null)) {
                sbSN.append(ResourceUtil.getMessage((String)resource, (String)"BEFORECHANGE_SERIL_RES", (String[])new String[]{String.valueOf(i + 1), beforeEntryInfo.getMaterial().getNumber()})).append("\r\n");
            }
            afterColl = beforeEntryInfo.getEntries();
            for (int j = 0; j < afterColl.size(); ++j) {
                afterEntryInfo = afterColl.get(j);
                if (afterEntryInfo.getMaterial() == null || afterEntryInfo.getUnit() == null || !this.isSerial(ctx, afterEntryInfo.getMaterial(), afterEntryInfo.getUnit(), storageOrgUnit) || afterEntryInfo.getId() != null && map.get(afterEntryInfo.getId().toString()) != null) continue;
                sbSN.append(ResourceUtil.getMessage((String)resource, (String)"AFTERCHANGE_RES", (String[])new String[]{String.valueOf(i + 1), String.valueOf(j + 1), afterEntryInfo.getMaterial().getNumber()})).append("\r\n");
            }
        }
        if (sbSN.toString().length() > 0) {
            throw new BOSException(sbSN.toString());
        }
    }

    public Map<String, MaterialSerialNumberInfo> getMaterialSerialNumber(Context ctx, MatDisassembleBillInfo matDisassembleBillInfo, IObjectCollection entryColl) throws BOSException {
        HashMap<String, MaterialSerialNumberInfo> map = new HashMap<String, MaterialSerialNumberInfo>();
        if (matDisassembleBillInfo == null || matDisassembleBillInfo.getId() == null) {
            return map;
        }
        String billID = matDisassembleBillInfo.getId().toString();
        HashSet<String> entryIdSet = new HashSet<String>();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        MatDisassembleBeforeEntryInfo beforeEntryInfo = null;
        MatDisassembleAfterEntryInfo afterEntryInfo = null;
        MatDisassembleAfterEntryCollection afterEntryColl = null;
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                beforeEntryInfo = (MatDisassembleBeforeEntryInfo)entryColl.getObject(i);
                if (beforeEntryInfo != null && beforeEntryInfo.getId() != null) {
                    entryIdSet.add(beforeEntryInfo.getId().toString());
                }
                if ((afterEntryColl = beforeEntryInfo.getEntries()) == null) continue;
                for (int j = 0; j < afterEntryColl.size(); ++j) {
                    if (afterEntryColl.get(j) == null || afterEntryColl.get(j).getId() == null) continue;
                    afterEntryInfo = afterEntryColl.get(j);
                    entryIdSet.add(afterEntryInfo.getId().toString());
                }
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        filter.getFilterItems().add(new FilterItemInfo("billEntryID", entryIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("snQty", (Object)BigDecimal.ZERO, CompareType.GREATER));
        ev.setFilter(filter);
        MaterialSerialNumberCollection snColl = MaterialSerialNumberFactory.getLocalInstance(ctx).getMaterialSerialNumberCollection(ev);
        MaterialSerialNumberInfo msnInfo = null;
        String billEntryId = null;
        if (snColl != null && snColl.size() > 0) {
            for (int i = 0; i < snColl.size(); ++i) {
                msnInfo = snColl.get(i);
                billEntryId = msnInfo.getBillEntryID();
                map.put(billEntryId, msnInfo);
            }
        }
        return map;
    }

    @Override
    protected void checkUnPassAduit(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        if (aInvBillBaseInfo.getBaseStatus() != null && aInvBillBaseInfo.getBaseStatus().getValue() != 4) {
            throw new SCMBillException(SCMBillException.CHECK_UNAUDIT, new Object[]{aInvBillBaseInfo.getString("number"), ""});
        }
        this._checkUnAuditInParam(ctx, (IObjectValue)aInvBillBaseInfo);
        if (aInvBillBaseInfo.isIsReversed()) {
            throw new SCMBillException(SCMBillException.ISREVERSED_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
        this._checkIsVouchered(ctx, (IObjectValue)aInvBillBaseInfo, true);
        if (!(aInvBillBaseInfo instanceof MaterialRequestBillInfo) && !aInvBillBaseInfo.isIsInitBill()) {
            this._checkBizDate(ctx, (IObjectValue)aInvBillBaseInfo);
        }
        this.isSamePerson4UnAudit(ctx, aInvBillBaseInfo);
    }

    public String getOtherID(Context ctx, String sourceBillID, String billTbl, String billEntryTbl) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT OIS.FID FROM " + billTbl + " OIS, " + billEntryTbl + " OISE ");
        sql.append(" WHERE OIS.FID = OISE.FPARENTID AND OISE.Fsourcebillid = ? ");
        String otherID = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = conn.prepareStatement(sql.toString());
            pstm.setString(1, sourceBillID);
            rs = pstm.executeQuery();
            if (rs.next()) {
                otherID = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)conn);
        return otherID;
    }

    public void unAuditDelOther(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof MatDisassembleBillInfo) {
            ArrayList<String> idList = new ArrayList<String>();
            MatDisassembleBillInfo billInfo = (MatDisassembleBillInfo)model;
            IOtherInWarehsBill iInWarehs = OtherInWarehsBillFactory.getLocalInstance(ctx);
            String inWarehsID = this.getOtherID(ctx, billInfo.getId().toString(), "T_IM_OTHERINWAREHSBILL", "T_IM_OTHERINWAREHSBILLENTRY");
            if (!StringUtils.isEmpty((String)inWarehsID)) {
                idList.add(inWarehsID);
                iInWarehs.unAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inWarehsID)));
                iInWarehs.deleteNocheck((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inWarehsID)));
                this.delCostAdjustBill(ctx, inWarehsID);
            }
            IOtherIssueBill iIssue = OtherIssueBillFactory.getLocalInstance(ctx);
            String isSueID = this.getOtherID(ctx, billInfo.getId().toString(), "T_IM_OTHERISSUEBILL", "T_IM_OTHERISSUEBILLENTRY");
            if (!StringUtils.isEmpty((String)isSueID)) {
                idList.add(isSueID);
                iIssue.unAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)isSueID)));
                iIssue.deleteNocheck((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)isSueID)));
            }
            if (billInfo.getBizType().getId().toString().equals("kXeVPjHuchDgQKjAYj1RYCQHQ1w=")) {
                this.updateDateOfMinDurability(ctx, ((InvBillBaseInfo)model).getId().toString(), BillBaseStatusEnum.SUBMITED);
            }
            if (idList != null && idList.size() > 0) {
                this.deleteMaterialSerialByUnAudit(ctx, idList);
            }
        }
    }

    private void deleteMaterialSerialByUnAudit(Context ctx, List idList) throws BOSException {
        if (idList != null && idList.size() > 0) {
            Connection conn = this.getConnection(ctx);
            Statement batchStatment = null;
            try {
                String ids = InvServerUtils.getInStringFromList(idList);
                batchStatment = conn.createStatement();
                StringBuffer sql = new StringBuffer();
                sql.append("delete from T_IV_MaterialSerialNumberEntry where fparentid in (select fid from ");
                sql.append("T_IV_MaterialSerialNumber where FBillId in ").append(ids).append(" )");
                batchStatment.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("delete from T_IV_MaterialSerialNumber where fbillid in ").append(ids);
                batchStatment.addBatch(sql.toString());
                batchStatment.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatment, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)batchStatment, (Connection)conn);
        }
    }

    public void checkAutoAuditPermission(Context ctx, SCMBillBaseInfo aSCMBillBaseInfo, OrgType orgType, IObjectPK orgPK, String permItemName) throws EASBizException, BOSException {
    }

    private void delCostAdjustBill(Context ctx, String inWarehsID) throws EASBizException, BOSException {
        String sql = "select fid from T_CL_CostAdjustBill where  FSourceBillID in ('" + inWarehsID + "')  and  (FCreateType = 14 or FCreateType = 15)";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<ObjectUuidPK> idSet = new HashSet<ObjectUuidPK>();
        try {
            while (rs.next()) {
                ObjectUuidPK costID = new ObjectUuidPK(rs.getString("fid"));
                idSet.add(costID);
            }
            for (IObjectPK iObjectPK : idSet) {
                CostAdjustBillFactory.getLocalInstance((Context)ctx).unAudit(iObjectPK);
                CostAdjustBillFactory.getLocalInstance((Context)ctx).delete(iObjectPK);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        MatDisassembleBillInfo info = this.getMatDisassembleBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MatDisassembleBillInfo info = this.getMatDisassembleBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    class MatCostObject {
        Context ctx;
        String sourceBillEntryID;
        List<InvBillBaseEntryInfo> issueList;
        List<InvBillBaseEntryInfo> inWarehsList;
        Map<String, MatDisAfterEntryData> dataMap;
        BigDecimal amount = new BigDecimal("0.00");

        public MatCostObject(Context ctx, String sourceBillEntryID) {
            this.ctx = ctx;
            this.sourceBillEntryID = sourceBillEntryID;
            this.issueList = new ArrayList<InvBillBaseEntryInfo>();
            this.inWarehsList = new ArrayList<InvBillBaseEntryInfo>();
        }

        public void addAmount(BigDecimal amount) {
            this.amount = this.amount.add(amount);
        }

        public void addEntryData(Map<String, MatDisAfterEntryData> dataMap) {
            this.dataMap = dataMap;
        }

        public void addIssueEntry(InvBillBaseEntryInfo entries) {
            this.issueList.add(entries);
        }

        public void addInWarehsEntry(InvBillBaseEntryInfo entries) {
            this.inWarehsList.add(entries);
        }

        public boolean isNeedSyncCost() throws BOSException {
            if (this.inWarehsList.size() <= 0) {
                return false;
            }
            for (int i = this.inWarehsList.size() - 1; i >= 0; --i) {
                String materialId = this.inWarehsList.get(i).getMaterial().getId().toString();
                String couID = this.inWarehsList.get(i).getCompanyOrgUnit().getId().toString();
                MaterialCompanyInfoInfo matComInfo = MaterialFactory.getLocalInstance((Context)this.ctx).getCompanyInfo(materialId, couID);
                if (matComInfo == null || !AccountType.MOVE_ADD_AVERAGE.equals((Object)matComInfo.getAccountType())) {
                    this.inWarehsList.remove(i);
                    continue;
                }
                if (this.dataMap.get(this.inWarehsList.get(i).getId().toString()).getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                this.inWarehsList.remove(i);
            }
            return this.inWarehsList.size() > 0;
        }

        public void calculateCost() throws BOSException, EASBizException {
            int i;
            BigDecimal totalCost = this.getTotalOutCost();
            BigDecimal totalQty = this.getTotalInQty();
            BigDecimal dealCost = new BigDecimal("0");
            BigDecimal recentCost = new BigDecimal("0");
            InvBillBaseEntryInfo entries = null;
            BigDecimal costRateSum = new BigDecimal("0");
            for (i = 0; i < this.inWarehsList.size(); ++i) {
                entries = this.inWarehsList.get(i);
                costRateSum = costRateSum.add(this.dataMap.get(entries.getId().toString()).getCostRate());
            }
            for (i = 0; i < this.inWarehsList.size(); ++i) {
                entries = this.inWarehsList.get(i);
                BigDecimal costRate = this.dataMap.get(entries.getId().toString()).getCostRate();
                recentCost = totalCost.multiply(costRate.divide(new BigDecimal("100.00"), 8, 4)).setScale(entries.getCompanyOrgUnit().getBaseCurrency().getPrecision(), 4);
                if (costRateSum.compareTo(new BigDecimal("100.00")) == 0 && this.inWarehsList.size() > 1 && i == this.inWarehsList.size() - 1) {
                    recentCost = totalCost.subtract(dealCost);
                }
                if (recentCost.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new InvBizException(InvBizException.INWAREHS_ACTCOSTISNULL);
                }
                recentCost = recentCost.add(this.dataMap.get(entries.getId().toString()).getProcessCharge());
                recentCost = recentCost.setScale(entries.getCompanyOrgUnit().getBaseCurrency().getPrecision(), 4);
                entries.setActualCost(recentCost);
                entries.setUnitActualCost(entries.getActualCost().divide(entries.getQty(), entries.getMaterial().getPricePrecision(), 4));
                entries.setBoolean("isNeedUpdate", true);
                dealCost = dealCost.add(entries.getActualCost());
            }
        }

        public void updateInWarehsEntryCost() throws BOSException {
            String updateSQL = "update t_im_otherinwarehsbillentry set FUnitActualCost = ?, FActualCost = ? where fid = ?";
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                conn = EJBFactory.getConnection((Context)this.ctx);
                ps = conn.prepareStatement(updateSQL);
                InvBillBaseEntryInfo entries = null;
                for (int i = 0; i < this.inWarehsList.size(); ++i) {
                    entries = this.inWarehsList.get(i);
                    ps.setBigDecimal(1, entries.getUnitActualCost());
                    ps.setBigDecimal(2, entries.getActualCost());
                    ps.setString(3, entries.getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }

        private BigDecimal getTotalOutCost() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.issueList.size(); ++i) {
                InvBillBaseEntryInfo entries = this.issueList.get(i);
                result = result.add(entries.getActualCost());
            }
            result = result.subtract(this.amount);
            return result;
        }

        private BigDecimal getTotalInQty() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.inWarehsList.size(); ++i) {
                InvBillBaseEntryInfo entries = this.inWarehsList.get(i);
                result = result.add(entries.getQty());
            }
            return result;
        }
    }

    class MatDisAfterEntryData {
        BigDecimal costRate = new BigDecimal("0.00");
        BigDecimal amount = new BigDecimal("0.00");
        BigDecimal processCharge = new BigDecimal("0.00");

        MatDisAfterEntryData() {
        }

        public BigDecimal getCostRate() {
            return this.costRate;
        }

        public void setCostRate(BigDecimal costRate) {
            if (costRate != null) {
                this.costRate = costRate;
            }
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            if (amount != null) {
                this.amount = amount;
            }
        }

        public BigDecimal getProcessCharge() {
            return this.processCharge;
        }

        public void setProcessCharge(BigDecimal processCharge) {
            if (processCharge != null) {
                this.processCharge = processCharge;
            }
        }
    }
}

