/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.RIEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.app.InventoryPageHelper;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.invconfig.util.BalanceCfgUtil;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MaterialQueryPageHelper
extends InventoryPageHelper {
    private StorageOrgUnitInfo sou = null;
    protected boolean isUpdateByBaseUnit = false;
    private String permissionSQL = null;
    private String permissionJoinSQL = null;
    private boolean isIssue = false;
    private boolean isStockTransferBill = false;
    private String materialID = null;
    private Map<String, Object> condition = null;

    public MaterialQueryPageHelper(Context ctx, Map<String, Object> condition) {
        this.ctx = ctx;
        this.condition = condition;
    }

    public Map getData(TransactionTypeInfo tti, IObjectValue billInfo, IObjectValue billEntryInfo, String entryName, StorageOrgUnitInfo storageOrgUnit) throws Exception {
        ObjectUuidPK pk;
        IParamControl ipc;
        String val;
        if (tti != null) {
            this.transactionTypeID = tti.getId().toString();
            tti = TransactionTypeFactory.getLocalInstance((Context)this.ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(this.transactionTypeID), SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
            this.setIsIssue(tti);
        }
        this.entryName = entryName;
        String bosType = billInfo.getBOSType().toString();
        this.setIsStock(bosType);
        if ("A4D04D25".equals(bosType) || "9CA9D08F".equals(bosType)) {
            this.isIssue = true;
        }
        String billEntryBosType = billEntryInfo.getBOSType().toString();
        this.buildConfigMapping(this.ctx, billInfo, billEntryInfo, 0);
        if (this.condition.get("fieldMap") != null) {
            this.propMap.putAll((Map)this.condition.get("fieldMap"));
        }
        this.sou = storageOrgUnit;
        if (this.sou == null) {
            this.sou = (StorageOrgUnitInfo)this.propMap.get("FStorageOrgUnitID");
        }
        if ((val = (ipc = ParamControlFactory.getRemoteInstance()).getParamValue((IObjectPK)(pk = new ObjectUuidPK(this.sou.getId().toString())), "INM004")) != null && val.equalsIgnoreCase("true")) {
            this.isUpdateByBaseUnit = true;
        }
        String sql = this.getQuerySQL(bosType, billInfo, billEntryInfo);
        Object materialInfo = this.propMap.get("FMaterialID");
        if (materialInfo instanceof IObjectValue) {
            this.materialID = ((IObjectValue)materialInfo).get("id").toString();
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        IRowSetMetaData md = rs.getRowSetMetaData();
        ArrayList listModel = new ArrayList();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int count = md.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String columnName = md.getColumnName(i).toUpperCase();
                Object value = rs.getObject(i);
                map.put(columnName, value);
            }
            if (map.get("EXP") != null) {
                map.put("EXP", map.get("EXP").toString());
            }
            if (map.get("MFG") != null) {
                map.put("MFG", map.get("MFG").toString());
            }
            listModel.add(map);
        }
        String[] columnModel = this.fieldSQL.toString().replace(" ", "").split(",");
        ArrayList records = new ArrayList();
        for (int nIndex = 0; nIndex < listModel.size(); ++nIndex) {
            Map rowInfo = (Map)listModel.get(nIndex);
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (String column : columnModel) {
                Object value = null;
                if (rowInfo.get(column.toUpperCase()) != null) {
                    value = rowInfo.get(column.toUpperCase());
                }
                row.put(column, value);
            }
            records.add(row);
        }
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        retValue.put("listModel", records);
        retValue.put("columns", columnModel);
        retValue.put("takeMapping", this.mapping);
        retValue.put("resMap", this.resMap);
        retValue.put("isIssue", this.isIssue);
        retValue.put("isStockTransferBill", this.isStockTransferBill);
        retValue.put("tableHeadKeyList", this.tableHeadKeyList);
        retValue.put("linkPropBosTypeMap", this.linkPropBosTypeMap);
        retValue.put("fieldTypeMap", this.fieldTypeMap);
        return retValue;
    }

    public Map getGeneralDetailData(TransactionTypeInfo tti, IObjectValue billInfo, IObjectValue billEntryInfo, String entryName, StorageOrgUnitInfo storageOrgUnit) throws Exception {
        ObjectUuidPK pk;
        IParamControl ipc;
        String val;
        if (tti != null) {
            this.transactionTypeID = tti.getId().toString();
            tti = TransactionTypeFactory.getLocalInstance((Context)this.ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(this.transactionTypeID), SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
            this.setIsIssue(tti);
        }
        this.entryName = entryName;
        String bosType = billInfo.getBOSType().toString();
        this.setIsStock(bosType);
        if ("A4D04D25".equals(bosType)) {
            this.isIssue = true;
        }
        String billEntryBosType = billEntryInfo.getBOSType().toString();
        this.buildConfigMapping(this.ctx, billInfo, billEntryInfo, 0);
        if (this.condition.get("fieldMap") != null) {
            this.propMap.putAll((Map)this.condition.get("fieldMap"));
        }
        this.sou = storageOrgUnit;
        if (this.sou == null) {
            this.sou = (StorageOrgUnitInfo)this.propMap.get("FStorageOrgUnitID");
        }
        if ((val = (ipc = ParamControlFactory.getRemoteInstance()).getParamValue((IObjectPK)(pk = new ObjectUuidPK(this.sou.getId().toString())), "INM004")) != null && val.equalsIgnoreCase("true")) {
            this.isUpdateByBaseUnit = true;
        }
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "InvQuery");
        IQueryExecutor iexec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, this.getEntityViewInfo());
        String sql = iexec.getSQL();
        Object materialInfo = this.propMap.get("FMaterialID");
        if (materialInfo instanceof IObjectValue) {
            this.materialID = ((IObjectValue)materialInfo).get("id").toString();
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        IRowSetMetaData md = rs.getRowSetMetaData();
        ArrayList listModel = new ArrayList();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int count = md.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String columnName = md.getColumnName(i);
                Object value = rs.getObject(i);
                map.put(columnName, value);
            }
            listModel.add(map);
        }
        String[] columnModel = this.fieldSQL.toString().replace(" ", "").split(",");
        ArrayList records = new ArrayList();
        for (int nIndex = 0; nIndex < listModel.size(); ++nIndex) {
            Map rowInfo = (Map)listModel.get(nIndex);
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (String column : columnModel) {
                Object value = null;
                if (rowInfo.get(column.toUpperCase()) != null) {
                    value = rowInfo.get(column.toUpperCase());
                }
                row.put(column, value);
            }
            records.add(row);
        }
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        retValue.put("listModel", records);
        retValue.put("columns", columnModel);
        retValue.put("takeMapping", this.mapping);
        retValue.put("resMap", this.resMap);
        retValue.put("isIssue", this.isIssue);
        retValue.put("isStockTransferBill", this.isStockTransferBill);
        retValue.put("tableHeadKeyList", this.tableHeadKeyList);
        retValue.put("linkPropBosTypeMap", this.linkPropBosTypeMap);
        retValue.put("fieldTypeMap", this.fieldTypeMap);
        return retValue;
    }

    public Map getInventoryGeneralDetail(Map params) throws BOSException, EASBizException {
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "InvQuery");
        IQueryExecutor iexec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, this.buildEntityViewInfo(params));
        String sql = iexec.getSQL();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        ArrayList listModel = new ArrayList();
        try {
            IRowSetMetaData md = rs.getRowSetMetaData();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int count = md.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i).toUpperCase();
                    Object value = rs.getObject(i);
                    map.put(columnName, value);
                }
                listModel.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap retValue = new HashMap();
        retValue.put("listModel", listModel);
        return retValue;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public EntityViewInfo getEntityViewInfo() throws Exception {
        String storeTypeID;
        String warehousID;
        String materialID;
        EntityViewInfo ev = new EntityViewInfo();
        HashMap hm = (HashMap)this.propMap;
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer(128);
        int maskIndex = 0;
        Object propValue = this.propMap.get("FStorageOrgUnitID");
        String storageUnitID = this.getPropStringValue(propValue);
        if (!StringUtil.isEmpty((String)storageUnitID)) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageUnitID, CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (!StringUtil.isEmpty((String)(materialID = this.getPropStringValue(propValue = this.propMap.get("FMaterialID"))))) {
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (!StringUtil.isEmpty((String)(warehousID = this.getPropStringValue(propValue = this.propMap.get("FWarehouseID"))))) {
            filter.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)warehousID, CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (!StringUtil.isEmpty((String)(storeTypeID = this.getPropStringValue(propValue = this.propMap.get("FStoreTypeID"))))) {
            filter.getFilterItems().add(new FilterItemInfo("storetype.id", (Object)storeTypeID, CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        ev.getSelector().add(new SelectorItemInfo("inventoryUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("curMatStoreQty"));
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("assistProperty.id"));
        ev.getSelector().add(new SelectorItemInfo("assistProperty.name"));
        ev.getSelector().add(new SelectorItemInfo("lot"));
        ev.getSelector().add(new SelectorItemInfo("unit.name"));
        ev.getSelector().add(new SelectorItemInfo("curStoreQty"));
        ev.getSelector().add(new SelectorItemInfo("baseQty"));
        ev.getSelector().add(new SelectorItemInfo("lockQty"));
        ev.getSelector().add(new SelectorItemInfo("lockBaseQty"));
        ev.getSelector().add(new SelectorItemInfo("assistUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("curStoreAssistQty"));
        ev.getSelector().add(new SelectorItemInfo("storetype.name"));
        ev.getSelector().add(new SelectorItemInfo("storestatus.name"));
        ev.getSelector().add(new SelectorItemInfo("warehouse.name"));
        ev.getSelector().add(new SelectorItemInfo("location.name"));
        ev.getSelector().add(new SelectorItemInfo("customer.name"));
        ev.getSelector().add(new SelectorItemInfo("supplier.name"));
        ev.getSelector().add(new SelectorItemInfo("warehouse.id"));
        ev.getSelector().add(new SelectorItemInfo("location.id"));
        ev.getSelector().add(new SelectorItemInfo("warehouse.hasLocation"));
        ev.getSelector().add(new SelectorItemInfo("supplier.id"));
        ev.getSelector().add(new SelectorItemInfo("customer.id"));
        ev.getSelector().add(new SelectorItemInfo("storetype.id"));
        ev.getSelector().add(new SelectorItemInfo("storestatus.id"));
        ev.getSelector().add(new SelectorItemInfo("unit.id"));
        ev.getSelector().add(new SelectorItemInfo("multiUnit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("multiAssistUnit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("multiBaseUnit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("project.id"));
        ev.getSelector().add(new SelectorItemInfo("project.number"));
        ev.getSelector().add(new SelectorItemInfo("project.name"));
        ev.getSelector().add(new SelectorItemInfo("trackNumber.id"));
        ev.getSelector().add(new SelectorItemInfo("trackNumber.number"));
        ev.getSelector().add(new SelectorItemInfo("trackNumber.name"));
        ev.getSelector().add(new SelectorItemInfo("DateOfMinDurability.mfg"));
        ev.getSelector().add(new SelectorItemInfo("DateOfMinDurability.exp"));
        FilterInfo warefilterInfo = this.getwarePerm(storageUnitID);
        if (warefilterInfo != null) {
            filter.mergeFilter(warefilterInfo, "AND");
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (mask.length() > 0) {
            filter.setMaskString(mask.toString());
        }
        ev.setFilter(filter);
        if (!StringUtil.isEmpty((String)storageUnitID)) {
            FilterInfo permisionFilter = SCMClientUtils.getDataPermissionFilter((String)storageUnitID, (String)"inventory");
            ev.getFilter().mergeFilter(permisionFilter, "and");
        }
        ev.getSorter().add(new SorterItemInfo("material.number"));
        ev.getSorter().add(new SorterItemInfo("warehouse.number"));
        return ev;
    }

    public EntityViewInfo buildEntityViewInfo(Map params) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        String lot = params.get("lot").toString();
        String assistProperty = params.get("assistProperty").toString();
        boolean isLikeQuery = (Boolean)params.get("isLikeQuery");
        String storageOrgUnitID = params.get("storageOrgUnitID").toString();
        String storeTypeID = params.get("storeTypeID").toString();
        String materialID = params.get("materialID").toString();
        String warehouseID = params.get("warehouseID").toString();
        FilterInfo filter = new FilterInfo();
        if (!StringUtil.isEmpty((String)storageOrgUnitID)) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        }
        if (!StringUtil.isEmpty((String)materialID)) {
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        }
        if (!StringUtil.isEmpty((String)warehouseID)) {
            filter.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)warehouseID, CompareType.EQUALS));
        }
        if (!StringUtil.isEmpty((String)storeTypeID)) {
            filter.getFilterItems().add(new FilterItemInfo("storetype.id", (Object)storeTypeID, CompareType.EQUALS));
        }
        if (!StringUtil.isEmpty((String)lot)) {
            if (isLikeQuery) {
                filter.getFilterItems().add(new FilterItemInfo("lot", (Object)("%" + lot + "%"), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
            }
        }
        if (!StringUtil.isEmpty((String)assistProperty)) {
            if (isLikeQuery) {
                filter.getFilterItems().add(new FilterItemInfo("assistProperty.name", (Object)("%" + assistProperty + "%"), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("assistProperty.name", (Object)assistProperty, CompareType.EQUALS));
            }
        }
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("inventoryUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("curMatStoreQty"));
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("assistProperty.id"));
        ev.getSelector().add(new SelectorItemInfo("assistProperty.name"));
        ev.getSelector().add(new SelectorItemInfo("lot"));
        ev.getSelector().add(new SelectorItemInfo("unit.name"));
        ev.getSelector().add(new SelectorItemInfo("curStoreQty"));
        ev.getSelector().add(new SelectorItemInfo("baseQty"));
        ev.getSelector().add(new SelectorItemInfo("lockQty"));
        ev.getSelector().add(new SelectorItemInfo("lockBaseQty"));
        ev.getSelector().add(new SelectorItemInfo("assistUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("curStoreAssistQty"));
        ev.getSelector().add(new SelectorItemInfo("storetype.name"));
        ev.getSelector().add(new SelectorItemInfo("storestatus.name"));
        ev.getSelector().add(new SelectorItemInfo("warehouse.name"));
        ev.getSelector().add(new SelectorItemInfo("location.name"));
        ev.getSelector().add(new SelectorItemInfo("customer.name"));
        ev.getSelector().add(new SelectorItemInfo("supplier.name"));
        ev.getSelector().add(new SelectorItemInfo("warehouse.id"));
        ev.getSelector().add(new SelectorItemInfo("location.id"));
        ev.getSelector().add(new SelectorItemInfo("warehouse.hasLocation"));
        ev.getSelector().add(new SelectorItemInfo("supplier.id"));
        ev.getSelector().add(new SelectorItemInfo("customer.id"));
        ev.getSelector().add(new SelectorItemInfo("storetype.id"));
        ev.getSelector().add(new SelectorItemInfo("storestatus.id"));
        ev.getSelector().add(new SelectorItemInfo("unit.id"));
        ev.getSelector().add(new SelectorItemInfo("multiUnit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("multiAssistUnit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("multiBaseUnit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("multiInventoryUnit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("project.id"));
        ev.getSelector().add(new SelectorItemInfo("project.number"));
        ev.getSelector().add(new SelectorItemInfo("project.name"));
        ev.getSelector().add(new SelectorItemInfo("trackNumber.id"));
        ev.getSelector().add(new SelectorItemInfo("trackNumber.number"));
        ev.getSelector().add(new SelectorItemInfo("trackNumber.name"));
        ev.getSelector().add(new SelectorItemInfo("DateOfMinDurability.mfg"));
        ev.getSelector().add(new SelectorItemInfo("DateOfMinDurability.exp"));
        ev.getSorter().add(new SorterItemInfo("material.number"));
        ev.getSorter().add(new SorterItemInfo("warehouse.number"));
        return ev;
    }

    private FilterInfo getwarePerm(String storageUnitID) throws Exception {
        HashSet<CtrlUnitInfo> cuUnitSets = new HashSet<CtrlUnitInfo>();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("CU.*"));
        StorageOrgUnitInfo storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageUnitID), selectors);
        cuUnitSets.add(storageOrgUnitInfo.getCU());
        int rettype = 0;
        Map warePermMap = InvClientUtils.getwarePemissionSqlMap(cuUnitSets, (int)rettype, (String)"");
        FilterInfo warefilterInfo = this.getwareMapFilter(warePermMap);
        return warefilterInfo;
    }

    private FilterInfo getwareMapFilter(Map warepermMap) throws Exception {
        Map.Entry entry2 = null;
        String wareperm = null;
        FilterInfo wareFilter = null;
        if (warepermMap != null && warepermMap.size() > 0) {
            for (Map.Entry entry2 : warepermMap.entrySet()) {
                wareperm = (String)entry2.getValue();
                wareFilter = new FilterInfo(wareperm);
            }
        }
        return wareFilter;
    }

    protected String getQuerySQL(String bosType, IObjectValue billInfo, IObjectValue billEntryInfo) throws Exception {
        StringBuilder sbFilter;
        this.initDefaultProperty();
        this.initFieldSQL();
        String invField = null;
        String val = null;
        StringBuilder sqlSelect = this.getDefaultSelectSQL();
        StringBuilder sqlFrom = this.getDefaultFromSQL();
        StringBuilder sqlWhere = this.getDefaultWhereSQL();
        StringBuilder supplierBuffer = new StringBuilder();
        StringBuilder customerBuffer = new StringBuilder();
        String linkTable = null;
        String tableAlias = null;
        boolean isTrack = false;
        boolean isProject = false;
        MaterialInfo materialInfo = (MaterialInfo)billEntryInfo.get("material");
        BalanceFieldModelCollection coll = BalanceCfgUtil.getBalanceFieldModelColl(null);
        BalanceFieldModelInfo fieldInfo = null;
        this.tableHeadKeyList.clear();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.getBizDataType() == BizDataTypeEnum.AssistInfo && !fieldInfo.isIsSPvisible()) continue;
            invField = fieldInfo.getFieldName();
            this.fieldTypeMap.put(invField, fieldInfo.getDataType().getValue());
            if (DataTypeEnum.Boolean.equals((Object)fieldInfo.getDataType())) {
                this.boolPropSet.add(invField);
            } else if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                this.linkPropBosTypeMap.put(invField, fieldInfo.getBaseDataBOSType());
            }
            if (this.defaultProperty.contains(invField)) {
                if (invField.equalsIgnoreCase("FMaterialID")) {
                    this.tableHeadKeyList.add("materialHelpCode");
                    this.tableHeadKeyList.add(invField);
                    this.resMap.put("materialHelpCode", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"MaterialHelpCode"));
                    this.resMap.put(invField, fieldInfo.getAlias());
                } else if (invField.equalsIgnoreCase("FLot")) {
                    this.tableHeadKeyList.add(invField);
                    this.tableHeadKeyList.add("Mfg");
                    this.tableHeadKeyList.add("Exp");
                    this.resMap.put(invField, fieldInfo.getAlias());
                    this.resMap.put("Mfg", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"mfg", null));
                    this.resMap.put("Exp", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"exp", null));
                } else {
                    this.tableHeadKeyList.add(invField);
                    this.resMap.put(invField, fieldInfo.getAlias());
                    if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType()) && fieldInfo.getBaseDataBOSType() != null) {
                        this.tableHeadKeyList.add(invField + "pk_hide");
                    }
                }
            } else {
                tableAlias = "t" + i;
                this.tableHeadKeyList.add(invField);
                this.resMap.put(invField, fieldInfo.getAlias());
                if (!"FEntrySeq".equals(invField)) {
                    this.fieldSQL.append(" , ").append(invField);
                }
                if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                    sqlSelect.append(", ").append(tableAlias).append(".fname_").append(this.loc).append(" as ").append(invField).append(" \r\n");
                    sqlSelect.append(", ").append(tableAlias).append(".fid as ").append(invField + "pk_hide").append(" \r\n");
                    IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                    IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldInfo.getBaseDataBOSType()));
                    EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                    linkTable = entityObjInfo.getTable().getName();
                    sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on inventory.").append(invField).append("=").append(tableAlias).append(".fid \r\n");
                    this.tableHeadKeyList.add(invField + "pk_hide");
                    this.fieldSQL.append(" , ").append(invField + "pk_hide");
                } else {
                    sqlSelect.append(", INVENTORY.").append(invField);
                }
            }
            Object propValue = this.propMap.get(invField);
            val = this.getPropStringValue(propValue);
            if (StringUtil.isEmpty((String)val)) {
                if (this.condition.get("nullValueFieldSet") == null || !((Set)this.condition.get("nullValueFieldSet")).contains(invField)) continue;
                if ("FLocationID".equals(invField)) {
                    sqlWhere.append(" and inventory.").append(invField).append("= 'EgkAAABc3XMgX/hq'");
                }
                if ("FLot".equals(invField)) {
                    sqlWhere.append(" and inventory.").append(invField).append("= 'YNi0IQEOEADgBT3mfwAAAcznrtQ='");
                }
                if ("FAssistPropertyID".equals(invField)) {
                    sqlWhere.append(" and inventory.").append(invField).append("= 'EgkAAAA5EWALxvQu'");
                }
                if ("FProjectID".equals(invField)) {
                    sqlWhere.append(" and inventory.").append(invField).append("= 'EgkAAABc3Xza3gXu'");
                }
                if (!"FTrackNumberID".equals(invField)) continue;
                sqlWhere.append(" and inventory.").append(invField).append("= 'EgkAAABc3X0Ibpg9'");
                continue;
            }
            if (invField.equals("FSupplierID")) {
                supplierBuffer.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FCustomerID")) {
                customerBuffer.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (propValue instanceof Date || DataTypeEnum.Date.equals((Object)fieldInfo.getDataType())) {
                sqlWhere.append(" and inventory.").append(invField).append("= to_date('").append(val).append("')");
                continue;
            }
            if (invField.equals("FUnitID") || invField.equals("FBaseUnitID")) {
                if ((!invField.equals("FBaseUnitID") || !this.isUpdateByBaseUnit) && (!invField.equals("FUnitID") || this.isUpdateByBaseUnit)) continue;
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FProjectID")) {
                if (!isProject) continue;
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FTrackNumberID")) {
                if (!isTrack) continue;
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FStorageOrgUnitID")) {
                isTrack = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FTrackNumber", val);
                isProject = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FProjectNumber", val);
                sqlWhere.append(" and inventory.").append(invField).append("='").append(this.sou == null ? val : this.sou.getId().toString()).append("'");
                continue;
            }
            sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
        }
        this.tableHeadKeyList.remove("FCompanyOrgUnitID");
        this.tableHeadKeyList.remove("FCompanyOrgUnitIDpk_hide");
        this.tableHeadKeyList.remove("FMaterialID");
        this.tableHeadKeyList.remove("FMaterialIDpk_hide");
        this.tableHeadKeyList.remove("FBaseUnitID");
        this.tableHeadKeyList.remove("FBaseUnitIDpk_hide");
        this.tableHeadKeyList.remove("FAmount");
        this.tableHeadKeyList.remove("FLockAssistQty");
        this.tableHeadKeyList.remove("FID");
        this.tableHeadKeyList.remove("FBillEntryID");
        this.tableHeadKeyList.remove("FEntrySeq");
        this.tableHeadKeyList.add("FReservationQty");
        this.tableHeadKeyList.add("FReservationBaseQty");
        this.tableHeadKeyList.add("FReservationAssistQty");
        this.resMap.put("FReservationQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationQty", null));
        this.resMap.put("FReservationBaseQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationBaseQty", null));
        this.resMap.put("FReservationAssistQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationAssistQty", null));
        this.resMap.put("FCurStoreQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realQty", null));
        this.resMap.put("FCurStoreAssistQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realAssistQty", null));
        this.resMap.put("FBaseQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realBaseQty", null));
        this.resMap.put("boolFieldSet", this.boolPropSet);
        this.fieldTypeMap.put("FReservationQty", "Qty");
        this.fieldTypeMap.put("FReservationBaseQty", "Qty");
        this.fieldTypeMap.put("FReservationAssistQty", "Qty");
        StringBuilder sb = this.getSupCustomerWhereSQL(supplierBuffer, customerBuffer, billEntryInfo);
        if (sb.length() > 0) {
            sqlWhere.append((CharSequence)sb);
        }
        if ((sbFilter = this.getFilterSQL()).length() > 0) {
            sqlWhere.append((CharSequence)sbFilter);
        }
        StringBuilder sql = new StringBuilder();
        this.initPermissionSQL();
        sql.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom);
        if (!StringUtil.isEmpty((String)this.permissionJoinSQL)) {
            sql.append(this.permissionJoinSQL);
        }
        sql.append((CharSequence)sqlWhere);
        if (!StringUtil.isEmpty((String)this.permissionSQL)) {
            this.permissionSQL = this.permissionSQL.replaceAll("\"T6\".\"FNUMBER\"", "warehouse.fnumber");
            this.permissionSQL = this.permissionSQL.replaceAll("\"T7\".\"FNUMBER\"", "location.fnumber");
            this.permissionSQL = this.permissionSQL.replaceAll("\"T12\".\"FNUMBER\"", "material.fnumber");
            sql.append(" and ").append(this.permissionSQL);
        }
        sql.append(" order by FLot asc");
        return sql.toString();
    }

    protected boolean isTrackNumberOrProjectNumberFilter(MaterialInfo materialInfo, String trOrPr, String val) throws EASBizException, BOSException {
        if (materialInfo == null) {
            return false;
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getRemoteInstance();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("where material.id = '").append(materialInfo.getId().toString()).append("' and orgUnit.id = '").append(val).append("'");
        MaterialInventoryInfo inventoryInfo = iMaterialInventory.getMaterialInventoryInfo(stringBuffer.toString());
        if (trOrPr.equals("FTrackNumber")) {
            return inventoryInfo.isIsTrackingNumber();
        }
        if (trOrPr.equals("FProjectNumber")) {
            return inventoryInfo.isIsProjectNumber();
        }
        return false;
    }

    @Override
    protected StringBuilder getDefaultSelectSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT INVENTORY.FID AS FID, \r\n");
        sb.append(" MATERIAL.FAssistAttr AS MATERIALASSISTATTR,  \r\n");
        sb.append(" STORAGEORGUNIT.FID AS FStorageOrgUnitIDpk_hide, \r\n");
        sb.append(" STORAGEORGUNIT.FName_").append(this.loc).append(" AS FStorageOrgUnitID,  \r\n");
        sb.append(" STORAGEORGUNIT.FNumber AS STORAGEORGNUMBER,  \r\n");
        sb.append(" WAREHOUSE.FName_").append(this.loc).append(" AS FWarehouseID, \r\n");
        sb.append(" WAREHOUSE.FNumber AS WAREHOUSENUMBER,  \r\n");
        sb.append(" LOCATION.FName_").append(this.loc).append(" AS FLocationID,  \r\n");
        sb.append(" LOCATION.FNumber AS LOCATIONNUMBER,  \r\n");
        sb.append(" STORETYPE.FName_").append(this.loc).append(" AS FStoreTypeID,  \r\n");
        sb.append(" STORETYPE.FNumber AS STORETYPENUMBER,  \r\n");
        sb.append(" UNIT.FName_").append(this.loc).append(" AS FUnitID, \r\n");
        sb.append(" UNIT.FID AS FUnitIDpk_hide, \r\n");
        sb.append(" UNIT.FNumber AS UNITNUMBER,    \r\n");
        sb.append(" ASSISTUNIT.FName_").append(this.loc).append(" AS FAssistUnitID,  \r\n");
        sb.append(" ASSISTUNIT.FID AS FAssistUnitIDpk_hide,  \r\n");
        sb.append(" ASSISTUNIT.FNumber AS ASSISTUNITNUMBER,   \r\n");
        sb.append(" ROUND(INVENTORY.FCurStoreQty ");
        sb.append(" - ");
        sb.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0), MULTIUNIT.FQtyPrecision) ");
        sb.append(" AS FCurStoreQty,  \r\n");
        sb.append(" ROUND(INVENTORY.FCurStoreAssistQty - ISNULL(RESERVATION.FReservationAssistQty, 0), MULTIASSISTUNIT.FQtyPrecision) AS FCurStoreAssistQty,  \r\n");
        sb.append(" ROUND(INVENTORY.FBaseQty - ISNULL(RESERVATION.FReservationBaseQty, 0), MULTIBASEUNIT.FQtyPrecision) AS FBaseQty,   \r\n");
        sb.append(" MATERIAL.FModel AS MATERIALMODEL,   \r\n");
        sb.append(" MATERIAL.FHelpCode AS materialHelpCode, \r\n");
        sb.append(" STORESTATUS.FNumber AS STORESTATUSNUMBER,  \r\n");
        sb.append(" STORESTATUS.FName_").append(this.loc).append(" AS FStoreStatusID,   \r\n");
        sb.append(" MATERIAL.FName_").append(this.loc).append(" AS MATERIALNAME,   \r\n");
        sb.append(" MATERIAL.FNumber AS MATERIALNUMBER,  \r\n");
        sb.append(" INVENTORY.FMaterialID AS MATERIALID,   \r\n");
        sb.append(" FBASEUNIT.FName_").append(this.loc).append(" AS FBaseUnitID, \r\n");
        sb.append(" MULTIBASEUNIT.FQtyPrecision AS MULTIBASEUNITQTYPRECISION,   \r\n");
        sb.append(" MULTIASSISTUNIT.FQtyPrecision AS MULTIASSISTUNITQTYPRECISION,   \r\n");
        sb.append(" MULTIUNIT.FQtyPrecision AS MULTIUNITQTYPRECISION,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE INVENTORY.FLot END AS FLot,    \r\n");
        sb.append(" PROJECT.FNumber AS FProjectID,   \r\n");
        sb.append(" TRACKNUMBER.FNumber AS FTrackNumberID,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' THEN NULL ELSE INVENTORY.FAssistPropertyID END AS FAssistPropertyIDpk_hide,   \r\n");
        sb.append(" ASSISTPROPERTY.FNumber AS ASSISTPROPERTYNUMBER,    \r\n");
        sb.append(" ASSISTPROPERTY.FName_").append(this.loc).append(" AS FAssistPropertyID,    \r\n");
        sb.append(" SUPPLIER.FName_").append(this.loc).append(" AS FSupplierID,    \r\n");
        sb.append(" SUPPLIER.FNumber AS SUPPLIERNUMBER,   \r\n");
        sb.append(" CUSTOMER.FName_").append(this.loc).append(" AS FCustomerID,    \r\n");
        sb.append(" CUSTOMER.FNumber AS CUSTOMERNUMBER,   \r\n");
        sb.append(" ISNULL(ROUND(RESERVATION.FReservationQty, MULTIUNIT.FQtyPrecision), 0) AS FReservationQty,   \r\n");
        sb.append(" ISNULL(ROUND(RESERVATION.FReservationBaseQty, MULTIBASEUNIT.FQtyPrecision), 0) AS FReservationBaseQty,   \r\n");
        sb.append(" ISNULL(ROUND(RESERVATION.FReservationAssistQty, MULTIASSISTUNIT.FQtyPrecision), 0) AS FReservationAssistQty,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' THEN NULL ELSE INVENTORY.FLocationID END AS FLocationIDpk_hide,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' THEN NULL ELSE INVENTORY.FWarehouseID END AS FWarehouseIDpk_hide,    \r\n");
        sb.append(" WAREHOUSE.FHasLocation AS WAREHOUSEHASLOCATION,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' THEN NULL ELSE INVENTORY.FSupplierID END AS FSupplierIDpk_hide,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' THEN NULL ELSE INVENTORY.FCustomerID END AS FCustomerIDpk_hide,   \r\n");
        sb.append(" INVENTORY.FUnitID AS FUnitIDpk_hide,    \r\n");
        sb.append(" INVENTORY.FStoreTypeID AS FStoreTypeIDpk_hide,     \r\n");
        sb.append(" INVENTORY.FStoreStatusID AS FStoreStatusIDpk_hide,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FProjectID = '").append("EgkAAABc3Xza3gXu").append("' THEN NULL ELSE INVENTORY.FProjectID END AS FProjectIDpk_hide,     \r\n");
        sb.append(" CASE  WHEN INVENTORY.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' THEN NULL ELSE INVENTORY.FTrackNumberID END AS FTrackNumberIDpk_hide,    \r\n");
        sb.append(" ROUND(DECIMAL((INVENTORY.FBaseQty / MULTIINVENTORYUNIT.FBaseConvsRate), 21, 8), MULTIINVENTORYUNIT.FQtyPrecision) AS CURMATSTOREQTY,      \r\n");
        sb.append(" MULTIINVENTORYUNIT.FQtyPrecision AS MULTIINVENTORYUNITQTYPRECIS43,    \r\n");
        sb.append(" to_char(DATEOFMINDURABILITY.FMfg,'yyyy-mm-dd') AS MFG,     \r\n");
        sb.append(" to_char(DATEOFMINDURABILITY.FExp,'yyyy-mm-dd') AS EXP    \r\n");
        return sb;
    }

    @Override
    protected StringBuilder getDefaultFromSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM T_IM_Inventory AS INVENTORY \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON INVENTORY.FSupplierID = SUPPLIER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATUS ON INVENTORY.FStoreStatusID = STORESTATUS.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON INVENTORY.FStoreTypeID = STORETYPE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON INVENTORY.FLocationID = LOCATION.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID \r\n");
        sb.append(" INNER JOIN T_ORG_Storage AS STORAGEORGUNIT ON INVENTORY.FStorageOrgUnitID = STORAGEORGUNIT.FID \r\n");
        sb.append(" INNER JOIN T_ORG_Company AS COMPANYORGUNIT ON INVENTORY.FCompanyOrgUnitID = COMPANYORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON INVENTORY.FMaterialID = MATERIAL.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON INVENTORY.FUnitID = UNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON INVENTORY.FAssistUnitID = ASSISTUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON INVENTORY.FMaterialID = MULTIBASEUNIT.FMaterialID AND INVENTORY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSISTUNIT ON INVENTORY.FMaterialID = MULTIASSISTUNIT.FMaterialID AND INVENTORY.FAssistUnitID = MULTIASSISTUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON INVENTORY.FAssistPropertyID = ASSISTPROPERTY.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON INVENTORY.FCustomerID = CUSTOMER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON INVENTORY.FProjectID = PROJECT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON INVENTORY.FTrackNumberID = TRACKNUMBER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialInventory AS MATLINVENTORY ON INVENTORY.FStorageOrgUnitID = MATLINVENTORY.FOrgUnit AND INVENTORY.FMaterialID = MATLINVENTORY.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON INVENTORY.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND INVENTORY.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND INVENTORY.FLot = DATEOFMINDURABILITY.FLot \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS FBASEUNIT ON MATERIAL.FBaseUnit = FBASEUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS INVENTORYUNIT ON MATLINVENTORY.FUnitID = INVENTORYUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIINVENTORYUNIT ON MATLINVENTORY.FMaterialID = MULTIINVENTORYUNIT.FMaterialID AND MATLINVENTORY.FUnitID = MULTIINVENTORYUNIT.FMeasureUnitID \r\n");
        sb.append((CharSequence)this.getReservationSQL());
        return sb;
    }

    @Override
    protected StringBuilder getDefaultWhereSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE (ROUND(INVENTORY.FCurStoreQty  -  ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0), MULTIUNIT.FQtyPrecision) <> 0) ");
        return sb;
    }

    private void initPermissionSQL() throws BOSException {
        if (this.sou == null) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.sou.getId().toString());
        Map permMap = SCMBillCommonFacadeFactory.getRemoteInstance().getPermissionEntityViewMap(ids, null);
        this.permissionSQL = (String)permMap.get("PERM_WHERE");
        this.permissionJoinSQL = (String)permMap.get("PERM_JOIN");
    }

    private StringBuilder getFilterSQL() {
        StringBuilder sb = new StringBuilder();
        String lot = this.condition.get("lot").toString();
        String assistProperty = this.condition.get("assistProperty").toString();
        boolean isLikeQuery = (Boolean)this.condition.get("isLikeQuery");
        if (lot != null && lot.length() > 0) {
            sb.append(" and ");
            if (isLikeQuery) {
                sb.append("  (INVENTORY.FLot like '%" + lot + "%' )  ");
            } else {
                sb.append("  (INVENTORY.FLot = '" + lot + "' )  ");
            }
        }
        if (assistProperty != null && assistProperty.length() > 0) {
            sb.append(" and ");
            if (isLikeQuery) {
                sb.append("(  ASSISTPROPERTY.fname_").append(this.loc).append("  LIKE '%" + assistProperty + "%' )   ");
            } else {
                sb.append("(  ASSISTPROPERTY.fname_").append(this.loc).append("  = '" + assistProperty + "' )   ");
            }
        }
        return sb;
    }

    private void setIsIssue(TransactionTypeInfo transTypeInfo) {
        RecIssueTypeInfo riType = transTypeInfo.getRiType();
        if (riType == null || riType.getRI() == null || riType.getBizDirection() == null) {
            return;
        }
        RIEnum ri = riType.getRI();
        BizDirectionEnum bizDirection = riType.getBizDirection();
        if (ri == RIEnum.Receive && bizDirection == BizDirectionEnum.back || ri == RIEnum.Issue && bizDirection == BizDirectionEnum.normal) {
            this.isIssue = true;
        }
    }

    @Override
    protected void initFieldSQL() {
        this.fieldSQL = new StringBuilder();
        this.fieldSQL.append(" FStorageOrgUnitID, ");
        this.fieldSQL.append(" STORAGEORGUNITNUMBER, ");
        this.fieldSQL.append(" FStorageOrgUnitIDpk_hide, ");
        this.fieldSQL.append(" FWarehouseID, ");
        this.fieldSQL.append(" FWarehouseIDpk_hide, ");
        this.fieldSQL.append(" WAREHOUSENUMBER, ");
        this.fieldSQL.append(" FLocationID,");
        this.fieldSQL.append(" FLocationIDpk_hide, ");
        this.fieldSQL.append(" LOCATIONNUMBER, ");
        this.fieldSQL.append(" FLot, ");
        this.fieldSQL.append(" Mfg, ");
        this.fieldSQL.append(" Exp, ");
        this.fieldSQL.append(" FStoreTypeID, ");
        this.fieldSQL.append(" FStoreTypeIDpk_hide, ");
        this.fieldSQL.append(" STORETYPENUMBER, ");
        this.fieldSQL.append(" FStoreStatusID, ");
        this.fieldSQL.append(" FStoreStatusIDpk_hide, ");
        this.fieldSQL.append(" STORESTATUSNUMBER, ");
        this.fieldSQL.append(" FSupplierID, ");
        this.fieldSQL.append(" SUPPLIERNUMBER, ");
        this.fieldSQL.append(" FSupplierIDpk_hide, ");
        this.fieldSQL.append(" FCustomerID, ");
        this.fieldSQL.append(" FCustomerIDpk_hide, ");
        this.fieldSQL.append(" CUSTOMERNUMBER, ");
        this.fieldSQL.append(" materialHelpCode, ");
        this.fieldSQL.append(" FUnitIDpk_hide, ");
        this.fieldSQL.append(" UNITNUMBER, ");
        this.fieldSQL.append(" FUnitID, ");
        this.fieldSQL.append(" FCurStoreQty, ");
        this.fieldSQL.append(" FAssistUnitID, ");
        this.fieldSQL.append(" ASSISTUNITNUMBER, ");
        this.fieldSQL.append(" FAssistUnitIDpk_hide, ");
        this.fieldSQL.append(" FCurStoreAssistQty, ");
        this.fieldSQL.append(" FBaseQty, ");
        this.fieldSQL.append(" FAssistPropertyIDpk_hide, ");
        this.fieldSQL.append(" FAssistPropertyID, ");
        this.fieldSQL.append(" ASSISTPROPERTYNUMBER, ");
        this.fieldSQL.append(" FProjectID, ");
        this.fieldSQL.append(" FProjectIDpk_hide, ");
        this.fieldSQL.append(" FTrackNumberID, ");
        this.fieldSQL.append(" FTrackNumberIDpk_hide, ");
        this.fieldSQL.append(" ID, ");
        this.fieldSQL.append(" MULTIUNITQTYPRECISION, ");
        this.fieldSQL.append(" MULTIBASEUNITQTYPRECISION, ");
        this.fieldSQL.append(" MULTIASSISTUNITQTYPRECISION, ");
        this.fieldSQL.append(" COMPANYORGUNITNAME, ");
        this.fieldSQL.append(" FReservationQty, ");
        this.fieldSQL.append(" FReservationBaseQty, ");
        this.fieldSQL.append(" FReservationAssistQty, ");
        this.fieldSQL.append(" INVENTORYUNITNAME, ");
        this.fieldSQL.append(" CURMATSTOREQTY, ");
        this.fieldSQL.append(" MULTIINVENTORYUNITQTYPRECIS32, ");
        this.fieldSQL.append(" MULTIBASEUNITBASECONVSRATE, ");
        this.fieldSQL.append(" MULTIUNITBASECONVSRATE, ");
        this.fieldSQL.append(" MULTIASSITUNITQTYPRECISION, ");
    }

    private void setIsStock(String bosType) {
        if ("2239F30A".equals(bosType)) {
            this.isStockTransferBill = true;
        }
    }
}

