/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.OrgUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMaterialRequestWebFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.SupplyRelationServerUtils;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MaterialRequestWebFacadeControllerBean
extends AbstractMaterialRequestWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MaterialRequestWebFacadeControllerBean");
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    public String getMainOrgUnitName() {
        return "requestOrgUnit";
    }

    protected ISCMBillBase getLocalInstance(Context context) throws BOSException {
        return MaterialRequestBillFactory.getLocalInstance(context);
    }

    public String getPermissionItem() {
        if (OprtStateConstant.EDIT.equals(this.oprtState)) {
            return "materialRequest_update";
        }
        if (OprtStateConstant.VIEW.equals(this.oprtState)) {
            return "materialRequest_view";
        }
        return "materialRequest_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Admin;
    }

    public IObjectValue createNewData(Context context, IObjectValue model) throws BOSException, EASBizException {
        return this.createNewData(context, model, null, null, true);
    }

    public IObjectValue createNewData(Context context, IObjectValue model, AdminOrgUnitInfo adminOrg, BizTypeInfo bizType, boolean isOnload) throws BOSException, EASBizException {
        MaterialRequestBillInfo info = null;
        CompanyOrgUnitInfo cou = null;
        info = model == null ? new MaterialRequestBillInfo() : (MaterialRequestBillInfo)model;
        if (info != null && info.getRequestOrgUnit() != null) {
            adminOrg = info.getRequestOrgUnit();
        } else if (adminOrg == null) {
            adminOrg = (AdminOrgUnitInfo)this.getDefaultMainBizOrg(context);
        }
        cou = this.getCompanyByMainOrg(context, adminOrg);
        if (cou == null && !isOnload) {
            throw new EASBizException(new NumericExceptionSubItem("10001", SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.SCMInvResource", (String)"CompanyByMainOrg_isNull", (Context)context)));
        }
        if (cou == null) {
            adminOrg = null;
            info.setRequestOrgUnit(null);
            info.setCompanyOrgUnit(null);
        } else {
            info.setRequestOrgUnit(adminOrg);
            info.setCompanyOrgUnit(cou);
        }
        UserInfo user = UserFactory.getLocalInstance((Context)context).getUserInfo(context.getCaller());
        if (user.getPerson() != null) {
            ObjectUuidPK personPK = new ObjectUuidPK(user.getPerson().getId().toString());
            PersonInfo person = PersonFactory.getLocalInstance((Context)context).getPersonInfo((IObjectPK)personPK);
            info.setRequestPerson(person);
        }
        if (bizType == null) {
            bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)context, (String)"0rSFjAEeEADgAAyMwKgSQiQHQ1w=", (String)"XlazxwEREADgAAAEwKgSxUY+1VI=");
            info.setBizType(bizType);
        } else {
            info.setBizType(bizType);
        }
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setTotalStandardCost(ZERO);
        info.setTotalActualCost(ZERO);
        info.setTotalQty(ZERO);
        info.setTotalAmount(ZERO);
        info.setHasEffected(false);
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setCreator(user);
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"XlazxwEREADgAAAEwKgSxUY+1VI="));
        aBillTypeInfo.setNumber("160");
        info.setBillType(aBillTypeInfo);
        info.setFiVouchered(false);
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        info.setCreateTime(ts);
        info.setBizDate(curDate);
        if (info.getEntry() != null) {
            MaterialRequestBillEntryInfo entry = null;
            Object issueSale = null;
            for (int i = 0; i < 5; ++i) {
                entry = (MaterialRequestBillEntryInfo)this.createNewDetailData(context, model);
                entry.setCompanyOrgUnit(cou);
                info.getEntry().add(entry);
            }
        }
        return info;
    }

    public IObjectValue createNewDetailData(Context context, IObjectValue model) throws BOSException, EASBizException {
        MaterialRequestBillEntryInfo entry = new MaterialRequestBillEntryInfo();
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        entry.setApprovedQty(ZERO);
        entry.setBaseQty(ZERO);
        entry.setApprovedBaseQty(ZERO);
        entry.setAssistQty(ZERO);
        entry.setApprovedAssitQty(ZERO);
        entry.setTotalFinishQty(ZERO);
        entry.setReturnBaseQty(ZERO);
        entry.setAssociateQty(ZERO);
        return entry;
    }

    private CompanyOrgUnitInfo getCompanyByMainOrg(Context ctx, AdminOrgUnitInfo adminOrg) throws EASBizException, BOSException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(adminOrg.getId().toString(), 0, 1);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
        return ret;
    }

    public void initData(Context context, Map initData, IObjectValue model) throws EASBizException, BOSException {
        super.initData(context, initData, model);
        MaterialRequestBillInfo info = (MaterialRequestBillInfo)model;
        BizTypeInfo bizType = info.getBizType();
        CompanyOrgUnitInfo cou = info.getCompanyOrgUnit();
        AdminOrgUnitInfo mainOrg = (AdminOrgUnitInfo)model.get(this.getMainOrgUnitName());
        if (mainOrg != null && cou == null) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(mainOrg.getId().toString(), 0, 1);
            cou = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        if (cou == null || mainOrg == null) {
            return;
        }
        StorageOrgUnitCollection inSouCol = this.getStorageUnitsByCou(context, cou);
        StorageOrgUnitInfo inSou = null;
        StorageOrgUnitInfo outSou = null;
        inSou = this.getInSou(context, mainOrg, cou, bizType, inSouCol);
        StorageOrgUnitCollection outSouCol = this.getOutStorageUnitCol(context, mainOrg, cou, bizType, inSouCol, inSou);
        outSou = this.getOutSou(context, cou, bizType, outSouCol, inSou);
        initData.put("company", cou);
        initData.put("defaultInSou", inSou);
        initData.put("defaultOutSou", outSou);
        initData.put("inSouFilter", this.getSouIdFilter(inSouCol));
        initData.put("outSouFilter", this.getSouIdFilter(outSouCol));
        initData.put("params", this.getParamsMap(context));
    }

    private String getSouIdFilter(StorageOrgUnitCollection souCol) {
        StringBuffer filter = new StringBuffer("id in (");
        for (int i = 0; i < souCol.size(); ++i) {
            if (i == 0) {
                filter.append(" '" + souCol.get(i).getId().toString() + "'");
                continue;
            }
            filter.append(",'" + souCol.get(i).getId().toString() + "'");
        }
        if (souCol.isEmpty()) {
            filter.append(" 'not_exist'");
        }
        filter.append(")");
        return filter.toString();
    }

    private Map getParamsMap(Context ctx) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map noOrgParamMap = this.batchGetParamValue(ctx, null, new String[]{"DISCOUNTRATEPRECISION"});
        paramMap.putAll(noOrgParamMap);
        return paramMap;
    }

    private Map getOrgParamsMap(Context ctx, String souId, String couId) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map souParamMap = this.batchGetParamValue(ctx, souId, new String[]{"INM004", "INM008", "INM007"});
        String paramName = null;
        for (Object key : souParamMap.keySet()) {
            paramName = (String)key;
            paramMap.put(souId + paramName, souParamMap.get(key));
        }
        return paramMap;
    }

    public Map handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        return super.handleMainOrgChange(ctx, mainOrgId);
    }

    @Override
    protected Map _getFilter(Context ctx, Map requestMap) throws BOSException, EASBizException {
        return null;
    }

    private StorageOrgUnitInfo getInSou(Context ctx, AdminOrgUnitInfo adminOrg, CompanyOrgUnitInfo cou, BizTypeInfo bizType, StorageOrgUnitCollection souCol) throws EASBizException, BOSException {
        for (int i = 0; i < souCol.size(); ++i) {
            if (!adminOrg.getId().toString().equals(souCol.get(i).getId().toString())) continue;
            return souCol.get(i);
        }
        if (!souCol.isEmpty()) {
            return souCol.get(0);
        }
        return null;
    }

    private StorageOrgUnitInfo getOutSou(Context ctx, CompanyOrgUnitInfo cou, BizTypeInfo bizType, StorageOrgUnitCollection souCol, StorageOrgUnitInfo inSou) {
        if (this.isJumpOrg(bizType)) {
            for (int i = 0; i < souCol.size(); ++i) {
                if (souCol.get(i).getId().equals((Object)inSou.getId())) continue;
                return souCol.get(i);
            }
        } else {
            return inSou;
        }
        return null;
    }

    private StorageOrgUnitCollection getOutStorageUnitCol(Context ctx, AdminOrgUnitInfo adminOrg, CompanyOrgUnitInfo cou, BizTypeInfo bizType, StorageOrgUnitCollection souCol, StorageOrgUnitInfo inSou) throws EASBizException, BOSException {
        if (bizType == null) {
            return souCol;
        }
        String bizTypeId = bizType.getId().toString();
        StorageOrgUnitCollection outSouCol = new StorageOrgUnitCollection();
        if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizTypeId) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizTypeId)) {
            for (int i = 0; i < souCol.size(); ++i) {
                outSouCol.add(souCol.get(i));
            }
            return outSouCol;
        }
        if ("nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizTypeId)) {
            return this.getOutStorageUnitColForJumCompany(ctx, adminOrg, cou, bizType, outSouCol, inSou);
        }
        if ("0rSFjAEeEADgAAyMwKgSQiQHQ1w=".equals(bizTypeId)) {
            return souCol;
        }
        return souCol;
    }

    private StorageOrgUnitCollection getOutStorageUnitColForJumCompany(Context ctx, AdminOrgUnitInfo adminOrg, CompanyOrgUnitInfo cou, BizTypeInfo bizType, StorageOrgUnitCollection souCol, StorageOrgUnitInfo inSou) throws EASBizException, BOSException {
        if (adminOrg == null || cou == null || inSou == null) {
            return null;
        }
        String[] fromStIds = new String[]{null};
        String[] fromCpIds = new String[]{null};
        BizRoleTypeEnum[] fromTypes = new BizRoleTypeEnum[]{null};
        fromStIds[0] = inSou.getId().toString();
        fromCpIds[0] = cou.getId().toString();
        fromTypes[0] = BizRoleTypeEnum.RequireSide;
        EntityViewInfo view = null;
        OrgUnitInfo[] mainOrgs = OrgUnitUtils.getMainBizOrgList((Context)ctx, (OrgType)OrgType.Storage, (String)"transferorder_new");
        view = SupplyRelationServerUtils.getStorageOrgUnitViewBySupplyRelation(ctx, adminOrg.getId().toString(), "d8e80652-0117-1000-e000-04c5c0a812202407435C", fromStIds, fromCpIds, fromTypes, BizRoleTypeEnum.SupplySide, "transferorder_new", null, null, null);
        StorageOrgUnitCollection outOrg = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
        return outOrg;
    }

    private StorageOrgUnitCollection getStorageUnitsByCou(Context ctx, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        OrgUnitCollection orgCol = OrgUtils.getFromOrgUnitColl((Context)ctx, (String)cou.getId().toString(), (OrgType)OrgType.Company, (OrgType)OrgType.Storage);
        HashSet<String> storageOrgUnitIDs = new HashSet<String>();
        for (int i = 0; i < orgCol.size(); ++i) {
            storageOrgUnitIDs.add(orgCol.get(i).get("id").toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection src = new SelectorItemCollection();
        src.add(new SelectorItemInfo("id"));
        src.add(new SelectorItemInfo("name"));
        src.add(new SelectorItemInfo("number"));
        ev.setSelector(src);
        filter.getFilterItems().add(new FilterItemInfo("id", storageOrgUnitIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer("1"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer("0"), CompareType.EQUALS));
        ev.setFilter(filter);
        StorageOrgUnitCollection souCol = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(ev);
        return souCol;
    }

    private boolean isJumpOrg(BizTypeInfo bizTypeInfo) {
        boolean flag = false;
        if (bizTypeInfo == null || bizTypeInfo.getId() == null) {
            return flag;
        }
        String bizTypeID = bizTypeInfo.getId().toString();
        if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizTypeID) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizTypeID) || "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizTypeID)) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected Map _dataChange(Context ctx, Map requestMap) throws BOSException, EASBizException {
        String dataName = (String)requestMap.get("dataName");
        if ("requestOrgUnit".equals(dataName)) {
            return this.mainOrgChange(ctx, requestMap);
        }
        if ("bizType".equals(dataName)) {
            return this.bizTypeChange(ctx, requestMap);
        }
        return null;
    }

    private Map mainOrgChange(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, MaterialRequestBillInfo> map = new HashMap<String, MaterialRequestBillInfo>();
        String bizTypeId = (String)requestMap.get("bizTypeId");
        String orgId = (String)requestMap.get("orgId");
        AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
        adminOrg.setId(BOSUuid.read((String)orgId));
        BizTypeInfo bizType = new BizTypeInfo();
        if (StringUtils.isEmpty((CharSequence)bizTypeId)) {
            bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)ctx, (String)"0rSFjAEeEADgAAyMwKgSQiQHQ1w=", (String)"XlazxwEREADgAAAEwKgSxUY+1VI=");
        } else {
            bizType.setId(BOSUuid.read((String)bizTypeId));
        }
        MaterialRequestBillInfo info = new MaterialRequestBillInfo();
        this.createNewData(ctx, (IObjectValue)info, adminOrg, bizType, false);
        this.initData(ctx, map, (IObjectValue)info);
        map.put("newModel", info);
        return map;
    }

    private Map bizTypeChange(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String bizTypeId = (String)requestMap.get("bizTypeId");
        String orgId = (String)requestMap.get("orgId");
        String couId = (String)requestMap.get("couId");
        BizTypeInfo bizType = new BizTypeInfo();
        bizType.setId(BOSUuid.read((String)bizTypeId));
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)couId));
        AdminOrgUnitInfo mainOrg = new AdminOrgUnitInfo();
        mainOrg.setId(BOSUuid.read((String)orgId));
        StorageOrgUnitCollection inSouCol = this.getStorageUnitsByCou(ctx, cou);
        StorageOrgUnitInfo inSou = null;
        StorageOrgUnitInfo outSou = null;
        inSou = this.getInSou(ctx, mainOrg, cou, bizType, inSouCol);
        StorageOrgUnitCollection outSouCol = this.getOutStorageUnitCol(ctx, mainOrg, cou, bizType, inSouCol, inSou);
        outSou = this.getOutSou(ctx, cou, bizType, outSouCol, inSou);
        map.put("defaultInSou", inSou);
        map.put("defaultOutSou", outSou);
        map.put("inSouFilter", this.getSouIdFilter(inSouCol));
        map.put("outSouFilter", this.getSouIdFilter(outSouCol));
        return map;
    }
}

