/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.im.inv.IMaterialSNInventory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFactory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberException;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.app.AbstractMaterialSNInventoryControllerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialSNInventoryControllerBean
extends AbstractMaterialSNInventoryControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MaterialSNInventoryControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue SNInfo) throws BOSException, EASBizException {
        return super._save(ctx, SNInfo);
    }

    protected Result _save(Context ctx, IObjectCollection SNInfos) throws BOSException, EASBizException {
        return super._save(ctx, SNInfos);
    }

    @Override
    protected void _saveMaterialSNInventoryBatch(Context ctx, IObjectCollection SNInfos) throws BOSException, EASBizException {
        if (SNInfos == null || SNInfos.size() == 0) {
            return;
        }
        this.serialNumberSavecheck(ctx, (MaterialSNInventoryCollection)SNInfos);
        for (int i = 0; i < SNInfos.size(); ++i) {
            super._save(ctx, SNInfos.getObject(i));
        }
    }

    private void serialNumberSavecheck(Context ctx, MaterialSNInventoryCollection SNInfos) throws EASBizException, BOSException {
        String MaterialId;
        HashSet<String> MaterialIds = new HashSet<String>();
        for (int i = 0; i < SNInfos.size(); ++i) {
            MaterialIds.add(SNInfos.get(i).getMaterial().getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", MaterialIds, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("material.id"));
        ev.getSelector().add(new SelectorItemInfo("serialNumber"));
        ev.getSorter().add(new SorterItemInfo("material.id"));
        IMaterialSNInventory iMaterialSNInventory = MaterialSNInventoryFactory.getLocalInstance(ctx);
        MaterialSNInventoryCollection snColl = iMaterialSNInventory.getMaterialSNInventoryCollection(ev);
        if (snColl == null || snColl.size() == 0) {
            return;
        }
        HashMap<String, ArrayList> snMap = new HashMap<String, ArrayList>();
        MaterialSNInventoryInfo snInfo = null;
        ArrayList materialSNInventoryInfoList = null;
        for (int j = 0; j < snColl.size(); ++j) {
            snInfo = snColl.get(j);
            MaterialId = snInfo.getMaterial().getId().toString();
            materialSNInventoryInfoList = (ArrayList)snMap.get(MaterialId);
            if (materialSNInventoryInfoList == null) {
                materialSNInventoryInfoList = new ArrayList();
            }
            materialSNInventoryInfoList.add(snInfo);
            snMap.put(MaterialId, materialSNInventoryInfoList);
        }
        for (int i = 0; i < SNInfos.size(); ++i) {
            snInfo = SNInfos.get(i);
            MaterialId = snInfo.getMaterial().getId().toString();
            materialSNInventoryInfoList = (ArrayList)snMap.get(MaterialId);
            if (materialSNInventoryInfoList == null) continue;
            for (MaterialSNInventoryInfo srcSnInfo : materialSNInventoryInfoList) {
                if (!srcSnInfo.getSerialNumber().equals(snInfo.getSerialNumber())) continue;
                throw new SerialNumberException(SerialNumberException.SN_EXIST, new String[]{srcSnInfo.getSerialNumber()});
            }
        }
    }

    @Override
    protected void _saveAddEntriesSerialNumberBatch(Context ctx, IObjectCollection snInfos) throws BOSException, EASBizException {
        if (snInfos == null || snInfos.size() == 0) {
            return;
        }
        StringBuffer inErrorMessage = new StringBuffer();
        StringBuffer outErrorMessage = new StringBuffer();
        MaterialSNInventoryCollection collection = (MaterialSNInventoryCollection)snInfos;
        for (int i = 0; i < collection.size(); ++i) {
            MaterialSNInventoryInfo materialSNInventoryInfo = collection.get(i);
            String materialID = materialSNInventoryInfo.getMaterial().getId().toString();
            String serialNumber = materialSNInventoryInfo.getSerialNumber();
            EntityViewInfo cview = new EntityViewInfo();
            FilterInfo cfilter = new FilterInfo();
            cfilter.getFilterItems().add(new FilterItemInfo("serialNumber", (Object)serialNumber, CompareType.EQUALS));
            cfilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
            cview.setFilter(cfilter);
            MaterialSNInventoryCollection sniColl = this.getMaterialSNInventoryCollection(ctx, cview);
            if (sniColl == null || sniColl.size() == 0) continue;
            MaterialSNInventoryInfo sniInfo = sniColl.get(0);
            materialSNInventoryInfo.setId(sniInfo.getId());
            if (sniInfo.getSnStatus() == SerialNumberStatusEnum.WAITIN) {
                materialSNInventoryInfo.setSnStatus(SerialNumberStatusEnum.INWAREHOUSE);
                continue;
            }
            if (sniInfo.getSnStatus() == SerialNumberStatusEnum.INWAREHOUSE || sniInfo.getSnStatus() == SerialNumberStatusEnum.OUTTHENIN) {
                if (sniInfo.getInventory() == null) continue;
                inErrorMessage.append(serialNumber + ",");
                continue;
            }
            if (sniInfo.getSnStatus() != SerialNumberStatusEnum.SALE) continue;
            outErrorMessage.append(serialNumber + ",");
        }
        MaterialInfo material = null;
        if (inErrorMessage.length() > 0 || outErrorMessage.length() > 0) {
            String message;
            String materialID = collection.get(0).getMaterial().getId().toString();
            material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
            if (inErrorMessage.length() > 0) {
                message = inErrorMessage.toString().substring(0, inErrorMessage.length() - 1);
                throw new SerialNumberException(SerialNumberException.HASINWAREHOUE, new String[]{material.getNumber(), message});
            }
            if (outErrorMessage.length() > 0) {
                message = outErrorMessage.toString().substring(0, outErrorMessage.length() - 1);
                throw new SerialNumberException(SerialNumberException.HASOUTWARHOUSE, new String[]{material.getNumber(), message});
            }
        }
        CoreBaseCollection coll = new CoreBaseCollection();
        coll.addObjectCollection((IObjectCollection)collection);
        this.saveBatchData(ctx, coll);
    }

    @Override
    protected Map _deleteMaterialSNInventory(Context ctx, List materialSNInventoryList) throws BOSException, EASBizException {
        Object[][] conditions = new String[materialSNInventoryList.size()][2];
        for (int i = 0; i < materialSNInventoryList.size(); ++i) {
            Map map = (Map)materialSNInventoryList.get(i);
            conditions[i][0] = (String)map.get("materialID");
            conditions[i][1] = (String)map.get("serialNumber");
        }
        String deleteSQL = "delete from t_iv_materialsninventory where fmaterialid = ? and fserialnumber = ? and fsnstatus = 4";
        KsqlUtil.executeBatch((Context)ctx, (String)deleteSQL, (Object[][])conditions);
        return null;
    }
}

