/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.ICellFormatFunction;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.util.SCMRptUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.app.AbstractMaterialSNInventoryFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.cellformat.BillBaseStatusCellFormat;
import com.kingdee.eas.scm.im.inv.cellformat.SerialNumberStatusCellFormat;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialSNInventoryFacadeControllerBean
extends AbstractMaterialSNInventoryFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MaterialSNInventoryFacadeControllerBean");
    private static final String resFile = "com.kingdee.eas.scm.im.inv.MaterialSNResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        boolean ckBxOnlyShowSN = params.getBoolean("ckBxOnlyShowSN");
        this.dropTempTable(params.getString("tempTable"), ctx);
        String selectSNSQL = this.buildSelectSNSQL(ctx, params);
        CreateTempTableResult result1 = SCMRptUtils.executeCreateAsSelectInto((Context)ctx, (String)selectSNSQL, null);
        String tempTable1 = result1.getTempTable();
        String tempTable = null;
        if (ckBxOnlyShowSN) {
            tempTable = tempTable1;
        } else {
            String selectSNRecordSQL = this.buildSelectSNRecordSQL(ctx, params);
            CreateTempTableResult result2 = SCMRptUtils.executeCreateAsSelectInto((Context)ctx, (String)selectSNRecordSQL, null);
            String tempTable2 = result2.getTempTable();
            String finalSQL = this.getFinalSQL(ctx, tempTable1, tempTable2, params);
            CreateTempTableResult result3 = SCMRptUtils.executeCreateAsSelectInto((Context)ctx, (String)finalSQL, null);
            tempTable = result3.getTempTable();
            this.dropTempTable(tempTable1, ctx);
            this.dropTempTable(tempTable2, ctx);
        }
        RptTableHeader header = this.getReportHeader(ctx, params);
        RptParams result = new RptParams();
        result.setObject("header", (Object)header);
        result.setObject("queryHeader", (Object)this.buildQueryHead(ctx, params));
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rsCount = this.executeQuery(countSql.toString(), null, ctx);
        rsCount.next();
        int count = rsCount.getInt(0);
        result.setInt("totalCount", count);
        result.setString("tempTable", tempTable);
        return result;
    }

    private String getFinalSQL(Context ctx, String tempTable1, String tempTable2, RptParams params) {
        String tempTable = "finalTempTable";
        StringBuffer buffer = new StringBuffer();
        buffer.append(" select t1.*, t2.FBillType_lz, t2.FStorageOrgUnit_lz, t2.FBillNumber_lz, t2.FBizDate_lz, ");
        buffer.append(" t2.FTransactionType_lz, t2.FBillStatus_lz, t2.FBillEntrySeq_lz, t2.FMaterialNumber_lz, ");
        buffer.append(" t2.FWarehouse_lz, t2.FLocation_lz, t2.fbilltypeid_lz, t2.fbillid_lz, t2.fremark, t2.faudittime as FAuditTime_lz into ").append(tempTable).append(" from ");
        buffer.append(tempTable1).append(" t1 left outer join ").append(tempTable2);
        buffer.append(" t2 on t1.fserialnumber = t2.fserialnumber and t1.fmaterialid = t2.fmaterialid ");
        buffer.append(" where 1 = 1 ");
        if (params.getObject("dateFrom") != null) {
            Date dateFrom = (Date)params.getObject("dateFrom");
            buffer.append(" and t2.FBizDate_lz >= to_date('" + IMRptUtils.getFilterBeginDate(dateFrom) + "') ");
        }
        if (params.getObject("dateTo") != null) {
            Date dateTo = (Date)params.getObject("dateTo");
            buffer.append(" and t2.FBizDate_lz <= to_date('" + IMRptUtils.getFilterBeginDate(dateTo) + "') ");
        }
        return buffer.toString();
    }

    private String buildSelectSNSQL(Context ctx, RptParams params) {
        String tempTable = "matSNTempTable";
        StringBuffer buff = new StringBuffer();
        buff.append(" select mat.fnumber as FMaterialNumber, mat.fname_l2 as FMaterialName, mat.fmodel as FModel, ");
        buff.append(" sn.fserialnumber as FSerialNumber, unit.fname_l2 as FSnUnit, sn.fsnstatus as FSnStatus, ");
        buff.append(" sorg.fname_l2 as FStorageOrgUnit, warehouse.fname_l2 as FWarehouse, location.fname_l2 as FLocation, ");
        buff.append(" storestate.fname_l2 as FStoreStatus, asstattt.fname_l2 as FAssistProperty, inv.flot as FLot, ");
        buff.append(" project.fnumber as FProject, track.fnumber as FTrackNumber, storetype.fname_l2 as FStoreType, ");
        buff.append(" supplier.fname_l2 as FSupplier, customer.fname_l2 as FCustomer, sn.fmaterialid as fmaterialid ");
        buff.append(" into ").append(tempTable);
        buff.append(" from T_IV_MaterialSNInventory sn ");
        buff.append(" left outer join t_im_inventory inv on sn.finventoryid = inv.fid ");
        buff.append(" left outer join t_bd_material mat on sn.fmaterialid = mat.fid ");
        buff.append(" left outer join t_org_baseunit sorg on inv.fstorageorgunitid = sorg.fid ");
        buff.append(" left outer join t_db_warehouse warehouse on inv.fwarehouseid = warehouse.fid ");
        buff.append(" left outer join t_db_location location on inv.flocationid = location.fid ");
        buff.append(" left outer join t_im_storestate storestate on inv.fstorestatusid = storestate.fid ");
        buff.append(" left outer join t_bd_asstattrvalue asstattt on inv.fassistpropertyid = asstattt.fid ");
        buff.append(" left outer join t_bd_measureunit unit on mat.fsequnitid = unit.fid ");
        buff.append(" left outer join t_mm_project project on inv.fprojectid = project.fid ");
        buff.append(" left outer join t_mm_tracknumber track on inv.ftracknumberid = track.fid ");
        buff.append(" left outer join t_im_storetype storetype on inv.fstoretypeid = storetype.fid ");
        buff.append(" left outer join t_bd_supplier supplier on inv.fsupplierid = supplier.fid ");
        buff.append(" left outer join t_bd_customer customer on inv.fcustomerid = customer.fid ");
        if (StringUtils.isEmpty((String)params.getString("inventoryID"))) {
            SerialNumberStatusEnum snStatus;
            buff.append(" where 1 = 1 ");
            if (params.getObject("material") != null) {
                MaterialInfo material = (MaterialInfo)params.getObject("material");
                buff.append(" and sn.fmaterialid = '").append(material.getId().toString()).append("' ");
            }
            if (params.getObject("snFrom") != null) {
                MaterialSNInventoryInfo snFrom = (MaterialSNInventoryInfo)params.getObject("snFrom");
                buff.append(" and sn.FSerialNumber >= '").append(snFrom.getSerialNumber()).append("' ");
            }
            if (params.getObject("snTo") != null) {
                MaterialSNInventoryInfo snTo = (MaterialSNInventoryInfo)params.getObject("snTo");
                buff.append(" and sn.FSerialNumber <= '").append(snTo.getSerialNumber()).append("' ");
            }
            if (params.getObject("snStatus") != null && (snStatus = (SerialNumberStatusEnum)((Object)params.getObject("snStatus"))).getValue() != -1) {
                buff.append(" and sn.fsnstatus = ").append(snStatus.getValue()).append(" ");
            }
        } else {
            buff.append(" where sn.finventoryid = '").append(params.getString("inventoryID")).append("' ");
        }
        logger.info((Object)("\u5e8f\u5217\u53f7\u67e5\u8be2SQL\uff1a" + buff.toString()));
        return buff.toString();
    }

    private String buildSelectSNRecordSQL(Context ctx, RptParams params) {
        String tempTable = "matSNRecordTempTable";
        StringBuffer buff = new StringBuffer();
        buff.append(" select bt.fname_l2 as FBillType_lz, bunit.fname_l2 as FStorageOrgUnit_lz, sn.FBillNumber as FBillNumber_lz, ");
        buff.append(" sn.fbillbizdate as FBizDate_lz, trans.fname_l2 as FTransactionType_lz, sn.fbillbasestatus as FBillStatus_lz, ");
        buff.append(" sn.fbillentryseq as FBillEntrySeq_lz, mat.fnumber as FMaterialNumber_lz, wh.fname_l2 as FWarehouse_lz, ");
        buff.append(" lc.fname_l2 as FLocation_lz, sne.fserialnumber as fserialnumber, sn.fmaterialid as fmaterialid, ");
        buff.append(" sn.fbillid as fbillid_lz, sn.fbilltypeid as fbilltypeid_lz, sne.fremark as fremark, sn.faudittime as faudittime ");
        buff.append(" into ").append(tempTable);
        buff.append(" from T_IV_MaterialSerialNumber sn ");
        buff.append(" left outer join T_IV_MaterialSerialNumberEntry sne on sne.fparentid = sn.fid ");
        buff.append(" left outer join t_scm_billtype bt on sn.fbilltypeid = bt.fid ");
        buff.append(" left outer join t_org_baseunit bunit on sn.fstorageorgunitid = bunit.fid ");
        buff.append(" left outer join t_scm_transactiontype trans on sn.ftransactiontypeid = trans.fid ");
        buff.append(" left outer join t_bd_material mat on sn.fmaterialid = mat.fid ");
        buff.append(" left outer join t_db_warehouse wh on sn.fwarehouseid = wh.fid ");
        buff.append(" left outer join t_db_location lc on sn.flocationid = lc.fid ");
        buff.append(" where 1 = 1 ");
        if (params.getObject("material") != null) {
            MaterialInfo material = (MaterialInfo)params.getObject("material");
            buff.append(" and sn.fmaterialid = '").append(material.getId().toString()).append("' ");
        }
        if (params.getObject("snFrom") != null) {
            MaterialSNInventoryInfo snFrom = (MaterialSNInventoryInfo)params.getObject("snFrom");
            buff.append(" and sne.FSerialNumber >= '").append(snFrom.getSerialNumber()).append("' ");
        }
        if (params.getObject("snTo") != null) {
            MaterialSNInventoryInfo snTo = (MaterialSNInventoryInfo)params.getObject("snTo");
            buff.append(" and sne.FSerialNumber <= '").append(snTo.getSerialNumber()).append("' ");
        }
        if (params.getObject("dateFrom") != null) {
            Date dateFrom = (Date)params.getObject("dateFrom");
            buff.append(" and sn.fbillbizdate >= to_date('" + IMRptUtils.getFilterBeginDate(dateFrom) + "') ");
        }
        if (params.getObject("dateTo") != null) {
            Date dateTo = (Date)params.getObject("dateTo");
            buff.append(" and sn.fbillbizdate <= to_date('" + IMRptUtils.getFilterBeginDate(dateTo) + "') ");
        }
        logger.info((Object)("\u6d41\u8f6c\u4fe1\u606f\u67e5\u8be2SQL\uff1a" + buff.toString()));
        return buff.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer buff = new StringBuffer();
        buff.append(" select FSerialNumber, FMaterialNumber, FMaterialName, FModel, FSnUnit, FSnStatus, ");
        buff.append(" FStorageOrgUnit, FWarehouse, FLocation, FStoreType, FStoreStatus, ");
        buff.append(" FAssistProperty, case FLot when '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' then '' else FLot end, FProject, ");
        buff.append(" FTrackNumber, FSupplier, FCustomer, FMaterialID ");
        boolean ckBxOnlyShowSN = params.getBoolean("ckBxOnlyShowSN");
        if (!ckBxOnlyShowSN) {
            buff.append(",FBillType_lz, FStorageOrgUnit_lz, FBillNumber_lz, FBizDate_lz, FAuditTime_lz, FTransactionType_lz, FBillStatus_lz, ");
            buff.append("FBillEntrySeq_lz, FMaterialNumber_lz, FWarehouse_lz, FLocation_lz, ");
            buff.append("FBillID_lz, FBillTypeID_lz, fremark ");
        }
        buff.append(" from ").append(tempTable);
        buff.append(" order by fmaterialid desc, fserialnumber asc ");
        if (!ckBxOnlyShowSN) {
            buff.append(" ,fbizdate_lz desc, FAuditTime_lz desc , fbillnumber_lz desc, fbillentryseq_lz asc ");
        }
        RptRowSet rs = this.executeQuery(buff.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private RptTableHeader getReportHeader(Context ctx, RptParams params) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        boolean ckBxOnlyShowSN = params.getBoolean("ckBxOnlyShowSN");
        int snNum = 0;
        int lzNum = 0;
        col = new RptTableColumn("FSerialNumber");
        col.setWidth(100);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FMaterialNumber");
        col.setWidth(100);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FMaterialName");
        col.setWidth(100);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FModel");
        col.setWidth(100);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FSnUnit");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FSnStatus");
        col.setWidth(100);
        col.setFormatFunction("SerialNumberStatusCellFormat", (ICellFormatFunction)new SerialNumberStatusCellFormat());
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FStorageOrgUnit");
        col.setWidth(100);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FWarehouse");
        col.setWidth(100);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FLocation");
        col.setWidth(100);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FStoreType");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FStoreStatus");
        col.setWidth(100);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FAssistProperty");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FLot");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FProject");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FTrackNumber");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FSupplier");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FCustomer");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        ++snNum;
        col = new RptTableColumn("FMaterialID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        ++snNum;
        if (!ckBxOnlyShowSN) {
            col = new RptTableColumn("FBillType_lz");
            col.setWidth(100);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FStorageOrgUnit_lz");
            col.setWidth(100);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FBillNumber_lz");
            col.setWidth(100);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FBizDate_lz");
            col.setWidth(100);
            col.setFormatPattern("yyyy-MM-dd");
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FAuditTime_lz");
            col.setWidth(100);
            col.setHided(true);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FTransactionType_lz");
            col.setWidth(100);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FBillStatus_lz");
            col.setWidth(100);
            col.setFormatFunction("BillBaseStatusCellFormat", (ICellFormatFunction)new BillBaseStatusCellFormat());
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FBillEntrySeq_lz");
            col.setWidth(100);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FMaterialNumber_lz");
            col.setWidth(100);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FWarehouse_lz");
            col.setWidth(100);
            col.setHided(true);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FLocation_lz");
            col.setWidth(100);
            col.setHided(true);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FBillID_lz");
            col.setWidth(-1);
            col.setHided(true);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FBillTypeID_lz");
            col.setWidth(-1);
            col.setHided(true);
            header.addColumn(col);
            ++lzNum;
            col = new RptTableColumn("FRemark");
            col.setWidth(100);
            col.setHided(true);
            header.addColumn(col);
            ++lzNum;
        }
        Object[][] labels = this.getReportHeadLables(ctx, snNum, lzNum, params);
        header.setLabels(labels, true);
        return header;
    }

    private Object[][] getReportHeadLables(Context ctx, int snNum, int lzNum, RptParams params) {
        int i;
        Object[][] labels = new Object[2][snNum + lzNum];
        int m = 0;
        for (i = 0; i < snNum; ++i) {
            labels[0][m] = SCMUtils.getResource((String)resFile, (String)"SN_INFO", (Context)ctx);
            ++m;
        }
        for (i = 0; i < lzNum; ++i) {
            labels[0][m] = SCMUtils.getResource((String)resFile, (String)"SN_LZ_INFO", (Context)ctx);
            ++m;
        }
        m = 0;
        labels[1][m] = SCMUtils.getResource((String)resFile, (String)"SN", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"MATERIAL_NUMBER", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"MATERIAL_NAME", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"MODAL", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"SN_UNIT", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"SN_STATUS", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"STORAGEORGUNIT", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"WAREHOUSE", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"LOCATION", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"STORETYPE", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"STORESTATUS", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"ASSISTPROPERTY", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"LOT", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"PROJECT", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"TRACKNUMBER", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"SUPPLIER", (Context)ctx);
        labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"CUSTOMER", (Context)ctx);
        labels[1][++m] = "FMaterialID";
        ++m;
        if (lzNum > 0) {
            labels[1][m] = SCMUtils.getResource((String)resFile, (String)"BILLTYPE", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"STORAGEORGUNIT", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"BILLNUMBER", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"BIZDATE", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"AUDITTIME", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"TRANSACTIONTYPE", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"BILLSTATUS", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"BILLENTRYSEQ", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"MATERIAL_NUMBER", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"WAREHOUSE", (Context)ctx);
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"LOCATION", (Context)ctx);
            labels[1][++m] = "FBillID_lz";
            labels[1][++m] = "FBillTypeID_lz";
            labels[1][++m] = SCMUtils.getResource((String)resFile, (String)"REMARK", (Context)ctx);
            ++m;
        }
        return labels;
    }

    private Map buildQueryHead(Context ctx, RptParams params) {
        HashMap<String, Boolean> queryHeader = new HashMap<String, Boolean>();
        queryHeader.put("FSerialNumber", true);
        queryHeader.put("FMaterialNumber", true);
        queryHeader.put("FMaterialName", true);
        queryHeader.put("FModel", false);
        queryHeader.put("FSnUnit", false);
        queryHeader.put("FSnStatus", true);
        queryHeader.put("FStorageOrgUnit", true);
        queryHeader.put("FWarehouse", true);
        queryHeader.put("FLocation", true);
        queryHeader.put("FStoreType", false);
        queryHeader.put("FStoreStatus", true);
        queryHeader.put("FAssistProperty", false);
        queryHeader.put("FLot", false);
        queryHeader.put("FProject", false);
        queryHeader.put("FTrackNumber", false);
        queryHeader.put("FSupplier", false);
        queryHeader.put("FCustomer", false);
        queryHeader.put("FMaterialID", false);
        boolean ckBxOnlyShowSN = params.getBoolean("ckBxOnlyShowSN");
        if (!ckBxOnlyShowSN) {
            queryHeader.put("FBillType_lz", true);
            queryHeader.put("FStorageOrgUnit_lz", true);
            queryHeader.put("FBillNumber_lz", true);
            queryHeader.put("FBizDate_lz", true);
            queryHeader.put("FAuditTime_lz", true);
            queryHeader.put("FTransactionType_lz", true);
            queryHeader.put("FBillStatus_lz", true);
            queryHeader.put("FBillEntrySeq_lz", true);
            queryHeader.put("FMaterialNumber_lz", true);
            queryHeader.put("FWarehouse_lz", false);
            queryHeader.put("FLocation_lz", false);
            queryHeader.put("FBillID_lz", false);
            queryHeader.put("FBillTypeID_lz", false);
            queryHeader.put("FRemark", true);
        }
        return queryHeader;
    }
}

