/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFactory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.EASResource;
import java.util.Hashtable;

public class MaterialSNInventoryImport
extends AbstractDataTransmission {
    private static final String SN_RESOURCE = "com.kingdee.eas.scm.im.inv.MaterialSNResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialSNInventoryFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        MaterialSNInventoryInfo materialSNInventoryInfo = null;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            try {
                Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
                materialSNInventoryInfo = this.transmitHead(lineData, ctx);
                continue;
            }
            catch (TaskExternalException e) {
                tex.addEntryErrorReason(i, e.getMessage());
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return materialSNInventoryInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MaterialSNInventoryInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        try {
            MaterialSNInventoryInfo materialSNInventoryInfo = new MaterialSNInventoryInfo();
            Object materialNumber = ((DataToken)lineData.get((Object)"FMaterial_number")).data;
            Object serialNumber = ((DataToken)lineData.get((Object)"FSerialNumber")).data;
            MaterialInfo material = null;
            if (materialNumber == null) throw new BOSException(EASResource.getString((String)SN_RESOURCE, (String)"MATERIAL_NOTNULL"));
            String materialNum = materialNumber.toString();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("number", (Object)materialNum, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItem);
            viewInfo.setFilter(filterInfo);
            MaterialCollection collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
            if (collection == null || collection.size() <= 0) throw new BOSException(EASResource.getString((String)SN_RESOURCE, (String)"MATERIAL_NOTEXIST"));
            material = collection.get(0);
            if (material.getSeqUnit() == null && (material = this.getMaterialInfo(ctx, material)).getSeqUnit() == null) {
                throw new BOSException(EASResource.getString((String)SN_RESOURCE, (String)"MATERAIL_NOT_SNMANGEMENT"));
            }
            materialSNInventoryInfo.setMaterial(material);
            if (serialNumber == null) {
                throw new BOSException(EASResource.getString((String)SN_RESOURCE, (String)"SN_NOTNULL"));
            }
            materialSNInventoryInfo.setSerialNumber(serialNumber.toString());
            materialSNInventoryInfo.setSnStatus(SerialNumberStatusEnum.WAITIN);
            return materialSNInventoryInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof MaterialSNInventoryInfo)) {
            return;
        }
        try {
            MaterialSNInventoryInfo snInfo = (MaterialSNInventoryInfo)coreBaseInfo;
            MaterialSNInventoryCollection snInfos = new MaterialSNInventoryCollection();
            snInfos.add(snInfo);
            MaterialSNInventoryFactory.getLocalInstance(ctx).saveMaterialSNInventoryBatch(snInfos);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private MaterialInfo getMaterialInfo(Context ctx, MaterialInfo info) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("model"));
        sic.add(new SelectorItemInfo("seqUnit.id"));
        sic.add(new SelectorItemInfo("seqUnit.number"));
        sic.add(new SelectorItemInfo("seqUnit.name"));
        MaterialInfo mi = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
        return mi;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }

    public int getSubmitType() {
        return 1;
    }
}

