/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.SCMBillBaseCollection;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.app.DataLoaderHelper;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.ISaleIssueEntry;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillInfo;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberException;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMaterialSerialNumberControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MaterialSerialNumberControllerBean
extends AbstractMaterialSerialNumberControllerBean {
    private static final long serialVersionUID = 1L;
    private static final String resFile = "com.kingdee.eas.scm.im.inv.MaterialSNResource";

    @Override
    protected void _saveSerialNumber(Context ctx, IObjectCollection serialNumberInfos) throws BOSException, EASBizException {
        if (serialNumberInfos == null || serialNumberInfos.size() == 0) {
            return;
        }
        for (int i = 0; i < serialNumberInfos.size(); ++i) {
            this._saveSerialNumber(ctx, serialNumberInfos.getObject(i));
        }
    }

    @Override
    protected IObjectPK _saveSerialNumber(Context ctx, IObjectValue serialNumberInfo) throws BOSException, EASBizException {
        MaterialSerialNumberInfo snInfo = (MaterialSerialNumberInfo)serialNumberInfo;
        if (snInfo == null || snInfo.getMaterial() == null) {
            return null;
        }
        BillTypeInfo billTypeInfo = snInfo.getBillType();
        if (billTypeInfo == null || !"50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeInfo.getId().toString())) {
            snInfo = this.serialNumberSavecheck(ctx, snInfo);
        }
        if (snInfo.getId() == null) {
            return super.addnew(ctx, (CoreBaseInfo)snInfo);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)snInfo.getBillID()));
        filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)snInfo.getBillEntryID()));
        this.delete(ctx, filter);
        if (this._exists(ctx, (IObjectPK)new ObjectUuidPK(snInfo.getId()))) {
            snInfo.setId(null);
        }
        return super.addnew(ctx, (CoreBaseInfo)snInfo);
    }

    private MaterialSerialNumberInfo serialNumberSavecheck(Context ctx, MaterialSerialNumberInfo serialNumberInfo) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)serialNumberInfo.getBillID()));
        filter.getFilterItems().add(new FilterItemInfo("Material", (Object)serialNumberInfo.getMaterial().getId()));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        ev.getSelector().add(new SelectorItemInfo("material.number"));
        ev.getSelector().add(new SelectorItemInfo("material.name"));
        ev.getSelector().add(new SelectorItemInfo("entry.*"));
        ev.getSorter().add(new SorterItemInfo("entry.seq"));
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        MaterialSerialNumberCollection snColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(ev);
        MaterialSerialNumberEntryCollection srcSnEnteryInfos = serialNumberInfo.getEntry();
        if (snColl != null && snColl.size() > 0) {
            MaterialSerialNumberInfo snInfo = null;
            MaterialSerialNumberInfo snInfoCopy = null;
            for (int j = 0; j < snColl.size(); ++j) {
                snInfo = snColl.get(j);
                boolean isCurrrtEntry = false;
                if (snInfo.getBillEntryID().equals(serialNumberInfo.getBillEntryID())) {
                    isCurrrtEntry = true;
                    if (serialNumberInfo.getId() == null) {
                        snInfoCopy = (MaterialSerialNumberInfo)snInfo.clone();
                    }
                }
                if (isCurrrtEntry && serialNumberInfo.getId() != null) break;
                MaterialSerialNumberEntryCollection snEnteryInfos = snInfo.getEntry();
                MaterialSerialNumberEntryInfo snEntryInfo = null;
                if (srcSnEnteryInfos == null || srcSnEnteryInfos.size() <= 0) continue;
                MaterialSerialNumberEntryInfo srcSnEntryInfo = null;
                for (int i = 0; i < srcSnEnteryInfos.size(); ++i) {
                    if (snEnteryInfos != null && snEnteryInfos.size() > 0) {
                        for (int k = 0; k < snEnteryInfos.size(); ++k) {
                            snEntryInfo = snEnteryInfos.get(k);
                            srcSnEntryInfo = srcSnEnteryInfos.get(i);
                            if (!snEntryInfo.getSerialNumber().equals(srcSnEntryInfo.getSerialNumber())) continue;
                            throw new SerialNumberException(SerialNumberException.NUMBER_REPEAT, new String[]{String.valueOf(serialNumberInfo.getBillEntrySeq()), serialNumberInfo.getMaterial().getNumber(), srcSnEntryInfo.getSerialNumber()});
                        }
                        if (!isCurrrtEntry || serialNumberInfo.getId() != null) continue;
                        int seq = snEnteryInfos.size() + i + 1;
                        if (null != srcSnEntryInfo) {
                            srcSnEntryInfo.setSeq(seq);
                        }
                        if (null == snInfoCopy) continue;
                        snInfoCopy.getEntry().add(srcSnEntryInfo);
                        snInfoCopy.setSnQty(new BigDecimal(seq));
                        continue;
                    }
                    if (null == snInfoCopy) continue;
                    snInfoCopy.getEntry().clear();
                    snInfoCopy.getEntry().addCollection(srcSnEnteryInfos);
                }
            }
            if (snInfoCopy != null) {
                serialNumberInfo = snInfoCopy;
            }
        }
        return serialNumberInfo;
    }

    private void checkSNDup(Context ctx, MaterialSerialNumberInfo snInfo, boolean isAudit, boolean checkIsInWHWhileIssue, ArrayList exceptionList) throws BOSException, EASBizException {
        if (snInfo == null) {
            return;
        }
        String strStorageID = snInfo.getStorageOrgUnit().getId().toString();
        String strMaterialID = snInfo.getMaterial().getId().toString();
        int status = snInfo.getSnStatus().getValue();
        String soureBillID = null;
        StringBuffer checkSNDup = new StringBuffer();
        StringBuffer checkExist = new StringBuffer();
        try {
            StringBuffer tempsb;
            Object[] msgs;
            IRowSet rsDup;
            if (snInfo.isIsReversed()) {
                Vector<String> vSN = new Vector<String>(0);
                StringBuffer sbSn = new StringBuffer();
                sbSn.append("select B.FSerialNumber from T_IV_MaterialSerialNumber A LEFT OUTER JOIN T_IV_MaterialSerialNumberEntry B ON B.FParentID = A.FID  where A.FBillID = '");
                sbSn.append(snInfo.getBillID());
                sbSn.append("' and A.FBillEntryID = '");
                sbSn.append(snInfo.getBillEntryID() + "';");
                IRowSet rsSNs = DbUtil.executeQuery((Context)ctx, (String)sbSn.toString());
                String SNs = null;
                while (rsSNs.next()) {
                    SNs = rsSNs.getString("FSerialNumber");
                    if (SNs == null) continue;
                    vSN.add(SNs);
                }
                soureBillID = snInfo.getSoureBillID().trim();
                checkExist = new StringBuffer();
                checkExist.append("select B.FSerialNumber from T_IV_MaterialSerialNumber A LEFT OUTER JOIN T_IV_MaterialSerialNumberEntry B ON B.FParentID = A.FID  where A.FBillID = '");
                checkExist.append(soureBillID);
                checkExist.append("' and A.FBillEntryID = '");
                checkExist.append(snInfo.getSoureBillEntryID() + "';");
                IRowSet rsIsReversed = DbUtil.executeQuery((Context)ctx, (String)checkExist.toString());
                String soureSNs = null;
                while (rsIsReversed.next()) {
                    soureSNs = rsIsReversed.getString("FSerialNumber");
                    if (soureSNs == null || !vSN.contains(soureSNs)) continue;
                    vSN.removeElement(soureSNs);
                }
                if (vSN.size() > 0) {
                    Object[] msgs2 = new String[2];
                    if (snInfo.getMaterial().getName() == null || snInfo.getMaterial().getName().length() == 0) {
                        MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(strMaterialID));
                        snInfo.setMaterial(material);
                    }
                    msgs2[0] = snInfo.getMaterial().getName();
                    StringBuffer sb = new StringBuffer();
                    for (int j = 0; j < vSN.size(); ++j) {
                        if (j != 0) {
                            sb.append(",");
                        }
                        sb.append(vSN.get(j).toString());
                        if (j == 5) break;
                    }
                    msgs2[1] = sb.toString();
                    exceptionList.add(new SerialNumberException(SerialNumberException.NOTEXISTSN, msgs2));
                    return;
                }
            }
            StringBuffer strFrom = new StringBuffer();
            strFrom.append("From T_IV_MaterialSNInventory A INNER JOIN ");
            strFrom.append("(select D.FSerialNumber from T_IV_MaterialSerialNumber C LEFT OUTER JOIN T_IV_MaterialSerialNumberEntry D ON D.FParentID = C.FID  where C.FBillID = '");
            strFrom.append(snInfo.getBillID());
            strFrom.append("' and C.FBillEntryID = '");
            strFrom.append(snInfo.getBillEntryID() + "')");
            strFrom.append(" B ON A.FSerialNumber = B.FSerialNumber ");
            StringBuffer strWhere = new StringBuffer();
            strWhere.append("Where A.FMaterialID = '");
            strWhere.append(strMaterialID);
            strWhere.append("' ");
            if (isAudit && (status == 1 || status == 3) || !isAudit && (status == 3 || status == 2)) {
                if (checkIsInWHWhileIssue) {
                    checkSNDup = new StringBuffer();
                    checkSNDup.append("select top 5 A.FSerialNumber ");
                    checkSNDup.append(strFrom);
                    checkSNDup.append(strWhere);
                    checkSNDup.append("And A.FSnStatus = ");
                    checkSNDup.append(1);
                    checkSNDup.append(" ");
                    rsDup = DbUtil.executeQuery((Context)ctx, (String)checkSNDup.toString());
                    msgs = new String[3];
                    int i = 0;
                    tempsb = new StringBuffer();
                    while (rsDup.next()) {
                        String sn = rsDup.getString("FSerialNumber");
                        if (i != 0) {
                            tempsb.append(",");
                        }
                        tempsb.append(sn);
                        ++i;
                    }
                    if (i > 0) {
                        if (snInfo.getMaterial().getName() == null || snInfo.getMaterial().getName().length() == 0) {
                            MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(strMaterialID));
                            snInfo.setMaterial(material);
                        }
                        msgs[0] = String.valueOf(snInfo.getBillEntrySeq());
                        msgs[1] = snInfo.getMaterial().getName();
                        msgs[2] = tempsb.toString();
                        exceptionList.add(new SerialNumberException(SerialNumberException.HASOUTWARHOUSE, msgs));
                        return;
                    }
                    checkExist = new StringBuffer();
                    checkExist.append("select C.bsn as Fsn From (select A.FSerialNumber asn,B.FSerialNumber bsn ");
                    checkExist.append("From ");
                    checkExist.append("(select D.FSerialNumber from T_IV_MaterialSerialNumber C LEFT OUTER JOIN T_IV_MaterialSerialNumberEntry D ON D.FParentID = C.FID  where C.FBillID = '");
                    checkExist.append(snInfo.getBillID());
                    checkExist.append("' and C.FBillEntryID = '");
                    checkExist.append(snInfo.getBillEntryID() + "')");
                    checkExist.append(" B LEFT JOIN T_IV_MaterialSNInventory A ON A.FSerialNumber = B.FSerialNumber ");
                    checkExist.append(" And A.FMaterialID = '");
                    checkExist.append(strMaterialID);
                    checkExist.append("' ");
                    checkExist.append("And (A.FSnStatus = ");
                    checkExist.append(2);
                    checkExist.append(" or A.FSnStatus = ");
                    checkExist.append(3);
                    checkExist.append(")) C where C.asn is null ");
                    IRowSet rsExist = DbUtil.executeQuery((Context)ctx, (String)checkExist.toString());
                    msgs = new String[3];
                    i = 0;
                    tempsb = new StringBuffer();
                    while (rsExist.next()) {
                        String sn = rsExist.getString("Fsn");
                        if (i != 0) {
                            tempsb.append(",");
                        }
                        tempsb.append(sn);
                        ++i;
                    }
                    if (i > 0) {
                        if (snInfo.getMaterial().getName() == null || snInfo.getMaterial().getName().length() == 0) {
                            MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(strMaterialID));
                            snInfo.setMaterial(material);
                        }
                        msgs[0] = String.valueOf(snInfo.getBillEntrySeq());
                        msgs[1] = snInfo.getMaterial().getName();
                        msgs[2] = tempsb.toString();
                        exceptionList.add(new SerialNumberException(SerialNumberException.NOTINWARHOUSE, msgs));
                        return;
                    }
                }
            } else if (isAudit && status == 2 || !isAudit && status == 1) {
                checkSNDup = new StringBuffer();
                checkSNDup.append("select A.FSerialNumber ");
                checkSNDup.append(strFrom);
                checkSNDup.append(strWhere);
                checkSNDup.append("And (A.FSnStatus = ");
                checkSNDup.append(2);
                checkSNDup.append(" OR A.FSnStatus = ");
                checkSNDup.append(3).append(")");
                rsDup = DbUtil.executeQuery((Context)ctx, (String)checkSNDup.toString());
                msgs = new String[3];
                int i = 0;
                tempsb = new StringBuffer();
                while (rsDup.next()) {
                    String sn = rsDup.getString("FSerialNumber");
                    if (i != 0) {
                        tempsb.append(",");
                    }
                    tempsb.append(sn);
                    ++i;
                }
                if (i > 0) {
                    if (snInfo.getMaterial().getName() == null || snInfo.getMaterial().getName().length() == 0) {
                        MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(strMaterialID));
                        snInfo.setMaterial(material);
                    }
                    msgs[0] = String.valueOf(snInfo.getBillEntrySeq());
                    msgs[1] = snInfo.getMaterial().getName();
                    msgs[2] = tempsb.toString();
                    exceptionList.add(new SerialNumberException(SerialNumberException.HASINWAREHOUE, msgs));
                    return;
                }
                boolean ischeck = true;
                Boolean isSaleBack = (Boolean)snInfo.get("isSaleBack");
                if (isSaleBack.booleanValue() && !SCMServerUtils.isOnlyOutNSCanBack((Context)ctx, (String)strStorageID)) {
                    ischeck = false;
                }
                if (isSaleBack.booleanValue() && ischeck && !snInfo.isIsReversed()) {
                    Vector<String> vSN = new Vector<String>(0);
                    StringBuffer sbSn = new StringBuffer();
                    sbSn.append("select B.FSerialNumber from T_IV_MaterialSerialNumber A LEFT OUTER JOIN T_IV_MaterialSerialNumberEntry B ON B.FParentID = A.FID  where A.FBillID = '");
                    sbSn.append(snInfo.getBillID());
                    sbSn.append("' and A.FBillEntryID = '");
                    sbSn.append(snInfo.getBillEntryID() + "';");
                    IRowSet rsSNs = DbUtil.executeQuery((Context)ctx, (String)sbSn.toString());
                    String SNs = null;
                    while (rsSNs.next()) {
                        SNs = rsSNs.getString("FSerialNumber");
                        if (SNs == null) continue;
                        vSN.add(SNs);
                    }
                    checkExist = new StringBuffer();
                    checkExist.append("select C.bsn as Fsn From (select A.FSerialNumber asn,B.FSerialNumber bsn ");
                    checkExist.append("From ");
                    checkExist.append("(select D.FSerialNumber from T_IV_MaterialSerialNumber C LEFT OUTER JOIN T_IV_MaterialSerialNumberEntry D ON D.FParentID = C.FID  where C.FBillID = '");
                    checkExist.append(snInfo.getBillID());
                    checkExist.append("' and C.FBillEntryID = '");
                    checkExist.append(snInfo.getBillEntryID() + "')");
                    checkExist.append(" B LEFT JOIN T_IV_MaterialSNInventory A ON A.FSerialNumber = B.FSerialNumber ");
                    checkExist.append("Where A.FMaterialID = '");
                    checkExist.append(strMaterialID);
                    checkExist.append("' ");
                    checkExist.append("And A.FSnStatus = ");
                    checkExist.append(1);
                    checkExist.append(") C  ");
                    IRowSet rsExist = DbUtil.executeQuery((Context)ctx, (String)checkExist.toString());
                    String soureSNs = null;
                    while (rsExist.next()) {
                        soureSNs = rsExist.getString("Fsn");
                        if (soureSNs == null || !vSN.contains(soureSNs)) continue;
                        vSN.removeElement(soureSNs);
                    }
                    if (vSN.size() > 0) {
                        msgs = new String[2];
                        if (snInfo.getMaterial().getName() == null || snInfo.getMaterial().getName().length() == 0) {
                            MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(strMaterialID));
                            snInfo.setMaterial(material);
                        }
                        msgs[0] = snInfo.getMaterial().getName();
                        StringBuffer sb = new StringBuffer();
                        for (int j = 0; j < vSN.size(); ++j) {
                            if (j != 0) {
                                sb.append(",");
                            }
                            sb.append(vSN.get(j).toString());
                            if (j == 5) break;
                        }
                        msgs[1] = sb.toString();
                        exceptionList.add(new SerialNumberException(SerialNumberException.NOTOUTWARHOUSE, msgs));
                        return;
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected void dropTable(Context ctx, String tableName) throws BOSException {
        KsqlUtil.releaseTempTable((Context)ctx, (String)tableName);
    }

    @Override
    protected void _checkSerialNumber(Context ctx, boolean isAudit, IObjectValue[] serialNumberInfos) throws BOSException, EASBizException {
        if (serialNumberInfos != null && serialNumberInfos.length > 0) {
            MaterialSerialNumberInfo snInfo = null;
            boolean paramBoolean = this.getParamINM002(ctx, serialNumberInfos);
            ArrayList exceptionList = new ArrayList();
            for (int i = 0; i < serialNumberInfos.length; ++i) {
                snInfo = (MaterialSerialNumberInfo)serialNumberInfos[i];
                this.checkSNDup(ctx, snInfo, isAudit, paramBoolean, exceptionList);
            }
            if (exceptionList.size() > 0) {
                StringBuffer msg = new StringBuffer();
                SerialNumberException exception = null;
                for (int i = 0; i < exceptionList.size(); ++i) {
                    exception = (SerialNumberException)((Object)exceptionList.get(i));
                    msg.append(exception.getMessage()).append("\n");
                }
                throw new BOSException(msg.toString());
            }
        }
    }

    private boolean getParamINM002(Context ctx, IObjectValue[] serialNumberInfos) throws BOSException {
        ObjectUuidPK orgPK = null;
        for (int i = 0; i < serialNumberInfos.length; ++i) {
            if (serialNumberInfos[i] == null || ((MaterialSerialNumberInfo)serialNumberInfos[i]).getStorageOrgUnit() == null) continue;
            orgPK = new ObjectUuidPK(((MaterialSerialNumberInfo)serialNumberInfos[i]).getStorageOrgUnit().getId());
            break;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        boolean paramBoolean = true;
        if (orgPK == null) {
            paramBoolean = false;
        } else {
            String param = (String)paramMap.get(orgPK.toString() + "INM002");
            if (StringUtils.isEmpty((String)param)) {
                try {
                    String getParamSQL = "select fvalue_l2 from t_bas_paramitem t1 inner join t_bas_param t2 on t1.fkeyid = t2.fid where t2.fnumber = 'INM002' and t1.forgunitid = '" + orgPK + "'";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getParamSQL);
                    if (rs.next()) {
                        param = rs.getString("fvalue_l2");
                        paramMap.put(orgPK.toString() + "INM002", param);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (!StringUtils.isEmpty((String)param)) {
                paramBoolean = "true".equalsIgnoreCase(param);
            }
        }
        return paramBoolean;
    }

    @Override
    protected void _updateSerialInventory(Context ctx, IObjectValue scmBill) throws BOSException, EASBizException {
        if (scmBill == null) {
            return;
        }
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)scmBill;
        if (aSCMBillBaseInfo instanceof StockTransferBillInfo || aSCMBillBaseInfo instanceof TransferOrderBillInfo) {
            return;
        }
        IObjectCollection iObjectCollection = (IObjectCollection)aSCMBillBaseInfo.get("entry");
        if (iObjectCollection == null) {
            iObjectCollection = (IObjectCollection)aSCMBillBaseInfo.get("entries");
        }
        int entrySize = iObjectCollection.size();
        SCMBillEntryBaseInfo ibb = null;
        HashSet<String> invUpdateTypeIdSet = new HashSet<String>();
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            ibb = (SCMBillEntryBaseInfo)iObjectCollection.getObject(i);
            if (ibb.get("invUpdateType") == null) continue;
            InvUpdateTypeInfo invUpdateType = (InvUpdateTypeInfo)ibb.get("invUpdateType");
            invUpdateTypeIdSet.add(invUpdateType.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectorForInvUpdateType());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", invUpdateTypeIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        InvUpdateTypeCollection updateTypeCollection = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeCollection(view);
        block3: for (int i = 0; i < iObjectCollection.size(); ++i) {
            ibb = (SCMBillEntryBaseInfo)iObjectCollection.getObject(i);
            if (ibb.get("invUpdateType") == null) continue;
            InvUpdateTypeInfo invUpdateType = (InvUpdateTypeInfo)ibb.get("invUpdateType");
            for (int j = 0; j < updateTypeCollection.size(); ++j) {
                if (!invUpdateType.getId().toString().equals(updateTypeCollection.get(j).getId().toString())) continue;
                ibb.put("invUpdateType", (Object)updateTypeCollection.get(j));
                continue block3;
            }
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        for (int i = 0; i < entrySize; ++i) {
            InvUpdateTypeInfo invUpdateType;
            ibb = (SCMBillEntryBaseInfo)iObjectCollection.getObject(i);
            if (ibb.get("invUpdateType") != null && (invUpdateType = (InvUpdateTypeInfo)ibb.get("invUpdateType")) != null && invUpdateType.isIsNotUpdateInv() || ibb.getMaterial() == null) continue;
            materialIdSet.add(ibb.getMaterial().getId().toString());
        }
        if (materialIdSet.size() == 0) {
            return;
        }
        this.updateSerialNumInventory(ctx, aSCMBillBaseInfo);
        Iterator iterator = materialIdSet.iterator();
        StringBuilder sqlMaterialWhere = new StringBuilder();
        while (iterator.hasNext()) {
            sqlMaterialWhere.append("'").append((String)iterator.next()).append("',");
        }
        sqlMaterialWhere.setLength(sqlMaterialWhere.length() - 1);
        StringBuilder whereSQL = new StringBuilder();
        whereSQL.append(" where fmaterialid in (").append(sqlMaterialWhere.toString()).append(") ").append(" and fserialnumber in ").append(" (select e.FSerialNumber ").append(" from T_IV_MaterialSerialNumber c ").append(" inner join T_IV_MaterialSerialNumberEntry e on c.fid = e.fparentid ").append(" where c.fbillid = '").append(aSCMBillBaseInfo.getId().toString()).append("' ").append(" and c.fmaterialid in (").append(sqlMaterialWhere.toString()).append(") ").append(")");
        try {
            StringBuilder querySQL = new StringBuilder();
            querySQL.append(" select fid, fserialnumber from T_IV_MaterialSNInventory ").append(whereSQL.toString());
            IRowSet tempRs = KsqlUtil.executeQuery((Context)ctx, (String)querySQL.toString(), null);
            StringBuilder checkSNSQL = new StringBuilder();
            checkSNSQL.append(" select t2.fid, t2.fserialnumber from T_IV_MaterialSerialNumber t1 left outer join T_IV_MaterialSerialNumberEntry t2 on t1.fid = t2.fparentid ");
            checkSNSQL.append(" where t1.fbillid = '").append(aSCMBillBaseInfo.getId().toString()).append("' and t1.fmaterialid in (").append(sqlMaterialWhere.toString()).append(") ");
            IRowSet checkRs = KsqlUtil.executeQuery((Context)ctx, (String)checkSNSQL.toString(), null);
            HashSet<String> isExistSet = new HashSet<String>();
            HashSet<String> isNotExistSet = new HashSet<String>();
            while (tempRs.next()) {
                String serialNumber = tempRs.getString("fserialnumber");
                isExistSet.add(serialNumber);
            }
            StringBuilder notExistSN = new StringBuilder();
            while (checkRs.next()) {
                String serialNumber = checkRs.getString("fserialnumber");
                if (isExistSet.contains(serialNumber)) continue;
                isNotExistSet.add(serialNumber);
                notExistSN.append("'").append(serialNumber).append("',");
            }
            if (notExistSN.length() > 0) {
                notExistSN.setLength(notExistSN.length() - 1);
            }
            if (isExistSet.size() > 0) {
                StringBuilder isExistQuerySQL = new StringBuilder();
                isExistQuerySQL.append(" select fid from T_IV_MaterialSNInventory ").append(whereSQL.toString());
                StringBuilder sb = new StringBuilder();
                sb.append(" update T_IV_MaterialSNInventory a set (fstorageorgunitid, fsnstatus) = ");
                sb.append(" (select b.fstorageorgunitid, b.fsnstatus from T_IV_MaterialSerialNumber b ");
                sb.append(" inner join T_IV_MaterialSerialNumberEntry cc on b.fid = cc.fparentid where a.fmaterialid = b.fmaterialid and a.fserialnumber = cc.fserialnumber and b.fbillid = '");
                sb.append(aSCMBillBaseInfo.getId().toString()).append("') ");
                sb.append(" where a.fid in (").append(isExistQuerySQL.toString()).append(")");
                DbUtil.execute((Context)ctx, (String)sb.toString());
            }
            if (isNotExistSet.size() > 0) {
                StringBuilder sbInsert = new StringBuilder();
                sbInsert.append(" INSERT INTO T_IV_MaterialSNInventory (FID, FStorageOrgUnitID, FMaterialID, FSerialNumber, FSnStatus) ");
                sbInsert.append(" SELECT NEWBOSID('CB56FF7C'), ");
                sbInsert.append(" a.fstorageorgunitid, a.fmaterialid, b.fserialnumber, a.FSnStatus ");
                sbInsert.append(" from T_IV_MaterialSerialNumber a ");
                sbInsert.append(" inner join T_IV_MaterialSerialNumberEntry b on a.fid = b.fparentid ");
                sbInsert.append(" where a.fmaterialid in (").append(sqlMaterialWhere.toString()).append(") ");
                sbInsert.append(" and a.fbillid = '" + aSCMBillBaseInfo.getId().toString() + "' ");
                sbInsert.append(" and b.fserialnumber in (").append(notExistSN.toString()).append(") ");
                DbUtil.execute((Context)ctx, (String)sbInsert.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateSerialNumInventory(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        MaterialSerialNumberInfo[] serialNumberInfos = null;
        if (billInfo instanceof InvBillBaseInfo) {
            InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)billInfo;
            if (!InvCommonUtils.isNeedUpdateSerialNumber(invBillBaseInfo)) {
                return;
            }
            if (invBillBaseInfo.getTransactionType() == null || invBillBaseInfo.getTransactionType().getId() == null) {
                return;
            }
            serialNumberInfos = this.buildMaterialSerialNumberInfos(ctx, invBillBaseInfo);
        } else if (billInfo instanceof StockTransferBillInfo) {
            StockTransferBillInfo stockTransferBillInfo = (StockTransferBillInfo)billInfo;
            serialNumberInfos = this.buildMaterialSerialNumberInfos(ctx, stockTransferBillInfo);
        } else if (billInfo instanceof TransferOrderBillInfo) {
            TransferOrderBillInfo transferOrderBillInfo = (TransferOrderBillInfo)billInfo;
            serialNumberInfos = this.buildMaterialSerialNumberInfos(ctx, transferOrderBillInfo);
        }
        if (serialNumberInfos == null || serialNumberInfos.length == 0) {
            return;
        }
        this.checkBillDuplicateSerialNumber(ctx, billInfo);
        this.lockSerialNumberRecords(ctx, billInfo);
        this.checkSerialNumber(ctx, true, (IObjectValue[])serialNumberInfos);
    }

    private void checkBillDuplicateSerialNumber(Context ctx, SCMBillBaseInfo invbillBase) throws InvBizException, BOSException {
        Set<String> serialNumSet;
        if (null == invbillBase || invbillBase.getId() == null) {
            return;
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)invbillBase.getId().toString()));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("material.number"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entry.serialNumber"));
        selector.add(new SelectorItemInfo("entry.id"));
        entityView.setSelector(selector);
        IMaterialSerialNumber imsn = MaterialSerialNumberFactory.getLocalInstance(ctx);
        MaterialSerialNumberCollection msnCol = imsn.getMaterialSerialNumberCollection(entityView);
        HashMap allSerialNumMap = new HashMap();
        HashMap<MaterialInfo, HashSet<String>> duplicateSerialMap = new HashMap<MaterialInfo, HashSet<String>>();
        int len = msnCol.size();
        for (int i = 0; i < len; ++i) {
            MaterialSerialNumberInfo msn = msnCol.get(i);
            MaterialSerialNumberEntryCollection entryCol = msn.getEntry();
            if (null == entryCol || entryCol.size() <= 0 || msn.getMaterial() == null) continue;
            int size = entryCol.size();
            for (int k = 0; k < size; ++k) {
                MaterialSerialNumberEntryInfo entryInfo = entryCol.get(k);
                String key = msn.getMaterial().getId().toString() + entryInfo.getSerialNumber();
                if (allSerialNumMap.containsKey(key)) {
                    serialNumSet = (Set)duplicateSerialMap.get(msn.getMaterial());
                    if (null == serialNumSet) {
                        serialNumSet = new HashSet<String>();
                        duplicateSerialMap.put(msn.getMaterial(), (HashSet<String>)serialNumSet);
                    }
                    serialNumSet.add(entryInfo.getSerialNumber());
                    continue;
                }
                allSerialNumMap.put(key, null);
            }
        }
        if (duplicateSerialMap.size() > 0) {
            Set keySet = duplicateSerialMap.keySet();
            Iterator iterator = keySet.iterator();
            StringBuffer errorMsg = new StringBuffer();
            while (iterator.hasNext()) {
                MaterialInfo materialInfo = (MaterialInfo)iterator.next();
                errorMsg.append(" (").append(materialInfo.getNumber()).append(": ");
                serialNumSet = (HashSet<String>)duplicateSerialMap.get(materialInfo);
                for (String serialNumber : serialNumSet) {
                    errorMsg.append(serialNumber).append(",");
                }
                errorMsg.setLength(errorMsg.length() - 1);
                errorMsg.append(" ),");
            }
            errorMsg.setLength(errorMsg.length() - 1);
            throw new InvBizException(InvBizException.BILL_HAS_DUPLICATE_SERIALNUMBER, new String[]{errorMsg.toString()});
        }
    }

    private MaterialSerialNumberInfo[] buildMaterialSerialNumberInfos(Context ctx, InvBillBaseInfo billInfo) throws EASBizException, BOSException {
        MaterialInventoryInfo mii;
        TransactionTypeInfo tti = billInfo.getTransactionType();
        if (tti.getRiType() == null) {
            tti = this.getTransactionTypeInfo(ctx, billInfo);
            billInfo.setTransactionType(tti);
        }
        boolean isSaleBack = false;
        if ((billInfo instanceof SaleIssueBillInfo || billInfo instanceof MaterialReqBillInfo) && tti.getRiType().getBizDirection() == BizDirectionEnum.back) {
            isSaleBack = true;
        }
        SerialNumberStatusEnum snstatus = null;
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        int entrySize = iObjectCollection.size();
        InvBillBaseEntryInfo ibb = null;
        MaterialSerialNumberInfo snInfo = null;
        MaterialInfo material = null;
        String[] materialIds = new String[entrySize];
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> mIds = new HashSet<String>();
        String[] seqUnitIDS = new String[entrySize];
        String[] storageOrgIds = new String[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            ibb = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            materialIds[i] = ibb.getMaterial().getId().toString();
            storageOrgIds[i] = ibb.getStorageOrgUnit().getId().toString();
        }
        SelectorItemCollection sicCol = new SelectorItemCollection();
        sicCol.add("isSequenceNo");
        sicCol.add("material.id");
        sicCol.add("orgUnit.id");
        Map mapMaterialInventorys = DataLoaderHelper.loadMaterialInventorys((Context)ctx, (String[])storageOrgIds, (String[])materialIds, (SelectorItemCollection)sicCol);
        SelectorItemCollection siCol = new SelectorItemCollection();
        siCol.add(new SelectorItemInfo("id"));
        siCol.add(new SelectorItemInfo("number"));
        siCol.add(new SelectorItemInfo("name"));
        siCol.add(new SelectorItemInfo("seqUnit.id"));
        siCol.add(new SelectorItemInfo("seqUnit.number"));
        siCol.add(new SelectorItemInfo("seqUnit.name"));
        Map mapMaterialSeq = DataLoaderHelper.loadMaterial((Context)ctx, (String[])materialIds, (SelectorItemCollection)siCol);
        boolean isNeedSele = false;
        MeasureUnitInfo seqUnit = null;
        HashMap map = new HashMap();
        for (int i = 0; i < entrySize; ++i) {
            ibb = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            if (ibb == null || ibb.getMaterial() == null || ibb.getStorageOrgUnit() == null) continue;
            mii = (MaterialInventoryInfo)mapMaterialInventorys.get(ibb.getMaterial().getId().toString() + ibb.getStorageOrgUnit().getId().toString());
            if (mii == null) {
                mIds.add(ibb.getMaterial().getId().toString());
                orgIds.add(ibb.getStorageOrgUnit().getId().toString());
            }
            if (mapMaterialSeq != null && materialIds[i] != null && mapMaterialSeq.get(materialIds[i]) != null && mapMaterialSeq.get(materialIds[i]) instanceof MaterialInfo) {
                seqUnit = ((MaterialInfo)mapMaterialSeq.get(materialIds[i])).getSeqUnit();
            }
            if (seqUnit != null) {
                isNeedSele = true;
                seqUnitIDS[i] = seqUnit.getId().toString();
                continue;
            }
            seqUnitIDS[i] = "";
        }
        if (isNeedSele) {
            map = SCMServerUtils.getMultiMeasureUnits((Context)ctx, (String[])materialIds, (String[])seqUnitIDS);
        }
        if (mIds.size() > 0 && orgIds.size() > 0) {
            mapMaterialInventorys = this.getMaterialInventoryMap(ctx, mapMaterialInventorys, mIds, orgIds);
        }
        MaterialSerialNumberInfo[] serialNumberInfos = new MaterialSerialNumberInfo[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            BigDecimal baseQty;
            ibb = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            if (ibb == null || ibb.getMaterial() == null || ibb.getStorageOrgUnit() == null || (mii = (MaterialInventoryInfo)mapMaterialInventorys.get(ibb.getMaterial().getId().toString() + ibb.getStorageOrgUnit().getId().toString())) == null || !mii.isIsSequenceNo() || ibb == null) continue;
            boolean isNegative = billInfo.isIsReversed() ^ InvAppUtils.isNegative(billInfo.getTransactionType());
            snstatus = InvCommonUtils.getSnStatusByTranType(tti, ibb.getInvUpdateType(), isNegative);
            if (snstatus == SerialNumberStatusEnum.NULL) continue;
            snInfo = new MaterialSerialNumberInfo();
            snInfo.setBillID(billInfo.getId().toString());
            snInfo.setBillEntryID(ibb.getId().toString());
            snInfo.setIsReversed(billInfo.isIsReversed());
            snInfo.setSoureBillID(ibb.getSourceBillId());
            snInfo.setSoureBillEntryID(ibb.getSourceBillEntryId());
            snInfo.setBillEntrySeq(ibb.getSeq());
            snInfo.setSnStatus(snstatus);
            snInfo.setBillType(this.getBillTypeByBosType(billInfo));
            snInfo.setBillNumber(billInfo.getNumber());
            snInfo.setTransactionType(billInfo.getTransactionType());
            snInfo.setBillBizDate(billInfo.getBizDate());
            snInfo.setBillBaseStatus(billInfo.getBaseStatus());
            snInfo.setWarehouse(ibb.getWarehouse());
            snInfo.setLocation(ibb.getLocation());
            snInfo.setStorageOrgUnit(ibb.getStorageOrgUnit());
            snInfo.setMaterial(ibb.getMaterial());
            material = ibb.getMaterial();
            MeasureUnitInfo sNUnitInfo = material.getSeqUnit();
            if (sNUnitInfo == null && (sNUnitInfo = ((MaterialInfo)mapMaterialSeq.get(material.getId().toString())).getSeqUnit()) == null) {
                return null;
            }
            BigDecimal sNqty = baseQty = ibb.getBaseQty();
            if (!ibb.getBaseUnit().getId().toString().equals(sNUnitInfo.getId().toString())) {
                BigDecimal coefficient = SCMConstant.BIGDECIMAL_ONE;
                MultiMeasureUnitInfo mulUnit = null;
                mulUnit = (MultiMeasureUnitInfo)map.get(material.getId().toString() + sNUnitInfo.getId().toString());
                if (mulUnit != null) {
                    coefficient = mulUnit.getBaseConvsRate();
                    int precision = mulUnit.getQtyPrecision();
                    if (coefficient != null) {
                        sNqty = baseQty.divide(coefficient, precision, 4);
                    }
                }
            }
            snInfo.setSnUnit(sNUnitInfo);
            snInfo.setSnQty(sNqty);
            snInfo.put("isSaleBack", isSaleBack);
            serialNumberInfos[i] = snInfo;
        }
        return serialNumberInfos;
    }

    private MaterialSerialNumberInfo[] buildMaterialSerialNumberInfos(Context ctx, StockTransferBillInfo billInfo) throws EASBizException, BOSException {
        MaterialInventoryInfo mii;
        SerialNumberStatusEnum snstatus = null;
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        int entrySize = iObjectCollection.size();
        StockTransferBillEntryInfo ibb = null;
        MaterialSerialNumberInfo snInfo = null;
        MaterialInfo material = null;
        String[] materialIds = new String[entrySize];
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> mIds = new HashSet<String>();
        String[] seqUnitIDS = new String[entrySize];
        String[] storageOrgIds = new String[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            ibb = (StockTransferBillEntryInfo)iObjectCollection.getObject(i);
            materialIds[i] = ibb.getMaterial().getId().toString();
            storageOrgIds[i] = ibb.getIssueStorageOrgUnit().getId().toString();
        }
        SelectorItemCollection sicCol = new SelectorItemCollection();
        sicCol.add("isSequenceNo");
        sicCol.add("material.id");
        sicCol.add("orgUnit.id");
        Map mapMaterialInventorys = DataLoaderHelper.loadMaterialInventorys((Context)ctx, (String[])storageOrgIds, (String[])materialIds, (SelectorItemCollection)sicCol);
        SelectorItemCollection siCol = new SelectorItemCollection();
        siCol.add(new SelectorItemInfo("id"));
        siCol.add(new SelectorItemInfo("number"));
        siCol.add(new SelectorItemInfo("name"));
        siCol.add(new SelectorItemInfo("seqUnit.id"));
        siCol.add(new SelectorItemInfo("seqUnit.number"));
        siCol.add(new SelectorItemInfo("seqUnit.name"));
        Map mapMaterialSeq = DataLoaderHelper.loadMaterial((Context)ctx, (String[])materialIds, (SelectorItemCollection)siCol);
        boolean isNeedSele = false;
        MeasureUnitInfo seqUnit = null;
        HashMap map = new HashMap();
        for (int i = 0; i < entrySize; ++i) {
            ibb = (StockTransferBillEntryInfo)iObjectCollection.getObject(i);
            if (ibb == null || ibb.getMaterial() == null || ibb.getIssueStorageOrgUnit() == null) continue;
            mii = (MaterialInventoryInfo)mapMaterialInventorys.get(ibb.getMaterial().getId().toString() + ibb.getIssueStorageOrgUnit().getId().toString());
            if (mii == null) {
                mIds.add(ibb.getMaterial().getId().toString());
                orgIds.add(ibb.getIssueStorageOrgUnit().getId().toString());
            }
            if (mapMaterialSeq != null && materialIds[i] != null && mapMaterialSeq.get(materialIds[i]) != null && mapMaterialSeq.get(materialIds[i]) instanceof MaterialInfo) {
                seqUnit = ((MaterialInfo)mapMaterialSeq.get(materialIds[i])).getSeqUnit();
            }
            if (seqUnit != null) {
                isNeedSele = true;
                seqUnitIDS[i] = seqUnit.getId().toString();
                continue;
            }
            seqUnitIDS[i] = "";
        }
        if (isNeedSele) {
            map = SCMServerUtils.getMultiMeasureUnits((Context)ctx, (String[])materialIds, (String[])seqUnitIDS);
        }
        if (mIds.size() > 0 && orgIds.size() > 0) {
            mapMaterialInventorys = this.getMaterialInventoryMap(ctx, mapMaterialInventorys, mIds, orgIds);
        }
        MaterialSerialNumberInfo[] serialNumberInfos = new MaterialSerialNumberInfo[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            BigDecimal baseQty;
            ibb = (StockTransferBillEntryInfo)iObjectCollection.getObject(i);
            if (ibb == null || ibb.getMaterial() == null || ibb.getIssueStorageOrgUnit() == null || (mii = (MaterialInventoryInfo)mapMaterialInventorys.get(ibb.getMaterial().getId().toString() + ibb.getIssueStorageOrgUnit().getId().toString())) == null || !mii.isIsSequenceNo() || ibb == null) continue;
            snstatus = SerialNumberStatusEnum.OUTTHENIN;
            snInfo = new MaterialSerialNumberInfo();
            snInfo.setBillID(billInfo.getId().toString());
            snInfo.setBillEntryID(ibb.getId().toString());
            snInfo.setIsReversed(false);
            snInfo.setSoureBillID(ibb.getSourceBillId());
            snInfo.setSoureBillEntryID(ibb.getSourceBillEntryId());
            snInfo.setBillEntrySeq(ibb.getSeq());
            snInfo.setSnStatus(snstatus);
            snInfo.setBillType(this.getBillTypeByBosType(billInfo));
            snInfo.setBillNumber(billInfo.getNumber());
            snInfo.setTransactionType(null);
            snInfo.setBillBizDate(billInfo.getBizDate());
            snInfo.setBillBaseStatus(billInfo.getBaseStatus());
            snInfo.setWarehouse(ibb.getIssueWarehouse());
            snInfo.setLocation(ibb.getIssueLocation());
            snInfo.setStorageOrgUnit(ibb.getIssueStorageOrgUnit());
            snInfo.setMaterial(ibb.getMaterial());
            material = ibb.getMaterial();
            MeasureUnitInfo sNUnitInfo = material.getSeqUnit();
            if (sNUnitInfo == null && (sNUnitInfo = ((MaterialInfo)mapMaterialSeq.get(material.getId().toString())).getSeqUnit()) == null) {
                return null;
            }
            BigDecimal sNqty = baseQty = ibb.getBaseQty();
            if (!ibb.getBaseUnit().getId().toString().equals(sNUnitInfo.getId().toString())) {
                BigDecimal coefficient = SCMConstant.BIGDECIMAL_ONE;
                MultiMeasureUnitInfo mulUnit = null;
                mulUnit = (MultiMeasureUnitInfo)map.get(material.getId().toString() + sNUnitInfo.getId().toString());
                if (mulUnit != null) {
                    coefficient = mulUnit.getBaseConvsRate();
                    int precision = mulUnit.getQtyPrecision();
                    if (coefficient != null) {
                        sNqty = baseQty.divide(coefficient, precision, 4);
                    }
                }
            }
            snInfo.setSnUnit(sNUnitInfo);
            snInfo.setSnQty(sNqty);
            serialNumberInfos[i] = snInfo;
        }
        return serialNumberInfos;
    }

    private MaterialSerialNumberInfo[] buildMaterialSerialNumberInfos(Context ctx, TransferOrderBillInfo billInfo) throws EASBizException, BOSException {
        MaterialInventoryInfo mii;
        SerialNumberStatusEnum snstatus = null;
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        int entrySize = iObjectCollection.size();
        TransferOrderBillEntryInfo ibb = null;
        MaterialSerialNumberInfo snInfo = null;
        MaterialInfo material = null;
        String[] materialIds = new String[entrySize];
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> mIds = new HashSet<String>();
        String[] seqUnitIDS = new String[entrySize];
        String[] storageOrgIds = new String[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            ibb = (TransferOrderBillEntryInfo)iObjectCollection.getObject(i);
            materialIds[i] = ibb.getMaterial().getId().toString();
            storageOrgIds[i] = ibb.getIssueStorageOrgUnit().getId().toString();
        }
        SelectorItemCollection sicCol = new SelectorItemCollection();
        sicCol.add("isSequenceNo");
        sicCol.add("material.id");
        sicCol.add("orgUnit.id");
        Map mapMaterialInventorys = DataLoaderHelper.loadMaterialInventorys((Context)ctx, (String[])storageOrgIds, (String[])materialIds, (SelectorItemCollection)sicCol);
        SelectorItemCollection siCol = new SelectorItemCollection();
        siCol.add(new SelectorItemInfo("id"));
        siCol.add(new SelectorItemInfo("number"));
        siCol.add(new SelectorItemInfo("name"));
        siCol.add(new SelectorItemInfo("seqUnit.id"));
        siCol.add(new SelectorItemInfo("seqUnit.number"));
        siCol.add(new SelectorItemInfo("seqUnit.name"));
        Map mapMaterialSeq = DataLoaderHelper.loadMaterial((Context)ctx, (String[])materialIds, (SelectorItemCollection)siCol);
        boolean isNeedSele = false;
        MeasureUnitInfo seqUnit = null;
        HashMap map = new HashMap();
        for (int i = 0; i < entrySize; ++i) {
            ibb = (TransferOrderBillEntryInfo)iObjectCollection.getObject(i);
            if (ibb == null || ibb.getMaterial() == null || ibb.getIssueStorageOrgUnit() == null) continue;
            mii = (MaterialInventoryInfo)mapMaterialInventorys.get(ibb.getMaterial().getId().toString() + ibb.getIssueStorageOrgUnit().getId().toString());
            if (mii == null) {
                mIds.add(ibb.getMaterial().getId().toString());
                orgIds.add(ibb.getIssueStorageOrgUnit().getId().toString());
            }
            if (mapMaterialSeq != null && materialIds[i] != null && mapMaterialSeq.get(materialIds[i]) != null && mapMaterialSeq.get(materialIds[i]) instanceof MaterialInfo) {
                seqUnit = ((MaterialInfo)mapMaterialSeq.get(materialIds[i])).getSeqUnit();
            }
            if (seqUnit != null) {
                isNeedSele = true;
                seqUnitIDS[i] = seqUnit.getId().toString();
                continue;
            }
            seqUnitIDS[i] = "";
        }
        if (isNeedSele) {
            map = SCMServerUtils.getMultiMeasureUnits((Context)ctx, (String[])materialIds, (String[])seqUnitIDS);
        }
        if (mIds.size() > 0 && orgIds.size() > 0) {
            mapMaterialInventorys = this.getMaterialInventoryMap(ctx, mapMaterialInventorys, mIds, orgIds);
        }
        MaterialSerialNumberInfo[] serialNumberInfos = new MaterialSerialNumberInfo[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            BigDecimal baseQty;
            ibb = (TransferOrderBillEntryInfo)iObjectCollection.getObject(i);
            if (ibb == null || ibb.getMaterial() == null || ibb.getIssueStorageOrgUnit() == null || (mii = (MaterialInventoryInfo)mapMaterialInventorys.get(ibb.getMaterial().getId().toString() + ibb.getIssueStorageOrgUnit().getId().toString())) == null || !mii.isIsSequenceNo() || ibb == null) continue;
            snstatus = SerialNumberStatusEnum.OUTTHENIN;
            snInfo = new MaterialSerialNumberInfo();
            snInfo.setBillID(billInfo.getId().toString());
            snInfo.setBillEntryID(ibb.getId().toString());
            snInfo.setIsReversed(false);
            snInfo.setSoureBillID(ibb.getSourceBillId());
            snInfo.setSoureBillEntryID(ibb.getSourceBillEntryId());
            snInfo.setBillEntrySeq(ibb.getSeq());
            snInfo.setSnStatus(snstatus);
            snInfo.setBillType(this.getBillTypeByBosType(billInfo));
            snInfo.setBillNumber(billInfo.getNumber());
            snInfo.setTransactionType(null);
            snInfo.setBillBizDate(billInfo.getBizDate());
            snInfo.setBillBaseStatus(billInfo.getBaseStatus());
            snInfo.setWarehouse(ibb.getIssueWarehouse());
            snInfo.setLocation(ibb.getIssueLocation());
            snInfo.setStorageOrgUnit(ibb.getIssueStorageOrgUnit());
            snInfo.setMaterial(ibb.getMaterial());
            material = ibb.getMaterial();
            MeasureUnitInfo sNUnitInfo = material.getSeqUnit();
            if (sNUnitInfo == null && (sNUnitInfo = ((MaterialInfo)mapMaterialSeq.get(material.getId().toString())).getSeqUnit()) == null) {
                return null;
            }
            BigDecimal sNqty = baseQty = ibb.getBaseQty();
            if (!ibb.getBaseUnit().getId().toString().equals(sNUnitInfo.getId().toString())) {
                BigDecimal coefficient = SCMConstant.BIGDECIMAL_ONE;
                MultiMeasureUnitInfo mulUnit = null;
                mulUnit = (MultiMeasureUnitInfo)map.get(material.getId().toString() + sNUnitInfo.getId().toString());
                if (mulUnit != null) {
                    coefficient = mulUnit.getBaseConvsRate();
                    int precision = mulUnit.getQtyPrecision();
                    if (coefficient != null) {
                        sNqty = baseQty.divide(coefficient, precision, 4);
                    }
                }
            }
            snInfo.setSnUnit(sNUnitInfo);
            snInfo.setSnQty(sNqty);
            serialNumberInfos[i] = snInfo;
        }
        return serialNumberInfos;
    }

    private Map getMaterialInventoryMap(Context ctx, Map miMap, Set mIds, Set orgIds) throws BOSException {
        String key = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)mIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sicCol = new SelectorItemCollection();
        sicCol.add("isSequenceNo");
        sicCol.add("material.id");
        sicCol.add("orgUnit.id");
        view.setSelector(sicCol);
        MaterialInventoryCollection matInventoryCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(view);
        MaterialInventoryInfo info = null;
        int size = matInventoryCol.size();
        for (int i = 0; i < size; ++i) {
            info = matInventoryCol.get(i);
            key = info.getMaterial().getId().toString() + info.getOrgUnit().getId().toString();
            if (miMap.containsKey(key)) continue;
            miMap.put(key, info);
        }
        return miMap;
    }

    protected TransactionTypeInfo getTransactionTypeInfo(Context ctx, InvBillBaseInfo invBillInfo) throws EASBizException, BOSException {
        if (null == invBillInfo || invBillInfo.getTransactionType() == null) {
            return null;
        }
        String transactionTypeId = invBillInfo.getTransactionType().getId().toString();
        TransactionTypeInfo result = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeId));
        if (result == null) {
            result = invBillInfo.getTransactionType();
        }
        return result;
    }

    private void lockSerialNumberRecords(Context ctx, SCMBillBaseInfo billInfo) throws BOSException {
        StringBuffer lockSQL = new StringBuffer();
        lockSQL.append(" update t_iv_materialserialnumberentry set fid = fid where fserialnumber in( ");
        lockSQL.append(" select t2.fserialnumber from t_iv_materialserialnumber t1 ");
        lockSQL.append(" left outer join t_iv_materialserialnumberentry t2 on t1.fid = t2.fparentid where t1.fbillid = ?) ");
        DbUtil.execute((Context)ctx, (String)lockSQL.toString(), (Object[])new String[]{billInfo.getId().toString()});
    }

    @Override
    protected String _serialNumberImport(Context ctx, Hashtable data, String sBillSign, String sBillVSNSign, String sSNSign, int materialNumEnum, int iMaterLength, int iLotLength, boolean isUpdate) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        Vector<MaterialSerialNumberInfo> vecSNinfo = new Vector<MaterialSerialNumberInfo>(0);
        String a1 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"billno", (Locale)ctx.getOriginLocale());
        String a2 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"mateial", (Locale)ctx.getOriginLocale());
        String a3 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"lotnum", (Locale)ctx.getOriginLocale());
        String a4 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"nosame", (Locale)ctx.getOriginLocale());
        String a5 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"exist", (Locale)ctx.getOriginLocale());
        String a6 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"notexist", (Locale)ctx.getOriginLocale());
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        Enumeration enums = data.keys();
        while (enums.hasMoreElements()) {
            String billNum = (String)enums.nextElement();
            Hashtable hmEnty = (Hashtable)data.get(billNum);
            Enumeration enumEntry = hmEnty.keys();
            while (enumEntry.hasMoreElements()) {
                String lotNum;
                String materiallot = (String)enumEntry.nextElement();
                Vector vecSN = (Vector)hmEnty.get(materiallot);
                String materialNum = materiallot.substring(0, iMaterLength);
                SaleIssueEntryInfo aSaleIssueEntryInfo = this.getSaleIssueEntryInfo(ctx, billNum, materialNum, lotNum = materiallot.substring(iMaterLength), materialNumEnum);
                if (aSaleIssueEntryInfo == null) {
                    sb.append(a1);
                    sb.append("[");
                    sb.append(billNum);
                    sb.append("]");
                    sb.append(a2);
                    sb.append("[");
                    sb.append(materialNum);
                    sb.append("]");
                    sb.append(a3);
                    sb.append("[");
                    sb.append(lotNum);
                    sb.append("]");
                    sb.append(a6);
                    sb.append("\r\n");
                    continue;
                }
                BigDecimal baseQty = aSaleIssueEntryInfo.getBaseQty();
                MeasureUnitInfo abaseUnitInfo = aSaleIssueEntryInfo.getBaseUnit();
                MeasureUnitInfo sNUnitInfo = aSaleIssueEntryInfo.getMaterial().getSeqUnit();
                if (!abaseUnitInfo.getId().toString().equals(sNUnitInfo.getId().toString())) {
                    baseQty = MaterialSerialNumberControllerBean.getAssUnitQty(sNUnitInfo, aSaleIssueEntryInfo.getMaterial(), baseQty);
                }
                int vsize = vecSN.size();
                if (baseQty.intValue() != vsize) {
                    sb.append(a1);
                    sb.append("[");
                    sb.append(billNum);
                    sb.append("]");
                    sb.append(a2);
                    sb.append("[");
                    sb.append(materialNum);
                    sb.append("]");
                    sb.append(a3);
                    sb.append("[");
                    sb.append(lotNum);
                    sb.append("]");
                    sb.append(a4);
                    sb.append("\r\n");
                    continue;
                }
                String oql = "billEntryID = '" + aSaleIssueEntryInfo.getId().toString() + "'";
                MaterialSerialNumberCollection MaterialSerialNumberColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(oql);
                MaterialSerialNumberInfo bMaterialSerialNumberInfo = null;
                if (MaterialSerialNumberColl != null && MaterialSerialNumberColl.size() > 0) {
                    bMaterialSerialNumberInfo = MaterialSerialNumberColl.get(0);
                }
                if (bMaterialSerialNumberInfo != null && !isUpdate) {
                    sb.append(a1);
                    sb.append("[");
                    sb.append(billNum);
                    sb.append("]");
                    sb.append(a2);
                    sb.append("[");
                    sb.append(materialNum);
                    sb.append("]");
                    sb.append(a3);
                    sb.append("[");
                    sb.append(lotNum);
                    sb.append("]");
                    sb.append(a5);
                    sb.append("\r\n");
                    continue;
                }
                if (bMaterialSerialNumberInfo != null) {
                    iMaterialSerialNumber.delete((IObjectPK)new ObjectUuidPK(bMaterialSerialNumberInfo.getId()));
                }
                MaterialSerialNumberInfo aMaterialSerialNumberInfo = new MaterialSerialNumberInfo();
                aMaterialSerialNumberInfo.setBillID(aSaleIssueEntryInfo.getParent().getId().toString());
                BillTypeInfo aBillTypeInfo = new BillTypeInfo();
                aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
                aMaterialSerialNumberInfo.setBillType(aBillTypeInfo);
                aMaterialSerialNumberInfo.setBillNumber(billNum);
                aMaterialSerialNumberInfo.setSnUnit(sNUnitInfo);
                aMaterialSerialNumberInfo.setStorageOrgUnit(aSaleIssueEntryInfo.getStorageOrgUnit());
                aMaterialSerialNumberInfo.setBillEntryID(aSaleIssueEntryInfo.getId().toString());
                aMaterialSerialNumberInfo.setBillEntrySeq(aSaleIssueEntryInfo.getSeq());
                aMaterialSerialNumberInfo.setMaterial(aSaleIssueEntryInfo.getMaterial());
                BigDecimal bigQty = new BigDecimal(vecSN.size());
                aMaterialSerialNumberInfo.setSnQty(bigQty);
                aMaterialSerialNumberInfo.setIsReversed(false);
                aMaterialSerialNumberInfo.setSnStatus(SerialNumberStatusEnum.SALE);
                for (int i = 0; i < vsize; ++i) {
                    MaterialSerialNumberEntryInfo aMaterialSerialNumberEntry = new MaterialSerialNumberEntryInfo();
                    aMaterialSerialNumberEntry.setSerialNumber((String)vecSN.get(i));
                    aMaterialSerialNumberInfo.getEntry().add(aMaterialSerialNumberEntry);
                }
                vecSNinfo.add(aMaterialSerialNumberInfo);
            }
        }
        if (sb.toString().length() == 0) {
            int size = vecSNinfo.size();
            for (int i = 0; i < size; ++i) {
                MaterialSerialNumberInfo aMaterialSerialNumberInfo = (MaterialSerialNumberInfo)vecSNinfo.get(i);
                iMaterialSerialNumber.addnew((CoreBaseInfo)aMaterialSerialNumberInfo);
            }
        }
        return sb.toString();
    }

    public SaleIssueEntryInfo getSaleIssueEntryInfo(Context ctx, String billNumber, String materialNum, String lot, int materialNumEnum) throws BOSException, EASBizException {
        if (billNumber == null || materialNum == null || lot == null) {
            return null;
        }
        ISaleIssueEntry iSaleIssueEntry = SaleIssueEntryFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.*"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("sourceBillNumber", (Object)billNumber.trim(), CompareType.EQUALS));
        if (materialNumEnum == 1) {
            fic.add(new FilterItemInfo("material.number", (Object)materialNum.trim(), CompareType.EQUALS));
        } else if (materialNumEnum == 2) {
            fic.add(new FilterItemInfo("material.helpCode", (Object)materialNum.trim(), CompareType.EQUALS));
        }
        fic.add(new FilterItemInfo("lot", (Object)lot.trim(), CompareType.EQUALS));
        view.setFilter(filter);
        SaleIssueEntryCollection saleIssueColl = iSaleIssueEntry.getSaleIssueEntryCollection(view);
        SaleIssueEntryInfo aSaleIssueEntryInfo = null;
        if (saleIssueColl != null && saleIssueColl.size() > 0) {
            aSaleIssueEntryInfo = saleIssueColl.get(0);
        }
        return aSaleIssueEntryInfo;
    }

    public static BigDecimal getAssUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty) throws BOSException, EASBizException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal assQty = new BigDecimal("0.00");
        if (baseQty != null) {
            assQty = baseQty;
        } else {
            baseQty = assQty;
        }
        MultiMeasureUnitInfo mulUnit = MaterialSerialNumberControllerBean.getMulUnit(mui, mi);
        if (mulUnit != null) {
            coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null) {
                assQty = baseQty.divide(coefficient, precision, 4);
            }
        }
        return assQty;
    }

    public static MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi) throws BOSException, EASBizException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    @Override
    protected RptRowSet _materialSNRpt(Context ctx, RptParams params) throws BOSException, EASBizException {
        String condition = this.getConditionFromParams(params);
        String locName = this.getLocName(ctx);
        StringBuffer sbSelect = new StringBuffer();
        sbSelect.append("Select AE.FSerialNumber,A.FBillNumber,B.FSourceBillNumber,C.FNumber,C.FHelpCode,C.");
        sbSelect.append(locName);
        sbSelect.append(",B.FLot,D.");
        sbSelect.append(locName);
        sbSelect.append(",E.");
        sbSelect.append(locName);
        sbSelect.append(",M.");
        sbSelect.append(locName);
        sbSelect.append(",N.");
        sbSelect.append(locName);
        sbSelect.append(",F.");
        sbSelect.append(locName);
        sbSelect.append(",G.");
        sbSelect.append(locName);
        sbSelect.append(",I.");
        sbSelect.append(locName);
        sbSelect.append(",B.FQty as qty");
        sbSelect.append(",O.FqtyPrecision as qtyPrecision");
        sbSelect.append(",J.");
        sbSelect.append(locName);
        sbSelect.append(",A.FSnStatus as snStatus");
        sbSelect.append(",A.FIsReversed as isReversed");
        sbSelect.append(",H.");
        sbSelect.append(locName);
        sbSelect.append(",AE.FRemark ");
        StringBuffer sbFrom = new StringBuffer();
        sbFrom.append("From T_IV_MaterialSerialNumber A ");
        sbFrom.append("LEFT OUTER JOIN T_IV_MaterialSerialNumberEntry AE on AE.FParentID = A.FID ");
        sbFrom.append("LEFT OUTER JOIN T_IM_SaleIssueEntry B on B.FID = A.FBillEntryID ");
        sbFrom.append("LEFT OUTER JOIN T_IM_SaleIssueBill BH on BH.FID = A.FBillID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_Material C on C.FID = A.FMaterialID ");
        sbFrom.append("LEFT OUTER JOIN T_ORG_Storage D on D.FID = A.FStorageOrgUnitID ");
        sbFrom.append("LEFT OUTER JOIN T_ORG_Sale E on E.FID = B.FSaleOrgUnitID ");
        sbFrom.append("LEFT OUTER JOIN T_DB_WAREHOUSE F on F.FID = B.FWarehouseID ");
        sbFrom.append("LEFT OUTER JOIN T_DB_LOCATION G on G.FID = B.FLocationID ");
        sbFrom.append("LEFT OUTER JOIN T_ORG_Admin H on H.FID = BH.FAdminOrgUnitID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_MeasureUnit I on I.FID = B.FUnitID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_MeasureUnit J on J.FID = A.FSnUnitID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_Person M on M.FID = B.FSalePersonID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_Customer N on N.FID = BH.FCustomerID ");
        sbFrom.append("LEFT OUTER JOIN T_BD_MultiMeasureUnit O ON O.FMaterialID = A.FMaterialID and O.FMeasureUnitID = B.FUnitID ");
        StringBuffer sbWhere = new StringBuffer();
        if (condition.length() > 0) {
            sbWhere.append("Where ");
            sbWhere.append(condition);
            sbWhere.append(" And A.FBillTypeID = '");
            sbWhere.append("50957179-0105-1000-e000-015bc0a812fd463ED552");
            sbWhere.append("'");
        }
        RptRowSet prtRowSet = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(sbSelect);
        sqlBuff.append(sbFrom);
        sqlBuff.append(sbWhere);
        sqlBuff.append(" order BY ");
        sqlBuff.append("A.FBillNumber DESC ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            prtRowSet = DBUtil.executeQuery((String)sqlBuff.toString(), null, (int)0, (int)-1, (Connection)conn);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        }
        return prtRowSet;
    }

    protected String getConditionFromParams(RptParams params) throws BOSException {
        String assistTo;
        String assistFrom;
        String lotTo;
        String lotFrom;
        String materialNumTo;
        String materialNumFrom;
        String warehouseTo;
        String warehouseFrom;
        String storetypeTo;
        String storetypeFrom;
        String stOrgUnitTo;
        String stOrgUnitFrom;
        StringBuffer sb = new StringBuffer();
        boolean isNull = true;
        String strOrgUintIn = (String)params.getObject("StOrgUnitIn");
        if (strOrgUintIn != null && strOrgUintIn.length() > 0) {
            strOrgUintIn = strOrgUintIn.substring(3);
            sb.append("D.Fid ");
            sb.append(strOrgUintIn);
            sb.append(" ");
            isNull = false;
        }
        if (params.getObject("StOrgUnitFrom") != null && (stOrgUnitFrom = (String)params.getObject("StOrgUnitFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("D.Fnumber >= '");
            sb.append(stOrgUnitFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("StOrgUnitTo") != null && (stOrgUnitTo = (String)params.getObject("StOrgUnitTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("D.Fnumber <= '");
            sb.append(stOrgUnitTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("BillNumberFrom") != null && (storetypeFrom = (String)params.getObject("BillNumberFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("A.FBillNumber >= '");
            sb.append(storetypeFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("BillNumberTo") != null && (storetypeTo = (String)params.getObject("BillNumberTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("A.FBillNumber <= '");
            sb.append(storetypeTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("WarehouseFrom") != null && (warehouseFrom = (String)params.getObject("WarehouseFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("F.Fnumber >= '");
            sb.append(warehouseFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("WarehouseTo") != null && (warehouseTo = (String)params.getObject("WarehouseTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("F.Fnumber <= '");
            sb.append(warehouseTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("MaterialNumFrom") != null && (materialNumFrom = (String)params.getObject("MaterialNumFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("C.Fnumber >= '");
            sb.append(materialNumFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("MaterialNumTo") != null && (materialNumTo = (String)params.getObject("MaterialNumTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("C.Fnumber <= '");
            sb.append(materialNumTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("CustomerFrom") != null && (materialNumFrom = (String)params.getObject("CustomerFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("N.Fnumber >= '");
            sb.append(materialNumFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("CustomerTo") != null && (materialNumTo = (String)params.getObject("CustomerTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("N.Fnumber <= '");
            sb.append(materialNumTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("LotFrom") != null && (lotFrom = (String)params.getObject("LotFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("B.Flot >= '");
            sb.append(lotFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("LotTo") != null && (lotTo = (String)params.getObject("LotTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("B.Flot <= '");
            sb.append(lotTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("SNFrom") != null && (assistFrom = (String)params.getObject("SNFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("AE.FSerialNumber >= '");
            sb.append(assistFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("SNTo") != null && (assistTo = (String)params.getObject("SNTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("AE.FSerialNumber <= '");
            sb.append(assistTo);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("SourceBillNumberFrom") != null && (assistFrom = (String)params.getObject("SourceBillNumberFrom")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("B.FSourceBillNumber >= '");
            sb.append(assistFrom);
            sb.append("' ");
            isNull = false;
        }
        if (params.getObject("SourceBillNumberTo") != null && (assistTo = (String)params.getObject("SourceBillNumberTo")).trim().length() > 0) {
            if (!isNull) {
                sb.append("AND ");
            }
            sb.append("B.FSourceBillNumber <= '");
            sb.append(assistTo);
            sb.append("' ");
            isNull = false;
        }
        return sb.toString();
    }

    protected String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    @Override
    protected void _unAduitSerialInventory(Context ctx, IObjectValue scmBillBaseInfo) throws BOSException, EASBizException {
        if (scmBillBaseInfo == null) {
            return;
        }
        StringBuilder stringBuffer = new StringBuilder();
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)scmBillBaseInfo;
        if (aSCMBillBaseInfo instanceof StockTransferBillInfo || aSCMBillBaseInfo instanceof TransferOrderBillInfo) {
            return;
        }
        IObjectCollection iObjectCollection = (IObjectCollection)aSCMBillBaseInfo.get("entry");
        if (iObjectCollection == null && (iObjectCollection = (IObjectCollection)aSCMBillBaseInfo.get("entries")) == null) {
            return;
        }
        int entrySize = iObjectCollection.size();
        SCMBillEntryBaseInfo ibb = null;
        HashSet<String> mIds = new HashSet<String>();
        for (int i = 0; i < entrySize; ++i) {
            ibb = (SCMBillEntryBaseInfo)iObjectCollection.getObject(i);
            if (ibb == null || ibb.getMaterial() == null || ibb.getMaterial().getId() == null) continue;
            mIds.add(ibb.getMaterial().getId().toString());
        }
        if (mIds.size() == 0) {
            return;
        }
        this.unAduitSerialNumInventory(ctx, aSCMBillBaseInfo);
        stringBuffer.append("update T_IV_MaterialSNInventory as A set (FSnStatus) = ");
        stringBuffer.append(" (SELECT");
        stringBuffer.append(" case when C.FSnStatus = ").append(1);
        stringBuffer.append(" then ").append(2);
        stringBuffer.append(" when C.FSnStatus = ").append(3);
        stringBuffer.append(" then ").append(3);
        stringBuffer.append(" else ").append(1);
        stringBuffer.append(" end as FSnStatus ");
        stringBuffer.append(" from T_IV_MaterialSerialNumber C ");
        stringBuffer.append(" inner join T_IV_MaterialSerialNumberEntry D on C.fid = D.fparentid");
        stringBuffer.append(" where C.fmaterialid in ").append(this.getInStringFromSet(mIds));
        stringBuffer.append(" and C.fbillid = '").append(aSCMBillBaseInfo.getId()).append("' ");
        stringBuffer.append(" and C.FMaterialID = A.FMaterialID ");
        stringBuffer.append(" and D.FSerialNumber = A.FSerialNumber) ");
        stringBuffer.append(" where A.fmaterialid in ").append(this.getInStringFromSet(mIds));
        String sqlStr = stringBuffer.toString();
        DbUtil.execute((Context)ctx, (String)sqlStr);
    }

    private void unAduitSerialNumInventory(Context ctx, SCMBillBaseInfo scmBillBaseInfo) throws EASBizException, BOSException {
        MaterialSerialNumberInfo[] serialNumberInfos = null;
        if (scmBillBaseInfo instanceof InvBillBaseInfo) {
            InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)scmBillBaseInfo;
            if (!InvCommonUtils.isNeedUpdateSerialNumber(invBillBaseInfo)) {
                return;
            }
            if (invBillBaseInfo.getTransactionType() == null || invBillBaseInfo.getTransactionType().getId() == null) {
                return;
            }
            serialNumberInfos = this.buildMaterialSerialNumberInfos(ctx, invBillBaseInfo);
        } else if (scmBillBaseInfo instanceof StockTransferBillInfo) {
            StockTransferBillInfo stockTransferBillInfo = (StockTransferBillInfo)scmBillBaseInfo;
            serialNumberInfos = this.buildMaterialSerialNumberInfos(ctx, stockTransferBillInfo);
        } else if (scmBillBaseInfo instanceof TransferOrderBillInfo) {
            TransferOrderBillInfo transferOrderBillInfo = (TransferOrderBillInfo)scmBillBaseInfo;
            serialNumberInfos = this.buildMaterialSerialNumberInfos(ctx, transferOrderBillInfo);
        }
        if (serialNumberInfos == null || serialNumberInfos.length == 0) {
            return;
        }
        this.lockSerialNumberRecords(ctx, scmBillBaseInfo);
        this.checkSerialNumber(ctx, false, (IObjectValue[])serialNumberInfos);
    }

    @Override
    protected void _updateMaterialSN(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        if (!(billInfo instanceof InvBillBaseInfo && InvCommonUtils.isNeedUpdateSerialNumber((InvBillBaseInfo)billInfo) || billInfo instanceof StockTransferBillInfo || billInfo instanceof TransferOrderBillInfo || billInfo instanceof MatAttrChangeBillInfo)) {
            return;
        }
        SCMBillBaseCollection collection = new SCMBillBaseCollection();
        collection.addObject(billInfo);
        this._updateMaterialSN(ctx, (IObjectCollection)collection);
    }

    @Override
    protected void _updateMaterialSN(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        int i;
        IObjectValue object = collection.getObject(0);
        if (!(object instanceof InvBillBaseInfo && InvCommonUtils.isNeedUpdateSerialNumber((InvBillBaseInfo)object) || object instanceof StockTransferBillInfo || object instanceof TransferOrderBillInfo || object instanceof MatAttrChangeBillInfo)) {
            return;
        }
        ArrayList<MaterialSerialNumberInfo> snList = new ArrayList<MaterialSerialNumberInfo>();
        HashSet<String> invUpdateTypeIdSet = new HashSet<String>();
        for (int i2 = 0; i2 < collection.size(); ++i2) {
            SCMBillBaseInfo scmBillInfo = (SCMBillBaseInfo)collection.getObject(i2);
            for (int k = 0; k < scmBillInfo.getEntries().size(); ++k) {
                SCMBillEntryBaseInfo ibb = (SCMBillEntryBaseInfo)scmBillInfo.getEntries().getObject(k);
                if (ibb.get("invUpdateType") == null) continue;
                InvUpdateTypeInfo invUpdateType = (InvUpdateTypeInfo)ibb.get("invUpdateType");
                invUpdateTypeIdSet.add(invUpdateType.getId().toString());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectorForInvUpdateType());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", invUpdateTypeIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        InvUpdateTypeCollection updateTypeCollection = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeCollection(view);
        for (i = 0; i < collection.size(); ++i) {
            SCMBillBaseInfo scmBillInfo = (SCMBillBaseInfo)collection.getObject(i);
            block3: for (int k = 0; k < scmBillInfo.getEntries().size(); ++k) {
                SCMBillEntryBaseInfo ibb = (SCMBillEntryBaseInfo)scmBillInfo.getEntries().getObject(k);
                if (ibb.get("invUpdateType") == null) continue;
                InvUpdateTypeInfo invUpdateType = (InvUpdateTypeInfo)ibb.get("invUpdateType");
                for (int j = 0; j < updateTypeCollection.size(); ++j) {
                    if (!invUpdateType.getId().toString().equals(updateTypeCollection.get(j).getId().toString())) continue;
                    ibb.put("invUpdateType", (Object)updateTypeCollection.get(j));
                    continue block3;
                }
            }
        }
        int size = collection.size();
        for (i = 0; i < size; ++i) {
            IObjectValue obj = collection.getObject(i);
            if (obj instanceof MatAttrChangeBillInfo || obj instanceof MatDisassembleBillInfo || obj instanceof MatAssembleBillInfo) {
                this.getMaterialSNList4DoubleEntry((InvBillBaseInfo)obj, snList);
                continue;
            }
            if (obj instanceof InvBillBaseInfo) {
                this.getMaterialSNList((InvBillBaseInfo)obj, snList);
                continue;
            }
            if (obj instanceof StockTransferBillInfo) {
                this.getMaterialSNList((StockTransferBillInfo)obj, snList);
                continue;
            }
            if (!(obj instanceof TransferOrderBillInfo)) continue;
            this.getMaterialSNList((TransferOrderBillInfo)obj, snList);
        }
        if (snList.size() > 0) {
            this.updateMaterialSN(ctx, snList);
        }
    }

    private void getMaterialSNList4DoubleEntry(InvBillBaseInfo billInfo, List<MaterialSerialNumberInfo> snList) {
        if (billInfo.getId() == null) {
            return;
        }
        String strBillId = billInfo.getId().toString();
        String strBillNumber = billInfo.getNumber();
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        if (iObjectCollection == null) {
            iObjectCollection = (IObjectCollection)billInfo.get("entries");
        }
        IObjectCollection entryCollection = null;
        MaterialSerialNumberInfo aMaterialSerialNumberInfo = null;
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            if (entryInfo.getId() == null) continue;
            aMaterialSerialNumberInfo = new MaterialSerialNumberInfo();
            aMaterialSerialNumberInfo.setBillID(strBillId);
            aMaterialSerialNumberInfo.setBillNumber(strBillNumber);
            aMaterialSerialNumberInfo.setSnUnit(entryInfo.getUnit());
            aMaterialSerialNumberInfo.setStorageOrgUnit(entryInfo.getStorageOrgUnit());
            aMaterialSerialNumberInfo.setBillEntryID(entryInfo.getId().toString());
            aMaterialSerialNumberInfo.setBillEntrySeq(entryInfo.getSeq());
            aMaterialSerialNumberInfo.setMaterial(entryInfo.getMaterial());
            aMaterialSerialNumberInfo.setTransactionType(billInfo.getTransactionType());
            aMaterialSerialNumberInfo.setBillBaseStatus(billInfo.getBaseStatus());
            aMaterialSerialNumberInfo.setBillBizDate(billInfo.getBizDate());
            aMaterialSerialNumberInfo.setWarehouse(entryInfo.getWarehouse());
            aMaterialSerialNumberInfo.setLocation(entryInfo.getLocation());
            aMaterialSerialNumberInfo.setAuditTime(billInfo.getAuditTime());
            aMaterialSerialNumberInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
            snList.add(aMaterialSerialNumberInfo);
            entryCollection = (IObjectCollection)entryInfo.get("entry1");
            if (entryCollection == null) {
                entryCollection = (IObjectCollection)entryInfo.get("entries");
            }
            if (entryCollection == null || entryCollection.size() <= 0) continue;
            for (int j = 0; j < entryCollection.size(); ++j) {
                InvBillBaseEntryInfo entryEntryInfo = (InvBillBaseEntryInfo)entryCollection.getObject(j);
                aMaterialSerialNumberInfo = new MaterialSerialNumberInfo();
                aMaterialSerialNumberInfo.setBillID(strBillId);
                aMaterialSerialNumberInfo.setBillNumber(strBillNumber);
                aMaterialSerialNumberInfo.setSnUnit(entryEntryInfo.getUnit());
                aMaterialSerialNumberInfo.setStorageOrgUnit(entryEntryInfo.getStorageOrgUnit());
                aMaterialSerialNumberInfo.setBillEntryID(entryEntryInfo.getId().toString());
                aMaterialSerialNumberInfo.setBillEntrySeq(entryEntryInfo.getSeq());
                aMaterialSerialNumberInfo.setMaterial(entryEntryInfo.getMaterial());
                aMaterialSerialNumberInfo.setTransactionType(billInfo.getTransactionType());
                aMaterialSerialNumberInfo.setBillBaseStatus(billInfo.getBaseStatus());
                aMaterialSerialNumberInfo.setBillBizDate(billInfo.getBizDate());
                aMaterialSerialNumberInfo.setWarehouse(entryEntryInfo.getWarehouse());
                aMaterialSerialNumberInfo.setLocation(entryEntryInfo.getLocation());
                aMaterialSerialNumberInfo.setAuditTime(billInfo.getAuditTime());
                aMaterialSerialNumberInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
                snList.add(aMaterialSerialNumberInfo);
            }
        }
    }

    private void getMaterialSNList(InvBillBaseInfo aInvBillBaseInfo, List<MaterialSerialNumberInfo> snList) {
        if (aInvBillBaseInfo.getId() == null) {
            return;
        }
        String billTypeID = null;
        if (this.getBillTypeByBosType(aInvBillBaseInfo) != null) {
            billTypeID = this.getBillTypeByBosType(aInvBillBaseInfo).getId().toString();
        }
        String strBillId = aInvBillBaseInfo.getId().toString();
        String strBillNumber = aInvBillBaseInfo.getNumber();
        IObjectCollection iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entry");
        if (iObjectCollection == null) {
            return;
        }
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            if (aInvBillBaseEntryInfo.getId() == null) continue;
            MaterialSerialNumberInfo aMaterialSerialNumberInfo = new MaterialSerialNumberInfo();
            aMaterialSerialNumberInfo.setBillID(strBillId);
            aMaterialSerialNumberInfo.setBillNumber(strBillNumber);
            aMaterialSerialNumberInfo.setSnUnit(aInvBillBaseEntryInfo.getUnit());
            aMaterialSerialNumberInfo.setStorageOrgUnit(aInvBillBaseInfo.getStorageOrgUnit());
            aMaterialSerialNumberInfo.setBillEntryID(aInvBillBaseEntryInfo.getId().toString());
            aMaterialSerialNumberInfo.setBillEntrySeq(aInvBillBaseEntryInfo.getSeq());
            aMaterialSerialNumberInfo.setMaterial(aInvBillBaseEntryInfo.getMaterial());
            aMaterialSerialNumberInfo.setTransactionType(aInvBillBaseInfo.getTransactionType());
            aMaterialSerialNumberInfo.setBillBaseStatus(aInvBillBaseInfo.getBaseStatus());
            aMaterialSerialNumberInfo.setBillBizDate(aInvBillBaseInfo.getBizDate());
            aMaterialSerialNumberInfo.setWarehouse(aInvBillBaseEntryInfo.getWarehouse());
            aMaterialSerialNumberInfo.setLocation(aInvBillBaseEntryInfo.getLocation());
            aMaterialSerialNumberInfo.setAuditTime(aInvBillBaseInfo.getAuditTime());
            TransactionTypeInfo transactionTypeInfo = aInvBillBaseInfo.getTransactionType();
            InvUpdateTypeInfo invUpdateType = aInvBillBaseEntryInfo.getInvUpdateType();
            if (transactionTypeInfo != null && invUpdateType != null) {
                boolean isNegative = aInvBillBaseInfo.isIsReversed() ^ InvAppUtils.isNegative(transactionTypeInfo);
                SerialNumberStatusEnum snstatus = InvCommonUtils.getSnStatusByTranType(transactionTypeInfo, invUpdateType, isNegative);
                aMaterialSerialNumberInfo.setSnStatus(snstatus);
            } else if ("50957179-0105-1000-e001-1152c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID)) {
                aMaterialSerialNumberInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
            } else if ("528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID)) {
                aMaterialSerialNumberInfo.setSnStatus(SerialNumberStatusEnum.INWAREHOUSE);
            } else {
                aMaterialSerialNumberInfo.setSnStatus(SerialNumberStatusEnum.NULL);
            }
            snList.add(aMaterialSerialNumberInfo);
        }
    }

    private void getMaterialSNList(StockTransferBillInfo billInfo, List<MaterialSerialNumberInfo> snList) {
        if (billInfo.getId() == null) {
            return;
        }
        String strBillId = billInfo.getId().toString();
        String strBillNumber = billInfo.getNumber();
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            StockTransferBillEntryInfo entryInfo = (StockTransferBillEntryInfo)iObjectCollection.getObject(i);
            if (entryInfo.getId() == null) continue;
            MaterialSerialNumberInfo aMaterialSerialNumberInfo = new MaterialSerialNumberInfo();
            aMaterialSerialNumberInfo.setBillID(strBillId);
            aMaterialSerialNumberInfo.setBillNumber(strBillNumber);
            aMaterialSerialNumberInfo.setSnUnit(entryInfo.getUnit());
            aMaterialSerialNumberInfo.setStorageOrgUnit(billInfo.getIssueStorageOrgUnit());
            aMaterialSerialNumberInfo.setBillEntryID(entryInfo.getId().toString());
            aMaterialSerialNumberInfo.setBillEntrySeq(entryInfo.getSeq());
            aMaterialSerialNumberInfo.setMaterial(entryInfo.getMaterial());
            aMaterialSerialNumberInfo.setTransactionType(null);
            aMaterialSerialNumberInfo.setBillBaseStatus(billInfo.getBaseStatus());
            aMaterialSerialNumberInfo.setBillBizDate(billInfo.getBizDate());
            aMaterialSerialNumberInfo.setWarehouse(entryInfo.getIssueWarehouse());
            aMaterialSerialNumberInfo.setLocation(entryInfo.getIssueLocation());
            aMaterialSerialNumberInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
            aMaterialSerialNumberInfo.setAuditTime(billInfo.getAuditTime());
            snList.add(aMaterialSerialNumberInfo);
        }
    }

    private void getMaterialSNList(TransferOrderBillInfo billInfo, List<MaterialSerialNumberInfo> snList) {
        if (billInfo.getId() == null) {
            return;
        }
        String strBillId = billInfo.getId().toString();
        String strBillNumber = billInfo.getNumber();
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            TransferOrderBillEntryInfo entryInfo = (TransferOrderBillEntryInfo)iObjectCollection.getObject(i);
            if (entryInfo.getId() == null) continue;
            MaterialSerialNumberInfo aMaterialSerialNumberInfo = new MaterialSerialNumberInfo();
            aMaterialSerialNumberInfo.setBillID(strBillId);
            aMaterialSerialNumberInfo.setBillNumber(strBillNumber);
            aMaterialSerialNumberInfo.setSnUnit(entryInfo.getUnit());
            aMaterialSerialNumberInfo.setStorageOrgUnit(entryInfo.getIssueStorageOrgUnit());
            aMaterialSerialNumberInfo.setBillEntryID(entryInfo.getId().toString());
            aMaterialSerialNumberInfo.setBillEntrySeq(entryInfo.getSeq());
            aMaterialSerialNumberInfo.setMaterial(entryInfo.getMaterial());
            aMaterialSerialNumberInfo.setTransactionType(null);
            aMaterialSerialNumberInfo.setBillBaseStatus(billInfo.getBaseStatus());
            aMaterialSerialNumberInfo.setBillBizDate(billInfo.getBizDate());
            aMaterialSerialNumberInfo.setWarehouse(entryInfo.getIssueWarehouse());
            aMaterialSerialNumberInfo.setLocation(entryInfo.getIssueLocation());
            aMaterialSerialNumberInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
            aMaterialSerialNumberInfo.setAuditTime(billInfo.getAuditTime());
            snList.add(aMaterialSerialNumberInfo);
        }
    }

    private Map updateMaterialSN(Context ctx, List materialSNList) throws BOSException, EASBizException {
        HashSet delIDSet = new HashSet();
        HashSet<String> billIDSet = new HashSet<String>();
        HashSet<String> billEntryIDSet = new HashSet<String>();
        HashMap snIdEntryIDMap = new HashMap();
        for (int i = 0; i < materialSNList.size(); ++i) {
            MaterialSerialNumberInfo snInfo = (MaterialSerialNumberInfo)materialSNList.get(i);
            String billID = snInfo.getBillID();
            String entryID = snInfo.getBillEntryID();
            billIDSet.add(billID);
            billEntryIDSet.add(entryID);
            if (snIdEntryIDMap.containsKey(billID)) {
                ((Set)snIdEntryIDMap.get(billID)).add(entryID);
                continue;
            }
            HashSet<String> entryIDSet = new HashSet<String>();
            entryIDSet.add(entryID);
            snIdEntryIDMap.put(billID, entryIDSet);
        }
        String selectSQL = "select fid, fmaterialid,fsnunitid,fbillid,fbillentryid from T_IV_MaterialSerialNumber where fbillid in (" + CollectionUtil.convertList2String(new ArrayList(billIDSet)) + ") and fbillentryid in (" + CollectionUtil.convertList2String(new ArrayList(billEntryIDSet)) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        HashMap idEntryIdValueMap = new HashMap();
        try {
            if (rs.next()) {
                String fid = rs.getString("fid");
                String materialID = rs.getString("fmaterialid");
                String unitID = rs.getString("fsnunitid");
                String billID = rs.getString("fbillid");
                String billEntryID = rs.getString("fbillentryid");
                String key = (String)billID + "|" + billEntryID;
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(fid);
                valueList.add(materialID);
                valueList.add(unitID);
                idEntryIdValueMap.put(key, valueList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        for (int i = 0; i < materialSNList.size(); ++i) {
            MaterialSerialNumberInfo snInfo = (MaterialSerialNumberInfo)materialSNList.get(i);
            List valueList = (List)idEntryIdValueMap.get(snInfo.getBillID() + "|" + snInfo.getBillEntryID());
            if (valueList == null || valueList.size() <= 0 || snInfo.getMaterial() != null && snInfo.getMaterial().getId().toString().equals(valueList.get(1)) && snInfo.getSnUnit() != null && snInfo.getSnUnit().getId().toString().equals(valueList.get(2))) continue;
            delIDSet.add(valueList.get(0));
        }
        Set billIdSet = snIdEntryIDMap.keySet();
        int k = 0;
        StringBuffer sb = new StringBuffer();
        for (String billId : billIdSet) {
            if (k != 0) {
                sb.append(" union all ");
            }
            sb.append(" select fid from T_IV_MaterialSerialNumber where fbillid = '").append(billId).append("' and fbillentryid not in (").append(CollectionUtil.convertList2String(new ArrayList((Collection)snIdEntryIDMap.get(billId)))).append(") ");
            ++k;
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                delIDSet.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
        if (delIDSet.size() > 0) {
            String deleteSNSQL = "delete from t_iv_materialserialnumber where fid = ?";
            String deleteSQL = "delete from t_iv_materialserialnumberentry where fparentid = ?";
            Object[][] delParams = new Object[delIDSet.size()][1];
            int mark = 0;
            for (String fid : delIDSet) {
                delParams[mark][0] = fid;
                ++mark;
            }
            KsqlUtil.executeBatch((Context)ctx, (String)deleteSNSQL, (Object[][])delParams);
            KsqlUtil.executeBatch((Context)ctx, (String)deleteSQL, (Object[][])delParams);
        }
        String updateSQL = " update T_IV_MaterialSerialNumber set FSnUnitID = ?, FStorageOrgUnitID = ?, FMaterialID = ?, FBillNumber = ?, FBillEntrySeq = ?, FBillBizDate = ?, FTransactionTypeID = ?, FBillBaseStatus = ?, FWarehouseID = ?, FLocationID = ?, FSnStatus = ?, FAuditTime = ? where FBillID = ? and FBillEntryID = ? ";
        Object[][] conditions = new Object[materialSNList.size()][14];
        for (int i = 0; i < materialSNList.size(); ++i) {
            MaterialSerialNumberInfo snInfo = (MaterialSerialNumberInfo)materialSNList.get(i);
            if (snInfo.getMaterial() == null || snInfo.getMaterial().getSeqUnit() == null) continue;
            String snUnitID = null;
            if (snInfo.getSnUnit() != null) {
                snUnitID = snInfo.getSnUnit().getId().toString();
            }
            conditions[i][0] = snUnitID;
            conditions[i][1] = snInfo.getStorageOrgUnit() == null ? null : snInfo.getStorageOrgUnit().getId().toString();
            conditions[i][2] = snInfo.getMaterial().getId().toString();
            conditions[i][3] = snInfo.getBillNumber();
            conditions[i][4] = snInfo.getBillEntrySeq();
            conditions[i][5] = snInfo.getBillBizDate();
            String transactionTypeID = null;
            if (snInfo.getTransactionType() != null) {
                transactionTypeID = snInfo.getTransactionType().getId().toString();
            }
            conditions[i][6] = transactionTypeID;
            conditions[i][7] = snInfo.getBillBaseStatus().getValue();
            String warehouseID = null;
            if (snInfo.getWarehouse() != null) {
                warehouseID = snInfo.getWarehouse().getId().toString();
            }
            conditions[i][8] = warehouseID;
            String locationID = null;
            if (snInfo.getLocation() != null) {
                locationID = snInfo.getLocation().getId().toString();
            }
            conditions[i][9] = locationID;
            conditions[i][10] = snInfo.getSnStatus().getValue();
            conditions[i][11] = snInfo.getAuditTime();
            conditions[i][12] = snInfo.getBillID();
            conditions[i][13] = snInfo.getBillEntryID();
        }
        KsqlUtil.executeBatch((Context)ctx, (String)updateSQL, (Object[][])conditions);
        return null;
    }

    @Override
    protected Map _saveSelectedMaterialSN(Context ctx, IObjectValue billInfo, IObjectValue entryInfo, List serialNumberList) throws BOSException, EASBizException {
        SCMBillBaseInfo scmBillInfo = (SCMBillBaseInfo)billInfo;
        SCMBillEntryBaseInfo scmBillEntryInfo = (SCMBillEntryBaseInfo)entryInfo;
        if (scmBillInfo.getId() == null || scmBillEntryInfo.getId() == null) {
            return null;
        }
        String billID = scmBillInfo.getId().toString();
        String billEntryID = scmBillEntryInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)billEntryID));
        view.setFilter(filter);
        MaterialSerialNumberCollection snColl = this.getMaterialSerialNumberCollection(ctx, view);
        if (snColl != null && snColl.size() > 0) {
            for (int j = 0; j < snColl.size(); ++j) {
                MaterialSerialNumberInfo sn = snColl.get(j);
                sn.setSnQty(sn.getSnQty().add(new BigDecimal(serialNumberList.size())));
                MaterialSerialNumberEntryCollection sneColl = sn.getEntry();
                for (int i = 0; i < serialNumberList.size(); ++i) {
                    MaterialSerialNumberEntryInfo sne = new MaterialSerialNumberEntryInfo();
                    sne.setParent(sn);
                    sne.setSeq(scmBillEntryInfo.getSeq());
                    sne.setSerialNumber(serialNumberList.get(i).toString());
                    sne.setRemark(null);
                    sneColl.add(sne);
                }
            }
        } else {
            snColl = new MaterialSerialNumberCollection();
            MaterialSerialNumberInfo sn = this.buildMaterialSerialNumberInfo(scmBillInfo, scmBillEntryInfo, serialNumberList);
            snColl.add(sn);
        }
        this._saveSerialNumber(ctx, (IObjectCollection)snColl);
        return null;
    }

    private MaterialSerialNumberInfo buildMaterialSerialNumberInfo(SCMBillBaseInfo scmBillInfo, SCMBillEntryBaseInfo scmBillEntryInfo, List serialNumberList) {
        MaterialSerialNumberInfo serialNumberInfo;
        block4: {
            block5: {
                block3: {
                    serialNumberInfo = new MaterialSerialNumberInfo();
                    if (!(scmBillInfo instanceof InvBillBaseInfo)) break block3;
                    InvBillBaseInfo invBillInfo = (InvBillBaseInfo)scmBillInfo;
                    InvBillBaseEntryInfo invBillEntryInfo = (InvBillBaseEntryInfo)scmBillEntryInfo;
                    serialNumberInfo.setBillID(invBillInfo.getId().toString());
                    serialNumberInfo.setBillType(this.getBillTypeByBosType(invBillInfo));
                    serialNumberInfo.setBillNumber(invBillInfo.getNumber());
                    serialNumberInfo.setSnUnit(invBillEntryInfo.getUnit());
                    serialNumberInfo.setStorageOrgUnit(invBillEntryInfo.getStorageOrgUnit());
                    serialNumberInfo.setBillEntryID(invBillEntryInfo.getId().toString());
                    serialNumberInfo.setBillEntrySeq(invBillEntryInfo.getSeq());
                    serialNumberInfo.setMaterial(invBillEntryInfo.getMaterial());
                    serialNumberInfo.setTransactionType(invBillInfo.getTransactionType());
                    serialNumberInfo.setBillBaseStatus(invBillInfo.getBaseStatus());
                    serialNumberInfo.setBillBizDate(invBillInfo.getBizDate());
                    serialNumberInfo.setWarehouse(invBillEntryInfo.getWarehouse());
                    serialNumberInfo.setLocation(invBillEntryInfo.getLocation());
                    serialNumberInfo.setSnQty(new BigDecimal(serialNumberList.size()));
                    serialNumberInfo.setIsReversed(false);
                    SerialNumberStatusEnum snstatus = InvCommonUtils.getSnStatusByTranType(invBillInfo.getTransactionType(), invBillEntryInfo.getInvUpdateType(), invBillInfo.isIsReversed() ^ InvAppUtils.isNegative(invBillInfo.getTransactionType()));
                    serialNumberInfo.setSnStatus(snstatus);
                    for (int j = 0; j < serialNumberList.size(); ++j) {
                        MaterialSerialNumberEntryInfo serialNumberEntryInfo = new MaterialSerialNumberEntryInfo();
                        serialNumberEntryInfo.setSerialNumber((String)serialNumberList.get(j));
                        serialNumberInfo.getEntry().add(serialNumberEntryInfo);
                    }
                    break block4;
                }
                if (!(scmBillInfo instanceof StockTransferBillInfo)) break block5;
                StockTransferBillInfo stockTransferBillInfo = (StockTransferBillInfo)scmBillInfo;
                StockTransferBillEntryInfo stockTransferBillEntryInfo = (StockTransferBillEntryInfo)scmBillEntryInfo;
                serialNumberInfo.setBillID(stockTransferBillInfo.getId().toString());
                serialNumberInfo.setBillType(this.getBillTypeByBosType(stockTransferBillInfo));
                serialNumberInfo.setBillNumber(stockTransferBillInfo.getNumber());
                serialNumberInfo.setSnUnit(stockTransferBillEntryInfo.getUnit());
                serialNumberInfo.setStorageOrgUnit(stockTransferBillInfo.getIssueStorageOrgUnit());
                serialNumberInfo.setBillEntryID(stockTransferBillEntryInfo.getId().toString());
                serialNumberInfo.setBillEntrySeq(stockTransferBillEntryInfo.getSeq());
                serialNumberInfo.setMaterial(stockTransferBillEntryInfo.getMaterial());
                serialNumberInfo.setSnQty(new BigDecimal(serialNumberList.size()));
                serialNumberInfo.setIsReversed(false);
                serialNumberInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
                serialNumberInfo.setTransactionType(null);
                serialNumberInfo.setBillBaseStatus(stockTransferBillInfo.getBaseStatus());
                serialNumberInfo.setBillBizDate(stockTransferBillInfo.getBizDate());
                serialNumberInfo.setWarehouse(stockTransferBillEntryInfo.getIssueWarehouse());
                serialNumberInfo.setLocation(stockTransferBillEntryInfo.getIssueLocation());
                for (int j = 0; j < serialNumberList.size(); ++j) {
                    MaterialSerialNumberEntryInfo serialNumberEntryInfo = new MaterialSerialNumberEntryInfo();
                    serialNumberEntryInfo.setSerialNumber((String)serialNumberList.get(j));
                    serialNumberInfo.getEntry().add(serialNumberEntryInfo);
                }
                break block4;
            }
            if (!(scmBillInfo instanceof TransferOrderBillInfo)) break block4;
            TransferOrderBillInfo transferOrderBillInfo = (TransferOrderBillInfo)scmBillInfo;
            TransferOrderBillEntryInfo transferOrderBillEntryInfo = (TransferOrderBillEntryInfo)scmBillEntryInfo;
            serialNumberInfo.setBillID(transferOrderBillInfo.getId().toString());
            serialNumberInfo.setBillType(this.getBillTypeByBosType(transferOrderBillInfo));
            serialNumberInfo.setBillNumber(transferOrderBillInfo.getNumber());
            serialNumberInfo.setSnUnit(transferOrderBillEntryInfo.getUnit());
            serialNumberInfo.setStorageOrgUnit(transferOrderBillInfo.getIssueStorageOrgUnit());
            serialNumberInfo.setBillEntryID(transferOrderBillEntryInfo.getId().toString());
            serialNumberInfo.setBillEntrySeq(transferOrderBillEntryInfo.getSeq());
            serialNumberInfo.setMaterial(transferOrderBillEntryInfo.getMaterial());
            serialNumberInfo.setSnQty(new BigDecimal(serialNumberList.size()));
            serialNumberInfo.setIsReversed(false);
            serialNumberInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
            serialNumberInfo.setTransactionType(null);
            serialNumberInfo.setBillBaseStatus(transferOrderBillInfo.getBaseStatus());
            serialNumberInfo.setBillBizDate(transferOrderBillInfo.getBizDate());
            serialNumberInfo.setWarehouse(transferOrderBillEntryInfo.getIssueWarehouse());
            serialNumberInfo.setLocation(transferOrderBillEntryInfo.getIssueLocation());
            for (int j = 0; j < serialNumberList.size(); ++j) {
                MaterialSerialNumberEntryInfo serialNumberEntryInfo = new MaterialSerialNumberEntryInfo();
                serialNumberEntryInfo.setSerialNumber((String)serialNumberList.get(j));
                serialNumberInfo.getEntry().add(serialNumberEntryInfo);
            }
        }
        return serialNumberInfo;
    }

    @Override
    protected void _checkSerialNumberIsNull(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        if (!(billInfo instanceof InvBillBaseInfo && InvCommonUtils.isNeedUpdateSerialNumber((InvBillBaseInfo)billInfo) || billInfo instanceof StockTransferBillInfo || billInfo instanceof TransferOrderBillInfo || billInfo instanceof MatAttrChangeBillInfo)) {
            return;
        }
        HashMap<String, MaterialInventoryInfo> cacheMaterialInventoryMap = new HashMap<String, MaterialInventoryInfo>();
        StringBuffer errorMessage = new StringBuffer();
        if (billInfo instanceof SCMBillBaseInfo) {
            SCMBillBaseInfo scmBillBaseInfo = (SCMBillBaseInfo)billInfo;
            if (scmBillBaseInfo instanceof StockTransferBillInfo && !scmBillBaseInfo.getBoolean("autoTransfer") || scmBillBaseInfo instanceof TransferOrderBillInfo) {
                return;
            }
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)scmBillBaseInfo.get(scmBillBaseInfo.getBizOrgPropertyName());
            String souid = sou.getId().toString();
            if (!InvCommonUtils.isSerialRequired(souid, ctx).booleanValue()) {
                return;
            }
            Boolean isMultiEntry = false;
            BillTypeInfo billTypeInfo = scmBillBaseInfo.getBillType();
            if (billTypeInfo != null && ("50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeInfo.getId().toString()) || "CJeXjSzrKhfgU0ETqMA1nkY+1VI=".equals(billTypeInfo.getId().toString()) || "CJewLHpKKe/gU0ETqMDAp0Y+1VI=".equals(billTypeInfo.getId().toString()))) {
                isMultiEntry = true;
            }
            IObjectCollection entryColl = scmBillBaseInfo.getEntries();
            Map<String, MaterialSerialNumberInfo> serialNumberMap = this.getMaterialSerialNumber(ctx, scmBillBaseInfo, entryColl, isMultiEntry);
            SCMBillEntryBaseInfo entryInfo = null;
            MaterialInfo material = null;
            InvUpdateTypeInfo invUpdateType = null;
            String materialID = null;
            String storageOrgUnitID = null;
            MaterialInventoryInfo materialInventoryInfo = null;
            MaterialSerialNumberInfo materialSerialNumberInfo = null;
            String[] keys = null;
            IObjectCollection coll = null;
            SCMBillEntryBaseInfo afterEntry = null;
            IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < entryColl.size(); ++i) {
                entryInfo = (SCMBillEntryBaseInfo)entryColl.getObject(i);
                material = entryInfo.getMaterial();
                if (material == null || entryInfo.get("invUpdateType") != null && (invUpdateType = (InvUpdateTypeInfo)entryInfo.get("invUpdateType")) != null && invUpdateType.isIsNotUpdateInv()) continue;
                materialID = material.getId().toString();
                storageOrgUnitID = ((StorageOrgUnitInfo)scmBillBaseInfo.get(scmBillBaseInfo.getBizOrgPropertyName())).getId().toString();
                materialInventoryInfo = (MaterialInventoryInfo)cacheMaterialInventoryMap.get(materialID + storageOrgUnitID);
                if (materialInventoryInfo == null) {
                    materialInventoryInfo = iMaterialInventory.getInventoryInfo(materialID, souid);
                    cacheMaterialInventoryMap.put(materialID + storageOrgUnitID, materialInventoryInfo);
                }
                if (!materialInventoryInfo.isIsSequenceNo()) continue;
                if (material.getSeqUnit() == null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("seqUnit.number"));
                    sic.add(new SelectorItemInfo("seqUnit.name"));
                    material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId()), sic);
                }
                if (entryInfo.getUnit() != null && material.getSeqUnit() != null && !entryInfo.getUnit().getId().toString().equals(material.getSeqUnit().getId().toString())) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("billID", (Object)scmBillBaseInfo.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)entryInfo.getId().toString()));
                    this.delete(ctx, filter);
                    continue;
                }
                materialSerialNumberInfo = serialNumberMap.get(entryInfo.getId().toString());
                if (isMultiEntry.booleanValue()) {
                    keys = this.getResourceKeyByBillType(billTypeInfo.getId().toString());
                    if (materialSerialNumberInfo == null) {
                        errorMessage.append(SCMUtils.getResource((String)resFile, (String)keys[0], (String[])new String[]{String.valueOf(i + 1), material.getNumber()}, (Context)ctx)).append("\n");
                    } else if (entryInfo.getBigDecimal("qty").abs().compareTo(materialSerialNumberInfo.getSnQty().abs()) > 0) {
                        errorMessage.append(SCMUtils.getResource((String)resFile, (String)keys[1], (String[])new String[]{String.valueOf(i + 1), material.getNumber()}, (Context)ctx)).append("\n");
                    } else if (entryInfo.getBigDecimal("qty").abs().compareTo(materialSerialNumberInfo.getSnQty().abs()) < 0) {
                        errorMessage.append(SCMUtils.getResource((String)resFile, (String)keys[2], (String[])new String[]{String.valueOf(i + 1), material.getNumber()}, (Context)ctx)).append("\n");
                    }
                    coll = (IObjectCollection)entryInfo.get("entry1");
                    if (coll == null) {
                        coll = (IObjectCollection)entryInfo.get("entries");
                    }
                    for (int j = 0; j < coll.size(); ++j) {
                        afterEntry = (SCMBillEntryBaseInfo)coll.getObject(j);
                        material = afterEntry.getMaterial();
                        materialID = material.getId().toString();
                        if (material == null) continue;
                        materialInventoryInfo = (MaterialInventoryInfo)cacheMaterialInventoryMap.get(materialID + storageOrgUnitID);
                        if (materialInventoryInfo == null) {
                            materialInventoryInfo = iMaterialInventory.getInventoryInfo(materialID, souid);
                            cacheMaterialInventoryMap.put(materialID + storageOrgUnitID, materialInventoryInfo);
                        }
                        if (!materialInventoryInfo.isIsSequenceNo()) continue;
                        if (material.getSeqUnit() == null) {
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("*"));
                            sic.add(new SelectorItemInfo("number"));
                            sic.add(new SelectorItemInfo("name"));
                            sic.add(new SelectorItemInfo("seqUnit.number"));
                            sic.add(new SelectorItemInfo("seqUnit.name"));
                            material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId()), sic);
                        }
                        if (afterEntry.getUnit() != null && material.getSeqUnit() != null && !afterEntry.getUnit().getId().toString().equals(material.getSeqUnit().getId().toString())) {
                            FilterInfo filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)scmBillBaseInfo.getId().toString()));
                            filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)afterEntry.getId().toString()));
                            this.delete(ctx, filter);
                            continue;
                        }
                        materialSerialNumberInfo = serialNumberMap.get(afterEntry.getId().toString());
                        if (materialSerialNumberInfo == null) {
                            errorMessage.append(SCMUtils.getResource((String)resFile, (String)keys[3], (String[])new String[]{String.valueOf(i + 1), String.valueOf(j + 1), material.getNumber()}, (Context)ctx)).append("\n");
                            continue;
                        }
                        if (afterEntry.getBigDecimal("qty").abs().compareTo(materialSerialNumberInfo.getSnQty().abs()) > 0) {
                            errorMessage.append(SCMUtils.getResource((String)resFile, (String)keys[4], (String[])new String[]{String.valueOf(i + 1), String.valueOf(j + 1), material.getNumber()}, (Context)ctx)).append("\n");
                            continue;
                        }
                        if (afterEntry.getBigDecimal("qty").abs().compareTo(materialSerialNumberInfo.getSnQty().abs()) >= 0) continue;
                        errorMessage.append(SCMUtils.getResource((String)resFile, (String)keys[5], (String[])new String[]{String.valueOf(i + 1), String.valueOf(j + 1), material.getNumber()}, (Context)ctx)).append("\n");
                    }
                    continue;
                }
                if (materialSerialNumberInfo == null) {
                    errorMessage.append(SCMUtils.getResource((String)resFile, (String)"SERIALNUMBER_ISMUST", (String[])new String[]{scmBillBaseInfo.getNumber(), String.valueOf(i + 1)}, (Context)ctx)).append("\n");
                    continue;
                }
                if (entryInfo.getBigDecimal("qty").abs().compareTo(materialSerialNumberInfo.getSnQty().abs()) > 0) {
                    errorMessage.append(SCMUtils.getResource((String)resFile, (String)"SERIALNUMBER_ISLESS", (String[])new String[]{scmBillBaseInfo.getNumber(), String.valueOf(i + 1)}, (Context)ctx)).append("\n");
                    continue;
                }
                if (entryInfo.getBigDecimal("qty").abs().compareTo(materialSerialNumberInfo.getSnQty().abs()) >= 0) continue;
                errorMessage.append(SCMUtils.getResource((String)resFile, (String)"SERIALNUMBER_ISMORE", (String[])new String[]{scmBillBaseInfo.getNumber(), String.valueOf(i + 1)}, (Context)ctx)).append("\n");
            }
        }
        if (errorMessage.length() > 0) {
            throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{"\n" + errorMessage.toString()});
        }
    }

    public Map<String, MaterialSerialNumberInfo> getMaterialSerialNumber(Context ctx, SCMBillBaseInfo scmBillBaseInfo, IObjectCollection entryColl, Boolean isMultiEntry) throws BOSException {
        HashMap<String, MaterialSerialNumberInfo> map = new HashMap<String, MaterialSerialNumberInfo>();
        String billID = scmBillBaseInfo.getId().toString();
        HashSet<String> entryIdSet = new HashSet<String>();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        InvBillBaseEntryInfo beforeEntryInfo = null;
        InvBillBaseEntryInfo afterEntryInfo = null;
        IObjectCollection coll = null;
        SCMBillEntryBaseInfo entryInfo = null;
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                if (entryColl.getObject(i) != null) {
                    entryInfo = (SCMBillEntryBaseInfo)entryColl.getObject(i);
                    entryIdSet.add(entryInfo.getId().toString());
                }
                if (!isMultiEntry.booleanValue()) continue;
                beforeEntryInfo = (InvBillBaseEntryInfo)entryColl.getObject(i);
                coll = (IObjectCollection)beforeEntryInfo.get("entry1");
                if (coll == null) {
                    coll = (IObjectCollection)beforeEntryInfo.get("entries");
                }
                if (coll == null) continue;
                for (int j = 0; j < coll.size(); ++j) {
                    if (coll.getObject(j) == null) continue;
                    afterEntryInfo = (InvBillBaseEntryInfo)coll.getObject(j);
                    entryIdSet.add(afterEntryInfo.getId().toString());
                }
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        filter.getFilterItems().add(new FilterItemInfo("billEntryID", entryIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("snQty", (Object)BigDecimal.ZERO, CompareType.GREATER));
        ev.setFilter(filter);
        MaterialSerialNumberCollection snColl = MaterialSerialNumberFactory.getLocalInstance(ctx).getMaterialSerialNumberCollection(ev);
        if (snColl != null && snColl.size() > 0) {
            for (int i = 0; i < snColl.size(); ++i) {
                MaterialSerialNumberInfo msnInfo = snColl.get(i);
                String billEntryId = msnInfo.getBillEntryID();
                map.put(billEntryId, msnInfo);
            }
        }
        return map;
    }

    @Override
    protected void _checkSerialNumberIsNull(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        for (int m = 0; m < collection.size(); ++m) {
            this._checkSerialNumberIsNull(ctx, collection.getObject(m));
        }
    }

    private String getInStringFromSet(Set mIds) {
        if (mIds == null || mIds.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = mIds.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    @Override
    protected void _doSerialNumberCarry(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        if (!(collection.getObject(0) instanceof StockTransferBillInfo || collection.getObject(0) instanceof TransferOrderBillInfo || collection.getObject(0) instanceof InvBillBaseInfo && InvCommonUtils.isNeedUpdateSerialNumber((InvBillBaseInfo)collection.getObject(0)))) {
            return;
        }
        SCMBillBaseCollection scmBillBaseCollection = (SCMBillBaseCollection)collection;
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        for (int i = 0; i < scmBillBaseCollection.size(); ++i) {
            boolean isReturn;
            SCMBillBaseInfo billInfo = scmBillBaseCollection.get(i);
            if (billInfo.getId() == null) {
                return;
            }
            if (billInfo instanceof SaleIssueBillInfo && billInfo.getBizType().getBizCategory() != null && "88a7587a-e017-497b-9f86-b8f00ab2fe72A9389020".equals(billInfo.getBizType().getBizCategory().getId().toString()) && billInfo.getSourceBillType() != null && billInfo.getBillType().getId().toString().equals(billInfo.getSourceBillType().getId().toString()) && !(isReturn = InvServerUtils.isReturnRIType(ctx, ((SaleIssueBillInfo)billInfo).getTransactionType()))) continue;
            String billID = billInfo.getId().toString();
            EntityViewInfo ckViewInfo = new EntityViewInfo();
            FilterInfo ckFilter = new FilterInfo();
            ckFilter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
            ckViewInfo.setFilter(ckFilter);
            MaterialSerialNumberCollection ckSnColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(ckViewInfo);
            if (ckSnColl != null && ckSnColl.size() > 0) {
                return;
            }
            IObjectCollection entrys = billInfo.getEntries();
            for (int j = 0; j < entrys.size(); ++j) {
                SCMBillEntryBaseInfo entry = (SCMBillEntryBaseInfo)entrys.getObject(j);
                if (billInfo.getId() == null || entry.getId() == null || StringUtils.isEmpty((String)entry.getSourceBillId()) || StringUtils.isEmpty((String)entry.getSourceBillEntryId()) || entry.getMaterial() == null) continue;
                String entryID = entry.getId().toString();
                String sourceBillID = entry.getSourceBillId();
                String sourceBillEntryID = entry.getSourceBillEntryId();
                String materialID = entry.getMaterial().getId().toString();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billID", (Object)sourceBillID));
                filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)sourceBillEntryID));
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
                viewInfo.setFilter(filter);
                MaterialSerialNumberCollection snColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(viewInfo);
                TransactionTypeInfo tti = null;
                IObjectValue transactionType = billInfo.getObjectValue("transactionType");
                if (transactionType != null) {
                    tti = (TransactionTypeInfo)transactionType;
                }
                IObjectValue invUpdateTypeObj = entry.getObjectValue("invUpdateType");
                InvUpdateTypeInfo invUpdateType = null;
                if (invUpdateTypeObj != null) {
                    invUpdateType = (InvUpdateTypeInfo)invUpdateTypeObj;
                }
                String billTypeID = this.getBillTypeByBosType(billInfo).getId().toString();
                SerialNumberStatusEnum snstatus = null;
                snstatus = tti != null && invUpdateType != null ? InvCommonUtils.getSnStatusByTranType(tti, invUpdateType, billInfo.getBoolean("isReversed") ^ InvAppUtils.isNegative(tti)) : ("50957179-0105-1000-e001-1152c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeID) || "Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(billTypeID) ? SerialNumberStatusEnum.OUTTHENIN : ("528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID) ? SerialNumberStatusEnum.INWAREHOUSE : SerialNumberStatusEnum.NULL));
                HashSet<String> notNeedSNSet = new HashSet<String>();
                try {
                    String selectSQL = " select FSerialNumber from T_IV_MaterialSNInventory where FMaterialID = ? and FSerialNumber in  (select t2.FSerialNumber from T_IV_MaterialSerialNumber t1 inner join T_IV_MaterialSerialNumberEntry t2 on t1.fid = t2.FParentID  where t1.FBillID = ? and t1.FBillEntryID = ? and t1.FMaterialID = ?) and FSnStatus in ";
                    selectSQL = snstatus == SerialNumberStatusEnum.INWAREHOUSE ? selectSQL + "(2, 3)" : (snstatus == SerialNumberStatusEnum.SALE ? selectSQL + "(1)" : selectSQL + "(1)");
                    IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{materialID, sourceBillID, sourceBillEntryID, materialID});
                    while (rs.next()) {
                        String fSerialNumber = rs.getString("FSerialNumber");
                        notNeedSNSet.add(fSerialNumber);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                MaterialSerialNumberCollection snCollNew = new MaterialSerialNumberCollection();
                if (snColl != null && snColl.size() > 0) {
                    IObjectValue location;
                    MaterialSerialNumberInfo snInfo = snColl.get(0);
                    MaterialSerialNumberInfo snCopyInfo = (MaterialSerialNumberInfo)snInfo.clone();
                    snCopyInfo.setId(null);
                    snCopyInfo.setBillID(billID);
                    snCopyInfo.setBillEntryID(entryID);
                    snCopyInfo.setBillNumber(billInfo.getNumber());
                    snCopyInfo.setBillEntrySeq(entry.getSeq());
                    snCopyInfo.setBillType(this.getBillTypeByBosType(billInfo));
                    snCopyInfo.setIsReversed(billInfo.getBoolean("isReversed"));
                    snCopyInfo.setBillBizDate(billInfo.getBizDate());
                    snCopyInfo.setBillBaseStatus(billInfo.getBaseStatus());
                    IObjectValue warehouse = entry.getObjectValue("warehouse");
                    if (warehouse != null) {
                        snCopyInfo.setWarehouse((WarehouseInfo)warehouse);
                    }
                    if ((location = entry.getObjectValue("location")) != null) {
                        snCopyInfo.setLocation((LocationInfo)location);
                    }
                    snCopyInfo.setAuditTime(billInfo.getAuditTime());
                    snCopyInfo.setStorageOrgUnit((StorageOrgUnitInfo)billInfo.get(billInfo.getBizOrgPropertyName()));
                    snCopyInfo.setTransactionType(tti);
                    snCopyInfo.setSnStatus(snstatus);
                    snCopyInfo.getEntry().clear();
                    MaterialSerialNumberEntryCollection snEntryColl = snInfo.getEntry();
                    for (int m = 0; m < snEntryColl.size(); ++m) {
                        MaterialSerialNumberEntryInfo snEntryInfo = snEntryColl.get(m);
                        if (notNeedSNSet.contains(snEntryInfo.getSerialNumber())) continue;
                        MaterialSerialNumberEntryInfo snEntryCopyInfo = (MaterialSerialNumberEntryInfo)snEntryInfo.clone();
                        snEntryCopyInfo.setId(null);
                        snEntryCopyInfo.setParent(snCopyInfo);
                        snCopyInfo.getEntry().add(snEntryCopyInfo);
                    }
                    snCopyInfo.setSnQty(new BigDecimal(snCopyInfo.getEntry().size()));
                    snCollNew.add(snCopyInfo);
                }
                CoreBaseCollection newMsnCol = new CoreBaseCollection();
                newMsnCol.addObjectCollection((IObjectCollection)snCollNew);
                if (newMsnCol.size() <= 0) continue;
                iMaterialSerialNumber.addnewBatchData(newMsnCol);
            }
        }
    }

    @Override
    protected void _doSerialNumberCarry(Context ctx, InvBillBaseInfo srcBillInfo, InvBillBaseInfo destBillInfo, boolean isCarryFirstEntry) throws BOSException, EASBizException {
        block24: {
            try {
                String entry = "entry";
                String entries = "entries";
                String entry1 = "entry1";
                IObjectCollection entryOtherColl = (IObjectCollection)destBillInfo.get(entry);
                InvBillBaseEntryInfo entryOtherInfo = null;
                HashSet<String> entrySet = new HashSet<String>();
                IObjectCollection entryMatColl = (IObjectCollection)srcBillInfo.get(entry);
                if (entryMatColl == null) {
                    entryMatColl = (IObjectCollection)srcBillInfo.get(entries);
                }
                InvBillBaseEntryInfo entryBeforeInfo = null;
                IObjectCollection entryAfterColl = null;
                InvBillBaseEntryInfo entryAfterInfo = null;
                if (isCarryFirstEntry) {
                    for (int i = 0; i < entryOtherColl.size(); ++i) {
                        entryBeforeInfo = (InvBillBaseEntryInfo)entryMatColl.getObject(i);
                        entrySet.add(entryBeforeInfo.getId().toString());
                    }
                } else {
                    for (int x = 0; x < entryMatColl.size(); ++x) {
                        entryBeforeInfo = (InvBillBaseEntryInfo)entryMatColl.getObject(x);
                        entryAfterColl = (IObjectCollection)entryBeforeInfo.get(entry1);
                        if (entryAfterColl == null) {
                            entryAfterColl = (IObjectCollection)entryBeforeInfo.get(entries);
                        }
                        for (int j = 0; j < entryAfterColl.size(); ++j) {
                            entryAfterInfo = (InvBillBaseEntryInfo)entryAfterColl.getObject(j);
                            for (int k = 0; k < entryOtherColl.size(); ++k) {
                                entryOtherInfo = (InvBillBaseEntryInfo)entryOtherColl.getObject(k);
                                if (!entryOtherInfo.getSourceBillEntryId().toString().equals(entryBeforeInfo.getId().toString())) continue;
                                entrySet.add(entryAfterInfo.getId().toString());
                            }
                        }
                    }
                }
                if (srcBillInfo == null || srcBillInfo.getBillType() == null || srcBillInfo.getNumber() == null || entrySet == null || entrySet.size() <= 0) break block24;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)srcBillInfo.getBillType().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("billId", (Object)srcBillInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("billNumber", (Object)srcBillInfo.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("billEntryId", entrySet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                MaterialSerialNumberCollection msnCol = MaterialSerialNumberFactory.getLocalInstance(ctx).getMaterialSerialNumberCollection(viewInfo);
                if (msnCol == null || msnCol.size() <= 0) break block24;
                MaterialSerialNumberInfo msnInfo = null;
                MaterialSerialNumberEntryInfo entryInfo = null;
                HashMap<String, MaterialSerialNumberInfo> map = new HashMap<String, MaterialSerialNumberInfo>();
                int col = msnCol.size();
                for (int i = 0; i < col; ++i) {
                    msnInfo = msnCol.get(i);
                    if (msnInfo == null) continue;
                    msnInfo.setId(BOSUuid.create((BOSObjectType)msnInfo.getBOSType()));
                    msnInfo.setBillType(destBillInfo.getBillType());
                    msnInfo.setBillID(destBillInfo.getId().toString());
                    msnInfo.setBillNumber(destBillInfo.getNumber());
                    if (msnInfo.getEntry() != null) {
                        int count = msnInfo.getEntry().size();
                        for (int j = 0; j < count; ++j) {
                            entryInfo = msnInfo.getEntry().get(j);
                            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                            entryInfo.setParent(msnInfo);
                        }
                    }
                    map.put(msnInfo.getBillEntryID(), msnInfo);
                }
                CoreBaseCollection coll = new CoreBaseCollection();
                if (isCarryFirstEntry) {
                    for (int i = 0; i < entryOtherColl.size(); ++i) {
                        entryBeforeInfo = (InvBillBaseEntryInfo)entryMatColl.getObject(i);
                        entryOtherInfo = (InvBillBaseEntryInfo)entryOtherColl.getObject(i);
                        if (entryBeforeInfo.getId() == null || !map.containsKey(entryBeforeInfo.getId().toString()) || (msnInfo = (MaterialSerialNumberInfo)map.get(entryBeforeInfo.getId().toString())) == null) continue;
                        msnInfo.setBillEntryID(entryOtherInfo.getId().toString());
                        if (destBillInfo instanceof OtherIssueBillInfo) {
                            msnInfo.setSnStatus(SerialNumberStatusEnum.SALE);
                        } else {
                            msnInfo.setSnStatus(SerialNumberStatusEnum.INWAREHOUSE);
                        }
                        coll.addObject((IObjectValue)msnInfo);
                    }
                } else {
                    boolean flag = false;
                    block9: for (int k = 0; k < entryOtherColl.size(); ++k) {
                        flag = false;
                        entryOtherInfo = (InvBillBaseEntryInfo)entryOtherColl.getObject(k);
                        for (int x = 0; x < entryMatColl.size(); ++x) {
                            entryBeforeInfo = (InvBillBaseEntryInfo)entryMatColl.getObject(x);
                            entryAfterColl = (IObjectCollection)entryBeforeInfo.get(entry1);
                            if (entryAfterColl == null) {
                                entryAfterColl = (IObjectCollection)entryBeforeInfo.get(entries);
                            }
                            for (int j = 0; j < entryAfterColl.size(); ++j) {
                                entryAfterInfo = (InvBillBaseEntryInfo)entryAfterColl.getObject(j);
                                if (entryOtherInfo.getSourceBillEntryId() == null || !map.containsKey(entryAfterInfo.getId().toString()) || !entryOtherInfo.getSourceBillEntryId().toString().equals(entryBeforeInfo.getId().toString()) || !entryOtherInfo.getMaterial().getId().equals((Object)entryAfterInfo.getMaterial().getId()) || (msnInfo = (MaterialSerialNumberInfo)map.get(entryAfterInfo.getId().toString())) == null) continue;
                                msnInfo.setBillEntryID(entryOtherInfo.getId().toString());
                                if (destBillInfo instanceof OtherIssueBillInfo) {
                                    msnInfo.setSnStatus(SerialNumberStatusEnum.SALE);
                                } else {
                                    msnInfo.setSnStatus(SerialNumberStatusEnum.INWAREHOUSE);
                                }
                                coll.addObject((IObjectValue)msnInfo);
                                map.remove(entryAfterInfo.getId().toString());
                                flag = true;
                                break;
                            }
                            if (flag) continue block9;
                        }
                    }
                }
                MaterialSerialNumberFactory.getLocalInstance(ctx).addnew(coll);
            }
            catch (Exception e) {
                throw new InvBizException(InvBizException.IDCARD_INVALID);
            }
        }
    }

    private SelectorItemCollection getSelectorForInvUpdateType() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("existingQty"));
        sic.add(new SelectorItemInfo("existingQtyPre"));
        sic.add(new SelectorItemInfo("isNotUpdateInv"));
        sic.add(new SelectorItemInfo("scheduled"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("storeType.id"));
        sic.add(new SelectorItemInfo("storeType.number"));
        sic.add(new SelectorItemInfo("storeType.name"));
        sic.add(new SelectorItemInfo("storeType.storeFlag"));
        sic.add(new SelectorItemInfo("storeType.isForwardAmt"));
        sic.add(new SelectorItemInfo("storeState.id"));
        sic.add(new SelectorItemInfo("storeState.number"));
        sic.add(new SelectorItemInfo("storeState.name"));
        sic.add(new SelectorItemInfo("storeTypePre.id"));
        sic.add(new SelectorItemInfo("storeTypePre.number"));
        sic.add(new SelectorItemInfo("storeTypePre.name"));
        sic.add(new SelectorItemInfo("storeTypePre.storeFlag"));
        sic.add(new SelectorItemInfo("storeTypePre.isForwardAmt"));
        sic.add(new SelectorItemInfo("storeStatePre.id"));
        sic.add(new SelectorItemInfo("storeStatePre.number"));
        sic.add(new SelectorItemInfo("storeStatePre.name"));
        return sic;
    }

    private BillTypeInfo getBillTypeByBosType(SCMBillBaseInfo scmBillBaseInfo) {
        if (scmBillBaseInfo.getBillType() != null) {
            return scmBillBaseInfo.getBillType();
        }
        String bosType = scmBillBaseInfo.getBOSType().toString();
        String billTypeID = null;
        if (SCMConstant.BOSTYPE_SALEISSUE.equals(bosType)) {
            billTypeID = "50957179-0105-1000-e000-015bc0a812fd463ED552";
        } else if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType)) {
            billTypeID = "50957179-0105-1000-e000-015fc0a812fd463ED552";
        } else if ("A4D04D23".equals(bosType)) {
            billTypeID = "50957179-0105-1000-e000-017bc0a812fd463ED552";
        } else if ("A4D04D24".equals(bosType)) {
            billTypeID = "50957179-0105-1000-e000-0177c0a812fd463ED552";
        } else if ("E3DAFF63".equals(bosType)) {
            billTypeID = "50957179-0105-1000-e000-0172c0a812fd463ED552";
        } else if ("71D272F1".equals(bosType)) {
            billTypeID = "50957179-0105-1000-e000-016ec0a812fd463ED552";
        } else if ("500AB75E".equals(bosType)) {
            billTypeID = "50957179-0105-1000-e000-0163c0a812fd463ED552";
        } else if ("FA1292B4".equals(bosType)) {
            billTypeID = "50957179-0105-1000-e000-0167c0a812fd463ED552";
        } else if (SCMConstant.BOSTYPE_INVENTORYINIT.equals(bosType)) {
            billTypeID = "528d806a-0106-1000-e000-0194c0a812e6463ED552";
        } else if ("A4D04D25".equals(bosType)) {
            billTypeID = "50957179-0105-1000-e001-1152c0a812fd463ED552";
        } else if (SCMConstant.BOSTYPE_INVSTATEADJUST.equals(bosType)) {
            billTypeID = "50957179-0105-1000-e000-0152c0a812fd463ED552";
        } else if (SCMConstant.BOSTYPE_STOCKTRANSFER.equals(bosType)) {
            billTypeID = "50957179-0105-1000-e003-3152c0a812fd463ED552";
        } else if (SCMConstant.BOSTYPE_TRANSFERORDER.equals(bosType)) {
            billTypeID = "Eg5BUQEVEADgAAABwKgOEEY+1VI=";
        }
        if (billTypeID == null) {
            return null;
        }
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)billTypeID));
        return billType;
    }

    private String[] getResourceKeyByBillType(String billTypeId) {
        String[] keys = new String[6];
        switch (billTypeId) {
            case "50957179-0105-1000-e000-888880a812fd463ED552": {
                keys[0] = "MATATTRCHANGEBEFORE_ISMUST";
                keys[1] = "MATATTRCHANGEBEFORE_ISLESS";
                keys[2] = "MATATTRCHANGEBEFORE_ISMORE";
                keys[3] = "MATATTRCHANGEAFTER_ISMUST";
                keys[4] = "MATATTRCHANGEAFTER_ISLESS";
                keys[5] = "MATATTRCHANGEAFTER_ISMORE";
                break;
            }
            case "CJeXjSzrKhfgU0ETqMA1nkY+1VI=": {
                keys[0] = "MATDISASSBEFORE_ISMUST";
                keys[1] = "MATDISASSBEFORE_ISLESS";
                keys[2] = "MATDISASSBEFORE_ISMORE";
                keys[3] = "MATDISASSAFTER_ISMUST";
                keys[4] = "MATDISASSAFTER_ISLESS";
                keys[5] = "MATDISASSAFTER_ISMORE";
                break;
            }
            case "CJewLHpKKe/gU0ETqMDAp0Y+1VI=": {
                keys[0] = "MATASSBEFORE_ISMUST";
                keys[1] = "MATASSBEFORE_ISLESS";
                keys[2] = "MATASSBEFORE_ISMORE";
                keys[3] = "MATASSAFTER_ISMUST";
                keys[4] = "MATASSAFTER_ISLESS";
                keys[5] = "MATASSAFTER_ISMORE";
            }
        }
        return keys;
    }
}

