/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialSupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.MaterialSupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.MaterialSupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMaterialSupplyRelationControllerBean;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class MaterialSupplyRelationControllerBean
extends AbstractMaterialSupplyRelationControllerBean {
    public static final String ORG_ID = "11111111-1111-1111-1111-111111111111CCE7AED4";

    @Override
    protected Map _handleByOprt(Context ctx, String oprtState, String billId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (OprtStateConstant.ADDNEW.equals(oprtState)) {
            List<FullOrgUnitInfo> list = this.getCtrlUnitsByPermission(ctx);
            CtrlUnitInfo cu = this.setDefaultCU(ctx, list);
            map.put("cu", cu);
            map.put("cu_f7", this.getCuFilter(ctx, list));
            map.put("mst_f7", this.getMaterialStandardF7(ctx, cu));
            map.put("materialGroup_f7", this.materialGroupFilter(cu));
        } else if (OprtStateConstant.EDIT.equals(oprtState) && !StringUtil.isEmpty((String)billId)) {
            MaterialSupplyRelationInfo billInfo = this.getRelationInfoById(ctx, billId);
            if (billInfo == null || billInfo.getCU() == null) {
                return null;
            }
            List<FullOrgUnitInfo> list = this.getCtrlUnitsByPermission(ctx);
            map.put("cu_f7", this.getCuFilter(ctx, list));
            map.put("mst_f7", this.getMaterialStandardF7(ctx, billInfo.getCU()));
            map.put("materialGroup_f7", this.materialGroupFilter(billInfo.getCU()));
            map.put("billInfo", billInfo);
        } else if (OprtStateConstant.EDIT.equals(oprtState) && !StringUtil.isEmpty((String)billId)) {
            MaterialSupplyRelationInfo billInfo = this.getRelationInfoById(ctx, billId);
            map.put("billInfo", billInfo);
        }
        return map;
    }

    private CtrlUnitInfo setDefaultCU(Context ctx, List<FullOrgUnitInfo> list) throws EASBizException, BOSException {
        FullOrgUnitInfo orgUnitInfo = null;
        CtrlUnitInfo cu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        boolean isEqual = false;
        HashSet<String> idSet = new HashSet<String>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            orgUnitInfo = list.get(i);
            if (cu != null && cu.getId().toString().equals(orgUnitInfo.getId().toString())) {
                isEqual = true;
            }
            idSet.add(orgUnitInfo.getId().toString());
        }
        if (!isEqual && list.size() > 1) {
            orgUnitInfo = list.get(0);
            cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)orgUnitInfo.getId().toString()));
            cu.setName(orgUnitInfo.getName());
            cu.setNumber(orgUnitInfo.getNumber());
            cu.setLongNumber(orgUnitInfo.getLongNumber());
        }
        return cu;
    }

    private List<FullOrgUnitInfo> getCtrlUnitsByPermission(Context ctx) throws EASBizException, BOSException {
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitCollection fullColl = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg(ctx.getCaller(), OrgType.ControlUnit, null, this.getPermissionItem());
        if (fullColl == null || fullColl.size() == 0) {
            return null;
        }
        ArrayList<FullOrgUnitInfo> list = new ArrayList<FullOrgUnitInfo>();
        int size = fullColl.size();
        for (int i = 0; i < size; ++i) {
            orgUnitInfo = fullColl.get(i);
            if (ORG_ID.equals(orgUnitInfo.getId().toString())) continue;
            list.add(orgUnitInfo);
        }
        return list;
    }

    private String getCuFilter(Context ctx, List<FullOrgUnitInfo> list) {
        FullOrgUnitInfo orgUnitInfo = null;
        HashSet<String> idSet = new HashSet<String>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            orgUnitInfo = list.get(i);
            idSet.add(orgUnitInfo.getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        return filter.toString();
    }

    private String getPermissionItem() {
        return "materialSupply_view";
    }

    private String getMaterialStandardF7(Context ctx, CtrlUnitInfo cu) throws BOSException {
        if (cu == null) {
            return null;
        }
        MaterialGroupStandardInfo standardInfo = null;
        ArrayList list = new ArrayList();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cu.getId().toString(), (String)cu.getLongNumber());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfoCU);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        MaterialGroupStandardCollection coll = MaterialGroupStandardFactory.getLocalInstance((Context)ctx).getMaterialGroupStandardCollection(view);
        StringBuilder f7 = new StringBuilder();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            standardInfo = coll.get(i);
            f7.append("'").append(standardInfo.getId().toString()).append("'");
            if (i == size - 1) continue;
            f7.append(",");
        }
        return f7.toString();
    }

    private String materialGroupFilter(CtrlUnitInfo cu) throws EASBizException, BOSException {
        if (cu == null) {
            return null;
        }
        String longNumber = cu.getLongNumber();
        String[] numbers = longNumber.split("!");
        String cuIds = "";
        for (int i = 0; i < numbers.length; ++i) {
            cuIds = cuIds + "'" + numbers[i] + "',";
        }
        String materialGroup_filter = null;
        if (cuIds.length() > 0) {
            cuIds = cuIds.substring(0, cuIds.length() - 1);
            materialGroup_filter = "CU.number in(" + cuIds + ")";
            return materialGroup_filter;
        }
        return null;
    }

    private MaterialSupplyRelationInfo getRelationInfoById(Context ctx, String billId) throws EASBizException, BOSException {
        if (StringUtil.isEmpty((String)billId)) {
            return null;
        }
        return MaterialSupplyRelationFactory.getLocalInstance(ctx).getMaterialSupplyRelationInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelectorItems());
    }

    private SelectorItemCollection getSelectorItems() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("materialStandard.id"));
        sic.add(new SelectorItemInfo("materialStandard.number"));
        sic.add(new SelectorItemInfo("materialStandard.name"));
        sic.add(new SelectorItemInfo("materialGroup.id"));
        sic.add(new SelectorItemInfo("materialGroup.number"));
        sic.add(new SelectorItemInfo("materialGroup.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("requireOrgUnit.id"));
        sic.add(new SelectorItemInfo("requireOrgUnit.number"));
        sic.add(new SelectorItemInfo("requireOrgUnit.name"));
        sic.add(new SelectorItemInfo("issueOrgUnit.id"));
        sic.add(new SelectorItemInfo("issueOrgUnit.number"));
        sic.add(new SelectorItemInfo("issueOrgUnit.name"));
        sic.add(new SelectorItemInfo("wareHouse.id"));
        sic.add(new SelectorItemInfo("wareHouse.number"));
        sic.add(new SelectorItemInfo("wareHouse.name"));
        sic.add(new SelectorItemInfo("issueWareHouse.id"));
        sic.add(new SelectorItemInfo("issueWareHouse.number"));
        sic.add(new SelectorItemInfo("issueWareHouse.name"));
        return sic;
    }

    @Override
    protected void _save(Context ctx, Map data) throws BOSException, EASBizException {
        if (data == null || data.size() == 0) {
            return;
        }
        LinkedTreeMap cuMap = (LinkedTreeMap)data.get("cu");
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)cuMap.get((Object)"id").toString()));
        MaterialGroupStandardInfo mgsInfo = null;
        if (data.get("materialGroupStandard") != null) {
            mgsInfo = new MaterialGroupStandardInfo();
            mgsInfo.setId(BOSUuid.read((String)data.get("materialGroupStandard").toString()));
        }
        if (data.get("entry") != null && data.get("entry") instanceof ArrayList) {
            int i;
            ArrayList list = (ArrayList)data.get("entry");
            MaterialSupplyRelationInfo info = null;
            MaterialSupplyRelationCollection objColl = new MaterialSupplyRelationCollection();
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            int size = list.size();
            for (i = 0; i < size; ++i) {
                WarehouseInfo warehHouseInfo;
                LinkedTreeMap wareHouseMap;
                StorageOrgUnitInfo storageInfo;
                LinkedTreeMap storageMap;
                info = new MaterialSupplyRelationInfo();
                info.setCU(cu);
                info.setMaterialStandard(mgsInfo);
                info.setStatus(UseStatusEnum.SAVED);
                LinkedTreeMap entryMap = (LinkedTreeMap)list.get(i);
                if (!(entryMap.get((Object)"requireOrgUnit") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"requireOrgUnit").toString()) || entryMap.get((Object)"wareHouse") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"wareHouse").toString()) || entryMap.get((Object)"materialGroup") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"materialGroup").toString()) || entryMap.get((Object)"material") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"material").toString()) || entryMap.get((Object)"issueOrgUnit") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"issueOrgUnit").toString())) && (entryMap.get((Object)"issueWareHouse") == null || StringUtil.isEmpty((String)entryMap.get((Object)"issueWareHouse").toString()))) continue;
                if (entryMap.get((Object)"requireOrgUnit") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"requireOrgUnit").toString())) {
                    storageMap = (LinkedTreeMap)entryMap.get((Object)"requireOrgUnit");
                    storageInfo = new StorageOrgUnitInfo();
                    storageInfo.setId(BOSUuid.read((String)storageMap.get((Object)"id").toString()));
                    info.setRequireOrgUnit(storageInfo);
                } else {
                    info.setRequireOrgUnit(null);
                }
                if (entryMap.get((Object)"wareHouse") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"wareHouse").toString())) {
                    wareHouseMap = (LinkedTreeMap)entryMap.get((Object)"wareHouse");
                    warehHouseInfo = new WarehouseInfo();
                    warehHouseInfo.setId(BOSUuid.read((String)wareHouseMap.get((Object)"id").toString()));
                    info.setWareHouse(warehHouseInfo);
                } else {
                    info.setWareHouse(null);
                }
                if (entryMap.get((Object)"materialGroup") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"materialGroup").toString())) {
                    LinkedTreeMap mgMap = (LinkedTreeMap)entryMap.get((Object)"materialGroup");
                    MaterialGroupInfo mgInfo = new MaterialGroupInfo();
                    mgInfo.setId(BOSUuid.read((String)mgMap.get((Object)"id").toString()));
                    info.setMaterialGroup(mgInfo);
                } else {
                    info.setMaterialGroup(null);
                }
                if (entryMap.get((Object)"material") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"material").toString())) {
                    LinkedTreeMap materialMap = null;
                    if (entryMap.get((Object)"material") instanceof LinkedTreeMap) {
                        materialMap = (LinkedTreeMap)entryMap.get((Object)"material");
                    } else if (entryMap.get((Object)"material") instanceof ArrayList) {
                        ArrayList mlist = (ArrayList)entryMap.get((Object)"material");
                        materialMap = (LinkedTreeMap)mlist.get(0);
                    }
                    if (materialMap != null) {
                        MaterialInfo materialInfo = new MaterialInfo();
                        materialInfo.setId(BOSUuid.read((String)materialMap.get((Object)"id").toString()));
                        materialInfo.setName(materialMap.get((Object)"name").toString());
                        info.setMaterial(materialInfo);
                    }
                } else {
                    info.setMaterial(null);
                }
                if (entryMap.get((Object)"issueOrgUnit") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"issueOrgUnit").toString())) {
                    storageMap = (LinkedTreeMap)entryMap.get((Object)"issueOrgUnit");
                    storageInfo = new StorageOrgUnitInfo();
                    storageInfo.setId(BOSUuid.read((String)storageMap.get((Object)"id").toString()));
                    info.setIssueOrgUnit(storageInfo);
                } else {
                    info.setIssueOrgUnit(null);
                }
                if (entryMap.get((Object)"issueWareHouse") != null && !StringUtil.isEmpty((String)entryMap.get((Object)"issueWareHouse").toString())) {
                    wareHouseMap = (LinkedTreeMap)entryMap.get((Object)"issueWareHouse");
                    warehHouseInfo = new WarehouseInfo();
                    warehHouseInfo.setId(BOSUuid.read((String)wareHouseMap.get((Object)"id").toString()));
                    info.setIssueWareHouse(warehHouseInfo);
                } else {
                    info.setIssueWareHouse(null);
                }
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                info.setCreator(userInfo);
                info.setCreateTime(ts);
                objColl.add(info);
            }
            if (objColl != null && objColl.size() > 0) {
                String billId;
                if (objColl.size() == 1 && data.get("billId") != null && !StringUtil.isEmpty((String)(billId = data.get("billId").toString()))) {
                    objColl.get(0).setId(BOSUuid.read((String)billId));
                }
                size = objColl.size();
                for (i = 0; i < size; ++i) {
                    this._checkData(ctx, (IObjectValue)objColl.get(i));
                }
                super._saveBatchData(ctx, (IObjectCollection)objColl);
            }
        }
    }

    @Override
    protected Map _cuOnChange(Context ctx, String cid) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)cid)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isStorageOrgUnit"));
        sic.add(new SelectorItemInfo("isAdminOrgUnit"));
        CtrlUnitInfo cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cid), sic);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("msg_f7", this.getMaterialStandardF7(ctx, cu));
        map.put("materialGroup_f7", this.materialGroupFilter(cu));
        return map;
    }

    @Override
    protected void _active(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update T_IM_MaterialSupplyRelation set FStatus = 1 where FStatus in (0,2) ");
        sql.append(" and FID in ").append(SCMServerUtils.getInStringFromSet((Set)idSet));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _cancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update T_IM_MaterialSupplyRelation set FStatus = 2 where FStatus = 1 ");
        sql.append(" and FID in ").append(SCMServerUtils.getInStringFromSet((Set)idSet));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _checkData(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        IRowSet rs;
        if (info == null) {
            return;
        }
        MaterialSupplyRelationInfo billInfo = (MaterialSupplyRelationInfo)info;
        if (billInfo.getCU() == null || billInfo.getIssueOrgUnit() == null) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select 1 from T_IM_MaterialSupplyRelation where FControlUnitID = '").append(billInfo.getCU().getId().toString()).append("' \r\n");
        if (billInfo.getMaterialStandard() == null) {
            sql.append("and FMaterialStandardID is null \r\n");
        } else {
            sql.append("and FMaterialStandardID = '").append(billInfo.getMaterialStandard().getId().toString()).append("' \r\n");
        }
        if (billInfo.getRequireOrgUnit() == null) {
            sql.append("and FRequireOrgUnitID is null \r\n");
        } else {
            sql.append("and FRequireOrgUnitID ='").append(billInfo.getRequireOrgUnit().getId().toString()).append("' \r\n");
        }
        if (billInfo.getMaterialGroup() == null) {
            sql.append("and FMaterialGroupID is null \r\n");
        } else {
            sql.append("and FMaterialGroupID = '").append(billInfo.getMaterialGroup().getId().toString()).append("' \r\n");
        }
        if (billInfo.getMaterial() == null) {
            sql.append("and FMaterialID is null \r\n");
        } else {
            sql.append("and FMaterialID ='").append(billInfo.getMaterial().getId().toString()).append("' \r\n");
        }
        if (billInfo.getId() != null) {
            sql.append(" and FID <> '").append(billInfo.getId().toString()).append("'");
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).size() > 0) {
            throw new InvBizException(InvBizException.MATERIAL_SUPPLY_ERROR);
        }
    }

    @Override
    protected Object _getData(Context ctx, String request) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)request)) {
            return null;
        }
        JSONObject jo = null;
        HashSet<String> mset = new HashSet<String>();
        JSONObject jsonObj = JSONObject.fromObject((Object)request);
        JSONArray jsonEntryArray = jsonObj.getJSONArray("entry");
        String recOrgId = jsonObj.getString("recOrgUnitId");
        for (int i = 0; i < jsonEntryArray.size(); ++i) {
            jo = (JSONObject)jsonEntryArray.get(i);
            String materialId = jo.getString("materialId");
            mset.add(materialId);
        }
        return this.matchData(ctx, mset, recOrgId);
    }

    private Set<String> getLongNumberByRecOrg(Context ctx, StorageOrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        if (orgUnitInfo == null || StringUtil.isEmpty((String)orgUnitInfo.getLongNumber())) {
            return null;
        }
        String[] numStr = orgUnitInfo.getLongNumber().split("!");
        HashSet<String> orgNumSet = new HashSet<String>();
        int size = numStr.length;
        for (int i = 0; i < size; ++i) {
            orgNumSet.add(numStr[i]);
        }
        return orgNumSet;
    }

    private StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String orgId) throws EASBizException, BOSException {
        if (StringUtil.isEmpty((String)orgId)) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("CU.name"));
        selector.add(new SelectorItemInfo("CU.number"));
        return StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), selector);
    }

    private Map<String, Map<String, Object>> matchData(Context ctx, Set<String> mset, String orgId) throws EASBizException, BOSException {
        if (mset == null || mset.size() == 0 || StringUtil.isEmpty((String)orgId)) {
            return null;
        }
        StorageOrgUnitInfo orgUnitInfo = this.getStorageOrgUnit(ctx, orgId);
        Set<String> orgNumberSet = this.getLongNumberByRecOrg(ctx, orgUnitInfo);
        if (orgNumberSet == null || orgNumberSet.size() == 0) {
            return null;
        }
        Map<String, List<ResultTo>> map = this.insertDataToList(ctx, mset, orgNumberSet, orgUnitInfo);
        Map<String, Map<String, Object>> finalMap = this.getFinalData(ctx, map, orgNumberSet);
        String key = "";
        Iterator<String> it = mset.iterator();
        while (it.hasNext()) {
            key = it.next().toString();
            if (finalMap == null || finalMap.size() == 0) {
                finalMap = new HashMap<String, Map<String, Object>>();
            }
            if (finalMap.containsKey(key)) continue;
            finalMap.put(key, null);
        }
        return finalMap;
    }

    private Map<String, Map<String, Object>> getFinalData(Context ctx, Map<String, List<ResultTo>> map, Set<String> orgNumberSet) throws BOSException {
        if (map == null || map.size() == 0 || orgNumberSet == null || orgNumberSet.size() == 0) {
            return null;
        }
        List<ResultTo> list = null;
        ResultTo defaultInfo = null;
        String materialId = "";
        Map<String, ResultTo> resultMap = null;
        HashMap<String, Map<String, Object>> finalMap = new HashMap<String, Map<String, Object>>();
        Iterator<String> iterator = map.keySet().iterator();
        Map<String, String> orgIdsMap = this.getIssueOrgIds(map);
        Object[] orgNums = orgNumberSet.toArray();
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> whIds = new HashSet<String>();
        while (iterator.hasNext()) {
            materialId = iterator.next().toString();
            list = map.get(materialId);
            defaultInfo = this.groupGetDataByType(list, orgNums);
            resultMap = new HashMap<String, String>();
            if (orgIdsMap.containsKey(materialId)) {
                resultMap.put("f7_filter", (ResultTo)((Object)orgIdsMap.get(materialId)));
            }
            if (!StringUtil.isEmpty((String)defaultInfo.issueOrgID)) {
                orgIds.add(defaultInfo.issueOrgID);
            }
            if (!StringUtil.isEmpty((String)defaultInfo.wareHouseID)) {
                whIds.add(defaultInfo.wareHouseID);
            }
            if (!StringUtil.isEmpty((String)defaultInfo.issueWareHouseID)) {
                whIds.add(defaultInfo.issueWareHouseID);
            }
            orgIds.add(defaultInfo.issueOrgID);
            resultMap.put("defaultInfo", defaultInfo);
            finalMap.put(materialId, resultMap);
        }
        if (finalMap.size() > 0) {
            Map<String, WarehouseInfo> wareHouseMap = this.getWareHouseInfos(ctx, whIds);
            Map<String, StorageOrgUnitInfo> orgMap = this.getStorageOrgUnitInfos(ctx, orgIds);
            Iterator it = finalMap.keySet().iterator();
            while (it.hasNext()) {
                materialId = it.next().toString();
                if (!finalMap.containsKey(materialId) || !(resultMap = (Map)finalMap.get(materialId)).containsKey("defaultInfo") || resultMap.get("defaultInfo") == null) continue;
                defaultInfo = (ResultTo)resultMap.get("defaultInfo");
                if (!StringUtil.isEmpty((String)defaultInfo.wareHouseID) && wareHouseMap != null && wareHouseMap.containsKey(defaultInfo.wareHouseID)) {
                    resultMap.put("wareHouse", (ResultTo)wareHouseMap.get(defaultInfo.wareHouseID));
                }
                if (!StringUtil.isEmpty((String)defaultInfo.issueWareHouseID) && wareHouseMap != null && wareHouseMap.containsKey(defaultInfo.issueWareHouseID)) {
                    resultMap.put("issueWareHouse", (ResultTo)wareHouseMap.get(defaultInfo.issueWareHouseID));
                }
                if (StringUtil.isEmpty((String)defaultInfo.issueOrgID) || orgMap == null || !orgMap.containsKey(defaultInfo.issueOrgID)) continue;
                resultMap.put("issueOrgUnit", (ResultTo)orgMap.get(defaultInfo.issueOrgID));
            }
        }
        return finalMap;
    }

    private Map<String, WarehouseInfo> getWareHouseInfos(Context ctx, Set<String> ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        EntityViewInfo view = this.getEntityViewInfo(ids);
        if (view == null) {
            return null;
        }
        WarehouseCollection coll = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(view);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        WarehouseInfo info = null;
        HashMap<String, WarehouseInfo> map = new HashMap<String, WarehouseInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            map.put(info.getId().toString(), info);
        }
        return map;
    }

    private Map<String, StorageOrgUnitInfo> getStorageOrgUnitInfos(Context ctx, Set<String> ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        EntityViewInfo view = this.getEntityViewInfo(ids);
        if (view == null) {
            return null;
        }
        StorageOrgUnitCollection coll = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        StorageOrgUnitInfo info = null;
        HashMap<String, StorageOrgUnitInfo> map = new HashMap<String, StorageOrgUnitInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            map.put(info.getId().toString(), info);
        }
        return map;
    }

    private EntityViewInfo getEntityViewInfo(Set<String> ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        return view;
    }

    private ResultTo groupGetDataByType(List<ResultTo> list, Object[] orgNums) {
        int j;
        if (list == null || list.size() == 0 || orgNums == null || orgNums.length == 0) {
            return null;
        }
        ResultTo info = null;
        ResultTo defaultInfo = null;
        int len = orgNums.length;
        block0: for (j = 0; j < len && defaultInfo == null; ++j) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                info = list.get(i);
                if (info.type != 1) continue;
                if (orgNums[j].toString().equals(info.orgNumber)) {
                    defaultInfo = info;
                }
                if (defaultInfo != null) continue block0;
            }
        }
        if (defaultInfo != null) {
            return defaultInfo;
        }
        for (j = 0; j < len && defaultInfo == null; ++j) {
            String materialLongNum = "";
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                info = list.get(i);
                if (info.type != 2) continue;
                materialLongNum = info.longNumber;
                break;
            }
            if (StringUtil.isEmpty((String)materialLongNum)) break;
            String[] mnums = materialLongNum.split("!");
            block4: for (int n = mnums.length - 1; n >= 0; --n) {
                int size2 = list.size();
                for (int i = 0; i < size2; ++i) {
                    info = list.get(i);
                    if (info.type != 2) continue;
                    if (orgNums[j].toString().equals(info.orgNumber) && mnums[n].equals(info.groupNum1)) {
                        defaultInfo = info;
                    }
                    if (defaultInfo != null) continue block4;
                }
            }
        }
        if (defaultInfo != null) {
            return defaultInfo;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            info = list.get(i);
            if (info.type != 3) continue;
            defaultInfo = info;
            break;
        }
        if (defaultInfo != null) {
            return defaultInfo;
        }
        String materialLongNum = "";
        int size3 = list.size();
        for (int i = 0; i < size3; ++i) {
            info = list.get(i);
            if (info.type != 4) continue;
            materialLongNum = info.longNumber;
            break;
        }
        if (!StringUtil.isEmpty((String)materialLongNum)) {
            String[] mnums = materialLongNum.split("!");
            block8: for (int n = mnums.length - 1; n >= 0; --n) {
                int size4 = list.size();
                for (int i = 0; i < size4; ++i) {
                    info = list.get(i);
                    if (info.type != 4) continue;
                    if (mnums[n].equals(info.groupNum1)) {
                        defaultInfo = info;
                    }
                    if (defaultInfo != null) continue block8;
                }
            }
        }
        if (defaultInfo != null) {
            return defaultInfo;
        }
        size3 = list.size();
        for (int i = 0; i < size3; ++i) {
            info = list.get(i);
            if (info.type != 5) continue;
            defaultInfo = info;
            break;
        }
        if (defaultInfo != null) {
            return defaultInfo;
        }
        return defaultInfo;
    }

    private Map<String, String> getIssueOrgIds(Map<String, List<ResultTo>> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        List<ResultTo> list = null;
        ResultTo info = null;
        String materialId = "";
        HashMap<String, String> orgIdsMap = new HashMap<String, String>();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            materialId = iterator.next().toString();
            list = map.get(materialId);
            HashSet<String> issueOrgSet = new HashSet<String>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                info = list.get(i);
                issueOrgSet.add(info.issueOrgID);
            }
            if (issueOrgSet.size() <= 0) continue;
            Iterator it = issueOrgSet.iterator();
            StringBuilder ids = new StringBuilder();
            while (it.hasNext()) {
                ids.append("'").append(it.next().toString()).append("',");
            }
            orgIdsMap.put(materialId, ids.substring(0, ids.length() - 1));
        }
        return orgIdsMap;
    }

    private Map<String, List<ResultTo>> insertDataToList(Context ctx, Set<String> mset, Set<String> orgNumberSet, StorageOrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        if (mset == null || mset.size() == 0 || orgNumberSet == null || orgNumberSet.size() == 0) {
            return null;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.getQuerySql(mset, orgNumberSet, orgUnitInfo));
        if (rs == null || rs.size() == 0) {
            return null;
        }
        try {
            HashMap<String, List<ResultTo>> map = new HashMap<String, List<ResultTo>>();
            List list = null;
            ResultTo info = null;
            String materialId = "";
            int type = 1;
            while (rs.next()) {
                info = new ResultTo();
                type = rs.getInt("FType");
                if (type == 5) {
                    Object[] arr = mset.toArray();
                    int size = arr.length;
                    for (int i = 0; i < size; ++i) {
                        materialId = arr[i].toString();
                        list = map.containsKey(materialId) ? (List)map.get(materialId) : new ArrayList();
                        info = this.buildResultTo(materialId, rs);
                        list.add(info);
                        map.put(materialId, list);
                    }
                    continue;
                }
                materialId = rs.getString("FMaterialID");
                list = map.containsKey(materialId) ? (List)map.get(materialId) : new ArrayList();
                info = this.buildResultTo(materialId, rs);
                list.add(info);
                map.put(materialId, list);
            }
            return map;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private ResultTo buildResultTo(String materialId, IRowSet rs) throws SQLException {
        ResultTo info = new ResultTo();
        info.materialID = materialId;
        info.requireOrgID = rs.getString("FRequireOrgUnitID");
        info.wareHouseID = rs.getString("FWareHouseID");
        info.issueOrgID = rs.getString("FIssueOrgUnitID");
        info.issueWareHouseID = rs.getString("FIssueWareHouseID");
        info.orgNumber = rs.getString("FStorageOrgNum");
        info.type = rs.getInt("FType");
        info.groupNum = rs.getString("FMaterialGroupNum");
        info.groupNum1 = rs.getString("FMaterialGroupNum1");
        info.longNumber = rs.getString("FLongNumber");
        return info;
    }

    private String getQuerySql(Set<String> mset, Set<String> orgNumberSet, StorageOrgUnitInfo orgUnitInfo) {
        String whereSql = this.getWhereSql(orgUnitInfo);
        String selectSql = this.getSelectSql();
        String groupBySql = this.getGroupBySql();
        StringBuilder sql = new StringBuilder();
        sql.append("select T.* from ( \n");
        sql.append(selectSql);
        sql.append(",1 as FType,s.FNumber as FStorageOrgNum  ,100 as flevel from T_IM_MaterialSupplyRelation msr \n");
        sql.append("inner join T_BD_Material material on material.fid = msr.FMaterialID \n");
        sql.append("inner join T_ORG_Storage s on msr.FRequireOrgUnitID = s.FID \n");
        sql.append("where msr.FMaterialID in ").append(SCMServerUtils.getInStringFromSet(mset)).append(" \n");
        sql.append("and s.FNumber in ").append(SCMServerUtils.getInStringFromSet(orgNumberSet)).append(" \n");
        sql.append(whereSql);
        sql.append(groupBySql);
        sql.append(",s.FNumber \n");
        sql.append(" union all \n");
        sql.append("select msr.FID,msr.FMaterialStandardID,msr.FMaterialGroupID,material.fid as FMaterialID,\n");
        sql.append("msr.FRequireOrgUnitID,msr.FWareHouseID,msr.FIssueOrgUnitID,msr.FIssueWareHouseID,\n");
        sql.append("mg1.fnumber as FMaterialGroupNum,mGroup.FNUMBER as FMaterialGroupNum1,mg1.FLONGNUMBER as FLongNumber \n");
        sql.append(",2 as FType,s.FNumber as FStorageOrgNum ,s1.flevel as flevel from T_IM_MaterialSupplyRelation msr \n");
        sql.append("inner join T_BD_MaterialGroupDetial gDetail on gDetail.FMaterialGroupStandardID = msr.FMaterialStandardID \n");
        sql.append("inner join T_BD_Material material on material.fid = gDetail.FMaterialID \n");
        sql.append("inner join T_BD_MaterialGroup mGroup on msr.FMaterialGroupID = mGroup.FID \n");
        sql.append("inner join T_BD_MaterialGroup mg1 on mg1.fid = gDetail.FMaterialGroupID and CharIndex(mGroup.FLongNumber,mg1.FLongNumber)>0 \n");
        sql.append("inner join T_ORG_Storage s on msr.FRequireOrgUnitID = s.FID \n");
        sql.append("inner join  T_ORG_Storage s1 on msr.FIssueOrgUnitID = s1.fid \n");
        sql.append("where material.fid in ").append(SCMServerUtils.getInStringFromSet(mset)).append(" \n");
        sql.append("and s.FNumber in ").append(SCMServerUtils.getInStringFromSet(orgNumberSet)).append(" \n");
        sql.append("and msr.FMaterialID is null \n");
        sql.append(whereSql);
        sql.append(" group by msr.FID,msr.FMaterialStandardID,msr.FMaterialGroupID,material.fid,\n");
        sql.append("msr.FRequireOrgUnitID,msr.FWareHouseID,msr.FIssueOrgUnitID,msr.FIssueWareHouseID \n");
        sql.append(",mg1.fnumber,mGroup.FNUMBER,mg1.FLONGNUMBER,s.FNumber,s1.flevel \n");
        sql.append(" union all \n");
        sql.append(selectSql);
        sql.append(",3 as FType,null as FStorageOrgNum ,100 as flevel  from T_IM_MaterialSupplyRelation msr \n");
        sql.append("inner join T_BD_Material material on material.fid = msr.FMaterialID \n");
        sql.append("where msr.FMaterialID in ").append(SCMServerUtils.getInStringFromSet(mset)).append(" \n");
        sql.append("and msr.FRequireOrgUnitID is null \n");
        sql.append(whereSql);
        sql.append(groupBySql);
        sql.append(" \n union all \n");
        sql.append("select msr.FID,msr.FMaterialStandardID,msr.FMaterialGroupID,material.fid as FMaterialID,\n");
        sql.append("msr.FRequireOrgUnitID,msr.FWareHouseID,msr.FIssueOrgUnitID,msr.FIssueWareHouseID,\n");
        sql.append("mg1.fnumber as FMaterialGroupNum,mGroup.FNUMBER as FMaterialGroupNum1,mg1.FLONGNUMBER as FLongNumber \n");
        sql.append(",4 as FType,null as FStorageOrgNum ,100 as flevel from T_IM_MaterialSupplyRelation msr \n");
        sql.append("inner join T_BD_MaterialGroupDetial gDetail on gDetail.FMaterialGroupStandardID = msr.FMaterialStandardID \n");
        sql.append("inner join T_BD_Material material on material.fid = gDetail.FMaterialID \n");
        sql.append("inner join T_BD_MaterialGroup mGroup on mGroup.fid = msr.FMaterialGroupID \n");
        sql.append("inner join T_BD_MaterialGroup mg1 on mg1.fid = gDetail.FMaterialGroupID and CharIndex(mGroup.FLongNumber,mg1.FLongNumber)>0 \n");
        sql.append("where material.fid in ").append(SCMServerUtils.getInStringFromSet(mset)).append(" \n");
        sql.append("and msr.FRequireOrgUnitID is null and msr.FMaterialID is null \n");
        sql.append(whereSql);
        sql.append(" group by msr.FID,msr.FMaterialStandardID,msr.FMaterialGroupID,material.fid,\n");
        sql.append("msr.FRequireOrgUnitID,msr.FWareHouseID,msr.FIssueOrgUnitID,msr.FIssueWareHouseID \n");
        sql.append(",mg1.fnumber,mGroup.FNUMBER,mg1.FLONGNUMBER \n");
        sql.append(" union all \n");
        sql.append(selectSql);
        sql.append(",5 as FType,null as FStorageOrgNum ,100 as flevel from T_IM_MaterialSupplyRelation msr \n");
        sql.append("where msr.FMaterialID is null and msr.FRequireOrgUnitID is null and msr.FMaterialGroupID is null \n");
        sql.append(whereSql);
        sql.append(groupBySql);
        sql.append(") T order by T.FType,T.flevel asc");
        return sql.toString();
    }

    private String getSelectSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("select msr.FID,msr.FMaterialStandardID,msr.FMaterialGroupID,msr.FMaterialID,\n");
        sql.append("msr.FRequireOrgUnitID,msr.FWareHouseID,msr.FIssueOrgUnitID,msr.FIssueWareHouseID,\n");
        sql.append("null as FMaterialGroupNum,null as FMaterialGroupNum1,null as FLongNumber \n");
        return sql.toString();
    }

    private String getWhereSql(StorageOrgUnitInfo orgUnitInfo) {
        StringBuilder sql = new StringBuilder();
        sql.append(" and msr.FStatus = 1 ");
        if (orgUnitInfo != null) {
            sql.append("and msr.FControlUnitID = '").append(orgUnitInfo.getCU().getId().toString()).append("'");
        }
        return sql.toString();
    }

    private String getGroupBySql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" group by msr.FID,msr.FMaterialStandardID,msr.FMaterialGroupID,msr.FMaterialID,\n");
        sql.append("msr.FRequireOrgUnitID,msr.FWareHouseID,msr.FIssueOrgUnitID,msr.FIssueWareHouseID \n");
        return sql.toString();
    }

    @Override
    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getInitData(Context ctx, IObjectValue object, String oprt) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _dealDataChange(Context ctx, Map param) throws BOSException, EASBizException {
        return null;
    }

    static class ResultTo {
        public String materialID;
        public String requireOrgID;
        public String wareHouseID;
        public String issueOrgID;
        public String issueWareHouseID;
        public String orgNumber;
        public String groupNum;
        public String groupNum1;
        public String longNumber;
        public int type;

        ResultTo() {
        }
    }
}

