/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHCollection;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.im.inv.MaterialSupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.MaterialSupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class MaterialSupplyRelationImport
extends AbstractDataTransmission {
    private static String RESOURCE = "com.kingdee.eas.scm.im.inv.MaterialSupplyRelationImportResource";
    private MaterialSupplyRelationInfo billInfo = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialSupplyRelationFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FCU_number", rs.getString("CU.number"));
            this.putTable(result, "FCU_name_l2", rs.getString("CU.name"));
            this.putTable(result, "FRequireOrgUnit_number", rs.getString("requireOrgUnit.number"));
            this.putTable(result, "FRequireOrgUnit_name_l2", rs.getString("requireOrgUnit.name"));
            this.putTable(result, "FWareHouse_number", rs.getString("wareHouse.number"));
            this.putTable(result, "FWareHouse_name_l2", rs.getString("wareHouse.name"));
            this.putTable(result, "FMaterialStandard_number", rs.getString("materialStandard.number"));
            this.putTable(result, "FMaterialStandard_name_l2", rs.getString("materialStandard.name"));
            this.putTable(result, "FMaterialGroup_number", rs.getString("materialGroup.number"));
            this.putTable(result, "FMaterialGroup_name_l2", rs.getString("materialGroup.name"));
            this.putTable(result, "FMaterial_number", rs.getString("material.number"));
            this.putTable(result, "FMaterial_name_l2", rs.getString("material.name"));
            this.putTable(result, "FIssueOrgUnit_number", rs.getString("issueOrgUnit.number"));
            this.putTable(result, "FIssueOrgUnit_name_l2", rs.getString("issueOrgUnit.name"));
            this.putTable(result, "FIssueWareHouse_number", rs.getString("issueWareHouse.number"));
            this.putTable(result, "FIssueWareHouse_name_l2", rs.getString("issueWareHouse.name"));
            this.putTable(result, "FStatus", rs.getString("status"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof MaterialSupplyRelationInfo)) {
            return;
        }
        try {
            this.getController(ctx).addnew(coreBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            this.billInfo = new MaterialSupplyRelationInfo();
            this.doCtrlUnit(ctx, hsData);
            this.doStorageOrgUnit(ctx, hsData);
            this.doWareHouse(ctx, hsData);
            this.doMaterialGroupStandard(ctx, hsData);
            this.doMaterialGroup(ctx, hsData);
            this.doMaterial(ctx, hsData);
            this.doIssueOrgUnit(ctx, hsData);
            this.doIssueWareHouse(ctx, hsData);
            this.billInfo.setStatus(UseStatusEnum.SAVED);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            this.billInfo.setCreator(userInfo);
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            this.billInfo.setCreateTime(ts);
            MaterialSupplyRelationFactory.getLocalInstance(ctx).checkData((IObjectValue)this.billInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return this.billInfo;
    }

    private void doCtrlUnit(Context ctx, Hashtable hsData) throws TaskExternalException, BOSException, EASBizException {
        CtrlUnitCollection coll;
        Object data = ((DataToken)hsData.get((Object)"FCU_number")).data;
        if (data != null && data.toString().length() > 0) {
            String number = data.toString();
            coll = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(this.getFilter(number, new String[]{"longNumber"}));
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "CU__NOT_EXISTS", number));
            }
        } else {
            throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "CU_NULL"));
        }
        this.billInfo.setCU(coll.get(0));
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), OrgType.ControlUnit, (IObjectPK)new ObjectUuidPK(this.billInfo.getCU().getId()), "materialSupply_import");
    }

    private void doStorageOrgUnit(Context ctx, Hashtable hsData) throws TaskExternalException, BOSException {
        Object data = ((DataToken)hsData.get((Object)"FRequireOrgUnit_number")).data;
        if (data != null && data.toString().length() > 0) {
            String number = data.toString();
            StorageOrgUnitCollection coll = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(this.getFilter(number, new String[]{"CU.id"}));
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "REQUIREORG_NOT_EXISTS", number));
            }
            StorageOrgUnitInfo orgInfo = coll.get(0);
            this.billInfo.setRequireOrgUnit(orgInfo);
            if (this.billInfo.getCU() != null && orgInfo.getCU() != null && !this.billInfo.getCU().getId().toString().equals(orgInfo.getCU().getId().toString())) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "REQUIREORG_CHECK_ERROR", number));
            }
        }
    }

    private void doIssueOrgUnit(Context ctx, Hashtable hsData) throws TaskExternalException, BOSException {
        StorageOrgUnitCollection coll;
        Object data = ((DataToken)hsData.get((Object)"FIssueOrgUnit_number")).data;
        if (data != null && data.toString().length() > 0) {
            String number = data.toString();
            coll = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(this.getFilter(number, new String[]{"CU.id"}));
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "ISSUEORG_NOT_EXISTS", number));
            }
        } else {
            throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "ISSUEORG_NULL"));
        }
        StorageOrgUnitInfo orgInfo = coll.get(0);
        this.billInfo.setIssueOrgUnit(orgInfo);
    }

    private void doWareHouse(Context ctx, Hashtable hsData) throws TaskExternalException, BOSException {
        Object data = ((DataToken)hsData.get((Object)"FWareHouse_number")).data;
        if (data != null && data.toString().length() > 0) {
            String number = data.toString();
            if (this.billInfo.getRequireOrgUnit() == null) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "WAREHOUSE_CHECK_ERROR_1"));
            }
            WarehouseCollection coll = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(this.getFilter(number, null));
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "WAREHOUSE_NOT_EXISTS", number));
            }
            WarehouseInfo wareHouseInfo = coll.get(0);
            this.billInfo.setWareHouse(wareHouseInfo);
            if (!this.checkSOAccreditWH(ctx, this.billInfo.getRequireOrgUnit().getId().toString(), wareHouseInfo.getId().toString())) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "WAREHOUSE_CHECK_ERROR", number));
            }
        }
    }

    private void doIssueWareHouse(Context ctx, Hashtable hsData) throws TaskExternalException, BOSException {
        Object data = ((DataToken)hsData.get((Object)"FIssueWareHouse_number")).data;
        if (data != null && data.toString().length() > 0) {
            String number = data.toString();
            if (this.billInfo.getIssueOrgUnit() == null) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "ISSUEWAREHOUSE_CHECK_ERROR_1"));
            }
            WarehouseCollection coll = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(this.getFilter(number, null));
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "ISSUEWAREHOUSE_NOT_EXISTS", number));
            }
            WarehouseInfo wareHouseInfo = coll.get(0);
            this.billInfo.setIssueWareHouse(wareHouseInfo);
            if (!this.checkSOAccreditWH(ctx, this.billInfo.getIssueOrgUnit().getId().toString(), wareHouseInfo.getId().toString())) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "ISSUEWAREHOUSE_CHECK_ERROR", number));
            }
        }
    }

    private void doMaterialGroupStandard(Context ctx, Hashtable hsData) throws TaskExternalException, BOSException {
        Object data = ((DataToken)hsData.get((Object)"FMaterialStandard_number")).data;
        if (data != null && data.toString().length() > 0) {
            String number = data.toString();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.billInfo.getCU().getId().toString(), (String)this.billInfo.getCU().getLongNumber());
            EntityViewInfo view = new EntityViewInfo();
            FilterItemInfo itemInfo = new FilterItemInfo("number", (Object)number);
            filterInfoCU.getFilterItems().add(itemInfo);
            if (filterInfoCU.getFilterItems().size() > 1) {
                filterInfoCU.setMaskString("(#0 or #1) and #2");
            } else {
                filterInfoCU.setMaskString("#0 and #1");
            }
            view.setFilter(filterInfoCU);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            view.setSelector(sic);
            MaterialGroupStandardCollection coll = MaterialGroupStandardFactory.getLocalInstance((Context)ctx).getMaterialGroupStandardCollection(view);
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "GROUPSTANDARD_CHECK_ERROR", number));
            }
            this.billInfo.setMaterialStandard(coll.get(0));
        }
    }

    private void doMaterialGroup(Context ctx, Hashtable hsData) throws TaskExternalException, BOSException {
        Object data = ((DataToken)hsData.get((Object)"FMaterialGroup_number")).data;
        if (data != null && data.toString().length() > 0) {
            String number = data.toString();
            if (this.billInfo.getMaterialStandard() == null) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "GROUPSTANDARD_CHECK_ERROR_1"));
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)this.billInfo.getMaterialStandard().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            view.setSelector(sic);
            MaterialGroupCollection coll = MaterialGroupFactory.getLocalInstance((Context)ctx).getMaterialGroupCollection(view);
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "MATERIALGROUP_CHECK_ERROR", number));
            }
            this.billInfo.setMaterialGroup(coll.get(0));
        }
    }

    private void doMaterial(Context ctx, Hashtable hsData) throws TaskExternalException, BOSException {
        Object data = ((DataToken)hsData.get((Object)"FMaterial_number")).data;
        if (data != null && data.toString().length() > 0) {
            String number = data.toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            view.setSelector(sic);
            MaterialCollection coll = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(MaterialSupplyRelationImport.getResource(ctx, "MATERIAL_CHECK_ERROR", number));
            }
            this.billInfo.setMaterial(coll.get(0));
        }
    }

    private boolean checkSOAccreditWH(Context ctx, String orgId, String wareHouseId) throws BOSException {
        if (StringUtil.isEmpty((String)orgId) || StringUtil.isEmpty((String)wareHouseId)) {
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("warehouse", (Object)wareHouseId));
        filter.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)orgId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("warehouse"));
        sic.add(new SelectorItemInfo("storageOrg"));
        view.setSelector(sic);
        SOAccreditWHCollection whColl = SOAccreditWHFactory.getLocalInstance((Context)ctx).getSOAccreditWHCollection(view);
        return whColl != null && whColl.size() != 0;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo oldFilterInfo;
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.ControlUnit, "materialSupply_export");
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            HashSet<String> keys = new HashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", keys, CompareType.INCLUDE));
        }
        if ((oldFilterInfo = (FilterInfo)this.getContextParameter("filter")) == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return oldFilterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.MaterialSupplyRelationQuery";
    }

    private EntityViewInfo getFilter(String number, String[] selectorItems) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        if (selectorItems != null && selectorItems.length > 0) {
            int size = selectorItems.length;
            for (int i = 0; i < size; ++i) {
                sic.add(new SelectorItemInfo(selectorItems[i]));
            }
        }
        viewInfo.setSelector(sic);
        return viewInfo;
    }

    private static String getResource(Context ctx, String strKey, String number) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return ResourceBase.getString((String)RESOURCE, (String)strKey, (Locale)ctx.getLocale(), (Object[])new Object[]{number});
    }

    private static String getResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return ResourceBase.getString((String)RESOURCE, (String)strKey, (Locale)ctx.getLocale());
    }
}

