/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.BillRelationOptionEnum;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.AbstractPurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.AbstractPurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.AbstractSaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.AbstractSaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.ISysBillFacade;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.RelationOfChildAndParentFacadeFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.SplitBillException;
import com.kingdee.eas.scm.im.inv.SysBillFacadeFactory;
import com.kingdee.eas.scm.im.inv.app.AbstractMergeSplitedBillFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.PurInAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.app.SaleIssueAlgorithmForInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MergeSplitedBillFacadeControllerBean
extends AbstractMergeSplitedBillFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MergeSplitedBillFacadeControllerBean");
    private static Map<String, List<FieldInfo>> fieldListMap = new HashMap<String, List<FieldInfo>>();
    private static final String RES = "com.kingdee.eas.scm.im.inv.MergeSplitedResource";
    public HashMap<String, String> relationsMap = new HashMap();
    public HashMap checkMap = new HashMap();
    private static final String MERGESPLITEDRESOURCE = "com.kingdee.eas.scm.im.inv.MergeSplitedResource";

    private String getFieldJson(String bosType) {
        boolean isPurin = SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType);
        boolean isSaleIssue = SCMConstant.BOSTYPE_SALEISSUE.equals(bosType);
        StringBuffer fieldSb = new StringBuffer();
        fieldSb.append("[");
        fieldSb.append("{name:FNUMBER,dataType:nvarchar(80),width:320,isHide:false,resKey:billNo},");
        fieldSb.append("{name:FSTATUS,dataType:int,width:100,isHide:false,resKey:billStatus},");
        fieldSb.append("{name:FBIZTYPE,dataType:nvarchar(255),width:100,isHide:false,resKey:bizType},");
        fieldSb.append("{name:FBIZDATE,dataType:datetime,width:100,isHide:false,format:yyyy-MM-dd,resKey:bizDate},");
        fieldSb.append("{name:FSTORAGEORGNAME,dataType:nvarchar(255),width:100,isHide:false,resKey:storageOrgUnit},");
        if (isSaleIssue) {
            fieldSb.append("{name:FCUSTOMERNAME,dataType:nvarchar(255),width:100,isHide:false,resKey:Customer},");
        }
        if (isPurin) {
            fieldSb.append("{name:FSUPPLIERNAME,dataType:nvarchar(255),width:100,isHide:false,resKey:Supplier},");
        }
        fieldSb.append("{name:FINTAX,dataType:int,width:100,isHide:false,resKey:intax},");
        fieldSb.append("{name:FVOUCHER,dataType:nvarchar(80),width:100,isHide:false,resKey:voucher},");
        if (isSaleIssue) {
            fieldSb.append("{name:FISGENBIZAR,dataType:int,width:100,isHide:false,resKey:genbizAr},");
        }
        if (isPurin) {
            fieldSb.append("{name:FISGENBIZAP,dataType:int,width:100,isHide:false,resKey:genbizAp},");
        }
        fieldSb.append("{name:FCANTMERGERESON,dataType:nvarchar(255),width:200,isHide:false,resKey:cantMergeReson},");
        fieldSb.append("{name:FISUNAUDIT,dataType:int,width:-1,isHide:true},");
        fieldSb.append("{name:FID,dataType:varchar(44),width:-1,isHide:true},");
        fieldSb.append("{name:FPARENTID,dataType:varchar(44),width:-1,isHide:true},");
        fieldSb.append("{name:FLEVEL,dataType:int,width:-1,isHide:true},");
        fieldSb.append("{name:FISLEAF,dataType:int,width:-1,isHide:true}");
        fieldSb.append("]");
        return fieldSb.toString();
    }

    private void initFieldInfoList(Context ctx, String bosType) throws BOSException {
        FieldInfo[] fieldArr = new FieldInfo[]{};
        FieldInfo[] convertJsonToObject = (FieldInfo[])JSONUtils.convertJsonToObject((Context)ctx, (String)this.getFieldJson(bosType), fieldArr.getClass());
        List<FieldInfo> fieldList = Arrays.asList(convertJsonToObject);
        fieldListMap.put(bosType, fieldList);
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String bosType = params.getString("BOSType");
        this.initFieldInfoList(ctx, bosType);
        List<FieldInfo> fieldList = fieldListMap.get(bosType);
        String tempTable = params.getString("tempTable");
        if (!StringUtils.isEmpty((String)tempTable)) {
            this.dropTempTable(tempTable, ctx);
        }
        tempTable = this.buildTempTable(ctx, fieldList);
        params.setString("tempTable", tempTable);
        this.buildTempTableData(ctx, params);
        String countSql = "SELECT COUNT(1) FCOUNT FROM " + tempTable + " WHERE FLEVEL = 1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)countSql);
        int count = 0;
        try {
            if (rs.next()) {
                count = rs.getInt("FCOUNT");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.handleLock(ctx, tempTable);
        RptTableHeader reportHeader = this.getReportHeader(ctx, fieldList);
        RptParams result = new RptParams();
        result.setObject("header", (Object)reportHeader);
        result.setString("tempTable", tempTable);
        result.setInt("totalCount", count);
        return result;
    }

    private void buildTempTableData(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        String bosType = params.getString("BOSType");
        String rootID = params.getString("rootBillId");
        this.insertBillData(ctx, tempTable, bosType, rootID);
        this.updateCantMergeReson(ctx, params);
        this.levelTempData(ctx, tempTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertBillData(Context ctx, String tempTable, String bosType, String rootID) throws BOSException {
        String loc = this.getLoc(ctx);
        String billTable = this.getBillTable(bosType);
        List<FieldInfo> fieldList = fieldListMap.get(bosType);
        StringBuffer sql = new StringBuffer(100);
        String idTemp = this.buildIdTempData(ctx, rootID);
        try {
            sql.append(" INSERT INTO ").append(tempTable);
            sql.append(" (").append(this.getFieldSql(fieldList)).append(")");
            sql.append(" SELECT RCP.FNUMBER ,BILL.FBASESTATUS ,");
            sql.append("BZTP.FNAME_").append(loc).append(",BILL.FBIZDATE, \n");
            sql.append(" SORG.FNAME_").append(loc).append(",");
            if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType)) {
                sql.append("SPL.FNAME_").append(loc);
            }
            if (SCMConstant.BOSTYPE_SALEISSUE.equals(bosType)) {
                sql.append("CUM.FNAME_").append(loc);
            }
            sql.append(" ,BILL.FISINTAX,VOUC.FNUMBER,");
            if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType)) {
                sql.append("BILL.FISGENBIZAP,");
            }
            if (SCMConstant.BOSTYPE_SALEISSUE.equals(bosType)) {
                sql.append("BILL.FISGENBIZAR,");
            }
            sql.append(" ' ',RCP.FISUNAUDIT,RCP.FID,RCP.FPARENTID,0,0");
            sql.append(" FROM ").append(idTemp).append("  RCP \n");
            sql.append(" LEFT JOIN ").append(billTable).append("  BILL ON RCP.FID = BILL.FID \n");
            sql.append(" LEFT JOIN T_SCM_BIZTYPE  BZTP ON BILL.FBIZTYPEID = BZTP.FID \n");
            sql.append(" LEFT JOIN T_ORG_STORAGE SORG ON BILL.FSTORAGEORGUNITID =SORG.FID \n");
            if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType)) {
                sql.append(" LEFT JOIN T_BD_SUPPLIER SPL ON BILL.FSUPPLIERID = SPL.FID \n");
            }
            if (SCMConstant.BOSTYPE_SALEISSUE.equals(bosType)) {
                sql.append(" LEFT JOIN T_BD_CUSTOMER CUM ON BILL.FCUSTOMERID = CUM.FID \n");
            }
            sql.append(" LEFT JOIN T_GL_VOUCHER  VOUC ON BILL.FVOUCHERID = VOUC.FID \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)idTemp);
        }
    }

    private String buildIdTempData(Context ctx, String rootID) throws BOSException {
        StringBuilder sql = new StringBuilder(100);
        sql.append(" SELECT DISTINCT FROOTID FROM T_IV_RELATIONOFCHILDANDPARENT WHERE FMOTHERID = ? ");
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{rootID});
        sql.setLength(0);
        String sourceRootID = null;
        try {
            if (rs.next()) {
                sourceRootID = rs.getString("FROOTID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (StringUtils.isEmpty(sourceRootID)) {
            throw new BOSException("rootID is null");
        }
        sql.append(" CREATE TABLE TEMP (FID VARCHAR(44),FNUMBER NVARCHAR(80),FPARENTID VARCHAR(44),FISUNAUDIT INT DEFAULT 0)");
        String idTemp = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        KsqlUtil.createTempTableIndex((Context)ctx, (String)idTemp, (String)"FID", (boolean)true);
        sql.setLength(0);
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>();
        sql.append(" SELECT DISTINCT FMOTHERID,FCHILDID,FISUNAUDIT FROM T_IV_RELATIONOFCHILDANDPARENT WHERE FROOTID = ? AND FMOTHERID IS NOT NULL ");
        rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{sourceRootID});
        sql.setLength(0);
        String motherId = null;
        String childId = null;
        ArrayList childIdList = null;
        HashSet<String> unAuditIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                motherId = rs.getString("FMOTHERID");
                childId = rs.getString("FCHILDID");
                if (1 == rs.getInt("FISUNAUDIT")) {
                    unAuditIdSet.add(childId);
                }
                if (idMap.get(motherId) == null) {
                    childIdList = new ArrayList();
                    idMap.put(motherId, childIdList);
                }
                ((List)idMap.get(motherId)).add(childId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuilder idSb = new StringBuilder();
        this.getAllChildID(idMap, rootID, idSb, unAuditIdSet);
        sql.append(" INSERT INTO ").append(idTemp).append("(FID,FNUMBER,FPARENTID) \n");
        sql.append(" SELECT FMOTHERID,FMOTHERNUMBER,'' FROM T_IV_RELATIONOFCHILDANDPARENT WHERE FMOTHERID = ? \n");
        sql.append(" UNION ");
        sql.append(" SELECT FCHILDID,FCHILDNUMBER,FMOTHERID FROM T_IV_RELATIONOFCHILDANDPARENT WHERE FCHILDID in ( \n");
        sql.append(idSb.substring(0, idSb.length() - 1)).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{rootID});
        sql.setLength(0);
        if (!unAuditIdSet.isEmpty()) {
            sql.append(" UPDATE ").append(idTemp).append(" SET FISUNAUDIT = 1 WHERE FID IN (");
            sql.append(StringUtil.getKeyIdList((Object[])unAuditIdSet.toArray())).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
        }
        return idTemp;
    }

    private void getAllChildID(Map<String, List<String>> idMap, String motherId, StringBuilder idSb, Set<String> unAuditIdSet) {
        if (idMap.get(motherId) != null) {
            List<String> childList = idMap.get(motherId);
            int size = childList.size();
            for (int i = 0; i < size; ++i) {
                if (unAuditIdSet.contains(motherId)) {
                    unAuditIdSet.add(childList.get(i));
                }
                idSb.append("'").append(childList.get(i)).append("',");
                this.getAllChildID(idMap, childList.get(i), idSb, unAuditIdSet);
            }
        }
    }

    private void updateCantMergeReson(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        String bosType = params.getString("BOSType");
        String rootId = params.getString("rootBillId");
        StringBuffer sql = new StringBuffer(100);
        String billSelf = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"billSelf", (Locale)ctx.getLocale());
        sql.append(" UPDATE ").append(tempTable).append(" set FCANTMERGERESON = ? ");
        sql.append(" WHERE FID = ?  ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{billSelf, rootId});
        sql.setLength(0);
        String hasDestBill = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"hasDestBill", (Locale)ctx.getLocale());
        sql.append(" UPDATE ").append(tempTable).append(" set FCANTMERGERESON = ? ");
        sql.append(" WHERE FID IN (SELECT TEMP.FID FROM  ").append(tempTable).append(" TEMP");
        sql.append(" INNER JOIN T_BOT_RELATION RAL ON TEMP.FID = RAL.FSRCOBJECTID )");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{hasDestBill});
        sql.setLength(0);
        String hasVoucher = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"hasVoucher", (Locale)ctx.getLocale());
        sql.append(" UPDATE ").append(tempTable).append(" SET FCANTMERGERESON = ? ");
        sql.append(" WHERE FVOUCHER IS NOT NULL");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{hasVoucher});
        sql.setLength(0);
        String hasWriteOffRecord = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"hasWriteOffRecord", (Locale)ctx.getLocale());
        sql.append(" UPDATE ").append(tempTable).append(" SET FCANTMERGERESON = ? ");
        sql.append(" WHERE FID IN (SELECT TEMP.FID FROM  ").append(tempTable).append(" TEMP");
        sql.append(" INNER JOIN T_CL_WRITEOFFRECORD WORC ON TEMP.FID = WORC.FBILLID )");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{hasWriteOffRecord});
        sql.setLength(0);
        String billUnaudit = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"billUnaudit", (Locale)ctx.getLocale());
        sql.append(" UPDATE ").append(tempTable).append(" SET FCANTMERGERESON = ? ");
        sql.append(" WHERE FISUNAUDIT = 1  ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{billUnaudit});
        sql.setLength(0);
        String rootID = params.getString("rootBillId");
        CompanyOrgUnitInfo companyOrgUnitInfo = this.getBillCompanyInfo(ctx, rootID, bosType);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        Date beginDate = currentPeriod.getBeginDate();
        Timestamp endDate = currentPeriod.getEndDate();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String beginDateStr = format.format(beginDate);
        String endDateStr = format.format(endDate);
        String previousPeriod = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"previousPeriod", (Locale)ctx.getLocale());
        sql.append(" UPDATE ").append(tempTable).append(" SET FCANTMERGERESON = ? ");
        sql.append(" WHERE FBIZDATE < TO_DATE('").append(beginDateStr).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{previousPeriod});
        sql.setLength(0);
        boolean isClose = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        if (isClose) {
            String periodClose = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"periodClose", (Locale)ctx.getLocale());
            sql.append(" UPDATE ").append(tempTable).append(" SET FCANTMERGERESON = ? ");
            sql.append(" WHERE FBIZDATE >= TO_DATE('").append(beginDateStr).append("')");
            sql.append(" AND FBIZDATE <= TO_DATE('").append(endDateStr).append("')");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{periodClose});
            sql.setLength(0);
        }
        String billDelete = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"billDelete", (Locale)ctx.getLocale());
        sql.append(" UPDATE ").append(tempTable).append(" SET FCANTMERGERESON = ? ");
        sql.append(" WHERE FSTATUS IS NULL  ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{billDelete});
        sql.setLength(0);
        String billStatus = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"billStatus", (Locale)ctx.getLocale());
        sql.append(" UPDATE ").append(tempTable).append(" SET FCANTMERGERESON = ? ");
        sql.append(" WHERE FSTATUS IS not NULL  and  FSTATUS <> ").append(4);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{billStatus});
        sql.setLength(0);
    }

    private CompanyOrgUnitInfo getBillCompanyInfo(Context ctx, String billId, String bosType) throws EASBizException, BOSException {
        IInvBillBase iInvbillBase = (IInvBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bosType));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("entry.companyOrgUnit"));
        InvBillBaseInfo invBillBaseInfo = iInvbillBase.getInvBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selectors);
        return ((InvBillBaseEntryInfo)invBillBaseInfo.getEntries().getObject(0)).getCompanyOrgUnit();
    }

    private String getBillTable(String bosType) {
        if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType)) {
            return "T_IM_PURINWAREHSBILL";
        }
        if (SCMConstant.BOSTYPE_SALEISSUE.equals(bosType)) {
            return "T_IM_SALEISSUEBILL";
        }
        return "";
    }

    private void levelTempData(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer(100);
        sql.append(" SELECT DISTINCT FPARENTID,FID FROM ").append(tempTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, List<String>> parent2ChildMap = new HashMap<String, List<String>>();
        List<String> childList = null;
        String parentId = null;
        String childId = null;
        ArrayList<String> rootList = new ArrayList<String>();
        try {
            while (rs.next()) {
                parentId = rs.getString("FPARENTID");
                childId = rs.getString("FID");
                if (!StringUtils.isEmpty((String)parentId)) {
                    if (parent2ChildMap.get(parentId) == null) {
                        childList = new ArrayList();
                        parent2ChildMap.put(parentId, childList);
                    }
                    childList = (List)parent2ChildMap.get(parentId);
                    childList.add(childId);
                    continue;
                }
                rootList.add(childId);
            }
            String rootId = null;
            HashMap<Integer, List<String>> deepMap = new HashMap<Integer, List<String>>();
            ArrayList<String> leafList = new ArrayList<String>();
            int size = rootList.size();
            for (int i = 0; i < size; ++i) {
                rootId = (String)rootList.get(i);
                childList = new ArrayList();
                childList.add(rootId);
                deepMap.put(1, childList);
                this.buildDeepMap(1, deepMap, rootId, parent2ChildMap, leafList);
            }
            sql.setLength(0);
            Iterator iterator = deepMap.keySet().iterator();
            int deep = 0;
            ArrayList<String> sqlList = new ArrayList<String>();
            while (iterator.hasNext()) {
                sql.setLength(0);
                deep = (Integer)iterator.next();
                childList = (List)deepMap.get(deep);
                sql.append(" UPDATE ").append(tempTable).append(" SET FLEVEL = ").append(deep);
                sql.append(" WHERE FID IN (");
                sql.append(this.covertIdListToString(childList));
                sql.append(")");
                sqlList.add(sql.toString());
            }
            String[] sqlArr = sqlList.toArray(new String[0]);
            KsqlUtil.executeBatch((Context)ctx, (String[])sqlArr);
            sql.setLength(0);
            sql.append(" UPDATE ").append(tempTable).append(" SET FISLEAF = 1 ");
            sql.append(" WHERE FID IN (");
            sql.append(this.covertIdListToString(leafList));
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    String covertIdListToString(List<String> idList) {
        StringBuffer sb = new StringBuffer(100);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'").append(idList.get(i)).append("'");
        }
        return sb.toString();
    }

    private RptTableHeader getReportHeader(Context ctx, List<FieldInfo> fieldList) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        FieldInfo fieldInfo = null;
        int size = fieldList.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = fieldList.get(i);
            col = new RptTableColumn(fieldInfo.getName());
            col.setWidth(fieldInfo.getWidth());
            col.setHided(fieldInfo.isHide());
            if (!StringUtils.isEmpty((String)fieldInfo.getFormat())) {
                col.setFormatPattern(fieldInfo.getFormat());
            }
            header.addColumn(col);
        }
        Object[][] labels = this.getReportHeadLables(ctx, fieldList);
        header.setLabels(labels, true);
        return header;
    }

    private Object[][] getReportHeadLables(Context ctx, List<FieldInfo> fieldList) {
        Object[][] labels = new Object[1][fieldList.size()];
        String resFile = "com.kingdee.eas.scm.im.rpt.IMRptResource";
        FieldInfo fieldInfo = null;
        String resKey = null;
        String labelStr = null;
        int size = fieldList.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = fieldList.get(i);
            resKey = fieldInfo.getResKey();
            labelStr = resKey != null ? SCMUtils.getResource((String)resFile, (String)resKey, (Context)ctx) : fieldInfo.getName();
            labels[0][i] = labelStr;
        }
        return labels;
    }

    private void buildDeepMap(int deep, Map<Integer, List<String>> deepMap, String rootId, Map<String, List<String>> parent2ChildMap, List<String> leafList) {
        List<String> childs = parent2ChildMap.get(rootId);
        if (childs == null) {
            leafList.add(rootId);
            return;
        }
        List<Object> nodeList = null;
        if (deepMap.get(++deep) == null) {
            nodeList = new ArrayList();
            deepMap.put(deep, nodeList);
        }
        nodeList = deepMap.get(deep);
        int size = childs.size();
        for (int i = 0; i < size; ++i) {
            rootId = childs.get(i);
            nodeList.add(rootId);
            this.buildDeepMap(deep, deepMap, rootId, parent2ChildMap, leafList);
        }
    }

    private void insertTestData(Context ctx, String tempTable, String bosType) throws BOSException {
        List<FieldInfo> fieldList = fieldListMap.get(bosType);
        StringBuffer sql = new StringBuffer(100);
        Locale locale = ctx.getLocale();
        sql.append(" INSERT INTO ").append(tempTable);
        sql.append(" (").append(this.getFieldSql(fieldList));
        sql.append(")");
        sql.append(" SELECT relation.FChildNumber ,A.FBASESTATUS ,B.FNAME_").append(locale).append(",A.FBIZDATE, \n");
        sql.append(" C.FNAME_L2,D.FNAME_L2 ,A.FISINTAX,E.FNUMBER,A.FISGENBIZAP,");
        sql.append(" ' ',A.FID,?,0,0");
        sql.append(" FROM  T_IV_RelationOfChildAndParent   relation \n");
        sql.append(" left join  T_IM_PURINWAREHSBILL A on A.fid = relation.FChildId \n");
        sql.append(" INNER JOIN T_SCM_BIZTYPE  B ON A.FBIZTYPEID = B.FID \n");
        sql.append(" INNER JOIN T_ORG_STORAGE C ON A.FSTORAGEORGUNITID =C.FID \n");
        sql.append(" INNER JOIN T_BD_SUPPLIER D ON A.FSUPPLIERID = D.FID \n");
        sql.append(" LEFT JOIN T_GL_VOUCHER  E ON A.FVOUCHERID = E.FID \n");
        sql.append(" WHERE relation.FRootID = ? \n");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param = null;
        param = new Object[]{"ES8VLSqDTOSHwka43qVvkXgwYeM=", "rh+moeZtTuG3wI++r/vJvngwYeM="};
        params.add(param);
        param = new Object[]{"rh+moeZtTuG3wI++r/vJvngwYeM=", "kXdBQB8dQXC6wBAXyTKfOXgwYeM="};
        params.add(param);
        param = new Object[]{"ES8VLSqDTOSHwka43qVvkXgwYeM=", "RvNvyYuJSJCEWUDCc4TcDngwYeM="};
        params.add(param);
        param = new Object[]{"", "ES8VLSqDTOSHwka43qVvkXgwYeM="};
        params.add(param);
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
    }

    private String buildTempTable(Context ctx, List<FieldInfo> fieldList) throws BOSException {
        boolean a = false;
        StringBuffer sql = new StringBuffer(200);
        sql.append(" CREATE TABLE TEMP ( ");
        FieldInfo fieldInfo = null;
        int size = fieldList.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = fieldList.get(i);
            if (i > 0) {
                sql.append(",\n");
            }
            sql.append(" ").append(fieldInfo.getName());
            sql.append(" ").append(fieldInfo.getDataType());
        }
        sql.append(" )");
        return this.createTempTable(ctx, sql.toString());
    }

    private String getFieldSql(List<FieldInfo> fieldList) {
        StringBuffer sb = new StringBuffer(100);
        FieldInfo fieldInfo = null;
        int size = fieldList.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = fieldList.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(" ").append(fieldInfo.getName());
        }
        return sb.toString();
    }

    private String getQuerySql(Context ctx, RptParams params) {
        String bosType = params.getString("BOSType");
        List<FieldInfo> fieldList = fieldListMap.get(bosType);
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append(" SELECT ");
        sql.append(this.getFieldSql(fieldList));
        sql.append(" FROM ").append(tempTable);
        return sql.toString();
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append(this.getQuerySql(ctx, params));
        if (StringUtils.isEmpty((String)params.getString("fromWeb"))) {
            sql.append(" WHERE FLEVEL = 1 ");
        }
        sql.append(" ORDER BY FLEVEL,FNUMBER");
        rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _findData(Context ctx, RptParams params, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        String parentId = params.getString("fparentid");
        StringBuffer sql = new StringBuffer(100);
        sql.append(this.getQuerySql(ctx, params));
        sql.append(" WHERE FPARENTID  = '").append(parentId).append("'");
        sql.append(" ORDER BY FNUMBER");
        RptRowSet rs = start <= -1 && count <= -1 ? this.executeQuery(sql.toString(), null, ctx) : this.executeQuery(sql.toString(), null, start, count, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private HashMap getCorrespondence(Context ctx, String id) throws BOSException {
        HashMap resultMap = new HashMap();
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select distinct FRootId from T_IV_RelationOfChildAndParent");
        sqlStr.append(" where FMotherId = '");
        sqlStr.append(id);
        sqlStr.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        String rootId = null;
        try {
            if (rs.next()) {
                rootId = rs.getString("FRootId");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList<String> motherIdList = new ArrayList<String>();
        ArrayList<String> childIdList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FMotherEntryId,FChildEntryId from T_IV_RelationOfChildAndParent");
        sql.append(" where FRootId = '");
        sql.append(rootId);
        sql.append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String motherId = rs.getString("FMotherEntryId");
                String childId = rs.getString("FChildEntryId");
                if (StringUtil.isEmpty((String)motherId)) continue;
                motherIdList.add(motherId);
                childIdList.add(childId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        resultMap.put("motherIdList", motherIdList);
        resultMap.put("childIdList", childIdList);
        return resultMap;
    }

    private HashMap buildEntryTree(ArrayList<String> motherIdList, ArrayList<String> childIdList, String id) throws BOSException {
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < motherIdList.size(); ++i) {
            String motherId = motherIdList.get(i);
            if (!motherId.equals(id)) continue;
            result.add(childIdList.get(i));
        }
        if (result.size() == 0) {
            return map;
        }
        map.put(id, result);
        HashMap resultMap = new HashMap();
        for (int i = 0; i < result.size(); ++i) {
            String entryId = ((String)result.get(i)).toString();
            resultMap = this.buildEntryTree(motherIdList, childIdList, entryId);
            for (String key : resultMap.keySet()) {
                map.put(key, (ArrayList<Object>)resultMap.get(key));
            }
        }
        return map;
    }

    private List buildTree(String id, String bosType, Context ctx) throws BOSException {
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        HashMap corMap = this.getCorrespondence(ctx, id);
        ArrayList motherIds = (ArrayList)corMap.get("motherIdList");
        ArrayList childIds = (ArrayList)corMap.get("childIdList");
        if ("783061E3".equals(bosType)) {
            EntityViewInfo childView = new EntityViewInfo();
            FilterInfo childFilterInfo = new FilterInfo();
            childFilterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id, CompareType.EQUALS));
            childView.setFilter(childFilterInfo);
            PurInWarehsEntryCollection purEntryCollection = PurInWarehsEntryFactory.getLocalInstance(ctx).getPurInWarehsEntryCollection(childView);
            HashMap map = new HashMap();
            for (int i = 0; i < purEntryCollection.size(); ++i) {
                PurInWarehsEntryInfo purEntry = purEntryCollection.get(i);
                HashMap resultmap = this.buildEntryTree(motherIds, childIds, purEntry.getId().toString());
                result.add(resultmap);
            }
        } else {
            EntityViewInfo childView = new EntityViewInfo();
            FilterInfo childFilterInfo = new FilterInfo();
            childFilterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id, CompareType.EQUALS));
            childView.setFilter(childFilterInfo);
            SaleIssueEntryCollection saleEntryCollection = SaleIssueEntryFactory.getLocalInstance(ctx).getSaleIssueEntryCollection(childView);
            HashMap map = new HashMap();
            for (int i = 0; i < saleEntryCollection.size(); ++i) {
                SaleIssueEntryInfo purEntry = saleEntryCollection.get(i);
                HashMap resultmap = this.buildEntryTree(motherIds, childIds, purEntry.getId().toString());
                result.add(resultmap);
            }
        }
        return result;
    }

    private boolean compareAccountAndUnitPrice(Context ctx, IObjectCollection parentCollection, IObjectCollection childCollection, List list, String bosType) throws BOSException {
        String priceInfo;
        InvBillBaseEntryInfo motherEntryInfo;
        int i;
        String motherEntryId;
        int i2;
        int i3;
        AbstractObjectCollection childEntryCollection;
        AbstractObjectCollection entryCollection;
        ArrayList<String> motherEntryIds = new ArrayList<String>();
        HashMap<String, InvBillBaseEntryInfo> relationMap = new HashMap<String, InvBillBaseEntryInfo>();
        HashSet<String> priceIdSet = new HashSet<String>();
        HashSet<String> accountViewIdSet = new HashSet<String>();
        if (parentCollection instanceof PurInWarehsEntryCollection) {
            entryCollection = (PurInWarehsEntryCollection)parentCollection;
            childEntryCollection = (PurInWarehsEntryCollection)childCollection;
            for (i3 = 0; i3 < entryCollection.size(); ++i3) {
                motherEntryIds.add(entryCollection.get(i3).getId().toString());
                relationMap.put(entryCollection.get(i3).getId().toString(), entryCollection.get(i3));
            }
            for (i2 = 0; i2 < childEntryCollection.size(); ++i2) {
                PurInWarehsEntryInfo childEntryInfo = childEntryCollection.get(i2);
                motherEntryId = this.getCorrespondingMasterEntryId(motherEntryIds, childEntryInfo.getId().toString(), list);
                this.relationsMap.put(childEntryInfo.getId().toString(), motherEntryId);
            }
            for (i = 0; i < childEntryCollection.size(); ++i) {
                PurInWarehsEntryInfo childEntryInfo = childEntryCollection.get(i);
                String childEntryId = childEntryInfo.getId().toString();
                if (childEntryId.equals(motherEntryId = this.relationsMap.get(childEntryId))) continue;
                motherEntryInfo = (PurInWarehsEntryInfo)relationMap.get(motherEntryId);
                if (childEntryInfo.getPrice().compareTo(((AbstractPurInWarehsEntryInfo)motherEntryInfo).getPrice()) != 0) {
                    priceIdSet.add(childEntryId);
                }
                if (childEntryInfo.getAccountViewIn() == null && motherEntryInfo.getAccountViewIn() == null) continue;
                if (childEntryInfo.getAccountViewIn() != null && motherEntryInfo.getAccountViewIn() != null) {
                    if (childEntryInfo.getAccountViewIn().getId().equals((Object)motherEntryInfo.getAccountViewIn().getId())) continue;
                    accountViewIdSet.add(childEntryId);
                    continue;
                }
                accountViewIdSet.add(childEntryId);
            }
            if (priceIdSet.isEmpty() && accountViewIdSet.isEmpty()) {
                return true;
            }
        }
        if (parentCollection instanceof SaleIssueEntryCollection) {
            entryCollection = (SaleIssueEntryCollection)parentCollection;
            childEntryCollection = (SaleIssueEntryCollection)childCollection;
            for (i3 = 0; i3 < entryCollection.size(); ++i3) {
                motherEntryIds.add(entryCollection.get(i3).getId().toString());
                relationMap.put(entryCollection.get(i3).getId().toString(), entryCollection.get(i3));
            }
            for (i2 = 0; i2 < childEntryCollection.size(); ++i2) {
                SaleIssueEntryInfo childEntryInfo = childEntryCollection.get(i2);
                motherEntryId = this.getCorrespondingMasterEntryId(motherEntryIds, childEntryInfo.getId().toString(), list);
                this.relationsMap.put(childEntryInfo.getId().toString(), motherEntryId);
            }
            for (i = 0; i < childEntryCollection.size(); ++i) {
                SaleIssueEntryInfo childEntryInfo = childEntryCollection.get(i);
                String childEntryId = childEntryInfo.getId().toString();
                if (childEntryId.equals(motherEntryId = this.relationsMap.get(childEntryId))) continue;
                motherEntryInfo = (SaleIssueEntryInfo)relationMap.get(motherEntryId);
                if (childEntryInfo.getPrice().compareTo(((AbstractSaleIssueEntryInfo)motherEntryInfo).getPrice()) != 0) {
                    priceIdSet.add(childEntryId);
                }
                if (childEntryInfo.getAccountViewOut() == null && motherEntryInfo.getAccountViewOut() == null) continue;
                if (childEntryInfo.getAccountViewOut() != null && motherEntryInfo.getAccountViewOut() != null) {
                    if (childEntryInfo.getAccountViewOut().getId().equals((Object)motherEntryInfo.getAccountViewOut().getId())) continue;
                    accountViewIdSet.add(childEntryId);
                    continue;
                }
                accountViewIdSet.add(childEntryId);
            }
            if (priceIdSet.isEmpty() && accountViewIdSet.isEmpty()) {
                return true;
            }
        }
        if (!priceIdSet.isEmpty() && !accountViewIdSet.isEmpty()) {
            priceInfo = this.getDiffInfoByEntryId(ctx, priceIdSet, bosType);
            String accountViewMap = this.getDiffAccountViewInfoByEntryId(ctx, accountViewIdSet, bosType);
            this.checkMap.put("priceDifferInfo", priceInfo);
            this.checkMap.put("accountViewDifferInfo", accountViewMap);
            return false;
        }
        if (!priceIdSet.isEmpty() && accountViewIdSet.isEmpty()) {
            priceInfo = this.getDiffInfoByEntryId(ctx, priceIdSet, bosType);
            this.checkMap.put("priceDifferInfo", priceInfo);
            this.checkMap.put("accountViewDifferInfo", null);
            return false;
        }
        if (!accountViewIdSet.isEmpty() && priceIdSet.isEmpty()) {
            String accountViewMap = this.getDiffAccountViewInfoByEntryId(ctx, accountViewIdSet, bosType);
            this.checkMap.put("accountViewDifferInfo", accountViewMap);
            this.checkMap.put("priceDifferInfo", null);
            return false;
        }
        return true;
    }

    private String getCorrespondingMasterEntryId(List motherEntryIds, String childEntryId, List<HashMap<String, List>> list) {
        HashMap<Object, Object> map = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            map = list.get(i);
            for (String string : map.keySet()) {
                List resultList = (List)map.get(string);
                if (!resultList.contains(childEntryId)) continue;
                if (motherEntryIds.contains(string)) {
                    return string;
                }
                return this.getCorrespondingMasterEntryId(motherEntryIds, string, list);
            }
        }
        return childEntryId;
    }

    @Override
    protected Map _mergeSubsingleData(Context ctx, String id, Set idSet, String bosType) throws BOSException, EASBizException {
        IObjectPK logPK;
        StorageOrgUnitInfo orgUnitInfo;
        if (bosType.equals(SCMConstant.BOSTYPE_PURINWAREHS)) {
            PurInWarehsBillInfo purInWarehsBillInfo = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(id));
            orgUnitInfo = purInWarehsBillInfo.getStorageOrgUnit();
            logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"MergeSplite", (Locale)ctx.getLocale()), (BOSObjectType)BOSObjectType.create((String)"783061E3"), (IObjectPK)new ObjectUuidPK(id), (String)this.getMotherAndChildInfo(ctx, id, idSet, bosType), (String)"im_purInWarehs_merge", (String)orgUnitInfo.getId().toString());
        } else {
            SaleIssueBillInfo saleIssueBillInfo = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(id));
            orgUnitInfo = saleIssueBillInfo.getStorageOrgUnit();
            logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"MergeSplite", (Locale)ctx.getLocale()), (BOSObjectType)BOSObjectType.create((String)"CC3E933B"), (IObjectPK)new ObjectUuidPK(id), (String)this.getMotherAndChildInfo(ctx, id, idSet, bosType), (String)"im_purInWarehs_merge", (String)orgUnitInfo.getId().toString());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> allIdSet = new HashSet<String>();
        allIdSet.add(id);
        allIdSet.addAll(idSet);
        this.lockBillUseUpdate(ctx, allIdSet, bosType);
        this.chekMotherBill(ctx, id, bosType);
        String checkMsg = this.chekChildBill(ctx, idSet, bosType);
        result.put("checkMsg", checkMsg);
        if (idSet.isEmpty()) {
            return result;
        }
        ArrayList<HashMap<String, List>> list = new ArrayList();
        HashMap<String, PurInWarehsEntryInfo> relationMap = new HashMap<String, PurInWarehsEntryInfo>();
        ArrayList<String> motherEntryIds = new ArrayList<String>();
        list = this.buildTree(id, bosType, ctx);
        if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType)) {
            PurInWarehsBillInfo purInWarehsBillInfo = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(id));
            PurInWarehsEntryCollection entryCollection = purInWarehsBillInfo.getEntry();
            PurInWarehsEntryCollection childEntryCollection = this.getChildBillEntryCollection(ctx, idSet);
            for (int i = 0; i < entryCollection.size(); ++i) {
                motherEntryIds.add(entryCollection.get(i).getId().toString());
                relationMap.put(entryCollection.get(i).getId().toString(), entryCollection.get(i));
            }
            for (int i = 0; i < childEntryCollection.size(); ++i) {
                PurInWarehsEntryInfo childEntryInfo = childEntryCollection.get(i);
                String childEntryId = childEntryInfo.getId().toString();
                String motherEntryId = this.getCorrespondingMasterEntryId(motherEntryIds, childEntryId, list);
                this.relationsMap.put(childEntryId, motherEntryId);
            }
            this.mergeChildOrdersToParentOrders(ctx, purInWarehsBillInfo, childEntryCollection);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            IObjectPK logChildPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"deleteChild", (Locale)ctx.getLocale()), (BOSObjectType)BOSObjectType.create((String)"783061E3"), (IObjectPK)new ObjectUuidPK(id), (String)this.getChildInfo(ctx, idSet, "783061E3"), (String)"im_purInWarehs_merge_splite", (String)purInWarehsBillInfo.getStorageOrgUnit().getId().toString());
            LogUtil.afterLog((Context)ctx, (IObjectPK)logChildPK);
            this.dealCoreOrder(ctx, id, idSet, bosType);
            this.delateChildId(idSet, bosType, ctx);
        } else {
            SaleIssueBillInfo saleIssueBillInfo = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(id));
            SaleIssueEntryCollection entryCollection = saleIssueBillInfo.getEntry();
            SaleIssueEntryCollection childEntryCollection = this.getSaleChildBillEntryCollection(ctx, idSet);
            for (int i = 0; i < childEntryCollection.size(); ++i) {
                SaleIssueEntryInfo childEntryInfo = childEntryCollection.get(i);
                String childEntryId = childEntryInfo.getId().toString();
                String motherEntryId = this.getCorrespondingMasterEntryId(motherEntryIds, childEntryId, list);
                this.relationsMap.put(childEntryId, motherEntryId);
            }
            this.mergeSaleChildOrdersToParentOrders(ctx, saleIssueBillInfo, childEntryCollection);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            IObjectPK logChildPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"deleteChild", (Locale)ctx.getLocale()), (BOSObjectType)BOSObjectType.create((String)"CC3E933B"), (IObjectPK)new ObjectUuidPK(id), (String)this.getChildInfo(ctx, idSet, "CC3E933B"), (String)"im_purInWarehs_merge_splite", (String)saleIssueBillInfo.getStorageOrgUnit().getId().toString());
            LogUtil.afterLog((Context)ctx, (IObjectPK)logChildPK);
            this.dealCoreOrder(ctx, id, idSet, bosType);
            this.delateChildId(idSet, bosType, ctx);
        }
        return result;
    }

    private void delateChildId(Set idSet, String bosType, Context ctx) throws EASBizException, BOSException {
        IObjectPK[] arrayPK = new IObjectPK[idSet.size()];
        Iterator it = idSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            String billId = (String)it.next();
            arrayPK[i] = new ObjectUuidPK(billId);
            ++i;
        }
        if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType)) {
            PurInWarehsBillFactory.getLocalInstance(ctx).deleteBatchData(arrayPK);
        }
        if (SCMConstant.BOSTYPE_SALEISSUE.equals(bosType)) {
            SaleIssueBillFactory.getLocalInstance(ctx).deleteBatchData(arrayPK);
        }
    }

    private String chekChildBill(Context ctx, Set idSet, String bosType) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return "";
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = this.getBillCompanyInfo(ctx, (String)idSet.toArray()[0], bosType);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        Date beginDate = currentPeriod.getBeginDate();
        Timestamp endDate = currentPeriod.getEndDate();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String beginDateStr = format.format(beginDate);
        String endDateStr = format.format(endDate);
        String billTable = this.getBillTable(bosType);
        StringBuilder result = new StringBuilder(300);
        StringBuilder sb = new StringBuilder(100);
        sb.append(" SELECT FNUMBER, FID FROM ").append(billTable).append(" BILL");
        sb.append(" WHERE FFIVOUCHERED = 1 AND FID IN (").append(StringUtil.getKeyIdList((Object[])idSet.toArray())).append(")");
        result.append(this.checkItem(ctx, sb.toString(), "hasVoucher", idSet));
        sb.setLength(0);
        sb.append(" SELECT BILL.FNUMBER, BILL.FID FROM ").append(billTable).append(" BILL ");
        sb.append(" INNER JOIN T_CL_WRITEOFFRECORD WORC ON BILL.FID = WORC.FBILLID ");
        sb.append(" WHERE BILL.FID IN (").append(StringUtil.getKeyIdList((Object[])idSet.toArray())).append(")");
        result.append(this.checkItem(ctx, sb.toString(), "hasWriteOffRecord", idSet));
        sb.setLength(0);
        sb.append(" SELECT BILL.FNUMBER FNUMBER ,BILL.FID FID FROM ").append(billTable).append(" BILL");
        sb.append(" INNER JOIN T_BOT_RELATION REL ON BILL.FID = REL.FSRCOBJECTID ");
        sb.append(" WHERE BILL.FID IN (").append(StringUtil.getKeyIdList((Object[])idSet.toArray())).append(")");
        result.append(this.checkItem(ctx, sb.toString(), "hasDestBill", idSet));
        sb.setLength(0);
        sb.append(" SELECT BILL.FNUMBER FNUMBER ,BILL.FID FID FROM ").append(billTable).append(" BILL");
        sb.append(" INNER JOIN T_IV_RELATIONOFCHILDANDPARENT REL ON BILL.FID = REL.FCHILDID ");
        sb.append(" WHERE BILL.FID IN (").append(StringUtil.getKeyIdList((Object[])idSet.toArray())).append(")");
        sb.append(" AND REL.FISUNAUDIT = 1 ");
        result.append(this.checkItem(ctx, sb.toString(), "billUnaudit", idSet));
        sb.setLength(0);
        sb.append(" SELECT FNUMBER, FID FROM ").append(billTable).append(" ");
        sb.append(" WHERE FBASESTATUS  <> ").append(4);
        sb.append(" AND FID IN (").append(StringUtil.getKeyIdList((Object[])idSet.toArray())).append(")");
        result.append(this.checkItem(ctx, sb.toString(), "billStatus", idSet));
        sb.setLength(0);
        sb.append(" SELECT FNUMBER, FID FROM ").append(billTable).append(" ");
        sb.append(" WHERE FBIZDATE  < TO_DATE('").append(beginDateStr).append("')");
        sb.append(" AND FID IN (").append(StringUtil.getKeyIdList((Object[])idSet.toArray())).append(")");
        result.append(this.checkItem(ctx, sb.toString(), "previousPeriod", idSet));
        sb.setLength(0);
        boolean isClose = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        if (isClose) {
            sb.append(" SELECT FNUMBER, FID FROM ").append(billTable).append(" ");
            sb.append(" WHERE FBIZDATE >= TO_DATE('").append(beginDateStr).append("')");
            sb.append(" AND FBIZDATE <= TO_DATE('").append(endDateStr).append("')");
            sb.append(" AND FID IN (").append(StringUtil.getKeyIdList((Object[])idSet.toArray())).append(")");
            result.append(this.checkItem(ctx, sb.toString(), "periodClose", idSet));
            sb.setLength(0);
        }
        return result.toString();
    }

    private String checkItem(Context ctx, String sql, String resKey, Set idSet) throws BOSException {
        StringBuilder result = new StringBuilder(300);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String resMsg = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)resKey, (Locale)ctx.getLocale());
        try {
            while (rs.next()) {
                String number = rs.getString("FNUMBER");
                String id = rs.getString("FID");
                idSet.remove(id);
                result.append(number).append("\t").append(resMsg).append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result.toString();
    }

    private void chekMotherBill(Context ctx, String id, String bosType) throws EASBizException, BOSException {
        RelationOfChildAndParentFacadeFactory.getLocalInstance(ctx).judgeCanMerge(id, bosType);
    }

    private void lockBillUseUpdate(Context ctx, Set idSet, String bosType) throws BOSException {
        String billTable = this.getBillTable(bosType);
        StringBuilder sb = new StringBuilder(100);
        String idStr = StringUtil.getKeyIdList((Object[])idSet.toArray());
        sb.append(" UPDATE ").append(billTable).append(" SET FID = FID WHERE FID IN (");
        sb.append(idStr).append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private PurInWarehsEntryCollection getMotherBillEntryCollection(Context ctx, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("material.pricePrecision"));
        sics.add(new SelectorItemInfo("qty"));
        sics.add(new SelectorItemInfo("amount"));
        sics.add(new SelectorItemInfo("taxAmount"));
        sics.add(new SelectorItemInfo("baseQty"));
        sics.add(new SelectorItemInfo("assistQty"));
        sics.add(new SelectorItemInfo("price"));
        sics.add(new SelectorItemInfo("accountViewIn.number"));
        sics.add(new SelectorItemInfo("accountViewIn.name"));
        view.setSelector(sics);
        view.setFilter(filterInfo);
        return PurInWarehsEntryFactory.getLocalInstance(ctx).getPurInWarehsEntryCollection(view);
    }

    private PurInWarehsEntryCollection getChildBillEntryCollection(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        return PurInWarehsEntryFactory.getLocalInstance(ctx).getPurInWarehsEntryCollection(view);
    }

    private SaleIssueEntryCollection getSaleChildBillEntryCollection(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        return SaleIssueEntryFactory.getLocalInstance(ctx).getSaleIssueEntryCollection(view);
    }

    private SaleIssueEntryCollection getSaleMotherBillEntryCollection(Context ctx, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("material.pricePrecision"));
        sics.add(new SelectorItemInfo("qty"));
        sics.add(new SelectorItemInfo("amount"));
        sics.add(new SelectorItemInfo("nonTaxAmount"));
        sics.add(new SelectorItemInfo("baseQty"));
        sics.add(new SelectorItemInfo("assistQty"));
        sics.add(new SelectorItemInfo("price"));
        sics.add(new SelectorItemInfo("accountViewOut.number"));
        sics.add(new SelectorItemInfo("accountViewOut.name"));
        view.setSelector(sics);
        view.setFilter(filterInfo);
        return SaleIssueEntryFactory.getLocalInstance(ctx).getSaleIssueEntryCollection(view);
    }

    private void dealCoreOrder(Context ctx, String motherId, Set childIdSet, String bosType) throws EASBizException, BOSException {
        int j;
        boolean flag;
        int i;
        int size;
        InvBillBaseEntryInfo entryInfo;
        AbstractObjectCollection entries;
        InvBillBaseInfo info;
        AbstractObjectCollection purInCollection;
        SelectorItemCollection sic;
        ISysBillFacade sysBillFacade = SysBillFacadeFactory.getLocalInstance(ctx);
        ObjectUuidPK billPk = null;
        HashSet<String> allIdSet = new HashSet<String>();
        allIdSet.add(motherId);
        allIdSet.addAll(childIdSet);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", allIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType)) {
            sic = SCMSelectorFactory.getPurInWarehsBillSelector((boolean)true);
            sic.add("currency.precision");
            sic.add("entry.companyOrgUnit.baseCurrency.id");
            sic.add("entry.companyOrgUnit.baseCurrency.precision");
            view.setSelector(sic);
            purInCollection = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(view);
            info = null;
            entries = null;
            entryInfo = null;
            size = purInCollection.size();
            for (i = 0; i < size; ++i) {
                info = purInCollection.get(i);
                billPk = new ObjectUuidPK(info.getId());
                flag = sysBillFacade.delBuildOrderOrReturnBill((IObjectPK)billPk, info, false);
                if (!motherId.equals(info.getId().toString()) || !flag) continue;
                entries = ((AbstractPurInWarehsBillInfo)info).getEntry();
                for (j = 0; j < entries.size(); ++j) {
                    entryInfo = entries.get(j);
                    ((AbstractPurInWarehsEntryInfo)entryInfo).setPurOrder(null);
                    ((AbstractPurInWarehsEntryInfo)entryInfo).setPurOrderEntry(null);
                    ((AbstractPurInWarehsEntryInfo)entryInfo).setPurOrderNumber(null);
                }
                sysBillFacade.buildOrderOrReturnBill((IObjectPK)billPk, info, false);
            }
        }
        if (SCMConstant.BOSTYPE_SALEISSUE.equals(bosType)) {
            sic = SCMSelectorFactory.getSaleIssueBillSelector((boolean)true);
            sic.add("currency.precision");
            sic.add("entry.companyOrgUnit.baseCurrency.id");
            sic.add("entry.companyOrgUnit.baseCurrency.precision");
            view.setSelector(sic);
            purInCollection = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillCollection(view);
            info = null;
            entries = null;
            entryInfo = null;
            size = purInCollection.size();
            for (i = 0; i < size; ++i) {
                info = purInCollection.get(i);
                billPk = new ObjectUuidPK(info.getId());
                flag = sysBillFacade.delBuildOrderOrReturnBill((IObjectPK)billPk, info, false);
                if (!motherId.equals(info.getId().toString()) || !flag) continue;
                entries = ((AbstractSaleIssueBillInfo)info).getEntry();
                for (j = 0; j < entries.size(); ++j) {
                    entryInfo = entries.get(j);
                    ((AbstractSaleIssueEntryInfo)entryInfo).setSaleOrder(null);
                    ((AbstractSaleIssueEntryInfo)entryInfo).setSaleOrderEntry(null);
                    ((AbstractSaleIssueEntryInfo)entryInfo).setSaleOrderNumber(null);
                }
                sysBillFacade.buildOrderOrReturnBill((IObjectPK)billPk, info, false);
            }
        }
    }

    public void mergeChildOrdersToParentOrders(Context ctx, PurInWarehsBillInfo purInWarehsBillInfo, PurInWarehsEntryCollection childPurCollection) throws BOSException, EASBizException {
        String parentEntryId;
        IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance(ctx);
        PurInWarehsBillInfo motherBillInfo = purInWarehsBillInfo;
        boolean isInTax = purInWarehsBillInfo.isIsInTax();
        PurInWarehsEntryCollection motherBillEntries = motherBillInfo.getEntry();
        ArrayList<PurInWarehsEntryInfo> childNeedAddList = new ArrayList<PurInWarehsEntryInfo>();
        HashMap<String, PurInWarehsEntryInfo> motherNeedAddMap = new HashMap<String, PurInWarehsEntryInfo>();
        for (Map.Entry<String, String> mapEntry : this.relationsMap.entrySet()) {
            String childEntryId = mapEntry.getKey();
            parentEntryId = mapEntry.getValue();
            PurInWarehsEntryInfo childPur = childPurCollection.get(BOSUuid.read((String)childEntryId));
            if (childEntryId.equals(parentEntryId)) {
                childPur.setId(BOSUuid.create((String)"783061E3"));
                childNeedAddList.add(childPur);
                continue;
            }
            PurInWarehsEntryInfo parentPur = motherBillEntries.get(BOSUuid.read((String)parentEntryId));
            if (null == childPur || null == parentPur) continue;
            this.setCommonDate(parentPur, childPur, isInTax);
        }
        for (int i = motherBillEntries.size() - 1; i >= 0; --i) {
            parentEntryId = motherBillEntries.get(i).getId().toString();
            if (this.relationsMap.containsValue(parentEntryId)) continue;
            motherNeedAddMap.put(parentEntryId, (PurInWarehsEntryInfo)motherBillEntries.get(i).clone());
        }
        motherBillInfo.setBillRelationOption(BillRelationOptionEnum.RECALCULATE);
        motherBillInfo.put("fromMerge", true);
        PurInAlgorithmForInfo purInAlgorithmForInfo = new PurInAlgorithmForInfo(motherBillInfo, ctx);
        purInAlgorithmForInfo.revalue();
        this.calSpecialField(motherBillInfo, true, purInAlgorithmForInfo.getLocalAmountPrecision());
        int size = motherBillEntries.size();
        for (int i = 0; i < size; ++i) {
            parentEntryId = motherBillEntries.get(i).getId().toString();
            if (motherNeedAddMap.get(parentEntryId) == null) continue;
            motherBillEntries.removeObject(i);
            motherBillEntries.addObject(i, (IObjectValue)motherNeedAddMap.get(parentEntryId));
        }
        ObjectUuidPK updatePK = new ObjectUuidPK(motherBillInfo.getId());
        int size2 = childNeedAddList.size();
        for (int i = 0; i < size2; ++i) {
            motherBillEntries.add((PurInWarehsEntryInfo)childNeedAddList.get(i));
        }
        iPurInWarehsBill.update((IObjectPK)updatePK, (CoreBaseInfo)motherBillInfo);
    }

    private void calSpecialField(InvBillBaseInfo motherBillInfo, boolean isPurin, int localAmtPrecision) {
        IObjectCollection entries = motherBillInfo.getEntries();
        InvBillBaseEntryInfo entryInfo = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (InvBillBaseEntryInfo)entries.getObject(i);
            if (!isPurin) {
                SaleIssueEntryInfo saleEntryInfo = (SaleIssueEntryInfo)entryInfo;
                int pricePrecision = entryInfo.getMaterial().getPricePrecision();
                entryInfo.setUnitActualCost(entryInfo.getActualCost().divide(entryInfo.getQty(), pricePrecision, RoundingMode.HALF_UP));
            }
            entryInfo.setStandardCost(entryInfo.getUnitStandardCost().multiply(entryInfo.getQty()).setScale(localAmtPrecision, RoundingMode.HALF_UP));
            entryInfo.setAssociateQty(entryInfo.getBaseQty());
        }
    }

    private void setCommonDate(PurInWarehsEntryInfo parentPur, PurInWarehsEntryInfo childPur, boolean isInTax) {
        parentPur.setQty(parentPur.getQty().add(childPur.getQty()));
        if (parentPur.getBaseQty() != null) {
            parentPur.setBaseQty(parentPur.getBaseQty().add(childPur.getBaseQty()));
        }
        if (parentPur.getAssistQty() != null) {
            parentPur.setAssistQty(parentPur.getAssistQty().add(childPur.getAssistQty()));
        }
        if (isInTax) {
            parentPur.setTaxAmount(parentPur.getTaxAmount().add(childPur.getTaxAmount()));
            parentPur.setTaxPrice(BigDecimal.ZERO);
        } else {
            parentPur.setAmount(parentPur.getAmount().add(childPur.getAmount()));
            parentPur.setPrice(BigDecimal.ZERO);
        }
    }

    public void mergeSaleChildOrdersToParentOrders(Context ctx, SaleIssueBillInfo saleIssueBillInfo, SaleIssueEntryCollection childPurCollection) throws BOSException, EASBizException {
        String parentEntryId;
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        SaleIssueBillInfo motherBillInfo = saleIssueBillInfo;
        boolean isInTax = motherBillInfo.isIsInTax();
        SaleIssueEntryCollection motherBillEntries = motherBillInfo.getEntry();
        ArrayList<SaleIssueEntryInfo> childNeedAddList = new ArrayList<SaleIssueEntryInfo>();
        HashMap<String, SaleIssueEntryInfo> motherNeedAddMap = new HashMap<String, SaleIssueEntryInfo>();
        for (Map.Entry<String, String> mapEntry : this.relationsMap.entrySet()) {
            String childEntryId = mapEntry.getKey();
            parentEntryId = mapEntry.getValue();
            SaleIssueEntryInfo childPur = childPurCollection.get(BOSUuid.read((String)childEntryId));
            if (childEntryId.equals(parentEntryId)) {
                childPur.setId(BOSUuid.create((String)"CC3E933B"));
                childNeedAddList.add(childPur);
                continue;
            }
            SaleIssueEntryInfo parentPur = motherBillEntries.get(BOSUuid.read((String)parentEntryId));
            if (null == childPur || null == parentPur) continue;
            this.setSaleIssCommonDate(parentPur, childPur, isInTax);
        }
        for (int i = motherBillEntries.size() - 1; i >= 0; --i) {
            parentEntryId = motherBillEntries.get(i).getId().toString();
            if (this.relationsMap.containsValue(parentEntryId)) continue;
            motherNeedAddMap.put(parentEntryId, (SaleIssueEntryInfo)motherBillEntries.get(i).clone());
        }
        SaleIssueAlgorithmForInfo saleIssueAlgorithmForInfo = new SaleIssueAlgorithmForInfo(motherBillInfo, ctx);
        saleIssueAlgorithmForInfo.revalue();
        this.calSpecialField(motherBillInfo, false, saleIssueAlgorithmForInfo.getLocalAmountPrecision());
        int size = motherBillEntries.size();
        for (int i = 0; i < size; ++i) {
            parentEntryId = motherBillEntries.get(i).getId().toString();
            if (motherNeedAddMap.get(parentEntryId) == null) continue;
            motherBillEntries.removeObject(i);
            motherBillEntries.addObject(i, (IObjectValue)motherNeedAddMap.get(parentEntryId));
        }
        ObjectUuidPK updatePK = new ObjectUuidPK(motherBillInfo.getId());
        int size2 = childNeedAddList.size();
        for (int i = 0; i < size2; ++i) {
            SaleIssueEntryInfo childNeedAddEntry = (SaleIssueEntryInfo)childNeedAddList.get(i);
            childNeedAddEntry.setSaleOrder(BOSUuid.create((String)"88888888").toString());
            childNeedAddEntry.setSaleOrderEntry(BOSUuid.create((String)"88888888").toString());
            motherBillEntries.add(childNeedAddEntry);
        }
        iSaleIssueBill.update((IObjectPK)updatePK, (CoreBaseInfo)motherBillInfo);
    }

    private void setSaleIssCommonDate(SaleIssueEntryInfo parentSaleEntryInfo, SaleIssueEntryInfo childSaleEntryInfo, boolean isInTax) {
        parentSaleEntryInfo.setQty(parentSaleEntryInfo.getQty().add(childSaleEntryInfo.getQty()));
        if (parentSaleEntryInfo.getBaseQty() != null) {
            parentSaleEntryInfo.setBaseQty(parentSaleEntryInfo.getBaseQty().add(childSaleEntryInfo.getBaseQty()));
        }
        if (parentSaleEntryInfo.getAssistQty() != null) {
            parentSaleEntryInfo.setAssistQty(parentSaleEntryInfo.getAssistQty().add(childSaleEntryInfo.getAssistQty()));
        }
        if (parentSaleEntryInfo.getUnWriteOffAmount() != null && childSaleEntryInfo.getUnWriteOffAmount() != null) {
            parentSaleEntryInfo.setUnWriteOffAmount(parentSaleEntryInfo.getUnWriteOffAmount().add(childSaleEntryInfo.getUnWriteOffAmount()));
        }
        if (parentSaleEntryInfo.getTotalVmiSettleBaseQty() != null && childSaleEntryInfo.getTotalVmiSettleBaseQty() != null) {
            parentSaleEntryInfo.setTotalVmiSettleBaseQty(parentSaleEntryInfo.getTotalVmiSettleBaseQty().add(childSaleEntryInfo.getTotalVmiSettleBaseQty()));
        }
        if (parentSaleEntryInfo.getUnVmiSettleBaseQty() != null && childSaleEntryInfo.getUnVmiSettleBaseQty() != null) {
            parentSaleEntryInfo.setUnVmiSettleBaseQty(parentSaleEntryInfo.getUnVmiSettleBaseQty().add(childSaleEntryInfo.getUnVmiSettleBaseQty()));
        }
        if (parentSaleEntryInfo.getUnSettleBaseQty() != null && childSaleEntryInfo.getUnSettleBaseQty() != null) {
            parentSaleEntryInfo.setUnSettleBaseQty(parentSaleEntryInfo.getUnSettleBaseQty().add(childSaleEntryInfo.getUnSettleBaseQty()));
        }
        if (parentSaleEntryInfo.getUnSettleQty() != null && childSaleEntryInfo.getUnSettleQty() != null) {
            parentSaleEntryInfo.setUnSettleQty(parentSaleEntryInfo.getUnSettleQty().add(childSaleEntryInfo.getUnSettleQty()));
        }
        if (isInTax) {
            parentSaleEntryInfo.setAmount(parentSaleEntryInfo.getAmount().add(childSaleEntryInfo.getAmount()));
            parentSaleEntryInfo.setTaxPrice(BigDecimal.ZERO);
        } else {
            parentSaleEntryInfo.setNonTaxAmount(parentSaleEntryInfo.getNonTaxAmount().add(childSaleEntryInfo.getNonTaxAmount()));
            parentSaleEntryInfo.setPrice(BigDecimal.ZERO);
        }
        parentSaleEntryInfo.setActualCost(parentSaleEntryInfo.getActualCost().add(childSaleEntryInfo.getActualCost()));
        parentSaleEntryInfo.setUnInQty(parentSaleEntryInfo.getUnInQty().add(childSaleEntryInfo.getUnInQty()));
        parentSaleEntryInfo.setUnInBaseQty(parentSaleEntryInfo.getUnInBaseQty().add(childSaleEntryInfo.getUnInBaseQty()));
        parentSaleEntryInfo.setAssociateBaseQty(parentSaleEntryInfo.getAssociateBaseQty().add(childSaleEntryInfo.getAssociateBaseQty()));
        parentSaleEntryInfo.setUnReturnedBaseQty(parentSaleEntryInfo.getUnReturnedBaseQty().add(childSaleEntryInfo.getUnReturnedBaseQty()));
        parentSaleEntryInfo.setReturnsQty(parentSaleEntryInfo.getReturnsQty().add(childSaleEntryInfo.getReturnsQty()));
        parentSaleEntryInfo.setReturnBaseQty(parentSaleEntryInfo.getReturnBaseQty().add(childSaleEntryInfo.getReturnBaseQty()));
        parentSaleEntryInfo.setReverseQty(parentSaleEntryInfo.getReverseQty().add(childSaleEntryInfo.getReverseQty()));
        parentSaleEntryInfo.setReverseBaseQty(parentSaleEntryInfo.getReverseBaseQty().add(childSaleEntryInfo.getReverseBaseQty()));
        parentSaleEntryInfo.setTotalInWarehsQty(parentSaleEntryInfo.getTotalInWarehsQty().add(childSaleEntryInfo.getTotalInWarehsQty()));
    }

    private void deletePurOrder(Context ctx, PurInWarehsEntryCollection childPurCollection) throws EASBizException, BOSException {
        HashSet<String> orderSet = new HashSet<String>();
        for (int j = 0; j < childPurCollection.size(); ++j) {
            orderSet.add(childPurCollection.get(j).getPurOrder());
        }
        IObjectPK[] deletePK = new IObjectPK[orderSet.size()];
        Iterator it = orderSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            String billId = (String)it.next();
            deletePK[i] = new ObjectUuidPK(billId);
            ++i;
        }
        PurOrderFactory.getLocalInstance((Context)ctx).deleteBatchData(deletePK);
    }

    private String getDiffInfoByEntryId(Context ctx, Set idSet, String bosType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        selectors.add(new SelectorItemInfo("parent.number"));
        selectors.add(new SelectorItemInfo("taxPrice"));
        selectors.add(new SelectorItemInfo("material.number"));
        selectors.add(new SelectorItemInfo("material.name"));
        SorterItemCollection selector = new SorterItemCollection();
        selector.add(new SorterItemInfo("parent.id"));
        view.setSorter(selector);
        view.setSelector(selectors);
        BigDecimal taxPrice = BigDecimal.ZERO;
        if ("783061E3".equals(bosType)) {
            PurInWarehsEntryCollection purEntryCollection = PurInWarehsEntryFactory.getLocalInstance(ctx).getPurInWarehsEntryCollection(view);
            StringBuffer bf = new StringBuffer();
            for (int i = 0; i < purEntryCollection.size(); ++i) {
                bf.append(purEntryCollection.get(i).getParent().getNumber());
                bf.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"material", (Locale)ctx.getLocale()));
                bf.append(":");
                bf.append(purEntryCollection.get(i).getMaterial().getNumber());
                bf.append(purEntryCollection.get(i).getMaterial().getName());
                bf.append(",");
                bf.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"taxPrice", (Locale)ctx.getLocale()));
                bf.append(":");
                taxPrice = BigDecimal.ZERO;
                if (purEntryCollection.get(i).getTaxPrice().compareTo(BigDecimal.ZERO) != 0) {
                    taxPrice = purEntryCollection.get(i).getTaxPrice();
                }
                bf.append(taxPrice.toPlainString());
                bf.append("\n");
            }
            return bf.toString();
        }
        SaleIssueEntryCollection saleEntryCollection = SaleIssueEntryFactory.getLocalInstance(ctx).getSaleIssueEntryCollection(view);
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < saleEntryCollection.size(); ++i) {
            bf.append(saleEntryCollection.get(i).getParent().getNumber());
            bf.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"material", (Locale)ctx.getLocale()));
            bf.append(":");
            bf.append(saleEntryCollection.get(i).getMaterial().getNumber());
            bf.append(saleEntryCollection.get(i).getMaterial().getName());
            bf.append(",");
            bf.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"taxPrice", (Locale)ctx.getLocale()));
            bf.append(":");
            taxPrice = BigDecimal.ZERO;
            if (saleEntryCollection.get(i).getTaxPrice().compareTo(BigDecimal.ZERO) != 0) {
                taxPrice = saleEntryCollection.get(i).getTaxPrice();
            }
            bf.append(taxPrice);
            bf.append("\n");
        }
        return bf.toString();
    }

    @Override
    protected HashMap _judgeUnitPriceAndAccountIsConsist(Context ctx, String motherId, Set childIdSet, String bosType) throws BOSException, EASBizException {
        AbstractObjectCollection purChildEntryCollection;
        AbstractObjectCollection purEntryCollection;
        boolean flag;
        List list = new ArrayList();
        list = this.buildTree(motherId, bosType, ctx);
        if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType) && !(flag = this.compareAccountAndUnitPrice(ctx, (IObjectCollection)(purEntryCollection = this.getMotherBillEntryCollection(ctx, motherId)), (IObjectCollection)(purChildEntryCollection = this.getChildBillEntryCollection(ctx, childIdSet)), list, bosType))) {
            this.checkMap.put("same", "no");
        }
        if (SCMConstant.BOSTYPE_SALEISSUE.equals(bosType) && !(flag = this.compareAccountAndUnitPrice(ctx, (IObjectCollection)(purEntryCollection = this.getSaleMotherBillEntryCollection(ctx, motherId)), (IObjectCollection)(purChildEntryCollection = this.getSaleChildBillEntryCollection(ctx, childIdSet)), list, bosType))) {
            this.checkMap.put("same", "no");
        }
        return this.checkMap;
    }

    private String getDiffAccountViewInfoByEntryId(Context ctx, Set idSet, String bosType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        selectors.add(new SelectorItemInfo("parent.number"));
        selectors.add(new SelectorItemInfo("material.number"));
        selectors.add(new SelectorItemInfo("material.name"));
        SorterItemCollection selector = new SorterItemCollection();
        selector.add(new SorterItemInfo("parent.id"));
        view.setSorter(selector);
        if ("783061E3".equals(bosType)) {
            selectors.add(new SelectorItemInfo("accountViewIn.number"));
            selectors.add(new SelectorItemInfo("accountViewIn.name"));
            view.setSelector(selectors);
            PurInWarehsEntryCollection purEntryCollection = PurInWarehsEntryFactory.getLocalInstance(ctx).getPurInWarehsEntryCollection(view);
            StringBuffer bf = new StringBuffer();
            for (int i = 0; i < purEntryCollection.size(); ++i) {
                bf.append(purEntryCollection.get(i).getParent().getNumber());
                bf.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"material", (Locale)ctx.getLocale()));
                bf.append(":");
                bf.append(purEntryCollection.get(i).getMaterial().getNumber());
                bf.append(purEntryCollection.get(i).getMaterial().getName());
                bf.append("\n");
            }
            return bf.toString();
        }
        selectors.add(new SelectorItemInfo("accountViewOut.number"));
        selectors.add(new SelectorItemInfo("accountViewOut.name"));
        view.setSelector(selectors);
        SaleIssueEntryCollection saleEntryCollection = SaleIssueEntryFactory.getLocalInstance(ctx).getSaleIssueEntryCollection(view);
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < saleEntryCollection.size(); ++i) {
            bf.append(saleEntryCollection.get(i).getParent().getNumber());
            bf.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"material", (Locale)ctx.getLocale()));
            bf.append(":");
            bf.append(saleEntryCollection.get(i).getMaterial().getNumber());
            bf.append(saleEntryCollection.get(i).getMaterial().getName());
            bf.append("\n");
        }
        return bf.toString();
    }

    protected void dropTempTable(String tableName, Context ctx) throws BOSException {
        this.handleRelease(ctx, tableName);
        super.dropTempTable(tableName, ctx);
    }

    private void handleLock(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuilder sb = new StringBuilder(100);
        sb.append("SELECT FID FROM ").append(tempTable);
        sb.append(" WHERE FSTATUS IS NOT NULL");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList<String> idLockList = new ArrayList<String>();
        ArrayList<String> thisLockList = new ArrayList<String>();
        ArrayList<String> otherLockList = new ArrayList<String>();
        String id = null;
        try {
            while (rs.next()) {
                id = rs.getString("FID");
                idLockList.add(id);
                idLockList.add(id + "/DAP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestLockMap = iMutexServiceControl.batchRequestObjIDForUpdate(idLockList);
        int size = idLockList.size();
        for (int i = 0; i < size; ++i) {
            id = (String)idLockList.get(i);
            if (((Boolean)requestLockMap.get(id)).booleanValue()) {
                thisLockList.add(id);
                continue;
            }
            otherLockList.add(id);
        }
        if (!otherLockList.isEmpty()) {
            iMutexServiceControl.batchReleaseObjIDForUpdate(thisLockList);
            throw new SplitBillException(SplitBillException.BILLLOCK);
        }
    }

    private void handleRelease(Context ctx, String tempTable) throws BOSException {
        StringBuilder sb = new StringBuilder(100);
        sb.append("SELECT FID FROM ").append(tempTable);
        sb.append(" WHERE FSTATUS IS NOT NULL");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList<String> idLockList = new ArrayList<String>();
        String id = null;
        try {
            while (rs.next()) {
                id = rs.getString("FID");
                idLockList.add(id);
                idLockList.add(id + "/DAP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        iMutexServiceControl.batchReleaseObjIDForUpdate(idLockList);
    }

    private String getMotherAndChildInfo(Context ctx, String motherId, Set idSet, String bosType) throws EASBizException, BOSException {
        StringBuffer bf = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("number"));
        view.setSelector(sics);
        view.setFilter(filterInfo);
        if (bosType.equals(SCMConstant.BOSTYPE_PURINWAREHS)) {
            PurInWarehsBillInfo purInWarehsBillInfo = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(motherId), sics);
            PurInWarehsBillCollection purInWarehsBillCollection = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(view);
            StringBuffer s = new StringBuffer();
            s.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"Mother", (Locale)ctx.getLocale()));
            s.append(":");
            s.append(purInWarehsBillInfo.getNumber());
            s.append(";");
            s.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"child", (Locale)ctx.getLocale()));
            s.append(":");
            for (int i = 0; i < purInWarehsBillCollection.size() - 1; ++i) {
                s.append(purInWarehsBillCollection.get(i).getNumber());
                s.append(",");
            }
            s.append(purInWarehsBillCollection.get(purInWarehsBillCollection.size() - 1).getNumber());
            return s.toString();
        }
        SaleIssueBillInfo saleIssueBillInfo = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(motherId), sics);
        SaleIssueBillCollection saleIssueBillCollection = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillCollection(view);
        StringBuffer s = new StringBuffer();
        s.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"Mother", (Locale)ctx.getLocale()));
        s.append(":");
        s.append(saleIssueBillInfo.getNumber());
        s.append(";");
        s.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"child", (Locale)ctx.getLocale()));
        s.append(":");
        for (int i = 0; i < saleIssueBillCollection.size() - 1; ++i) {
            s.append(saleIssueBillCollection.get(i).getNumber());
            s.append(",");
        }
        s.append(saleIssueBillCollection.get(saleIssueBillCollection.size() - 1).getNumber());
        return s.toString();
    }

    private String getChildInfo(Context ctx, Set idSet, String bosType) throws EASBizException, BOSException {
        StringBuffer bf = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("number"));
        view.setSelector(sics);
        view.setFilter(filterInfo);
        if (bosType.equals(SCMConstant.BOSTYPE_PURINWAREHS)) {
            PurInWarehsBillCollection purInWarehsBillCollection = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(view);
            StringBuffer s = new StringBuffer();
            s.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"child", (Locale)ctx.getLocale()));
            s.append(":");
            for (int i = 0; i < purInWarehsBillCollection.size() - 1; ++i) {
                s.append(purInWarehsBillCollection.get(i).getNumber());
                s.append(",");
            }
            s.append(purInWarehsBillCollection.get(purInWarehsBillCollection.size() - 1).getNumber());
            return s.toString();
        }
        SaleIssueBillCollection saleIssueBillCollection = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillCollection(view);
        StringBuffer s = new StringBuffer();
        s.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.MergeSplitedResource", (String)"child", (Locale)ctx.getLocale()));
        s.append(":");
        for (int i = 0; i < saleIssueBillCollection.size() - 1; ++i) {
            s.append(saleIssueBillCollection.get(i).getNumber());
            s.append(",");
        }
        s.append(saleIssueBillCollection.get(saleIssueBillCollection.size() - 1).getNumber());
        return s.toString();
    }

    class FieldInfo {
        private String name;
        private String dataType;
        private int width;
        private boolean isHide;
        private String resKey;
        private String format;

        FieldInfo() {
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getResKey() {
            return this.resKey;
        }

        public void setResKey(String resKey) {
            this.resKey = resKey;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public boolean isHide() {
            return this.isHide;
        }

        public void setHide(boolean isHide) {
            this.isHide = isHide;
        }
    }
}

