/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMoveInWarehsBillControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MoveInWarehsBillControllerBean
extends AbstractMoveInWarehsBillControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selects = new SelectorItemCollection();
        selects.add(new SelectorItemInfo("receiptCompanyOrgUnit.CU"));
        MoveInWarehsBillInfo bill = MoveInWarehsBillFactory.getLocalInstance(ctx).getMoveInWarehsBillInfo(pk, selects);
        return bill.getReceiptCompanyOrgUnit();
    }

    @Override
    protected boolean isCheckSourceBill() {
        return true;
    }

    @Override
    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.dealBillCost(ctx, model);
        super.update(ctx, pk, model);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dealBillCost(Context ctx, CoreBaseInfo model) throws BOSException {
        MoveInWarehsBillInfo info = (MoveInWarehsBillInfo)model;
        MoveInWarehsBillEntryInfo entry = null;
        MoveInWarehsBillEntryCollection entries = info.getEntry();
        BigDecimal totalActualCost = new BigDecimal("0.00");
        StringBuffer bf = new StringBuffer();
        bf.append("select entry.FReverseQty as reverseQty");
        bf.append(" ,entry.freverseBaseQty as reverseBaseQty");
        bf.append(" ,entry.fbaseQty as baseQty");
        bf.append(" ,entry.funitActualCost as unitActualCost");
        bf.append(" ,entry.factualCost as actualCost");
        bf.append(" from T_IM_MoveInWarehsBill bill");
        bf.append(" inner join T_IM_MoveInWarehsBillEntry entry");
        bf.append(" on bill.fid=entry.fparentid");
        bf.append(" where entry.fid=?");
        String sql = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        ResultSet rs = null;
        try {
            BigDecimal actualCost;
            conn = this.getConnection(ctx);
            pm = conn.prepareStatement(sql);
            int length = entries.size();
            for (int i = 0; i < length; totalActualCost = totalActualCost.add(actualCost), ++i) {
                entry = entries.get(i);
                actualCost = null != entry.getActualCost() ? entry.getActualCost() : new BigDecimal("0.00");
                BigDecimal unitActualCost = null != entry.getUnitActualCost() ? entry.getUnitActualCost() : new BigDecimal("0.00");
                entry.setActualCost(actualCost);
                entry.setUnitActualCost(unitActualCost);
                pm.setString(1, entry.getId().toString());
                rs = pm.executeQuery();
                if (!rs.next()) continue;
                BigDecimal reverseQty = rs.getBigDecimal("reverseQty");
                entry.setReverseQty(reverseQty);
                entry.setReverseBaseQty(rs.getBigDecimal("reverseBaseQty"));
            }
            info.setTotalActualCost(totalActualCost);
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pm, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectPK _transferAutoSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("autoTransfer") != null) {
            WfEventListenerStateManager wfManager = WfEventListenerStateManager.getInstance();
            try {
                if (wfManager.isEnable()) {
                    wfManager.disableEventListener();
                }
                IObjectPK iObjectPK = this._submit(ctx, model);
                return iObjectPK;
            }
            finally {
                if (wfManager.isEnable()) {
                    wfManager.enableEventListener();
                }
            }
        }
        return this._submit(ctx, model);
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e000-0172c0a812fd463ED552";
    }

    @Override
    protected void _checkIsHaveDestBills(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        MoveInWarehsBillInfo movInInfo = (MoveInWarehsBillInfo)aInvBillBaseInfo;
        if (movInInfo.isIsSysBill()) {
            throw new InvBizException(InvBizException.VISUALBILLNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
        }
        super._checkIsHaveDestBills(ctx, aInvBillBaseInfo);
    }

    @Override
    protected boolean isCheckMaterialInventory() {
        return true;
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        super._batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        int i;
        if (collection == null || collection.size() == 0) {
            return;
        }
        MoveInWarehsBillInfo moveInwarehsBillInfo = null;
        int n = collection.size();
        for (i = 0; i < n; ++i) {
            moveInwarehsBillInfo = (MoveInWarehsBillInfo)collection.getObject(i);
            this.calByUnitSource(ctx, moveInwarehsBillInfo, (IObjectCollection)moveInwarehsBillInfo.getEntry());
            int amtPrecesion = this.getAmtPrecision(ctx, moveInwarehsBillInfo.getReceiptCompanyOrgUnit());
            MoveInWarehsBillEntryCollection entrys = moveInwarehsBillInfo.getEntry();
            for (int j = 0; j < entrys.size(); ++j) {
                MoveInWarehsBillEntryInfo entry = entrys.get(j);
                if (entry.getPrice() == null) continue;
                BigDecimal amount = entry.getPrice().multiply(entry.getQty()).setScale(amtPrecesion, RoundingMode.HALF_UP);
                entry.setAmount(amount);
            }
        }
        super._handleAfterTransform(ctx, action, collection);
        n = collection.size();
        for (i = 0; i < n; ++i) {
            moveInwarehsBillInfo = (MoveInWarehsBillInfo)collection.getObject(i);
            this._fillLotFrame(ctx, (IObjectValue)moveInwarehsBillInfo);
        }
    }

    private int getAmtPrecision(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        int amtPrecision = 4;
        if (company != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("precision");
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()), selector);
            if (currency != null) {
                amtPrecision = currency.getPrecision();
            }
        }
        return amtPrecision;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getMoveInWarehsBillSelector((boolean)true);
    }

    @Override
    protected TransactionTypeInfo getDefaultBotpTransaction(Context ctx, InvBillBaseInfo info) throws BOSException, EASBizException {
        return super.getDefaultBotpTransaction(ctx, info);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MoveInWarehsBillInfo info = this.getMoveInWarehsBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MoveInWarehsBillInfo info = this.getMoveInWarehsBillInfo(ctx, pk, this.getSelector());
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        MoveInWarehsBillInfo info = this.getMoveInWarehsBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        MoveInWarehsBillEntryInfo moveInwarehsBillEntryInfo = (MoveInWarehsBillEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = moveInwarehsBillEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = moveInwarehsBillEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = moveInwarehsBillEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)moveInwarehsBillEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)moveInwarehsBillEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        moveInwarehsBillEntryInfo.setQty(qty);
        MoveInWarehsBillInfo moveInwarehsBillInfo = (MoveInWarehsBillInfo)scmBillBaseInfo;
        this.reCalCost4UnitSource(ctx, moveInwarehsBillInfo, moveInwarehsBillEntryInfo, sourceUnitId);
    }
}

