/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.basedatautil.master.OrgUnitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMoveInWarehsWebFacadeControllerBean;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class MoveInWarehsWebFacadeControllerBean
extends AbstractMoveInWarehsWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MoveInWarehsWebFacadeControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    public IObjectValue createNewData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou = null;
        StorageOrgUnitInfo sou = null;
        PeriodInfo periodInfo = null;
        MoveInWarehsBillInfo info = new MoveInWarehsBillInfo();
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        sou = (StorageOrgUnitInfo)this.getDefaultMainBizOrg(ctx);
        if (sou == null) {
            return info;
        }
        cou = OrgUnitUtil.getCompanyFromStorage((Context)ctx, (StorageOrgUnitInfo)sou);
        if (cou != null) {
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        }
        info.setBizDate(new Date());
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setStorageOrgUnit(sou);
        info.setCreator(userInfo);
        info.setCreateTime(new Timestamp(new Date().getTime()));
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e003-3152c0a812fd463ED552"));
        info.setBillType(billTypeInfo);
        if (periodInfo != null) {
            info.setYear(periodInfo.getPeriodYear());
            info.setPeriod(periodInfo.getPeriodNumber());
        } else {
            info.setYear(Calendar.getInstance().get(1));
            info.setPeriod(Calendar.getInstance().get(3));
        }
        if (info.getEntry() != null) {
            MoveInWarehsBillEntryInfo entry = null;
            for (int i = 0; i < 5; ++i) {
                entry = (MoveInWarehsBillEntryInfo)this.createNewDetailData(ctx, model);
                info.getEntry().add(entry);
            }
        }
        return info;
    }

    public IObjectValue createNewDetailData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        MoveInWarehsBillEntryInfo entry = new MoveInWarehsBillEntryInfo();
        entry.setBaseQty(ZERO);
        entry.setAssistQty(ZERO);
        entry.setUnitStandardCost(ZERO);
        entry.setStandardCost(ZERO);
        entry.setUnitActualCost(ZERO);
        entry.setActualCost(ZERO);
        entry.setPrice(ZERO);
        entry.setAmount(ZERO);
        return entry;
    }

    public Map getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        Map initData = super.getInitData(ctx, model, oprtState);
        MoveInWarehsBillInfo info = (MoveInWarehsBillInfo)model;
        if (info.getStorageOrgUnit() == null) {
            return initData;
        }
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, info.getStorageOrgUnit().getId().toString());
        initData.put("cou", cou);
        initData.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        initData.put("currentPeriodinfo", currentPeriodinfo);
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        if (info.getSourceBillType() != null && "ADDNEW".equals(oprtState)) {
            info.setCreator(userInfo);
            info.setCreateTime(new Timestamp(new Date().getTime()));
        }
        info.setCU(info.getStorageOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new MoveInWarehsBillInfo(), info.getStorageOrgUnit().getId().toString());
        if (ruleInfo != null) {
            initData.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                initData.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getStorageOrgUnit().getId().toString()));
            }
        }
        Map paramMap = this.batchGetParamValue(ctx, info.getStorageOrgUnit().getId().toString(), new String[]{"INM004", "INM008"});
        initData.put("params", paramMap);
        return initData;
    }

    public Map batchGetParamValue(Context ctx, String orgId, String[] numbers) throws EASBizException, BOSException {
        return ParamManager.getParamHashMap((Context)ctx, (String[])numbers, (String)orgId);
    }

    protected ISCMBillBase getLocalInstance(Context ctx) throws BOSException {
        return MoveInWarehsBillFactory.getLocalInstance(ctx);
    }

    public String getPermissionItem() {
        if (OprtStateConstant.ADDNEW.equals(this.oprtState)) {
            return "moveinwarehs_new";
        }
        if (OprtStateConstant.EDIT.equals(this.oprtState)) {
            return "moveinwarehs_update";
        }
        if (OprtStateConstant.VIEW.equals(this.oprtState)) {
            return "moveinwarehs_view";
        }
        return "moveinwarehs_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public String getMainOrgUnitName() {
        return "storageOrgUnit";
    }
}

