/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMoveIssueWebFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MoveIssueWebFacadeControllerBean
extends AbstractMoveIssueWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MoveIssueWebFacadeControllerBean");

    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MoveIssueBillInfo billInfo = (MoveIssueBillInfo)model;
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-016ec0a812fd463ED552"));
        billInfo.setBillType(billType);
        billInfo.setCreator(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
        Timestamp date = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        billInfo.setBizDate(date);
        billInfo.setCreateTime(date);
        billInfo.setAuditTime(null);
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        billInfo.setTotalActualCost(BigDecimal.ZERO);
        billInfo.setTotalStandardCost(BigDecimal.ZERO);
        billInfo.setFiVouchered(false);
        billInfo.setVoucher(null);
        billInfo.setTotalQty(BigDecimal.ZERO);
        StorageOrgUnitInfo sou = null;
        sou = billInfo.getStorageOrgUnit() != null ? billInfo.getStorageOrgUnit() : (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "moveissue_new");
        if (sou == null) {
            return billInfo;
        }
        if (sou.getCU() != null) {
            billInfo.setCU(sou.getCU());
        }
        billInfo.setStorageOrgUnit(sou);
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, sou.getId().toString());
        if (cou != null) {
            billInfo.setStorageOrgUnit(sou);
            billInfo.setIssueCompanyOrgUnit(cou);
            billInfo.setReceiptCompanyOrgUnit(cou);
        }
        MoveIssueBillEntryInfo entryInfo = null;
        entryInfo = (MoveIssueBillEntryInfo)this.createNewDetailData(ctx, model);
        if (cou != null) {
            entryInfo.setStorageOrgUnit(sou);
            entryInfo.setCompanyOrgUnit(cou);
        }
        billInfo.getEntry().add(entryInfo);
        return billInfo;
    }

    public IObjectValue createNewDetailData(Context context, IObjectValue model) throws BOSException, EASBizException {
        MoveIssueBillEntryInfo entry = new MoveIssueBillEntryInfo();
        entry.setReverseQty(BigDecimal.ZERO);
        entry.setReturnsQty(BigDecimal.ZERO);
        entry.setAssociateQty(BigDecimal.ZERO);
        entry.setActualCost(BigDecimal.ZERO);
        entry.setStandardCost(BigDecimal.ZERO);
        entry.setTotalInWarehsQty(BigDecimal.ZERO);
        if (entry.getBaseQty() == null) {
            entry.setBaseQty(BigDecimal.ZERO);
        }
        if (entry.getUnitActualCost() == null) {
            entry.setUnitActualCost(BigDecimal.ZERO);
        }
        if (entry.getAssistQty() == null) {
            entry.setAssistQty(BigDecimal.ZERO);
        }
        entry.setIsPresent(false);
        return entry;
    }

    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MoveIssueBillInfo info = (MoveIssueBillInfo)model;
        String storageOrgFilter = this.getMainOrgFilter(ctx);
        map.put("storageOrgFilter", storageOrgFilter);
        if (info.getStorageOrgUnit() == null) {
            return map;
        }
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(info.getStorageOrgUnit().getId().toString());
        map.put("bizOrgCUID", bizOrgCUID);
        CompanyOrgUnitInfo cou = null;
        cou = this.getCouBySou(ctx, info.getStorageOrgUnit().getId().toString());
        map.put("cou", cou);
        map.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        Map paramMap = this.getParamsMap(ctx, info.getStorageOrgUnit().getId().toString(), cou.getId().toString());
        map.put("params", paramMap);
        info.setCU(info.getStorageOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new MoveIssueBillInfo(), info.getStorageOrgUnit().getId().toString());
        if (ruleInfo != null) {
            map.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                map.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getStorageOrgUnit().getId().toString()));
            }
        }
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        map.put("currentPeriodinfo", currentPeriodinfo);
        return map;
    }

    public String getPermissionItem() {
        return "moveissue_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    protected Map _handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        String orgId = mainOrgId;
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, orgId);
        if (cou == null) {
            return responseMap;
        }
        responseMap.put("cou", cou);
        responseMap.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(orgId);
        responseMap.put("bizOrgCUID", bizOrgCUID);
        responseMap.put("params", this.getParamsMap(ctx, orgId, cou.getId().toString()));
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        responseMap.put("currentPeriodinfo", currentPeriodinfo);
        SaleIssueBillInfo info = new SaleIssueBillInfo();
        StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        info.setStorageOrgUnit(sou);
        info.setCU(sou.getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, orgId);
        if (ruleInfo != null) {
            responseMap.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (ruleInfo.isIsAddView()) {
                responseMap.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)info, orgId));
            }
        }
        return responseMap;
    }

    private Map getParamsMap(Context ctx, String souId, String couId) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map souParamMap = this.batchGetParamValue(ctx, souId, new String[]{"INM008", "INM004"});
        paramMap.putAll(souParamMap);
        Map couParamMap = this.batchGetParamValue(ctx, couId, new String[0]);
        paramMap.putAll(couParamMap);
        Map noOrgParamMap = this.batchGetParamValue(ctx, null, new String[0]);
        paramMap.putAll(noOrgParamMap);
        return paramMap;
    }
}

