/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.util.DataImportUtils;
import com.kingdee.eas.scm.im.inv.MoveLocationBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveLocationBillFactory;
import com.kingdee.eas.scm.im.inv.MoveLocationBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MoveLocationImport
extends InvDataImport {
    MoveLocationBillInfo moveLocationBillInfo = null;
    private static String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final int ASSISTPROPERTY = 3;
    private static final int ASSISTUNIT = 4;
    StorageOrgUnitInfo sou = null;
    AdminOrgUnitInfo adm = null;
    CompanyOrgUnitInfo cou = null;

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.moveLocationBillInfo = null;
        int k = 0;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            block8: {
                Map lineData = (Map)hsData.get(i);
                if (k == 0) {
                    try {
                        this.moveLocationBillInfo = this.transmitHead(lineData, ctx);
                        if (this.moveLocationBillInfo == null) {
                            return null;
                        }
                        this.afterBuildHead(ctx, this.moveLocationBillInfo, lineData);
                    }
                    catch (TaskExternalException ex) {
                        tex.addEntryErrorReason(i, ex.getMessage());
                        this.recycleNumber(ctx, this.moveLocationBillInfo);
                        break;
                    }
                }
                try {
                    MoveLocationBillEntryInfo entryinfo = this.transmitEntry(lineData, ctx);
                    int seq = this.moveLocationBillInfo.getEntry().size() + 1;
                    entryinfo.setSeq(seq);
                    entryinfo.setParent(this.moveLocationBillInfo);
                    entryinfo.setStorageOrgUnit(this.sou);
                    entryinfo.setCompanyOrgUnit(this.cou);
                    this.moveLocationBillInfo.getEntry().add(entryinfo);
                }
                catch (TaskExternalException ex) {
                    tex.addEntryErrorReason(i, ex.getMessage());
                    if (tex.getEntryErrorReasons().size() != 1) break block8;
                    this.recycleNumber(ctx, this.moveLocationBillInfo);
                }
            }
            ++k;
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.moveLocationBillInfo;
    }

    public int getSubmitType() {
        return 1;
    }

    private MoveLocationBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        Object description1;
        this.moveLocationBillInfo = new MoveLocationBillInfo();
        Object data = null;
        data = ((DataToken)lineData.get((Object)"FStorageOrgUnit_number")).data;
        this.sou = this.getStorageOrgUnit(ctx, "number", data);
        this.moveLocationBillInfo.setStorageOrgUnit(this.sou);
        this.cou = this.getCompanyOrgFromStorageOrg(ctx, this.sou);
        Object bizDate = ((DataToken)lineData.get((Object)"FBizDate")).data;
        if (bizDate == null || bizDate.toString().trim().length() <= 0) {
            throw new TaskExternalException(MoveLocationImport.getResource((Context)ctx, (String)"bizDateCanNotBeNull", (String)resources));
        }
        Date date = DataImportUtils.formatNationalDate((Context)ctx, (String)bizDate.toString());
        this.moveLocationBillInfo.setBizDate(date);
        Object reason = ((DataToken)lineData.get((Object)"FReason")).data;
        if (reason != null && reason.toString().trim().length() > 0) {
            String DeTemp = (String)reason;
            if (DeTemp.length() > 80) {
                DeTemp = DeTemp.substring(0, 80);
            }
            this.moveLocationBillInfo.setReason(DeTemp);
        } else {
            this.moveLocationBillInfo.setDescription("");
        }
        data = ((DataToken)lineData.get((Object)"FAdminOrgUnit_number")).data;
        AdminOrgUnitInfo info = this.getAdminOrgUnit(ctx, "number", data);
        this.moveLocationBillInfo.setAdminOrgUnit(info);
        Object descriptionObj = lineData.get("FDescription");
        if (null != descriptionObj && descriptionObj instanceof DataToken && (description1 = ((DataToken)descriptionObj).data) != null && description1.toString().trim().length() > 0) {
            String DeTemp = (String)description1;
            if (DeTemp.length() > 80) {
                DeTemp = DeTemp.substring(0, 80);
            }
            this.moveLocationBillInfo.setDescription(DeTemp);
        }
        this.moveLocationBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this.moveLocationBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        UserInfo creator = this.getCreator(ctx, data);
        this.moveLocationBillInfo.setCreator(creator);
        this.moveLocationBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"50957179-0105-1000-e001-1152c0a812fd463ED552"));
        this.moveLocationBillInfo.setBillType(billType);
        return this.moveLocationBillInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MoveLocationBillEntryInfo transmitEntry(Map lineData, Context ctx) throws TaskExternalException {
        StoreStateInfo storeState;
        String number;
        MoveLocationBillEntryInfo entryInfo = new MoveLocationBillEntryInfo();
        Object data = null;
        MaterialInfo materialInfo = new MaterialInfo();
        MeasureUnitInfo mui = new MeasureUnitInfo();
        MaterialInventoryInfo materialInventory = null;
        data = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
        materialInfo = this.getMaterial(ctx, data, resources, "MaterialNotExists", "MaterialNotExists", new OrgUnitInfo[]{this.sou, this.cou});
        entryInfo.setMaterial(materialInfo);
        materialInventory = this.getMaterialInventory(ctx, materialInfo, this.sou);
        if (this.checkLotInfo(ctx, entryInfo.getMaterial(), this.sou)) {
            data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
            if (data == null || data.toString().trim().length() <= 0) throw new TaskExternalException(materialInfo.getNumber() + MoveLocationImport.getResource((Context)ctx, (String)"LotManager", (String)resources));
            entryInfo.setLot(data.toString().trim());
        } else {
            entryInfo.setLot(null);
        }
        if (materialInventory.isIsPeriodValid()) {
            String lot = entryInfo.getLot();
            Date[] mfgAndExp = this.getMfgAndExp(ctx, materialInfo, lot, this.sou, lineData.get("FEntry_mfg"), lineData.get("FEntry_exp"));
            entryInfo.setMfg(mfgAndExp[0]);
            entryInfo.setExp(mfgAndExp[1]);
            if (entryInfo.getExp() == null || entryInfo.getMfg() == null) {
                throw new TaskExternalException(MoveLocationImport.getResource((Context)ctx, (String)"IsPeriodValidNoExpandMfg", (String)resources));
            }
        }
        data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
        mui = this.getMeasureUnit(ctx, data, materialInfo);
        entryInfo.setUnit(mui);
        data = ((DataToken)lineData.get((Object)"FEntry_qty")).data;
        if (data == null || data.toString().trim().length() <= 0) throw new TaskExternalException(MoveLocationImport.getResource((Context)ctx, (String)"Numbercannotbenull", (String)resources));
        try {
            BigDecimal qty = DataImportUtils.getDataDecimal((Context)ctx, (String)data.toString().trim(), (Integer)mui.getQtyPrecision());
            qty = qty.abs();
            entryInfo.setQty(qty);
        }
        catch (NumberFormatException e) {
            throw new TaskExternalException(MoveLocationImport.getResource((Context)ctx, (String)"FormatMustBeNumber", (String)resources));
        }
        try {
            MeasureUnitInfo assistMmu;
            entryInfo.setAssistUnit(materialInfo.getAssistUnit());
            if (entryInfo.getAssistUnit() != null && (assistMmu = entryInfo.getAssistUnit()) != null) {
                data = ((DataToken)lineData.get((Object)"FEntry_assistQty")).data;
                if (data != null && data.toString().trim().length() > 0) {
                    BigDecimal assiQty = DataImportUtils.getDataDecimal((Context)ctx, (String)data.toString().trim(), (Integer)assistMmu.getQtyPrecision());
                    assiQty = assiQty.abs();
                    entryInfo.setAssistQty(assiQty);
                }
                if (entryInfo.getAssistQty() == null || entryInfo.getAssistQty().compareTo(ZERO) == 0) {
                    BigDecimal qty = entryInfo.getQty();
                    BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty(ctx, mui, entryInfo.getAssistUnit(), materialInfo, qty);
                    entryInfo.setAssistQty(assisqtyQty);
                }
            }
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
        this.checkMaterialInfo(ctx, materialInfo, data, 3);
        if (data != null && (number = data.toString()) != null && number.trim().length() > 0) {
            AsstAttrValueInfo asstAttr = this.getAsstAttr(ctx, data, materialInfo.getAssistAttr());
            entryInfo.setAssistProperty(asstAttr);
        }
        if ((storeState = this.getStoreState(ctx, data = ((DataToken)lineData.get((Object)"FEntry$storeStatus_number")).data)) == null) {
            throw new TaskExternalException(MoveLocationImport.getResource((Context)ctx, (String)"storeStatusNull", (String)resources));
        }
        entryInfo.setStoreStatus(storeState);
        data = ((DataToken)lineData.get((Object)"FEntry$storeType_number")).data;
        StoreTypeInfo storeType = this.getStoreType(ctx, data);
        if (storeType == null) {
            throw new TaskExternalException(MoveLocationImport.getResource((Context)ctx, (String)"storeTypeNull", (String)resources));
        }
        entryInfo.setStoreType(storeType);
        WarehouseInfo warehouseInfo = new WarehouseInfo();
        data = ((DataToken)lineData.get((Object)"FEntry$warehouse_number")).data;
        warehouseInfo = this.getWarehouse(ctx, (OrgUnitInfo)this.sou, data);
        entryInfo.setWarehouse(warehouseInfo);
        data = ((DataToken)lineData.get((Object)"FEntry$stocker_number")).data;
        if (data == null || data.toString().trim().length() <= 0) {
            throw new TaskExternalException(MoveLocationImport.getResource((Context)ctx, (String)"stockerNotExists", (String)resources));
        }
        PersonInfo stocker = this.getStocker(ctx, data);
        entryInfo.setStocker(stocker);
        data = ((DataToken)lineData.get((Object)"FEntry$location_number")).data;
        LocationInfo locationInfo = this.getLocation(ctx, data, warehouseInfo);
        entryInfo.setLocation(locationInfo);
        data = ((DataToken)lineData.get((Object)"FEntry$receiptLocation_number")).data;
        LocationInfo receiptLocation = this.getLocation(ctx, data, warehouseInfo);
        entryInfo.setReceiptLocation(receiptLocation);
        data = ((DataToken)lineData.get((Object)"FEntry$customer_number")).data;
        CustomerInfo customer = this.getCustomer(ctx, data);
        entryInfo.setCustomer(customer);
        data = ((DataToken)lineData.get((Object)"FEntry$supplier_number")).data;
        SupplierInfo supplier = this.getSupplier(ctx, "number", data);
        entryInfo.setSupplier(supplier);
        Object o = ((DataToken)lineData.get((Object)"FEntry_remark")).data;
        if (o != null && o.toString().trim().length() > 0) {
            String remark = o.toString().trim().substring(0, 255);
            entryInfo.setRemark(remark);
        }
        MeasureUnitInfo baseUnit = materialInfo.getBaseUnit();
        entryInfo.setBaseUnit(baseUnit);
        try {
            BigDecimal qty = entryInfo.getQty();
            BigDecimal baseQty = InvAppUtils.getBaseUnitQty(ctx, mui, baseUnit, materialInfo, qty);
            entryInfo.setBaseQty(baseQty);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data;
        ProjectInfo project = this.getProject(ctx, data, this.sou.getCU());
        entryInfo.setProject(project);
        data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data;
        TrackNumberInfo trackNumber = this.getTrackNumber(ctx, data, this.sou.getCU());
        entryInfo.setTrackNumber(trackNumber);
        return entryInfo;
    }

    private void checkMaterialInfo(Context ctx, MaterialInfo materialInfo, Object data, int type) throws TaskExternalException {
        if (type == 3) {
            AsstAttrTypeInfo asstAttrTypeInfo = materialInfo.getAssistAttr();
            if (asstAttrTypeInfo == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + MoveLocationImport.getResource((Context)ctx, (String)"NotSetAssistProperty", (String)resources));
            }
            if (asstAttrTypeInfo != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + MoveLocationImport.getResource((Context)ctx, (String)"SetAssistProperty", (String)resources));
            }
        } else if (type == 4) {
            MeasureUnitInfo assistUnit = materialInfo.getAssistUnit();
            if (assistUnit == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + MoveLocationImport.getResource((Context)ctx, (String)"NotSetAssistUnit", (String)resources));
            }
            if (assistUnit != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + MoveLocationImport.getResource((Context)ctx, (String)"SetAssistUnit", (String)resources));
            }
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal qty;
            if (rs.getString("Number") != null) {
                result.put("FNumber", rs.getString("Number"));
            }
            if (rs.getString("BizDate") != null) {
                result.put("FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("BizDate")));
            }
            if (rs.getString("STORAGEORGUNIT1.NUMBER") != null) {
                result.put("FStorageOrgUnit_number", rs.getString("STORAGEORGUNIT1.NUMBER"));
            }
            if (rs.getString("STORAGEORGUNIT1.NAME") != null) {
                result.put("FStorageOrgUnit_name_l2", rs.getString("STORAGEORGUNIT1.NAME"));
            }
            if (rs.getString("ASSISTANTUNIT.NUMBER") != null) {
                result.put("FEntry$assistUnit_number", rs.getString("ASSISTANTUNIT.NUMBER"));
            }
            if (rs.getString("REASON") != null) {
                result.put("FReason", rs.getString("REASON"));
            }
            if (rs.getString("DESCRIPTION") != null) {
                result.put("FDescription", rs.getString("DESCRIPTION"));
            }
            if (rs.getString("MATERIAL.NUMBER") != null) {
                result.put("FEntry$material_number", rs.getString("MATERIAL.NUMBER"));
            }
            if (rs.getString("MATERIAL.NAME") != null) {
                result.put("FEntry$material_name_l2", rs.getString("MATERIAL.NAME"));
            }
            if (rs.getString("MATERIAL.MODEL") != null) {
                result.put("FEntry$material_model", rs.getString("MATERIAL.MODEL"));
            }
            if (rs.getString("ASSISTPROPERTY.NUMBER") != null) {
                result.put("FEntry$assistProperty_number", rs.getString("ASSISTPROPERTY.NUMBER"));
            }
            if (rs.getString("ENTRY.LOT") != null) {
                result.put("FEntry_lot", rs.getString("ENTRY.LOT"));
            }
            if (rs.getString("ENTRY.MFG") != null) {
                result.put("FEntry_mfg", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.MFG")));
            }
            if (rs.getString("ENTRY.EXP") != null) {
                result.put("FEntry_exp", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.EXP")));
            }
            if (rs.getString("UNIT.NUMBER") != null) {
                result.put("FEntry$unit_number", rs.getString("UNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.QTY") != null) {
                if ("".equalsIgnoreCase(this.transformValue(rs.getString("ENTRY.QTY")).toString()) || this.transformValue(rs.getString("ENTRY.QTY")).toString().length() < 1) {
                    result.put("FEntry_qty", this.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.QTY"));
                    result.put("FEntry_qty", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qty));
                }
            }
            if (rs.getString("ASSISTANTUNIT.NUMBER") != null) {
                result.put("FEntry$assistUnit_number", rs.getString("ASSISTANTUNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.ASSISTQTY") != null) {
                if ("".equalsIgnoreCase(this.transformValue(rs.getString("ENTRY.ASSISTQTY")).toString()) || this.transformValue(rs.getString("ENTRY.ASSISTQTY")).toString().length() < 1) {
                    result.put("FEntry_assistQty", this.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.ASSISTQTY"));
                    result.put("FEntry_assistQty", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qty));
                }
            }
            if (rs.getString("BASEUNIT.NUMBER") != null) {
                result.put("FEntry$baseUnit_number", rs.getString("BASEUNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.BASEQTY") != null) {
                if ("".equalsIgnoreCase(this.transformValue(rs.getString("ENTRY.BASEQTY")).toString()) || this.transformValue(rs.getString("ENTRY.BASEQTY")).toString().length() < 1) {
                    result.put("FEntry_baseQty", this.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.BASEQTY"));
                    result.put("FEntry_baseQty", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qty));
                }
            }
            if (rs.getString("STORESTATE.NUMBER") != null) {
                result.put("FEntry$storeStatus_number", rs.getString("STORESTATE.NUMBER"));
            }
            if (rs.getString("STORETYPE.NUMBER") != null) {
                result.put("FEntry$storeType_number", rs.getString("STORETYPE.NUMBER"));
            }
            if (rs.getString("WAREHOUSE.NUMBER") != null) {
                result.put("FEntry$warehouse_number", rs.getString("WAREHOUSE.NUMBER"));
            }
            if (rs.getString("STOCKER.NUMBER") != null) {
                result.put("FEntry$stocker_number", rs.getString("STOCKER.NUMBER"));
            }
            if (rs.getString("LOCATION.NUMBER") != null) {
                result.put("FEntry$location_number", rs.getString("LOCATION.NUMBER"));
            }
            if (rs.getString("RECEIPTLOCATION.NUMBER") != null) {
                result.put("FEntry$receiptLocation_number", rs.getString("RECEIPTLOCATION.NUMBER"));
            }
            if (rs.getString("CUSTOMER.NUMBER") != null) {
                result.put("FEntry$customer_number", rs.getString("CUSTOMER.NUMBER"));
            }
            if (rs.getString("SUPPLIER.NUMBER") != null) {
                result.put("FEntry$supplier_number", rs.getString("SUPPLIER.NUMBER"));
            }
            if (rs.getString("Entry.remark") != null) {
                result.put("FEntry_remark", rs.getString("Entry.remark"));
            }
            if (rs.getString("CreateTime") != null) {
                result.put("FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("CreateTime")));
            }
            if (rs.getString("Creator.number") != null) {
                result.put("FCreator_number", rs.getString("Creator.number"));
            }
            if (rs.getString("PROJECT.NUMBER") != null) {
                result.put("FEntry$project_number", rs.getString("PROJECT.NUMBER"));
            }
            if (rs.getString("TrackNumber.number") != null) {
                result.put("FEntry$trackNumber_number", rs.getString("TrackNumber.number"));
            }
        }
        catch (Exception Ex) {
            Logger.error((Throwable)Ex);
            throw new TaskExternalException("", (Throwable)Ex);
        }
        return result;
    }

    private Object transformValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.MoveLocationQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        return oldFilterInfo;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MoveLocationBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public String getImportPermissionItem() {
        return "movelocation_new";
    }
}

