/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.MoveLocationBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveLocationBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMoveLocationWebFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MoveLocationWebFacadeControllerBean
extends AbstractMoveLocationWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MoveLocationWebFacadeControllerBean");

    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MoveLocationBillInfo billInfo = (MoveLocationBillInfo)model;
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e001-1152c0a812fd463ED552"));
        billInfo.setBillType(aBillTypeInfo);
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        Timestamp serverDate = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        billInfo.setBizDate(serverDate);
        billInfo.setFiVouchered(false);
        billInfo.setAuditTime(null);
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        billInfo.setCreateTime(serverDate);
        billInfo.setCreator(aUserInfo);
        StorageOrgUnitInfo sou = null;
        sou = billInfo.getStorageOrgUnit() != null ? billInfo.getStorageOrgUnit() : (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "movelocation_new");
        if (sou == null) {
            return billInfo;
        }
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, sou.getId().toString());
        billInfo.setStorageOrgUnit(sou);
        MoveLocationBillEntryInfo aMoveLocationBillEntryInfo = null;
        aMoveLocationBillEntryInfo = (MoveLocationBillEntryInfo)this.createNewDetailData(ctx);
        aMoveLocationBillEntryInfo.setStorageOrgUnit(sou);
        aMoveLocationBillEntryInfo.setCompanyOrgUnit(cou);
        billInfo.getEntry().add(aMoveLocationBillEntryInfo);
        return billInfo;
    }

    public IObjectValue createNewDetailData(Context context) throws BOSException, EASBizException {
        MoveLocationBillEntryInfo entryInfo = new MoveLocationBillEntryInfo();
        entryInfo.setAssistQty(SCMConstant.BIGDECIMAL_ZERO);
        entryInfo.setAssociateQty(SCMConstant.BIGDECIMAL_ZERO);
        return entryInfo;
    }

    public Map handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        String orgId = mainOrgId;
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, orgId);
        if (cou == null) {
            return responseMap;
        }
        responseMap.put("cou", cou);
        responseMap.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(orgId);
        responseMap.put("bizOrgCUID", bizOrgCUID);
        responseMap.put("params", this.getParamsMap(ctx, orgId, cou.getId().toString()));
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        responseMap.put("currentPeriodinfo", currentPeriodinfo);
        MoveLocationBillInfo info = new MoveLocationBillInfo();
        StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        info.setStorageOrgUnit(sou);
        info.setCU(sou.getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, orgId);
        if (ruleInfo != null) {
            responseMap.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (ruleInfo.isIsAddView()) {
                responseMap.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)info, orgId));
            }
        }
        return responseMap;
    }

    public void initData(Context context, Map map, IObjectValue model) throws EASBizException, BOSException {
        super.initData(context, map, model);
        MoveLocationBillInfo billInfo = (MoveLocationBillInfo)model;
        map.put("sourceBillType", billInfo.getSourceBillType());
        if (billInfo.getStorageOrgUnit() != null) {
            String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)context).getCUID(billInfo.getStorageOrgUnit().getId().toString());
            map.put("bizOrgCUID", bizOrgCUID);
            CompanyOrgUnitInfo cou = null;
            cou = this.getCouBySou(context, billInfo.getStorageOrgUnit().getId().toString());
            map.put("cou", cou);
            Map paramMap = this.getParamsMap(context, billInfo.getStorageOrgUnit().getId().toString(), cou.getId().toString());
            map.put("params", paramMap);
            billInfo.setCU(billInfo.getStorageOrgUnit().getCU());
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)context);
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new MoveLocationBillInfo(), billInfo.getStorageOrgUnit().getId().toString());
            if (ruleInfo != null) {
                map.put("numberIsEdit", ruleInfo.isIsModifiable());
                if (billInfo.getSourceBillType() != null && billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                    map.put("addNewNumber", iCodingRuleManager.getNumber(model, billInfo.getStorageOrgUnit().getId().toString()));
                }
            }
        }
    }

    private Map getParamsMap(Context ctx, String souId, String couId) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map souParamMap = this.batchGetParamValue(ctx, souId, new String[]{"INM004", "INM100", "INM008"});
        paramMap.putAll(souParamMap);
        Map couParamMap = this.batchGetParamValue(ctx, couId, new String[]{"CONSIGNSALES", "AR_032"});
        paramMap.putAll(couParamMap);
        Map noOrgParamMap = this.batchGetParamValue(ctx, null, new String[]{"DISCOUNTRATEPRECISION"});
        paramMap.putAll(noOrgParamMap);
        return paramMap;
    }

    public String getMainOrgUnitName() {
        return "storageOrgUnit";
    }

    public String getPermissionItem() {
        if (OprtStateConstant.ADDNEW.equals(this.oprtState)) {
            return "movelocation_new";
        }
        if (OprtStateConstant.EDIT.equals(this.oprtState)) {
            return "movelocation_update";
        }
        if (OprtStateConstant.VIEW.equals(this.oprtState)) {
            return "movelocation_view";
        }
        return "movelocation_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }
}

