/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.loadmass.app.DataLoaderHelper;
import com.kingdee.eas.scm.im.inv.AbstractTransferRule3Info;
import com.kingdee.eas.scm.im.inv.AbstractTransferRule4Info;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Info;
import com.kingdee.eas.scm.im.inv.TransferRule3Info;
import com.kingdee.eas.scm.im.inv.TransferRule4Info;
import com.kingdee.eas.scm.im.inv.TransferRuleInfo;
import com.kingdee.eas.scm.im.inv.app.MultiSidesPriceBizDataVO;

public class MultiSidesPriceDataLoader {
    private Context ctx;
    private PriceParamInfo[] paramInfos;

    public MultiSidesPriceDataLoader(Context ctx, PriceParamInfo[] paramInfos) {
        this.ctx = ctx;
        this.paramInfos = paramInfos;
    }

    public MultiSidesPriceBizDataVO loadDataVO() throws EASBizException, BOSException {
        MultiSidesPriceBizDataVO dataVO = new MultiSidesPriceBizDataVO();
        this.loadTransferRule(dataVO);
        this.loadMaterialSalesInfo(dataVO);
        this.loadInternalCustomer(dataVO);
        this.loadIsInTaxParam(dataVO);
        this.loadBaseConvsRate(dataVO);
        this.loadCurrentPeriod(dataVO);
        return dataVO;
    }

    private void loadTransferRule(MultiSidesPriceBizDataVO dataVO) throws EASBizException, BOSException {
        if (this.ctx == null || this.paramInfos == null) {
            return;
        }
        String[] supplyRelationIds = new String[this.paramInfos.length];
        String bizTypeId = null;
        int length = this.paramInfos.length;
        for (int i = 0; i < length; ++i) {
            if (this.paramInfos[i] == null || this.paramInfos[i].getSupplyRelation() == null) continue;
            supplyRelationIds[i] = this.paramInfos[i].getSupplyRelation().getId().toString();
            if (bizTypeId != null) continue;
            bizTypeId = this.paramInfos[i].getBizTypeInfo().getId().toString();
        }
        dataVO.setMapTransferRule(DataLoaderHelper.loadTransferRule((Context)this.ctx, (String[])supplyRelationIds, bizTypeId));
    }

    private void loadMaterialSalesInfo(MultiSidesPriceBizDataVO dataVO) throws BOSException {
        Integer status = new Integer(1);
        String[] orgUnitIds = new String[this.paramInfos.length];
        String[] materialIds = new String[this.paramInfos.length];
        int length = this.paramInfos.length;
        for (int i = 0; i < length; ++i) {
            orgUnitIds[i] = null;
            PriceParamInfo paramInfo = this.paramInfos[i];
            if (paramInfo == null) continue;
            if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(paramInfo.getBizTypeInfo().getId().toString())) {
                if (paramInfo.getIssueSaleOrgUnitInfo() != null) {
                    orgUnitIds[i] = paramInfo.getIssueSaleOrgUnitInfo().getId().toString();
                }
            } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(paramInfo.getBizTypeInfo().getId().toString())) {
                if (paramInfo.getSupplySaleOrgUnitInfo() != null) {
                    orgUnitIds[i] = paramInfo.getSupplySaleOrgUnitInfo().getId().toString();
                }
            } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(paramInfo.getBizTypeInfo().getId().toString()) && paramInfo.getSupplySaleOrgUnitInfo() != null) {
                orgUnitIds[i] = paramInfo.getSupplySaleOrgUnitInfo().getId().toString();
            }
            materialIds[i] = paramInfo.getMateial().getId().toString();
        }
        dataVO.setMapMaterialSales(DataLoaderHelper.loadMaterialSales((Context)this.ctx, (String[])orgUnitIds, (String[])materialIds, (Integer)status));
    }

    private void loadInternalCustomer(MultiSidesPriceBizDataVO dataVO) throws BOSException {
        String[] companyIds = new String[this.paramInfos.length];
        int length = this.paramInfos.length;
        for (int i = 0; i < length; ++i) {
            if (this.paramInfos[i] == null) continue;
            SupplyRelationInfo srInfo = this.paramInfos[i].getSupplyRelation();
            if (this.paramInfos[i] == null || srInfo == null) continue;
            BizRoleTypeEnum bizRole = this.paramInfos[i].getBizRole();
            String bizTypeId = this.paramInfos[i].getBizTypeInfo().getId().toString();
            if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
                companyIds[i] = this.getOrgUnitId((OrgUnitInfo)srInfo.getReceiveCompanyOrgUnit());
                continue;
            }
            if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                if (bizRole.equals((Object)BizRoleTypeEnum.SupplySide)) {
                    companyIds[i] = this.getOrgUnitId((OrgUnitInfo)srInfo.getReceiveCompanyOrgUnit());
                    continue;
                }
                if (!bizRole.equals((Object)BizRoleTypeEnum.IssueSide)) continue;
                companyIds[i] = this.getOrgUnitId((OrgUnitInfo)srInfo.getSupplyCompanyOrgUnit());
                continue;
            }
            if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) continue;
            if (bizRole.equals((Object)BizRoleTypeEnum.IssueSide)) {
                companyIds[i] = this.getOrgUnitId((OrgUnitInfo)srInfo.getSupplyCompanyOrgUnit());
                continue;
            }
            if (bizRole.equals((Object)BizRoleTypeEnum.SupplySide)) {
                companyIds[i] = this.getOrgUnitId((OrgUnitInfo)srInfo.getRequireCompanyOrgUnit());
                continue;
            }
            if (!bizRole.equals((Object)BizRoleTypeEnum.RequireSide)) continue;
            companyIds[i] = this.getOrgUnitId((OrgUnitInfo)srInfo.getReceiveCompanyOrgUnit());
        }
        dataVO.setMapCustomer(DataLoaderHelper.loadInternalCustomer((Context)this.ctx, (String[])companyIds));
    }

    private void loadIsInTaxParam(MultiSidesPriceBizDataVO dataVO) throws PriceParamException, BOSException {
        String[] saleOrgIds = new String[this.paramInfos.length];
        int length = this.paramInfos.length;
        for (int i = 0; i < length; ++i) {
            TransferRuleInfo tri;
            if (this.paramInfos[i] == null || this.paramInfos[i].getBizTypeInfo() == null || this.paramInfos[i].getSupplyRelation() == null) continue;
            String bizTypeId = this.paramInfos[i].getBizTypeInfo().getId().toString();
            String supplyRelationId = this.paramInfos[i].getSupplyRelation().getId().toString();
            if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
                tri = (TransferRule2Info)dataVO.getMapTransferRule().get(supplyRelationId + bizTypeId);
                saleOrgIds[i] = tri == null ? null : this.getOrgUnitId((OrgUnitInfo)tri.getIssueSaleOrgUnit());
                continue;
            }
            if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                tri = (TransferRule3Info)dataVO.getMapTransferRule().get(supplyRelationId + bizTypeId);
                if (this.paramInfos[i].getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                    saleOrgIds[i] = tri == null ? null : this.getOrgUnitId((OrgUnitInfo)tri.getIssueSaleOrgUnit());
                    continue;
                }
                if (!this.paramInfos[i].getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) continue;
                saleOrgIds[i] = tri == null ? null : this.getOrgUnitId((OrgUnitInfo)((AbstractTransferRule3Info)tri).getSupplySaleOrgUnit());
                continue;
            }
            if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) continue;
            tri = (TransferRule4Info)dataVO.getMapTransferRule().get(supplyRelationId + bizTypeId);
            if (this.paramInfos[i].getBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                saleOrgIds[i] = tri == null ? null : this.getOrgUnitId((OrgUnitInfo)tri.getIssueSaleOrgUnit());
                continue;
            }
            if (this.paramInfos[i].getBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                saleOrgIds[i] = tri == null ? null : this.getOrgUnitId((OrgUnitInfo)((AbstractTransferRule4Info)tri).getSupplySaleOrgUnit());
                continue;
            }
            if (!this.paramInfos[i].getBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) continue;
            saleOrgIds[i] = tri == null ? null : this.getOrgUnitId((OrgUnitInfo)((AbstractTransferRule4Info)tri).getRequireSaleOrgUnit());
        }
        dataVO.setMapPolicyContainTax(DataLoaderHelper.loadIsInTax((Context)this.ctx, (String[])saleOrgIds));
    }

    private void loadBaseConvsRate(MultiSidesPriceBizDataVO dataVO) throws PriceParamException, BOSException {
        int length = this.paramInfos.length;
        String[] materialIds = new String[length * 2];
        String[] unitIds = new String[length * 2];
        for (int i = 0; i < length; ++i) {
            if (this.paramInfos[i] == null || this.paramInfos[i].getUnit() == null || this.paramInfos[i].getBaseUnit() == null || this.paramInfos[i].getMateial() == null || this.paramInfos[i].getUnit().getId().equals((Object)this.paramInfos[i].getBaseUnit().getId())) continue;
            materialIds[i + length] = materialIds[i] = this.paramInfos[i].getMateial().getId().toString();
            unitIds[i] = this.paramInfos[i].getUnit().getId().toString();
            unitIds[i + length] = this.paramInfos[i].getBaseUnit().getId().toString();
        }
        dataVO.setMapBaseConvsRate(DataLoaderHelper.loadBaseConvsRate((Context)this.ctx, (String[])materialIds, (String[])unitIds));
    }

    private void loadCurrentPeriod(MultiSidesPriceBizDataVO dataVO) throws PriceParamException, BOSException {
        int length = this.paramInfos.length;
        String[] companyIds = new String[length];
        for (int i = 0; i < length; ++i) {
            if (this.paramInfos[i] == null || this.paramInfos[i].getCompanyOrgUnit() == null) continue;
            if (this.paramInfos[i].getCostBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
                companyIds[i] = this.paramInfos[i].getCompanyOrgUnit().getId().toString();
                continue;
            }
            if (this.paramInfos[i].getCostBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
                companyIds[i] = this.paramInfos[i].getIssueCompanyOrgUnitInfo().getId().toString();
                continue;
            }
            if (!this.paramInfos[i].getCostBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) continue;
            companyIds[i] = this.paramInfos[i].getRequireCompanyOrgUnitInfo().getId().toString();
        }
        dataVO.setMapCurrenPeriod(DataLoaderHelper.loadCurrenPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (String[])companyIds));
    }

    private String getOrgUnitId(OrgUnitInfo orgUnit) {
        return orgUnit == null || orgUnit.getId() == null ? null : orgUnit.getId().toString();
    }
}

