/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.basedatautil.master.OrgUnitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractOtherIssueWebFacadeControllerBean;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtherIssueWebFacadeControllerBean
extends AbstractOtherIssueWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.OtherIssueWebFacadeControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    public IObjectValue createNewData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StorageOrgUnitInfo sou = null;
        CompanyOrgUnitInfo cou = null;
        PeriodInfo periodInfo = null;
        OtherIssueBillInfo info = new OtherIssueBillInfo();
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        info.setNumber(null);
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setBizDate(new Date());
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo(null, (String)"Nz878AEgEADgAABMwKg/GiQHQ1w=", (String)"50957179-0105-1000-e000-0177c0a812fd463ED552");
        info.setBizType(bizType);
        if (bizType != null) {
            TransactionTypeInfo tti = InvCommonUtils.getDefaultTransactionType(null, "50957179-0105-1000-e000-0177c0a812fd463ED552", bizType.getId().toString());
            info.setTransactionType(tti);
        }
        if ((sou = (StorageOrgUnitInfo)this.getDefaultMainBizOrg(ctx)) == null) {
            return info;
        }
        cou = OrgUnitUtil.getCompanyFromStorage((Context)ctx, (StorageOrgUnitInfo)sou);
        if (cou != null) {
            info.setStorageOrgUnit(sou);
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        }
        info.setCreator(userInfo);
        info.setCreateTime(new Timestamp(new Date().getTime()));
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0177c0a812fd463ED552"));
        info.setBillType(billTypeInfo);
        if (periodInfo != null) {
            info.setYear(periodInfo.getPeriodYear());
            info.setPeriod(periodInfo.getPeriodNumber());
        } else {
            info.setYear(Calendar.getInstance().get(1));
            info.setPeriod(Calendar.getInstance().get(3));
        }
        if (info.getEntry() != null) {
            OtherIssueBillEntryInfo entry = null;
            for (int i = 0; i < 5; ++i) {
                entry = (OtherIssueBillEntryInfo)this.createNewDetailData(ctx, model);
                entry.setStorageOrgUnit(sou);
                info.getEntry().add(entry);
            }
        }
        info.setCU(info.getStorageOrgUnit().getCU());
        return info;
    }

    public IObjectValue createNewDetailData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        OtherIssueBillEntryInfo entry = new OtherIssueBillEntryInfo();
        entry.setBaseQty(ZERO);
        entry.setAssistQty(ZERO);
        entry.setUnitStandardCost(ZERO);
        entry.setStandardCost(ZERO);
        entry.setUnitActualCost(ZERO);
        entry.setActualCost(ZERO);
        entry.setPrice(ZERO);
        entry.setAmount(ZERO);
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        entry.setIsPresent(false);
        return entry;
    }

    public Map getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        Map initData = super.getInitData(ctx, model, oprtState);
        OtherIssueBillInfo info = (OtherIssueBillInfo)model;
        if (info.getStorageOrgUnit() == null) {
            return initData;
        }
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, info.getStorageOrgUnit().getId().toString());
        initData.put("cou", cou);
        initData.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        info.setCU(info.getStorageOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new OtherIssueBillInfo(), info.getStorageOrgUnit().getId().toString());
        if (ruleInfo != null) {
            initData.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                initData.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getStorageOrgUnit().getId().toString()));
            }
        }
        Map paramMap = this.batchGetParamValue(ctx, info.getStorageOrgUnit().getId().toString(), new String[]{"INM004", "INM008"});
        initData.put("params", paramMap);
        boolean costManageIsStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.COSTMANAGEMENT, (CompanyOrgUnitInfo)cou);
        initData.put("costManageIsStart", costManageIsStart);
        return initData;
    }

    protected Map _handleMainOrgChange(Context ctx, String orgId) throws BOSException, EASBizException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, orgId);
        if (cou == null) {
            return responseMap;
        }
        responseMap.put("cou", cou);
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(orgId);
        responseMap.put("bizOrgCUID", bizOrgCUID);
        responseMap.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new OtherIssueBillInfo(), sou.getId().toString());
        if (ruleInfo != null) {
            responseMap.put("numberIsEdit", ruleInfo.isIsModifiable());
            responseMap.put("isIsAddView", ruleInfo.isIsAddView());
            responseMap.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)new OtherIssueBillInfo(), sou.getId().toString()));
        }
        Map paramMap = this.batchGetParamValue(ctx, orgId, new String[]{"INM004"});
        responseMap.put("params", paramMap);
        return responseMap;
    }

    protected ISCMBillBase getLocalInstance(Context ctx) throws BOSException {
        return OtherIssueBillFactory.getLocalInstance(ctx);
    }

    public String getPermissionItem() {
        if (OprtStateConstant.ADDNEW.equals(this.oprtState)) {
            return "otherissue_new";
        }
        if (OprtStateConstant.EDIT.equals(this.oprtState)) {
            return "otherissue_udpate";
        }
        if (OprtStateConstant.VIEW.equals(this.oprtState)) {
            return "otherissue_view";
        }
        return "otherissue_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public String getMainOrgUnitName() {
        return "storageOrgUnit";
    }
}

