/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignCollection;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractPurInWarehsBillEditUIHandler;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class PurInWarehsBillEditUIHandler
extends AbstractPurInWarehsBillEditUIHandler {
    protected void _handleActionMaterialView(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionMaterialView(request, response, context);
    }

    protected void _handleActionQueryByMaterial(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionQueryByMaterial(request, response, context);
    }

    @Override
    public void _handleActionRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionRemove(request, response, context);
        this.fillInitFiledProperty(request, response, context);
        PurInWarehsBillInfo billInfo = (PurInWarehsBillInfo)request.getValue();
        if (billInfo != null) {
            this.fillAdminOrgUnitInfo(billInfo.getStorageOrgUnit(), response, context);
        }
    }

    protected void _handleActionQueryGeneralInventory(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionQueryGeneralInventory(request, response, context);
    }

    protected void _handleActionWorkFlowG(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionWorkFlowG(request, response, context);
    }

    @Override
    public void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        StorageOrgUnitInfo mainOrg;
        if (request.get("BATCH_ACTION") != null) {
            return;
        }
        if (request.getState() == null || request.getState().equals("ADDNEW")) {
            if (request.getBotpValue() != null) {
                request.setValue((CoreBaseInfo)request.getBotpValue());
            } else {
                context.put((Object)"isSubContractBill", request.get("isSubContractBill"));
                PurInWarehsBillInfo info = (PurInWarehsBillInfo)PurInWarehsBillFactory.getLocalInstance(context).createNewData(false);
                request.setValue((CoreBaseInfo)info);
            }
        } else {
            String id = request.getId();
            if (id != null) {
                PurInWarehsBillInfo info = (PurInWarehsBillInfo)PurInWarehsBillFactory.getLocalInstance(context).getValue((IObjectPK)new ObjectUuidPK(id), request.getSelectorItemCollection());
                request.setValue((CoreBaseInfo)info);
            }
        }
        super._handleInit(request, response, context);
        if (!(BatchActionEnum.AUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.UNAUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.SUBMIT.equals(request.get("BATCH_ACTION")))) {
            PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)request.getValue();
            this.fillPurOrgColBySou(piwInfo, response, context);
            this.fillPaymentType(request, response, context);
        }
        if ((mainOrg = ((PurInWarehsBillInfo)request.getValue()).getStorageOrgUnit()) != null) {
            this.getAdminOrgUnitInfo(mainOrg.getId().toString(), context);
        }
        this.getMaterialStorageAssignCollection(context, (PurInWarehsBillInfo)request.getValue());
        OrgUnitRelationFactory.getLocalInstance((Context)context).getDefaultToUnit(mainOrg.getId().toString(), 4, 3);
    }

    private void getMaterialStorageAssignCollection(Context context, PurInWarehsBillInfo info) throws Exception {
        if (info == null || info.getStorageOrgUnit() == null) {
            return;
        }
        StorageOrgUnitInfo sou = info.getStorageOrgUnit();
        PurInWarehsEntryInfo entry = null;
        MaterialInfo materialInfo = null;
        WarehouseInfo warehs = null;
        HashSet<String> materialIDs = new HashSet<String>();
        HashSet<String> warehsIDs = new HashSet<String>();
        HashMap<String, WarehouseInfo> defaultWarehouseMap = new HashMap<String, WarehouseInfo>();
        int entrySize = info.getEntry().size();
        for (int j = 0; j < entrySize; ++j) {
            entry = info.getEntry().get(j);
            materialInfo = entry.getMaterial();
            if (materialInfo == null || materialInfo.getId() == null) continue;
            if (entry.getWarehouse() == null) {
                if (defaultWarehouseMap.containsKey(materialInfo.getId().toString() + sou.getId().toString())) {
                    warehs = (WarehouseInfo)defaultWarehouseMap.get(materialInfo.getId().toString() + sou.getId().toString());
                } else {
                    warehs = this.getDefaultWarehouse(context, materialInfo.getId().toString(), sou.getId().toString());
                    defaultWarehouseMap.put(materialInfo.getId().toString() + sou.getId().toString(), warehs);
                }
                entry.setWarehouse(warehs);
            } else {
                warehs = entry.getWarehouse();
            }
            if (warehs == null || entry.getLocation() != null) continue;
            materialIDs.add(materialInfo.getId().toString());
            warehsIDs.add(warehs.getId().toString());
        }
        if (materialIDs.size() > 0 && warehsIDs.size() > 0) {
            this.getMaterialStorageAssignCollection(context, new ArrayList<String>(materialIDs), new ArrayList<String>(warehsIDs), sou.getId().toString());
        }
    }

    private WarehouseInfo getDefaultWarehouse(Context ctx, String materialID, String souID) throws Exception {
        MaterialInventoryInfo miInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialID, souID);
        return miInfo == null ? null : miInfo.getDefaultWarehouse();
    }

    private void getMaterialStorageAssignCollection(Context ctx, List<String> materialId, List<String> warehsId, String souID) throws EASBizException, BOSException {
        if (materialId.size() <= 0 || warehsId.size() <= 0 || StringUtils.isEmpty((String)souID)) {
            return;
        }
        StringBuffer materialIdIn = new StringBuffer();
        StringBuffer warehsIdIn = new StringBuffer();
        for (int j = 0; j < (materialId.size() > warehsId.size() ? materialId.size() : warehsId.size()); ++j) {
            if (j < materialId.size() && !StringUtils.isEmpty((String)materialId.get(j))) {
                materialIdIn.append("'").append(materialId.get(j)).append("',");
            }
            if (j >= warehsId.size() || StringUtils.isEmpty((String)warehsId.get(j))) continue;
            warehsIdIn.append("'").append(warehsId.get(j)).append("',");
        }
        if (materialIdIn.length() <= 3) {
            return;
        }
        materialIdIn.setLength(materialIdIn.length() - 1);
        if (warehsIdIn.length() <= 3) {
            return;
        }
        warehsIdIn.setLength(warehsIdIn.length() - 1);
        IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select id,material.id,storageOrg.id,warehouse.id,location.id,location.name,location.number ").append("where storageOrg = '").append(souID).append("' and ").append("material in (").append(materialIdIn.toString()).append(") and ").append("warehouse in (").append(warehsIdIn.toString()).append(") and ").append("ISDEFAULTLOCATION = 1 ");
        MaterialStorageAssignCollection msaCol = imsa.getMaterialStorageAssignCollection(oql.toString());
    }

    @Override
    protected void fillPaymentType(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String ptId = (String)request.get("PAYMENTTYPE_ID");
        if (ptId != null) {
            ObjectUuidPK pk = new ObjectUuidPK(ptId);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add(new SelectorItemInfo("name"));
            selectorItemCollection.add(new SelectorItemInfo("number"));
            PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeInfo((IObjectPK)pk, selectorItemCollection);
        }
    }

    protected void _handleActionTraceDown(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionTraceDown(request, response, context);
    }

    protected void _handleActionTraceUp(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionTraceUp(request, response, context);
    }

    protected void loadFields(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.loadFields(request, response, context);
        if (!(BatchActionEnum.AUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.UNAUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.SUBMIT.equals(request.get("BATCH_ACTION")))) {
            this.fillCouBySou(request, response, context);
            String msg = this.checkMaterialHasCompany(request, response, context);
            if (msg.length() > 0) {
                throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{msg});
            }
            PurInWarehsBillInfo editData = (PurInWarehsBillInfo)request.getValue();
            if (editData.getTransactionType() == null && editData.getSourceBillType() != null) {
                TransactionTypeFactory.getLocalInstance((Context)context).getCollection("50957179-0105-1000-e000-015fc0a812fd463ED552", editData.getBizType().getId().toString());
            }
        }
    }

    @Override
    public void _handleActionNext(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionNext(request, response, context);
        this.fillInitFiledProperty(request, response, context);
        this.fillSupplierInfo(request, response, context);
    }

    @Override
    public void _handleActionPre(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionPre(request, response, context);
        this.fillInitFiledProperty(request, response, context);
        this.fillSupplierInfo(request, response, context);
    }

    protected void _handleActionAddLine(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAddLine(request, response, context);
    }

    @Override
    protected void _handleActionAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAudit(request, response, context);
    }

    protected void _handleActionCreateFrom(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionCreateFrom(request, response, context);
    }

    @Override
    protected void _handleActionUnAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionUnAudit(request, response, context);
    }

    @Override
    protected void _handleActionOffset(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.fillDestBillIds(request, response, context);
        this.fillCurrentPeriod(request, response, context);
    }

    @Override
    protected void _handleActionQuickAddLine(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSplitBill(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionViewWriteOffRecord(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.prepareCheck4Submit(request, response, context);
        super._handleActionSubmit(request, response, context);
        this.fillServerDate(response, context);
    }

    @Override
    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)request.getValue();
        super._handleActionAddNew(request, response, context);
        this.fillServerDate(response, context);
        this.fillPaymentType(request, response, context);
        PaymentTypeFactory.getLocalInstance((Context)context).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"));
        this.fillAdminOrgUnitInfo((StorageOrgUnitInfo)this.getDefaultMainBizOrg(request, response, context), response, context);
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou != null) {
            CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)context);
        iUnitRel.getFromUnit(cou.getId().toString(), 1, 3);
        if (piwInfo != null && piwInfo.getStorageOrgUnit() != null && piwInfo.getStorageOrgUnit().getId() != null) {
            iUnitRel.getToUnit(piwInfo.getStorageOrgUnit().getId().toString(), 4, 1);
        }
    }

    @Override
    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSave(request, response, context);
        this.fillServerDate(response, context);
        this.fillSupplierInfo2(request, response, context);
    }

    public void handleRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.handleRemove(request, response, context);
        this.fillSupplierInfo(request, response, context);
        String msg = this.checkMaterialHasCompany(request, response, context);
        if (msg.length() > 0) {
            throw new EASBizException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{msg});
        }
        this.fillCouBySou(request, response, context);
        this.fetchData(request, response, context);
        PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)request.getValue();
        this.fillParamValue(piwInfo, response, context);
    }

    private String checkMaterialHasCompany(RequestContext request, ResponseContext response, Context context) throws BOSException, EASBizException {
        int i;
        PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)request.getValue();
        int materialSize = 0;
        for (int i2 = 0; i2 < piwInfo.getEntry().size(); ++i2) {
            if (piwInfo.getEntry().get(i2).getMaterial() == null) continue;
            ++materialSize;
        }
        Object[] materials = new MaterialInfo[materialSize];
        for (int i3 = 0; i3 < piwInfo.getEntry().size(); ++i3) {
            if (piwInfo.getEntry().get(i3).getMaterial() == null) continue;
            materials[i3] = piwInfo.getEntry().get(i3).getMaterial();
        }
        if (materials.length == 0) {
            return "";
        }
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou == null) {
            return "";
        }
        MaterialCompanyInfoCollection mcic = SCMBillCommonFacadeFactory.getLocalInstance((Context)context).getMaterialCompanyCollection(PurInWarehsBillEditUIHandler.getMaterialCompanyOQL(materials, cou.getId().toString()));
        StringBuffer msg = new StringBuffer();
        StringBuffer resultmsg = new StringBuffer();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int size = 0;
        if (mcic != null && mcic.size() > 0) {
            size = mcic.size();
        }
        for (i = 0; i < size; ++i) {
            MaterialCompanyInfoInfo mci = mcic.get(i);
            hashMap.put(mci.getMateial().getId().toString(), "");
        }
        size = materials.length;
        for (i = 0; i < size; ++i) {
            if (hashMap.containsKey(materials[i].getId().toString())) continue;
            msg.append("\n");
            msg.append(materials[i].getNumber());
            msg.append(": ");
            msg.append(materials[i].getName());
        }
        if (msg.toString().length() > 0) {
            resultmsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"MATERIALNOCOMPAY", (Locale)context.getOriginLocale()));
            resultmsg.append(msg);
        }
        return resultmsg.toString();
    }

    private static String getMaterialCompanyOQL(Object[] materials, String companyID) {
        StringBuffer oqlWhere = new StringBuffer();
        oqlWhere.append("select id,mateial.id,company.id where ");
        oqlWhere.append("mateial.id  in(");
        int size = materials.length;
        for (int i = 0; i < size; ++i) {
            if (materials[i] == null || StringUtils.isEmpty((String)((MaterialInfo)materials[i]).getId().toString())) continue;
            oqlWhere.append("'").append(((MaterialInfo)materials[i]).getId().toString()).append("',");
        }
        oqlWhere.delete(oqlWhere.length() - 1, oqlWhere.length());
        oqlWhere.append(")");
        oqlWhere.append(" and company.id = '").append(companyID).append("' ");
        return oqlWhere.toString();
    }

    public EntityViewInfo getConfigTypeEntityView(Context ctx, String className, String configTypeValue, boolean defaultValue) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)className, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId(), CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configTypeValue, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        return ev;
    }

    private void fillSupplierInfo(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)request.getValue();
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou != null) {
            CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        }
        SupplierInfo si = piwInfo.getSupplier();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("paymentType.*"));
        if (si != null) {
            SupplierFactory.getLocalInstance((Context)ctx).getCompanyInfo((IObjectPK)new ObjectUuidPK(si.getId()), (IObjectPK)new ObjectUuidPK(cou.getId()), sic);
        }
    }

    private void fillSupplierInfo2(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)request.getValue();
        SupplierInfo si = piwInfo.getSupplier();
        if (si != null) {
            SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(si.getId()));
        }
    }

    private void fillInitFiledProperty(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)request.getValue();
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou != null) {
            CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        }
        ArrayList<MaterialInfo> materials = new ArrayList<MaterialInfo>();
        PurInWarehsEntryCollection entries = piwInfo.getEntry();
        int rows = entries.size();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                MaterialInfo mi = entries.get(i).getMaterial();
                if (mi == null) continue;
                materials.add(mi);
            }
            if (materials.size() > 0) {
                StringBuffer oqlWhere = new StringBuffer();
                oqlWhere.append("select id,mateial.id,company.id where ");
                oqlWhere.append("mateial.id  in(");
                int size = materials.size();
                for (int i = 0; i < size; ++i) {
                    if (StringUtils.isEmpty((String)((MaterialInfo)materials.get(i)).getId().toString())) continue;
                    oqlWhere.append("'").append(((MaterialInfo)materials.get(i)).getId().toString()).append("',");
                }
                oqlWhere.delete(oqlWhere.length() - 1, oqlWhere.length());
                oqlWhere.append(")");
                oqlWhere.append(" and company.id = '").append(cou.getId().toString()).append("' ");
                SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getMaterialCompanyCollection(oqlWhere.toString());
            }
        }
    }

    private void fillPurOrgColBySou(PurInWarehsBillInfo piwInfo, ResponseContext response, Context ctx) throws Exception {
        if (piwInfo == null) {
            return;
        }
        StorageOrgUnitInfo souInfo = piwInfo.getStorageOrgUnit();
        if (souInfo == null) {
            return;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(souInfo.getId().toString(), 4, 3);
        this.addToResponse(response, IOrgUnitRelation.class, "getToUnit", new Class[]{String.class, Integer.TYPE, Integer.TYPE}, new Object[]{souInfo.getId().toString(), new Integer(4), new Integer(3)}, orgCol);
    }

    private void fillPurOrgBySou(PurInWarehsBillInfo piwInfo, ResponseContext response, Context ctx) throws Exception {
        StorageOrgUnitInfo souInfo = piwInfo.getStorageOrgUnit();
        if (souInfo == null || souInfo.getId() == null) {
            return;
        }
        SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getPurchaseByStorageOrg(souInfo.getId().toString());
    }

    public void fillParamValue(PurInWarehsBillInfo piwInfo, ResponseContext response, Context ctx) throws Exception {
        StorageOrgUnitInfo souInfo = piwInfo.getStorageOrgUnit();
        if (souInfo == null || souInfo.getId() == null) {
            return;
        }
        OrgUnitCollection orgCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(souInfo.getId().toString(), 4, 1);
        if (null == orgCol || orgCol.size() == 0) {
            return;
        }
        CompanyOrgUnitInfo companyOrgInfo = (CompanyOrgUnitInfo)orgCol.get(0);
        if (companyOrgInfo == null || companyOrgInfo.getId() == null) {
            return;
        }
        ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(companyOrgInfo.getId().toString()), "SCM_CAL_011");
    }

    private void fillDestBillIds(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String destBosType = (String)request.get("OFFSET_DEST_BOSTYPE");
        String srcBillId = (String)request.get("OFFSET_SRC_BILLID");
        this.addToResponse(response, IBOTRelation.class, "getDestObjIdByDestType", new Class[]{String.class, String.class}, new Object[]{srcBillId, destBosType}, BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(srcBillId, destBosType));
    }

    @Override
    public void _handleActionCopy(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionCopy(request, response, context);
        this.fillServerDate(response, context);
        this.fillPaymentType(request, response, context);
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou != null) {
            CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        }
        this.fillInitFiledProperty(request, response, context);
    }

    @Override
    public void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionEdit(request, response, context);
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.createNewData(request, response, context);
        PurInWarehsBillInfo piwInfo = new PurInWarehsBillInfo();
        piwInfo.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg(request, response, context));
        request.setValue((CoreBaseInfo)piwInfo);
        this.fillServerDate(response, context);
        this.fillPaymentType(request, response, context);
        this.fillAdminOrgUnitInfo(piwInfo.getStorageOrgUnit(), response, context);
        this.fillPurOrgBySou(piwInfo, response, context);
        return request.getValue();
    }

    private void prepareCheck4Submit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionISDMMsg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSplitBillByHand(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

