/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;

public class PurInWarehsServerutils {
    public static BigDecimal getBaseUnitQty(Context ctx, MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            MultiMeasureUnitInfo mulUnit = PurInWarehsServerutils.getMulUnit(ctx, mui, mi);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = PurInWarehsServerutils.getMulUnit(ctx, baseUnit, mi);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public static BigDecimal getAssUnitQty(Context ctx, MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal assQty = new BigDecimal("0.00");
        if (baseQty != null) {
            assQty = baseQty;
        } else {
            baseQty = assQty;
        }
        MultiMeasureUnitInfo mulUnit = PurInWarehsServerutils.getMulUnit(ctx, mui, mi);
        if (mulUnit != null) {
            coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null) {
                assQty = baseQty.divide(coefficient, precision, 4);
            }
        }
        return assQty;
    }

    public static BigDecimal getUnitStandardCost(Context ctx, MaterialInfo aMaterialInfo, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws Exception {
        BigDecimal result = new BigDecimal("0.00");
        if (aMaterialInfo == null || aMaterialInfo.getId() == null || aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
            return result;
        }
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = iMaterial.getCompanyInfo(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString());
        if (aMaterialCompanyInfoInfo == null) {
            return result;
        }
        if (aMaterialCompanyInfoInfo.getStandardCost() != null) {
            result = aMaterialCompanyInfoInfo.getStandardCost();
        }
        return result;
    }

    public static BigDecimal getUnitPrice(Context ctx, MeasureUnitInfo mui, MaterialInfo mi, BigDecimal basePrice) throws BaseException {
        MultiMeasureUnitInfo mulUnit;
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal price = new BigDecimal("0.00");
        if (basePrice != null) {
            price = basePrice;
        }
        if ((mulUnit = PurInWarehsServerutils.getMulUnit(ctx, mui, mi)) != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
            price = price.multiply(coefficient);
        }
        return price;
    }

    public static CompanyOrgUnitInfo getCompany(Context ctx, StorageOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 4, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        if (ret != null) {
            String oql = "SELECT *, baseCurrency.precision WHERE id ='" + ret.getId().toString() + "'";
            ret = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
        }
        return ret;
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }
}

