/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractUniteBill;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class PurInWarehsUniteCalculate
extends AbstractUniteBill {
    @Override
    public HashMap executeUniteBill(Context ctx, String id) throws BOSException, EASBizException {
        BigDecimal ZERO;
        HashMap msgHm = this.check(ctx, id);
        if (msgHm.containsKey("NotUniteMsg")) {
            return msgHm;
        }
        String motherBillId = (String)msgHm.get("MotherBillId");
        String childBillId = (String)msgHm.get("ChildBillId");
        ObjectUuidPK motherPK = new ObjectUuidPK(motherBillId);
        ObjectUuidPK childPK = new ObjectUuidPK(childBillId);
        IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance(ctx);
        PurInWarehsBillInfo motherPurInWarehsInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)motherPK);
        PurInWarehsBillInfo tempMotherPurInWarehsInfo = (PurInWarehsBillInfo)motherPurInWarehsInfo.clone();
        PurInWarehsBillInfo childPurInWarehsInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)childPK);
        PurInWarehsEntryCollection motherPurInWarehsEntry = motherPurInWarehsInfo.getEntry();
        PurInWarehsEntryCollection tempMotherPurInWarehsEntry = tempMotherPurInWarehsInfo.getEntry();
        PurInWarehsEntryCollection childPurInWarehsEntry = childPurInWarehsInfo.getEntry();
        ArrayList<PurInWarehsEntryInfo> childEntryList = new ArrayList<PurInWarehsEntryInfo>();
        BigDecimal totalQty = ZERO = new BigDecimal("0.00");
        BigDecimal totalAmount = ZERO;
        BigDecimal totalLocalAmount = ZERO;
        BigDecimal totalStandardCost = ZERO;
        BigDecimal totalActualCost = ZERO;
        motherPurInWarehsEntry.clear();
        int motherSize = tempMotherPurInWarehsEntry.size();
        for (int i = 0; i < motherSize; ++i) {
            PurInWarehsEntryInfo tempMotherPurInWarehsEntryInfo = tempMotherPurInWarehsEntry.get(i);
            int childSize = childPurInWarehsEntry.size();
            for (int j = 0; j < childSize; ++j) {
                PurInWarehsEntryInfo childPurInWarehsEntryInfo = childPurInWarehsEntry.get(j);
                if (!this.compareTo(tempMotherPurInWarehsEntryInfo, childPurInWarehsEntryInfo)) continue;
                this.processUniteBillEntry(ctx, tempMotherPurInWarehsEntryInfo, childPurInWarehsEntryInfo);
                childEntryList.add(childPurInWarehsEntryInfo);
                totalQty = totalQty.add(tempMotherPurInWarehsEntryInfo.getQty());
                totalAmount = totalAmount.add(tempMotherPurInWarehsEntryInfo.getAmount());
                totalLocalAmount = totalLocalAmount.add(tempMotherPurInWarehsEntryInfo.getLocalAmount());
                totalStandardCost = totalStandardCost.add(tempMotherPurInWarehsEntryInfo.getStandardCost());
                totalActualCost = totalActualCost.add(tempMotherPurInWarehsEntryInfo.getActualCost());
                motherPurInWarehsEntry.add(tempMotherPurInWarehsEntryInfo);
                childPurInWarehsEntry.remove(childPurInWarehsEntryInfo);
                break;
            }
            if (motherPurInWarehsEntry.contains(tempMotherPurInWarehsEntryInfo)) continue;
            motherPurInWarehsEntry.add(tempMotherPurInWarehsEntryInfo);
        }
        int childSize = childPurInWarehsEntry.size();
        for (int j = 0; j < childSize; ++j) {
            PurInWarehsEntryInfo childPurInWarehsEntryInfo = childPurInWarehsEntry.get(j);
            childPurInWarehsEntryInfo.setSeq(motherPurInWarehsEntry.size() + 1);
            childPurInWarehsEntryInfo.setParent(motherPurInWarehsInfo);
            motherPurInWarehsEntry.add(childPurInWarehsEntryInfo);
            totalQty = totalQty.add(childPurInWarehsEntryInfo.getQty());
            totalAmount = totalAmount.add(childPurInWarehsEntryInfo.getAmount());
            totalLocalAmount = totalLocalAmount.add(childPurInWarehsEntryInfo.getLocalAmount());
            totalStandardCost = totalStandardCost.add(childPurInWarehsEntryInfo.getStandardCost());
            totalActualCost = totalActualCost.add(childPurInWarehsEntryInfo.getActualCost());
        }
        motherPurInWarehsInfo.setTotalQty(totalQty);
        motherPurInWarehsInfo.setTotalAmount(totalAmount);
        motherPurInWarehsInfo.setTotalLocalAmount(totalLocalAmount);
        motherPurInWarehsInfo.setTotalStandardCost(totalStandardCost);
        motherPurInWarehsInfo.setTotalActualCost(totalActualCost);
        this.delete(ctx, childBillId, motherBillId);
        iPurInWarehsBill.addnew((CoreBaseInfo)motherPurInWarehsInfo);
        return msgHm;
    }

    private boolean compareTo(PurInWarehsEntryInfo tempMotherPurInWarehsEntryInfo, PurInWarehsEntryInfo childPurInWarehsEntryInfo) {
        boolean flag = false;
        flag = tempMotherPurInWarehsEntryInfo.getPurOrderEntry().equals(childPurInWarehsEntryInfo.getPurOrderEntry());
        boolean bl = flag = flag && tempMotherPurInWarehsEntryInfo.getPurOrderEntrySeq() == childPurInWarehsEntryInfo.getPurOrderEntrySeq();
        boolean bl2 = null != tempMotherPurInWarehsEntryInfo.getAssistProperty() ? flag && tempMotherPurInWarehsEntryInfo.getAssistProperty().equals((Object)childPurInWarehsEntryInfo.getAssistProperty()) : (flag = flag && null == childPurInWarehsEntryInfo.getAssistProperty());
        boolean bl3 = null != tempMotherPurInWarehsEntryInfo.getUnit() ? flag && tempMotherPurInWarehsEntryInfo.getUnit().equals((Object)childPurInWarehsEntryInfo.getUnit()) : (flag = flag && null == childPurInWarehsEntryInfo.getUnit());
        boolean bl4 = null != tempMotherPurInWarehsEntryInfo.getLot() ? flag && tempMotherPurInWarehsEntryInfo.getLot().equals(childPurInWarehsEntryInfo.getLot()) : (flag = flag && null == childPurInWarehsEntryInfo.getLot());
        boolean bl5 = null != tempMotherPurInWarehsEntryInfo.getMfg() ? flag && tempMotherPurInWarehsEntryInfo.getMfg().equals(childPurInWarehsEntryInfo.getMfg()) : (flag = flag && null == childPurInWarehsEntryInfo.getMfg());
        boolean bl6 = null != tempMotherPurInWarehsEntryInfo.getExp() ? flag && tempMotherPurInWarehsEntryInfo.getExp().equals(childPurInWarehsEntryInfo.getExp()) : (flag = flag && null == childPurInWarehsEntryInfo.getExp());
        boolean bl7 = null != tempMotherPurInWarehsEntryInfo.getWarehouse() ? flag && tempMotherPurInWarehsEntryInfo.getWarehouse().equals((Object)childPurInWarehsEntryInfo.getWarehouse()) : (flag = flag && null == childPurInWarehsEntryInfo.getWarehouse());
        flag = null != tempMotherPurInWarehsEntryInfo.getLocation() ? flag && tempMotherPurInWarehsEntryInfo.getLocation().equals((Object)childPurInWarehsEntryInfo.getLocation()) : flag && null == childPurInWarehsEntryInfo.getLocation();
        return flag;
    }

    private void delete(Context ctx, String childBillId, String motherBillId) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("DELETE FROM T_IM_SplitBillRelation WHERE FChildBillId = ?");
        String deleteSplitBillRelationSQL = bf.toString();
        bf.setLength(0);
        bf.append("DELETE FROM T_IM_PurInWarehsEntry WHERE FParentID = ?");
        String deletePurInWarehsEntrySQL = bf.toString();
        bf.setLength(0);
        bf.append("DELETE FROM T_IM_PurInWarehsBill WHERE FID = ?");
        String deletePurInWarehsBillSQL = bf.toString();
        DbUtil.execute((Context)ctx, (String)deleteSplitBillRelationSQL, (Object[])new Object[]{childBillId});
        DbUtil.execute((Context)ctx, (String)deletePurInWarehsEntrySQL, (Object[])new Object[]{childBillId});
        DbUtil.execute((Context)ctx, (String)deletePurInWarehsBillSQL, (Object[])new Object[]{childBillId});
        DbUtil.execute((Context)ctx, (String)deletePurInWarehsEntrySQL, (Object[])new Object[]{motherBillId});
        DbUtil.execute((Context)ctx, (String)deletePurInWarehsBillSQL, (Object[])new Object[]{motherBillId});
    }

    private void processUniteBillEntry(Context ctx, PurInWarehsEntryInfo tempMotherPurInWarehsInfo, PurInWarehsEntryInfo childPurInWarehsEntryInfo) throws BOSException, EASBizException {
        int precision = CalculateUtil.getLocalCurrencyPrecision2((Context)ctx, (CompanyOrgUnitInfo)tempMotherPurInWarehsInfo.getCompanyOrgUnit());
        tempMotherPurInWarehsInfo.setQty(tempMotherPurInWarehsInfo.getQty().add(childPurInWarehsEntryInfo.getQty()));
        tempMotherPurInWarehsInfo.setBaseQty(tempMotherPurInWarehsInfo.getBaseQty().add(childPurInWarehsEntryInfo.getBaseQty()));
        tempMotherPurInWarehsInfo.setActualCost(tempMotherPurInWarehsInfo.getQty().multiply(tempMotherPurInWarehsInfo.getUnitActualCost()).setScale(precision));
        tempMotherPurInWarehsInfo.setStandardCost(tempMotherPurInWarehsInfo.getQty().multiply(tempMotherPurInWarehsInfo.getUnitStandardCost()).setScale(precision));
        tempMotherPurInWarehsInfo.setWrittenOffQty(tempMotherPurInWarehsInfo.getWrittenOffQty().add(childPurInWarehsEntryInfo.getWrittenOffQty()));
        tempMotherPurInWarehsInfo.setWrittenOffBaseQty(tempMotherPurInWarehsInfo.getWrittenOffBaseQty().add(childPurInWarehsEntryInfo.getWrittenOffBaseQty()));
        tempMotherPurInWarehsInfo.setUnWriteOffQty(tempMotherPurInWarehsInfo.getUnWriteOffQty().add(childPurInWarehsEntryInfo.getUnWriteOffQty()));
        tempMotherPurInWarehsInfo.setUnWriteOffBaseQty(tempMotherPurInWarehsInfo.getUnWriteOffBaseQty().add(childPurInWarehsEntryInfo.getUnWriteOffBaseQty()));
        tempMotherPurInWarehsInfo.setWrittenOffAmount(tempMotherPurInWarehsInfo.getWrittenOffAmount().add(childPurInWarehsEntryInfo.getWrittenOffAmount()));
        tempMotherPurInWarehsInfo.setUnWriteOffAmount(tempMotherPurInWarehsInfo.getUnWriteOffAmount().add(childPurInWarehsEntryInfo.getUnWriteOffAmount()));
        tempMotherPurInWarehsInfo.setAssistQty(tempMotherPurInWarehsInfo.getAssistQty().add(childPurInWarehsEntryInfo.getAssistQty()));
        tempMotherPurInWarehsInfo.setAmount(tempMotherPurInWarehsInfo.getQty().multiply(tempMotherPurInWarehsInfo.getPrice()).setScale(precision));
        tempMotherPurInWarehsInfo.setLocalAmount(tempMotherPurInWarehsInfo.getQty().multiply(tempMotherPurInWarehsInfo.getLocalPrice()).setScale(precision));
        tempMotherPurInWarehsInfo.setTax(tempMotherPurInWarehsInfo.getTax().add(childPurInWarehsEntryInfo.getTax()));
        tempMotherPurInWarehsInfo.setLocalTax(tempMotherPurInWarehsInfo.getLocalTax().add(childPurInWarehsEntryInfo.getLocalTax()));
        tempMotherPurInWarehsInfo.setAssociateQty(tempMotherPurInWarehsInfo.getAssociateQty().add(childPurInWarehsEntryInfo.getAssociateQty()));
        tempMotherPurInWarehsInfo.setUnReturnedBaseQty(tempMotherPurInWarehsInfo.getUnReturnedBaseQty().add(childPurInWarehsEntryInfo.getUnReturnedBaseQty()));
        tempMotherPurInWarehsInfo.setTotalMoveQty(tempMotherPurInWarehsInfo.getTotalMoveQty().add(childPurInWarehsEntryInfo.getTotalMoveQty()));
        tempMotherPurInWarehsInfo.setCanDirectReqQty(tempMotherPurInWarehsInfo.getCanDirectReqQty().add(childPurInWarehsEntryInfo.getCanDirectReqQty()));
        tempMotherPurInWarehsInfo.setCanDirectReqBaseQty(tempMotherPurInWarehsInfo.getCanDirectReqBaseQty().add(childPurInWarehsEntryInfo.getCanDirectReqBaseQty()));
        tempMotherPurInWarehsInfo.setDrewQty(tempMotherPurInWarehsInfo.getDrewQty().add(childPurInWarehsEntryInfo.getDrewQty()));
        tempMotherPurInWarehsInfo.setDrewBaseQty(tempMotherPurInWarehsInfo.getDrewBaseQty().add(childPurInWarehsEntryInfo.getDrewBaseQty()));
        tempMotherPurInWarehsInfo.setReverseQty(tempMotherPurInWarehsInfo.getReverseQty().add(childPurInWarehsEntryInfo.getReverseQty()));
        tempMotherPurInWarehsInfo.setReverseBaseQty(tempMotherPurInWarehsInfo.getReverseBaseQty().add(childPurInWarehsEntryInfo.getReverseBaseQty()));
        tempMotherPurInWarehsInfo.setReturnsQty(tempMotherPurInWarehsInfo.getReturnsQty().add(childPurInWarehsEntryInfo.getReturnsQty()));
        tempMotherPurInWarehsInfo.setReturnBaseQty(tempMotherPurInWarehsInfo.getReturnBaseQty().add(childPurInWarehsEntryInfo.getReturnBaseQty()));
    }

    private HashMap check(Context ctx, String id) throws BOSException, EASBizException {
        HashMap map;
        HashMap<String, String> msgHm = new HashMap<String, String>();
        boolean flag = false;
        StringBuffer notUniteMsg = new StringBuffer();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance(ctx);
        PurInWarehsBillInfo purInWarehsBillInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)pk);
        if (BillBaseStatusEnum.AUDITED != purInWarehsBillInfo.getBaseStatus()) {
            notUniteMsg.append("[");
            notUniteMsg.append(purInWarehsBillInfo.getNumber());
            notUniteMsg.append("]\t ");
            notUniteMsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"NotAudit", (Locale)ctx.getOriginLocale()));
            notUniteMsg.append("\t\n ");
            flag = true;
        }
        if (purInWarehsBillInfo.isFiVouchered()) {
            notUniteMsg.append("[");
            notUniteMsg.append(purInWarehsBillInfo.getNumber());
            notUniteMsg.append("]\t ");
            notUniteMsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"HasFiVouchered", (Locale)ctx.getOriginLocale()));
            notUniteMsg.append("\t\n ");
            flag = true;
        }
        if ((map = this.getMotherBillIdAndChildBillId(ctx, id)).containsKey("NotUniteMsg")) {
            String tempError = (String)map.get("NotUniteMsg");
            notUniteMsg.append(tempError);
            flag = true;
        } else {
            String motherBillId = (String)map.get("MotherBillId");
            String childBillId = (String)map.get("ChildBillId");
            msgHm.put("MotherBillId", motherBillId);
            msgHm.put("ChildBillId", childBillId);
            if (SCMServerUtils.hasDestBill((Context)ctx, (String)childBillId)) {
                ObjectUuidPK childPK = new ObjectUuidPK(childBillId);
                PurInWarehsBillInfo childPurInWarehsBillInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)childPK);
                notUniteMsg.append("[");
                notUniteMsg.append(childPurInWarehsBillInfo.getNumber());
                notUniteMsg.append("]\t ");
                notUniteMsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"ChildHasNextBill", (Locale)ctx.getOriginLocale()));
                notUniteMsg.append("\t\n ");
                flag = true;
            }
        }
        if (flag) {
            msgHm.put("NotUniteMsg", notUniteMsg.toString());
        }
        return msgHm;
    }
}

