/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMParamFacadeFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillAgent;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractPurReceivalBillEditUIHandler;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;

public class PurReceivalBillEditUIHandler
extends AbstractPurReceivalBillEditUIHandler {
    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        StorageOrgUnitInfo sou;
        PurReceivalBillInfo info;
        if (request.get("BATCH_ACTION") != null) {
            return;
        }
        if (request.getState() == null || request.getState().equals("ADDNEW")) {
            if (request.getBotpValue() != null) {
                request.setValue((CoreBaseInfo)request.getBotpValue());
            } else {
                context.put((Object)"isSubContractBill", request.get("isSubContractBill"));
                info = (PurReceivalBillInfo)PurReceivalBillFactory.getLocalInstance(context).createNewData(true);
                request.setValue((CoreBaseInfo)info);
            }
        } else {
            String id = request.getId();
            if (id != null) {
                PurReceivalBillInfo info2 = (PurReceivalBillInfo)PurReceivalBillFactory.getLocalInstance(context).getValue((IObjectPK)new ObjectUuidPK(id), request.getSelectorItemCollection());
                request.setValue((CoreBaseInfo)info2);
            }
        }
        super._handleInit(request, response, context);
        if (!(BatchActionEnum.AUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.UNAUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.SUBMIT.equals(request.get("BATCH_ACTION")))) {
            PurReceivalBillInfo recBillInfo = (PurReceivalBillInfo)request.getValue();
            this.fillParamValue(request, response, context);
            if (recBillInfo != null && recBillInfo.get("currency") != null) {
                ObjectUuidPK pk = new ObjectUuidPK(((CurrencyInfo)recBillInfo.get("currency")).getId());
                CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)pk);
            }
            this.fillTransactionCollection(request, response, context);
            this.fillInitFiledProperty(request, response, context);
            this.fillPersonalParam(request, response, context);
        }
        if ((sou = (info = (PurReceivalBillInfo)request.getValue()).getStorageOrgUnit()) != null) {
            this.getAdminOrgUnitInfo(sou.getId().toString(), context);
        }
        ReasonCodeTypeFactory.getLocalInstance((Context)context).getReasonCodeTypeInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-000000000003A5CCD5DC"));
        if (info.getSourceBillType() != null && (request.getState() == null || request.getState().equals("ADDNEW") || 1 == info.getBaseStatus().getValue())) {
            int entrySize = info.getEntry().size();
            HashSet<String> muSet = new HashSet<String>();
            HashSet<String> mpSet = new HashSet<String>();
            HashSet<String> msSet = new HashSet<String>();
            for (int i = 0; i < entrySize; ++i) {
                PurReceivalEntryInfo entry = info.getEntry().get(i);
                MeasureUnitInfo unit = entry.getUnit();
                MaterialInfo material = entry.getMaterial();
                PurchaseOrgUnitInfo pou = entry.getPurchaseOrgUnit();
                IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)context);
                if (material != null && unit != null && !muSet.contains(material.getId().toString() + unit.getId().toString())) {
                    immu.getMultiUnit(material.getId().toString(), unit.getId().toString());
                    muSet.add(material.getId().toString() + unit.getId().toString());
                }
                if (material != null && pou != null && !mpSet.contains(material.getId().toString() + pou.getId().toString())) {
                    MaterialPurchasingFactory.getLocalInstance((Context)context).getPurchasingInfo(material.getId().toString(), pou.getId().toString());
                    mpSet.add(material.getId().toString() + pou.getId().toString());
                }
                if (material == null || sou == null || msSet.contains(material.getId().toString() + sou.getId().toString())) continue;
                MaterialPlanFactory.getLocalInstance((Context)context).getPlanInfo(material.getId().toString(), sou.getId().toString());
                msSet.add(material.getId().toString() + sou.getId().toString());
            }
        }
    }

    @Override
    protected void _handleActionOffset(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionQuickAddLine(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionISDMMsg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.createNewData(request, response, context);
        PurReceivalBillAgent recBillInfo = PurReceivalBillAgent.create();
        recBillInfo.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg(request, response, context));
        request.setValue((CoreBaseInfo)recBillInfo);
        this.fillServerDate(response, context);
        this.fillPaymentType(request, response, context);
        this.fillAdminOrgUnitInfo(recBillInfo.getStorageOrgUnit(), response, context);
        this.fillParamValue(request, response, context);
        this.fillLocalCurrency(request, response, context);
        IRowType irowtype = RowTypeFactory.getLocalInstance((Context)context);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("destinationType"));
        sic.add(new SelectorItemInfo("requestOrgType"));
        sic.add(new SelectorItemInfo("isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("precision"));
        irowtype.getRowTypeInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-0000000000017C7DC4A3"), sic);
        return request.getValue();
    }

    private void fillParamValue(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String souId = request.getMainOrg();
        if (StringUtil.isEmpty((String)souId)) {
            return;
        }
        ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(souId), "IS_AUDIT_SIGN");
        String[] keys = new String[]{"isUseProjectTrack"};
        SCMParamFacadeFactory.getLocalInstance((Context)ctx).getScmSpecialParams(keys);
    }

    private void fillTransactionCollection(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String bizTypeID = null;
        String srcBillTypeID = null;
        PurReceivalBillInfo recBillInfo = (PurReceivalBillInfo)request.getValue();
        if (recBillInfo == null) {
            return;
        }
        if (recBillInfo.getBizType() != null && recBillInfo.getSourceBillType() != null) {
            bizTypeID = recBillInfo.getBizType().getId().toString();
            srcBillTypeID = recBillInfo.getSourceBillType().getId().toString();
        }
        if (bizTypeID != null && srcBillTypeID != null) {
            TransactionTypeFactory.getLocalInstance((Context)ctx).getCollection("50957179-0105-1000-e000-0157c0a812fd463ED552", bizTypeID);
        }
    }

    private void fillInitFiledProperty(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        PurReceivalBillInfo siInfo = (PurReceivalBillInfo)request.getValue();
        if (siInfo == null) {
            return;
        }
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou != null) {
            CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        } else {
            if (siInfo.getStorageOrgUnit() == null) {
                return;
            }
            cou = InvServerUtils.getCompanyInfoForStorage(ctx, siInfo.getStorageOrgUnit());
        }
        ArrayList<MaterialInfo> materials = new ArrayList<MaterialInfo>();
        PurReceivalEntryCollection entries = siInfo.getEntry();
        int rows = entries.size();
        if (rows > 0 && cou != null) {
            for (int i = 0; i < rows; ++i) {
                MaterialInfo mi = entries.get(i).getMaterial();
                if (mi == null) continue;
                materials.add(mi);
            }
            if (materials.size() > 0) {
                StringBuffer oqlWhere = new StringBuffer();
                oqlWhere.append("select id,mateial.id,company.id where ");
                oqlWhere.append("mateial.id  in(");
                int size = materials.size();
                for (int i = 0; i < size; ++i) {
                    if (StringUtils.isEmpty((String)((MaterialInfo)materials.get(i)).getId().toString())) continue;
                    oqlWhere.append("'").append(((MaterialInfo)materials.get(i)).getId().toString()).append("',");
                }
                oqlWhere.delete(oqlWhere.length() - 1, oqlWhere.length());
                oqlWhere.append(")");
                oqlWhere.append(" and company.id = '").append(cou.getId().toString()).append("' ");
                SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getMaterialCompanyCollection(oqlWhere.toString());
            }
        }
    }

    private void fillPersonalParam(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String osql = "where user.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "'";
        PersonalParamFactory.getLocalInstance((Context)ctx).getPersonalParamCollection(osql);
        PersonalParamFactory.getLocalInstance((Context)ctx).getPersonalParamCollection("where user.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' and paramName='returnOlnyRecord'");
        PersonalParamFactory.getLocalInstance((Context)ctx).getPersonalParamCollection("where user.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' and paramName='f7CapitalSensitiveQuery'");
    }

    @Override
    protected void _handleactionClose(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionUnClose(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

