/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.im.inv.PlanOrderEntryInfo;
import com.kingdee.eas.scm.im.inv.PlanOrderFactory;
import com.kingdee.eas.scm.im.inv.PlanOrderInfo;
import com.kingdee.eas.scm.im.inv.ROPParam;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class ROPServerUtils {
    public static String[] getMaterialIDsFromNumber(Context ctx, String materialNumberFrom, String materialNumberTo) throws BOSException {
        if (StringUtils.isEmpty((String)materialNumberFrom) || StringUtils.isEmpty((String)materialNumberTo)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)materialNumberFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)materialNumberTo, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        MaterialCollection coll = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        ArrayList<String> materialIDList = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            materialIDList.add(coll.get(i).getId().toString());
        }
        String[] materialIDs = new String[materialIDList.size()];
        materialIDList.toArray(materialIDs);
        return materialIDs;
    }

    public static String getDeletePlanOrderSql(Context ctx, ROPParam ropParam) {
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM T_IM_PlanOrderEntry WHERE EXISTS");
        sql.append(" (SELECT 1");
        sql.append(" FROM T_IM_PlanOrder po INNER JOIN T_IM_PlanOrderEntry poe ON po.FID = poe.FParentID");
        sql.append(" INNER JOIN T_BD_Material mat ON poe.FMaterialID = mat.FID");
        sql.append(" INNER JOIN T_BD_MaterialInventory matInv ON poe.FMaterialID = matInv.FMaterialID AND po.FStorageOrgUnitID = matInv.FOrgUnit");
        sql.append(" WHERE T_IM_PlanOrderEntry.FBaseStatus = ").append(2);
        if (ropParam != null) {
            String planner;
            String materialTo;
            String materialFrom;
            String[] souIDs = ropParam.getSouIDs();
            if (souIDs != null && souIDs.length > 0) {
                sql.append(" AND po.FStorageOrgUnitID IN ").append(InvServerUtils.getInStringFromArray(souIDs));
            }
            if (!StringUtils.isEmpty((String)(materialFrom = ropParam.getMaterialNumberFrom()))) {
                sql.append(" AND mat.FNumber>= '").append(materialFrom).append("'");
            }
            if (!StringUtils.isEmpty((String)(materialTo = ropParam.getMaterialNumberTo()))) {
                sql.append(" AND mat.FNumber <= '").append(materialTo).append("'");
            }
            if (!StringUtils.isEmpty((String)(planner = ropParam.getPlanner()))) {
                sql.append(" AND matInv.FInvPlanner = '").append(planner).append("'");
            }
        }
        sql.append(" AND T_IM_PlanOrderEntry.FID = poe.FID)");
        return sql.toString();
    }

    public static List createPlanOrder(Context ctx, String tableName) throws BOSException, SQLException, EASBizException {
        BigDecimal ZERO = new BigDecimal("0.00");
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" SELECT tmp.*, mat.FNumber FROM ").append(tableName).append(" tmp");
        selectSql.append(" INNER JOIN T_BD_Material mat ON TMP.FMaterialID = mat.FID");
        selectSql.append(" INNER JOIN T_BD_MaterialGroup AS matG ON mat.FMaterialGroupID = matG.FID");
        selectSql.append(" WHERE tmp.FPlanQty > 0 AND tmp.FPlanOrderReleasedCount = 0 ");
        selectSql.append(" and (matG.FDeletedStatus = 1 OR matG.FDeletedStatus IS NULL)");
        selectSql.append(" ORDER BY tmp.FSouID ASC, mat.FNumber ASC ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        CoreBaseCollection planOrderCol = new CoreBaseCollection();
        ArrayList<String> planOrderNOs = new ArrayList<String>();
        PlanOrderInfo planOrder = null;
        String currentSouID = null;
        ICodingRuleManager iCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        int entryLength = 0;
        while (rs.next()) {
            String souID = rs.getString("FSouID");
            if (!souID.equals(currentSouID) || entryLength % 500 == 0) {
                if (planOrder != null) {
                    planOrderCol.add(planOrder);
                    entryLength = 0;
                }
                planOrder = new PlanOrderInfo();
                BillTypeInfo billType = new BillTypeInfo();
                billType.setId(BOSUuid.read((String)"7UcZ6QEUEADgAAYawKg9C0Y+1VI="));
                planOrder.setBillType(billType);
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                sou.setId(BOSUuid.read((String)souID));
                planOrder.setStorageOrgUnit(sou);
                planOrder.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                java.util.Date date = new java.util.Date();
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
                String temp_str = dateformat.format(date);
                try {
                    java.util.Date bizDate = dateformat.parse(temp_str);
                    planOrder.setBizDate(bizDate);
                }
                catch (ParseException e) {
                    throw new BOSException();
                }
                planOrder.setNumber(iCodingRule.getNumber((IObjectValue)planOrder, souID));
                planOrderNOs.add(planOrder.getNumber());
                currentSouID = souID;
            }
            PlanOrderEntryInfo entry = new PlanOrderEntryInfo();
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)rs.getString("FMaterialID")));
            entry.setMaterial(material);
            MeasureUnitInfo unit = new MeasureUnitInfo();
            unit.setId(BOSUuid.read((String)rs.getString("FUnitID")));
            entry.setUnit(unit);
            BigDecimal safetyQty = rs.getBigDecimal("FSafetyQty");
            entry.setSafetyStorage(safetyQty);
            BigDecimal instanceQty = rs.getBigDecimal("FInstanceStorage");
            entry.setInstantStorage(instanceQty);
            BigDecimal planQty = rs.getBigDecimal("FPlanQty");
            entry.setPlanQty(planQty);
            MeasureUnitInfo baseUnit = new MeasureUnitInfo();
            baseUnit.setId(BOSUuid.read((String)rs.getString("FBaseUnitID")));
            entry.setBaseUnit(baseUnit);
            BigDecimal planBaseQty = rs.getBigDecimal("FPlanBaseQty");
            entry.setPlanBaseQty(planBaseQty);
            Date planDate = rs.getDate("FPlanDate");
            entry.setPlanDate(planDate);
            Date reqDate = rs.getDate("FReqDate");
            entry.setReqDate(reqDate);
            entry.setTotalReqQty(ZERO);
            entry.setTotalReqBaseQty(ZERO);
            entry.setAssociateQty(ZERO);
            String plannerID = rs.getString("FPlannerID");
            if (plannerID != null && plannerID.length() > 0) {
                PersonInfo planner = new PersonInfo();
                planner.setId(BOSUuid.read((String)plannerID));
                entry.setPlanner(planner);
            }
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            planOrder.getEntry().add(entry);
            ++entryLength;
        }
        if (planOrder != null) {
            planOrderCol.add(planOrder);
        }
        PlanOrderFactory.getLocalInstance(ctx).addnew(planOrderCol);
        return planOrderNOs;
    }

    public static String getCreateTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" CREATE TABLE TEML_KSQL_0");
        sql.append(" (FSouID VARCHAR(44),");
        sql.append("FMaterialID VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FSafetyQty DECIMAL(21,8),");
        sql.append("FInstanceStorage DECIMAL(21,8),");
        sql.append("FPlanQty DECIMAL(21,8),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FPlanBaseQty DECIMAL(21,8),");
        sql.append("FPlanDate DateTime,");
        sql.append("FReqDate DateTime,");
        sql.append("FPlannerID VARCHAR(44),");
        sql.append("FMaxStorage DECIMAL(21,8),");
        sql.append("FRop DECIMAL(21,8),");
        sql.append("FLotStategy INT,");
        sql.append("FFixedLot DECIMAL(21,8),");
        sql.append("FBeginDate DateTime,");
        sql.append("FPlanOrderReleasedCount INT)");
        return sql.toString();
    }

    public static String getInsertTempTableSql(Context ctx, String tableName, ROPParam ropParam, java.util.Date planDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strPlanDate = df.format(planDate);
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ");
        sql.append(tableName);
        sql.append(" SELECT");
        sql.append(" matInv.FOrgUnit,");
        sql.append(" matInv.FMaterialID,");
        sql.append(" matInv.FUnitID,");
        sql.append(" matInv.FQtySafety,");
        sql.append(" ISNULL(SUM(inv.FBaseQty) * immua.FBaseConvsRate / immub.FBaseConvsRate , 0),");
        sql.append(" 0,");
        sql.append(" mat.FBaseUnit,");
        sql.append(" 0,");
        sql.append(" TO_DATE('").append(strPlanDate).append("'),");
        sql.append(" DATEADD(DAY, matInv.FPurchasingAheadDate , TO_DATE('").append(strPlanDate).append("')),");
        sql.append(" matInv.FInvPlanner,");
        sql.append(" matInv.FQtyMax,");
        sql.append(" matInv.FReBookQty,");
        sql.append(" matInv.FBatchPolicy,");
        sql.append(" matInv.FFixationBatchQty,");
        sql.append(" DATEADD(DAY, matInv.FPurchasingAheadDate * -1, TO_DATE('").append(strPlanDate).append("')),");
        sql.append(" 0 ");
        sql.append(" FROM T_BD_MaterialInventory matInv LEFT OUTER JOIN T_IM_Inventory inv ON matInv.FMaterialID = inv.FMaterialID AND matInv.FOrgUnit = inv.FStorageOrgUnitID");
        sql.append(" INNER JOIN T_BD_Material mat ON matInv.FMaterialID = mat.FID");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit immua ON immua.FMeasureUnitID = mat.FBaseUnit AND immua.FMaterialID = matInv.FMaterialID");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit immub ON immub.FMeasureUnitID = matInv.FUnitID AND immub.FMaterialID = matInv.FMaterialID");
        sql.append(" WHERE matInv.FStatus = ").append(1);
        sql.append(" AND matInv.FPlanningMode = ").append(1);
        if (ropParam != null) {
            sql.append(" AND ").append(ROPServerUtils.getWhereSqlByROPParam(ctx, ropParam));
        }
        sql.append(" GROUP BY matInv.FOrgUnit, matInv.FMaterialID, matInv.FUnitID, matInv.FQtySafety, mat.FBaseUnit, matInv.FInvPlanner, matInv.FQtyMax, matInv.FReBookQty, matInv.FBatchPolicy,  matInv.FFixationBatchQty, matInv.FPurchasingAheadDate, immua.FBaseConvsRate, immub.FBaseConvsRate");
        return sql.toString();
    }

    public static String getUpdateTempTableSql_countPlanOrderReleased(Context ctx, String tableName) {
        StringBuffer sql = new StringBuffer();
        if (KsqlUtil.isSQLServer((Context)ctx)) {
            sql.append(" UPDATE ").append(tableName);
            sql.append(" SET (FPlanOrderReleasedCount) = ");
            sql.append(" ( ");
            sql.append(" SELECT FCount From ");
            sql.append(" ( ");
            sql.append(" SELECT COUNT(entry.FID) AS FCount, head.FStorageOrgUnitID AS FStorageOrgUnitID, entry.FMaterialID AS FMaterialID, MAX(entry.FPlanDate) AS FPlanDate ");
            sql.append(" FROM T_IM_PlanOrderEntry entry INNER JOIN T_IM_PlanOrder head ON entry.FParentID = head.FID ");
            sql.append(" WHERE entry.FBaseStatus >= ").append(5);
            sql.append(" GROUP BY head.FStorageOrgUnitID, entry.FMaterialID ");
            sql.append(" ) TT ");
            sql.append(" WHERE TT.FStorageOrgUnitID = ").append(tableName).append(".FSouID ");
            sql.append(" AND TT.FMaterialID = ").append(tableName).append(".FMaterialID ");
            sql.append(" AND TT.FPlanDate >= ").append(tableName).append(".FBeginDate ");
            sql.append(" AND TT.FPlanDate <= ").append(tableName).append(".FPlanDate ");
            sql.append(" )");
        } else {
            sql.append(" UPDATE ").append(tableName).append(" AS T1 ");
            sql.append(" SET FPlanOrderReleasedCount = ");
            sql.append(" SELECT COUNT(entry.FID) FROM T_IM_PlanOrderEntry entry INNER JOIN T_IM_PlanOrder head ON entry.FParentID = head.FID");
            sql.append(" WHERE entry.FBaseStatus >= ").append(5);
            sql.append(" AND head.FStorageOrgUnitID = T1.FSouID AND entry.FMaterialID = T1.FMaterialID");
            sql.append(" AND entry.FPlanDate >= T1.FBeginDate AND entry.FPlanDate <= T1.FPlanDate");
        }
        return sql.toString();
    }

    public static String getUpdateTempTableSql_calPlanQty(Context ctx, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(tableName).append(" AS T1 ");
        sql.append(" SET (FPlanQty, FPlanBaseQty) = ");
        sql.append(" (SELECT ");
        sql.append(" CASE WHEN TMP.FLotStategy = ").append(1).append(" THEN TMP.FFixedLot ");
        sql.append(" WHEN TMP.FLotStategy = ").append(5).append(" THEN TMP.FMaxStorage - TMP.FInstanceStorage ");
        sql.append(" END, ");
        sql.append(" (CASE WHEN TMP.FLotStategy = ").append(1).append(" THEN TMP.FFixedLot ");
        sql.append(" WHEN TMP.FLotStategy = ").append(5).append(" THEN TMP.FMaxStorage - TMP.FInstanceStorage ");
        sql.append(" END) * immua.FBaseConvsRate / immub.FBaseConvsRate ");
        sql.append(" FROM ").append(tableName).append(" TMP ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit immua ON immua.FMeasureUnitID = TMP.FUnitID AND immua.FMaterialID = TMP.FMaterialID");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit immub ON immub.FMeasureUnitID = TMP.FBaseUnitID AND immub.FMaterialID = TMP.FMaterialID");
        sql.append(" WHERE TMP.FInstanceStorage < TMP.FRop");
        sql.append(" AND TMP.FSouID = T1.FSouID AND TMP.FMaterialID = T1.FMaterialID )");
        return sql.toString();
    }

    private static String getWhereSqlByROPParam(Context ctx, ROPParam ropParam) {
        String planner;
        String materialTo;
        if (ropParam == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        String[] souIDs = ropParam.getSouIDs();
        if (souIDs == null || souIDs.length <= 0) {
            return null;
        }
        sql.append(" matInv.FOrgUnit IN ").append(InvServerUtils.getInStringFromArray(souIDs));
        String materialFrom = ropParam.getMaterialNumberFrom();
        if (!StringUtils.isEmpty((String)materialFrom)) {
            sql.append(" AND mat.FNumber >= '").append(materialFrom).append("'");
        }
        if (!StringUtils.isEmpty((String)(materialTo = ropParam.getMaterialNumberTo()))) {
            sql.append(" AND mat.FNumber <= '").append(materialTo).append("'");
        }
        if (!StringUtils.isEmpty((String)(planner = ropParam.getPlanner()))) {
            sql.append(" AND matInv.FInvPlanner = '").append(planner).append("'");
        }
        return sql.toString();
    }
}

