/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.IRelationOfChildAndParentFacade;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.ISysBillFacade;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.RelationOfChildAndParentFacadeFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.SplitBillException;
import com.kingdee.eas.scm.im.inv.SysBillFacadeFactory;
import com.kingdee.eas.scm.im.inv.app.AbstractSaleIssueBillSplitFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SaleIssueBillSplitFacadeControllerBean
extends AbstractSaleIssueBillSplitFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SaleIssueBillSplitFacadeControllerBean.class);
    private int moneyPrecision = 2;
    private Map pricePrecisionMap = null;
    private int costPrecision = 2;
    private Map qtyPrecisionMap = null;
    private Map baseConvsRateMap = null;
    private SaleIssueBillCollection saleIssueBillCol = null;
    private HashMap hmCheckMsg = new HashMap();
    private HashMap hmSeqManager = new HashMap();
    private static final String ENTRY_TABLE_NAME = "T_IM_SaleIssueEntry";
    private Set allUnWritedBillSet = new HashSet();
    private boolean isBillSplitChangeDate = false;
    private boolean isPastPeriod = false;
    public static final String RES_InvUI = "com.kingdee.eas.scm.im.inv.app.RelationOfChildAndParentResource";

    private void initPrecisions(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws BOSException, EASBizException {
        this.initMoneyPrecisionByBillCurrency(ctx, saleIssueBillInfo.getCurrency());
        SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
        if (entryCol.size() > 0 && null != entryCol.get(0).getCompanyOrgUnit()) {
            this.initCostPrecisionByCompanyBaseCurrency(ctx, saleIssueBillInfo.getEntry().get(0).getCompanyOrgUnit());
        } else {
            this.costPrecision = 2;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        ArrayList<String> materialIdList = new ArrayList<String>();
        ArrayList<String> unitIdList = new ArrayList<String>();
        ArrayList<String> baseUnitIdList = new ArrayList<String>();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            SaleIssueEntryInfo entry = entryCol.get(i);
            materialIdSet.add(entry.getMaterial().getId().toString());
            materialIdList.add(entry.getMaterial().getId().toString());
            unitIdList.add(entry.getUnit().getId().toString());
            baseUnitIdList.add(entry.getBaseUnit().getId().toString());
        }
        this.initPrecisionByMaterial(ctx, materialIdSet);
        this.initQtyPrecisionAndBaseConvsrate(ctx, materialIdList, unitIdList, baseUnitIdList);
    }

    private int getQtyPrecision(String materialId, String measureUnitId) {
        int qtyPricesion = 2;
        if (materialId == null || measureUnitId == null) {
            return qtyPricesion;
        }
        Integer qtyPreInteger = null;
        String key = materialId + measureUnitId;
        if (null != this.qtyPrecisionMap && this.qtyPrecisionMap.containsKey(key)) {
            qtyPreInteger = (Integer)this.qtyPrecisionMap.get(key);
        }
        if (null != qtyPreInteger) {
            qtyPricesion = qtyPreInteger;
        }
        return qtyPricesion;
    }

    private BigDecimal getBaseConvsrate(String materialId, String measureUnitId) {
        if (materialId == null || measureUnitId == null) {
            return SCMConstant.BIGDECIMAL_ONE;
        }
        BigDecimal baseConvsrate = null;
        String key = materialId + measureUnitId;
        if (null != this.baseConvsRateMap && this.baseConvsRateMap.containsKey(key)) {
            baseConvsrate = (BigDecimal)this.baseConvsRateMap.get(key);
        }
        if (null == baseConvsrate) {
            baseConvsrate = SCMConstant.BIGDECIMAL_ONE;
        }
        return baseConvsrate;
    }

    private void initQtyPrecisionAndBaseConvsrate(Context ctx, List materialIdList, List unitIdList, List baseUnitIdList) throws BOSException {
        this.qtyPrecisionMap = new HashMap();
        this.baseConvsRateMap = new HashMap();
        if (null == materialIdList || materialIdList.size() == 0 || null == unitIdList || unitIdList.size() == 0 || null == baseUnitIdList || baseUnitIdList.size() == 0) {
            return;
        }
        int idSize = materialIdList.size();
        if (idSize > unitIdList.size()) {
            idSize = unitIdList.size();
        }
        if (idSize > baseUnitIdList.size()) {
            idSize = baseUnitIdList.size();
        }
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        for (int i = 0; i < idSize; ++i) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialIdList.get(i)));
            filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", unitIdList.get(i)));
            maskString.append(" (#").append(index).append(" and #").append(index + 1).append(") or");
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialIdList.get(i)));
            filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", baseUnitIdList.get(i)));
            maskString.append(" (#").append(index + 2).append(" and #").append(index + 3).append(") or");
            index += 4;
        }
        if (maskString.length() > 2) {
            maskString.setLength(maskString.length() - 2);
        }
        filterInfo.setMaskString(maskString.toString());
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("measureUnit.id"));
        selector.add(new SelectorItemInfo("qtyPrecision"));
        selector.add(new SelectorItemInfo("baseConvsRate"));
        entityViewInfo.setSelector(selector);
        MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entityViewInfo);
        if (col == null || col.size() == 0) {
            return;
        }
        MultiMeasureUnitInfo mmu = null;
        String key = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            mmu = col.get(i);
            key = mmu.getMaterial().getId().toString() + mmu.getMeasureUnit().getId().toString();
            this.qtyPrecisionMap.put(key, new Integer(mmu.getQtyPrecision()));
            this.baseConvsRateMap.put(key, mmu.getBaseConvsRate());
        }
    }

    public int getPricePrecision(String materialInfoId) {
        if (null == materialInfoId || "".equals(materialInfoId.trim()) || null == this.pricePrecisionMap || this.pricePrecisionMap.size() == 0) {
            return 2;
        }
        Integer precision = (Integer)this.pricePrecisionMap.get(materialInfoId);
        if (null == precision) {
            return 2;
        }
        return precision;
    }

    public int getCostPrecision() {
        return this.costPrecision;
    }

    public int getMoneyPrecision() {
        return this.moneyPrecision;
    }

    @Override
    protected void _check(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ISaleIssueBill saleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)saleIssueBill.getValue(pk, selector);
        this.checkForSplitBill(ctx, saleIssueBillInfo);
    }

    protected void checkAddClose(Context ctx, IObjectPK[] pkIDs, Date childBizDate) throws BOSException, EASBizException {
        int i;
        if (null == pkIDs || pkIDs.length == 0) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        ISaleIssueBill saleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        SaleIssueBillInfo saleIssueBillInfo = null;
        SaleIssueEntryInfo entryInfo = null;
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        int len = pkIDs.length;
        for (int i2 = 0; i2 < len; ++i2) {
            idSet.add(pkIDs[i2]);
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entity.setFilter(filter);
        this.saleIssueBillCol = saleIssueBill.getSaleIssueBillCollection(entity);
        for (int i3 = 0; i3 < this.saleIssueBillCol.size(); ++i3) {
            saleIssueBillInfo = this.saleIssueBillCol.get(i3);
            if (!saleIssueBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                this.hmCheckMsg.put(saleIssueBillInfo.getNumber() + "  ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"Not_Audited", (Locale)ctx.getLocale()));
                this.saleIssueBillCol.remove(saleIssueBillInfo);
                --i3;
                continue;
            }
            if (this.isDelegatereSaleTransactionType(saleIssueBillInfo.getBizType())) {
                this.hmCheckMsg.put(saleIssueBillInfo.getNumber() + "   ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"CommissionSaleBill", (Locale)ctx.getLocale()));
                this.saleIssueBillCol.remove(saleIssueBillInfo);
                --i3;
                continue;
            }
            if (this.checkExistsNextBillBySplit(ctx, this.getDestTableName(), saleIssueBillInfo.getId().toString())) {
                this.hmCheckMsg.put(saleIssueBillInfo.getNumber() + "  ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"HasNextBillNotAudit", (Locale)ctx.getLocale()));
                this.saleIssueBillCol.remove(saleIssueBillInfo);
                --i3;
                continue;
            }
            if (this.checkIsTotalSaleFeeNotZero(saleIssueBillInfo).booleanValue()) {
                this.hmCheckMsg.put(saleIssueBillInfo.getNumber() + "  ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"WriteOffSplitTotalSaleFeeIsNotZero", (Locale)ctx.getLocale()));
                this.saleIssueBillCol.remove(saleIssueBillInfo);
                --i3;
                continue;
            }
            String errorStr = this.checkNextBillBySplitExtend(ctx, saleIssueBillInfo);
            if (StringUtils.isEmpty((String)errorStr)) continue;
            this.hmCheckMsg.put(saleIssueBillInfo.getNumber() + "  ", errorStr);
            this.saleIssueBillCol.remove(saleIssueBillInfo);
            --i3;
        }
        if (this.saleIssueBillCol.size() == 0) {
            return;
        }
        StorageOrgUnitInfo sou = this.saleIssueBillCol.get(0).getStorageOrgUnit();
        Date billBizDate = this.saleIssueBillCol.get(0).getBizDate();
        CompanyOrgUnitInfo cou = InvServerUtils.getCompanyInfoForStorage(ctx, sou);
        PeriodInfo billPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)billBizDate, (CompanyOrgUnitInfo)cou);
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        boolean isClose = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        boolean billInCurPeriod = false;
        if (isClose) {
            PeriodInfo childPeriodInfo;
            if (childBizDate != null && (childPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)childBizDate, (CompanyOrgUnitInfo)cou)).getId().equals((Object)currentPeriodinfo.getId())) {
                billInCurPeriod = true;
            }
            if (billPeriodInfo.getId().equals((Object)currentPeriodinfo.getId())) {
                billInCurPeriod = true;
            }
            if (billInCurPeriod) {
                throw new SplitBillException(SplitBillException.BILLPERIODCLOSE);
            }
        }
        if (billPeriodInfo.getBeginDate().before(currentPeriodinfo.getBeginDate())) {
            this.isPastPeriod = true;
        }
        if (!this.isPastPeriod) {
            ArrayList<String> orgIdStrList = new ArrayList<String>();
            ArrayList<String> paramNumberList = new ArrayList<String>();
            paramNumberList.add("INM100");
            for (int i4 = 0; i4 < this.saleIssueBillCol.size(); ++i4) {
                saleIssueBillInfo = this.saleIssueBillCol.get(i4);
                if (orgIdStrList.contains(saleIssueBillInfo.getStorageOrgUnit().getId().toString())) continue;
                orgIdStrList.add(saleIssueBillInfo.getStorageOrgUnit().getId().toString());
            }
            ArrayList paramList = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMapBatch(paramNumberList, orgIdStrList);
            ParamSimpleInfo paramInfo = null;
            if (paramList.size() > 0) {
                paramInfo = (ParamSimpleInfo)paramList.get(0);
                this.isBillSplitChangeDate = Boolean.TRUE.toString().equals(paramInfo.getParamValue());
            }
        }
        for (i = 0; i < this.saleIssueBillCol.size(); ++i) {
            saleIssueBillInfo = this.saleIssueBillCol.get(i);
            SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
            boolean isAllWrittenOff = true;
            for (int j = 0; j < entryCol.size(); ++j) {
                entryInfo = entryCol.get(j);
                if (entryInfo.getUnWriteOffQty().compareTo(SysConstant.BIGZERO) == 0) continue;
                isAllWrittenOff = false;
                break;
            }
            if (isAllWrittenOff) {
                this.hmCheckMsg.put(saleIssueBillInfo.getNumber() + "  ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"WrittenOff", (Locale)ctx.getLocale()));
            }
            boolean isAllUnWrited = true;
            for (int j = 0; j < entryCol.size(); ++j) {
                entryInfo = entryCol.get(j);
                if (entryInfo.getWrittenOffQty().compareTo(SysConstant.BIGZERO) == 0 && (this.isPastPeriod || !this.isBillSplitChangeDate)) continue;
                isAllUnWrited = false;
                break;
            }
            if (isAllUnWrited) {
                this.hmCheckMsg.put(saleIssueBillInfo.getNumber() + "  ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"NoneWrittenOff_SplitChangeDateFalse_pastPeriod", (Locale)ctx.getLocale()));
            }
            if (!isAllWrittenOff && !isAllUnWrited) continue;
            this.saleIssueBillCol.remove(saleIssueBillInfo);
            --i;
        }
        if (this.isBillSplitChangeDate && !this.isPastPeriod) {
            for (i = 0; i < this.saleIssueBillCol.size(); ++i) {
                saleIssueBillInfo = this.saleIssueBillCol.get(i);
                boolean isAllUnWrited = true;
                SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
                for (int j = 0; j < entryCol.size(); ++j) {
                    entryInfo = entryCol.get(j);
                    if (entryInfo.getWrittenOffQty().compareTo(SysConstant.BIGZERO) == 0) continue;
                    isAllUnWrited = false;
                    break;
                }
                if (!isAllUnWrited) continue;
                this.allUnWritedBillSet.add(saleIssueBillInfo.getId().toString());
            }
        }
    }

    @Override
    protected void _check(Context ctx, IObjectPK[] pkIDs) throws BOSException, EASBizException {
        this.checkAddClose(ctx, pkIDs, null);
    }

    private void removeSaleBackWriteOffOver(Context ctx, SaleIssueBillCollection saleIssueBillCol) throws BOSException {
        if (saleIssueBillCol.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select relat.FSrcObjectID as FSrcObjectID,bill.FBaseStatus as FBaseStatus,entry.FUnWriteOffBaseQty as  FUnWriteOffBaseQty");
        sql.append(" from T_IM_SaleIssueBill bill ");
        sql.append(" inner join T_IM_SaleIssueEntry entry on bill.FID = entry.FParentID ");
        sql.append(" inner join T_BOT_Relation relat on bill.FID = relat.FDestObjectID and relat.FDestEntityID = 'CC3E933B' ");
        sql.append(" inner join T_BOT_RelationEntry rEntry on rEntry.FKeyID = relat.FID and rEntry.FDestEntryID = entry.FID ");
        sql.append(" where bill.FBizTypeID in ( ");
        sql.append(" '").append("d8e80652-0110-1000-e000-04c5c0a812202407435C").append("', ");
        sql.append(" '").append("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=").append("', ");
        sql.append(" '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ) ");
        StringBuffer subsql = new StringBuffer();
        SaleIssueBillInfo saleIssueBillInfo = null;
        SaleIssueEntryCollection entryCol = null;
        subsql.append(" and ( ");
        for (int i = 0; i < saleIssueBillCol.size(); ++i) {
            if (i > 0) {
                subsql.append(" or ");
            }
            saleIssueBillInfo = saleIssueBillCol.get(i);
            subsql.append(" ( relat.FSrcObjectID = '").append(saleIssueBillInfo.getId().toString()).append("' ");
            entryCol = saleIssueBillInfo.getEntry();
            subsql.append(" and rEntry.FSrcEntryID in ( ");
            for (int j = 0; j < entryCol.size(); ++j) {
                if (j > 0) {
                    subsql.append(",");
                }
                subsql.append("'").append(entryCol.get(j).getId().toString()).append("'");
            }
            subsql.append(" ))");
        }
        subsql.append(")");
        sql.append(subsql);
        try {
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
            block4: while (rowSet.next()) {
                String srcObjectID = null;
                BigDecimal unWriteOffBaseQty = null;
                srcObjectID = rowSet.getString("FSrcObjectID");
                unWriteOffBaseQty = rowSet.getBigDecimal("FUnWriteOffBaseQty");
                if (rowSet.getInt("FBaseStatus") == 4 && (null == unWriteOffBaseQty || unWriteOffBaseQty.compareTo(SysConstant.BIGZERO) <= 0)) continue;
                for (int j = 0; j < saleIssueBillCol.size(); ++j) {
                    if (!srcObjectID.equals(saleIssueBillCol.get(j).getId().toString())) continue;
                    if (rowSet.getInt("FBaseStatus") != 4) {
                        this.hmCheckMsg.put(saleIssueBillCol.get(j).getNumber() + "   ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"SaleBack_UnAudit", (Locale)ctx.getLocale()));
                        saleIssueBillCol.removeObject(j);
                        continue block4;
                    }
                    if (null == unWriteOffBaseQty || unWriteOffBaseQty.compareTo(SysConstant.BIGZERO) <= 0) continue;
                    this.hmCheckMsg.put(saleIssueBillCol.get(j).getNumber() + "   ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"SaleBack_UnWriteOff", (Locale)ctx.getLocale()));
                    saleIssueBillCol.removeObject(j);
                    continue block4;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void removeBelowBizArBill(Context ctx, SaleIssueBillCollection saleIssueBillCol) throws BOSException {
        if (saleIssueBillCol.size() == 0) {
            return;
        }
        StringBuffer idBuffer = new StringBuffer();
        for (int i = 0; i < saleIssueBillCol.size(); ++i) {
            if (i > 0) {
                idBuffer.append(",");
            }
            idBuffer.append("'");
            idBuffer.append(saleIssueBillCol.get(i).getId().toString());
            idBuffer.append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.FSrcObjectID as FSrcObjectID from T_AR_OtherBill t0 inner join T_BOT_Relation t1 on t0.FID = t1.FDestObjectID ");
        sql.append(" where t0.FIsBizBill = 1 and t1.FDestEntityID='FC910EF3' and t1.FSrcObjectID in( ").append(idBuffer.toString());
        sql.append(" )");
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
        try {
            String srcObjectID = null;
            block3: while (rowSet.next()) {
                srcObjectID = rowSet.getString("FSrcObjectID");
                for (int j = 0; j < saleIssueBillCol.size(); ++j) {
                    if (!srcObjectID.equals(saleIssueBillCol.get(j).getId().toString())) continue;
                    this.hmCheckMsg.put(saleIssueBillCol.get(j).getNumber() + "   ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"ExsitBelowBizArBill", (Locale)ctx.getLocale()));
                    saleIssueBillCol.removeObject(j);
                    continue block3;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void removeArOtherBillWriteOffOver_Ext(Context ctx, SaleIssueBillCollection saleIssueBillCol) throws BOSException {
        if (saleIssueBillCol.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select relat.FSrcObjectID as FSrcObjectID ,entry.FUnWriteOffBaseQty as FUnWriteOffBaseQty ,bill.FBillStatus as FBillStatus");
        sql.append(" from T_AR_OtherBill bill ");
        sql.append(" inner join T_AR_OtherBillentry entry on bill.FID = entry.FParentID ");
        sql.append(" inner join T_BOT_Relation relat on bill.FID = relat.FDestObjectID and relat.FDestEntityID = 'FC910EF3' ");
        sql.append(" inner join T_BOT_RelationEntry rEntry on rEntry.FKeyID = relat.FID and rEntry.FDestEntryID = entry.FID ");
        StringBuffer subsql = new StringBuffer();
        SaleIssueBillInfo saleIssueBillInfo = null;
        SaleIssueEntryCollection entryCol = null;
        subsql.append(" and ( ");
        for (int i = 0; i < saleIssueBillCol.size(); ++i) {
            if (i > 0) {
                subsql.append(" or ");
            }
            saleIssueBillInfo = saleIssueBillCol.get(i);
            subsql.append(" ( relat.FSrcObjectID = '").append(saleIssueBillInfo.getId().toString()).append("' ");
            entryCol = saleIssueBillInfo.getEntry();
            subsql.append(" and rEntry.FSrcEntryID in ( ");
            for (int j = 0; j < entryCol.size(); ++j) {
                if (j > 0) {
                    subsql.append(",");
                }
                subsql.append("'").append(entryCol.get(j).getId().toString()).append("'");
            }
            subsql.append(" ))");
        }
        subsql.append(")");
        sql.append(subsql);
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
        String srcObjectID = null;
        BigDecimal unWriteOffBaseQty = null;
        try {
            block4: while (rowSet.next()) {
                srcObjectID = rowSet.getString("FSrcObjectID");
                unWriteOffBaseQty = rowSet.getBigDecimal("FUnWriteOffBaseQty");
                if (rowSet.getInt("FBillStatus") == 3 && (null == unWriteOffBaseQty || unWriteOffBaseQty.compareTo(SysConstant.BIGZERO) <= 0)) continue;
                for (int j = 0; j < saleIssueBillCol.size(); ++j) {
                    if (!srcObjectID.equals(saleIssueBillCol.get(j).getId().toString())) continue;
                    if (rowSet.getInt("FBillStatus") != 4) {
                        this.hmCheckMsg.put(saleIssueBillCol.get(j).getNumber() + "   ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"ArOtherBill_UnAudit", (Locale)ctx.getLocale()));
                        saleIssueBillCol.removeObject(j);
                        continue block4;
                    }
                    if (null == unWriteOffBaseQty || unWriteOffBaseQty.compareTo(SysConstant.BIGZERO) <= 0) continue;
                    this.hmCheckMsg.put(saleIssueBillCol.get(j).getNumber() + "   ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"ArOtherBill_UnWriteOff", (Locale)ctx.getLocale()));
                    saleIssueBillCol.removeObject(j);
                    continue block4;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void removeBelowBill(Context ctx, SaleIssueBillCollection saleIssueBillCol) throws BOSException {
        if (saleIssueBillCol.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemCol = filter.getFilterItems();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < saleIssueBillCol.size(); ++i) {
            idSet.add(saleIssueBillCol.get(i).getId().toString());
        }
        filterItemCol.add(new FilterItemInfo("srcObjectID", idSet, CompareType.INCLUDE));
        filterItemCol.add(new FilterItemInfo("destEntityID", (Object)"FC910EF3", CompareType.NOTEQUALS));
        filterItemCol.add(new FilterItemInfo("destEntityID", (Object)"2652E01E", CompareType.NOTEQUALS));
        filterItemCol.add(new FilterItemInfo("destEntityID", (Object)"CC3E933B", CompareType.NOTEQUALS));
        filterItemCol.add(new FilterItemInfo("destEntityID", (Object)"783061E3", CompareType.NOTEQUALS));
        view.setFilter(filter);
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("srcObjectID"));
        view.setSelector(selectorCol);
        BOTRelationCollection retCol = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        String srcObjectID = null;
        if (retCol.size() > 0) {
            block1: for (int i = 0; i < retCol.size(); ++i) {
                srcObjectID = retCol.get(i).getSrcObjectID();
                for (int j = 0; j < saleIssueBillCol.size(); ++j) {
                    if (!srcObjectID.equals(saleIssueBillCol.get(j).getId().toString())) continue;
                    this.hmCheckMsg.put(saleIssueBillCol.get(j).getNumber() + "   ", ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"ExsitBelowBill", (Locale)ctx.getLocale()));
                    saleIssueBillCol.removeObject(j);
                    continue block1;
                }
            }
        }
    }

    private void checkForSplitBill(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws BOSException, EASBizException {
        if (saleIssueBillInfo == null) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        if (!BillBaseStatusEnum.AUDITED.equals((Object)saleIssueBillInfo.getBaseStatus())) {
            throw new SplitBillException(SplitBillException.BILLNOTAUDIT);
        }
        if (this.isDelegatereSaleTransactionType(saleIssueBillInfo.getBizType())) {
            throw new SplitBillException(SplitBillException.COMMISSIONSALEBILL);
        }
        if (this.isWriteOffOver(saleIssueBillInfo)) {
            throw new SplitBillException(SplitBillException.BILLWRITEOFFOVER);
        }
        if (this.checkExistsNextBillBySplit(ctx, this.getDestTableName(), saleIssueBillInfo.getId().toString())) {
            throw new InvBizException(InvBizException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"HasNextBillNotAudit", (Locale)ctx.getLocale())});
        }
        if (this.checkIsTotalSaleFeeNotZero(saleIssueBillInfo).booleanValue()) {
            throw new InvBizException(InvBizException.HANDLESPLITTOTALSALEFEEISNOTZERO, new Object[]{saleIssueBillInfo.getNumber()});
        }
        String errorStr = this.checkNextBillBySplitExtend(ctx, saleIssueBillInfo);
        if (!StringUtils.isEmpty((String)errorStr)) {
            throw new InvBizException(InvBizException.COMMON, new Object[]{errorStr});
        }
    }

    public String checkNextBillBySplitExtend(Context ctx, SaleIssueBillInfo info) throws EASBizException, BOSException {
        return "";
    }

    private String[][] getDestTableName() {
        String[][] tableName = new String[][]{{"T_CAS_ReceivingBill", "T_CAS_ReceivingBillEntry"}, {"T_SD_SaleReturns", "T_SD_SaleReturnsEntry"}, {"T_AR_OtherBill", "T_AR_OtherBillEntry"}, {"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_AR_IncomeConfimBill", "T_AR_IncomeConfimEntry"}, {"T_IM_SaleIssueBill", ENTRY_TABLE_NAME}};
        return tableName;
    }

    private boolean checkExistsNextBillBySplit(Context ctx, String[][] tableName, String id) throws BOSException {
        boolean isExists = false;
        if (tableName != null && tableName.length > 0) {
            int billCount = tableName.length;
            StringBuffer sql = new StringBuffer();
            for (int i = 0; i < billCount; ++i) {
                if (i > 0) {
                    sql.append(" union all ");
                }
                sql.append(this.getBillSql(tableName[i][0], tableName[i][1], id));
            }
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.next()) {
                    isExists = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isExists;
    }

    private String getBillSql(String headTable, String entryTable, String id) {
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.FID from ").append(entryTable).append(" entry \n ");
        sql.append("inner join ").append(headTable).append(" bill on bill.FID = \n");
        if ("T_CAS_ReceivingBill".equals(headTable)) {
            sql.append("entry.FReceivingBillID ");
        } else {
            sql.append("entry.FParentID ");
        }
        sql.append("inner join T_IM_SaleIssueEntry srcEntry on entry.FSourceBillEntryID = srcEntry.FID \n");
        sql.append("and srcEntry.FParentID = '").append(id).append("' and ");
        if ("T_CAS_ReceivingBill".equals(headTable)) {
            sql.append("bill.FBillStatus in (1,2) ");
        } else if ("T_AR_OtherBill".equals(headTable)) {
            sql.append(" ( bill.FBillStatus in (1,2) or ( bill.FBillStatus = 3 and bill.FISBIZBILL = 1 )) ");
        } else if ("T_SD_SaleReturns".equals(headTable)) {
            sql.append("bill.FBaseStatus not in (3,4,6,7) ");
        } else if ("T_AR_IncomeConfimBill".equals(headTable)) {
            sql.append("bill.FBillStatus in (1,2) ");
        } else {
            sql.append("bill.FBaseStatus in (1,2) ");
        }
        return sql.toString();
    }

    private boolean isWriteOffOver(SaleIssueBillInfo saleIssueBillInfo) {
        SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
        boolean isWriteOffOver = true;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            if (null == entryCol.get(i).getUnWriteOffQty() || entryCol.get(i).getUnWriteOffQty().abs().compareTo(SysConstant.BIGZERO) <= 0) continue;
            isWriteOffOver = false;
            break;
        }
        return isWriteOffOver;
    }

    private boolean isDelegatereSaleTransactionType(BizTypeInfo bizTypeInfo) {
        if (null == bizTypeInfo) {
            return true;
        }
        return "d8e80652-0114-1000-e000-04c5c0a812202407435C".equals(bizTypeInfo.getId().toString()) || "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeInfo.getId().toString());
    }

    private boolean hasBelowBizArBill(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_AR_OtherBill where FIsBizBill = 1 and FID in ");
        sql.append(" ( select FDestObjectID  from T_BOT_Relation where FDestEntityID='FC910EF3' ");
        sql.append(" and FSrcObjectID ='").append(saleIssueBillInfo.getId().toString()).append("' ) ");
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
        return null != rowSet && rowSet.size() > 0;
    }

    private boolean hasSequenceManagerMaterial(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws BOSException, EASBizException {
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)saleIssueBillInfo.getId().toString()));
        return iMaterialSerialNumber.exists(filter);
    }

    private boolean isArOtherBillWriteOffOver(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws BOSException {
        HashMap billEntryIdMap = new HashMap();
        SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdMap.put(entryCol.get(i).getId().toString(), null);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select obill.FID,obill.FBillStatus,oentry.FUnWriteOffBaseQty,oentry.FID as FDestEntryID");
        sql.append(" from T_IM_SaleIssueBill sbill ");
        sql.append(" inner join T_BOT_Relation r on sbill.FID = r.FSrcObjectID and r.FdestEntityID='FC910EF3' ");
        sql.append(" inner join T_AR_OtherBill obill on obill.FID = r.FDestObjectID ");
        sql.append(" inner join T_AR_OtherBillentry oentry on oentry.FParentID = obill.FID ");
        sql.append(" where sbill.fid = '").append(saleIssueBillInfo.getId().toString()).append("' ");
        Set entryIdSet = billEntryIdMap.keySet();
        Iterator iterator = entryIdSet.iterator();
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
        if (null == rowSet || rowSet.size() == 0) {
            return true;
        }
        BigDecimal unWriteOffBaseQty = null;
        try {
            while (rowSet.next()) {
                if (rowSet.getInt("FBillStatus") != 3) {
                    return false;
                }
                unWriteOffBaseQty = rowSet.getBigDecimal("FUnWriteOffBaseQty");
                if (null != unWriteOffBaseQty && unWriteOffBaseQty.compareTo(SysConstant.BIGZERO) > 0) {
                    return false;
                }
                billEntryIdMap.put(rowSet.getString("FDestEntryID"), null);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private Set getWriteOffRecordInSameGroup(Context ctx, Set billEntryIDSet) throws BOSException {
        HashSet<String> result = new HashSet<String>();
        if (null == billEntryIDSet || billEntryIDSet.size() == 0) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select worecord.FbillEntryID ");
        sql.append(" from T_CL_WriteOffGroup wogroup inner join T_CL_WriteOffRecord worecord on  worecord.FParentID = wogroup.FID ");
        sql.append(" where wogroup.FID in ( ");
        sql.append(" select FParentID from  T_CL_WriteOffRecord where FbillEntryID in ( ");
        Iterator iterator = billEntryIDSet.iterator();
        while (iterator.hasNext()) {
            sql.append("'").append((String)iterator.next()).append("',");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" ) )");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                result.add(rowSet.getString("FbillEntryID"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }

    private boolean isSaleBackWriteOffOver(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws BOSException {
        HashMap billEntryIdMap = new HashMap();
        SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdMap.put(entryCol.get(i).getId().toString(), null);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select sbill.FID,sbill.FBaseStatus,sentry.FUnWriteOffBaseQty,sentry.FID as FDestEntryID ");
        sql.append(" from T_IM_SaleIssueBill bill ");
        sql.append(" left join  T_BOT_Relation r on r.FSrcObjectID = bill.FID and r.FdestEntityID = 'CC3E933B' ");
        sql.append(" left join T_IM_SaleIssueBill sbill on sbill.FID = r.FDestObjectID ");
        sql.append(" inner join T_IM_SaleIssueEntry sentry on sentry.FParentID=sbill.FID ");
        sql.append(" where sbill.FBizTypeID in ( ");
        sql.append(" '").append("d8e80652-0110-1000-e000-04c5c0a812202407435C").append("', ");
        sql.append(" '").append("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=").append("', ");
        sql.append(" '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("' ) ");
        sql.append("  and bill.fid = '").append(saleIssueBillInfo.getId().toString()).append("' ");
        Set entryIdSet = billEntryIdMap.keySet();
        Iterator<Object> iterator = entryIdSet.iterator();
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
        if (null == rowSet || rowSet.size() == 0) {
            return true;
        }
        HashSet<String> belowBillIdSet = new HashSet<String>();
        BigDecimal unWriteOffBaseQty = null;
        try {
            while (rowSet.next()) {
                if (rowSet.getInt("FBaseStatus") != 4) {
                    return false;
                }
                unWriteOffBaseQty = rowSet.getBigDecimal("FUnWriteOffBaseQty");
                if (null != unWriteOffBaseQty && unWriteOffBaseQty.compareTo(SysConstant.BIGZERO) > 0) {
                    return false;
                }
                belowBillIdSet.add(rowSet.getString("FID"));
                billEntryIdMap.put(rowSet.getString("FDestEntryID"), null);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Set billEntryIDSet = this.getWriteOffRecordInSameGroup(ctx, belowBillIdSet);
        iterator = billEntryIDSet.iterator();
        while (iterator.hasNext()) {
            if (billEntryIdMap.containsKey((String)iterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean hasBelowBill(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemCol = filter.getFilterItems();
        FilterItemCollection filterItemColEX = null;
        filterItemCol.add(new FilterItemInfo("srcObjectID", (Object)saleIssueBillInfo.getId().toString()));
        filterItemCol.add(new FilterItemInfo("destEntityID", (Object)"FC910EF3", CompareType.NOTEQUALS));
        filterItemCol.add(new FilterItemInfo("destEntityID", (Object)"2652E01E", CompareType.NOTEQUALS));
        filterItemCol.add(new FilterItemInfo("destEntityID", (Object)"CC3E933B", CompareType.NOTEQUALS));
        filterItemCol.add(new FilterItemInfo("destEntityID", (Object)"783061E3", CompareType.NOTEQUALS));
        filterItemColEX = this.getfilterItemColEX();
        if (filterItemColEX != null) {
            filterItemCol.addObjectCollection((IObjectCollection)filterItemColEX);
        }
        view.setFilter(filter);
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        view.setSelector(selectorCol);
        BOTRelationCollection retCol = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        return null != retCol && retCol.size() > 0;
    }

    @Override
    protected void _split(Context ctx, IObjectPK pk, Date bizDate) throws BOSException, EASBizException {
        CoreBaseInfo model = SaleIssueBillFactory.getLocalInstance(ctx).getValue(pk);
        this._split(ctx, (IObjectValue)model, bizDate);
    }

    @Override
    protected void _split(Context ctx, SaleIssueBillInfo model, Date bizDate, boolean isBillSplitChangeDate) throws BOSException, EASBizException {
        if (model == null || !(model instanceof SaleIssueBillInfo)) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        ObjectUuidPK pk = new ObjectUuidPK(model.getId());
        SelectorItemCollection selector = SCMSelectorFactory.getSaleIssueBillSelector((boolean)true);
        SaleIssueBillInfo childInfo = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo((IObjectPK)pk, this.addSelectors(selector));
        if (null != bizDate) {
            childInfo.setBizDate(bizDate);
            StorageOrgUnitInfo sou = childInfo.getStorageOrgUnit();
            CompanyOrgUnitInfo cou = null;
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
            cou = iSCMBillCommonFacade.getCompanyInfo(sou.getId());
            PeriodInfo bizPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)childInfo.getBizDate(), (CompanyOrgUnitInfo)cou, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
            if (bizPeriodInfo == null) {
                throw new SCMBillException(SCMBillException.GETBIZPERIODFAIL);
            }
            childInfo.setYear(bizPeriodInfo.getPeriodYear());
            childInfo.setPeriod(bizPeriodInfo.getPeriodNumber());
            SimpleDateFormat df1 = new SimpleDateFormat("yyyyMM");
            SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");
            String str1 = df1.format(bizDate);
            String str2 = df2.format(bizDate);
            childInfo.setMonth(Integer.parseInt(str1));
            childInfo.setDay(Integer.parseInt(str2));
            int size = childInfo.getEntry().size();
            for (int i = 0; i < size; ++i) {
                childInfo.getEntry().get(i).setBizDate(bizDate);
            }
        }
        ctx.put((Object)"SPLIT_ACTION", (Object)Boolean.TRUE);
        ISaleIssueBill saleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        saleIssueBill.update((IObjectPK)new ObjectUuidPK(childInfo.getId()), (CoreBaseInfo)childInfo);
    }

    protected SelectorItemCollection addSelectors(SelectorItemCollection selector) {
        return selector;
    }

    @Override
    protected void _split(Context ctx, IObjectValue model, Date bizDate) throws BOSException, EASBizException {
        if (model == null || !(model instanceof SaleIssueBillInfo)) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        HashMap moveBotpRealtionMap = new HashMap();
        HashMap addBotpRelationMap = new HashMap();
        ObjectUuidPK pk = new ObjectUuidPK(((SaleIssueBillInfo)model).getId());
        SelectorItemCollection selector = SCMSelectorFactory.getSaleIssueBillSelector((boolean)true);
        SaleIssueBillInfo motherInfo = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo((IObjectPK)pk, this.addSelectors(selector));
        SaleIssueBillInfo childInfo = (SaleIssueBillInfo)motherInfo.clone();
        this.splitBillInfo(ctx, motherInfo, childInfo, bizDate);
        this.initPrecisions(ctx, motherInfo);
        HashSet<String> idSet = new HashSet<String>();
        int size = motherInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            idSet.add(motherInfo.getEntry().get(i).getId().toString());
        }
        Map<String, String> flowMap = InvServerUtils.getBillBizFlowRelation(ctx, idSet, ENTRY_TABLE_NAME);
        this.splitEntryInfoByWriteOffQty(ctx, motherInfo, childInfo, moveBotpRealtionMap, addBotpRelationMap);
        if (motherInfo.getEntry().size() == 0 || childInfo.getEntry().size() == 0) {
            return;
        }
        this.calBillSumField(motherInfo);
        this.calBillSumField(childInfo);
        ISysBillFacade sysBillFacade = SysBillFacadeFactory.getLocalInstance(ctx);
        ObjectUuidPK motherPk = new ObjectUuidPK(motherInfo.getId().toString());
        ObjectUuidPK childPk = new ObjectUuidPK(childInfo.getId().toString());
        EntityViewInfo mView = new EntityViewInfo();
        FilterInfo mfilter = new FilterInfo();
        mfilter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)("*" + motherInfo.getNumber())));
        mView.setFilter(mfilter);
        SelectorItemCollection mSelector = new SelectorItemCollection();
        mSelector = new SelectorItemCollection();
        mSelector.add("id");
        mSelector.add("totalInvoicedQty");
        mSelector.add("tolInvoidBaseQty");
        mSelector.add("totalArAmount");
        mView.setSelector(mSelector);
        SaleOrderEntryCollection saleOrderEntrys = SaleOrderEntryFactory.getLocalInstance((Context)ctx).getSaleOrderEntryCollection(mView);
        boolean flag = sysBillFacade.delBuildOrderOrReturnBill((IObjectPK)motherPk, motherInfo, false);
        this.saveBillInfo(ctx, motherInfo, childInfo);
        this.spliteInfoEx(ctx, motherInfo, childInfo);
        if (flag) {
            this.cleanSysbillInfo(motherInfo, childInfo);
            sysBillFacade.buildOrderOrReturnBill((IObjectPK)motherPk, motherInfo, true);
            sysBillFacade.buildOrderOrReturnBill((IObjectPK)childPk, childInfo, false);
            if (saleOrderEntrys != null && saleOrderEntrys.size() > 0) {
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                Object[] param = null;
                SaleOrderEntryInfo entry = null;
                String updateSql = "update t_sd_saleorderentry set ftotalInvoicedQty = ?,ftolInvoidBaseQty = ?,ftotalArAmount = ? where fid = ?";
                for (int i = 0; i < saleOrderEntrys.size(); ++i) {
                    entry = saleOrderEntrys.get(i);
                    param = new Object[]{entry.getTotalInvoicedQty(), entry.getTolInvoidBaseQty(), entry.getTotalArAmount(), entry.getId().toString()};
                    paramList.add(param);
                }
                DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramList);
            }
        }
        this.updateBotp(ctx, motherInfo, childInfo, moveBotpRealtionMap, addBotpRelationMap);
        this.dealChildBillBotp(ctx, childInfo);
        if (childInfo.get("EntryRelation") != null && childInfo.get("EntryRelation") instanceof Map) {
            Map entryRelationMap = (Map)childInfo.get("EntryRelation");
            if (flowMap != null && flowMap.size() > 0 && entryRelationMap != null && entryRelationMap.size() > 0) {
                Iterator it = entryRelationMap.keySet().iterator();
                String key = "";
                HashMap<String, String> clildFlowMap = new HashMap<String, String>();
                while (it.hasNext()) {
                    key = it.next().toString();
                    if (!entryRelationMap.containsKey(key) || !flowMap.containsKey(key)) continue;
                    clildFlowMap.put(((String)entryRelationMap.get(key)).toString(), flowMap.get(key).toString() + "#" + ((String)entryRelationMap.get(key)).toString());
                }
                if (clildFlowMap != null && clildFlowMap.size() > 0) {
                    InvServerUtils.writeBizFlowRelation(ctx, clildFlowMap, ENTRY_TABLE_NAME);
                }
            }
        }
    }

    private void calBillSumField(SaleIssueBillInfo billInfo) {
        BigDecimal totalAmout = new BigDecimal("0.0");
        BigDecimal totalLocalAmout = new BigDecimal("0.0");
        SaleIssueEntryCollection tempCol = billInfo.getEntry();
        int size = tempCol.size();
        for (int i = 0; i < size; ++i) {
            totalAmout = totalAmout.add(tempCol.get(i).getAmount());
            totalLocalAmout = totalLocalAmout.add(tempCol.get(i).getLocalAmount());
        }
        totalAmout = totalAmout.setScale(this.getMoneyPrecision(), 4);
        totalLocalAmout = totalLocalAmout.setScale(this.getMoneyPrecision(), 4);
        billInfo.setTotalAmount(totalAmout);
        billInfo.setTotalLocalAmount(totalLocalAmout);
    }

    private void dealChildBillBotp(Context ctx, SaleIssueBillInfo childInfo) throws BOSException {
        StringBuffer queryBackSaleSql = new StringBuffer();
        queryBackSaleSql.append(" select bill.FID ");
        queryBackSaleSql.append(" from T_IM_SaleIssueBill bill inner join T_BOT_Relation relat on bill.FID = relat.FDestObjectID ");
        queryBackSaleSql.append(" where relat.FSrcObjectID='").append(childInfo.getId().toString()).append("' ");
        queryBackSaleSql.append(" and bill.FIsSysBill = 0 ");
        queryBackSaleSql.append(" and ( bill.FIsReversed=1 or FBizTypeID in ( ");
        queryBackSaleSql.append(" '").append("d8e80652-0110-1000-e000-04c5c0a812202407435C").append("', ");
        queryBackSaleSql.append(" '").append("wIZPS7oOQaOl1CeE/8cZOSQHQ1w=").append("', ");
        queryBackSaleSql.append(" '").append("d8e80652-0110-1000-e000-04c5c0a812202407435C").append("' ) ) ");
        StringBuffer queryBackOtherBillSql = new StringBuffer();
        queryBackOtherBillSql.append(" select other.fid from t_ar_otherbill other inner join t_bot_relation re ");
        queryBackOtherBillSql.append(" on other.fid = re.fdestobjectid where other.fisBizBill = 0 ");
        queryBackOtherBillSql.append(" and re.fsrcobjectid = '" + childInfo.getId().toString() + "'");
        StringBuffer delSql = new StringBuffer();
        delSql.append(" delete from T_BOT_Relation ");
        delSql.append(" where FSrcObjectID ='").append(childInfo.getId().toString()).append("' ");
        delSql.append(" and ( (FDestEntityID='FC910EF3' and FDestObjectID in (").append(queryBackOtherBillSql.toString()).append("))");
        delSql.append(" or ( FDestEntityID='CC3E933B' and FDestObjectID in ( ").append(queryBackSaleSql.toString()).append(" )))");
        DBUtil.executeUpdate((Context)ctx, (String)delSql.toString(), null);
    }

    private void updateBotp(Context ctx, SaleIssueBillInfo motherInfo, SaleIssueBillInfo childInfo, Map moveBotpRelationMap, Map addBotpRelationMap) throws BOSException {
        HashMap<Integer, String> seq2Id = new HashMap<Integer, String>();
        SaleIssueEntryCollection entryCol = childInfo.getEntry();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            SaleIssueEntryInfo entry = entryCol.get(i);
            seq2Id.put(new Integer(entry.getSeq()), entry.getId().toString());
        }
        String motherInfoId = motherInfo.getId().toString();
        String childInfoId = childInfo.getId().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)motherInfoId));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)motherInfoId));
        filter.setMaskString("#0 or #1");
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selectorItemCol = new SelectorItemCollection();
        selectorItemCol.add(new SelectorItemInfo("*"));
        selectorItemCol.add(new SelectorItemInfo("relationEntries.*"));
        entityViewInfo.setSelector(selectorItemCol);
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection botRelationCol = botRelation.getCollection(entityViewInfo);
        int size2 = botRelationCol.size();
        for (int i = 0; i < size2; ++i) {
            BOTRelationInfo botRelationInfo = botRelationCol.get(i);
            BOTRelationInfo childBotRelationInfo = (BOTRelationInfo)botRelationInfo.clone();
            if (motherInfoId.equals(botRelationInfo.getSrcObjectID())) {
                childBotRelationInfo.setId(null);
                childBotRelationInfo.setSrcObjectID(childInfoId);
            } else if (motherInfoId.equals(botRelationInfo.getDestObjectID())) {
                childBotRelationInfo.setId(null);
                childBotRelationInfo.setDestObjectID(childInfoId);
            }
            for (int j = 0; j < childBotRelationInfo.getRelationEntries().size(); ++j) {
                childBotRelationInfo.getRelationEntries().get(j).setId(null);
            }
            BOTRelationEntryCollection botRelationEntryCol = botRelationInfo.getRelationEntries();
            BOTRelationEntryCollection childBotRelationEntryCol = childBotRelationInfo.getRelationEntries();
            childBotRelationEntryCol.clear();
            botRelation.update((IObjectPK)new ObjectUuidPK(botRelationInfo.getId()), botRelationInfo);
            botRelation.addnew(childBotRelationInfo);
        }
    }

    private void saveBillInfo(Context ctx, SaleIssueBillInfo motherInfo, SaleIssueBillInfo childInfo) throws BOSException, EASBizException {
        ctx.put((Object)"SPLIT_ACTION", (Object)Boolean.TRUE);
        ISaleIssueBill saleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        this.checkBeforeSaveInfo(motherInfo);
        saleIssueBill.update((IObjectPK)new ObjectUuidPK(motherInfo.getId()), (CoreBaseInfo)motherInfo);
        this.checkBeforeSaveInfo(childInfo);
        saleIssueBill.addnew((CoreBaseInfo)childInfo);
    }

    private void splitEntryInfoBySplitQty(Context ctx, SaleIssueBillInfo motherInfo, SaleIssueBillInfo childInfo, Map entryId2SplitQtyMap, Map moveBotpRealtionMap, Map addBotpRelationMap) throws BOSException, EASBizException {
        SaleIssueEntryCollection motherEntryCol = motherInfo.getEntry();
        SaleIssueEntryInfo entryInfo = null;
        String entryId = "";
        SaleIssueEntryInfo subEntryInfo = null;
        BigDecimal splitQty = SysConstant.BIGZERO;
        int subEntrySeqIndex = 0;
        HashMap<String, String> relationMap = new HashMap<String, String>();
        String childBillID = "";
        String childNumber = "";
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"submitSplitBillByHand", (BOSObjectType)BOSObjectType.create((String)motherInfo.getBOSType().toString()), (IObjectPK)new ObjectUuidPK(motherInfo.getId().toString()), (String)motherInfo.getNumber(), (String)"im_purInWarehs_splitBill", (String)childInfo.getStorageOrgUnit().getId().toString());
        childInfo.setId(BOSUuid.create((BOSObjectType)childInfo.getBOSType()));
        childBillID = childInfo.getId().toString();
        childNumber = this.getExBilltNumber(ctx, motherInfo.getNumber());
        IRelationOfChildAndParentFacade iRelationOfChildAndParentFacade = RelationOfChildAndParentFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("motherId", motherInfo.getId().toString());
        String rootId = null;
        HashMap resultMap = (HashMap)iRelationOfChildAndParentFacade.queryInfoByMap(map);
        if (resultMap.get("FRootID") != null) {
            rootId = (String)resultMap.get("FRootID");
        } else {
            rootId = motherInfo.getId().toString();
            this.insertRootSplitRelation(ctx, motherInfo);
        }
        for (int i = motherEntryCol.size() - 1; i >= 0; --i) {
            entryInfo = motherEntryCol.get(i);
            entryId = entryInfo.getId().toString();
            splitQty = (BigDecimal)entryId2SplitQtyMap.get(entryId);
            if (splitQty.compareTo(SysConstant.BIGZERO) == 0) {
                motherEntryCol.remove(entryInfo);
                moveBotpRealtionMap.put(entryId, new Integer(subEntrySeqIndex));
                String id = entryInfo.getId().toString();
                entryInfo.setId(BOSUuid.create((String)"BBC07FBE"));
                entryInfo.setSeq(++subEntrySeqIndex);
                if (childInfo.getSourceBillType() == null && "d8e80652-0110-1000-e000-04c5c0a812202407435C".equals(childInfo.getBizType().getId().toString())) {
                    entryInfo.setSaleOrderNumber(childInfo.getNumber());
                    entryInfo.setSaleOrderEntrySeq(subEntrySeqIndex);
                    entryInfo.setSaleOrderEntry(entryInfo.getId().toString());
                }
                childInfo.getEntry().add(entryInfo);
                StringBuffer sql = new StringBuffer();
                sql.append("update T_IV_MATERIALSERIALNUMBER set fbillentryid = '" + entryInfo.getId().toString() + "',fbillid = '" + childBillID + "',fbillNUMBER = '" + childNumber + "'  where fbillentryid = '" + id + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                relationMap.put(entryId, entryInfo.getId().toString());
                SaleIssueEntryInfo entry = childInfo.getEntry().get(i);
                SaleIssueEntryInfo soureEntry = motherInfo.getEntry().get(i);
                iRelationOfChildAndParentFacade.saleIssueAddChildOrderToParent(motherInfo, (IObjectValue)childInfo, " ", entryInfo.getId().toString(), rootId);
                continue;
            }
            if (splitQty.compareTo(entryInfo.getQty()) == 0) continue;
            addBotpRelationMap.put(entryId, new Integer(subEntrySeqIndex));
            subEntryInfo = (SaleIssueEntryInfo)entryInfo.clone();
            subEntryInfo.setSeq(++subEntrySeqIndex);
            subEntryInfo.setId(BOSUuid.create((String)"BBC07FBE"));
            if (childInfo.getSourceBillType() == null && "d8e80652-0110-1000-e000-04c5c0a812202407435C".equals(childInfo.getBizType().getId().toString())) {
                subEntryInfo.setSaleOrderNumber(childInfo.getNumber());
                subEntryInfo.setSaleOrderEntrySeq(subEntrySeqIndex);
                subEntryInfo.setSaleOrderEntry(subEntryInfo.getId().toString());
            }
            childInfo.getEntry().add(subEntryInfo);
            relationMap.put(entryId, subEntryInfo.getId().toString());
            if (motherInfo.isIsInTax()) {
                this.calEntryInfoBySplitQtyInTax(entryInfo, subEntryInfo, splitQty);
            } else {
                this.calEntryInfoBySplitQtyInNoneTax(entryInfo, subEntryInfo, splitQty);
            }
            iRelationOfChildAndParentFacade.saleIssueAddChildOrderToParent(motherInfo, (IObjectValue)childInfo, entryInfo.getId().toString(), subEntryInfo.getId().toString(), rootId);
        }
        childInfo.put("EntryRelation", relationMap);
        this.handleVIMSplit(motherInfo, childInfo, relationMap);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void handleVIMSplit(SaleIssueBillInfo motherInfo, SaleIssueBillInfo childInfo, Map<String, String> relationMap) {
        for (int i = 0; i < childInfo.getEntry().size(); ++i) {
            childInfo.getEntry().get(i).setUnVmiSettleBaseQty(BigDecimal.ZERO);
            childInfo.getEntry().get(i).setTotalVmiSettleBaseQty(BigDecimal.ZERO);
        }
        for (Map.Entry<String, String> entry : relationMap.entrySet()) {
            String motherKey = entry.getKey();
            String subKey = entry.getValue();
            SaleIssueEntryInfo motherEntry = motherInfo.getEntry().get(BOSUuid.read((String)motherKey));
            SaleIssueEntryInfo subEntry = childInfo.getEntry().get(BOSUuid.read((String)subKey));
            BigDecimal unVmiSettleBaseQty = BigDecimal.ZERO;
            if (motherEntry != null) {
                unVmiSettleBaseQty = motherEntry.getUnVmiSettleBaseQty();
            }
            if (null == unVmiSettleBaseQty) {
                unVmiSettleBaseQty = BigDecimal.ZERO;
            }
            BigDecimal totalVmiSettleBaseQty = BigDecimal.ZERO;
            if (motherEntry != null) {
                totalVmiSettleBaseQty = motherEntry.getTotalVmiSettleBaseQty();
            }
            if (null == totalVmiSettleBaseQty) {
                totalVmiSettleBaseQty = BigDecimal.ZERO;
            }
            BigDecimal motherQty = BigDecimal.ZERO;
            if (motherEntry != null) {
                motherQty = motherEntry.getQty();
            }
            BigDecimal subQty = subEntry.getQty();
            BigDecimal motherUnVmiSettleQty = BigDecimal.ZERO;
            BigDecimal motherVmiSettleQty = BigDecimal.ZERO;
            BigDecimal subUnVmiSettleQty = BigDecimal.ZERO;
            BigDecimal subVmiSettleQty = BigDecimal.ZERO;
            if (totalVmiSettleBaseQty.compareTo(BigDecimal.ZERO) != 0 && unVmiSettleBaseQty.compareTo(BigDecimal.ZERO) != 0) {
                motherVmiSettleQty = totalVmiSettleBaseQty.compareTo(motherQty) > 0 ? motherQty : totalVmiSettleBaseQty;
                subVmiSettleQty = totalVmiSettleBaseQty.subtract(motherVmiSettleQty);
                motherUnVmiSettleQty = motherQty.subtract(motherVmiSettleQty);
                subUnVmiSettleQty = subQty.subtract(subVmiSettleQty);
            } else if (totalVmiSettleBaseQty.compareTo(BigDecimal.ZERO) != 0) {
                motherVmiSettleQty = motherQty;
                subVmiSettleQty = subQty;
            } else {
                motherUnVmiSettleQty = motherQty;
                subUnVmiSettleQty = subQty;
            }
            if (motherEntry != null) {
                motherEntry.setTotalVmiSettleBaseQty(motherVmiSettleQty);
                motherEntry.setUnVmiSettleBaseQty(motherUnVmiSettleQty);
            }
            subEntry.setTotalVmiSettleBaseQty(subVmiSettleQty);
            subEntry.setUnVmiSettleBaseQty(subUnVmiSettleQty);
        }
    }

    private void splitEntryInfoByWriteOffQty(Context ctx, SaleIssueBillInfo motherInfo, SaleIssueBillInfo childInfo, Map moveBotpRealtionMap, Map addBotpRelationMap) throws BOSException, EASBizException {
        SaleIssueEntryCollection motherEntryCol = motherInfo.getEntry();
        SaleIssueEntryInfo entryInfo = null;
        SaleIssueEntryInfo subEntryInfo = null;
        String childBillID = "";
        String childNumber = "";
        childInfo.setId(BOSUuid.create((BOSObjectType)childInfo.getBOSType()));
        childBillID = childInfo.getId().toString();
        childNumber = this.getExBilltNumber(ctx, motherInfo.getNumber());
        int subEntrySeqIndex = 0;
        HashMap<String, String> relationMap = new HashMap<String, String>();
        String motherEntryID = "";
        IRelationOfChildAndParentFacade iRelationOfChildAndParentFacade = RelationOfChildAndParentFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("motherId", motherInfo.getId().toString());
        String rootId = null;
        HashMap resultMap = (HashMap)iRelationOfChildAndParentFacade.queryInfoByMap(map);
        if (resultMap.get("FRootID") != null) {
            rootId = (String)resultMap.get("FRootID");
        } else {
            rootId = motherInfo.getId().toString();
            this.insertRootSplitRelation(ctx, motherInfo);
        }
        for (int i = motherEntryCol.size() - 1; i >= 0; --i) {
            entryInfo = motherEntryCol.get(i);
            motherEntryID = entryInfo.getId().toString();
            if (entryInfo.getUnWriteOffBaseQty().compareTo(SysConstant.BIGZERO) == 0 || entryInfo.getWrittenOffBaseQty().compareTo(entryInfo.getQty()) == 0) continue;
            if (entryInfo.getWrittenOffBaseQty().compareTo(SysConstant.BIGZERO) == 0) {
                motherEntryCol.remove(entryInfo);
                String id = entryInfo.getId().toString();
                entryInfo.setId(BOSUuid.create((String)"BBC07FBE"));
                entryInfo.setSeq(++subEntrySeqIndex);
                if (childInfo.getSourceBillType() == null && "d8e80652-0110-1000-e000-04c5c0a812202407435C".equals(childInfo.getBizType().getId().toString())) {
                    entryInfo.setSaleOrderNumber(childInfo.getNumber());
                    entryInfo.setSaleOrderEntrySeq(subEntrySeqIndex);
                    entryInfo.setSaleOrderEntry(entryInfo.getId().toString());
                }
                entryInfo.setBizDate(childInfo.getBizDate());
                childInfo.getEntry().add(entryInfo);
                relationMap.put(motherEntryID, entryInfo.getId().toString());
                StringBuffer sql = new StringBuffer();
                sql.append("update T_IV_MATERIALSERIALNUMBER set fbillentryid = '" + entryInfo.getId().toString() + "',fbillid = '" + childBillID + "',fbillNUMBER = '" + childNumber + "'  where fbillentryid = '" + id + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                SaleIssueEntryInfo entry = childInfo.getEntry().get(i);
                SaleIssueEntryInfo soureEntry = motherInfo.getEntry().get(i);
                iRelationOfChildAndParentFacade.saleIssueAddChildOrderToParent(motherInfo, (IObjectValue)childInfo, " ", entryInfo.getId().toString(), rootId);
                continue;
            }
            subEntryInfo = (SaleIssueEntryInfo)entryInfo.clone();
            subEntryInfo.setSeq(++subEntrySeqIndex);
            subEntryInfo.setId(BOSUuid.create((String)"BBC07FBE"));
            if (childInfo.getSourceBillType() == null && "d8e80652-0110-1000-e000-04c5c0a812202407435C".equals(childInfo.getBizType().getId().toString())) {
                subEntryInfo.setSaleOrderNumber(childInfo.getNumber());
                subEntryInfo.setSaleOrderEntrySeq(subEntrySeqIndex);
                subEntryInfo.setSaleOrderEntry(subEntryInfo.getId().toString());
            }
            subEntryInfo.setBizDate(childInfo.getBizDate());
            childInfo.getEntry().add(subEntryInfo);
            relationMap.put(motherEntryID, subEntryInfo.getId().toString());
            if (motherInfo.isIsInTax()) {
                this.calEntryInfoByWriteOffQtyInTax(entryInfo, subEntryInfo);
            } else {
                this.calEntryInfoByWriteOffQtyInNoneTax(entryInfo, subEntryInfo);
            }
            iRelationOfChildAndParentFacade.saleIssueAddChildOrderToParent(motherInfo, (IObjectValue)childInfo, entryInfo.getId().toString(), subEntryInfo.getId().toString(), rootId);
        }
        childInfo.put("EntryRelation", relationMap);
    }

    private void calEntryInfoByWriteOffQtyInNoneTax(SaleIssueEntryInfo entryInfo, SaleIssueEntryInfo subEntryInfo) {
        SaleIssueEntryInfo originalEntryInfo = (SaleIssueEntryInfo)entryInfo.clone();
        entryInfo.setQty(originalEntryInfo.getWrittenOffQty());
        subEntryInfo.setQty(originalEntryInfo.getUnWriteOffQty());
        BigDecimal rate = entryInfo.getQty().divide(originalEntryInfo.getQty(), 10, 5);
        entryInfo.setBaseQty(originalEntryInfo.getWrittenOffBaseQty());
        subEntryInfo.setBaseQty(originalEntryInfo.getUnWriteOffBaseQty());
        entryInfo.setUnitActualCost(originalEntryInfo.getUnitActualCost());
        subEntryInfo.setUnitActualCost(originalEntryInfo.getUnitActualCost());
        entryInfo.setActualCost(originalEntryInfo.getWrittenOffAmount());
        subEntryInfo.setActualCost(originalEntryInfo.getActualCost().subtract(entryInfo.getActualCost()));
        entryInfo.setUnitStandardCost(originalEntryInfo.getUnitStandardCost());
        subEntryInfo.setUnitStandardCost(originalEntryInfo.getUnitStandardCost());
        BigDecimal temp = rate.multiply(originalEntryInfo.getStandardCost());
        temp = temp.setScale(this.getCostPrecision(), 5);
        entryInfo.setStandardCost(temp);
        subEntryInfo.setStandardCost(originalEntryInfo.getStandardCost().subtract(temp));
        entryInfo.setWrittenOffQty(originalEntryInfo.getWrittenOffQty());
        subEntryInfo.setWrittenOffQty(SysConstant.BIGZERO);
        entryInfo.setWrittenOffBaseQty(originalEntryInfo.getWrittenOffBaseQty());
        subEntryInfo.setWrittenOffBaseQty(SysConstant.BIGZERO);
        entryInfo.setWrittenOffAmount(originalEntryInfo.getWrittenOffAmount());
        subEntryInfo.setWrittenOffAmount(SysConstant.BIGZERO);
        entryInfo.setUnWriteOffQty(SysConstant.BIGZERO);
        subEntryInfo.setUnWriteOffQty(subEntryInfo.getQty());
        entryInfo.setUnWriteOffBaseQty(SysConstant.BIGZERO);
        subEntryInfo.setUnWriteOffBaseQty(subEntryInfo.getBaseQty());
        entryInfo.setUnWriteOffAmount(SysConstant.BIGZERO);
        subEntryInfo.setUnWriteOffAmount(subEntryInfo.getActualCost());
        if (originalEntryInfo.getAssistQty() == null) {
            entryInfo.setAssistQty(SysConstant.BIGZERO);
            subEntryInfo.setAssistQty(SysConstant.BIGZERO);
        } else {
            temp = rate.multiply(originalEntryInfo.getAssistQty());
            temp = temp.setScale(entryInfo.getAssistQty().scale(), 5);
            entryInfo.setAssistQty(temp);
            subEntryInfo.setAssistQty(originalEntryInfo.getAssistQty().subtract(temp));
        }
        entryInfo.setTaxRate(originalEntryInfo.getTaxRate());
        subEntryInfo.setTaxRate(originalEntryInfo.getTaxRate());
        entryInfo.setSalePrice(originalEntryInfo.getSalePrice());
        subEntryInfo.setSalePrice(originalEntryInfo.getSalePrice());
        entryInfo.setDiscountType(originalEntryInfo.getDiscountType());
        subEntryInfo.setDiscountType(originalEntryInfo.getDiscountType());
        entryInfo.setDiscount(originalEntryInfo.getDiscount());
        subEntryInfo.setDiscount(originalEntryInfo.getDiscount());
        entryInfo.setActualPrice(originalEntryInfo.getActualPrice());
        subEntryInfo.setActualPrice(originalEntryInfo.getActualPrice());
        entryInfo.setTaxPrice(originalEntryInfo.getTaxPrice());
        subEntryInfo.setTaxPrice(originalEntryInfo.getTaxPrice());
        entryInfo.setPrice(originalEntryInfo.getPrice());
        subEntryInfo.setPrice(originalEntryInfo.getPrice());
        temp = rate.multiply(originalEntryInfo.getDiscountAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 5);
        entryInfo.setDiscountAmount(temp);
        subEntryInfo.setDiscountAmount(originalEntryInfo.getDiscountAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getNonTaxAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 5);
        entryInfo.setNonTaxAmount(temp);
        subEntryInfo.setNonTaxAmount(originalEntryInfo.getNonTaxAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalNonTaxAmount());
        temp = temp.setScale(this.getCostPrecision(), 5);
        entryInfo.setLocalNonTaxAmount(temp);
        subEntryInfo.setLocalNonTaxAmount(originalEntryInfo.getLocalNonTaxAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getTax());
        temp = temp.setScale(this.getMoneyPrecision(), 5);
        entryInfo.setTax(temp);
        subEntryInfo.setTax(originalEntryInfo.getTax().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalTax());
        temp = temp.setScale(this.getCostPrecision(), 5);
        entryInfo.setLocalTax(temp);
        subEntryInfo.setLocalTax(originalEntryInfo.getLocalTax().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 5);
        entryInfo.setAmount(temp);
        subEntryInfo.setAmount(originalEntryInfo.getAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalAmount());
        temp = temp.setScale(this.getCostPrecision(), 5);
        entryInfo.setLocalAmount(temp);
        subEntryInfo.setLocalAmount(originalEntryInfo.getLocalAmount().subtract(temp));
        entryInfo.setDrewQty(originalEntryInfo.getDrewQty());
        subEntryInfo.setDrewQty(SysConstant.BIGZERO);
        entryInfo.setTotalIncomeConfirmQty(originalEntryInfo.getTotalIncomeConfirmQty());
        entryInfo.setTotalIncomeConfirmBaseQty(originalEntryInfo.getTotalIncomeConfirmBaseQty());
        subEntryInfo.setTotalIncomeConfirmQty(SysConstant.BIGZERO);
        subEntryInfo.setTotalIncomeConfirmBaseQty(SysConstant.BIGZERO);
        if (originalEntryInfo.getUnReturnedBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnReturnedBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnReturnedBaseQty(originalEntryInfo.getUnReturnedBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnReturnedBaseQty(originalEntryInfo.getUnReturnedBaseQty());
            entryInfo.setUnReturnedBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReturnsQty().abs().compareTo(entryInfo.getQty().abs()) > 0) {
            entryInfo.setReturnsQty(entryInfo.getQty());
            subEntryInfo.setReturnsQty(originalEntryInfo.getReturnsQty().subtract(entryInfo.getReturnsQty()));
        } else {
            entryInfo.setReturnsQty(originalEntryInfo.getReturnsQty());
            subEntryInfo.setReturnsQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReturnBaseQty().abs().compareTo(entryInfo.getBaseQty().abs()) > 0) {
            entryInfo.setReturnBaseQty(entryInfo.getBaseQty());
            subEntryInfo.setReturnBaseQty(originalEntryInfo.getReturnBaseQty().subtract(entryInfo.getReturnBaseQty()));
        } else {
            entryInfo.setReturnBaseQty(originalEntryInfo.getReturnBaseQty());
            subEntryInfo.setReturnBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnInQty().abs().compareTo(subEntryInfo.getQty().abs()) > 0) {
            subEntryInfo.setUnInQty(subEntryInfo.getQty());
            entryInfo.setUnInQty(originalEntryInfo.getUnInQty().subtract(subEntryInfo.getQty()));
        } else {
            subEntryInfo.setUnInQty(originalEntryInfo.getUnInQty());
            entryInfo.setUnInQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnInBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnInBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnInBaseQty(originalEntryInfo.getUnInBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnInBaseQty(originalEntryInfo.getUnInBaseQty());
            entryInfo.setUnInBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReverseQty().abs().compareTo(entryInfo.getQty().abs()) <= 0) {
            entryInfo.setReverseQty(originalEntryInfo.getReverseQty());
            subEntryInfo.setReverseQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setReverseQty(entryInfo.getQty());
            subEntryInfo.setReverseQty(originalEntryInfo.getReverseQty().subtract(entryInfo.getReverseQty()));
        }
        if (originalEntryInfo.getReverseBaseQty().abs().compareTo(entryInfo.getBaseQty().abs()) <= 0) {
            entryInfo.setReverseBaseQty(originalEntryInfo.getReverseBaseQty());
            subEntryInfo.setReverseBaseQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setReverseBaseQty(entryInfo.getBaseQty());
            subEntryInfo.setReverseBaseQty(originalEntryInfo.getReverseBaseQty().subtract(entryInfo.getReverseBaseQty()));
        }
        if (originalEntryInfo.getWrittenOffQty().abs().compareTo(originalEntryInfo.getTotalInWarehsQty().abs()) >= 0) {
            entryInfo.setTotalInWarehsQty(originalEntryInfo.getTotalInWarehsQty());
            subEntryInfo.setTotalInWarehsQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setTotalInWarehsQty(originalEntryInfo.getWrittenOffQty());
            subEntryInfo.setTotalInWarehsQty(originalEntryInfo.getTotalInWarehsQty().subtract(originalEntryInfo.getWrittenOffQty()));
        }
        entryInfo.setAssociateQty(SysConstant.BIGZERO);
        subEntryInfo.setAssociateQty(subEntryInfo.getQty());
        entryInfo.setAssociateBaseQty(SysConstant.BIGZERO);
        subEntryInfo.setAssociateBaseQty(subEntryInfo.getBaseQty());
        if (originalEntryInfo.getUnSettleQty().abs().compareTo(subEntryInfo.getQty().abs()) > 0) {
            subEntryInfo.setUnSettleQty(subEntryInfo.getQty());
            entryInfo.setUnSettleQty(originalEntryInfo.getUnSettleQty().subtract(subEntryInfo.getQty()));
        } else {
            subEntryInfo.setUnSettleQty(originalEntryInfo.getUnSettleQty());
            entryInfo.setUnSettleQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnSettleBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnSettleBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnSettleBaseQty(originalEntryInfo.getUnSettleBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnSettleBaseQty(originalEntryInfo.getUnSettleBaseQty());
            entryInfo.setUnSettleBaseQty(SysConstant.BIGZERO);
        }
    }

    private void calEntryInfoByWriteOffQtyInTax(SaleIssueEntryInfo entryInfo, SaleIssueEntryInfo subEntryInfo) {
        SaleIssueEntryInfo originalEntryInfo = (SaleIssueEntryInfo)entryInfo.clone();
        entryInfo.setQty(originalEntryInfo.getWrittenOffQty());
        subEntryInfo.setQty(originalEntryInfo.getUnWriteOffQty());
        BigDecimal rate = entryInfo.getQty().divide(originalEntryInfo.getQty(), 10, 5);
        String materialInfoId = entryInfo.getMaterial().getId().toString();
        entryInfo.setBaseQty(originalEntryInfo.getWrittenOffBaseQty());
        subEntryInfo.setBaseQty(originalEntryInfo.getUnWriteOffBaseQty());
        entryInfo.setUnitActualCost(originalEntryInfo.getUnitActualCost());
        subEntryInfo.setUnitActualCost(originalEntryInfo.getUnitActualCost());
        entryInfo.setActualCost(originalEntryInfo.getWrittenOffAmount());
        subEntryInfo.setActualCost(originalEntryInfo.getActualCost().subtract(entryInfo.getActualCost()));
        entryInfo.setUnitStandardCost(originalEntryInfo.getUnitStandardCost());
        subEntryInfo.setUnitStandardCost(originalEntryInfo.getUnitStandardCost());
        BigDecimal temp = rate.multiply(originalEntryInfo.getStandardCost());
        temp = temp.setScale(this.getCostPrecision(), 5);
        entryInfo.setStandardCost(temp);
        subEntryInfo.setStandardCost(originalEntryInfo.getStandardCost().subtract(temp));
        entryInfo.setWrittenOffQty(originalEntryInfo.getWrittenOffQty());
        subEntryInfo.setWrittenOffQty(SysConstant.BIGZERO);
        entryInfo.setWrittenOffBaseQty(originalEntryInfo.getWrittenOffBaseQty());
        subEntryInfo.setWrittenOffBaseQty(SysConstant.BIGZERO);
        entryInfo.setWrittenOffAmount(originalEntryInfo.getWrittenOffAmount());
        subEntryInfo.setWrittenOffAmount(SysConstant.BIGZERO);
        entryInfo.setUnWriteOffQty(SysConstant.BIGZERO);
        subEntryInfo.setUnWriteOffQty(originalEntryInfo.getUnWriteOffQty());
        entryInfo.setUnWriteOffBaseQty(SysConstant.BIGZERO);
        subEntryInfo.setUnWriteOffBaseQty(originalEntryInfo.getUnWriteOffBaseQty());
        entryInfo.setUnWriteOffAmount(SysConstant.BIGZERO);
        subEntryInfo.setUnWriteOffAmount(originalEntryInfo.getUnWriteOffAmount());
        if (originalEntryInfo.getAssistQty() == null) {
            entryInfo.setAssistQty(SysConstant.BIGZERO);
            subEntryInfo.setAssistQty(SysConstant.BIGZERO);
        } else {
            temp = rate.multiply(originalEntryInfo.getAssistQty());
            temp = temp.setScale(entryInfo.getAssistQty().scale(), 5);
            entryInfo.setAssistQty(temp);
            subEntryInfo.setAssistQty(originalEntryInfo.getAssistQty().subtract(temp));
        }
        entryInfo.setTaxRate(originalEntryInfo.getTaxRate());
        subEntryInfo.setTaxRate(originalEntryInfo.getTaxRate());
        entryInfo.setTaxPrice(originalEntryInfo.getTaxPrice());
        subEntryInfo.setTaxPrice(originalEntryInfo.getTaxPrice());
        entryInfo.setSalePrice(originalEntryInfo.getSalePrice());
        BigDecimal taxrate = subEntryInfo.getTaxRate().divide(new BigDecimal("100.0"), 10, 4);
        temp = subEntryInfo.getTaxPrice().divide(taxrate.add(new BigDecimal("1.0")), this.getPricePrecision(materialInfoId), 4);
        subEntryInfo.setSalePrice(temp);
        entryInfo.setDiscountType(originalEntryInfo.getDiscountType());
        subEntryInfo.setDiscountType(originalEntryInfo.getDiscountType());
        entryInfo.setDiscount(originalEntryInfo.getDiscount());
        subEntryInfo.setDiscount(originalEntryInfo.getDiscount());
        temp = rate.multiply(originalEntryInfo.getDiscountAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 5);
        entryInfo.setDiscountAmount(temp);
        subEntryInfo.setDiscountAmount(originalEntryInfo.getDiscountAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getNonTaxAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 5);
        entryInfo.setNonTaxAmount(temp);
        subEntryInfo.setNonTaxAmount(originalEntryInfo.getNonTaxAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalNonTaxAmount());
        temp = temp.setScale(this.getCostPrecision(), 5);
        entryInfo.setLocalNonTaxAmount(temp);
        subEntryInfo.setLocalNonTaxAmount(originalEntryInfo.getLocalNonTaxAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getTax());
        temp = temp.setScale(this.getMoneyPrecision(), 5);
        entryInfo.setTax(temp);
        subEntryInfo.setTax(originalEntryInfo.getTax().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalTax());
        temp = temp.setScale(this.getCostPrecision(), 5);
        entryInfo.setLocalTax(temp);
        subEntryInfo.setLocalTax(originalEntryInfo.getLocalTax().subtract(temp));
        entryInfo.setAmount(entryInfo.getNonTaxAmount().add(entryInfo.getTax()));
        subEntryInfo.setAmount(originalEntryInfo.getAmount().subtract(entryInfo.getAmount()));
        entryInfo.setLocalAmount(entryInfo.getLocalNonTaxAmount().add(entryInfo.getLocalTax()));
        subEntryInfo.setLocalAmount(originalEntryInfo.getLocalAmount().subtract(entryInfo.getLocalAmount()));
        entryInfo.setDrewQty(originalEntryInfo.getDrewQty());
        subEntryInfo.setDrewQty(SysConstant.BIGZERO);
        entryInfo.setTotalIncomeConfirmQty(originalEntryInfo.getTotalIncomeConfirmQty());
        entryInfo.setTotalIncomeConfirmBaseQty(originalEntryInfo.getTotalIncomeConfirmBaseQty());
        subEntryInfo.setTotalIncomeConfirmQty(SysConstant.BIGZERO);
        subEntryInfo.setTotalIncomeConfirmBaseQty(SysConstant.BIGZERO);
        if (originalEntryInfo.getUnReturnedBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnReturnedBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnReturnedBaseQty(originalEntryInfo.getUnReturnedBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnReturnedBaseQty(originalEntryInfo.getUnReturnedBaseQty());
            entryInfo.setUnReturnedBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReturnsQty().abs().compareTo(entryInfo.getQty().abs()) > 0) {
            entryInfo.setReturnsQty(entryInfo.getQty());
            subEntryInfo.setReturnsQty(originalEntryInfo.getReturnsQty().subtract(entryInfo.getReturnsQty()));
        } else {
            entryInfo.setReturnsQty(originalEntryInfo.getReturnsQty());
            subEntryInfo.setReturnsQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReturnBaseQty().abs().compareTo(entryInfo.getBaseQty().abs()) > 0) {
            entryInfo.setReturnBaseQty(entryInfo.getBaseQty());
            subEntryInfo.setReturnBaseQty(originalEntryInfo.getReturnBaseQty().subtract(entryInfo.getReturnBaseQty()));
        } else {
            entryInfo.setReturnBaseQty(originalEntryInfo.getReturnBaseQty());
            subEntryInfo.setReturnBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnInQty().abs().compareTo(subEntryInfo.getQty().abs()) > 0) {
            subEntryInfo.setUnInQty(subEntryInfo.getQty());
            entryInfo.setUnInQty(originalEntryInfo.getUnInQty().subtract(subEntryInfo.getQty()));
        } else {
            subEntryInfo.setUnInQty(originalEntryInfo.getUnInQty());
            entryInfo.setUnInQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnInBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnInBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnInBaseQty(originalEntryInfo.getUnInBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnInBaseQty(originalEntryInfo.getUnInBaseQty());
            entryInfo.setUnInBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReverseQty().abs().compareTo(entryInfo.getQty().abs()) <= 0) {
            entryInfo.setReverseQty(originalEntryInfo.getReverseQty());
            subEntryInfo.setReverseQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setReverseQty(entryInfo.getQty());
            subEntryInfo.setReverseQty(originalEntryInfo.getReverseQty().subtract(entryInfo.getReverseQty()));
        }
        if (originalEntryInfo.getReverseBaseQty().abs().compareTo(entryInfo.getBaseQty().abs()) <= 0) {
            entryInfo.setReverseBaseQty(originalEntryInfo.getReverseBaseQty());
            subEntryInfo.setReverseBaseQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setReverseBaseQty(entryInfo.getBaseQty());
            subEntryInfo.setReverseBaseQty(originalEntryInfo.getReverseBaseQty().subtract(entryInfo.getReverseBaseQty()));
        }
        if (originalEntryInfo.getWrittenOffQty().abs().compareTo(originalEntryInfo.getTotalInWarehsQty().abs()) >= 0) {
            entryInfo.setTotalInWarehsQty(originalEntryInfo.getTotalInWarehsQty());
            subEntryInfo.setTotalInWarehsQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setTotalInWarehsQty(originalEntryInfo.getWrittenOffQty());
            subEntryInfo.setTotalInWarehsQty(originalEntryInfo.getTotalInWarehsQty().subtract(originalEntryInfo.getWrittenOffQty()));
        }
        entryInfo.setActualPrice(originalEntryInfo.getActualPrice());
        entryInfo.setPrice(originalEntryInfo.getPrice());
        if (null != subEntryInfo.getDiscount() && subEntryInfo.getDiscount().compareTo(SysConstant.BIGZERO) == 0) {
            subEntryInfo.setActualPrice(subEntryInfo.getSalePrice());
            subEntryInfo.setPrice(originalEntryInfo.getPrice());
        } else {
            temp = subEntryInfo.getNonTaxAmount().divide(subEntryInfo.getQty(), this.getPricePrecision(materialInfoId), 4);
            subEntryInfo.setActualPrice(temp);
            temp = subEntryInfo.getAmount().divide(subEntryInfo.getQty(), this.getPricePrecision(materialInfoId), 4);
            subEntryInfo.setPrice(temp);
        }
        entryInfo.setAssociateQty(SysConstant.BIGZERO);
        subEntryInfo.setAssociateQty(subEntryInfo.getQty());
        entryInfo.setAssociateBaseQty(SysConstant.BIGZERO);
        subEntryInfo.setAssociateBaseQty(subEntryInfo.getBaseQty());
        if (originalEntryInfo.getUnSettleQty().abs().compareTo(subEntryInfo.getQty().abs()) > 0) {
            subEntryInfo.setUnSettleQty(subEntryInfo.getQty());
            entryInfo.setUnSettleQty(originalEntryInfo.getUnSettleQty().subtract(subEntryInfo.getQty()));
        } else {
            subEntryInfo.setUnSettleQty(originalEntryInfo.getUnSettleQty());
            entryInfo.setUnSettleQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnSettleBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnSettleBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnSettleBaseQty(originalEntryInfo.getUnSettleBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnSettleBaseQty(originalEntryInfo.getUnSettleBaseQty());
            entryInfo.setUnSettleBaseQty(SysConstant.BIGZERO);
        }
    }

    private void calEntryInfoBySplitQtyInTax(SaleIssueEntryInfo entryInfo, SaleIssueEntryInfo subEntryInfo, BigDecimal splitQty) {
        SaleIssueEntryInfo originalEntryInfo = (SaleIssueEntryInfo)entryInfo.clone();
        entryInfo.setQty(splitQty);
        subEntryInfo.setQty(originalEntryInfo.getQty().subtract(splitQty));
        BigDecimal rate = entryInfo.getQty().divide(originalEntryInfo.getQty(), 10, 4);
        String materialInfoId = entryInfo.getMaterial().getId().toString();
        int baseQtyPrecision = this.getQtyPrecision(materialInfoId, entryInfo.getBaseUnit().getId().toString());
        BigDecimal baseConvsRate = this.getBaseConvsrate(materialInfoId, entryInfo.getUnit().getId().toString());
        BigDecimal temp = entryInfo.getQty().multiply(baseConvsRate).setScale(baseQtyPrecision, 4);
        entryInfo.setBaseQty(temp);
        subEntryInfo.setBaseQty(originalEntryInfo.getBaseQty().subtract(temp));
        entryInfo.setUnitActualCost(originalEntryInfo.getUnitActualCost());
        subEntryInfo.setUnitActualCost(originalEntryInfo.getUnitActualCost());
        temp = rate.multiply(originalEntryInfo.getActualCost());
        temp = temp.setScale(this.getCostPrecision(), 4);
        entryInfo.setActualCost(temp);
        subEntryInfo.setActualCost(originalEntryInfo.getActualCost().subtract(temp));
        entryInfo.setUnitStandardCost(originalEntryInfo.getUnitStandardCost());
        subEntryInfo.setUnitStandardCost(originalEntryInfo.getUnitStandardCost());
        temp = rate.multiply(originalEntryInfo.getStandardCost());
        temp = temp.setScale(this.getCostPrecision(), 4);
        entryInfo.setStandardCost(temp);
        subEntryInfo.setStandardCost(originalEntryInfo.getStandardCost().subtract(temp));
        entryInfo.setWrittenOffQty(SysConstant.BIGZERO);
        subEntryInfo.setWrittenOffQty(SysConstant.BIGZERO);
        entryInfo.setWrittenOffBaseQty(SysConstant.BIGZERO);
        subEntryInfo.setWrittenOffBaseQty(SysConstant.BIGZERO);
        entryInfo.setWrittenOffAmount(SysConstant.BIGZERO);
        subEntryInfo.setWrittenOffAmount(SysConstant.BIGZERO);
        entryInfo.setUnWriteOffQty(entryInfo.getQty());
        subEntryInfo.setUnWriteOffQty(subEntryInfo.getQty());
        entryInfo.setUnWriteOffBaseQty(entryInfo.getBaseQty());
        subEntryInfo.setUnWriteOffBaseQty(subEntryInfo.getBaseQty());
        if (originalEntryInfo.getAssistQty() == null) {
            entryInfo.setAssistQty(SysConstant.BIGZERO);
            subEntryInfo.setAssistQty(SysConstant.BIGZERO);
        } else {
            temp = rate.multiply(entryInfo.getAssistQty());
            temp = temp.setScale(entryInfo.getAssistQty().scale(), 4);
            entryInfo.setAssistQty(temp);
            subEntryInfo.setAssistQty(originalEntryInfo.getAssistQty().subtract(temp));
        }
        entryInfo.setTaxRate(originalEntryInfo.getTaxRate());
        subEntryInfo.setTaxRate(originalEntryInfo.getTaxRate());
        entryInfo.setTaxPrice(originalEntryInfo.getTaxPrice());
        subEntryInfo.setTaxPrice(originalEntryInfo.getTaxPrice());
        entryInfo.setSalePrice(originalEntryInfo.getSalePrice());
        subEntryInfo.setSalePrice(subEntryInfo.getSalePrice());
        entryInfo.setDiscountType(originalEntryInfo.getDiscountType());
        subEntryInfo.setDiscountType(originalEntryInfo.getDiscountType());
        entryInfo.setDiscount(originalEntryInfo.getDiscount());
        subEntryInfo.setDiscount(originalEntryInfo.getDiscount());
        entryInfo.setActualPrice(originalEntryInfo.getActualPrice());
        subEntryInfo.setActualPrice(originalEntryInfo.getActualPrice());
        entryInfo.setPrice(originalEntryInfo.getPrice());
        subEntryInfo.setPrice(originalEntryInfo.getPrice());
        temp = rate.multiply(originalEntryInfo.getDiscountAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 4);
        entryInfo.setDiscountAmount(temp);
        subEntryInfo.setDiscountAmount(originalEntryInfo.getDiscountAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getNonTaxAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 4);
        entryInfo.setNonTaxAmount(temp);
        subEntryInfo.setNonTaxAmount(originalEntryInfo.getNonTaxAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalNonTaxAmount());
        temp = temp.setScale(this.getCostPrecision(), 4);
        entryInfo.setLocalNonTaxAmount(temp);
        subEntryInfo.setLocalNonTaxAmount(originalEntryInfo.getLocalNonTaxAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 4);
        entryInfo.setAmount(temp);
        subEntryInfo.setAmount(originalEntryInfo.getAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalAmount());
        temp = temp.setScale(this.getCostPrecision(), 4);
        entryInfo.setLocalAmount(temp);
        subEntryInfo.setLocalAmount(originalEntryInfo.getLocalAmount().subtract(temp));
        entryInfo.setTax(entryInfo.getAmount().subtract(entryInfo.getNonTaxAmount()));
        subEntryInfo.setTax(subEntryInfo.getAmount().subtract(subEntryInfo.getNonTaxAmount()));
        entryInfo.setLocalTax(entryInfo.getLocalAmount().subtract(entryInfo.getLocalNonTaxAmount()));
        subEntryInfo.setLocalTax(subEntryInfo.getLocalAmount().subtract(subEntryInfo.getLocalNonTaxAmount()));
        entryInfo.setDrewQty(SysConstant.BIGZERO);
        subEntryInfo.setDrewQty(SysConstant.BIGZERO);
        entryInfo.setTotalIncomeConfirmQty(SysConstant.BIGZERO);
        entryInfo.setTotalIncomeConfirmBaseQty(SysConstant.BIGZERO);
        subEntryInfo.setTotalIncomeConfirmQty(SysConstant.BIGZERO);
        subEntryInfo.setTotalIncomeConfirmBaseQty(SysConstant.BIGZERO);
        if (originalEntryInfo.getUnReturnedBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnReturnedBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnReturnedBaseQty(originalEntryInfo.getUnReturnedBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnReturnedBaseQty(originalEntryInfo.getUnReturnedBaseQty());
            entryInfo.setUnReturnedBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReturnsQty().abs().compareTo(entryInfo.getQty().abs()) > 0) {
            entryInfo.setReturnsQty(entryInfo.getQty());
            subEntryInfo.setReturnsQty(originalEntryInfo.getReturnsQty().subtract(entryInfo.getReturnsQty()));
        } else {
            entryInfo.setReturnsQty(originalEntryInfo.getReturnsQty());
            subEntryInfo.setReturnsQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReturnBaseQty().abs().compareTo(entryInfo.getBaseQty().abs()) > 0) {
            entryInfo.setReturnBaseQty(entryInfo.getBaseQty());
            subEntryInfo.setReturnBaseQty(originalEntryInfo.getReturnBaseQty().subtract(entryInfo.getReturnBaseQty()));
        } else {
            entryInfo.setReturnBaseQty(originalEntryInfo.getReturnBaseQty());
            subEntryInfo.setReturnBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnInQty().abs().compareTo(subEntryInfo.getQty().abs()) > 0) {
            subEntryInfo.setUnInQty(subEntryInfo.getQty());
            entryInfo.setUnInQty(originalEntryInfo.getUnInQty().subtract(subEntryInfo.getQty()));
        } else {
            subEntryInfo.setUnInQty(originalEntryInfo.getUnInQty());
            entryInfo.setUnInQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnInBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnInBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnInBaseQty(originalEntryInfo.getUnInBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnInBaseQty(originalEntryInfo.getUnInBaseQty());
            entryInfo.setUnInBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReverseQty().abs().compareTo(entryInfo.getQty().abs()) <= 0) {
            entryInfo.setReverseQty(originalEntryInfo.getReverseQty());
            subEntryInfo.setReverseQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setReverseQty(entryInfo.getQty());
            subEntryInfo.setReverseQty(originalEntryInfo.getReverseQty().subtract(entryInfo.getReverseQty()));
        }
        if (originalEntryInfo.getReverseBaseQty().abs().compareTo(entryInfo.getBaseQty().abs()) <= 0) {
            entryInfo.setReverseBaseQty(originalEntryInfo.getReverseBaseQty());
            subEntryInfo.setReverseBaseQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setReverseBaseQty(entryInfo.getBaseQty());
            subEntryInfo.setReverseBaseQty(originalEntryInfo.getReverseBaseQty().subtract(entryInfo.getReverseBaseQty()));
        }
        if (splitQty.abs().compareTo(originalEntryInfo.getTotalInWarehsQty().abs()) >= 0) {
            entryInfo.setTotalInWarehsQty(originalEntryInfo.getTotalInWarehsQty());
            subEntryInfo.setTotalInWarehsQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setTotalInWarehsQty(splitQty);
            subEntryInfo.setTotalInWarehsQty(originalEntryInfo.getTotalInWarehsQty().subtract(splitQty));
        }
        entryInfo.setUnWriteOffAmount(entryInfo.getActualCost());
        subEntryInfo.setUnWriteOffAmount(subEntryInfo.getActualCost());
        entryInfo.setAssociateQty(entryInfo.getQty());
        subEntryInfo.setAssociateQty(subEntryInfo.getQty());
        entryInfo.setAssociateBaseQty(entryInfo.getBaseQty());
        subEntryInfo.setAssociateBaseQty(subEntryInfo.getBaseQty());
        if (originalEntryInfo.getUnSettleQty().abs().compareTo(subEntryInfo.getQty().abs()) > 0) {
            subEntryInfo.setUnSettleQty(subEntryInfo.getQty());
            entryInfo.setUnSettleQty(originalEntryInfo.getUnSettleQty().subtract(subEntryInfo.getQty()));
        } else {
            subEntryInfo.setUnSettleQty(originalEntryInfo.getUnSettleQty());
            entryInfo.setUnSettleQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnSettleBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnSettleBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnSettleBaseQty(originalEntryInfo.getUnSettleBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnSettleBaseQty(originalEntryInfo.getUnSettleBaseQty());
            entryInfo.setUnSettleBaseQty(SysConstant.BIGZERO);
        }
    }

    private void calEntryInfoBySplitQtyInNoneTax(SaleIssueEntryInfo entryInfo, SaleIssueEntryInfo subEntryInfo, BigDecimal splitQty) {
        SaleIssueEntryInfo originalEntryInfo = (SaleIssueEntryInfo)entryInfo.clone();
        entryInfo.setQty(splitQty);
        subEntryInfo.setQty(originalEntryInfo.getQty().subtract(splitQty));
        BigDecimal rate = entryInfo.getQty().divide(originalEntryInfo.getQty(), 10, 4);
        String materialInfoId = entryInfo.getMaterial().getId().toString();
        int baseQtyPrecision = this.getQtyPrecision(materialInfoId, entryInfo.getBaseUnit().getId().toString());
        BigDecimal baseConvsRate = this.getBaseConvsrate(materialInfoId, entryInfo.getUnit().getId().toString());
        BigDecimal temp = entryInfo.getQty().multiply(baseConvsRate).setScale(baseQtyPrecision, 4);
        entryInfo.setBaseQty(temp);
        subEntryInfo.setBaseQty(originalEntryInfo.getBaseQty().subtract(temp));
        entryInfo.setUnitActualCost(originalEntryInfo.getUnitActualCost());
        subEntryInfo.setUnitActualCost(originalEntryInfo.getUnitActualCost());
        temp = rate.multiply(originalEntryInfo.getActualCost());
        temp = temp.setScale(this.getCostPrecision(), 4);
        entryInfo.setActualCost(temp);
        subEntryInfo.setActualCost(originalEntryInfo.getActualCost().subtract(temp));
        entryInfo.setUnitStandardCost(originalEntryInfo.getUnitStandardCost());
        subEntryInfo.setUnitStandardCost(originalEntryInfo.getUnitStandardCost());
        temp = rate.multiply(originalEntryInfo.getStandardCost());
        temp = temp.setScale(this.getCostPrecision(), 4);
        entryInfo.setStandardCost(temp);
        subEntryInfo.setStandardCost(originalEntryInfo.getStandardCost().subtract(temp));
        entryInfo.setWrittenOffQty(SysConstant.BIGZERO);
        subEntryInfo.setWrittenOffQty(SysConstant.BIGZERO);
        entryInfo.setWrittenOffBaseQty(SysConstant.BIGZERO);
        subEntryInfo.setWrittenOffBaseQty(SysConstant.BIGZERO);
        entryInfo.setWrittenOffAmount(SysConstant.BIGZERO);
        subEntryInfo.setWrittenOffAmount(SysConstant.BIGZERO);
        entryInfo.setUnWriteOffQty(entryInfo.getQty());
        subEntryInfo.setUnWriteOffQty(subEntryInfo.getQty());
        entryInfo.setUnWriteOffBaseQty(entryInfo.getBaseQty());
        subEntryInfo.setUnWriteOffBaseQty(subEntryInfo.getBaseQty());
        entryInfo.setUnWriteOffAmount(entryInfo.getActualCost());
        subEntryInfo.setUnWriteOffAmount(subEntryInfo.getActualCost());
        if (originalEntryInfo.getAssistQty() == null) {
            entryInfo.setAssistQty(SysConstant.BIGZERO);
            subEntryInfo.setAssistQty(SysConstant.BIGZERO);
        } else {
            temp = rate.multiply(originalEntryInfo.getAssistQty());
            temp = temp.setScale(entryInfo.getAssistQty().scale(), 4);
            entryInfo.setAssistQty(temp);
            subEntryInfo.setAssistQty(originalEntryInfo.getAssistQty().subtract(temp));
        }
        entryInfo.setTaxRate(originalEntryInfo.getTaxRate());
        subEntryInfo.setTaxRate(originalEntryInfo.getTaxRate());
        entryInfo.setSalePrice(originalEntryInfo.getSalePrice());
        subEntryInfo.setSalePrice(originalEntryInfo.getSalePrice());
        entryInfo.setDiscountType(originalEntryInfo.getDiscountType());
        subEntryInfo.setDiscountType(originalEntryInfo.getDiscountType());
        entryInfo.setDiscount(originalEntryInfo.getDiscount());
        subEntryInfo.setDiscount(originalEntryInfo.getDiscount());
        entryInfo.setTaxPrice(originalEntryInfo.getTaxPrice());
        subEntryInfo.setTaxPrice(originalEntryInfo.getTaxPrice());
        entryInfo.setActualPrice(originalEntryInfo.getActualPrice());
        subEntryInfo.setActualPrice(originalEntryInfo.getActualPrice());
        entryInfo.setPrice(originalEntryInfo.getPrice());
        subEntryInfo.setPrice(originalEntryInfo.getPrice());
        temp = rate.multiply(originalEntryInfo.getDiscountAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 4);
        entryInfo.setDiscountAmount(temp);
        subEntryInfo.setDiscountAmount(originalEntryInfo.getDiscountAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getNonTaxAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 4);
        entryInfo.setNonTaxAmount(temp);
        subEntryInfo.setNonTaxAmount(originalEntryInfo.getNonTaxAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalNonTaxAmount());
        temp = temp.setScale(this.getCostPrecision(), 4);
        entryInfo.setLocalNonTaxAmount(temp);
        subEntryInfo.setLocalNonTaxAmount(originalEntryInfo.getLocalNonTaxAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getTax());
        temp = temp.setScale(this.getMoneyPrecision(), 4);
        entryInfo.setTax(temp);
        subEntryInfo.setTax(originalEntryInfo.getTax().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalTax());
        temp = temp.setScale(this.getCostPrecision(), 4);
        entryInfo.setLocalTax(temp);
        subEntryInfo.setLocalTax(originalEntryInfo.getLocalTax().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getAmount());
        temp = temp.setScale(this.getMoneyPrecision(), 4);
        entryInfo.setAmount(temp);
        subEntryInfo.setAmount(originalEntryInfo.getAmount().subtract(temp));
        temp = rate.multiply(originalEntryInfo.getLocalAmount());
        temp = temp.setScale(this.getCostPrecision(), 4);
        entryInfo.setLocalAmount(temp);
        subEntryInfo.setLocalAmount(originalEntryInfo.getLocalAmount().subtract(temp));
        entryInfo.setDrewQty(SysConstant.BIGZERO);
        subEntryInfo.setDrewQty(SysConstant.BIGZERO);
        entryInfo.setTotalIncomeConfirmQty(SysConstant.BIGZERO);
        entryInfo.setTotalIncomeConfirmBaseQty(SysConstant.BIGZERO);
        subEntryInfo.setTotalIncomeConfirmQty(SysConstant.BIGZERO);
        subEntryInfo.setTotalIncomeConfirmBaseQty(SysConstant.BIGZERO);
        if (originalEntryInfo.getUnReturnedBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnReturnedBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnReturnedBaseQty(originalEntryInfo.getUnReturnedBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnReturnedBaseQty(originalEntryInfo.getUnReturnedBaseQty());
            entryInfo.setUnReturnedBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReturnsQty().abs().compareTo(entryInfo.getQty().abs()) > 0) {
            entryInfo.setReturnsQty(entryInfo.getQty());
            subEntryInfo.setReturnsQty(originalEntryInfo.getReturnsQty().subtract(entryInfo.getReturnsQty()));
        } else {
            entryInfo.setReturnsQty(originalEntryInfo.getReturnsQty());
            subEntryInfo.setReturnsQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReturnBaseQty().abs().compareTo(entryInfo.getBaseQty().abs()) > 0) {
            entryInfo.setReturnBaseQty(entryInfo.getBaseQty());
            subEntryInfo.setReturnBaseQty(originalEntryInfo.getReturnBaseQty().subtract(entryInfo.getReturnBaseQty()));
        } else {
            entryInfo.setReturnBaseQty(originalEntryInfo.getReturnBaseQty());
            subEntryInfo.setReturnBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnInQty().abs().compareTo(subEntryInfo.getQty().abs()) > 0) {
            subEntryInfo.setUnInQty(subEntryInfo.getQty());
            entryInfo.setUnInQty(originalEntryInfo.getUnInQty().subtract(subEntryInfo.getQty()));
        } else {
            subEntryInfo.setUnInQty(originalEntryInfo.getUnInQty());
            entryInfo.setUnInQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnInBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnInBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnInBaseQty(originalEntryInfo.getUnInBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnInBaseQty(originalEntryInfo.getUnInBaseQty());
            entryInfo.setUnInBaseQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getReverseQty().abs().compareTo(entryInfo.getQty().abs()) <= 0) {
            entryInfo.setReverseQty(originalEntryInfo.getReverseQty());
            subEntryInfo.setReverseQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setReverseQty(entryInfo.getQty());
            subEntryInfo.setReverseQty(originalEntryInfo.getReverseQty().subtract(entryInfo.getReverseQty()));
        }
        if (originalEntryInfo.getReverseBaseQty().abs().compareTo(entryInfo.getBaseQty().abs()) <= 0) {
            entryInfo.setReverseBaseQty(originalEntryInfo.getReverseBaseQty());
            subEntryInfo.setReverseBaseQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setReverseBaseQty(entryInfo.getBaseQty());
            subEntryInfo.setReverseBaseQty(originalEntryInfo.getReverseBaseQty().subtract(entryInfo.getReverseBaseQty()));
        }
        if (splitQty.abs().compareTo(originalEntryInfo.getTotalInWarehsQty().abs()) >= 0) {
            entryInfo.setTotalInWarehsQty(originalEntryInfo.getTotalInWarehsQty());
            subEntryInfo.setTotalInWarehsQty(SysConstant.BIGZERO);
        } else {
            entryInfo.setTotalInWarehsQty(splitQty);
            subEntryInfo.setTotalInWarehsQty(originalEntryInfo.getTotalInWarehsQty().subtract(splitQty));
        }
        entryInfo.setAssociateQty(entryInfo.getQty());
        subEntryInfo.setAssociateQty(subEntryInfo.getQty());
        entryInfo.setAssociateBaseQty(entryInfo.getBaseQty());
        subEntryInfo.setAssociateBaseQty(subEntryInfo.getBaseQty());
        if (originalEntryInfo.getUnSettleQty().abs().compareTo(subEntryInfo.getQty().abs()) > 0) {
            subEntryInfo.setUnSettleQty(subEntryInfo.getQty());
            entryInfo.setUnSettleQty(originalEntryInfo.getUnSettleQty().subtract(subEntryInfo.getQty()));
        } else {
            subEntryInfo.setUnSettleQty(originalEntryInfo.getUnSettleQty());
            entryInfo.setUnSettleQty(SysConstant.BIGZERO);
        }
        if (originalEntryInfo.getUnSettleBaseQty().abs().compareTo(subEntryInfo.getBaseQty().abs()) > 0) {
            subEntryInfo.setUnSettleBaseQty(subEntryInfo.getBaseQty());
            entryInfo.setUnSettleBaseQty(originalEntryInfo.getUnSettleBaseQty().subtract(subEntryInfo.getBaseQty()));
        } else {
            subEntryInfo.setUnSettleBaseQty(originalEntryInfo.getUnSettleBaseQty());
            entryInfo.setUnSettleBaseQty(SysConstant.BIGZERO);
        }
    }

    private void splitBillInfo(Context ctx, SaleIssueBillInfo motherInfo, SaleIssueBillInfo childInfo, Date bizDate) throws BOSException, EASBizException {
        String childNumber = this.getExBilltNumber(ctx, motherInfo.getNumber());
        childInfo.setNumber(childNumber);
        childInfo.setId(null);
        childInfo.getEntry().clear();
        if (null != bizDate) {
            childInfo.setBizDate(bizDate);
            if (bizDate.compareTo(motherInfo.getBizDate()) != 0) {
                int[] period = this.convertBizPeriod(ctx, motherInfo, bizDate);
                SimpleDateFormat df1 = new SimpleDateFormat("yyyyMM");
                SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");
                String str1 = df1.format(bizDate);
                String str2 = df2.format(bizDate);
                childInfo.setYear(period[0]);
                childInfo.setPeriod(period[1]);
                childInfo.setMonth(Integer.parseInt(str1));
                childInfo.setDay(Integer.parseInt(str2));
            }
        }
    }

    @Override
    protected HashMap _split(Context ctx, IObjectValue model, Map entryId2SplitQtyMap, Date bizDate) throws BOSException, EASBizException {
        if (model == null || !(model instanceof SaleIssueBillInfo)) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        if (null == entryId2SplitQtyMap || entryId2SplitQtyMap.size() == 0) {
            throw new SplitBillException(SplitBillException.SPLITQTYERROR);
        }
        HashMap<String, SaleIssueBillInfo> result = new HashMap<String, SaleIssueBillInfo>();
        HashMap moveBotpRealtionMap = new HashMap();
        HashMap addBotpRelationMap = new HashMap();
        SaleIssueBillInfo motherInfo = (SaleIssueBillInfo)model;
        SaleIssueBillInfo childInfo = (SaleIssueBillInfo)motherInfo.clone();
        this.splitBillInfo(ctx, motherInfo, childInfo, bizDate);
        this.initPrecisions(ctx, (SaleIssueBillInfo)model);
        HashSet<String> idSet = new HashSet<String>();
        int size = motherInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            idSet.add(motherInfo.getEntry().get(i).getId().toString());
        }
        Map<String, String> flowMap = InvServerUtils.getBillBizFlowRelation(ctx, idSet, ENTRY_TABLE_NAME);
        this.splitEntryInfoBySplitQty(ctx, motherInfo, childInfo, entryId2SplitQtyMap, moveBotpRealtionMap, addBotpRelationMap);
        this.calBillSumField(motherInfo);
        this.calBillSumField(childInfo);
        ISysBillFacade sysBillFacade = SysBillFacadeFactory.getLocalInstance(ctx);
        ObjectUuidPK motherPk = new ObjectUuidPK(motherInfo.getId().toString());
        ObjectUuidPK childPk = new ObjectUuidPK(childInfo.getId().toString());
        boolean flag = sysBillFacade.delBuildOrderOrReturnBill((IObjectPK)motherPk, motherInfo, false);
        this.saveBillInfo(ctx, motherInfo, childInfo);
        this.spliteInfoEx(ctx, motherInfo, childInfo);
        if (flag) {
            this.cleanSysbillInfo(motherInfo, childInfo);
            sysBillFacade.buildOrderOrReturnBill((IObjectPK)motherPk, motherInfo, true);
            sysBillFacade.buildOrderOrReturnBill((IObjectPK)childPk, childInfo, false);
        }
        this.updateBotp(ctx, motherInfo, childInfo, moveBotpRealtionMap, addBotpRelationMap);
        this.dealChildBillBotp(ctx, childInfo);
        if (childInfo.get("EntryRelation") != null && childInfo.get("EntryRelation") instanceof Map) {
            Map entryRelationMap = (Map)childInfo.get("EntryRelation");
            if (flowMap != null && flowMap.size() > 0 && entryRelationMap != null && entryRelationMap.size() > 0) {
                Iterator it = entryRelationMap.keySet().iterator();
                String key = "";
                HashMap<String, String> clildFlowMap = new HashMap<String, String>();
                while (it.hasNext()) {
                    key = it.next().toString();
                    if (!entryRelationMap.containsKey(key) || !flowMap.containsKey(key)) continue;
                    clildFlowMap.put(((String)entryRelationMap.get(key)).toString(), flowMap.get(key).toString() + "#" + ((String)entryRelationMap.get(key)).toString());
                }
                if (clildFlowMap != null && clildFlowMap.size() > 0) {
                    InvServerUtils.writeBizFlowRelation(ctx, clildFlowMap, ENTRY_TABLE_NAME);
                }
            }
        }
        result.put("motherInfo", motherInfo);
        result.put("childInfo", childInfo);
        return result;
    }

    private void cleanSysbillInfo(SaleIssueBillInfo motherInfo, SaleIssueBillInfo childInfo) {
        int i;
        SaleIssueEntryCollection entries = motherInfo.getEntry();
        SaleIssueEntryInfo entryInfo = null;
        for (i = 0; i < entries.size(); ++i) {
            entryInfo = entries.get(i);
            entryInfo.setSaleOrderNumber(null);
            entryInfo.setSaleOrderEntry(null);
            entryInfo.setSaleOrder(null);
        }
        entries = childInfo.getEntry();
        for (i = 0; i < entries.size(); ++i) {
            entryInfo = entries.get(i);
            entryInfo.setSaleOrderNumber(null);
            entryInfo.setSaleOrderEntry(null);
            entryInfo.setSaleOrder(null);
        }
    }

    private String getExBilltNumber(Context ctx, String oldNumber) throws BOSException {
        String maxNumber;
        int index;
        String newNumber = null;
        String fillNumber = null;
        String subNumber = null;
        int count = 0;
        if ((oldNumber = this.getOldNumber(ctx, oldNumber)) == null || "".equals(oldNumber.trim())) {
            oldNumber = "SaleIssueSplitNumber";
        }
        if ((index = (maxNumber = this.getMaxNumber(ctx, oldNumber)).lastIndexOf("_C")) == -1) {
            newNumber = maxNumber + "_C001";
        } else {
            subNumber = maxNumber.substring(index + 2, maxNumber.length());
            try {
                count = Integer.parseInt(subNumber);
                fillNumber = this.fillSign(String.valueOf(++count), 3, "0");
                newNumber = oldNumber + "_C" + fillNumber;
            }
            catch (NumberFormatException e) {
                newNumber = maxNumber + "_C001";
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return newNumber;
    }

    private void initMoneyPrecisionByBillCurrency(Context ctx, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        this.moneyPrecision = 2;
        if (null == currencyInfo) {
            return;
        }
        if (currencyInfo.getPrecision() > 0) {
            this.moneyPrecision = currencyInfo.getPrecision();
            return;
        }
        ObjectStringPK pk = new ObjectStringPK(currencyInfo.getId().toString());
        SelectorItemCollection selectorItemCol = new SelectorItemCollection();
        selectorItemCol.add(new SelectorItemInfo("precision"));
        selectorItemCol.add(new SelectorItemInfo("id"));
        CurrencyInfo actualObj = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk, selectorItemCol);
        if (null != actualObj) {
            this.moneyPrecision = actualObj.getPrecision();
            return;
        }
    }

    private void initCostPrecisionByCompanyBaseCurrency(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        this.costPrecision = 2;
        if (null == companyInfo) {
            return;
        }
        if (null != companyInfo.getBaseCurrency() && companyInfo.getBaseCurrency().getPrecision() > 0) {
            this.costPrecision = companyInfo.getBaseCurrency().getPrecision();
            return;
        }
        ObjectStringPK pk = new ObjectStringPK(companyInfo.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseCurrency.id"));
        selector.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo actualObj = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk, selector);
        if (null != actualObj && null != actualObj.getBaseCurrency()) {
            this.costPrecision = actualObj.getBaseCurrency().getPrecision();
            return;
        }
    }

    private void initPrecisionByMaterial(Context ctx, Set materialIdSet) throws BOSException {
        this.pricePrecisionMap = new HashMap();
        if (null == materialIdSet || materialIdSet.size() == 0) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)materialIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("pricePrecision"));
        entityViewInfo.setSelector(selector);
        CoreBaseCollection col = MaterialFactory.getLocalInstance((Context)ctx).getCollection(entityViewInfo);
        if (null == col || col.size() == 0) {
            return;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            MaterialInfo materialInfo = (MaterialInfo)col.get(i);
            this.pricePrecisionMap.put(materialInfo.getId().toString(), new Integer(materialInfo.getPricePrecision()));
        }
    }

    @Override
    protected void _split(Context ctx, IObjectPK pk, Map entryId2SplitQtyMap, Date bizDate) throws BOSException, EASBizException {
        if (pk == null) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        SaleIssueBillInfo model = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo(pk);
        this._split(ctx, (IObjectValue)model, entryId2SplitQtyMap, bizDate);
    }

    @Override
    protected HashMap _split(Context ctx, IObjectPK[] pkIDs, Date bizDate) throws BOSException, EASBizException {
        SaleIssueBillInfo model = null;
        this.checkAddClose(ctx, pkIDs, bizDate);
        if (this.saleIssueBillCol.size() == 0) {
            return this.hmCheckMsg;
        }
        HashSet<ObjectStringPK> idSet = new HashSet<ObjectStringPK>();
        int len = this.saleIssueBillCol.size();
        for (int i = 0; i < len; ++i) {
            idSet.add(new ObjectStringPK(this.saleIssueBillCol.get(i).getId().toString()));
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entity.setFilter(filter);
        SaleIssueBillCollection col = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillCollection(entity);
        if (null == col || col.size() == 0) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            model = col.get(i);
            if (model.isIsInitBill() || !this.isBillSplitChangeDate || this.isPastPeriod) {
                bizDate = model.getBizDate();
            }
            if (this.allUnWritedBillSet.contains(model.getId().toString())) {
                this._split(ctx, model, bizDate, true);
                continue;
            }
            this._split(ctx, (IObjectValue)model, bizDate);
        }
        return this.hmCheckMsg;
    }

    protected void split4batch(Context ctx, IObjectValue model, Date bizDate) throws BOSException, EASBizException {
        if (model == null || !(model instanceof SaleIssueBillInfo)) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        HashMap moveBotpRealtionMap = new HashMap();
        HashMap addBotpRelationMap = new HashMap();
        SaleIssueBillInfo motherInfo = (SaleIssueBillInfo)model;
        SaleIssueBillInfo childInfo = (SaleIssueBillInfo)motherInfo.clone();
        this.splitBillInfo(ctx, motherInfo, childInfo, bizDate);
        this.initPrecisions(ctx, (SaleIssueBillInfo)model);
        this.splitEntryInfoByWriteOffQty4Batch(motherInfo, childInfo, moveBotpRealtionMap, addBotpRelationMap);
        if (motherInfo.getEntry().size() == 0 || childInfo.getEntry().size() == 0) {
            return;
        }
        this.calBillSumField(motherInfo);
        this.calBillSumField(childInfo);
        this.saveBillInfo(ctx, motherInfo, childInfo);
        this.updateBotp(ctx, motherInfo, childInfo, moveBotpRealtionMap, addBotpRelationMap);
        this.dealChildBillBotp(ctx, childInfo);
    }

    private void splitEntryInfoByWriteOffQty4Batch(SaleIssueBillInfo motherInfo, SaleIssueBillInfo childInfo, Map moveBotpRealtionMap, Map addBotpRelationMap) {
        SaleIssueEntryCollection motherEntryCol = motherInfo.getEntry();
        int subEntrySeqIndex = 0;
        for (int i = motherEntryCol.size() - 1; i >= 0; --i) {
            SaleIssueEntryInfo entryInfo = motherEntryCol.get(i);
            String materialId = entryInfo.getMaterial().getId().toString();
            String souId = motherInfo.getStorageOrgUnit().getId().toString();
            if (null != this.hmSeqManager.get(souId + materialId) || entryInfo.getUnWriteOffBaseQty().compareTo(SysConstant.BIGZERO) == 0 || entryInfo.getWrittenOffBaseQty().compareTo(SysConstant.BIGZERO) == 0 || entryInfo.getWrittenOffBaseQty().compareTo(entryInfo.getQty()) == 0) continue;
            addBotpRelationMap.put(entryInfo.getId().toString(), new Integer(subEntrySeqIndex));
            SaleIssueEntryInfo subEntryInfo = (SaleIssueEntryInfo)entryInfo.clone();
            subEntryInfo.setSeq(++subEntrySeqIndex);
            subEntryInfo.setId(null);
            subEntryInfo.setBizDate(childInfo.getBizDate());
            childInfo.getEntry().add(subEntryInfo);
            if (motherInfo.isIsInTax()) {
                this.calEntryInfoByWriteOffQtyInTax(entryInfo, subEntryInfo);
                continue;
            }
            this.calEntryInfoByWriteOffQtyInNoneTax(entryInfo, subEntryInfo);
        }
    }

    @Override
    protected void _split(Context ctx, IObjectPK[] pkIDs) throws BOSException, EASBizException {
        SaleIssueBillInfo model = null;
        Date bizDate = null;
        if (null == pkIDs || pkIDs.length == 0) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        int len = pkIDs.length;
        for (int i = 0; i < len; ++i) {
            idSet.add(pkIDs[i]);
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entity.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        selector.add(new SelectorItemInfo("transactionType.bizType.id"));
        entity.setSelector(selector);
        SaleIssueBillCollection col = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillCollection(entity);
        if (null == col || col.size() == 0) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            model = col.get(i);
            if (this.isWriteOffOver(model)) continue;
            try {
                this.checkForSplitBill(ctx, model);
            }
            catch (EASBizException e) {
                continue;
            }
            bizDate = model.isIsInitBill() ? model.getBizDate() : this.getNextPeriodBeginDate(ctx, model);
            this._split(ctx, (IObjectValue)model, bizDate);
        }
    }

    private Date getNextPeriodBeginDate(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws EASBizException, BOSException {
        if (saleIssueBillInfo.isIsInitBill()) {
            return saleIssueBillInfo.getBizDate();
        }
        StorageOrgUnitInfo sou = saleIssueBillInfo.getStorageOrgUnit();
        CompanyOrgUnitInfo cou = null;
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        cou = iSCMBillCommonFacade.getCompanyInfo(sou.getId());
        boolean isChangeDate = this.isSaleIssueBillSplitChangeDate(ctx, sou.getId().toString());
        if (!isChangeDate) {
            return null;
        }
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        PeriodInfo bizPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)saleIssueBillInfo.getBizDate(), (CompanyOrgUnitInfo)cou, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
        boolean ischecked = PeriodUtils.PeriodCompare((PeriodInfo)bizPeriodInfo, (PeriodInfo)currentPeriodInfo);
        if (!ischecked) {
            return null;
        }
        Date bizDate = null;
        PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)bizPeriodInfo);
        bizDate = nextPeriodInfo.isIsAdjustPeriod() ? PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo).getBeginDate() : nextPeriodInfo.getBeginDate();
        return bizDate;
    }

    private boolean isSaleIssueBillSplitChangeDate(Context ctx, String companyInfoID) throws BOSException, EASBizException {
        String per;
        ObjectUuidPK pk;
        boolean isChangeDate = false;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String strChangeDate = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(companyInfoID)), per = "INM100");
        if (strChangeDate != null && strChangeDate.trim().length() != 0 && strChangeDate.trim().equalsIgnoreCase("true")) {
            isChangeDate = true;
        }
        return isChangeDate;
    }

    protected int[] convertBizPeriod(Context ctx, SaleIssueBillInfo info, Date date) throws EASBizException, BOSException {
        if (info.getBizDate() == null) {
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        int[] period = new int[]{2199, 1};
        CompanyOrgUnitInfo company = null;
        if (info.getEntry() != null && info.getEntry().size() > 0) {
            SaleIssueEntryInfo entryInfo = info.getEntry().get(0);
            company = entryInfo.getCompanyOrgUnit();
        }
        if (company != null && company.getId() != null) {
            PeriodInfo pInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, company, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
            if (pInfo != null && pInfo.getPeriodYear() > 0 && pInfo.getPeriodNumber() > 0) {
                period[0] = pInfo.getPeriodYear();
                period[1] = pInfo.getPeriodNumber();
            } else {
                boolean isStartBill = false;
                if (info.isIsInitBill()) {
                    isStartBill = true;
                }
                if (isStartBill) {
                    PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
                    if (currPeriodInfo == null) {
                        throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
                    }
                    int startYear = currPeriodInfo.getPeriodYear();
                    int startNumber = currPeriodInfo.getPeriodNumber();
                    if (startNumber == 1) {
                        startNumber = 12;
                    }
                    period[0] = --startYear;
                    period[1] = --startNumber;
                }
            }
        }
        return period;
    }

    private String getOldNumber(Context ctx, String number) throws BOSException {
        if (null == number || "".equals(number.trim())) {
            return null;
        }
        String oldNumber = null;
        String subNumber = null;
        int index = number.indexOf("_");
        if (index == -1) {
            oldNumber = number;
        } else {
            subNumber = number.substring(0, number.indexOf("_"));
            while (!this.existNumber(ctx, subNumber)) {
                if ((number = number.substring(number.indexOf("_") + 1)).indexOf("_") == -1) {
                    subNumber = subNumber + "_" + number;
                    continue;
                }
                subNumber = subNumber + "_" + number.substring(0, number.indexOf("_"));
            }
            oldNumber = subNumber;
        }
        if (this.existNumber(ctx, oldNumber)) {
            return oldNumber;
        }
        return null;
    }

    private String getMaxNumber(Context ctx, String number) throws BOSException {
        if (this.existNumber(ctx, number)) {
            String sql = "select max(fnumber) as fnumber from T_IM_SaleIssueBill where fnumber like '" + number.trim() + "%'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (null != rowSet && rowSet.next()) {
                    return rowSet.getString("fnumber");
                }
                return null;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return number;
    }

    private boolean existNumber(Context ctx, String number) throws BOSException {
        if (null == number || "".equals(number.trim())) {
            return false;
        }
        String sql = "select fid from T_IM_SaleIssueBill where fnumber ='" + number.trim() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return null != rowSet && rowSet.size() > 0;
    }

    private String fillSign(String str, int totalLength, Object fillSign) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= totalLength || fillSign == null || fillSign.toString().trim().length() == 0) {
            return str;
        }
        StringBuffer sbStr = new StringBuffer();
        StringBuffer sbFill = new StringBuffer();
        sbStr.append(str);
        for (int i = 0; i < totalLength - str.length(); ++i) {
            sbFill.append(fillSign);
        }
        return sbFill.append(sbStr).toString();
    }

    public void spliteInfoEx(Context ctx, SaleIssueBillInfo motherInfo, SaleIssueBillInfo childInfo) {
    }

    public FilterItemCollection getfilterItemColEX() {
        return null;
    }

    private void checkBeforeSaveInfo(SaleIssueBillInfo info) throws EASBizException {
        if (info != null && info.getEntry() != null) {
            SaleIssueEntryCollection entryCollection = info.getEntry();
            int size = entryCollection.size();
            for (int i = 0; i < size; ++i) {
                SaleIssueEntryInfo entryInfo = entryCollection.get(i);
                if (entryInfo.getBaseQty() == null || SCMConstant.BIGDECIMAL_ZERO.compareTo(entryInfo.getBaseQty()) != 0) continue;
                throw new SCMBillException(SCMBillException.SPLIT_BILL_BASE_QTY_ZERO);
            }
        }
    }

    private void insertRootSplitRelation(Context ctx, SaleIssueBillInfo aSaleIssueBillInfo) throws BOSException {
        String rootId = aSaleIssueBillInfo.getId().toString();
        String billNumber = aSaleIssueBillInfo.getNumber();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_IV_RelationOfChildAndParent (FID,FDocumentType,FMotherNumber,FMotherId,FMotherEntryId,FChildNumber,FChildId,FChildEntryId,FIsUnAudit,FRootID) ");
        sql.append(" VALUES ( ?,?,?,?,?,?,?,?,?,?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{BOSUuid.create((String)"88888888").toString(), EASResource.getString((String)RES_InvUI, (String)"SaleIssue"), " ", " ", " ", billNumber, rootId, " ", 0, rootId});
    }

    private Boolean checkIsTotalSaleFeeNotZero(SaleIssueBillInfo saleIssueBillInfo) throws EASBizException {
        Boolean ret = false;
        SaleIssueEntryCollection entry = saleIssueBillInfo.getEntry();
        if (null != entry && entry.size() > 0) {
            for (int i = 0; i < entry.size(); ++i) {
                SaleIssueEntryInfo saleIssueEntryInfo = entry.get(i);
                if (null == saleIssueEntryInfo.getTotalSaleFee() || BigDecimal.ZERO.compareTo(saleIssueEntryInfo.getTotalSaleFee()) == 0) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }
}

